<?php
include ('session.php');
include ('../config.php');
include ('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['menu_site_rule']; ?>
    </title>
    <meta name="description" content="" />
    <?php include ('head.php'); ?>
    <style>
        .cancel-style {
            color: red !important
        }

        input[type="button"]:hover {
            color: #fff !important;

        }

        .cancel-style:hover {
            color: #fff !important
        }

        .swal-button--danger {
            background-color: #2523b3;
            width: 100px;
        }

        .swal-button--cancel {
            color: white;
            width: 100px;
            background-color: #ff3e1d;
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: red;
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #2523b3;
        }

        .swal-footer {
            text-align: center;
        }

        .alert {
            display: none;
        }

        #add_rule_set {
            display: none;
        }

        td {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        td:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }

        #website_list {
            width: 60%;
        }

        @media only screen and (max-width: 600px) {
            #website_list {
                width: 100%;
            }
        }
    </style>
</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include ('sidebar.php'); ?>
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include ('navbar.php'); ?>
                <!-- / Navbar -->
                <!-- Content wrapper <i class="menu-icon tf-icons bx bx-plus"></i> -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="card my-4">
                            <div class="card-header" id="delivery_title">
                                <div class="row">
                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class="h3">
                                            <?php echo $GLOBALS['menu_site_rule']; ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 ">
                                        <select id="website_list" class="form-select text-dark website"
                                            onchange="table_delivery_rule_set('change')">
                                        </select>
                                    </div>
                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <button type="button" class="btn btn-primary" id="back_to_website"
                                            onclick="back_btn()">
                                            <i class="bx bx-arrow-back bg-label-white"></i>
                                            <?php echo $GLOBALS['strback']; ?>
                                        </button>&nbsp;
                                        <button type="button" class="btn btn-primary" id="delete_rule"
                                            onclick="delete_all_rule();"><i class="bx bx-trash" aria-hidden="true"
                                                title="Delete"></i>
                                            <?php echo $GLOBALS['delete']; ?>
                                        </button>&nbsp;
                                        <button class="btn btn-primary" type="button" id="add_rule"
                                            onclick="add_delivery_rule();"><i class="menu-icon tf-icons bx bx-plus"></i>
                                            <?php echo $GLOBALS['add_rule']; ?>
                                        </button>
                                    </div>
                                </div>
                                <hr />
                                <div class="row mt-3">
                                    <p id="warning" class="h6 alert text-black"
                                        style="background: #ffffb3; display:none;"><strong>
                                            <?php echo $GLOBALS['warning']; ?>
                                        </strong>&nbsp;<span id="warning_msg"></span></p>
                                    <p class="alert bg-success alert-dismissible fade show text-white" id="alertdelete">
                                        <i class="fa fa-check-circle"></i> </p>
                                </div>
                            </div>

                            <div class="card-body">
                                <div id="add_rule_set">
                                    <div class="row mb-3 mt-3">
                                        <p
                                            class="h3 col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                            <?php echo $GLOBALS['add_del_rule_set']; ?>
                                        </p>
                                    </div>
                                    <div class="row mb-1">
                                        <div class="col-12">
                                            <p class="alert bg-success alert-dismissible fade show text-white"
                                                id="alertsuccess"><i class="fa fa-check-circle"></i> </p>
                                        </div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['website']; ?><span style="color: red;">*</span>
                                            </label>
                                            <select id="website" class="form-select text-dark mb-2 website" onchange="">

                                            </select>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['strName']; ?><span style="color: red;">*</span>
                                            </label>
                                            <input type="text" name="rule_name" id="rule_name"
                                                class="form-control mb-2 text-dark"
                                                placeholder="<?php echo $GLOBALS['strName']; ?>"
                                                onchange="nameValidation();" onkeyup="nameValidation();" />
                                            <p id="rule_set_error" class="h6 text-danger">
                                                <?php echo $GLOBALS['strName_validation']; ?>
                                            </p>
                                        </div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['strInventory_Description']; ?>
                                            </label>
                                            <input type="text" name="rule_description" id="rule_description"
                                                class="form-control mb-2 text-dark" placeholder="" />
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['strInventory_Comments']; ?>
                                            </label>
                                            <textarea name="rule_comments" id="rule_comments"
                                                class="form-control mb-3 text-dark"></textarea>
                                        </div>
                                    </div>
                                    <div class="row mt-3 mb-3">
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6"></div>
                                        <div
                                            class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-end justify-content-sm-end justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                            <button class="btn btn-outline-danger cancel-style" type="button"
                                                id="cancel" onclick="cancel()">
                                                <?php echo $GLOBALS['strCancel']; ?>
                                            </button>&nbsp;
                                            <button class="btn btn-primary" type="button" id="save_changes"
                                                onclick="save_rule()">
                                                <?php echo $GLOBALS['strSubmit']; ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <div class="table-responsive text-nowrap" id="table">
                                    <table id="delivery_rule_set"
                                        class="table table-striped table-responsive table-hover">
                                        <thead>
                                            <tr class="text-nowrap">
                                                <th class="th-color text-center">
                                                    <input type="checkbox" class="form-check-input check-rule"
                                                        id="select-all">
                                                </th>
                                                <th class="th-color">
                                                    <?php echo $GLOBALS['strName']; ?>
                                                </th>
                                                <th class="th-color">
                                                    <?php echo $GLOBALS['strInventory_Description']; ?>
                                                </th>
                                                <th class="th-color">
                                                    <?php echo $GLOBALS['strInventory_Comments']; ?>
                                                </th>
                                                <th class="th-color">
                                                    <?php echo $GLOBALS['action']; ?>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <?php include ('footer.php'); ?>
            </div>
        </div>
    </div>
    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var affiliate_id = '<?php echo $_GET['affiliateid']; ?>';
        var publisherId = '<?php echo $_SESSION['pub_id']; ?>';
		let getpubId = '<?php echo $_REQUEST['pubid']; ?>';
        var agencyid = '<?php echo $_SESSION['agencyid']; ?>';
        var error = false;
        $(document).ready(function () {
            var webValue = localStorage.getItem("webValue");
            get_websites(affiliate_id, webValue);
            document.getElementById('back_to_website').style.display = (affiliate_id == "") ? "none" : "block";
            $('#add_rule_set').hide();
            document.getElementById('delivery_title').style.display = "block";
            $('#rule_set_error').hide();
            $('#delete_rule').prop('disabled', true);
        });

        function table_delivery_rule_set(change) {
            $('.table-data').remove();
            //location.reload();
            var row = [];
            let affiliateid = $('#website_list').val();
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_targeting_channel/' + affiliateid,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
                success: function (data) {
                    var row = data.data;
                    console.log('data', data);
                    if (data.msg == 'No data found') {
                        $('#delivery_rule_set').DataTable({
                            ordering: false,
                            destroy: true,
                            responsive: true,
                            bPaginate: false,
                            bInfo: false,
                            data: [],
                            searching: false,
                            oLanguage: {
                                sEmptyTable: "<?php echo $GLOBALS['strNo_Data_Meassages']; ?>"
                            }
                        });
                    } else {
                        $('#delivery_rule_set').DataTable({
                            targets: 0,
                            ordering: true,
                            stateSave: true,
                            destroy: true,
                            data: data.data,
                            columns: [{
                                data: 'affiliateid',
                                className: "text-center",
                                orderable: false,
                                render: function (data, type, row, meta) {
                                    return '<input type="checkbox" class="data-checked form-check-input check-rule" value="' + row.channelid + '" data-channel-id="' + row.channelid + '" name="checkrow" id="checkrow"  >';
                                }
                            },
                            {
                                data: 'affiliateid',
                                className: "text-start",
                                render: function (data, type, row, meta) {
                                    return '<a href="delivery_rule_set_edit.php?channelid=' + row.channelid + '&affiliate_id=' + affiliate_id + '">' + row.name + '</a>';
                                }
                            },
                            {
                                data: 'description',
                                className: "text-start",

                                render: function (data, type, row, meta) {
                                    return row.description;
                                }
                            },
                            {
                                data: 'comments',
                                className: "text-start",

                                render: function (data, type, row, meta) {
                                    return row.comments;
                                }
                            },

                            {
                                className: "text-center",
                                orderable: false,
                                render: function (data, type, row, meta) {
                                    return '<a class="btn btn-icon btn-xs btn-primary" href="delivery_rule_set_edit.php?channelid=' + row.channelid + '&affiliate_id=' + affiliate_id + '"><i class="bx bx-edit label-primary" style="font-size:14px" title="<?php echo $GLOBALS['edit']; ?>"></i></a>&nbsp;&nbsp;<a title=<?php echo $GLOBALS['delivery_options']; ?> class="btn btn-icon btn-xs btn-primary" href="delivery_option_pub.php?channelid=' + row.channelid + '&affiliate_id=' + affiliate_id + '"><i class="fas fa-shipping-fast"></i></a>';
                                }
                            },
                            ],
                        });
                    }

                },
                // error: function(jqXHR, textStatus, errorThrown) {
                //     alert('Error: ' + textStatus + ' - ' + errorThrown);
                // }

            });
            if (change) {
                location.reload();
                webValue = $('#website_list').val();
                localStorage.setItem("webValue", webValue);
            }

        }

        function get_websites(id, id2) {
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_website/' + agencyid,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function (data) {
                var websites = [];
                if (!data.data) {
                    $('#website_list').hide();
                    $('#add_rule').attr("disabled", true);
                    $('#warning').show();
                    $('#warning_msg').html("<?php echo $GLOBALS['drs_website_warning']; ?>");
                } else {
                    $('#website_list').show();
                    $('#warning').hide();
                    data.data.map((data) => {
                        getwebLength = (data.name.length > 30) ? (data.name.slice(0, 30) + '...') : data.name;
                        websites += `<option value=${data.affiliateid} title="${data.name}">${getwebLength}</option>`;
                    });
                    $('.website').html(websites);
                    if (id != '') {
                        console.log('hai');
                        $('.website').val(id);
                        $('#website_list').attr('disabled', true);
                        $('#website').attr('disabled', true);
                    } else if (id2 != '' && id2 != null) {
                        $('#website_list option').each(function () {
                            if (this.value == id2) {
                                $('.website').val(id2);
                            }
                        });
                        // $('.website').val(id2);
                        // console.log('1');
                    }
                }
                table_delivery_rule_set();
            });
        }

        function add_delivery_rule() {
            let web_id = $('#website_list').val();
            $('#add_rule_set').show();
            document.getElementById('delivery_title').style.display = "none";

            $('#delete_rule').hide();
            $('#add_rule').hide();
            $('#table').hide();
            $('#rule_set_error').hide();
            $('#rule_name').val('');
        }

        function cancel() {
            $('#delete_rule').show();
            $('#add_rule').show();
            $('#table').show();
            $('#add_rule_set').hide();
            document.getElementById('delivery_title').style.display = "block";
        }

        function nameValidation() {
            error = false;
            var name = $('#rule_name').val();
            if (name == null || name == "") {
                $('#rule_set_error').show();
            } else {
                $('#rule_set_error').hide();
            }
        }

        $("#rule_name").bind("paste", function (e) {
            var pastedData = e.originalEvent.clipboardData.getData('text');
            if (pastedData == null || pastedData == "") {
                $('#rule_set_error').show();
            } else {
                $('#rule_set_error').hide();
            }
        });

        function save_rule() {
            var formdata = [];
            let affiliateid = $('#website').val();
            var name = $('#rule_name').val();
            var description = $('#rule_description').val();
            var comments = $('#rule_comments').val();
            if (name == null || name == "") {
                $('#rule_set_error').show();
                return false;
            } else {
                $('#rule_set_error').hide();
                if (error == false) {
                    var formData = {
                        "affiliateid": affiliateid,
                        "name": name,
                        "description": description,
                        "comments": comments,
                    };
                    $.ajax({
                        type: "POST",
                        url: live_URL + '/add_targeting_channel/' + agencyid,
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        data: formData,
                        dataType: "json",
                        encode: true,
                    }).done(function (data) {
                        if (data.statuscode == 200 && data.msg == "Delivery rule set added successfully") {
                            $("#alertsuccess").show('medium');
                            $("#alertsuccess").html('<?php echo $GLOBALS['del_rule_add_msg']; ?>');
                            setTimeout(function () {
                                $("#alertsuccess").hide('medium');
                            }, 2000);
                            setTimeout(function () {
                                location.reload();
                            }, 1500);
                        } else {
                            $("#alertfailed").show('medium');
                            $("#alertfailed").html('<?php echo $GLOBALS['del_rule_add_fail']; ?>');
                            setTimeout(function () {
                                $("#alertfailed").hide('medium');
                            }, 2000);
                        }

                    });
                }
            }
            webValue = $('#website').val();
            localStorage.setItem("webValue", webValue);
        }

        $("#select-all").click(function () {
            $(".data-checked").prop("checked", this.checked);
            if (($('.data-checked:checked').length) > 0) {
                $('#delete_rule').prop('disabled', false);
            } else {
                $('#delete_rule').prop('disabled', true);
            }
        });

        $(document).on('click', '.data-checked', function () {
            if ($('.data-checked:checked').length == $('.data-checked').length) {
                $('#select-all').prop('checked', true);
            } else {
                $('#select-all').prop('checked', false);
            }
            if (($('.data-checked:checked').length) > 0) {
                $('#delete_rule').prop('disabled', false);
            } else {
                $('#delete_rule').prop('disabled', true);
            }
        });

        function delete_rule(channel) {
            swal({
                title: `<?php echo $GLOBALS['del_rule_delete']; ?>`,
                buttons: {
                    cancel: "Cancel",
                    danger: "Confirm",
                },
                // dangerMode: true,
                // type: "success"
            }).then(function (isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        type: "DELETE",
                        url: live_URL + '/deletechannel/' + channel,
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function (data) {
                        //location.reload();
                        if (data.msg = "Channel Successfully deleted" && data.statuscode == 200) {
                            $("#alertdelete").show('medium');
                            $("#alertdelete").html('<?php echo $GLOBALS['del_rule_delete_succuss']; ?>');
                            setTimeout(function () {
                                $("#alertdelete").hide('medium');
                            }, 1000);
                            setTimeout(function () {
                                location.reload();
                            }, 1000);
                        } else {
                            $("#alertfailed").show('medium');
                            $("#alertfailed").html('data.msg');
                            setTimeout(function () {
                                $("#alertfailed").hide('medium');
                            }, 1000);
                        }
                    });
                }
            });
            //localStorage.clear();
            webValue = $('#website_list').val();
            localStorage.setItem("webValue", webValue);
        }

        function delete_all_rule() {
            var channelData = [];
            var selected = $('.data-checked:checked');
            selected.each(function () {
                channelData.push($(this).attr('data-channel-id'));
            });
            if (channelData.length <= 0) {
                alert("Please select records.");
            } else {
                swal({
                    title: `<?php echo $GLOBALS['del_rule_delete']; ?>`,
                    buttons: {
                        cancel: "Cancel",
                        danger: "Confirm",
                    },
                }).then(function (isConfirm) {
                    if (isConfirm) {
                        $.ajax({
                            type: "DELETE",
                            url: live_URL + '/deletechannel/' + channelData,
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            dataType: "json",
                            encode: true,
                        }).done(function (data) {

                            if (data.msg = "Channel Successfully deleted" && data.statuscode == 200) {
                                $("#alertdelete").show('medium');
                                $("#alertdelete").html('<?php echo $GLOBALS['del_rule_delete_succuss']; ?>');
                                setTimeout(function () {
                                    $("#alertdelete").hide('medium');
                                }, 1500);
                                setTimeout(function () {
                                    location.reload();
                                }, 1500);
                            }
                        });
                    }
                });
            }
            webValue = $('#website_list').val();
            localStorage.setItem("webValue", webValue);
        }

        back_btn = () => {
            window.location.href = getpubId == '' ? 'websites_list.php?pub_id=' + publisherId + '' :
                'websites_list.php?pubid=' + getpubId + '';
        }
    </script>

</body>

</html>