<?php
include ('session.php');
include ('../config.php');
include ('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['linked_zones']; ?>
    </title>
    <meta name="description" content="" />
    <?php include ('head.php'); ?>
    <style>
        .nav {
            background: none !important;
        }

        .nav-pills .nav-link {

            border-radius: 0;
        }

        .alert {
            display: none;
        }

        .tbodyDiv {
            max-height: 50vh;
            overflow: auto;
        }

        td {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        td:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }

        .swal-button--danger {
            background-color: #2523b3;
            width: 100px;
        }

        .swal-button--cancel {
            color: white;
            width: 100px;
            background-color: #ff3e1d;
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: red;
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #2523b3;
        }

        .swal-footer {
            text-align: center;
        }
    </style>

</head>

<body onload="zone_list_link();zone_list_unlink();">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include ('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include ('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <form action="unlink_table" method="POST" class=" mt-5">
                            <div class="nav-align-top mb-4">
                                <ul class="nav nav-tabs" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link" href="campaign_edit.php?<?php if ($_GET['clientid']) {
                                            echo 'clientid=' . $_GET['clientid'];
                                        } else {
                                            echo 'client_id=' . $_GET['client_id'];
                                        }
                                        ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><span class="text-dark">
                                                <?php echo $GLOBALS['campaign_properties']; ?>
                                            </span></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link active" href="#"><span class="text-primary">
                                                <?php echo $GLOBALS['linked_zones']; ?>
                                            </span></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link"
                                            href="campaign_trackers.php?<?php if ($_GET['clientid']) {
                                            echo 'clientid=' . $_GET['clientid'];
                                        } else {
                                            echo 'client_id=' . $_GET['client_id'];
                                        }
                                        ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><span
                                                class="text-dark">
                                                <?php echo $GLOBALS['linked_tracker']; ?>
                                            </span></a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div class="tab-pane fade show active" id="" role="tabpanel">
                                        <div class="row">
                                            <p class="alert bg-success alert-dismissible fade show text-white"
                                                id="alertsuccess1"><i class="fa fa-check-circle"></i>
                                                <?php echo $GLOBALS['zone_unlinked_successfully']; ?>
                                            </p>
                                        </div>
                                        <!-- Available Zones-->
                                        <div class="row">
                                            <div class="col-12">
                                                <!-- style='margin-left:30px;' -->
                                                <div class="card">
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col">
                                                                <p class="h5 text-primary mb-4">
                                                                    <?php echo $GLOBALS['available_zones']; ?>
                                                                </p>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div
                                                                class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                                <label for="inputName">
                                                                    <?php echo $GLOBALS['available']; ?> <span
                                                                        id="len2"></span>
                                                                </label>
                                                            </div>
                                                            <!-- <div class="col-2"></div> -->
                                                            <div
                                                                class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mt-1 d-flex justify-content-start justify-content-sm-start justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                                                <label for="inputName">
                                                                    <?php echo $GLOBALS['search']; ?>
                                                                </label>
                                                            </div>
                                                            <div
                                                                class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mt-1 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                                                <input type="text" id="searchInput" class="form-control"
                                                                    placeholder="zone/website name" />
                                                            </div>
                                                        </div>
                                                        <div class="row mt-2">
                                                            <div
                                                                class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                                <label for="inputName">
                                                                    <?php echo $GLOBALS['unlinked']; ?> <span
                                                                        id="len"></span>
                                                                </label>
                                                            </div>
                                                            <div
                                                                class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-start justify-content-sm-start justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                                                <button class="btn btn-primary" type="button" id="link"
                                                                    style="position:relative;float:right;"
                                                                    onclick="zone_link();">
                                                                    <?php echo $GLOBALS['link_btn']; ?>
                                                                </button>
                                                            </div>
                                                        </div>

                                                        <div class="tbodyDiv mt-2">
                                                            <table id="link_table"
                                                                class="table table-striped table-responsive table-hover mt-3">
                                                                <thead class="sticky-top">
                                                                    <tr class="text-nowrap">
                                                                        <th class="th-color">
                                                                            <input type="checkbox"
                                                                                class="form-check-input check-zone"
                                                                                id="select_all">&nbsp;&nbsp;
                                                                            <?php echo $GLOBALS['strName']; ?>
                                                                        </th>
                                                                        <th class="th-color text-center">
                                                                            <?php echo $GLOBALS['strCTR']; ?>
                                                                        </th>
                                                                        <th class="th-color text-center">
                                                                            <?php echo $GLOBALS['cr']; ?>
                                                                        </th>
                                                                        <th class="th-color text-center">
                                                                            <?php echo $GLOBALS['strFinanceCPM']; ?>
                                                                        </th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody id="fbody" class="fbody">
                                                                    <td colspan="5" id="linkempty" class="text-center">
                                                                        <?php echo $GLOBALS['link_empty_msg']; ?>
                                                                    </td>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <hr class="solid">
                                            <!-- Available Zones-->

                                            <!-- Linked Zones-->
                                            <div class="col-12">
                                                <!-- style='margin-left:30px;' -->
                                                <div class="card">
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <p class="alert bg-success alert-dismissible fade show text-white"
                                                                id="alertsuccess"><i class="fa fa-check-circle"></i>
                                                                <?php echo $GLOBALS['zone_linked_successfully']; ?>
                                                            </p>
                                                            <div class="col">
                                                                <p class="h5 text-primary mb-4">
                                                                    <?php echo $GLOBALS['linked_zones']; ?>
                                                                </p>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div
                                                                class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                                <label for="inputName">
                                                                    <?php echo $GLOBALS['available']; ?> <span
                                                                        id="len3"></span>
                                                                </label>
                                                            </div>
                                                            <!-- <div class="col-2"></div> -->
                                                            <div
                                                                class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mt-1 d-flex justify-content-start justify-content-sm-start justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                                                <label for="inputName">
                                                                    <?php echo $GLOBALS['search']; ?>
                                                                </label>
                                                            </div>
                                                            <div
                                                                class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mt-1 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                                                <input type="text" id="searchInput1"
                                                                    class="form-control"
                                                                    placeholder="zone/website name" />
                                                            </div>
                                                        </div>
                                                        <div class="row mt-2">
                                                            <div
                                                                class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                                <label for="inputName">
                                                                    <?php echo $GLOBALS['linked']; ?> <span
                                                                        id="len1"></span>
                                                                </label>
                                                            </div>
                                                            <div
                                                                class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-start justify-content-sm-start justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                                                <button class="btn btn-danger" type="button" id="unlink"
                                                                    style="position:relative;float:right;"
                                                                    onclick="zone_unlink()">
                                                                    <?php echo $GLOBALS['unlink_btn']; ?>
                                                                </button></br>
                                                            </div>
                                                        </div></br>

                                                        <div class="tbodyDiv">
                                                            <table id="unlink_table"
                                                                class="table table-striped table-responsive table-hover mt-3">
                                                                <thead class="sticky-top">
                                                                    <tr class="text-nowrap">
                                                                        <th class="th-color">
                                                                            <input type="checkbox"
                                                                                class="form-check-input check-zone"
                                                                                id="select_all2">&nbsp;&nbsp;
                                                                            <?php echo $GLOBALS['strName']; ?>
                                                                        </th>
                                                                        <th class="th-color text-center">
                                                                            <?php echo $GLOBALS['strCTR']; ?>
                                                                        </th>
                                                                        <th class="th-color text-center">
                                                                            <?php echo $GLOBALS['cr']; ?>
                                                                        </th>
                                                                        <th class="th-color text-center">
                                                                            <?php echo $GLOBALS['strFinanceCPM']; ?>
                                                                        </th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody id="fbody1">
                                                                    <td colspan="5" id="unlinkempty"
                                                                        class="text-center">
                                                                        <?php echo $GLOBALS['unlink_empty_msg']; ?>
                                                                    </td>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Linked Zones-->
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    <!--Footer-->
                    <?php include ('footer.php'); ?>
                    <!--Footer-->
                </div>
            </div>
        </div>
    </div>


    <script src="../js/sweetalert.min.js"></script>
    <script>

        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var campaignid = '<?php echo $_REQUEST['campaignid']; ?>';

        document.getElementById("link").disabled = true;
        document.getElementById("unlink").disabled = true;

        //link_zone_list
        function zone_list_link() {
            $.ajax({
                url: live_URL + '/get_zonenotlinkedby_campaign/' + campaignid,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
                success: function (data) {
                    //console.log(data.data[0].zones);
                    if (data.data) {
                        for (var i = 0; i < data.data.length; i++) {
                            var pubid = data.data[i].publisherid;
                            var row = $('<tr><td style="" class="tableName"><input type="checkbox" class="data-checked form-check-input select-checkbox" name="checkrow" id="parent_' + pubid + '" value="' + data.data[i].publisherid + '" onclick="parentChanged(' + pubid + ')"><i class="fa fa-folder" aria-hidden="true" style="padding-left:10px;"></i>&nbsp;' + data.data[i].publishername + '</td><td></td><td></td><td></td></tr>');
                            $('#link_table').append(row);
                            for (var j = 0; j < data.data[i].zones.length; j++) {
                                var zon = data.data[i].zones[j];
                                var row = $('<tr id="trid"><td style="padding-left:50px;" class="tableName"><input type="checkbox" class="child_' + pubid + ' child form-check-input select-checkbox" name="checkrow" id="checkrow1" value="' + zon.zoneid + '" data-zone-id="' + zon.zoneid + '" onclick="childChanged(' + pubid + ')"><i class="fa fa-image" aria-hidden="true" style="padding-left:10px;"></i>&nbsp;' + zon.zonename + '</td><td class="text-center">0.000%</td><td class="text-center">0.000%</td><td class="text-center">$0.00</td></tr>');
                                $('#link_table').append(row);
                            }
                        }
                    }
                    var x = $("#trid #checkrow1").length;
                    if (x != null && x != '') {
                        $('#linkempty').hide();
                    }
                    else {
                        $('#linkempty').show();
                    }
                    $('#len').html(x);
                },
                error: function () { },
            });
        }

        //unlink_zone_list
        function zone_list_unlink() {
            $.ajax({
                url: live_URL + '/get_zonelinkedby_campaign/' + campaignid,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
                success: function (data) {
                    //console.log(data.data[0].zones);
                    if (data.data) {
                        for (var i = 0; i < data.data.length; i++) {
                            var pubid2 = data.data[i].publisherid;
                            var row = $('<tr><td style="" class="tableName"><input type="checkbox" class="data-checked2 form-check-input select-checkbox" name="checkrow" id="parent2_' + pubid2 + '" value="' + data.data[i].publisherid + '" onclick="parentChanged2(' + pubid2 + ')"><i class="fa fa-folder" aria-hidden="true" style="padding-left:10px;"></i>&nbsp;' + data.data[i].publishername + '</td><td></td><td></td><td></td></tr>');
                            $('#unlink_table').append(row);
                            for (var j = 0; j < data.data[i].zones.length; j++) {
                                var zon = data.data[i].zones[j];
                                var row = $('<tr id="trid1"><td style="padding-left:50px;" class="tableName"><input type="checkbox" class="child2_' + pubid2 + ' subchild form-check-input select-checkbox" name="checkrow" id="checkrow3" value="' + zon.zoneid + '" data-zone-id="' + zon.zoneid + '" onclick="childChanged2(' + pubid2 + ')"><i class="fa fa-image" aria-hidden="true" style="padding-left:10px;"></i>&nbsp;' + zon.zonename + '</td><td class="text-center">0.000%</td><td class="text-center">0.000%</td><td class="text-center">$0.00</td></tr>');
                                $('#unlink_table').append(row);
                            }
                        }
                    }
                    var y = $("#trid1 #checkrow3").length;
                    if (y != null && y != '') {
                        $('#unlinkempty').hide();
                    }
                    else {
                        $('#unlinkempty').show();
                    }
                    $('#len1').html(y);
                    all_zone();
                },
                error: function () { },
            });
        }

        //Link table Select_all
        $(document).on('click', '#select_all', function () {
            var checkval;
            $(".data-checked").prop("checked", this.checked);
            if (this.checked == true) {
                $('.data-checked:checked').each(function () {
                    checkval = this.value;
                    $('.child_' + checkval).prop("checked", true);
                    checkval = "";
                });
            }
            else {
                $('.child').prop("checked", false);
            }
            document.getElementById('link').disabled = $('.data-checked:checked').length > 0 ? false : true;
        });

        $(document).on('click', '.data-checked', function () {
            if ($('.data-checked:checked').length == $('.data-checked').length) {
                $('#select_all').prop('checked', true);
            }
            else {
                $('#select_all').prop('checked', false);
            }
        });

        function parentChanged(pubid) {
            //alert(pubid);
            if ($('#parent_' + pubid).prop("checked")) {
                $('.child_' + pubid).prop("checked", true);
                document.getElementById('link').disabled = $('.data-checked:checked').length > 0 ? false : true;
            }
            else {
                $('.child_' + pubid).prop("checked", false);
                document.getElementById('link').disabled = $('.data-checked:checked').length > 0 ? false : true;
            }
        }

        function childChanged(pubid) {
            if ($(".child_" + pubid + ":checked").length == $('.child_' + pubid).length) {
                $('#parent_' + pubid).prop('checked', true);
                if ($('.data-checked:checked').length == $('.data-checked').length) {
                    $('#select_all').prop('checked', true);
                }
                document.getElementById('link').disabled = false;
            }
            else if ($(".child_" + pubid + ":checked").length > 0) {
                $('#parent_' + pubid).prop('checked', false);
                $('#select_all').prop('checked', false);
                document.getElementById('link').disabled = false;
            }
            else {
                $('#parent_' + pubid).prop('checked', false);
                $('#select_all').prop('checked', false);
                document.getElementById('link').disabled = $('.child:checked').length > 0 ? false : true;
            }
        }

        //unlink table Select_all

        $(document).on('click', '#select_all2', function () {
            var checkval1;
            $(".data-checked2").prop("checked", this.checked);
            if (this.checked == true) {
                $('.data-checked2:checked').each(function () {
                    checkval1 = this.value;
                    $('.child2_' + checkval1).prop("checked", true);
                    checkval1 = "";
                });
            }
            else {
                $('.subchild').prop("checked", false);
            }
            document.getElementById('unlink').disabled = $('.data-checked2:checked').length > 0 ? false : true;
        });


        $(document).on('click', '.data-checked2', function () {
            if ($('.data-checked2:checked').length == $('.data-checked2').length) {
                $('#select_all2').prop('checked', true);
            }
            else {
                $('#select_all2').prop('checked', false);
            }
        });

        function parentChanged2(pubid2) {
            //alert(pubid);
            if ($('#parent2_' + pubid2).prop("checked")) {
                $('.child2_' + pubid2).prop("checked", true);
                document.getElementById('unlink').disabled = $('.data-checked2:checked').length > 0 ? false : true;
            }
            else {
                $('.child2_' + pubid2).prop("checked", false);
                document.getElementById('unlink').disabled = $('.data-checked2:checked').length > 0 ? false : true;
            }
        }

        function childChanged2(pubid2) {
            if ($(".child2_" + pubid2 + ":checked").length == $('.child2_' + pubid2).length) {
                $('#parent2_' + pubid2).prop('checked', true);
                if ($('.data-checked2:checked').length == $('.data-checked2').length) {
                    $('#select_all2').prop('checked', true);
                }
                document.getElementById('unlink').disabled = false;
            }
            else if ($(".child2_" + pubid2 + ":checked").length > 0) {
                $('#parent2_' + pubid2).prop('checked', false);
                document.getElementById('unlink').disabled = false;
                $('#select_all2').prop('checked', false);
            }
            else {
                $('#parent2_' + pubid2).prop('checked', false);
                $('#select_all2').prop('checked', false);
                document.getElementById('unlink').disabled = $('.subchild:checked').length > 0 ? false : true;
            }
        }


        //Link_Zone
        function zone_link() {
            var zoneData = [];
            var selected = $('#checkrow1:checked');
            selected.each(function () {
                zoneData.push($(this).attr('data-zone-id'));
            });
            console.log(zoneData);
            if (zoneData.length <= 0) {
                alert("Please select records.");
            } else {
                swal({
                    title: `<?php echo "Do you want to link?"; ?>`,
                    buttons: {
                        cancel: "Cancel",
                        danger: "Confirm",
                    },
                }).then(function (isConfirm) {
                    if (isConfirm) {
                        //console.log(zoneData);
                        var zoneData1 = { "zoneid": "" + zoneData + "", }
                        $.ajax({
                            type: "POST",
                            url: live_URL + '/zonebycampaign_link/' + campaignid,
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            data: zoneData1,
                            dataType: "json",
                            encode: true,
                        }).done(function (data) {
                            console.log(data);
                            if (data.msg = "Zones linked sucessfully") {
                                window.scrollTo(0, 800);
                                $("#alertsuccess").show('medium');
                                setTimeout(function () {
                                    $("#alertsuccess").hide('medium');
                                }, 2000);
                                setTimeout(function () {
                                    location.reload();
                                }, 1000);

                            } else {
                                window.scrollTo(0, 0);
                                $("#alertfailed").show('medium');
                                $("#alertfailed").html(data.msg);
                                setTimeout(function () {
                                    $("#alertfailed").hide('medium');
                                }, 1500);
                            }
                        });
                    }
                });
            }
        }


        //Unlink_Zone
        function zone_unlink() {
            var zoneData = [];
            var selected = $('#checkrow3:checked');
            selected.each(function () {
                zoneData.push($(this).attr('data-zone-id'));
            });
            console.log(zoneData);
            if (zoneData.length <= 0) {
                alert("Please select records.");
            } else {
                swal({
                    title: `<?php echo "Do you want to unlink?"; ?>`,
                    buttons: {
                        cancel: "Cancel",
                        danger: "Confirm",
                    },
                }).then(function (isConfirm) {
                    if (isConfirm) {
                        var zoneData1 = { "zoneid": "" + zoneData + "", }
                        console.log(zoneData1);
                        $.ajax({
                            type: "POST",
                            url: live_URL + '/zonebycampaign_unlink/' + campaignid,
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            data: zoneData1,
                            dataType: "json",
                            encode: true,
                        }).done(function (data) {
                            console.log(data);
                            if (data.msg = "Zones unlinked sucessfully") {
                                window.scrollTo(0, 0);
                                $("#alertsuccess1").show('medium');
                                setTimeout(function () {
                                    $("#alertsuccess1").hide('medium');
                                }, 2000);
                                setTimeout(function () {
                                    location.reload();
                                }, 1000);
                            } else {
                                window.scrollTo(0, 0);
                                $("#alertfailed").show('medium');
                                $("#alertfailed").html(data.msg);
                                setTimeout(function () {
                                    $("#alertfailed").hide('medium');
                                }, 1500);
                            }
                        });
                    }
                });
            }
        }

        //search_table_start
        $("#searchInput").keyup(function () {
            var value = $(this).val().toLowerCase();
            $("#fbody tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });

        $("#searchInput1").keyup(function () {
            var value = $(this).val().toLowerCase();
            $("#fbody1 tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
        //search_table_end 

        //Zone Count
        function all_zone() {
            var x = $("#trid #checkrow1").length;
            var y = $("#trid1 #checkrow3").length;
            var z = x + y;
            $('#len2').html(z);
            $('#len3').html(z);
            //alert(add);
        }
    </script>


</body>

</html>