<?php
include ('session.php');
include ('../config.php');
include ('../common.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['campaign_trackers']; ?>
    </title>
    <meta name="description" content="" />
    <?php include ('head.php'); ?>

</head>
<style>
    .swal-button--danger {
        background-color: #2523b3;
    }

    .swal-button--cancel {
        color: white;
        background-color: #ff3e1d;
    }

    .swal-button--cancel:not([disabled]):hover {
        background-color: #ff0800;
    }

    .swal-button--danger:not([disabled]):hover {
        background-color: #2523b3;
    }

    .text-hide {
        display: flex;
        width: 130px !important;
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
    }

    .text-hide:hover {
        overflow: hidden;
    }

    .card-body {
        padding: 0 !important;
    }

    .dataTables_scrollBody {
        height: auto !important;
    }


    .text_convert {
        text-transform: capitalize;
    }

    .btn:disabled {
        pointer-events: none;
        opacity: 0.95;
        background-color: #9E9E9E;
        border-color: #9E9E9E;
    }

    .loader {
        display: none;
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 999;
        background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
    }

    .align_size {
        width: 800px;
    }

    .nav {
        background: none !important;
    }

    .alert {
        display: none;
    }

    td {
        max-width: 150px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }

    td:hover {
        text-overflow: clip;
        white-space: normal;
        word-break: break-all;
    }
</style>

<body onload="tracker_list();">
    <div class="loader"></div>
    <input type='hidden' name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>" />
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include ('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include ('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">

                        <div class="nav-align-top mt-5">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link" href="campaign_edit.php?<?php if ($_GET['clientid']) {
                                        echo 'clientid=' . $_GET['clientid'];
                                    } else {
                                        echo 'client_id=' . $_GET['client_id'];
                                    }
                                    ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><span class="text-dark">
                                            <?php echo $GLOBALS['campaign_properties']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="campaign_zones.php?<?php if ($_GET['clientid']) {
                                        echo 'clientid=' . $_GET['clientid'];
                                    } else {
                                        echo 'client_id=' . $_GET['client_id'];
                                    }
                                    ?>&campaignid=<?php echo $_GET['campaignid']; ?>"><span class="text-dark">
                                            <?php echo $GLOBALS['linked_zones']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link active" href="#"><span class="text-primary">
                                            <?php echo $GLOBALS['linked_tracker']; ?>
                                        </span>
                                    </a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="navs-top-zoneproperties" role="tabpanel">
                                    <br>
                                    <p class="alert bg-success alert-dismissible fade show text-white"
                                        id="alertsuccess"><i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['track_success']; ?>
                                    </p>
                                    <div class="row">
                                        <div class="col-6">
                                            <p class="h3">
                                                <?php echo $GLOBALS['conversion_window']; ?>
                                            </p>
                                        </div>
                                        <hr class="solid">
                                    </div>

                                    <p class="h5 text-dark">
                                        <?php echo $GLOBALS['view']; ?>:
                                    </p>
                                    <div class="row mb-4">
                                        <!-- <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1">
                                            <label class="form-label text-center">
                                                <?php echo $GLOBALS['view']; ?>:
                                            </label>
                                        </div> -->
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1">
                                            <label class="form-label text-center">
                                                <?php echo $GLOBALS['day']; ?>
                                            </label>
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1 mb-2">
                                            <input type="text" name="days" id="days" class="form-control" placeholder=""
                                                value="0" onkeypress='return restrictAlphabets(event)' />
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1">
                                            <label class="form-label text-center">
                                                <?php echo $GLOBALS['hour']; ?>
                                            </label>
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1 mb-2">
                                            <input type="text" name="hours" id="hours" class="form-control"
                                                placeholder="" value="0" onkeypress='return restrictAlphabets(event)' />
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1">
                                            <label class="form-label text-center">
                                                <?php echo $GLOBALS['minutes']; ?>
                                            </label>
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1 mb-2">
                                            <input type="text" name="minutes" id="minutes" class="form-control"
                                                placeholder="" value="0" onkeypress='return restrictAlphabets(event)' />
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1">
                                            <label class="form-label text-center">
                                                <?php echo $GLOBALS['seconds']; ?>
                                            </label>
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1 mb-2">
                                            <input type="text" name="seconds" id="seconds" class="form-control"
                                                placeholder="" value="0" onkeypress='return restrictAlphabets(event)' />
                                        </div>
                                    </div>
                                    <p class="h5 text-dark">
                                        <?php echo $GLOBALS['strClicks']; ?>:
                                    </p>
                                    <div class="row">
                                        <!-- <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1">
                                            <label class="form-label text-center">
                                                <?php echo $GLOBALS['strClicks']; ?>
                                            </label>
                                        </div> -->
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1">
                                            <label class="form-label text-center">
                                                <?php echo $GLOBALS['day']; ?>
                                            </label>
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1 mb-2">
                                            <input type="text" name="days2" id="days2" class="form-control"
                                                placeholder="" value="0" onkeypress='return restrictAlphabets(event)' />
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1">
                                            <label class="form-label text-center">
                                                <?php echo $GLOBALS['hour']; ?>
                                            </label>
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1 mb-2">
                                            <input type="text" name="hours2" id="hours2" class="form-control"
                                                placeholder="" value="0" onkeypress='return restrictAlphabets(event)' />
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1">
                                            <label class="form-label text-center">
                                                <?php echo $GLOBALS['minutes']; ?>
                                            </label>
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1 mb-2">
                                            <input type="text" name="minutes2" id="minutes2" class="form-control"
                                                placeholder="" value="0" onkeypress='return restrictAlphabets(event)' />
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1">
                                            <label class="form-label text-center">
                                                <?php echo $GLOBALS['seconds']; ?>
                                            </label>
                                        </div>
                                        <div class="col col-6 col-sm-6 col-md-6 col-lg-1 col-xl-1 col-xxl-1 mb-2">
                                            <input type="text" name="seconds2" id="seconds2" class="form-control"
                                                placeholder="" value="0" onkeypress='return restrictAlphabets(event)' />
                                        </div>
                                    </div>

                                    <hr class="solid">
                                    <div class="row">
                                        <div class="col-6">
                                            <p class="h3">
                                                <?php echo $GLOBALS['linked_tracker']; ?>
                                            </p>
                                        </div>
                                        <hr class="solid">
                                    </div>
                                    <div class="text-center" id="link">
                                        <p>
                                            <?php echo $GLOBALS['link_update']; ?>No trackers available for this
                                            campaign
                                        </p>
                                    </div>

                                    <div id="track_table">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="mt-2 mb-4 container">
                                                    <div class="table-responsive text-nowrap">
                                                        <table id="tracker_list1"
                                                            class="table table-striped table-responsive">
                                                            <thead>
                                                                <tr class="text-nowrap">
                                                                    <th class="th-color" style="width:40px;"><input
                                                                            type="checkbox" class="form-check-input"
                                                                            id="select-all">
                                                                    </th>
                                                                    <th class="thauth-login-basic.html-color">
                                                                        <?php echo $GLOBALS['strName']; ?>
                                                                    </th>
                                                                    <th class="thauth-login-basic.html-color th-color ">
                                                                        <?php echo $GLOBALS['link_banner_id']; ?>
                                                                    </th>
                                                                    <th
                                                                        class="thauth-login-basic.html-color th-color text-center" style="width: 300px;">
                                                                        <?php echo $GLOBALS['default_status']; ?>
                                                                    </th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        </br>
                                        <div class="row mb-3">
                                            <div class="justify-content-end">
                                                <div class="col">
                                                    <button class="btn btn-primary text-white" onclick="savetracker()">
                                                        <?php echo $GLOBALS['save_changes']; ?>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <!-- / Content -->

                            <!-- Footer -->

                            <?php include ('footer.php'); ?>

                            <!-- / Footer -->

                            <div class="content-backdrop fade"></div>
                        </div>
                        <!-- Content wrapper -->
                    </div>

                </div>
                <!-- / Layout page -->
            </div>

            <!-- Overlay -->
            <div class="layout-overlay layout-menu-toggle"></div>
        </div>

        <script>
            var live_URL = '<?php echo $apiinvenpath; ?>';
            var token = 'Bearer ' + document.getElementById('token').value;

            var campaignid = '<?php echo $_REQUEST['campaignid']; ?>';
            var clientid = '<?php echo $_REQUEST['clientid']; ?>';
            var client_id = '<?php echo $_REQUEST['client_id']; ?>';

            function tracker_list() {

                if (client_id != '') {
                    cliid = client_id;
                } else {
                    cliid = clientid
                }
                $.ajax({
                    url: live_URL + '/get_tracker_by_advertiser/' + cliid,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    dataType: 'json',
                    encode: true,
                    success: function (data) {
                        console.log("test", data);
                        if (data.msg == "Tracker does not available for this client id") {
                            document.getElementById('tracker_list1').style.display = 'none';
                            $("#link").show();

                        } else {
                            $("#link").hide();
                            for (var i = 0; i < data.data.length; i++) {

                                var row = data.data;
                                var trackerid = row[i].trackerid;
                                var status = row[i].status;
                                //    console.log(trackerid);
                                var row = $('<tr  class="data-checked1 form-check-input id ="trid' + row[i].trackerid + '"><td><input type="checkbox" name="checkrow" class="data-checked form-check-input" id="checkrow' + row[i].trackerid + '" value="' + row[i].trackerid + '" data-tracker-id="' + row[i].trackerid + '" onclick="enable_dropdown(' + trackerid + ')"></td><td class="" style="color:blue;"><a href="adv_tracker_edit.php?clientid=' + cliid + '&trackerid=' + row[i].trackerid + '"><i class="fa fa-folder" aria-hidden="true"></i>&nbsp;' + data.data[i].trackername + '</a></td><td>' + data.data[i].trackerid + '</td><td><select  name="min_select" id="status_check' + row[i].trackerid + '" class="form-select text-dark status_check1" disabled><option value="4">Approved</option><option value="2">Pending</option><option value="1">Ignore</option></select></td></tr>');
                                $('#tracker_list1').append(row);
                                $('#status_check' + trackerid).val(status);
                            }
                            view_click(); 
                            get_trackerid();
                        }
                    },

                    //error: function () { },
                });

            }

            restrictAlphabets = (e) => {
                var x = e.which || e.keycode;
                if ((x >= 48 && x <= 57)) {
                    return true;
                } else {
                    return false;
                }
            };


            function view_click() {

                // console.log(clientid);
                $.ajax({
                    url: live_URL + '/get_view_clicks/' + campaignid,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    dataType: 'json',
                    encode: true,
                    success: function (data) {
                        console.log("test", data);

                        var reset_time = data.data.viewwindow;

                        var d = Math.round(reset_time / 86400);
                        var h = Math.round(reset_time % 86400 / 3600);
                        var m = Math.floor(reset_time % 3600 / 60);
                        var s = Math.floor(reset_time % 3600 % 60);
                        $('#days').val(d);
                        $('#hours').val(h);
                        $('#minutes').val(m);
                        $('#seconds').val(s);
                        var reset_time2 = data.data.clickwindow;

                        var d2 = Math.round(reset_time2 / 86400);
                        var h2 = Math.round(reset_time2 % 86400 / 3600);
                        var m2 = Math.floor(reset_time2 % 3600 / 60);
                        var s2 = Math.floor(reset_time2 % 3600 % 60);
                        $('#days2').val(d2);
                        $('#hours2').val(h2);
                        $('#minutes2').val(m2);
                        $('#seconds2').val(s2);
                    },
                    //error: function () { },
                });
            }


            function get_trackerid() {
                var val;
                $.ajax({
                    url: live_URL + '/get_trackerid/' + campaignid,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    dataType: 'json',
                    encode: true,
                    success: function (data) {
                        console.log("nith", data);
                        $.each(data.data, function (index, value) {
                            val = value['trackerid'];
                            var status = value['status'];
                            $('#checkrow' + val).prop('checked', true);
                            $('#status_check' + val).prop('disabled', false);
                            $('#status_check' + val).val(status);

                            val = '';
                            status = '';
                        });
                        if ($('.data-checked:checked').length == $('.data-checked').length) {
                            $('#select-all').prop('checked', true);
                        } else {
                            $('#select-all').prop('checked', false);
                        }
                    },
                    error: function () { },
                });
            }

            function savetracker() {

                var trackerid1 = [];

                $('.data-checked:checked').each(function () {
                    trackerid1 += this.value + ',';
                });
                //var tracklength=trackerid1.length;
                var trackval = Array.isArray(trackerid1);
                console.log("nithya", trackerid1);
                if (trackval == false) {
                    var trackerid = trackerid1.replace(/(^,)|(,$)/g, "");
                } else {
                    trackerid = '';
                }

                var status = [];
                var selected = trackerid.split(',');
                $.each(selected, function (id, val) {
                    if (val != '') {
                        status.push($('#status_check' + val + ' option:selected').val());
                    }
                });

                console.log("nith", trackerid);
                // console.log("vynu",id);

                var days = $('#days').val();
                var hours = $('#hours').val();
                var minutes = $('#minutes').val();
                var seconds = $('#seconds').val();
                if ((days != '' || hours != '' || minutes != '' || seconds != '')) {
                    var view = (days * 86400 + hours * 3600 + minutes * 60 + seconds * 1);
                }
                var days2 = $('#days2').val();
                var hours2 = $('#hours2').val();
                var minutes2 = $('#minutes2').val();
                var seconds2 = $('#seconds2').val();
                if ((days2 != '' || hours2 != '' || minutes2 != '' || seconds2 != '')) {
                    var click = (days2 * 86400 + hours2 * 3600 + minutes2 * 60 + seconds2 * 1);
                }
                var formData = {
                    "trackerid": "" + trackerid + "",
                    "status": "" + status + "",
                    "view": "" + view + "",
                    "click": "" + click + "",
                };

                console.log(formData);
                $.ajax({
                    url: live_URL + '/tracker_update/' + campaignid,
                    type: 'POST',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: formData,
                    dataType: 'json',
                    encode: true,
                    success: function (data) {
                        if (data.msg == "Tracker has been updated successfully!") {
                            window.scrollTo(0, 0);
                            $("#alertsuccess").show('medium');
                            setTimeout(function () {
                                $("#alertsuccess").hide('medium');
                            }, 2000);
                            setTimeout(function () {
                                window.location = window.location;
                            }, 1200);
                        }
                    },
                    //error: function () { },
                });
            }


            function enable_dropdown(trackerid) {

                if ($('#checkrow' + trackerid).prop("checked")) {
                    $('#status_check' + trackerid).prop('disabled', false);
                } else {
                    $('#status_check' + trackerid).prop('disabled', true);
                }
            }

            document.getElementById('select-all').onclick = function () {
                var checkboxes = document.querySelectorAll('input[type="checkbox"]');
                for (var checkbox of checkboxes) {
                    if (checkbox.checked = this.checked) {
                        $('.status_check1').prop('disabled', false);
                    } else {
                        $('.status_check1').prop('disabled', true);
                    }
                }
            }

            $(document).on('click', '.data-checked', function () {
                if ($('.data-checked:checked').length == $('.data-checked').length) {
                    $('#select-all').prop('checked', true);
                } else {
                    $('#select-all').prop('checked', false);
                }
            });
        </script>
</body>

</html>