<?php
include ('session.php');
include ('../config.php');
include ('../common.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['strReport_Banner_Report_Head']; ?>
    </title>

    <meta name="description" content="" />
    <style>
        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        h5 {
            position: relative;
            left: 250%;
        }

        .tableName {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .tableName:hover {
            text-overflow: clip;
            white-space: normal;
            /* word-break: break-all; */
        }

        /* Close Button */
        .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus) {
            box-shadow: 0 0 5px #fff !important;
        }

        .dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
            -webkit-appearance: none !important;
        }

        .dataTables_wrapper .dataTables_filter button {
            visibility: hidden;
            outline: none;
        }

        .dataTables_wrapper .dataTables_filter input:valid~button {
            visibility: visible;
        }

        button.close {
            padding: 0;
            background-color: transparent;
            border: 0;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }

        .close {
            float: right;
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
            color: #000;
            text-shadow: 0 1px 0 #fff;
            opacity: .5;
        }

        @media screen and (min-width:700px) {
            .daySelection {
                width: 30%;
                display: flex;
                justify-content: end;
            }
        }

        @media screen and (min-width:420px) and (max-width:699px) {
            .daySelection {
                width: 40%;
                display: flex;
                justify-content: center;
            }

            .main-chart {
                /* width: 200px;
                height: 400px; */
                width: auto;
                height: auto;
                margin: auto;
            }
        }

        @media screen and(min-width:220px) and (max-width:419px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }

            .main-chart {
                /* width: 90%; */
                /* height: 2100px; */
                width: auto;
                height: auto;
                margin: auto;
            }

            /* #myChart4{
                width: 227px;
                height: 300px;
            } */

            /* .country-chart{
                width: 100%;
                height: 600px;
            } */
        }

        @media screen and (max-width: 219px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }

        }

        .left-col {
            float: left;
            width: 45%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        .center-col {
            float: left;
            width: 20%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        .right-col {
            float: left;
            width: 35%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        @media only screen and (max-width: 767px) {
            .left-col {
                float: left;
                width: 45%;
                margin-top: 4rem;
                margin-bottom: 2rem;
            }

            .right-col {
                float: left;
                width: 35%;
                margin-top: 1rem;
                margin-bottom: 2rem;
                margin-right: 1px;
            }
        }

        #getBanner {
            width: 40% !important;
        }

        .table #alltotal tr th {
            padding-right: 20px;
        }

        .table tfoot #total,
        #totalall th {
            padding-right: 20px;
            text-align: center;
        }
    </style>
    <?php include ('head.php'); ?>
</head>

<body onload="gettime();">
    <div class="loader"></div>
    <input type="hidden" name="clientid" id="clientid" value="<?php echo $_GET['clientid']; ?>" />
    <input type="hidden" name="client_id" id="client_id" value="<?php echo $_GET['client_id']; ?>" />
    <input type="hidden" name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>" />
    <input type="hidden" name="campaign_id" id="campaign_id" value="<?php echo $_GET['campaign_id']; ?>" />
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <?php include ('sidebar.php'); ?>

            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include ('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3 ">
                            <div class="card-body">
                                <div class="row mb-2 mt-2">
                                    <div class="col col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                        <p class="h4" id='reportTitle'>
                                            <?php echo $GLOBALS['strReport_Banner_Report_Head']; ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="row mb-2 mt-2">
                                    <div
                                        class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <select id="advertiser_list" name="advertiser_list"
                                            class="form-select text-dark" onchange="get_campaigns('changed');">
                                        </select>
                                    </div>
                                    <div
                                        class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <select id="campaign_list" name="campaign_list" class="form-select text-dark"
                                            onchange="onChangeDetails('changed');">
                                        </select>
                                    </div>
                                    <input type='hidden' name="campaignid" id="campaignid"
                                        value="<?php echo $_GET['campaignid']; ?>" />
                                    <input type='hidden' id="startDate" value="<?php echo $_GET['start_date']; ?>" />
                                    <input type='hidden' id="endDate" value="<?php echo $_GET['end_date']; ?>" />
                                    <input type='hidden' id="campaignName"
                                        value="<?php echo $_GET['campaignname']; ?>" />
                                    <input type='hidden' id="client_id" value="<?php echo $_GET['clientid']; ?>" />

                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <button type="button" class="btn btn-primary" id="campaignList_backButton"
                                            onclick="back_button()" >
                                            <i class="bx bx-arrow-back bg-label-white"></i>
                                            <?php echo $GLOBALS['strback']; ?>
                                        </button>&nbsp;&nbsp;
                                        <select id="getBanner" name="allfilter"
                                            class="form-select text-dark daySelection w-30"
                                            aria-label="Default select example" onchange="onChangeDetails(this.value)">
                                            <option value="Today" selected>
                                                <?php echo $GLOBALS['strToday']; ?>
                                            </option>
                                            <option value="Yesterday">
                                                <?php echo $GLOBALS['strYesterday']; ?>
                                            </option>
                                            <option value="Last 7 days">
                                                <?php echo $GLOBALS['strLast_7_days']; ?>
                                            </option>
                                            <option value="Last 30 days">
                                                <?php echo $GLOBALS['strLast 30 days']; ?>
                                            </option>
                                            <option value="Last Month">
                                                <?php echo $GLOBALS['strLast Month']; ?>
                                            </option>
                                            <option value="This Month">
                                                <?php echo $GLOBALS['strThis Month']; ?>
                                            </option>
                                            <option value='All Statistics'>
                                                <?php echo $GLOBALS['strAll Statistics']; ?>
                                            </option>
                                            <option value="Custom">
                                                <?php echo $GLOBALS['strCustom']; ?>
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div
                                    class="d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                    <input style="display: none; margin-left:3%;width:20%" id="daterange"
                                        name="daterange" />
                                </div>

                                <hr>
                                <p id="warning" class="h6 alert text-black" style="background: #ffffb3; display:none;">
                                    <strong><?php echo $GLOBALS['warning']; ?></strong>&nbsp;<span
                                        id="warning_msg"></span>
                                </p>
                                <div class="table-responsive text-nowrap">
                                    <table id="bannerrep" class="table table-striped table-responsive">
                                        <thead>
                                            <tr class="text-dark">
                                                <th class="text-dark">
                                                    <?php echo $GLOBALS['strName']; ?>
                                                </th>
                                                <th class="text-dark">
                                                    <?php echo $GLOBALS['strImpression']; ?>
                                                </th>
                                              
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strSpend']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strECPM']; ?>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody id="ban_table"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include ('footer.php'); ?>
                    <!-- / Footer -->
                    <script>
                        const token = 'Bearer ' + document.getElementById('token').value;
                        const live_URL = '<?php echo $apistatpath; ?>';
                        var live_URL1 = '<?php echo $apiinvenpath; ?>';
                        let getClientId = document.getElementById('clientid').value;;
                        let getCampaign_Id = document.getElementById('campaign_id').value;
                        let agency_id = document.getElementById('agencyid').value;
                        var agencyid = document.getElementById('agencyid').value;
                        let campaign_id = document.getElementById('campaignid').value;
                        let startDate = document.getElementById('startDate').value;
                        let endDate = document.getElementById('endDate').value;
                        let campaignName = document.getElementById('campaignName').value;
                        let getparams = '<?php echo $_REQUEST['params']; ?>';
                        var cli_id = '<?php echo $_REQUEST['clientid']; ?>';
                        console.log("getClient_id", cli_id);
                        let getTodayDate;
                        let userid = '<?php echo $_SESSION['user_id']; ?>';
                        var permissions = [];

                        if (campaign_id) {
                            document.getElementById('campaignList_backButton').style.display = "block";
                        } else {
                            document.getElementById('campaignList_backButton').style.display = "none";
                        }

                        // API's
                        // let domain_url = live_URL + '/get_agency_banner_statistics/';
                        let campaignBanner_url = live_URL + '/get_agency_campaignwise_banner_statistics/';

                        var advValue = localStorage.getItem('advValue');
                        var camValue = localStorage.getItem("camValue");
                        var timeZone;

                        function gettime() {
                            $.ajax({
                                type: "GET",
                                url: live_URL + '/get_timezone_report/' + agency_id,
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                dataType: "json",
                                encode: true,
                            }).done(function (data) {
                                //console.log(data);
                                timeZone = data;
                                get_advertisers();
                            });
                        }

                        function get_advertisers() {
                            $.ajax({
                                type: "GET",
                                url: live_URL + '/get_all_advertiser/' + agencyid,
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                dataType: "json",
                                encode: true,
                            }).done(function (data) {
                                var client_name = [];
                                if (!data.data) {
                                    $('#advertiser_list').hide();
                                    $('#campaign_list').hide();
                                    $('#warning').show();
                                    $('#warning_msg').html("<?php echo $GLOBALS['orders_warning']; ?>");
                                    onChangeDetails();
                                } else {
                                    $('#advertiser_list').show();
                                    $('#warning').hide();
                                    data.data.map((data) => {
                                        getclientLength = (data.clientname.length > 30) ? (data.clientname.slice(0, 30) + '...') : data.clientname;
                                        client_name += `<option value=${data.clientid} title="${data.clientname}">${getclientLength}</option>`;
                                        document.getElementById('advertiser_list').innerHTML = client_name;
                                    });
                                    if (getClientId != '') {
                                        $('#advertiser_list').val(getClientId);
                                        $('#advertiser_list').attr("disabled", true);
                                    } else if (advValue != '' && advValue != null && advValue != 'undefined') {
                                        $('#advertiser_list option').each(function () {
                                            if (this.value == advValue) {
                                                $("#advertiser_list").val(advValue);
                                            }
                                        });
                                    }
                                    get_campaigns();
                                }
                            });
                        }

                        function get_campaigns(changed) {
                            var advertiser_id = $("#advertiser_list option:selected").val();
                            $.ajax({
                                type: "GET",
                                url: live_URL + '/get_all_campaigns/' + advertiser_id,
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                dataType: "json",
                                encode: true,
                            }).done(function (data) {
                                var campaign_name = [];
                                if (!data.data) {
                                    $('#campaign_list').hide();
                                    $('#campaign_list').val('');
                                    $('#warning').show();
                                    $('#warning_msg').html("<?php echo $GLOBALS['campaigns_warning']; ?>");
                                    //onChangeDetails();
                                } else {
                                    $('#campaign_list').show();
                                    $('#addBannerButton').attr("disabled", false);
                                    $('#warning').hide();
                                    data.data.map((data) => {
                                        getLength = (data.campaignname.length > 35) ? (data.campaignname.slice(0, 35) + '...') : data.campaignname;
                                        campaign_name += `<option value=${data.campaignid} title="${data.campaignname}" class='text-wrap text-break'>${getLength}</option>`;
                                        document.getElementById('campaign_list').innerHTML = campaign_name;
                                    });
                                    if (changed) {
                                        camValue = '';
                                        localStorage.removeItem('camValue');
                                        location.reload();
                                    }
                                    if (getCampaign_Id != '') {
                                        $('#campaign_list').val(getCampaign_Id);
                                    } else if (campaign_id != '') {
                                        $('#campaign_list').val(campaign_id);
                                        $('#campaign_list').attr("disabled", true);
                                    } else if (camValue != '' && camValue != null && camValue != 'undefined') {
                                        $('#campaign_list option').each(function () {
                                            if (this.value == camValue) {
                                                $("#campaign_list").val(camValue);
                                            }
                                        });
                                    }
                                    onChangeDetails();
                                    localStorage.setItem('advValue', $("#advertiser_list option:selected").val())
                                }

                            });
                        }



                        function onChangeDetails(changed) {
                            var advertiser_id = $("#advertiser_list option:selected").val();
                            //var campaign_id = $("#campaign_list option:selected").val();
                            $(".loader").show();
                            // Get the current date and time
                            const now = new Date();
                            // Create options for formatting the date and time
                            const options = {
                                timeZone,
                                weekday: 'short',
                                year: 'numeric',
                                month: 'short',
                                day: 'numeric',
                                hour: 'numeric',
                                minute: 'numeric',
                                second: 'numeric',
                                timeZoneName: 'short'
                            };

                            // Format the date and time
                            const formatter = new Intl.DateTimeFormat('en-US', options);
                            const formattedDate = formatter.format(now);

                            // Remove commas from the formatted date and time
                            let dateString1 = formattedDate.replace(/,/g, '');
                            let dateString = `"${dateString1}"`;
                            // Split the date string by spaces
                            let parts = dateString.split(' ');

                            // Extract the date components
                            let dayOfWeek = parts[0];
                            let month = parts[1];
                            let day = parts[2];
                            let year = parts[3];

                            // Convert month abbreviation to numeric month
                            let monthIndex = {
                                'Jan': '01', 'Feb': '02', 'Mar': '03', 'Apr': '04', 'May': '05', 'Jun': '06',
                                'Jul': '07', 'Aug': '08', 'Sep': '09', 'Oct': '10', 'Nov': '11', 'Dec': '12'
                            }[month];

                            // Construct the ISO formatted date
                            let date = `${year}-${monthIndex}-${day}`;

                            let getSelectedDay = document.getElementById('getBanner').value;

                            document.getElementById('daterange').style.display = getSelectedDay == 'Custom' ? "block" : "none";

                            if (getSelectedDay == 'Today') {
                                let v3 = date;
                                getTodayDate = v3;
                                getBannerDate(v3, v3);
                            } else if (getSelectedDay == 'Yesterday') {
                                let dateObj = new Date(date);
                                dateObj.setDate(dateObj.getDate() - 1);
                                let year = dateObj.getFullYear();
                                let month = ('0' + (dateObj.getMonth() + 1)).slice(-2);
                                let day = ('0' + dateObj.getDate()).slice(-2);
                                let yesterday_date = year + '-' + month + '-' + day;
                                getBannerDate(yesterday_date, yesterday_date);
                            } else if (getSelectedDay == 'Last 7 days') {
                                let dateObj = new Date(date);
                                dateObj.setDate(dateObj.getDate() - 7);
                                let year = dateObj.getFullYear();
                                let month = ('0' + (dateObj.getMonth() + 1)).slice(-2);
                                let day = ('0' + dateObj.getDate()).slice(-2);
                                let first_day = year + '-' + month + '-' + day;

                                let dateObj1 = new Date(date);
                                dateObj1.setDate(dateObj1.getDate() - 1);
                                let year1 = dateObj1.getFullYear();
                                let month1 = ('0' + (dateObj1.getMonth() + 1)).slice(-2);
                                let day1 = ('0' + dateObj1.getDate()).slice(-2);
                                let date_end = year1 + '-' + month1 + '-' + day1;
                                getBannerDate(first_day, date_end);
                            } else if (getSelectedDay == 'Last 30 days') {
                                let dateObj = new Date(date);
                                dateObj.setDate(dateObj.getDate() - 30);
                                let year = dateObj.getFullYear();
                                let month = ('0' + (dateObj.getMonth() + 1)).slice(-2);
                                let day = ('0' + dateObj.getDate()).slice(-2);
                                let first_day = year + '-' + month + '-' + day;

                                let dateObj1 = new Date(date);
                                dateObj1.setDate(dateObj1.getDate() - 1);
                                let year1 = dateObj1.getFullYear();
                                let month1 = ('0' + (dateObj1.getMonth() + 1)).slice(-2);
                                let day1 = ('0' + dateObj1.getDate()).slice(-2);
                                let date_end = year1 + '-' + month1 + '-' + day1;
                                getBannerDate(first_day, date_end);
                            } else if (getSelectedDay == 'This Month') {
                                let dateObj = new Date(date);
                                let firstDay = new Date(dateObj.getFullYear(), dateObj.getMonth(), 1);
                                let cYear = firstDay.getFullYear(),
                                    cMonth = firstDay.getMonth() + 1,
                                    cDate = firstDay.getDate();
                                let first_day = cYear + "-" + cMonth + "-" + cDate;

                                let dateObj1 = new Date(date);
                                let lastDay = new Date(dateObj1.getFullYear(), dateObj1.getMonth() + 1, 0);
                                let year = lastDay.getFullYear(),
                                    month = lastDay.getMonth() + 1,
                                    day = lastDay.getDate();
                                let date_end = year + "-" + month + "-" + day;
                                getBannerDate(first_day, date_end);
                            } else if (getSelectedDay == 'Last Month') {
                                let dateObj = new Date(date);
                                var prevMonthLastDate = new Date(dateObj.getFullYear(), dateObj.getMonth(), 0);
                                var prevMonthFirstDate = new Date(dateObj.getFullYear() - (dateObj.getMonth() > 0 ? 0 : 1), (dateObj.getMonth() - 1 + 12) % 12, 1);
                                var formatDateComponent = function (dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                                }
                                var formatDate = function (dateObj) {
                                    return dateObj.getFullYear() + "-" + formatDateComponent(dateObj.getMonth() + 1) + "-" + formatDateComponent(dateObj.getDate())
                                };
                                var start_date = formatDate(prevMonthFirstDate),
                                    end_date = formatDate(prevMonthLastDate);
                                getBannerDate(start_date, end_date);
                            } else if (getSelectedDay == 'All Statistics') {
                                getBannerDate(start_date = 0, end_date = 0);
                            } else if (getSelectedDay == 'Custom') {
                                $(".loader").hide();
                                const date1 = new Date();
                                let getCurrentDate = JSON.stringify(date1).slice(1, 11);
                                getBannerDate(getCurrentDate, getCurrentDate);
                                $(function () {
                                    $('input[name="daterange"]').daterangepicker({
                                        opens: 'left',
                                        locale: {
                                            format: 'DD/MM/YYYY'
                                        },
                                    }, function (start, end, label) {
                                        getBannerDate(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
                                    });
                                })
                            }
                            if (changed) {
                                localStorage.setItem('camValue', $("#campaign_list option:selected").val())
                            }
                        };

                        function getBannerDate(start_date, end_date) {
                            console.log("start_date", start_date, "end_date", end_date);
                            if (cli_id != "") {

                                var getClient_id = cli_id;
                            } else {
                                var getClient_id = $("#advertiser_list option:selected").val();
                            }

                            if (getCampaign_Id != "") {

                                var campaign_id = getCampaign_Id;
                            } else {
                                var campaign_id = $("#campaign_list option:selected").val();
                            }

                            let payload;

                            if (campaign_id == '') {
                                payload = (start_date == 0 && end_date == 0) ? {
                                    "action": 'all'
                                } : {
                                    "action": '',
                                    "start_date": start_date + ' 00:00:00,',
                                    "end_date": end_date + ' 23:59:59,'
                                }
                                console.log('start_date' + start_date);
                                $.ajax({
                                    url: campaignBanner_url + getClient_id + campaign_id,
                                    type: 'POST',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: payload,
                                    success: function (data) {
                                        //$('#hmm').html(data);
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available' || data.msg == 'Please enter valid Advertiser Id') {
                                            $("#foot").hide();
                                            $('#alltotal').hide();
                                            $('#bannerrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: false,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                                }
                                            });
                                        } else {
                                            $("#foot").show();
                                            $('#alltotal').show();
                                            $('#bannerrep').DataTable({
                                                ordering: true,
                                                destroy: true,
                                                "dom": '<"top"<"center-col"l><"left-col"B><"right-col"f>>rtip',
                                                buttons: [{
                                                    extend: 'collection',
                                                    text: 'Export',
                                                    autoClose: true,
                                                    className: 'btn btn-primary btn-sm export',
                                                    buttons: [{
                                                        text: 'Excel',
                                                        extend: 'excel',
                                                        header: true,
                                                        footer: true,
                                                        visible: false,
                                                        "customize": function (xlsx) {
                                                            var sheet = xlsx.xl.worksheets['sheet1.xml'];
                                                            $('row c', sheet).attr('s', '51'); //for all rows
                                                            //$('row:eq(0) c', sheet).attr('s','2');                                                                                                             
                                                            //$('row:eq(1) c', sheet).attr('s', '2');                                                              
                                                        }
                                                    },
                                                    {
                                                        text: 'PDF',
                                                        extend: 'pdf',
                                                        header: true,
                                                        footer: true,
                                                        visible: false,
                                                        orientation: 'landscape',
                                                        pageSize: 'LEGAL',
                                                        customize: function (doc) {
                                                            doc.styles.tableBodyEven.alignment = 'center';
                                                            doc.styles.tableBodyOdd.alignment = 'center';
                                                            doc.styles.tableFooter.alignment = 'center';
                                                        },
                                                    }
                                                    ],
                                                    fade: true,
                                                }],
                                                data: data,
                                                columns: [{
                                                    data: 'bannername',
                                                    className: 'tableName'
                                                },
                                                {
                                                    data: 'impressions',
                                                    className: "text-center"
                                                },
                                                
                                                {
                                                    data: 'revenue',
                                                    className: "text-center",
                                                    render: function (data, type, row, meta) {
                                                        return row.revenue == null ? "0.0000" : row.revenue;
                                                    }
                                                },
                                                {
                                                    data: 'ecpm',
                                                    className: "text-center",
                                                    render: function (data, type, row, meta) {
                                                        return row.ecpm == null ? "0.0000" : row.ecpm;
                                                    }
                                                },
                                                ],
                                                "footerCallback": function (row, data, start, end, display) {
                                                    let api = this.api();

                                                    // converting to interger to find total
                                                    let intVal = function (i) {
                                                        return typeof i === 'string' ?
                                                            i.replace(/[\$,]/g, '') * 1 :
                                                            typeof i === 'number' ? i : 0;
                                                    };

                                                },
                                                initComplete: function (settings) {
                                                    //settings.nTable.id --> Get table ID
                                                    $('#' + settings.nTable.id + '_filter input').wrap(`
                                                    <div class="d-inline-flex position-relative"></div>
                                              `).after(`
                                                    <button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
                                                      <span aria-hidden="true">&times;</span>
                                                    </button>
                                               `).attr('required', 'required').attr('title', 'Search');

                                                    // Click Event on Clear button
                                                    $(document).on('click', '#' + settings.nTable.id + '_filter button', function () {
                                                        $('#' + settings.nTable.id).DataTable({
                                                            "retrieve": true,
                                                        }).search('').draw(); // reDraw table
                                                    });
                                                }
                                            });
                                        }
                                    },
                                    error: function () { },
                                });
                            } else {
                                <?php if ($_GET['campaignid']) { ?>
                                    document.getElementById('campaignList_backButton').style.display = "block";
                                    //document.getElementById('getBanner').style.display = "none";
                                <?php } else { ?>
                                    document.getElementById('campaignList_backButton').style.display = "none";
                                    //document.getElementById('getBanner').style.display = "block";
                                <?php } ?>
                                //document.getElementById('campaignList_backButton').style.display="none";
                                // let campaignWisher_banner = campaignBanner_url + start_date + ' 00:00:00,' + end_date + ' 23:59:59,' + agency_id + ',' + campaign_id
                                payload = (start_date == 0 && end_date == 0) ? {
                                    "action": 'all'
                                } : {
                                    "action": '',
                                    "start_date": start_date + ' 00:00:00,',
                                    "end_date": end_date + ' 23:59:59,'
                                }
                                $.ajax({
                                    url: campaignBanner_url + getClient_id + ',' + campaign_id,
                                    type: 'POST',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: payload,
                                    success: function (data) {
                                        //$('#hmm').html(data);
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available' || data.msg == 'Please enter valid Advertiser Id') {
                                            $("#foot").hide();
                                            $('#alltotal').hide();
                                            $('#bannerrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: false,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                                }
                                            });
                                        } else {
                                            $("#foot").show();
                                            $('#alltotal').show();
                                            //document.getElementById('getBanner').style.display = "none";
                                            <?php if ($_GET['campaignid']) { ?>
                                                document.title = campaignName;
                                                //document.getElementById('reportTitle').innerHTML = document.title;
                                            <?php } ?>
                                            $('#bannerrep').DataTable({
                                                ordering: true,
                                                destroy: true,
                                                "dom": '<"top"<"center-col"l><"left-col"B><"right-col"f>>rtip',
                                                buttons: [{
                                                    extend: 'collection',
                                                    text: 'Export',
                                                    autoClose: true,
                                                    className: 'btn btn-primary btn-sm export',
                                                    buttons: [{
                                                        text: 'Excel',
                                                        extend: 'excel',
                                                        header: true,
                                                        footer: true,
                                                        visible: false,
                                                        "customize": function (xlsx) {
                                                            var sheet = xlsx.xl.worksheets['sheet1.xml'];
                                                            $('row c', sheet).attr('s', '51'); //for all rows
                                                            //$('row:eq(0) c', sheet).attr('s','2');                                                                                                             
                                                            //$('row:eq(1) c', sheet).attr('s', '2');                                                              
                                                        }
                                                    },
                                                    {
                                                        text: 'PDF',
                                                        extend: 'pdf',
                                                        header: true,
                                                        footer: true,
                                                        visible: false,
                                                        orientation: 'landscape',
                                                        pageSize: 'LEGAL',
                                                        customize: function (doc) {
                                                            doc.styles.tableBodyEven.alignment = 'center';
                                                            doc.styles.tableBodyOdd.alignment = 'center';
                                                            doc.styles.tableFooter.alignment = 'center';
                                                        },
                                                    }
                                                    ],
                                                    fade: true,
                                                }],
                                                data: data,
                                                columns: [{
                                                    data: 'bannername',
                                                    className: 'text-start tableName'
                                                },
                                                {
                                                    data: 'impressions',
                                                    className: 'text-center'
                                                },
                                                
                                                {
                                                    data: 'revenue',
                                                    className: "text-center",
                                                    render: function (data, type, row, meta) {
                                                        return row.revenue == null ? "0.0000" : row.revenue;
                                                    }
                                                },
                                                {
                                                    data: 'ecpm',
                                                    className: "text-center",
                                                    render: function (data, type, row, meta) {
                                                        return row.ecpm == null ? "0.0000" : row.ecpm;
                                                    }
                                                },
                                                ],
                                                "footerCallback": function (row, data, start, end, display) {
                                                    var api = this.api(),
                                                        data;

                                                    // converting to interger to find total
                                                    var intVal = function (i) {
                                                        return typeof i === 'string' ?
                                                            i.replace(/[\$,]/g, '') * 1 :
                                                            typeof i === 'number' ?
                                                                i : 0;
                                                    };


                                                },
                                            });
                                        }
                                    },
                                    error: function () { },
                                });
                            }
                            $.ajax({
                                type: "GET",
                                url: live_URL1 + '/get_permissions/' + userid,
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                dataType: "json",
                                encode: true,
                            }).done(function (data) {
                                console.log(data);
                                let get_data = data.data;
                                if (get_data) {
                                    for (var i = 0; i < get_data.length; i++) {
                                        permissions[i] = get_data[i];
                                    }
                                } else {
                                    permissions = '';
                                }
                                if (!permissions.includes('44')) {
                                    $('.export').hide();
                                } else {
                                    $('.export').show();
                                }
                            });
                        };

                        function back_button() {
                            window.location.href = (getparams != '') ? 'campaignreport.php' :
                                'campaignreport.php?clientid=' + cli_id;
                        }
                    </script>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>

</html>