<?php
include('session.php');
include('../config.php');
include('../common.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='assets/' data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title><?php echo $projecttitle; ?> - <?php echo $GLOBALS['strInventory_AddBanner']; ?></title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        .cancel-style {
            color: red !important
        }

        .cancel-style:hover {
            color: #fff !important
        }

        canvas {
            height: 175px;
            border-style: solid;
            border-width: 1px;
            border-color: black;
        }

        input {
            font-family: verdana;
            font-size: 12pt;
        }

        .alert {
            display: none;
        }

        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        .tableName {
            max-width: 80px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .tableName:hover {
            text-overflow: clip;
            white-space: normal;
            /* word-break: break-all; */
        }
    </style>
</head>

<body onload="get_advertiser()">
    <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->
                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="card mt-4 mb-2">
                            <div class="card-header d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                <p class="h3 text-secondary"><?php echo $GLOBALS['strInventory_AddBanner']; ?></p>

                                <!-- <div class="alert bg-primary alert-dismissible fade show" role="alert" id="alertsuccess">                                      
                                        <p class="text-white"><i class="fa fa-check-circle"></i><?php echo $GLOBALS['strSuccessAlert']; ?></p>
                                    </div>
                                    <div class="alert bg-danger alert-dismissible fade show" role="alert" id="alertfailed">                                      
                                        <p class="text-white"><i class="fa fa-check-circle"></i><?php echo $GLOBALS['strFailedAlert']; ?></p>
                                    </div> -->
                            </div>
                            <!-- <p class="h3 text-secondary"><?php echo $GLOBALS['strInventory_AddBanner']; ?></p> -->
                            <input type='hidden' name="clientid" id="clientid" value="<?php echo $_GET['clientid']; ?>" />
                            <input type='hidden' name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>" />
                            <input type='hidden' name="client_id" id="client_id" value="<?php echo $_GET['client_id']; ?>" />
                            <input type='hidden' name="campaign_id" id="campaign_id" value="<?php echo $_GET['campaign_id']; ?>" />
                            <input type="hidden" name="params" id="campaign_params" value="<?php echo $_GET['params']; ?>" />

                            <form action="" method="POST" enctype="multipart/form-data">
                                <div class="card-body">
                                    <div class="container">
                                        <div class="row">
                                            <!-- <p class="h3 text-secondary"><?php echo $GLOBALS['strInventory_AddBanner']; ?></p> -->
                                            <p class="alert bg-success alert-dismissible fade show text-white" id="alertsuccess"><i class="fa fa-check-circle"></i> <?php echo $GLOBALS['banner_success']; ?> </p>
                                            <p class="alert bg-danger alert-dismissible fade show text-white" id="alertfailed"><i class="fa fa-times-circle"></i> <?php echo $GLOBALS['banner_failed']; ?> </p>
                                        </div>
                                        <div class="row">                                       
                                            <div id="bannerimage" style="display:none;">
                                                <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-4">
                                                    <img id="frame" src="" style="max-width:1000px;max-height:400px" />
                                                </div>
                                            </div>                                         
                                        </div>
                                        <div class="row">
                                        <h4><?php echo $GLOBALS['']; ?>Basic information</h4>
                                        <hr class="solid">
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                <div class="mb-2">
                                                    <label class="form-label"><?php echo $GLOBALS['ordersjobs']; ?>
                                                        <span class="required text-danger"> *</span></label>
                                                    <select class="form-select text-dark" id="advertiser_name" onchange="getCampaign('change')" onkeyup="">
                                                    </select>
                                                    <p id="error_advertiser" style="color:red"></p>
                                                </div>
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                <div class="mb-2">
                                                    <label class="form-label"><?php echo $GLOBALS['campaign_name']; ?>
                                                        <span class="required text-danger"> *</span></label>
                                                    <select class="form-select text-dark" id="campaignName" onchange="getSelectedCampaign()">
                                                    </select>
                                                    <p id="error_campaign" style="color:red"></p>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="row" id="nameType">
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                <label class="form-label mb-2">
                                                    <?php echo $GLOBALS['strInventory_Campaign_List_Type']; ?><span class="required text-danger"> *</span>
                                                </label>
                                                <select id="bannert_type" name="bannert_type" class="form-select text-dark" onchange="banner_type(this.value);">
                                                    <option value=""><?php echo $GLOBALS['strSelect_Banner_Type']; ?></option>
                                                    <optgroup label=<?php echo $GLOBALS['strWeb']; ?>>
                                                        <option value="web" id="web"><?php echo $GLOBALS['strWeb Banner']; ?></option>
                                                    </optgroup>
                                                    <optgroup label=<?php echo $GLOBALS['strSQL']; ?>>
                                                        <option value="sql" id="sql"><?php echo $GLOBALS['strSQL Banner']; ?></option>
                                                    </optgroup>
                                                    <optgroup label=<?php echo $GLOBALS['strURL']; ?> id="url">
                                                        <option value="url"><?php echo $GLOBALS['strURL_Banner']; ?></option>
                                                    </optgroup>
                                                    <optgroup label=<?php echo $GLOBALS['strHTML']; ?> id="html">
                                                        <option value="html"><?php echo $GLOBALS['strGeneric_HTML_Banner']; ?></option>
                                                        <option value="html5"><?php echo $GLOBALS['strHTML5_Banner_Zip']; ?></option>
                                                        <!-- <option value="inline"><?php echo $GLOBALS['strInlineVideo_Ad']; ?></option>
                                                        <option value="overlay"><?php echo $GLOBALS['strOverlay_Video_Ad']; ?></option> -->
                                                    </optgroup>
                                                    <optgroup label=<?php echo $GLOBALS['strText']; ?> id="text">
                                                        <option value="txt"><?php echo $GLOBALS['strGeneric_TEXT_Banner']; ?></option>
                                                    </optgroup>
                                                </select>
                                                <p id="errors1" style="color:red"></p>
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                <label class="form-label mb-2">
                                                    <?php echo $GLOBALS['strName']; ?><span class="required text-danger"> *</span></label>
                                                <input type="text" class="form-control text-dark" id="name" name="name" placeholder="name" oninput="bannernameval()" onchange="bannernameval()" onkeyup="bannernameval()">
                                                <p id="errors" style="color:red"></p>
                                            </div>

                                        </div>
                                        <div class="row mb-2">
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6" id="main_destination">
                                                <label class="form-label mb-2">
                                                    <?php echo $GLOBALS['strDestination_URL']; ?><span id="req_destinationURL" class="required text-danger"> *</span>
                                                </label>
                                                <input type="url" class="form-control text-dark" value="" placeholder="Destination URL" id="desurl" name="desurl" oninput="destinationUrlValidation()" onchange="destinationUrlValidation()" onkeyup="destinationUrlValidation()" />
                                                <p id="error_destinationURL" style="color:red"></p>
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                <label class="form-label mb-2" for="wight"><?php echo $GLOBALS['weight']; ?>
                                                    <span class="required text-danger"> *</span></label>
                                                </label>
                                                <input type="number" min=0 class="form-control text-dark w-100" placeholder=<?php echo $GLOBALS['weight']; ?> value="1" id="banner_weight" onchange="onChangeWeight()" onkeyup="onChangeWeight()" />
                                                <p id="error_weight" style="color: red;"></p>
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6" id="getBannerSize">
                                                <label class="form-label mb-2">
                                                    <?php echo $GLOBALS['strSize']; ?><span class="required text-danger"> *</span></label>
                                                <select class="form-select text-dark" name="bannerSize" id="bannerSize" onchange="custom_select(this.value)">
                                                </select>
                                                <p id="errors2" style="color:red"></p>
                                            </div>
                                            

                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6" id="custom" style="display:none;">
                                                <div class="row">
                                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                        <label class="form-label "><?php echo $GLOBALS['width']; ?><span class="required text-danger"> *</span></label>
                                                        <input type="number" min=0 name="height" id="width" class="form-control text-dark" onkeypress='return restrictAlphabets(event)' onchange='sizeValidation()' onkeyup="sizeValidation()" />
                                                        <p id="errorswidth" style="color:red;"></p>
                                                        <p id="errors_sizeWidth" style="color:red;"></p>
                                                    </div>
                                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                        <label class="form-label "><?php echo $GLOBALS['height']; ?><span class="required text-danger"> *</span></label>
                                                        <input type="number" min=0 name="height" id="height" class="form-control text-dark" onkeypress='return restrictAlphabets(event)' onchange='sizeValidation()' onkeyup="sizeValidation()" />
                                                        <p id="errorsheight" style="color:red;"></p>
                                                        <p id="error_sizeHeight" style="color:red;"></p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="col" id="webbanner" style="display:none;">
                                                            <label class="form-label mb-2">
                                                                <?php echo $GLOBALS['strUpload_Image']; ?><span class="required text-danger"> *</span>
                                                            </label>
                                                            <input class="form-control" type="file" id="formFile" name="formFile" onchange="preview()">
                                                            <p id="webuploaderrors" style="color:red"></p>
                                                        </div>
                                                        <div class="col" id="sqlbanner" style="display:none;">
                                                            <label class="form-label mb-2">
                                                                <?php echo $GLOBALS['strSQL']; ?><span class="required text-danger"> *</span>
                                                            </label>
                                                            <input type="file" name="sqlban" id="sqlban" class="form-control" onchange="preview()" value="" />
                                                            <p id="sqlerrors" style="color:red"></p>
                                                        </div>
                                                        <div class="col" id="urlbanner" style="display:none;">
                                                            <label class="form-label mb-2">
                                                                <?php echo $GLOBALS['strIMAGE_URL']; ?><span class="required text-danger"> *</span>
                                                            </label>
                                                            <input type="url" name="url" id="bannerurl" class="form-control text-dark" value="" onkeyup="urlbanner()" placeholder=<?php echo $GLOBALS['strIMAGE_URL']; ?> />
                                                            <p id="errors3" style="color:red"></p>
                                                        </div>
                                                        <div class="col" id="textbanner" style="display:none;">
                                                            <label class="form-label mb-2">
                                                                <?php echo $GLOBALS['strText']; ?><span class="required text-danger"> *</span>
                                                            </label>
                                                            <textarea class="form-control text-dark" name="bannertext" id="bannertext" placeholder="text" value="" onchange="bannertextVal()" onkeyup="bannertextVal()"></textarea>
                                                            <p id="bannertexterror" style="color:red"></p>
                                                        </div>
                                                        <div class="col" id="htmlbanner" style="display:none;">
                                                            <label class="form-label mb-2">
                                                                <?php echo $GLOBALS['strHTML']; ?><span class="required text-danger"> *</span>
                                                            </label>
                                                            <textarea class="form-control text-dark" name="htmlBanner" id="htmlBanner" onkeyup="htmlbannerVal()"></textarea>
                                                            <p id="htmlerror" style="color:red"></p>
                                                        </div>
                                                        <div class="col" id="html5banner" style="display:none;">
                                                            <label class="form-label mb-2">
                                                                <?php echo $GLOBALS['strHTML_5']; ?><span class="required text-danger"> *</span>
                                                            </label>
                                                            <input type="file" name="html5ban" id="html5ban" class="form-control" onchange="preview()" />
                                                            <p id="html5_bannerError" style="color:red"></p>
                                                        </div>
                                                    </div>
                                            <div id="bannerarea" style="display:block;">

                                                <!-- inline -->
                                                <div class="col" id="inlinevideoad" style="display:none;">
                                                    <div class="row mb-2">
                                                        <b class="d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start"><?php echo $GLOBALS['strCreate_InlineVideo_Ad']; ?></b>
                                                        <hr>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col col-12 col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                            <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                <?php echo $GLOBALS['strVideo_Delivery_Method']; ?><span class="required text-danger"> *</span>
                                                            </label>
                                                            <select class="form-select text-dark" id="inlineVideo-deliveryType" name="inlineVideo-deliveryType" onchange="progressivechange(this.value)" onkeyup="progressivechange(this.value)">
                                                                <option value=""><?php echo $GLOBALS['strSelect_Video_Type']; ?></option>
                                                                <option value="streaming"><?php echo $GLOBALS['strStreaming_RTMP']; ?></option>
                                                                <option value="progressive"><?php echo $GLOBALS['strProgressive_HTTP']; ?></option>
                                                            </select>
                                                            <p id="vediodeliveryerrors" style="color:red;"></p>
                                                        </div>
                                                        <div class="col col-12 col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6" id="strem" style="display:block;">
                                                            <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                <?php echo $GLOBALS['strRtmp_Server_URL']; ?>
                                                            </label>
                                                            <input type="url" id="rtmp_serverURL" name="rtmp_serverURL" class="form-control" onkeyup="inlinertmpurl()" />
                                                            <!-- onkeyup="overlayStreaming()" -->
                                                            <p id="rtms_server_url" style="color:red;"></p>
                                                        </div>
                                                        <div class="col col-12 col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6" id="prgs" style="display:none;">
                                                            <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                <?php echo $GLOBALS['video_url']; ?>
                                                            </label>
                                                            <input type="text" name="rtmpurl" class="form-control" id="video_URL" value="" onkeyup="inlineVideoURL()" />
                                                            <p id="error_progressive_videoUrl" style="color:red;"></p>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col col-12 col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6" id="filename">
                                                            <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                <?php echo $GLOBALS['strVIDEO_FILE_NAME']; ?>
                                                            </label>
                                                            <input type="text" name="inline_videofile" id="inline_videofile" class="form-control" value="" onkeyup="vediouploadval()" />
                                                            <!-- onkeyup="overlayStreaming()" -->
                                                            <p id="vediourlerrors" style="color:red;"></p>
                                                        </div>
                                                        <div class="col col-12 col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                            <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                <?php echo $GLOBALS['strVIDEO TYPE']; ?>
                                                            </label>
                                                            <select id="inline_videoType" name="inline_videoType" class="form-select text-dark" onchange="vediofiletypeval()">
                                                                <option selected value=""><?php echo $GLOBALS['strSelect_Video_Type']; ?></option>
                                                                <option value="video/x-mp4"><?php echo $GLOBALS['strMP4']; ?></option>
                                                            </select>
                                                            <p id="vediofiletypeerrors" style="color:red;"></p>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col col-12 col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                            <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                <?php echo $GLOBALS['video_duration_in_seconds']; ?>
                                                            </label>
                                                            <input type="text" name="inline_videoduration" id="inline_videoduration" class="form-control" value="" onkeyup="vediodurationval()" />
                                                            <!-- onkeyup="overlayStreaming()" -->
                                                            <p id="vediodurationerrors" style="color:red;"></p>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2" id="companion">
                                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                            <label class="form-label" style="font-size: 1.4ch;">
                                                                <?php echo $GLOBALS['companion_banner']; ?>
                                                            </label>
                                                            <select id="inline_companion_banner" name="inline_companion_banner" class="form-select text-dark"></select>
                                                        </div>
                                                        <div class="col col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6"></div>
                                                    </div>
                                                </div>
                                                <!-- overlay -->
                                                <div class="col" id="overlayvideoad" style="display:none;">
                                                    <div class="row mb-2">
                                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                            <label class="form-label"><?php echo $GLOBALS['strOverlay_Type']; ?></label><br>
                                                            <select class="form-select text-dark mb-2" name="overlayType" id="overlayType" onchange="overlayad(this.value);">
                                                                <option value=""><?php echo $GLOBALS['strSelect_Overlay_Type']; ?></option>
                                                                <option value="image_overlay"><?php echo $GLOBALS['strImage_Overlay']; ?></option>
                                                                <option value="text_overlay"><?php echo $GLOBALS['strText_Overlay']; ?></option>
                                                                <option value="html_overlay"><?php echo $GLOBALS['strHTML_Overlay']; ?></option>
                                                            </select>
                                                            <p id="overlayaderrors" style="color:red;"></p>
                                                            <div class="col" id="imageoverlay" style="display:none;">
                                                                <b><?php echo $GLOBALS['overlay_image']; ?></b>
                                                                <hr>
                                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                    <?php echo $GLOBALS['upload_overlay_image']; ?>
                                                                </label>
                                                                <input type="file" class="form-control" id="overlayImage" name="overlayImage" onchange="preview()" />
                                                                <div class="col-6">
                                                                    <p id="overlayiamgeuploaderrors1" style="color:red"></p>
                                                                </div>
                                                            </div>
                                                            <div class="col" id="textoverlay" style="display:none;">
                                                                <b><?php echo $GLOBALS['overlay_text']; ?></b>
                                                                <hr>
                                                                <div>
                                                                    <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['title']; ?></label>
                                                                    <input type="text" class="form-control" name="textOverlay_title" id="textOverlay_title" placeholder="title" />
                                                                </div>
                                                                <div>
                                                                    <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['strInventory_Description']; ?></label>
                                                                    <textarea type="text" class="form-control" name="textOverlay_description" id="textOverlay_description" placeholder="Description"></textarea>
                                                                </div>
                                                                <div>
                                                                    <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['call_to_action']; ?></label>
                                                                    <input type="text" class="form-control" name="overlayText_callToAction" id="overlayText_callToAction" placeholder="Call to Action" />
                                                                </div>
                                                            </div>
                                                            <div class="col" id="htmloverlay" style="display:none;">
                                                                <b><?php echo $GLOBALS['overlay_html']; ?></b>
                                                                <hr>
                                                                <b><?php echo $GLOBALS['overlay_html_label']; ?></b>
                                                                <textarea type="text" class="form-control" name="overlayhtml" id="overlayhtml"></textarea>
                                                            </div>
                                                        </div>
                                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                            <div class="col">
                                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                    <?php echo $GLOBALS['strOverlay_Click_Action']; ?>
                                                                </label>
                                                                <select class="form-select text-dark" name="overlayClick_action" id="overlayClick_action" onchange="overlayclick(this.value)">
                                                                    <option value=""><?php echo $GLOBALS['strSelect_Overlay_Action']; ?></option>
                                                                    <option value="click_to_page"><?php echo $GLOBALS['strOpen_page_window']; ?></option>
                                                                    <option value="click_to_video"><?php echo $GLOBALS['strPlay_Video']; ?></option>
                                                                </select>
                                                                <p id="overlayclickerrors" style="color:red"></p>
                                                            </div>
                                                            <div class="col" id="overlayclickpage" style="display:none;">
                                                                <b><?php echo $GLOBALS['strWhen_user_clicks_overlay']; ?></b>
                                                                <hr>
                                                                <label class="form-label mb-2"><?php echo $GLOBALS['strDestination_URL']; ?></label>
                                                                <input type="text" name="overlay_destinationURL" id="overlay_destinationURL" class="form-control text-dark" onkeyup="inlineDestinationUrlValidation()" />
                                                                <p id="error_inlineDestinationURL" style="color:red"></p>
                                                            </div>
                                                            <div class="col" id="overlayclickaction" style="display:none;">
                                                                <b><?php echo $GLOBALS['overlay_click_action']; ?></b>
                                                                <hr>
                                                                <div>
                                                                    <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                        <?php echo $GLOBALS['strVideo_Delivery_Method']; ?>
                                                                    </label>
                                                                    <select class="form-select text-dark" name="vast_video_delivery" id="vast_video_delivery" onchange="overlayprogressivechange(this.value);">
                                                                        <option value=""><?php echo $GLOBALS['overlay_video_delivery']; ?></option>
                                                                        <option value="streaming"><?php echo $GLOBALS['strStreaming_RTMP']; ?></option>
                                                                        <option value="progressive"><?php echo $GLOBALS['strProgressive_HTTP']; ?></option>
                                                                    </select>
                                                                    <p id="overlayprogressiveerror" style="color:red;"></p>
                                                                </div>
                                                                <div class="col" id="overlaystrem" style="display:block;">
                                                                    <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                        <?php echo $GLOBALS['strRtmp_Server_URL']; ?>
                                                                    </label>
                                                                    <input type="text" name="overlayStreaming_rtmpServerURL" id="overlayStreaming_rtmpServerURL" class="form-control" onkeyup="overlayrtmUrl()" />
                                                                    <p id="overlayrtmp_urlerrors" style="color:red;"></p>
                                                                </div>
                                                                <div class="col" id="overlayprgs" style="display:none;">
                                                                    <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                        <?php echo $GLOBALS['video_url']; ?>
                                                                    </label>
                                                                    <input type="url" name="overlayProgressive_videoURL" id="overlayProgressive_videoURL" class="form-control" value="" onkeyup="overlayVideo_url()" />
                                                                    <p id="overlayProgressive_videoURLerror" style="color:red;"></p>
                                                                </div>
                                                                <div class="col" id="filenameoverlay">
                                                                    <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                        <?php echo $GLOBALS['strVIDEO_FILE_NAME']; ?>
                                                                    </label>
                                                                    <input type="text" name="overlay_videofile" id="overlay_videofile" class="form-control" value="" onkeyup="overlayvideofile()" />
                                                                    <p id="overlay_videofileerrors" style="color:red;"></p>
                                                                    <!-- <input type="text" name="rtmpurl" id="url"
                                                                            class="form-control"/> -->
                                                                </div>
                                                                <div id="getVideo-type">
                                                                    <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                        <?php echo $GLOBALS['strVIDEO TYPE']; ?>
                                                                    </label>
                                                                    <select id="video_type" name="video_type" class="form-select text-dark" onchange="overlayvedio_change()">
                                                                        <option selected value=""><?php echo $GLOBALS['strSelect_Video_Type']; ?></option>
                                                                        <option value="MP4"><?php echo $GLOBALS['strMP4']; ?></option>
                                                                        <!-- <option value="FLV">FLV</option>
                                                                            <option value="WEBM">WEBM</option> -->
                                                                    </select>
                                                                    <p id="overlayvideotypeerror" style="color:red;"></p>
                                                                </div>
                                                                <div>
                                                                    <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                                        <?php echo $GLOBALS['video_duration_in_seconds']; ?>
                                                                    </label>
                                                                    <input type="text" name="overlay_videoduration" id="overlay_videoduration" class="form-control" value="" onkeyup="overlayvedioduration()" />
                                                                    <p id="overlayvediop_durationerror" style="color:red;"></p>
                                                                </div>
                                                            </div>
                                                            <div class="row mb-2" id="overlay_companion">
                                                                <div class="col col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-6">
                                                                    <label class="form-label" style="font-size: 1.4ch;">
                                                                        <?php echo $GLOBALS['companion_banner']; ?>
                                                                    </label>
                                                                    <select id="overlay_companion_banner" name="overlay_companion_banner" class="form-select text-dark"></select>
                                                                </div>
                                                                <div class="col col-xs-12 col-sm-12 col-xxl-6"></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    
                                                    <!-- <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                        <div class="row justify-content-md-center mt-2">
                                                            <div id="bannerimage" style="display:none;">
                                                                <div class="col-8">
                                                                    <img id="frame" src="" class="img-fluid w-75" style="height:180px;" />
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div> -->
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row mt-3" id="ban_display" style="display:none;">
                                            <h4><?php echo $GLOBALS['ban_display']; ?></h4>
                                            <hr class="solid">
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6" id="txtall" >
                                                <label class="form-label mb-2">
                                                    <?php echo $GLOBALS['all_text']; ?></label>
                                                <input type="text" class="form-control text-dark" id="alltext" name="alltext" placeholder="Alt text">                                       
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6" id="txtsts" >
                                                <label class="form-label mb-2">
                                                    <?php echo $GLOBALS['status_text']; ?></label>
                                                <input type="text" class="form-control text-dark" id="statustext" name="statustext" placeholder="Status text">                                             
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6" id="txtimg" >
                                                <label class="form-label mt-3 mb-2">
                                                    <?php echo $GLOBALS['txt_blw_img']; ?></label>
                                                <input type="text" class="form-control text-dark" id="txtimgbelow" name="txtimgbelow" placeholder="Text below image" >
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6"></div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                                <button type="button" class="btn btn-outline-danger" onclick="onCancel()">
                                                    <?php echo $GLOBALS['strCancel']; ?>
                                                </button>&nbsp;
                                                <button type="button" class="btn btn-primary" id="submitbtn" onclick="Addbannerform()">
                                                    <?php echo $GLOBALS['strSubmit']; ?>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!-- / Content -->
                    <!-- Footer -->
                    <?php include('footer.php'); ?>
                    <!-- / Footer -->
                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <script src="../js/sweetalert.min.js"></script>
        <script>
            const token = 'Bearer ' + document.getElementById('token').value;
            const live_URL = '<?php echo $apiinvenpath; ?>';
            const image_path = '<?php echo $bannerpath; ?>';
            const revive_imagePath = '<?php echo $revivePath; ?>';
            var agencyid = document.getElementById('agencyid').value;
            let clientid = document.getElementById('clientid').value;
            let campaignid = document.getElementById('campaignid').value;
            let client_id = document.getElementById('client_id').value;
            let campaign_id = document.getElementById('campaign_id').value;
            let getParams = document.getElementById('campaign_params').value;
            let addBanner = live_URL + '/add_banner/';
            let uploadFile = "",
                bannerWidth, bannerHeight, fileWidth, fileHeight, imageType,
                bannerSize_disabledFiled, webImage_disabledFiled, sql_disabledFiled, url_disabledFiled,
                html_disabledFiled, html5_disabledFiled, urlFileFormat, getWidth, getHeight;
            let pattern = new RegExp(
                '^(https?:\\/\\/)?' + // protocol
                '((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|' + // domain name
                '((\\d{1,3}\\.){3}\\d{1,3}))' + // OR ip (v4) address
                '(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*' + // port and path
                '(\\?[;&a-z\\d%_.~+=-]*)?' + // query string
                '(\\#[-a-z\\d_]*)?$', // fragment locator
                'i'
            );
            document.getElementById('companion').style.display = "none";
            document.getElementById('overlay_companion').style.display = "none";

            //banner size dropdown
            const sizeArray = [{
                    id: 0,
                    key: "Select Size",
                    value: "select_size"
                },
                {
                    id: 1,
                    key: "IAB Full Banner (468 x 60)",
                    value: "468x60"
                },
                {
                    id: 2,
                    key: "IAB Skyscraper (120 x 600)",
                    value: "120x600"
                },
                {
                    id: 3,
                    key: "IAB Leaderboard (728 x 90)",
                    value: "728x90"
                },
                {
                    id: 4,
                    key: "IAB Button 1 (120 x 90)",
                    value: "120x90"
                },
                {
                    id: 5,
                    key: "IAB Button 2 (120 x 60)",
                    value: "120x60"
                },
                {
                    id: 6,
                    key: "IAB Micro Bar (88 x 31)",
                    value: "88x31"
                },
                {
                    id: 7,
                    key: "IAB Square Button (125 x 125)",
                    value: "125x125"
                },
                {
                    id: 8,
                    key: "IAB Vertical Banner (120 x 240)",
                    value: "120x240"
                },
                {
                    id: 9,
                    key: "IAB Rectangle (180 x 150)",
                    value: "180x150"
                },
                {
                    id: 10,
                    key: "IAB Medium Rectangle (300 x 250)",
                    value: "300x250"
                },
                {
                    id: 11,
                    key: "IAB Large Rectangle (336 x 280)",
                    value: "336x280"
                },
                {
                    id: 12,
                    key: "IAB Vertical Rectangle (240 x 400)",
                    value: "240x400"
                },
                {
                    id: 13,
                    key: "IAB Square Pop-up (250 x 250)",
                    value: "250x250"
                },
                {
                    id: 14,
                    key: "IAB Wide Skyscraper (160 x 600)",
                    value: "160x600"
                },
                {
                    id: 15,
                    key: "IAB Pop-Under (720 x 300)",
                    value: "720x300"
                },
                {
                    id: 16,
                    key: "IAB 3:1 Rectangle (300 x 100)",
                    value: "300x100"
                },
                {
                    id: 17,
                    key: "Custom",
                    value: "custom"
                }
            ];

            let viewArray = sizeArray.map((data, index) => {
                return `<option key=${index} value=${data.value}>${data.key}</option>`;
            });
            document.getElementById('bannerSize').innerHTML = viewArray;

            get_advertiser = () => {
                $.ajax({
                    type: "GET",
                    url: live_URL + '/get_all_advertiser/' + agencyid,
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    dataType: "json",
                    encode: true,
                }).done(function(data) {
                    var client_name = [];
                    //defaultValue = `<option value="0" selected><?php echo $GLOBALS['select_campaign']; ?></option>`;
                    data.data.map((data) => {
                        getclientLength = (data.clientname.length > 30) ? (data.clientname.slice(0, 30) + '...') : data.clientname;
                        client_name += `<option value=${data.clientid} title="${data.clientname}">${getclientLength}</option>`;
                        document.getElementById('advertiser_name').innerHTML = client_name;
                    });
                    if (client_id != '') {
                        $('#advertiser_name').val(client_id);
                        $('#advertiser_name').attr("disabled", true);
                    } else {
                        $('#advertiser_name').val(clientid);
                        $('#advertiser_name').attr("disabled", true);
                    }
                    getCampaign();
                });
            }

            getCampaign = (action) => {
                let client;
                if (action) {
                    client = $('#advertiser_name').val();
                } else if (client_id != '') {
                    client = client_id;
                } else {
                    client = clientid;
                }
                document.getElementById('bannerSize').disabled = true;
                bannerSize_disabledFiled = true;
                $(".loader").show();

                $.ajax({
                    type: "GET",
                    url: live_URL + '/get_all_campaigns/' + client,
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    dataType: "json",
                    encode: true,
                }).done(function(data) {
                    $(".loader").hide();
                    let cam_name = [],
                        getLength,
                        defaultValue = `<option value="0" selected><?php echo $GLOBALS['select_campaign']; ?></option>`;
                    data.data.map((data, index) => {
                        getLength = (data.campaignname.length > 35) ? (data.campaignname.slice(0, 35) + '...') : data.campaignname;
                        cam_name += `<option key=${index} value=${data.campaignid} title="${data.campaignname}" class='text-wrap text-break'>${getLength}</option>`;
                    });
                    document.getElementById('campaignName').innerHTML = defaultValue + cam_name;
                    if (!action) {
                        if (client_id != '') {
                            $('#campaignName').val(campaign_id);
                            $('#campaignName').attr("disabled", true);
                        } else if (campaign_id != '') {
                        $('#campaignName').val(campaign_id);
                        $('#campaignName').attr("disabled", true);
                    } else {
                            $('#campaignName').val(campaignid);
                        }
                    }
                });
            };

            // selectedadvertiser=()=>{
            //     let advertiser_value = document.getElementById('advertiser_name').value;
            //     document.getElementById('error_advertiser').innerHTML = advertiser_value == 0 ? `<?php echo $GLOBALS[''];
            echo "select orders/jobs"; ?>` : "";

            // }

            getSelectedCampaign = () => {
                let campaign_value = document.getElementById('campaignName').value;
                document.getElementById('error_campaign').innerHTML = campaign_value == 0 ? `<?php echo $GLOBALS['select_campaign']; ?>` : "";
                getCompanionBanner(campaign_value);
            };

            getCompanionBanner = (campaignId) => {
                $.ajax({
                    type: "GET",
                    url: live_URL + '/get_campaignwise_companion_banner/' + campaignId,
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    dataType: "json",
                    encode: true,
                }).done(function(data) {
                    if (data.data) {
                        document.getElementById('companion').style.display = "block";
                        document.getElementById('overlay_companion').style.display = "block";
                        let campanion_array = [],
                            getCompanionBannerLength,
                            defaultValue = `<option value="0" selected><?php echo $GLOBALS['select_companion_banner']; ?></option>`;
                        data.data.map((data, index) => {
                            getCompanionBannerLength = (data.bannername.length > 30) ? (data.bannername.slice(0, 35) + '...') : data.bannername;
                            campanion_array += `<option key=${index} value=${data.bannerid}>${getCompanionBannerLength}</option>`;
                        });
                        document.getElementById('inline_companion_banner').innerHTML = defaultValue + campanion_array;
                        document.getElementById('overlay_companion_banner').innerHTML = defaultValue + campanion_array;
                    }
                });
            };

            async function preview() {
                let form_Data = new FormData();
                let bannert_type = document.getElementById('bannert_type').value;

                frame.src = URL.createObjectURL(event.target.files[0]);
                $(".loader").show();

                imageType = event.target.files[0].type == "image/jpeg" ? "jpeg" :
                    event.target.files[0].type == "image/png" ? "png" :
                    event.target.files[0].type == "image/gif" ? "gif" :
                    event.target.files[0].type == "application/zip" ? "zip" :
                    event.target.files[0].type == "application/x-zip-compressed" ? "zip" : "";

                if (bannert_type == 'web') {
                    if (event.target.files[0].type == "image/jpeg" || event.target.files[0].type == "image/png" ||
                        event.target.files[0].type == "image/gif") {
                        document.getElementById("webuploaderrors").innerHTML = "";
                        form_Data.append("filetype", bannert_type);
                        form_Data.append("internal_file", formFile.files[0]);
                        // document.getElementById("frame").style.display = "block";
                    } else {
                        document.getElementById("webuploaderrors").innerHTML = `<?php echo $GLOBALS['image_format']; ?>`;
                    }
                } else if (bannert_type == 'sql') {
                    if (event.target.files[0].type == "image/jpeg" || event.target.files[0].type == "image/png" || event.target.files[0].type == "image/gif") {
                        document.getElementById("sqlerrors").innerHTML = "";
                        form_Data.append("filetype", bannert_type);
                        form_Data.append("internal_file", sqlban.files[0]);
                        // document.getElementById("frame").style.display = "block";
                    } else {
                        document.getElementById("sqlerrors").innerHTML = `<?php echo $GLOBALS['image_format']; ?>`;
                    }
                } else if (bannert_type == 'html5') {
                    document.getElementById("frame").style.display = "none";

                    if (event.target.files[0].type == "application/zip") {

                        form_Data.append("filetype", bannert_type);
                        form_Data.append("internal_file", html5ban.files[0]);
                        document.getElementById("html5_bannerError").innerHTML = "";
                    } else if (event.target.files[0].type == "application/x-zip-compressed") {
                        form_Data.append("filetype", bannert_type);
                        form_Data.append("internal_file", html5ban.files[0]);
                        document.getElementById("html5_bannerError").innerHTML = "";
                    } else {
                        document.getElementById("html5_bannerError").innerHTML = `<?php echo $GLOBALS['strBanner_HTML5_validation']; ?>`;
                    }
                } else if (bannert_type == 'overlay') {
                    preview.src = URL.createObjectURL(event.target.files[0]);
                    //document.getElementById("frame").style.display = "block";
                    form_Data.append("filetype", bannert_type);
                    form_Data.append("internal_file", overlayImage.files[0]);
                }

                $.ajax({
                    type: "POST",
                    url: live_URL + '/image_upload',
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: form_Data,
                    dataType: "json",
                    contentType: false,
                    processData: false,
                    // encode: true,
                }).done(function(data) {

                    // image_id = data.filename;
                    $(".loader").hide();
                    uploadFile = bannert_type == 'html5' ? revive_imagePath + data.filename :
                        bannert_type == 'web' ? revive_imagePath + data.filename :
                        bannert_type == 'sql' ? revive_imagePath + data.filename :
                        bannert_type == 'overlay' ? revive_imagePath + data.filename : "";

                    let image = new Image();
                    image.src = bannert_type == "web" ? revive_imagePath + data.filename :
                        bannert_type == "sql" ? revive_imagePath + data.filename : "";
                    image.onload = function() {
                        fileWidth = this.width;
                        fileHeight = this.height;
                        if (Number(bannerWidth) == fileWidth && Number(bannerHeight) == fileHeight) {
                            document.getElementById('bannerimage').style.display = "block";
                            document.getElementById('webuploaderrors').innerHTML = "";
                            document.getElementById('sqlerrors').innerHTML = "";
                        } else {
                            document.getElementById('bannerimage').style.display = "none";
                            document.getElementById('webuploaderrors').innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(bannerWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(bannerHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                            document.getElementById('sqlerrors').innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(bannerWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(bannerHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                        }
                    };
                });
                // formFile.files[0].name, html5ban.files[0].name, sqlban.files[0].name, overlayImage.files[0].name

                // let image = new Image();
                // image.src = bannert_type =="web"?'https://revphpe.djaxbidder.com/revivemohan/www/images/'+formFile.files[0].name:
                //     bannert_type =="sql"?image_path+'/'+sqlban.files[0].name:"";
                // image.onload = function() {
                //     fileWidth = this.width;
                //     fileHeight = this.height;
                //     if(Number(bannerWidth) == fileWidth && Number(bannerHeight) == fileHeight) {
                //         document.getElementById('bannerimage').style.display = "block";
                //         document.getElementById('webuploaderrors').innerHTML = "";
                //         document.getElementById('sqlerrors').innerHTML = "";
                //     }
                //     else {
                //         document.getElementById('bannerimage').style.display = "none";
                //         document.getElementById('webuploaderrors').innerHTML = `<?php echo $GLOBALS['file_width']; ?>`+Number(bannerWidth)+`<?php echo $GLOBALS['file_height']; ?>`+Number(bannerHeight)+`<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                //         document.getElementById('sqlerrors').innerHTML = `<?php echo $GLOBALS['file_width']; ?>`+Number(bannerWidth)+`<?php echo $GLOBALS['file_height']; ?>`+Number(bannerHeight)+`<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                //     }
                // };
            };

            banner_type = () => {
                let bannerValue = document.getElementById("bannert_type").value;
                document.getElementById("errors1").innerHTML = bannerValue !== "" ? "" : `<?php echo $GLOBALS['select_a_type']; ?>`;
                document.getElementById("main_destination").style.display = bannerValue == "overlay" ? "none" : "block";

                document.getElementById("getBannerSize").style.display = bannerValue == "txt" ? "none" :
                    bannerValue == "inline" ? "none" :
                    bannerValue == "overlay" ? "none" : "block";

                document.getElementById("bannerimage").style.display = (bannerValue == "web" || bannerValue == "sql") ? "block" : "none";

                document.getElementById("htmlbanner").style.display = bannerValue == "html" ? "block" : "none";
                document.getElementById("html5banner").style.display = bannerValue == "html5" ? "block" : "none";
                document.getElementById("inlinevideoad").style.display = bannerValue == "inline" ? "block" : "none";
                document.getElementById("overlayvideoad").style.display = bannerValue == "overlay" ? "block" : "none";
                document.getElementById("bannerarea").style.display = bannerValue == "block";
                document.getElementById('bannerSize').disabled = bannerValue == "" ? true : false;
                bannerSize_disabledFiled = bannerValue == "" ? true : false;
                if (bannerValue == "") {
                    document.getElementById('errors2').innerHTML = "";
                }

                document.getElementById("bannerimage").style.display = "none";
                document.getElementById("custom").style.display = bannerValue == "inline" ? "none" :
                    bannerValue == "overlay" ? "none" : bannerValue == "txt" ? "none" : "none";
                document.getElementById('bannerSize').value = "select_size";
                document.getElementById('desurl').value = "";
                document.getElementById('name').value = "";
                //web
                document.getElementById("webbanner").style.display = bannerValue == "web" ? "block" : "none";
                document.getElementById('formFile').disabled = true;
                document.getElementById('formFile').value = "";
                document.getElementById('webuploaderrors').innerHTML = "";
                webImage_disabledFiled = true;
                //sql
                document.getElementById("sqlbanner").style.display = bannerValue == "sql" ? "block" : "none";
                document.getElementById('sqlban').disabled = true;
                document.getElementById('sqlban').value = "";
                sql_disabledFiled = true;
                //URL
                document.getElementById("urlbanner").style.display = bannerValue == "url" ? "block" : "none";
                document.getElementById('bannerurl').disabled = true;
                document.getElementById('bannerurl').value = "";
                document.getElementById('errors3').innerHTML = "";
                url_disabledFiled = true;
                //text
                document.getElementById("textbanner").style.display = bannerValue == "txt" ? "block" : "none";
                document.getElementById('bannertext').value = "";
                //html 
                document.getElementById('htmlBanner').disabled = true;
                document.getElementById('htmlBanner').value = "";
                document.getElementById('htmlerror').innerHTML = "";
                html_disabledFiled = true;
                //html5
                document.getElementById('html5ban').disabled = true;
                document.getElementById('html5ban').value = "";
                document.getElementById('html5_bannerError').innerHTML = "";
                html5_disabledFiled = true;
                // document.getElementById('req_destinationURL').style.display = bannerValue == "html5"?"none":"compact";

                if(bannerValue == "web" || bannerValue == "sql" || bannerValue =="url"){
                    document.getElementById("ban_display").style.display="flex";
                    document.getElementById("txtall").style.display="block";
                    document.getElementById("txtsts").style.display="block";
                    document.getElementById("txtimg").style.display="block";
                }else if(bannerValue =="txt"){
                    document.getElementById("ban_display").style.display="flex";
                    document.getElementById("txtall").style.display="none";
                    document.getElementById("txtsts").style.display="block";
                    document.getElementById("txtimg").style.display="none";
                }else{
                    document.getElementById("ban_display").style.display="none";
                    document.getElementById("txtall").style.display="none";
                    document.getElementById("txtsts").style.display="none";
                    document.getElementById("txtimg").style.display="none";
                }
            };

            overlayclick = (selectclickaction) => {
                document.getElementById("overlayclickpage").style.display = selectclickaction == 'click_to_page' ? "block" : "none";
                document.getElementById("overlayclickaction").style.display = selectclickaction == 'click_to_video' ? "block" : "none";
                document.getElementById("overlayclickerrors").innerHTML = selectclickaction == "" ? `<?php echo $GLOBALS['strBanner_Overlayclick_Action_validation']; ?>` : "";
            };

            overlayad = (overlayadselect) => {
                document.getElementById("imageoverlay").style.display = overlayadselect == 'image_overlay' ? "block" : "none";
                document.getElementById("bannerimage").style.display = overlayadselect == 'image_overlay' ? "block" : "none";
                document.getElementById("textoverlay").style.display = overlayadselect == 'text_overlay' ? "block" : "none";
                document.getElementById("htmloverlay").style.display = overlayadselect == 'html_overlay' ? "block" : "none";
                document.getElementById("overlayaderrors").innerHTML = overlayadselect == "" ? `<?php echo $GLOBALS['strBanner_Overlaytype_validation']; ?>` : "";
            };

            custom_select = (sizeselect) => {
                if (sizeselect == "custom") {
                    bannerWidth = document.getElementById('width').value;
                    bannerHeight = document.getElementById('height').value;
                } else {
                    let getBanner_size = sizeselect.split("x");
                    bannerWidth = getBanner_size[0];
                    bannerHeight = getBanner_size[1];
                }

                document.getElementById("bannerimage").style.display = "none";
                document.getElementById("custom").style.display = sizeselect == 'custom' ? "block" : "none";
                document.getElementById("errors2").innerHTML = sizeselect !== "select_size" ? "" : `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
                document.getElementById('webuploaderrors').innerHTML = "";
                //web
                document.getElementById('formFile').value = "";
                document.getElementById('formFile').disabled = sizeselect == "select_size" ? true : false;
                webImage_disabledFiled = sizeselect == "select_size" ? true : false;
                if (sizeselect == "select_size") {
                    document.getElementById('webuploaderrors').innerHTML = "";
                }
                //sql
                document.getElementById('sqlban').value = "";
                document.getElementById('sqlban').disabled = sizeselect == "select_size" ? true : false;
                sql_disabledFiled = sizeselect == "select_size" ? true : false;
                if (sizeselect == "select_size") {
                    document.getElementById('sqlerrors').innerHTML = "";
                }
                //url
                document.getElementById('bannerurl').value = "";
                document.getElementById('errors3').innerHTML = "";
                document.getElementById('bannerurl').disabled = sizeselect == "select_size" ? true : false;
                url_disabledFiled = sizeselect == "select_size" ? true : false;
                if (sizeselect == "select_size") {
                    document.getElementById('errors3').innerHTML = "";
                }
                //html 
                document.getElementById('htmlBanner').disabled = sizeselect == "select_size" ? true : false;
                html_disabledFiled = sizeselect == "select_size" ? true : false;
                if (sizeselect == "select_size") {
                    document.getElementById('htmlerror').innerHTML = "";
                }
                //html 5
                document.getElementById('html5ban').disabled = sizeselect == "select_size" ? true : false;
                html5_disabledFiled = sizeselect == "select_size" ? true : false;
                if (sizeselect == "select_size") {
                    document.getElementById('html5_bannerError').innerHTML = "";
                }
            };

            progressivechange = () => {
                let select = document.getElementById('inlineVideo-deliveryType').value;
                document.getElementById("prgs").style.display = select == 'progressive' ? "block" : "none";
                document.getElementById("strem").style.display = select == 'streaming' ? "block" : select == "" ? "block" : "none";
                document.getElementById("filename").style.display = select == 'streaming' ? "block" : select == "" ? "block" : "none";
                document.getElementById("vediodeliveryerrors").innerHTML = select == "" ? `<?php echo $GLOBALS['select_delivery_method']; ?>` : "";
                document.getElementById("inline_videoType").style.display = select == "" || select == 'progressive' || select == "streaming" ? "block" : "none";
                document.getElementById("inline_videoduration").style.display = select == "" || select == 'progressive' || select == "streaming" ? "block" : "none";
            };

            overlayprogressivechange = (select) => {
                document.getElementById("overlayprgs").style.display = select == 'progressive' ? "block" : "none";
                document.getElementById("overlaystrem").style.display = select == 'streaming' ? "block" : "none";
                document.getElementById("filenameoverlay").style.display = select == 'streaming' ? "block" : "none";
                document.getElementById("overlayprogressiveerror").innerHTML = select == "" ? `<?php echo $GLOBALS['strBanner_Selectvedio_validation']; ?>` : "";
            };

            submit = () => {
                //general fileds
                let order_value = document.getElementById('advertiser_name').value;
                let campaign_value = document.getElementById('campaignName').value;
                let name = document.getElementById('name').value;
                let banner = document.getElementById("bannert_type").value;
                let bannerSize = document.getElementById("bannerSize").value;
                let widthval = document.getElementById('width').value;
                let heightval = document.getElementById('height').value;
                let url = document.getElementById('desurl').value;
                let getWeight = document.getElementById('banner_weight').value;

                //web
                let formFile = document.getElementById('formFile').value;
                //sql
                let sqlban = document.getElementById('sqlban').value;
                //url
                let urlBanner = document.getElementById("bannerurl").value;
                //text
                let bannertext = document.getElementById('bannertext').value;
                //html
                let htmlBanner = document.getElementById("htmlBanner").value;
                //html5
                let html5ban = document.getElementById('html5ban').value;
                //inline
                let videofilename = document.getElementById("inline_videofile").value;
                let videofiletype = document.getElementById('inline_videoType').value;
                let videoduration = document.getElementById('inline_videoduration').value;
                let inlineVideodeliveryType = document.getElementById('inlineVideo-deliveryType').value;
                let rtms_server = document.getElementById('rtmp_serverURL').value;
                let inline_progressive_videoURL = document.getElementById('video_URL').value;
                //overlay
                let overlayType = document.getElementById('overlayType').value;
                let overlayClick_action = document.getElementById("overlayClick_action").value;
                let vastvideo_delivery = document.getElementById('vast_video_delivery').value;
                let overlayVideourl = document.getElementById('overlayProgressive_videoURL').value;
                let overlayrtm = document.getElementById('overlayStreaming_rtmpServerURL').value;
                let overlayvideofile = document.getElementById('overlay_videofile').value;
                let overlayvideochange = document.getElementById('video_type').value;
                let overlayvideoduration = document.getElementById('overlay_videoduration').value;

                if (name == "" && banner == "" && bannerSize == "select_size" && bannerSize_disabledFiled == false) {
                    document.getElementById("errors").innerHTML = `<?php echo $GLOBALS['strName_validation']; ?>`;
                    document.getElementById("errors1").innerHTML = `<?php echo $GLOBALS['select_a_type']; ?>`;
                    document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
                } else if (name == "" && banner == "") {
                    document.getElementById("errors").innerHTML = `<?php echo $GLOBALS['strName_validation']; ?>`;
                    document.getElementById("errors1").innerHTML = `<?php echo $GLOBALS['select_a_type']; ?>`;
                } else if (banner == "" && bannerSize == "select_size" && bannerSize_disabledFiled == false) {
                    document.getElementById("errors1").innerHTML = `<?php echo $GLOBALS['select_a_type']; ?>`;
                    document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
                } else if (name == "" && bannerSize == "select_size" && bannerSize_disabledFiled == false) {
                    document.getElementById("errors").innerHTML = `<?php echo $GLOBALS['strName_validation']; ?>`;
                    document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
                } else if (name == "") {
                    document.getElementById("errors").innerHTML = `<?php echo $GLOBALS['strName_validation']; ?>`;
                } else if (bannerSize == "select_size" && bannerSize_disabledFiled == false) {
                    document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
                } else if (banner == "") {
                    document.getElementById("errors1").innerHTML = `<?php echo $GLOBALS['select_a_type']; ?>`;
                } else {
                    document.getElementById("errors").innerHTML = "";
                    document.getElementById("errors1").innerHTML = "";
                    document.getElementById("errors2").innerHTML = "";
                }
                document.getElementById('error_weight').innerHTML = getWeight == "" ? `<?php echo $GLOBALS['weight_validation']; ?>` : getWeight > 0 ? "" :
                    `<?php echo $GLOBALS['strValue_Greaterthen_Zero']; ?>`;

                //banner width and height
                document.getElementById("errorsheight").innerHTML = (heightval == "") ? `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>` :
                    (bannerSize == "custom" && heightval == 0) ? `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>` : "";
                document.getElementById("errorswidth").innerHTML = (widthval == "") ? `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>` :
                    (bannerSize == "custom" && widthval == 0) ? `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>` : "";

                document.getElementById('error_campaign').innerHTML = (campaign_id == "" && campaign_value == 0) ?
                    `<?php echo $GLOBALS['select_campaign']; ?>` : "";
                document.getElementById("error_destinationURL").innerHTML = (banner == 'html' && (url == "" || url !== "")) ? "" :
                    url == "" ? `<?php echo $GLOBALS['enter_destination_url']; ?>` : "";
                //web
                document.getElementById("webuploaderrors").innerHTML = (formFile == "" && webImage_disabledFiled == false) ? `<?php echo $GLOBALS['strBanner_Upload_Image_validation']; ?>` : "";
                //sql
                document.getElementById("sqlerrors").innerHTML = (sqlban == "" && sql_disabledFiled == false) ? `<?php echo $GLOBALS['strBanner_Upload_Image_validation']; ?>` : "";
                // url
                document.getElementById("errors3").innerHTML = (urlBanner == "" && url_disabledFiled == false) ? `<?php echo $GLOBALS['strBanner_URL_validation']; ?>` :
                    (pattern.test(urlBanner) == false && url_disabledFiled == false) ? `<?php echo $GLOBALS['enter_valid_url']; ?>` :
                    (banner == "url" && urlBanner !== "" && urlFileFormat == false) ? `<?php echo $GLOBALS['strBanner_Upload_Imagetype_validation']; ?>` :
                    (banner == 'url' && getWidth !== Number(bannerWidth) && getHeight !== Number(bannerHeight)) ? `<?php echo $GLOBALS['file_width']; ?>` + Number(bannerWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(bannerHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>` : "";
                //text
                document.getElementById("bannertexterror").innerHTML = bannertext == "" ? `<?php echo $GLOBALS['enter_the_text']; ?>` : "";
                //html
                document.getElementById("htmlerror").innerHTML = (htmlBanner == "" && html_disabledFiled == false) ? `<?php echo $GLOBALS['strBanner_HTML_validation']; ?>` : "";
                //html5
                document.getElementById("html5_bannerError").innerHTML = (html5ban == "" && html5_disabledFiled == false) ? `<?php echo $GLOBALS['strBanner_Upload_Image_validation']; ?>` : "";
                //inline
                document.getElementById("vediodeliveryerrors").innerHTML = (banner == "inline" && inlineVideodeliveryType == "") ?
                    `<?php echo $GLOBALS['strBanner_Videodelivery_Method_validation']; ?>` : "";
                document.getElementById("vediourlerrors").innerHTML = (banner == "inline" && videofilename == "") ?
                    `<?php echo $GLOBALS['strBanner_Vediofile_Name_validation']; ?>` : "";
                document.getElementById("vediofiletypeerrors").innerHTML = (banner == "inline" && videofiletype == "") ?
                    `<?php echo $GLOBALS['strBanner_Videofile_Type_validation']; ?>` : "";
                document.getElementById("rtms_server_url").innerHTML = (banner == "inline" && rtms_server == "") ?
                    `<?php echo $GLOBALS['strBanner_Videofile_Type_validation']; ?>` : "";
                document.getElementById("vediodurationerrors").innerHTML = (banner == "inline" && videoduration == "") ?
                    `<?php echo $GLOBALS['enter_the_video_duration']; ?>` : "";
                document.getElementById("error_progressive_videoUrl").innerHTML = (banner == "inline" && inlineVideodeliveryType == "progressive" && inline_progressive_videoURL == "") ?
                    `<?php echo $GLOBALS['strBanner_URL_validation']; ?>` : "";

                if (banner == "web" && formFile !== "" && Number(bannerWidth) !== fileWidth) {
                    document.getElementById('bannerimage').style.display = "none";
                    document.getElementById('webuploaderrors').innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(bannerWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(bannerHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                } else if (banner == "sql" && sqlban !== "" && Number(bannerWidth) !== fileWidth) {
                    document.getElementById('bannerimage').style.display = "none";
                    document.getElementById('sqlerrors').innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(bannerWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(bannerHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                } else if ((banner == "web" && formFile == "") || (banner == "sql" && sqlban == "")) {
                    document.getElementById('bannerimage').style.display = "none";
                } else {
                    document.getElementById('bannerimage').style.display = banner == "web" ? "block" :
                        banner == "sql" ? "block" : banner == "overlay" ? "block" : "none";
                    document.getElementById('webuploaderrors').innerHTML = "";
                    document.getElementById('sqlerrors').innerHTML = "";
                }
                if (banner == "web" && formFile !== "" && Number(bannerHeight) !== fileHeight) {
                    document.getElementById('bannerimage').style.display = "none";
                    document.getElementById('webuploaderrors').innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(bannerWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(bannerHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                } else if (banner == "sql" && sqlban !== "" && Number(bannerHeight) !== fileHeight) {
                    document.getElementById('bannerimage').style.display = "none";
                    document.getElementById('sqlerrors').innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(bannerWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(bannerHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                } else if ((banner == "web" && formFile == "") || (banner == "sql" && sqlban == "")) {
                    document.getElementById('bannerimage').style.display = "none";
                } else {
                    document.getElementById('bannerimage').style.display = banner == "web" ? "block" :
                        banner == "sql" ? "block" : banner == "overlay" ? "block" : "none";
                    document.getElementById('webuploaderrors').innerHTML = "";
                    document.getElementById('sqlerrors').innerHTML = "";
                }

                //overlay
                document.getElementById("overlayaderrors").innerHTML = (banner == "overlay" && overlayType == "") ? `<?php echo $GLOBALS['strBanner_Overlaytype_validation']; ?>` : "";
                document.getElementById("overlayclickerrors").innerHTML = (banner == "overlay" && overlayClick_action == "") ? `<?php echo $GLOBALS['strBanner_Overlayclick_Action_validation']; ?>` : "";
                document.getElementById("overlayprogressiveerror").innerHTML = (banner == "overlay" && vastvideo_delivery == "") ? `<?php echo $GLOBALS['strSelect_Video_Type']; ?>` : "";
                document.getElementById("overlayrtmp_urlerrors").innerHTML = (banner == "overlay" && overlayrtm == "") ? `<?php echo $GLOBALS['strBanner_RTMSserver_URL_validation']; ?>` : "";
                document.getElementById("overlay_videofileerrors").innerHTML = (banner == "overlay" && overlayvideofile == "") ? `<?php echo $GLOBALS['strBanner_Vediofile_Name_validation']; ?>` : "";
                document.getElementById("overlayvideotypeerror").innerHTML = (banner == "overlay" && overlayvideochange == "") ? `<?php echo $GLOBALS['strSelect_Video_Type']; ?>` : "";
                document.getElementById("overlayvediop_durationerror").innerHTML = (banner == "overlay" && overlayvideoduration == "") ? `<?php echo $GLOBALS['select_video_duration']; ?>` : "";
                document.getElementById("overlayProgressive_videoURLerror").innerHTML = (banner == "overlay" && overlayVideourl == "") ? `<?php echo $GLOBALS['enter_the_url']; ?>` : "";
            };

            Addbannerform = () => {

                submit();
                // Basic Information
                let width, height, formData;
                let advertiser = $('#advertiser_name').val();
                let campaign = $('#campaignName').val();
                let description = document.getElementById('name').value;
                let storagetype = document.getElementById('bannert_type').value;
                let url = document.getElementById('desurl').value;
                let banner_size = document.getElementById('bannerSize').value;
                if (banner_size == "custom") {
                    width = document.getElementById('width').value;
                    height = document.getElementById('height').value;
                } else {
                    const sizes = banner_size.split("x");
                    width = sizes[0];
                    height = sizes[1];
                }
                let getWeight = document.getElementById('banner_weight').value;

                //web
                let web_imageURL = document.getElementById('formFile').value;
                let webImage_path = web_imageURL == "" ? "" : uploadFile;
                //sql
                let sqlBanner_imageURL = document.getElementById('sqlban').value;
                let sqlImage_path = sqlBanner_imageURL == "" ? "" : uploadFile;
                //URL Banner
                let urlBanner_imageURL = document.getElementById('bannerurl').value;
                //Text Banner
                let bannertext = document.getElementById('bannertext').value;
                // HTML Banner
                let html_banner = document.getElementById('htmlBanner').value;
                //HTML5 Banner
                let html5_banner = document.getElementById('html5ban').value;
                //inline Banner
                let videoDelivery_method = document.getElementById('inlineVideo-deliveryType').value;
                let videoFile_name = document.getElementById('inline_videofile').value;
                let inline_videoDuration = document.getElementById('inline_videoduration').value;
                let inline_videoType = document.getElementById('inline_videoType').value;
                let inline_videoURL = document.getElementById('video_URL').value;
                let campaign_value = document.getElementById('campaignName').value;
                let rtms_server = document.getElementById('rtmp_serverURL').value;
                let companionBanner = document.getElementById('inline_companion_banner').value;
                //overlay banner
                let getOverlay_type = document.getElementById('overlayType').value;
                let getOverlayClick_action = document.getElementById('overlayClick_action').value;
                let vastVideo_delivery = document.getElementById('vast_video_delivery').value;
                let overlayRTMP_serverURL = document.getElementById('overlayStreaming_rtmpServerURL').value;
                let overlayVideo_fileName = document.getElementById('overlay_videofile').value;
                let getVideoType = document.getElementById('video_type').value;
                let getVideoduration = document.getElementById('overlay_videoduration').value;
                let overlayProgressive_videoURL = document.getElementById('overlayProgressive_videoURL').value;
                let overlayText_title = document.getElementById('textOverlay_title').value;
                let overlayText_description = document.getElementById('textOverlay_description').value;
                let overlayText_callToAction = document.getElementById('overlayText_callToAction').value;
                let overlayHTML_label = document.getElementById('overlayhtml').value;
                let overlay_destinationURL = document.getElementById('overlay_destinationURL').value;
                let overlay_companionBanner = document.getElementById('overlay_companion_banner').value;
                let alltext = document.getElementById('alltext').value;
                let statustext = document.getElementById('statustext').value;
                let txtimgbelow = document.getElementById('txtimgbelow').value;

                switch (storagetype) {
                    case 'web':
                        formData = {
                            "description": description,
                            "alt":alltext,
                            "statustext":statustext,
                            "txtimgbelow":txtimgbelow,
                            "contenttype": imageType,
                            "storagetype": "web",
                            "url": url,
                            "imageurl": webImage_path,
                            "width": width,
                            "height": height,
                            "weight": getWeight
                        };
                        break;
                    case 'sql':
                        formData = {
                            "description": description,
                            "alt":alltext,
                            "statustext":statustext,
                            "txtimgbelow":txtimgbelow,
                            "contenttype": imageType,
                            "storagetype": "sql",
                            "url": url,
                            "imageurl": sqlImage_path,
                            "width": width,
                            "height": height,
                            "weight": getWeight
                        };
                        break;
                    case 'url':
                        formData = {
                            "description": description,
                            "alt":alltext,
                            "statustext":statustext,
                            "txtimgbelow":txtimgbelow,
                            "contenttype": "png",
                            "storagetype": "url",
                            "imageurl": urlBanner_imageURL,
                            "url_banner_imageurl": urlBanner_imageURL,
                            "width": width,
                            "height": height,
                            "url": url,
                            "weight": getWeight
                        };
                        break;
                    case 'txt':
                        formData = {
                            "description": description,
                            "statustext":statustext,
                            "contenttype": "txt",
                            "storagetype": "txt",
                            "url": url,
                            "bannertext": bannertext,
                            "ext_bannertype": "bannerTypeText:oxText:genericText",
                            "weight": getWeight
                        };
                        break;
                    case 'html':
                        formData = {
                            "description": description,
                            "storagetype": "html",
                            "contenttype": "html",
                            "url": url,
                            "width": width,
                            "height": height,
                            "htmltemplate": html_banner,
                            "ext_bannertype": "bannerTypeHtml:oxHtml:genericHtml",
                            "weight": getWeight
                        };
                        break;
                    case 'html5':
                        formData = {
                            "description": description,
                            "storagetype": "html",
                            "contenttype": "zip",
                            "url": url,
                            "width": width,
                            "height": height,
                            "filename": uploadFile,
                            "ext_bannertype": "bannerTypeHtml:oxHtml:html5",
                            "weight": getWeight
                        };
                        break;
                    case 'inline':
                        formData = {
                            "description": description,
                            "storagetype": "html",
                            "url": url,
                            "vast_video_delivery": videoDelivery_method,
                            "vast_video_outgoing_filename": videoDelivery_method == "streaming" ? rtms_server + "/" + videoFile_name : inline_videoURL,
                            "vast_video_duration": inline_videoDuration,
                            "vast_video_type": inline_videoType,
                            "width": "-2",
                            "height": "-2",
                            "vast_video_clickthrough_url": url,
                            "vast_companion_banner_id": companionBanner,
                            // "vast_video_clickthrough_url":videoDelivery_method == "streaming"?rtms_server:inline_videoURL
                            "ext_bannertype": "bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml",
                            "weight": getWeight
                        };
                        break;
                    case 'overlay':
                        formData = {
                            "description": description,
                            "storagetype": "html",
                            "url": overlay_destinationURL == "" ? "" : overlay_destinationURL,
                            "ext_bannertype": "bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml",
                            "vast_creative_type": "jpeg",
                            "vast_overlay_action": getOverlayClick_action,
                            "vast_overlay_format": getOverlay_type,
                            "vast_video_delivery": vastVideo_delivery,
                            "vast_video_clickthrough_url": vastVideo_delivery == "streaming" ? overlayRTMP_serverURL : overlayProgressive_videoURL,
                            "vast_video_outgoing_filename": overlayVideo_fileName,
                            "vast_video_type": getVideoType,
                            "vast_video_duration": getVideoduration,
                            "vast_companion_banner_id": overlay_companionBanner,
                            // overlay-image
                            "imageurl": uploadFile == "" ? "" : uploadFile,
                            //text overlay
                            "vast_overlay_text_title": overlayText_title,
                            "vast_overlay_text_description": overlayText_description,
                            "vast_overlay_text_call": overlayText_callToAction,
                            //html overlay
                            "htmltemplate": overlayHTML_label == "" ? "" : overlayHTML_label,
                            "weight": getWeight

                        };
                        break;
                };

                if (campaign_id == "" && campaign_value == 0) {
                    document.getElementById('error_campaign').innerHTML = `<?php echo $GLOBALS['select_campaign']; ?>`;
                } else if (description == "") {
                    document.getElementById("errors").innerHTML = `<?php echo $GLOBALS['strName_validation']; ?>`;
                } else if (storagetype == "") {
                    document.getElementById("errors1").innerHTML = `<?php echo $GLOBALS['select_a_type']; ?>`;
                } else if (getWeight == "") {
                    document.getElementById('error_weight').innerHTML = `<?php echo $GLOBALS['weight_validation']; ?>`;
                } else if (getWeight <= 0) {
                    document.getElementById('error_weight').innerHTML = `<?php echo $GLOBALS['strValue_Greaterthen_Zero']; ?>`;
                }
                // else if (storagetype == "html5" && url == "") {
                //     document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_destination_url']; ?>`;
                // }
                // else if (storagetype !== "html5" && pattern.test(url) == false) {
                //     document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                // }
                // else if (storagetype !== "overlay" && url == "") {
                //     document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_destination_url']; ?>`;
                // }
                // else if (storagetype !== "overlay" && pattern.test(url) == false) {
                //     document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                // }
                //Web
                else if (storagetype == "web" && bannerSize_disabledFiled == false && banner_size == "select_size") {
                    document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
                } else if (storagetype == "web" && webImage_path !== "" && Number(bannerWidth) !== fileWidth) {
                console.log(bannerWidth);
                console.log(fileWidth);
                    document.getElementById('bannerimage').style.display = "none";
                    document.getElementById('webuploaderrors').innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(bannerWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(bannerHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                } else if (storagetype == "web" && webImage_path !== "" && Number(bannerHeight) !== fileHeight) {
                    console.log("nisha");
                    document.getElementById('bannerimage').style.display = "none";
                    document.getElementById('webuploaderrors').innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(bannerWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(bannerHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                } else if (storagetype == "web" && banner_size == "custom" && width == "") {
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "web" && banner_size == "custom" && height == "") {
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "web" && banner_size == "custom" && width == "" && height == "") {
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "web" && banner_size == "custom" && width == 0) {
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                } else if (storagetype == "web" && banner_size == "custom" && height == 0) {
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                } else if (storagetype == "web" && banner_size == "custom" && height == 0 && width == 0) {
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                } else if (storagetype == "web" && webImage_path == "" && webImage_disabledFiled == false) {
                    document.getElementById('webuploaderrors').innerHTML = `<?php echo $GLOBALS['strBanner_Upload_Image_validation']; ?>`;
                } else if (storagetype == "web" && url == "") {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_destination_url']; ?>`;
                } else if (storagetype == "web" && pattern.test(url) == false) {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                }
                //SQL
                else if (storagetype == "sql" && banner_size == "select_size") {
                    document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
                } else if (storagetype == "sql" && sqlBanner_imageURL == "" && sql_disabledFiled == false) {
                    document.getElementById('sqlerrors').innerHTML = `<?php echo $GLOBALS['select_a_file']; ?>`;
                } else if (storagetype == "sql" && uploadFile !== "" && Number(bannerWidth) !== fileWidth) {
                    document.getElementById('bannerimage').style.display = "none";
                    document.getElementById('sqlerrors').innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(bannerWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(bannerHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                } else if (storagetype == "sql" && uploadFile !== "" && Number(bannerHeight) !== fileHeight) {
                    document.getElementById('bannerimage').style.display = "none";
                    document.getElementById('sqlerrors').innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(bannerWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(bannerHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                } else if (storagetype == "sql" && banner_size == "custom" && width == "") {
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "sql" && banner_size == "custom" && height == "") {
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "sql" && banner_size == "custom" && width == "" && height == "") {
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "sql" && height == 0 && width == 0) {
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                } else if (storagetype == "sql" && url == "") {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_destination_url']; ?>`;
                } else if (storagetype == "sql" && pattern.test(url) == false) {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                }
                //URL
                else if (storagetype == "url" && banner_size == "select_size") {
                    document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
                } else if (storagetype == "url" && url_disabledFiled == false && urlBanner_imageURL == "") {
                    document.getElementById("errors3").innerHTML = `<?php echo $GLOBALS['enter_the_url']; ?>`;
                } else if (storagetype == "url" && pattern.test(urlBanner_imageURL) == false && url_disabledFiled == false) {
                    document.getElementById("errors3").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                } else if (storagetype == "url" && banner_size == "custom" && width == "") {
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "url" && banner_size == "custom" && height == "") {
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "url" && banner_size == "custom" && width == "" && height == "") {
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "url" && banner_size == "custom" && width == 0) {
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                } else if (storagetype == "url" && banner_size == "custom" && height == 0) {
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                } else if (storagetype == "url" && banner_size == "custom" && height == 0 && width == 0) {
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                } else if (storagetype == "url" && url == "") {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_destination_url']; ?>`;
                } else if (storagetype == "url" && pattern.test(url) == false) {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                } else if (storagetype == "url" && urlBanner_imageURL !== "" && urlFileFormat == false) {
                    document.getElementById("errors3").innerHTML = `<?php echo $GLOBALS['strBanner_Upload_Imagetype_validation']; ?>`;
                } else if (storagetype == "url" && getWeight !== Number(bannerWidth) && getHeight !== Number(bannerHeight)) {
                    document.getElementById("errors3").innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(bannerWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(bannerHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                }
                //html
                else if (storagetype == "html" && banner_size == "select_size") {
                    document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
                } else if (storagetype == "html" && html_disabledFiled == false && html_banner == "") {
                    document.getElementById("htmlerror").innerHTML = `<?php echo $GLOBALS['strBanner_HTML_validation']; ?>`;
                } else if (storagetype == "html" && banner_size == "custom" && width == "") {
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "html" && banner_size == "custom" && height == "") {
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "html" && banner_size == "custom" && width == "" && height == "") {
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "html" && banner_size == "custom" && width == 0) {
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                } else if (storagetype == "html" && banner_size == "custom" && height == 0) {
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                } else if (storagetype == "html" && banner_size == "custom" && height == 0 && width == 0) {
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                }
                //HTML5
                else if (storagetype == "html5" && banner_size == "select_size") {
                    document.getElementById("errors2").innerHTML = `<?php echo $GLOBALS['strBanner_Size_validation']; ?>`;
                } else if (storagetype == "html5" && html5ban == "" && html5_disabledFiled == false) {
                    document.getElementById("html5_bannerError").innerHTML = `<?php echo $GLOBALS['strBanner_Upload_Image_validation']; ?>`;
                } else if (storagetype == "html5" && html5ban !== "" && imageType !== "zip") {
                    document.getElementById("html5_bannerError").innerHTML = `<?php echo $GLOBALS['strBanner_HTML5_validation']; ?>`;
                } else if (storagetype == "html5" && banner_size == "custom" && width == "") {
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "html5" && banner_size == "custom" && height == "") {
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "html5" && banner_size == "custom" && width == "" && height == "") {
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>`;
                } else if (storagetype == "html5" && height == 0 && width == 0) {
                    document.getElementById("errorsheight").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                    document.getElementById("errorswidth").innerHTML = `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                } else if (storagetype == "html5" && url == "") {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_destination_url']; ?>`;
                } else if (storagetype == "html5" && pattern.test(url) == false) {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                }
                //Text
                else if (storagetype == "txt" && bannertext == "") {
                    document.getElementById("bannertexterror").innerHTML = `<?php echo $GLOBALS['enter_the_text']; ?>`;
                } else if (storagetype == "txt" && url == "") {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_destination_url']; ?>`;
                } else if (storagetype == "txt" && pattern.test(url) == false) {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                }
                //Inline
                else if (storagetype == "inline" && videoDelivery_method == "") {
                    document.getElementById("vediodeliveryerrors").innerHTML = `<?php echo $GLOBALS['select_delivery_method']; ?>`;
                } else if (storagetype == "inline" && inline_videoType == "") {
                    document.getElementById("vediofiletypeerrors").innerHTML = `<?php echo $GLOBALS['strBanner_Selectvedio_validation']; ?>`;
                } else if (storagetype == "inline" && inline_videoDuration == "") {
                    document.getElementById("vediodurationerrors").innerHTML = `<?php echo $GLOBALS['enter_the_video_duration']; ?>`;
                } else if (storagetype == "inline" && videoDelivery_method == "streaming" && rtms_server == "") {
                    document.getElementById("rtms_server_url").innerHTML = `<?php echo $GLOBALS['enter_the_server_URL']; ?>`;
                } else if (storagetype == "inline" && videoDelivery_method == "streaming" && pattern.test(rtms_server) == false) {
                    document.getElementById("rtms_server_url").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                } else if (storagetype == "inline" && videoDelivery_method == "streaming" && videoFile_name == "") {
                    document.getElementById("vediourlerrors").innerHTML = `<?php echo $GLOBALS['enter_the_server_URL']; ?>`;
                } else if (storagetype == "inline" && videoDelivery_method == "progressive" && inline_videoURL == "") {
                    document.getElementById("error_progressive_videoUrl").innerHTML = `<?php echo $GLOBALS['strBanner_VideoURL_validation']; ?>`;
                } else if (storagetype == "inline" && videoDelivery_method == "progressive" && pattern.test(inline_videoURL) == false) {
                    document.getElementById("error_progressive_videoUrl").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                } else if (storagetype == "inline" && url == "") {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_destination_url']; ?>`;
                } else if (storagetype == "inline" && pattern.test(url) == false) {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                }
                //Overlay
                else if (storagetype == "overlay" && getOverlay_type == "") {
                    document.getElementById("overlayaderrors").innerHTML = `<?php echo $GLOBALS['select_a_type']; ?>`;
                } else if (storagetype == "overlay" && getOverlayClick_action == "") {
                    document.getElementById("overlayclickerrors").innerHTML = `<?php echo $GLOBALS['strBanner_Overlayclick_Action_validation']; ?>`;
                } else if (storagetype == "overlay" && getOverlayClick_action == "click_to_page" && overlay_destinationURL == "") {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['strBanner_URL_validation']; ?>`;
                } else if (storagetype == "overlay" && getOverlayClick_action == "click_to_video" && vastVideo_delivery == "") {
                    document.getElementById("overlayprogressiveerror").innerHTML = `<?php echo $GLOBALS['select_delivery_method']; ?>`;
                } else if (storagetype == "overlay" && getOverlayClick_action == "click_to_video" && getVideoType == "") {
                    document.getElementById("overlayvideotypeerror").innerHTML = `<?php echo $GLOBALS['strSelect_Video_Type']; ?>`;
                } else if (storagetype == "overlay" && getOverlayClick_action == "click_to_video" && getVideoduration == "") {
                    document.getElementById("overlayvediop_durationerror").innerHTML = `<?php echo $GLOBALS['enter_the_video_duration']; ?>`;
                } else if (storagetype == "overlay" && getOverlayClick_action == "click_to_video" && vastVideo_delivery == "streaming" && overlayRTMP_serverURL == "") {
                    document.getElementById("overlayrtmp_urlerrors").innerHTML = `<?php echo $GLOBALS['enter_server_url']; ?>`;
                } else if (storagetype == "overlay" && getOverlayClick_action == "click_to_video" && vastVideo_delivery == "streaming" && pattern.test(overlayRTMP_serverURL) == false) {
                    document.getElementById("overlayrtmp_urlerrors").innerHTML = `<?php echo $GLOBALS['enter_server_url']; ?>`;
                } else if (storagetype == "overlay" && getOverlayClick_action == "click_to_video" && vastVideo_delivery == "streaming" && overlayVideo_fileName == "") {
                    document.getElementById("overlay_videofileerrors").innerHTML = `<?php echo $GLOBALS['enter_server_url']; ?>`;
                } else if (storagetype == "overlay" && getOverlayClick_action == "click_to_video" && vastVideo_delivery == "progressive" &&
                    overlayProgressive_videoURL == "") {
                    document.getElementById("overlayProgressive_videoURLerror").innerHTML = `<?php echo $GLOBALS['strBanner_VideoURL_validation']; ?>`;
                } else if (storagetype == "overlay" && getOverlayClick_action == "click_to_video" && vastVideo_delivery == "progressive" &&
                    pattern.test(overlayProgressive_videoURL) == false) {
                    document.getElementById("overlayProgressive_videoURLerror").innerHTML = `<?php echo $GLOBALS['strBanner_VideoURL_validation']; ?>`;
                } else {
                    document.getElementById("bannertexterror").innerHTML = "";
                    document.getElementById("errors").innerHTML = "";
                    document.getElementById("errors1").innerHTML = "";
                    document.getElementById("error_destinationURL").innerHTML = "";
                    document.getElementById("errorswidth").innerHTML = "";
                    document.getElementById("errorsheight").innerHTML = "";
                    document.getElementById('error_weight').innerHTML = "";
                    //web
                    document.getElementById('bannerimage').style.display = storagetype == "web" ? "block" : storagetype == "sql" ? "block" : "none";
                    document.getElementById('webuploaderrors').innerHTML = "";
                    //sql
                    document.getElementById('sqlerrors').innerHTML = "";
                    //url
                    document.getElementById("errors3").innerHTML = "";
                    //overlay
                    document.getElementById("overlayclickerrors").innerHTML = "";
                    document.getElementById("overlayaderrors").innerHTML = "";
                    document.getElementById("overlayprogressiveerror").innerHTML = "";
                    document.getElementById("overlayrtmp_urlerrors").innerHTML = "";
                    document.getElementById("overlay_videofileerrors").innerHTML = "";
                    document.getElementById("overlayvideotypeerror").innerHTML = "";
                    document.getElementById("overlayvediop_durationerror").innerHTML = "";
                    document.getElementById("overlayProgressive_videoURLerror").innerHTML = "";
                    //html 
                    document.getElementById("htmlerror").innerHTML = "";
                    //inline
                    document.getElementById("vediodeliveryerrors").innerHTML = "";
                    document.getElementById("rtms_server_url").innerHTML = "";
                    document.getElementById("vediourlerrors").innerHTML = "";
                    document.getElementById("vediofiletypeerrors").innerHTML = "";
                    document.getElementById("vediodurationerrors").innerHTML = "";
                    document.getElementById("error_progressive_videoUrl").innerHTML = "";
                    //campaign
                    document.getElementById('error_campaign').innerHTML = "";
                    //html5
                    document.getElementById("html5_bannerError").innerHTML = "";
                    //let check_id = campaign_id == "" ? campaign_value : campaign_id;
                    $('#submitbtn').prop('disabled', true);
                    $.ajax({
                        type: "POST",
                        url: addBanner + campaign,
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        data: formData,
                        dataType: "json",
                        encode: true,
                    }).done(function(data) {
                        var getBanner_id = data.banner;
                        if (data.msg == 'Banner added successfully!' && data.statuscode == 200) {
                            window.scrollTo(0, 0);
                            // window.location.href = "bannerlist.php";
                            $("#alertsuccess").show('medium');
                            setTimeout(function() {
                                $("#alertsuccess").hide('medium');
                                $('#submitbtn').prop('disabled', false);
                            }, 2000);
                            setTimeout(function() {
                                if (clientid) {
                                window.location.href = (campaign_id != "" && clientid != "" && getParams == "1") ? 'advertiser_campaigns.php?campaign_id=' + campaign_id + '&clientid=' + clientid : (campaign_id != "" && clientid != "") ? 'bannerlist.php?campaign_id=' + campaign_id + '&clientid=' + clientid : 'bannerlist.php';
                            } else {
                                window.location.href = (campaign_id != "" && client_id != "" && getParams == "") ? 'bannerlist.php?campaign_id=' + campaign_id + '&client_id=' + client_id :
                                    (campaign_id != "" && client_id != "" && getParams == "1") ? 'advertiser_campaigns.php' : 'bannerlist.php';
                            }
                            }, 1700);

                            auto_link(getBanner_id);

                        } else if (data.msg == "Please check with input parameters" && data.response == "error") {
                            console.log("Fill the all fileds in the form");
                        } else {
                            window.scrollTo(0, 0);
                            // location.reload();
                            $("#alertfailed").show('medium');
                            $('#submitbtn').prop('disabled', false);
                            setTimeout(function() {
                                $("#alertfailed").hide('medium');
                            }, 2000);
                        }
                    });
                    event.preventDefault();
                }
            };

            onCancel = () => {
            if (clientid) {
                window.location.href = (campaign_id != "" && clientid != "" && getParams == "1") ? 'advertiser_campaigns.php?campaign_id=' + campaign_id + '&clientid=' + clientid : (campaign_id != "" && clientid != "") ? 'bannerlist.php?campaign_id=' + campaign_id + '&clientid=' + clientid : 'bannerlist.php';
            } else {
                window.location.href = (campaign_id != "" && client_id != "" && getParams == "") ? 'bannerlist.php?campaign_id=' + campaign_id + '&client_id=' + client_id :
                    (campaign_id != "" && client_id != "" && getParams == "1") ? 'advertiser_campaigns.php' : 'bannerlist.php';
            }
        };

            restrictAlphabets = (e) => {
                let x = e.which || e.keycode;
                if ((x >= 48 && x <= 57)) {
                    return true;
                } else {
                    return false;
                }
            };

            destinationUrlValidation = () => {
                let getUrl = document.getElementById('desurl').value;

                if (getUrl == "") {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['strBanner_VideoURL_validation']; ?>`;
                } else if (pattern.test(getUrl)) {
                    document.getElementById("error_destinationURL").innerHTML = "";
                    return true;
                } else {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                    return false;
                }
            };

            inlineDestinationUrlValidation = () => {
                let getUrl = document.getElementById('overlay_destinationURL').value;

                if (getUrl == "") {
                    document.getElementById("error_inlineDestinationURL").innerHTML = `<?php echo $GLOBALS['strBanner_VideoURL_validation']; ?>`;
                } else if (pattern.test(getUrl)) {
                    document.getElementById("error_inlineDestinationURL").innerHTML = "";
                    return true;
                } else {
                    document.getElementById("error_inlineDestinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                    return false;
                }
            };

            //on paste validation
            $("#name,#bannertext,#htmlBanner").bind("paste", function(e) {
                var attr_id = e.target.id;
                var pasted_data = e.originalEvent.clipboardData.getData('text');
                if (attr_id == 'name') {
                    document.getElementById("errors").innerHTML = pasted_data == "" ? `<?php echo $GLOBALS['strName_validation']; ?>` : "";
                }
                if (attr_id == 'bannertext') {
                    document.getElementById("bannertexterror").innerHTML = pasted_data == "" ? `<?php echo $GLOBALS['enter_the_text']; ?>` : "";
                }
                if (attr_id == 'htmlBanner') {
                    document.getElementById("htmlerror").innerHTML = htmlBanner == "" ? `<?php echo $GLOBALS['strBanner_HTML_validation']; ?>` : "";
                }
            });

            $("#desurl").bind("paste", function(e) {
                var getUrl = e.originalEvent.clipboardData.getData('text');
                if (getUrl == "") {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['strBanner_VideoURL_validation']; ?>`;
                } else if (pattern.test(getUrl)) {
                    document.getElementById("error_destinationURL").innerHTML = "";
                    return true;
                } else {
                    document.getElementById("error_destinationURL").innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
                    return false;
                }
            });

            $("#width,#height,#banner_weight").bind("paste", function(e) {
                var attr_id = e.target.id;
                var size_val = e.originalEvent.clipboardData.getData('text');
                if (attr_id == 'width') {
                    document.getElementById("errorswidth").innerHTML = size_val == "" ? `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>` :
                        Number(size_val) > 0 ? "" : `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                }
                if (attr_id == 'height') {
                    document.getElementById("errorsheight").innerHTML = size_val == "" ? `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>` :
                        Number(size_val) > 0 ? "" : `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                }
                if (attr_id == 'banner_weight') {
                    document.getElementById('error_weight').innerHTML = size_val == "" ? `<?php echo $GLOBALS['weight_validation']; ?>` : size_val > 0 ? "" : `<?php echo $GLOBALS['strValue_Greaterthen_Zero']; ?>`;
                }
            });

            $("#bannerurl").bind("paste", function(e) {
                var urlBanner = e.originalEvent.clipboardData.getData('text');
                let getFileName = urlBanner.split('/').pop();
                let fileFormat = getFileName.split('.').pop();
                urlFileFormat = (fileFormat == 'png' || fileFormat == 'gif' || fileFormat == 'jpg' || fileFormat == 'jpeg') ? true : false;
                document.getElementById("errors3").innerHTML = urlBanner == "" ? `<?php echo $GLOBALS['strBanner_URL_validation']; ?>` :
                    pattern.test(urlBanner) == false ? `<?php echo $GLOBALS['enter_valid_url']; ?>` :
                    (urlBanner !== "" && urlFileFormat == false) ? `<?php echo $GLOBALS['strBanner_Upload_Imagetype_validation']; ?>` : "";
            });

            //validation function's
            function bannernameval() {
                let name = document.getElementById('name').value;
                document.getElementById("errors").innerHTML = name == "" ? `<?php echo $GLOBALS['strName_validation']; ?>` : "";
            };

            function sizeValidation() {
                document.getElementById('formFile').value = "";
                document.getElementById('sqlban').value = "";
                document.getElementById("bannerurl").value = "";
                document.getElementById("errors3").innerHTML = "";
                let widthval = document.getElementById('width').value;
                let heightval = document.getElementById('height').value;
                bannerWidth = widthval;
                bannerHeight = heightval;
                document.getElementById('bannerimage').style.display = "none";

                document.getElementById("errorswidth").innerHTML = widthval == "" ? `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>` :
                    Number(widthval) > 0 ? "" : `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
                document.getElementById("errorsheight").innerHTML = heightval == "" ? `<?php echo $GLOBALS['strBanner_Custom_validation']; ?>` :
                    Number(heightval) > 0 ? "" : `<?php echo $GLOBALS['value_should_greater_then_zero']; ?>`;
            };

            function urlbanner() {
                let urlBanner = document.getElementById("bannerurl").value;
                const urlImage = new Image();
                urlImage.src = urlBanner;
                urlImage.onload = () => {
                    getWidth = urlImage.width;
                    getHeight = urlImage.height;
                    if (getWidth == Number(bannerWidth) && getHeight == Number(bannerHeight)) {
                        document.getElementById("errors3").innerHTML = "";
                    } else {
                        document.getElementById("errors3").innerHTML = `<?php echo $GLOBALS['file_width']; ?>` + Number(bannerWidth) + `<?php echo $GLOBALS['file_height']; ?>` + Number(bannerHeight) + `<?php echo $GLOBALS['file_size_is_not_match']; ?>`;
                    }
                }
                let getFileName = urlBanner.split('/').pop();
                let fileFormat = getFileName.split('.').pop();
                urlFileFormat = (fileFormat == 'png' || fileFormat == 'gif' || fileFormat == 'jpg' || fileFormat == 'jpeg') ? true : false;
                document.getElementById("errors3").innerHTML = urlBanner == "" ? `<?php echo $GLOBALS['strBanner_URL_validation']; ?>` :
                    pattern.test(urlBanner) == false ? `<?php echo $GLOBALS['enter_valid_url']; ?>` :
                    (urlBanner !== "" && urlFileFormat == false) ? `<?php echo $GLOBALS['strBanner_Upload_Imagetype_validation']; ?>` : "";
            };

            function bannertextVal() {
                let bannertext = document.getElementById("bannertext").value;
                document.getElementById("bannertexterror").innerHTML = bannertext == "" ? `<?php echo $GLOBALS['enter_the_text']; ?>` : "";
            };

            function htmlbannerVal() {
                let htmlBanner = document.getElementById("htmlBanner").value;
                document.getElementById("htmlerror").innerHTML = htmlBanner == "" ? `<?php echo $GLOBALS['strBanner_HTML_validation']; ?>` : "";
            };

            function vediouploadval() {
                let videofilename = document.getElementById("inline_videofile").value;
                document.getElementById("vediourlerrors").innerHTML = videofilename == "" ? `<?php echo $GLOBALS['strBanner_Vediofile_Name_validation']; ?>` : "";
            }

            function vediofiletypeval() {
                let videofiletype = document.getElementById('inline_videoType').value;
                document.getElementById("vediofiletypeerrors").innerHTML = videofiletype == "" ? `<?php echo $GLOBALS['strBanner_Videofile_Type_validation']; ?>` : "";
            }

            function vediodurationval() {
                let videoduration = document.getElementById('inline_videoduration').value;
                document.getElementById("vediodurationerrors").innerHTML = videoduration == "" ? `<?php echo $GLOBALS['enter_the_video_duration']; ?>` : "";
            };

            function inlinertmpurl() {
                let rtmsserver = document.getElementById('rtmp_serverURL').value;
                document.getElementById("rtms_server_url").innerHTML = rtmsserver == "" ? `<?php echo $GLOBALS['strBanner_RTMSserver_URL_validation']; ?>` :
                    pattern.test(rtmsserver) == false ? `<?php echo $GLOBALS['enter_valid_url']; ?>` : "";
            };

            function overlayrtmUrl() {
                let overlayrtm = document.getElementById('overlayStreaming_rtmpServerURL').value;
                document.getElementById("overlayrtmp_urlerrors").innerHTML = overlayrtm == "" ? `<?php echo $GLOBALS['strBanner_RTMSserver_URL_validation']; ?>` :
                    pattern.test(overlayrtm) == false ? `<?php echo $GLOBALS['enter_valid_url']; ?>` : "";
            };

            function overlayvideofile() {
                let overlayvideofile = document.getElementById('overlay_videofile').value;
                document.getElementById("overlay_videofileerrors").innerHTML = overlayvideofile == "" ? `<?php echo $GLOBALS['strBanner_Vediofile_Name_validation']; ?>` : "";
            };

            function overlayvedio_change() {
                let overlayvideochange = document.getElementById('video_type').value;
                document.getElementById("overlayvideotypeerror").innerHTML = overlayvideochange == "" ? `<?php echo $GLOBALS['strSelect_Video_Type']; ?>` : "";
            };

            function overlayvedioduration() {
                let overlayvideoduration = document.getElementById('overlay_videoduration').value;
                document.getElementById("overlayvediop_durationerror").innerHTML = overlayvideoduration == "" ? `<?php echo $GLOBALS['select_video_duration']; ?>` : "";
            };

            function overlayVideo_url() {
                let overlayVideourl = document.getElementById('overlayProgressive_videoURL').value;
                document.getElementById("overlayProgressive_videoURLerror").innerHTML = overlayVideourl == "" ? `<?php echo $GLOBALS['enter_the_url']; ?>` :
                    pattern.test(overlayVideourl) == false ? `<?php echo $GLOBALS['enter_valid_url']; ?>` : "";
            }

            inlineVideoURL = () => {
                let inline_progressive_videoURL = document.getElementById('video_URL').value;
                document.getElementById("error_progressive_videoUrl").innerHTML = inline_progressive_videoURL == "" ? `<?php echo $GLOBALS['strBanner_VideoURL_validation']; ?>` :
                    pattern.test(inline_progressive_videoURL) == false ? `<?php echo $GLOBALS['enter_valid_url']; ?>` : "";
            };

            onChangeWeight = () => {
                let getWeight = document.getElementById('banner_weight').value;
                document.getElementById('error_weight').innerHTML = getWeight == "" ? `<?php echo $GLOBALS['weight_validation']; ?>` : getWeight > 0 ? "" :
                    `<?php echo $GLOBALS['strValue_Greaterthen_Zero']; ?>`;
            };

            function auto_link(getBanner_id) {
                $.ajax({
                    url: live_URL + '/banner_autolink/' + getBanner_id,
                    type: "POST",
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    dataType: "json",
                    encode: true,
                }).done(function(data) {

                });
            }
        </script>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>

</html>