<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['user_access']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        #clientname,
        #contact,
        #email {
            width: 50%;
            display: inline;
        }

        #check {
            margin-left: 4rem;
        }

        .alert {
            display: none;
        }
    </style>
</head>

<body onload=>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="card mt-5">
                            <div class="card-header">
                                <div class="row mb-3">
                                    <div class="col-md-5">
                                        <p class="h4">
                                            <?php echo $GLOBALS['user_access']; ?> <span id="len"
                                                class="text-secondary"></span>
                                        </p>
                                    </div>
                                    <hr class="solid">
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <p>
                                        <?php echo $GLOBALS['adduser']; ?>
                                    </p>
                                    <hr class="solid">
                                    <div class="mb-3 col-md-4">
                                        <label for="inputName" class="col-form-label" style="margin-left: 3rem;">
                                            <?php echo $GLOBALS['usertoadd']; ?>
                                        </label>
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <input type="text" class="form-control" id="username" name="username"
                                            onkeyup="manageButton()" onchange="manageButton()">
                                    </div>
                                    <hr class="solid">
                                </div>
                                <div class="row mb-3 mt-3">
                                    <div class="col">
                                        <button type="button" id="submitbtn" class="btn btn-primary submitbtn"
                                            onclick="add_user()" style="" disabled>
                                            <?php echo $GLOBALS['add_user']; ?>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php include('footer.php'); ?>
            </div>
        </div>
    </div>
    <script src="../js/sweetalert.min.js"></script>
    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var clientid = '<?php echo $_REQUEST['clientid']; ?>';

        function manageButton() {
            if ($("#username").val() != "") {
                $("#submitbtn").prop("disabled", false);
            } else {
                $("#submitbtn").prop("disabled", true);
            }
        }

        function add_user() {
            var username = $("#username").val();
            window.location.href = 'agency_user.php?login=' + username + '&agencyid=<?php echo $_SESSION['agencyid']; ?>&link=1';
        }
    </script>


</body>

</html>