<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['user_access']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>

    <style>
        .swal-button--danger {
            background-color: #2523b3;
        }

        .swal-button--cancel {
            color: white;
            background-color: #ff3e1d;
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: red;
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #2523b3;
        }

        .text-hide {
            display: block;
            width: 270px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: hidden;
        }

        .statuswidth {
            width: 13%;
        }

        .dataTables_scrollBody {
            height: auto !important;
        }

        .text_convert {
            text-transform: capitalize;
        }

        select {
            float: right;
        }

        td {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        td:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }
    </style>
</head>

<body onload="get_userdetails();">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card my-4">
                            <div class="card-body">
                                <div class="row">
                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class="h3">
                                            <?php echo $GLOBALS['user_access']; ?><span id="len"
                                                class="text-secondary"></span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                    </div>
                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <span class="rows_selected" id="select_count"></span>
                                        <button type="button" class="btn btn-primary"
                                            onclick="window.location.href='agency_user_start.php?agencyid=<?php echo $_SESSION['agencyid']; ?>'"
                                            style=""><i class="menu-icon tf-icons bx bx-plus"></i>
                                            <?php echo $GLOBALS['add_user']; ?>
                                        </button>
                                    </div>
                                </div>
                                <hr class="solid">

                                <div class="row">
                                    <div class="table-responsive text-nowrap">
                                        <table id="user_table" class="table table-striped table-responsive table-hover">
                                            <thead>
                                                <tr class="text-nowrap">
                                                    <th class="th-color">
                                                        <?php echo $GLOBALS['strUsername']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['Email']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['contact_name']; ?>
                                                    </th>
                                                    <!-- <th class="th-color">
                                                        <?php echo $GLOBALS['last_logged_in']; ?>
                                                    </th> -->
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['date_linked']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['action']; ?>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->

                    <?php include('footer.php'); ?>

                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper , className: "text-hide" -->

    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var agencyid = '<?php echo $_SESSION['agencyid']; ?>';
        // alert(agencyid);
        function get_userdetails() {
            $.ajax({
                url: live_URL + '/get_all_user_details/' + agencyid,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
                success: function (data) {
                    if (data) {
                        var user_data = data.data;
                        if (user_data) {
                            for (var i = 0; i < user_data.length; i++) {
                                var row = $('<tr><td><a href="agency_user.php?user_id=' + user_data[i].user_id + '&agencyid=' + agencyid + '">' + user_data[i].username + '</a></td><td class="text-center"><a href="agency_user.php?user_id=' + user_data[i].user_id + '&agencyid=' + agencyid + '">' + user_data[i].email_address + '</a></td><td class="text-center">' + user_data[i].contact_name + '</td><td class="text-center">' + user_data[i].date_created + '</td><td class="text-center"><a class="" href="agency_user.php?user_id=' + user_data[i].user_id + '&agencyid=' + agencyid + '">Permissions</a></td></tr>');
                                $('#user_table').append(row);
                            }
                        }
                    }
                },
                error: function () { },
            });
        }
    </script>
</body>

</html>