<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['adv_access']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>

    <style>
        .swal-button--danger {
            background-color: #2523b3;
            width: 100px;
        }

        .swal-button--cancel {
            color: white;
            width: 100px;
            background-color: #ff3e1d;
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: red;
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #2523b3;
        }

        .swal-footer {
            text-align: center;
        }

        .text-hide {
            display: block;
            width: 270px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: hidden;
        }

        .card-body {
            padding: 0 !important;
        }

        .statuswidth {
            width: 13%;
        }

        .dataTables_scrollBody {
            height: auto !important;
        }

        .campaign-name {
            display: block;
            height: 20px;
            overflow-y: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text_convert {
            text-transform: capitalize;
        }

        select {
            float: right;
        }

        td {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        td:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }

        .alert {
            display: none;
        }
    </style>
</head>

<body onload="get_userdetails();">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-5">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col-md-5">
                                        <p class="h4">
                                            <?php echo $GLOBALS['advertiser']; ?> <span id="len"
                                                class="text-secondary"></span>
                                        </p>
                                    </div>
                                    <div class="col-md-7 display-flex mb-2">
                                        <span class="rows_selected" id="select_count"></span>
                                        <button type="button" class="btn btn-primary"
                                            onclick="window.location.href='advertiser_user_start.php?clientid=<?php echo $_GET['clientid']; ?>'"
                                            style="position:relative;float:right;"><i
                                                class="menu-icon tf-icons bx bx-plus"></i>
                                            <?php echo $GLOBALS['add_user']; ?>
                                        </button>
                                    </div>
                                    <hr class="solid">
                                </div>
                                <div class="row">
                                    <p class="alert bg-success alert-dismissible fade show text-white"
                                        id="alertsuccess"><i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['']; ?>User has been deleted successfully
                                    </p>
                                    <p class="alert bg-danger alert-dismissible fade show text-white" id="alertfailed">
                                        <i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['']; ?>User has been deleted failed
                                    </p>
                                </div>

                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="mt-2 mb-4 container">
                                        <div class="table-responsive text-nowrap">
                                            <table id="user_table"
                                                class="table table-striped table-responsive table-hover">
                                                <thead>
                                                    <tr class="text-nowrap">
                                                        <th class="th-color">
                                                            <?php echo $GLOBALS['strUsername']; ?>
                                                        </th>
                                                        <th class="th-color">
                                                            <?php echo $GLOBALS['Email']; ?>
                                                        </th>
                                                        <th class="th-color">
                                                            <?php echo $GLOBALS['contact_name']; ?>
                                                        </th>
                                                        <th class="th-color">
                                                            <?php echo $GLOBALS['last_logged_in']; ?>
                                                        </th>
                                                        <th class="th-color">
                                                            <?php echo $GLOBALS['date_linked']; ?>
                                                        </th>
                                                        <th class="th-color text-center">
                                                            <?php echo $GLOBALS['action']; ?>
                                                        </th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!-- / Content -->

                    <!-- Footer -->

                    <?php include('footer.php'); ?>

                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper , className: "text-hide" -->

    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var clientid = '<?php echo $_REQUEST['clientid']; ?>';
        var agencyid = '<?php echo $_SESSION['agencyid']; ?>';
        //alert(agencyid);
        function get_userdetails() {
            $.ajax({
                url: live_URL + '/get_all_user_new/' + agencyid,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
                success: function (data) {
                    console.log(data);
                    for (i = 0; i < data.length; i++) {
                        var row = $('<tr><td><a href="advertiser_user_edit.php?userid=' + data[i].user_id + '&clientid=<?php echo $_GET['clientid']; ?>">' + data[i].username + '</a></td><td><a href="advertiser_user_edit.php?userid=' + data[i].user_id + '&clientid=<?php echo $_GET['clientid']; ?>"">' + data[i].email_address + '</a></td><td>' + data[i].contact_name + '</td><td>' + data[i].date_last_login + '</td><td>' + data[i].date_created + '</td><td style=""><a class="btn btn-icon btn-xs btn-primary" href="advertiser_user_edit.php?userid=' + data[i].user_id + '&clientid=<?php echo $_GET['clientid']; ?>"><i class="bx bx-user-check ms-0 label-primary" style="padding-left:5px;font-size:14px" title="Permissions"></i></a>&nbsp;&nbsp;<a class="btn btn-icon btn-xs btn-danger" href="#"><i class="bx bx-trash ms-0 label-danger" onclick="Deletebtn(' + data[i].user_id + ')" style=font-size:14px" title="Delete"></i></a></td></tr>');
                        $('#user_table').append(row);
                        var x = data.username;
                        $('#len').html(x);
                        //alert(x);
                    }
                },
                error: function () { },
            });
        }

        function Deletebtn(userid) {
            console.log("userid", userid);
            swal({
                title: 'Are you sure,you want to delete this user?',
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function (isConfirm) {

                if (isConfirm) {
                    $.ajax({
                        type: "DELETE",
                        url: live_URL + '/delete_user/' + userid,
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function (data) {
                        if (data.msg = "User has been deleted successfully!") {
                            $("#alertsuccess").show('medium');
                            setTimeout(function () {
                                $("#alertsuccess").hide('medium');
                            }, 1700);
                            setTimeout(function () {
                                location.reload();
                            }, 1700);
                        } else {

                        }
                    });
                }
            });
        }

    </script>
</body>

</html>