<?php
include ('session.php');
include ('../config.php');
include ('../common.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> - <?php echo $GLOBALS['adv_reports']; ?>
    </title>

    <meta name="description" content="" />
    <?php include ('head.php'); ?>

    <style>
        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }
    </style>
</head>

<body onload="">
    <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include ('sidebar.php'); ?>
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include ('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3 mb-5">
                            <div class="card-body">
                                <div class="row mb-2 mt-2">
                                    <div
                                        class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class="h4">
                                            <?php echo $GLOBALS['adv_reports']; ?>
                                        </p>
                                    </div>
                                </div>
                                <hr class="solid">
                                <div class="row mb-3">
                                    <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                                        <label for="inputName"
                                            class="form-label"><?php echo $GLOBALS['std_reports']; ?></label>
                                    </div>
                                    <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                        <select id="standard_reports" class="form-select text-dark"
                                            onchange="report_change();">
                                            <option value="0"><?php echo $GLOBALS['select_report']; ?></option>
                                            <option value="1"><?php echo $GLOBALS['aa_report']; ?></option>
                                            <option value="2"><?php echo $GLOBALS['ca_report']; ?></option>
                                            <option value="3"><?php echo $GLOBALS['cr_report']; ?></option>
                                            <option value="4"><?php echo $GLOBALS['ct_report']; ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div id="report_window" style="display: none;">
                                    <div class="row mt-4">
                                        <div class="row" id="aar">
                                            <p class="h5"><?php echo $GLOBALS['aa_report']; ?></p>
                                            <p><?php echo $GLOBALS['aa_report_show']; ?></p>
                                        </div>
                                        <div class="row" id="car">
                                            <p class="h5"><?php echo $GLOBALS['ca_report']; ?></p>
                                            <p><?php echo $GLOBALS['ca_report_show']; ?></p>
                                        </div>
                                        <div class="row" id="cdr">
                                            <p class="h5"><?php echo $GLOBALS['cr_report']; ?></p>
                                            <p><?php echo $GLOBALS['cr_report_show']; ?></p>
                                        </div>
                                        <div class="row" id="ctr">
                                            <p class="h5"><?php echo $GLOBALS['ct_report']; ?></p>
                                            <p><?php echo $GLOBALS['ctr_report_show']; ?></p>
                                        </div>
                                        <div class="row mt2" id="no_worksheet" style="display: none;">
                                            <p class="alert alert-danger"><?php echo $GLOBALS['']; ?>No worksheet was
                                                selected for report</p>
                                        </div>
                                    </div>
                                    <!-- period -->
                                    <div class="row mb-3">
                                        <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                                            <label for="inputName" class="col-form-label"
                                                style="margin-left: 3rem;"><?php echo $GLOBALS['period']; ?></label>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                            <select id="period" name="allfilter" class="form-select text-dark"
                                                aria-label="Default select example"
                                                onchange="change_period(this.value)">
                                                <option value="Today" selected><?php echo $GLOBALS['strToday']; ?>
                                                </option>
                                                <option value="Yesterday"><?php echo $GLOBALS['strYesterday']; ?>
                                                </option>
                                                <option value="Last 7 days"><?php echo $GLOBALS['strLast 7 days']; ?>
                                                </option>
                                                <option value="Last 30 days"><?php echo $GLOBALS['strLast 30 days']; ?>
                                                </option>
                                                <option value="Last Month"><?php echo $GLOBALS['strLast Month']; ?>
                                                </option>
                                                <option value="This Month"><?php echo $GLOBALS['strThis Month']; ?>
                                                </option>
                                                <option value='all'><?php echo $GLOBALS['strAll Statistics']; ?>
                                                </option>
                                                <option value="Custom"><?php echo $GLOBALS['strCustom']; ?></option>
                                            </select>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                            <input type="text" class="form-control" id="daterange" name="daterange"
                                                style="display: none;">
                                        </div>
                                    </div>
                                    <!-- Delivery Rules / Limitations -->
                                    <div class="row mb-3" id="orders_websites">
                                        <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                                            <label for="inputName" id="delivery_rules" class="col-form-label"
                                                style="margin-left: 3rem;"><?php echo $GLOBALS['delivery_rules']; ?></label>
                                            <label for="inputName" id="limitations" class="col-form-label"
                                                style="margin-left: 3rem; display:none;"><?php echo $GLOBALS['limitations']; ?></label>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                            <select id="orders" name="allfilter" class="form-select text-dark"
                                                aria-label="Default select example" onchange="">
                                            </select>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                            <select id="websites" name="allfilter" class="form-select text-dark"
                                                aria-label="Default select example" onchange="">
                                            </select>
                                        </div>
                                    </div>
                                    <!-- Campaign -->
                                    <div class="row mb-3" id="campaign">
                                        <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                                            <label for="inputName" class="col-form-label"
                                                style="margin-left: 3rem;"><?php echo $GLOBALS['campaign']; ?></label>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                            <select id="campaign_select" name="allfilter" class="form-select text-dark"
                                                aria-label="Default select example" onchange="">
                                                <!-- <option value="all"><?php echo $GLOBALS['']; ?>All Orders</option> -->
                                            </select>
                                        </div>
                                    </div>
                                    <!-- Worksheets -->
                                    <div class="row mb-3" id="worksheets">
                                        <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                                            <label for="inputName" class="col-form-label"
                                                style="margin-left: 3rem;"><?php echo $GLOBALS['worksheets']; ?></label>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                            <div id="daily_check">
                                                <input class="form-check-input" type="checkbox" name="daily_bd"
                                                    id="daily_bd" value="1" checked>
                                                <label
                                                    class="form-check-label"><?php echo $GLOBALS['daily_bd']; ?></label><br>
                                            </div>
                                            <div id="campaign_check">
                                                <input class="form-check-input mt-2" type="checkbox" name="campaign_bd"
                                                    id="campaign_bd" value="1" checked>
                                                <label
                                                    class="form-check-label mt-2"><?php echo $GLOBALS['campaign_bd']; ?></label><br>
                                            </div>
                                            <div id="ad_check">
                                                <input class="form-check-input mt-2" type="checkbox" name="ad_bd"
                                                    id="ad_bd" value="1" checked>
                                                <label
                                                    class="form-check-label mt-2"><?php echo $GLOBALS['ad_bd']; ?></label><br>
                                            </div>
                                            <div id="zone_check">
                                                <input class="form-check-input mt-2" type="checkbox" name="zone_bd"
                                                    id="zone_bd" value="1" checked>
                                                <label
                                                    class="form-check-label mt-2"><?php echo $GLOBALS['zone_bd']; ?></label>
                                            </div>
                                            <div id="performance_check">
                                                <input class="form-check-input mt-2" type="checkbox"
                                                    name="performance_bd" id="performance_bd" value="1" checked>
                                                <label
                                                    class="form-check-label mt-2"><?php echo $GLOBALS['performance_bd']; ?></label>
                                            </div>
                                            <div id="connection_by_day">
                                                <input class="form-check-input mt-2" type="checkbox"
                                                    name="connection_by_day_bd" id="connection_by_day_bd" value="1"
                                                    checked>
                                                <label
                                                    class="form-check-label mt-2"><?php echo $GLOBALS['con_sum_by_day']; ?></label>
                                            </div>
                                            <div id="variable_by_day">
                                                <input class="form-check-input mt-2" type="checkbox"
                                                    name="variable_by_day_bd" id="variable_by_day_bd" value="1" checked>
                                                <label
                                                    class="form-check-label mt-2"><?php echo $GLOBALS['var_sum_by_day']; ?></label>
                                            </div>
                                            <div id="variable_by_variable">
                                                <input class="form-check-input mt-2" type="checkbox"
                                                    name="variable_by_variable_bd" id="variable_by_variable_bd"
                                                    value="1" checked>
                                                <label
                                                    class="form-check-label mt-2"><?php echo $GLOBALS['var_sum_by_var']; ?></label>
                                            </div>
                                            <div id="connection_detail">
                                                <input class="form-check-input mt-2" type="checkbox"
                                                    name="connection_detail_bd" id="connection_detail_bd" value="1"
                                                    checked>
                                                <label
                                                    class="form-check-label mt-2"><?php echo $GLOBALS['con_det']; ?></label>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="row mb-3">
                                        <div
                                            class="col col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                            <button type="button" class="btn btn-primary " style="position:relative;"
                                                id="generate"
                                                onclick="generate_report();"><?php echo $GLOBALS['generate']; ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- / Content -->
                        <div class="content-backdrop fade"></div>
                    </div>
                    <!-- Footer -->
                    <?php include ('footer.php'); ?>
                    <!-- / Footer -->
                    <!-- Content wrapper -->
                </div>
                <!-- / Layout page -->


                <script>
                    const live_URL = '<?php echo $apiinvenpath; ?>';
                    const stat_URL = '<?php echo $apistatpath; ?>';
                    const token = 'Bearer ' + '<?php echo $_SESSION['token']; ?>';
                    var agencyid = '<?php echo $_SESSION['agencyid']; ?>';
                    let userid = '<?php echo $_SESSION['user_id']; ?>';
                    var start_date, end_date;
                    var timeZone;

                    $(function () {
                        //get orders
                        $.ajax({
                            type: "GET",
                            url: live_URL + '/get_all_advertiser/' + agencyid,
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            data: {},
                            dataType: "json",
                            encode: true,
                        }).done(function (data) {
                            var client_name = [];
                            var default_value = `<option value=all><?php echo $GLOBALS['all_orderjob']; ?></option>`;
                            if (!data.data) {
                                $('#orders').html(default_value);
                            } else {
                                data.data.map((data) => {
                                    getadvLength = (data.clientname.length > 30) ? (data.clientname.slice(0, 30) + '...') : data.clientname;
                                    client_name += `<option value=${data.clientid} title="${data.clientname}">${getadvLength}</option>`;
                                    $('#orders').html(default_value + client_name);
                                });
                            }
                        });
                        //get website
                        $.ajax({
                            type: "GET",
                            url: live_URL + '/get_all_website/' + agencyid,
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            data: {},
                            dataType: "json",
                            encode: true,
                        }).done(function (data) {
                            var websites = [];
                            var default_value = `<option value=all><?php echo $GLOBALS['all_web']; ?></option>`;
                            if (!data.data) {
                                $('#websites').html(default_value);
                            } else {
                                data.data.map((data) => {
                                    getwebLength = (data.name.length > 30) ? (data.name.slice(0, 30) + '...') : data.name;
                                    websites += `<option value=${data.affiliateid} title="${data.name}">${getwebLength}</option>`;
                                    $('#websites').html(default_value + websites);
                                });
                            }
                        });
                        //get campaigns
                        $.ajax({
                            type: "GET",
                            url: live_URL + '/get_all_agengy_campaigns/' + agencyid,
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            data: {},
                            dataType: "json",
                            encode: true,
                        }).done(function (data) {
                            console.log('data', data.data);
                            var campaigns = [];
                            if (data.data) {
                                data.data.map((data) => {
                                    campaigns += `<option value=${data.campaignid}>${data.campaignname}</option>`;
                                    $('#campaign_select').html(campaigns);
                                });
                            }
                        });

                        //get_timezone_report
                        $.ajax({
                            type: "GET",
                            url: stat_URL + '/get_timezone_report/' + agencyid,
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            dataType: "json",
                            encode: true,
                        }).done(function (data) {
                            //console.log(data);
                            timeZone = data;
                        });

                    });

                    function report_change() {
                        var report_type = $('#standard_reports').val();
                        var daily_bd_val = $('#daily_bd').is(':checked');
                        var campaign_val = $('#campaign_bd').is(':checked');
                        var ad_val = $('#ad_bd').is(':checked');
                        var zone_val = $('#zone_bd').is(':checked');
                        var performance_val = $('#performance_bd').is(':checked');
                        var connection_by_day_val = $('#connection_by_day_bd').is(':checked');
                        var variable_by_day_val = $('#variable_by_day_bd').is(':checked');
                        var variable_by_variable_val = $('#variable_by_variable_bd').is(':checked');
                        var connection_detail_val = $('#connection_detail_bd').is(':checked');
                        if (report_type == 1) {
                            $('#report_window, #generate').show();
                            $('#car,#cdr,#ctr').hide();
                            $('#aar').show();
                            $('#campaign').hide();
                            $('#orders_websites').show();
                            $('#limitations').hide();
                            $('#delivery_rules').show();
                            $('#worksheets').show();
                            $('#campaign_check').show();
                            $('#ad_check').hide();
                            $('#zone_check').show();
                            $('#daily_check').show();
                            $('#performance_check').hide();
                            $('#connection_by_day').hide();
                            $('#variable_by_day').hide();
                            $('#variable_by_variable').hide();
                            $('#connection_detail').hide();
                            if (daily_bd_val == false && campaign_val == false && zone_val == false) {
                                $('#no_worksheet').show();
                            }
                            else {
                                $('#no_worksheet').hide();
                            }
                        }
                        if (report_type == 2) {
                            $('#report_window, #generate').show();
                            $('#aar,#cdr,#ctr').hide();
                            $('#car').show();
                            $('#campaign').show();
                            $('#orders_websites').hide();
                            $('#limitations').hide();
                            $('#delivery_rules').show();
                            $('#worksheets').show();
                            $('#campaign_check').hide();
                            $('#ad_check').show();
                            $('#zone_check').show();
                            $('#daily_check').show();
                            $('#performance_check').hide();
                            $('#connection_by_day').hide();
                            $('#variable_by_day').hide();
                            $('#variable_by_variable').hide();
                            $('#connection_detail').hide();
                            if (daily_bd_val == false && ad_val == false && zone_val == false) {
                                $('#no_worksheet').show();
                            }
                            else {
                                $('#no_worksheet').hide();
                            }
                        }
                        if (report_type == 3) {
                            $('#report_window, #generate').show();
                            $('#aar,#car,#ctr').hide();
                            $('#cdr').show();
                            $('#campaign').hide();
                            $('#orders_websites').show();
                            $('#limitations').show();
                            $('#delivery_rules').hide();
                            $('#worksheets').hide();
                            $('#performance_check').hide();
                            $('#connection_by_day').hide();
                            $('#variable_by_day').hide();
                            $('#variable_by_variable').hide();
                            $('#connection_detail').hide();
                            $('#no_worksheet').hide();
                        }

                        if (report_type == 4) {
                            $('#report_window, #generate').show();
                            $('#aar,#car,#cdr').hide();
                            $('#ctr').show();
                            $('#campaign').hide();
                            $('#orders_websites').show();
                            $('#limitations').show();
                            $('#delivery_rules').hide();
                            $('#worksheets').show();
                            $('#performance_check').show();
                            $('#connection_by_day').show();
                            $('#variable_by_day').show();
                            $('#variable_by_variable').show();
                            $('#connection_detail').show();
                            $('#campaign_check').hide();
                            $('#zone_check').hide();
                            $('#daily_check').hide();
                            $('#ad_check').hide();
                            if ((performance_val == false) || (connection_by_day_val == false) || (variable_by_day_val == false) || (variable_by_variable_val == false) || (connection_detail_val == false)) {
                                $('#no_worksheet').show();
                            }
                            else {
                                $('#no_worksheet').hide();
                            }
                        }
                        if (report_type == 0) {
                            $('#report_window').hide();
                            $('#no_worksheet').hide();
                        }
                    }

                    function change_period() {
                        // Get the current date and time
                        const now = new Date();
                        // Create options for formatting the date and time
                        const options = {
                            timeZone,
                            weekday: 'short',
                            year: 'numeric',
                            month: 'short',
                            day: 'numeric',
                            hour: 'numeric',
                            minute: 'numeric',
                            second: 'numeric',
                            timeZoneName: 'short'
                        };

                        // Format the date and time
                        const formatter = new Intl.DateTimeFormat('en-US', options);
                        const formattedDate = formatter.format(now);

                        // Remove commas from the formatted date and time
                        let dateString1 = formattedDate.replace(/,/g, '');
                        let dateString = `"${dateString1}"`;
                        // Split the date string by spaces
                        let parts = dateString.split(' ');

                        // Extract the date components
                        let dayOfWeek = parts[0];
                        let month = parts[1];
                        let day = parts[2];
                        let year = parts[3];

                        // Convert month abbreviation to numeric month
                        let monthIndex = {
                            'Jan': '01', 'Feb': '02', 'Mar': '03', 'Apr': '04', 'May': '05', 'Jun': '06',
                            'Jul': '07', 'Aug': '08', 'Sep': '09', 'Oct': '10', 'Nov': '11', 'Dec': '12'
                        }[month];

                        // Construct the ISO formatted date
                        let date = `${year}-${monthIndex}-${day}`;

                        let getSelectedDay = $('#period').val();
                        document.getElementById('daterange').style.display = getSelectedDay == 'Custom' ? "block" : "none";

                        if (getSelectedDay == 'Today') {
                            let date_data = date;
                            start_date = date_data;
                            end_date = date_data;
                        }
                        else if (getSelectedDay == 'Yesterday') {
                            let dateObj = new Date(date);
                            dateObj.setDate(dateObj.getDate() - 1);
                            let year = dateObj.getFullYear();
                            let month = ('0' + (dateObj.getMonth() + 1)).slice(-2);
                            let day = ('0' + dateObj.getDate()).slice(-2);
                            let yesterday_date = year + '-' + month + '-' + day;
                            start_date = yesterday_date;
                            end_date = yesterday_date;
                        }
                        else if (getSelectedDay == 'Last 7 days') {
                            let dateObj = new Date(date);
                            dateObj.setDate(dateObj.getDate() - 7);
                            let year = dateObj.getFullYear();
                            let month = ('0' + (dateObj.getMonth() + 1)).slice(-2);
                            let day = ('0' + dateObj.getDate()).slice(-2);
                            start_date = year + '-' + month + '-' + day;

                            let dateObj1 = new Date(date);
                            dateObj1.setDate(dateObj1.getDate() - 1);
                            let year1 = dateObj1.getFullYear();
                            let month1 = ('0' + (dateObj1.getMonth() + 1)).slice(-2);
                            let day1 = ('0' + dateObj1.getDate()).slice(-2);
                            end_date = year1 + '-' + month1 + '-' + day1;
                        }
                        else if (getSelectedDay == 'Last 30 days') {
                            let dateObj = new Date(date);
                            dateObj.setDate(dateObj.getDate() - 30);
                            let year = dateObj.getFullYear();
                            let month = ('0' + (dateObj.getMonth() + 1)).slice(-2);
                            let day = ('0' + dateObj.getDate()).slice(-2);
                            start_date = year + '-' + month + '-' + day;

                            let dateObj1 = new Date(date);
                            dateObj1.setDate(dateObj1.getDate() - 1);
                            let year1 = dateObj1.getFullYear();
                            let month1 = ('0' + (dateObj1.getMonth() + 1)).slice(-2);
                            let day1 = ('0' + dateObj1.getDate()).slice(-2);
                            end_date = year1 + '-' + month1 + '-' + day1;
                        }
                        else if (getSelectedDay == 'Last Month') {
                            let dateObj = new Date(date);
                            var prevMonthLastDate = new Date(dateObj.getFullYear(), dateObj.getMonth(), 0);
                            var prevMonthFirstDate = new Date(dateObj.getFullYear() - (dateObj.getMonth() > 0 ? 0 : 1), (dateObj.getMonth() - 1 + 12) % 12, 1);
                            var formatDateComponent = function (dateComponent) {
                                return (dateComponent < 10 ? '0' : '') + dateComponent;
                            }
                            var formatDate = function (dateObj) {
                                return dateObj.getFullYear() + "-" + formatDateComponent(dateObj.getMonth() + 1) + "-" + formatDateComponent(dateObj.getDate())
                            };
                            start_date = formatDate(prevMonthFirstDate);
                            end_date = formatDate(prevMonthLastDate);
                        }
                        else if (getSelectedDay == 'This Month') {
                            let dateObj = new Date(date);
                            let firstDay = new Date(dateObj.getFullYear(), dateObj.getMonth(), 1);
                            let cYear = firstDay.getFullYear(),
                                cMonth = firstDay.getMonth() + 1,
                                cDate = firstDay.getDate();
                            start_date = cYear + "-" + cMonth + "-" + cDate;

                            let dateObj1 = new Date(date);
                            let lastDay = new Date(dateObj1.getFullYear(), dateObj1.getMonth() + 1, 0);
                            let year = lastDay.getFullYear(),
                                month = lastDay.getMonth() + 1,
                                day = lastDay.getDate();
                            end_date = year + "-" + month + "-" + day;
                        }
                        else if (getSelectedDay == 'all') {
                            start_date = 0;
                            end_date = 0;
                        }
                        else if (getSelectedDay == 'Custom') {
                            const date1 = new Date();
                            let date_data1 = JSON.stringify(date1).slice(1, 11);
                            start_date = date_data1;
                            end_date = date_data1;
                            $(function () {
                                $('input[name="daterange"]').daterangepicker({
                                    opens: 'left',
                                    locale: {
                                        format: 'DD/MM/YYYY'
                                    },
                                }, function (start, end, label) {
                                    start_date = start.format('YYYY-MM-DD');
                                    end_date = end.format('YYYY-MM-DD');
                                })
                            })
                        }
                        console.log("start_date", start_date, "end_date", end_date);
                    };

                    function generate_report() {
                        var report_api;
                        var report_type = $('#standard_reports').val();
                        change_period();
                        var orders_id = $('#orders').val();
                        var orders_name = $('#orders option:selected').text();
                        var campaign_id = $('#campaign_select').val();
                        var campaign_name = $('#campaign_select option:selected').text();
                        var website_id = $('#websites').val();
                        var website_name = $('#websites option:selected').text();
                        var daily_bd_val = $('#daily_bd').is(':checked');
                        var campaign_val = $('#campaign_bd').is(':checked');
                        var ad_val = $('#ad_bd').is(':checked');
                        var zone_val = $('#zone_bd').is(':checked');
                        var performance_val = $('#performance_bd').is(':checked');
                        var connection_by_day_val = $('#connection_by_day_bd').is(':checked');
                        var variable_by_day_val = $('#variable_by_day_bd').is(':checked');
                        var variable_by_variable_val = $('#variable_by_variable_bd').is(':checked');
                        var connection_detail_val = $('#connection_detail_bd').is(':checked');
                        var action = $('#period').val();
                        if (report_type == '1') {
                            report_api = stat_URL + '/get_advertising_analysis_report';
                            var formData = {
                                "report_name": 'Advertising Analysis Report',
                                "orders_id": orders_id,
                                "orders_name": orders_name,
                                "website_id": website_id,
                                "website_name": website_name,
                                "start_date": start_date + ' 00:00:00,',
                                "end_date": end_date + ' 23:59:59,',
                                "daily_bd": daily_bd_val,
                                "campaign_bd": campaign_val,
                                "zone_bd": zone_val,
                                "action": action,
                            }
                        }

                        if (report_type == '2') {
                            report_api = stat_URL + '/get_campaign_analysis_report';
                            var formData = {
                                "report_name": 'Campaign Analysis Report',
                                "campaign_id": campaign_id,
                                "campaign_name": campaign_name,
                                "website_id": website_id,
                                "website_name": website_name,
                                "start_date": start_date + ' 00:00:00,',
                                "end_date": end_date + ' 23:59:59,',
                                "daily_bd": daily_bd_val,
                                "ad_val": ad_val,
                                "zone_bd": zone_val,
                                "action": action,
                            }
                        }
                        if (report_type == '3') {
                            report_api = stat_URL + '/get_delivery_analysis_report';
                            var formData = {
                                "report_name": 'Campaign Delivery Report',
                                "orders_id": orders_id,
                                "orders_name": orders_name,
                                "website_id": website_id,
                                "website_name": website_name,
                                "start_date": start_date + ' 00:00:00,',
                                "end_date": end_date + ' 23:59:59,',
                                "action": action,
                            }
                        }
                        if (report_type == '4') {
                            report_api = stat_URL + '/get_convertion_analysis_report';
                            var formData = {
                                "report_name": 'Conversion Tracking Report',
                                "orders_id": orders_id,
                                "orders_name": orders_name,
                                "website_id": website_id,
                                "website_name": website_name,
                                "start_date": start_date + ' 00:00:00,',
                                "end_date": end_date + ' 23:59:59,',
                                "action": action,
                                "performance_bd": performance_val,
                                "connection_by_day_bd": connection_by_day_val,
                                "variable_by_day_bd": variable_by_day_val,
                                "variable_by_variable_bd": variable_by_variable_val,
                                "connection_detail_bd": connection_detail_val,
                            }
                        }

                        $.ajax({
                            type: "POST",
                            url: report_api + '/' + agencyid,
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            data: formData,
                            dataType: "json",
                            encode: true,
                        }).done(function (data) {
                            if (action != 'all') {
                                sdate = start_date.split("-").reverse().join("-");
                                edate = end_date.split("-").reverse().join("-");
                            } else {
                                sdate = 'Beginning';
                                let date = new Date();
                                date = JSON.stringify(date).slice(1, 11);
                                edate = date.split("-").reverse().join("-");;
                            }
                            console.log('result', data);

                            if (data.report_name == 'Advertising Analysis Report') {
                                if (daily_bd_val == false && campaign_val == false && zone_val == false) {
                                    $('#no_worksheet').show();
                                }
                                else {
                                    $(".loader").show();
                                    $('#no_worksheet').hide();
                                    //head table
                                    let row = [[{ v: data.report_name, t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                    [{ v: '<?php echo $GLOBALS['ordersjobs']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: orders_name, t: "s", s: { border: { top: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }],
                                    [{ v: '<?php echo $GLOBALS['website']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: website_name, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }],
                                    [{ v: '<?php echo $GLOBALS['strStartDate']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { left: { style: "thin" }, bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: sdate, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }],
                                    [{ v: '<?php echo $GLOBALS['strEndDate']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: edate, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }]];
                                    //daily table
                                    let daily_table_row = [[{ v: '<?php echo $GLOBALS['daily_bd']; ?>', t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                    [{ v: '<?php echo $GLOBALS['strday']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strImpressions']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strClicks']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strCTR']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['revenue']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strECPM']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                    ];
                                    //campaign table
                                    let campaign_table_row = [[{ v: '<?php echo $GLOBALS['campaign_bd']; ?>', t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                    [{ v: '<?php echo $GLOBALS['strName']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strImpressions']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strClicks']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strCTR']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strSpend']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strECPM']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                    ];
                                    //zone table
                                    let zone_table_row = [[{ v: '<?php echo $GLOBALS['zone_bd']; ?>', t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                    [{ v: '<?php echo $GLOBALS['strName']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strImpressions']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strClicks']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strCTR']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['revenue']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strECPM']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                    ];
                                    daily_table_row = row.concat([''], ['']).concat(daily_table_row);
                                    campaign_table_row = row.concat([''], ['']).concat(campaign_table_row);
                                    zone_table_row = row.concat([''], ['']).concat(zone_table_row);
                                    var daily_break = data.daily;
                                    var campaign_break = data.campaign;
                                    var zone_break = data.zone;
                                    //Get daily data
                                    if (daily_break.length > 0) {
                                        for (var i = 0; i < daily_break.length; i++) {
                                            var daily_row = [{ v: daily_break[i].date, t: "s", s: { border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: daily_break[i].impressions, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: daily_break[i].clicks, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: daily_break[i].ctr, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: daily_break[i].revenue, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: daily_break[i].ecpm, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }];
                                            daily_table_row = daily_table_row.concat([daily_row]);
                                        }
                                    } else {
                                        var daily_row = [{ v: '<?php echo $GLOBALS['strNo_Data_Meassages']; ?>', t: "s", s: { border: { left: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }];
                                        daily_table_row = daily_table_row.concat([daily_row]);
                                    }
                                    //Get campaign data
                                    if (campaign_break.length > 0) {
                                        for (var i = 0; i < campaign_break.length; i++) {
                                            var campaign_row = [{ v: campaign_break[i].campaignname, t: "s", s: { border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: campaign_break[i].impressions, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: campaign_break[i].clicks, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: campaign_break[i].ctr, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: campaign_break[i].revenue, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: campaign_break[i].ecpm, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }];
                                            campaign_table_row = campaign_table_row.concat([campaign_row]);
                                        }
                                    } else {
                                        var campaign_row = [{ v: '<?php echo $GLOBALS['strNo_Data_Meassages']; ?>', t: "s", s: { border: { left: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }];
                                        campaign_table_row = campaign_table_row.concat([campaign_row]);
                                    }
                                    //Get zone data
                                    if (zone_break.length > 0) {
                                        for (var i = 0; i < zone_break.length; i++) {
                                            var zone_row = [{ v: zone_break[i].zonename, t: "s", s: { border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: zone_break[i].impressions, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: zone_break[i].clicks, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: zone_break[i].ctr, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: zone_break[i].revenue, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: zone_break[i].ecpm, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }];
                                            zone_table_row = zone_table_row.concat([zone_row]);
                                        }
                                    } else {
                                        var zone_row = [{ v: '<?php echo $GLOBALS['strNo_Data_Meassages']; ?>', t: "s", s: { border: { left: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }];
                                        zone_table_row = zone_table_row.concat([zone_row]);
                                    }
                                    //Create a new workbook
                                    const wb = XLSX.utils.book_new();
                                    //Create worksheet with rows; Add worksheet to workbook
                                    const daily_sheet = XLSX.utils.json_to_sheet(daily_table_row, {
                                        skipHeader: true
                                    });
                                    const campaign_sheet = XLSX.utils.json_to_sheet(campaign_table_row, {
                                        skipHeader: true
                                    });
                                    const zone_sheet = XLSX.utils.json_to_sheet(zone_table_row, {
                                        skipHeader: true
                                    });
                                    daily_sheet['!cols'] = [{ width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }];
                                    campaign_sheet['!cols'] = [{ width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }];
                                    zone_sheet['!cols'] = [{ width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }];
                                    if (daily_bd_val == true) {
                                        XLSX.utils.book_append_sheet(wb, daily_sheet, "Daily Breakdown");
                                    }
                                    if (campaign_val == true) {
                                        XLSX.utils.book_append_sheet(wb, campaign_sheet, "Campaign Breakdown");
                                    }
                                    if (zone_val == true) {
                                        XLSX.utils.book_append_sheet(wb, zone_sheet, "Zone Breakdown");
                                    }
                                    $(".loader").hide();
                                    // Write Excel file
                                    XLSX.writeFile(wb, data.report_name + ' From ' + sdate + ' To ' + edate + '.xlsx');
                                }
                            }

                            if (data.report_name == 'Campaign Analysis Report') {
                                if (daily_bd_val == false && ad_val == false && zone_val == false) {
                                    $('#no_worksheet').show();
                                }
                                else {
                                    $(".loader").show();
                                    $('#no_worksheet').hide();
                                    // STEP 1: Create a new workbook
                                    const wb = XLSX.utils.book_new();
                                    var order = data.order[0].clientname;
                                    //head table
                                    let row = [[{ v: data.report_name, t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                    [{ v: '<?php echo $GLOBALS['ordersjobs']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: order, t: "s", s: { border: { top: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }],
                                    [{ v: '<?php echo $GLOBALS['campaign']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: campaign_name, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }],
                                    [{ v: '<?php echo $GLOBALS['strStartDate']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { left: { style: "thin" }, bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: sdate, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }],
                                    [{ v: '<?php echo $GLOBALS['strEndDate']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: edate, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }]];
                                    //daily table
                                    let daily_table_row = [[{ v: '<?php echo $GLOBALS['daily_bd']; ?>', t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                    [{ v: '<?php echo $GLOBALS['strday']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strImpressions']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strClicks']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strCTR']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['revenue']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strECPM']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                    ];
                                    //campaign table
                                    let ad_table_row = [[{ v: '<?php echo $GLOBALS['ad_bd']; ?>', t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                    [{ v: '<?php echo $GLOBALS['strName']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strImpressions']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strClicks']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strCTR']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strSpend']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strECPM']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                    ];
                                    //zone table
                                    let zone_table_row = [[{ v: '<?php echo $GLOBALS['zone_bd']; ?>', t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                    [{ v: '<?php echo $GLOBALS['strName']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strImpressions']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strClicks']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strCTR']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['revenue']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strECPM']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                    ];
                                    daily_table_row = row.concat([''], ['']).concat(daily_table_row);
                                    ad_table_row = row.concat([''], ['']).concat(ad_table_row);
                                    zone_table_row = row.concat([''], ['']).concat(zone_table_row);
                                    var daily_break = data.camp_daily;
                                    var campaign_break = data.camp_ad;
                                    var zone_break = data.camp_zone;
                                    //Get daily data
                                    if (daily_break.length > 0) {
                                        for (var i = 0; i < daily_break.length; i++) {
                                            var daily_row = [{ v: daily_break[i].date, t: "s", s: { border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: daily_break[i].impressions, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: daily_break[i].clicks, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: daily_break[i].ctr, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: daily_break[i].revenue, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: daily_break[i].ecpm, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }];
                                            daily_table_row = daily_table_row.concat([daily_row]);
                                        }
                                    } else {
                                        var daily_row = [{ v: '<?php echo $GLOBALS['strNo_Data_Meassages']; ?>', t: "s", s: { border: { left: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }];
                                        daily_table_row = daily_table_row.concat([daily_row]);
                                    }
                                    //Get campaign data
                                    if (campaign_break.length > 0) {
                                        for (var i = 0; i < campaign_break.length; i++) {
                                            var campaign_row = [{ v: campaign_break[i].bannername, t: "s", s: { border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: campaign_break[i].impressions, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: campaign_break[i].clicks, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: campaign_break[i].ctr, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: campaign_break[i].revenue, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: campaign_break[i].ecpm, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }];
                                            ad_table_row = ad_table_row.concat([campaign_row]);
                                        }
                                    } else {
                                        var campaign_row = [{ v: '<?php echo $GLOBALS['strNo_Data_Meassages']; ?>', t: "s", s: { border: { left: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }];
                                        ad_table_row = ad_table_row.concat([campaign_row]);
                                    }
                                    //Get zone data
                                    if (zone_break.length > 0) {
                                        for (var i = 0; i < zone_break.length; i++) {
                                            var zone_row = [{ v: zone_break[i].zonename, t: "s", s: { border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: zone_break[i].impressions, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: zone_break[i].clicks, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: zone_break[i].ctr, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: zone_break[i].revenue, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: zone_break[i].ecpm, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }];
                                            zone_table_row = zone_table_row.concat([zone_row]);
                                        }
                                    } else {
                                        var zone_row = [{ v: '<?php echo $GLOBALS['strNo_Data_Meassages']; ?>', t: "s", s: { border: { left: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }];
                                        zone_table_row = zone_table_row.concat([zone_row]);
                                    }
                                    //Create worksheet with rows; Add worksheet to workbook
                                    const daily_sheet = XLSX.utils.json_to_sheet(daily_table_row, {
                                        skipHeader: true
                                    });
                                    const campaign_sheet = XLSX.utils.json_to_sheet(ad_table_row, {
                                        skipHeader: true
                                    });
                                    const zone_sheet = XLSX.utils.json_to_sheet(zone_table_row, {
                                        skipHeader: true
                                    });
                                    daily_sheet['!cols'] = [{ width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }];
                                    campaign_sheet['!cols'] = [{ width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }];
                                    zone_sheet['!cols'] = [{ width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }];
                                    if (daily_bd_val == true) {
                                        XLSX.utils.book_append_sheet(wb, daily_sheet, "Daily Breakdown");
                                    }
                                    if (ad_val == true) {
                                        XLSX.utils.book_append_sheet(wb, campaign_sheet, "Ad Breakdown");
                                    }
                                    if (zone_val == true) {
                                        XLSX.utils.book_append_sheet(wb, zone_sheet, "Zone Breakdown");
                                    }
                                    $(".loader").hide();
                                    // Write Excel file
                                    XLSX.writeFile(wb, data.report_name + ' From ' + sdate + ' To ' + edate + '.xlsx');
                                }
                            }

                            if (data.report_name == 'Campaign Delivery Report') {
                                $(".loader").show();
                                //head table
                                let cdr_head = [[{ v: data.report_name, t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                [{ v: '<?php echo $GLOBALS['ordersjobs']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: orders_name, t: "s", s: { border: { top: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }],
                                [{ v: '<?php echo $GLOBALS['website']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: website_name, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }],
                                [{ v: '<?php echo $GLOBALS['strStartDate']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { left: { style: "thin" }, bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: sdate, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }],
                                [{ v: '<?php echo $GLOBALS['strEndDate']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: edate, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }]];

                                //daily table
                                let delivery_table_row = [[{ v: '<?php echo $GLOBALS['camp_del']; ?>', t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                [{ v: '<?php echo $GLOBALS['campaign_name']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['type']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['status']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['priority']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strStartDate']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strEndDate']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['booked_imp']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['delivered_imp']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '% ' + '<?php echo $GLOBALS['complete']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['overall']; ?>' + ' +/-', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['current']; ?>' + ' +/-', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                ];

                                delivery_table_row = cdr_head.concat([''], ['']).concat(delivery_table_row);

                                var camp_del = data.delivery_camp;
                                var i;
                                if (camp_del.length > 0) {
                                    for (i = 0; i < camp_del.length; i++) {
                                        var camp_end_date;
                                        if (camp_del[i].priority == 0) {
                                            var camp_priority = 'Remnant';
                                        }
                                        var type;
                                        if (camp_del[i].target == '') {
                                            type = "Run of Site";
                                        } else {
                                            type = "Targeted";
                                        }
                                        if (camp_del[i].status == 0) {
                                            var camp_status = "Running";
                                        }
                                        camp_end_date = (camp_del[i].enddate == null) ? '-' : camp_del[i].enddate;

                                        var camp_row = [{ v: camp_del[i].campaignname, t: "s", s: { border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: type, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: camp_status, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: camp_priority, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: camp_del[i].startdate, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: camp_end_date, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: camp_del[i].booked_imp, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: camp_del[i].impressions, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: '-', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: '-', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: '-', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }];

                                        delivery_table_row = delivery_table_row.concat([camp_row]);

                                    }
                                } else {
                                    var camp_row = [{ v: '<?php echo $GLOBALS['strNo_Data_Meassages']; ?>', t: "s", s: { border: { left: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }];
                                    delivery_table_row = delivery_table_row.concat([camp_row]);
                                }

                                const delivery_sheet = XLSX.utils.json_to_sheet(delivery_table_row, {
                                    skipHeader: true
                                });

                                delivery_sheet['!cols'] = [{ width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }];

                                const workbook = XLSX.utils.book_new();
                                $(".loader").hide();
                                XLSX.utils.book_append_sheet(workbook, delivery_sheet, "Campaign Delivery");

                                return XLSX.writeFile(workbook, data.report_name + ' From ' + sdate + ' To ' + edate + '.xlsx');
                            }

                            if (data.report_name == 'Conversion Tracking Report') {
                                if ((performance_val == false) && (connection_by_day_val == false) && (variable_by_day_val == false) && (variable_by_variable_val == false) && (connection_detail_val == false)) {
                                    $('#no_worksheet').show();
                                }
                                else {
                                    $(".loader").show();
                                    $('#no_worksheet').hide();
                                    //head table
                                    let ctr_head = [[{ v: data.report_name, t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                    [{ v: '<?php echo $GLOBALS['ordersjobs']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: orders_name, t: "s", s: { border: { top: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }],
                                    [{ v: '<?php echo $GLOBALS['website']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: website_name, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }],
                                    [{ v: '<?php echo $GLOBALS['strStartDate']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { left: { style: "thin" }, bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: sdate, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }],
                                    [{ v: '<?php echo $GLOBALS['strEndDate']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: edate, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }]];

                                    //performance by day table
                                    let day_table_row = [[{ v: '<?php echo $GLOBALS['performance_bd']; ?>', t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                    [{ v: '<?php echo $GLOBALS['strday']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strRequests']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strConversions']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "t hin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['']; ?>BV', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['']; ?>Num.Items', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['']; ?>Rev.CPC', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['']; ?>ERPM', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strImpressions']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strClicks']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strCTR']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['revenue']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strECPM']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                    ];
                                    day_table_row = ctr_head.concat([''], ['']).concat(day_table_row);
                                    var day_break = data.daily_track;
                                    var i;
                                    if (day_break.length > 0) {
                                        for (i = 0; i < day_break.length; i++) {
                                            var day_row = [{ v: day_break[i].date, t: "s", s: { border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: day_break[i].requests, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: day_break[i].conversions, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '-', t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '0', t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: day_break[i].revcpc, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: day_break[i].erpm, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: day_break[i].impressions, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: day_break[i].clicks, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: day_break[i].ctr + '%', t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: day_break[i].revenue, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: day_break[i].ecpm, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }];
                                            day_table_row = day_table_row.concat([day_row]);
                                        }
                                    } else {
                                        var day_row = [{ v: '<?php echo $GLOBALS['strNo_Data_Meassages']; ?>', t: "s", s: { border: { left: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }];
                                        day_table_row = day_table_row.concat([day_row]);
                                    }
                                    const day_sheet = XLSX.utils.json_to_sheet(day_table_row, {
                                        skipHeader: true
                                    });
                                    day_sheet['!cols'] = [{ width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }];

                                    //variable by day table
                                    var var_sum_day = data.variable_by_day;
                                    var j;
                                    var var_day_table_row = [];
                                    var var_sum_day_sheet;

                                    for (j = 0; j < var_sum_day.length; j++) {
                                        if (j == 0) {
                                            var_day_table_row = [[{ v: var_sum_day[j].trackername, t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                            [{ v: '<?php echo $GLOBALS['strday']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strConversions']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                            ];
                                        } else {
                                            var_day_table_row = var_day_table_row.concat([[{ v: var_sum_day[j].trackername, t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                            [{ v: '<?php echo $GLOBALS['strday']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strConversions']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                            ]);
                                        }

                                        var var_sum_day_det = var_sum_day[j].details;
                                        var i;
                                        if (var_sum_day_det.length > 0) {
                                            for (i = 0; i < var_sum_day_det.length; i++) {
                                                var var_sum_day_row = [{ v: var_sum_day_det[i].ConnectionDateTime, t: "s", s: { border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: var_sum_day_det[i].conversions, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }];
                                                var_day_table_row = var_day_table_row.concat([var_sum_day_row]);
                                            }
                                        } else {
                                            var var_sum_day_row = [{ v: '<?php echo $GLOBALS['strNo_Data_Meassages']; ?>', t: "s", s: { border: { left: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }];
                                            var_day_table_row = var_day_table_row.concat([var_sum_day_row]);
                                        }
                                        var_day_table_row = var_day_table_row.concat([''], ['']);
                                    }
                                    var_day_table_row = ctr_head.concat([''], ['']).concat(var_day_table_row);

                                    var_sum_day_sheet = XLSX.utils.json_to_sheet(var_day_table_row, {
                                        skipHeader: true
                                    });

                                    var_sum_day_sheet['!cols'] = [{ width: 35 }, { width: 35 }];



                                    //variable by variable table
                                    var var_sum_var_sheet;
                                    var var_sum_table_row = [];
                                    var var_sum_var = data.variable_by_var;
                                    var j;
                                    for (j = 0; j < var_sum_var.length; j++) {
                                        if (j == 0) {
                                            var_sum_table_row = [[{ v: var_sum_var[j].trackername + '-' + var_sum_var[j].variablename, t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                            [{ v: '<?php echo $GLOBALS['']; ?>value', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strConversions']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                            ];
                                        } else {
                                            var_sum_table_row = var_sum_table_row.concat([[{ v: var_sum_var[j].trackername + '-' + var_sum_var[j].variablename, t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                            [{ v: '<?php echo $GLOBALS['']; ?>value', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strConversions']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                            ]);
                                        }

                                        var i;
                                        if (var_sum_var.length > 0) {
                                            for (i = 0; i < var_sum_var.length; i++) {
                                                var var_sum_day_row = [{ v: '', t: "s", s: { border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: var_sum_var[i].conversions, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }];
                                                var_sum_table_row = var_sum_table_row.concat([var_sum_day_row]);
                                            }
                                        } else {
                                            var var_sum_day_row = [{ v: '<?php echo $GLOBALS['strNo_Data_Meassages']; ?>', t: "s", s: { border: { left: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }];
                                            var_sum_table_row = var_sum_table_row.concat([var_sum_day_row]);
                                        }
                                        var_sum_table_row = var_sum_table_row.concat([''], ['']);
                                    }
                                    var_sum_table_row = ctr_head.concat([''], ['']).concat(var_sum_table_row);
                                    var_sum_var_sheet = XLSX.utils.json_to_sheet(var_sum_table_row, {
                                        skipHeader: true
                                    });
                                    var_sum_var_sheet['!cols'] = [{ width: 35 }, { width: 35 }];


                                    //connection by day table
                                    var con_day_det1 = data.Connection_day;
                                    var j;
                                    var con_day_table_row = [];
                                    var con_day_sheet;
                                    for (j = 0; j < con_day_det1.length; j++) {
                                        if (j == 0) {
                                            con_day_table_row = [[{ v: con_day_det1[j].trackername, t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                            [{ v: '<?php echo $GLOBALS['strday']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['total_com']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['pending_con']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['approved_con']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['dup_con']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['disapproved_con']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['onhold_con']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['ignore_con']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                            ];
                                        } else {
                                            con_day_table_row = con_day_table_row.concat([[{ v: con_day_det1[j].trackername, t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                            [{ v: '<?php echo $GLOBALS['strday']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['total_com']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['pending_con']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['approved_con']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['dup_con']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['disapproved_con']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['onhold_con']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['ignore_con']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                            ]);
                                        }

                                        var con_day_det = con_day_det1[j].details;
                                        var i;
                                        if (con_day_det.length > 0) {
                                            for (i = 0; i < con_day_det.length; i++) {
                                                var approval_stat;
                                                if (con_day_det[i].approvalstatus == 0) {
                                                    approval_stat = '-';
                                                } else {
                                                    approval_stat = con_day_det[i].approvalstatus;
                                                }
                                                var ignore_stat;
                                                if (con_day_det[i].ignorestatus == 0) {
                                                    ignore_stat = '-';
                                                } else {
                                                    ignore_stat = con_day_det[i].ignorestatus;
                                                }
                                                var pending_stat;
                                                if (con_day_det[i].pendingstatus == 0) {
                                                    pending_stat = '-';
                                                } else {
                                                    pending_stat = con_day_det[i].pendingstatus;
                                                }

                                                var con_day_row = [{ v: con_day_det[i].ConnectionDateTime, t: "s", s: { border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: con_day_det[i].conversions, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: pending_stat, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: approval_stat, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '-', t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '-', t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '-', t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: ignore_stat, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }];
                                                con_day_table_row = con_day_table_row.concat([con_day_row]);
                                            }
                                        } else {
                                            var con_day_row = [{ v: '<?php echo $GLOBALS['strNo_Data_Meassages']; ?>', t: "s", s: { border: { left: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }];
                                            con_day_table_row = con_day_table_row.concat([con_day_row]);
                                        }
                                        con_day_table_row = con_day_table_row.concat([''], ['']);
                                    }
                                    con_day_table_row = ctr_head.concat([''], ['']).concat(con_day_table_row);
                                    con_day_sheet = XLSX.utils.json_to_sheet(con_day_table_row, {
                                        skipHeader: true
                                    });
                                    con_day_sheet['!cols'] = [{ width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }];

                                    //connection_detail table
                                    var con_break1 = data.connection_detail;
                                    var j;
                                    var con_table_row = [];
                                    var con_sheet;
                                    for (j = 0; j < con_day_det1.length; j++) {
                                        if (j == 0) {
                                            con_table_row = [[{ v: con_break1[j].trackername, t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                            [{ v: '<?php echo $GLOBALS['con_id']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['con_date_time']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['approval_status']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['comment']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['source']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['adv_name']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['tracker_name']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['ad_name']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['website_name']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['zone_name']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['con_type']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['con_val_date']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['ip']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strGeo_Report_Country']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['domain']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['language']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['os']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['browser']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['window_delay']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                            ];
                                        } else {
                                            con_table_row = con_table_row.concat([[{ v: con_break1[j].trackername, t: "s", s: { font: { sz: 14, bold: true, color: { rgb: "0066CC" } } } }],
                                            [{ v: '<?php echo $GLOBALS['con_id']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['con_date_time']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['approval_status']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['comment']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['source']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['adv_name']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['tracker_name']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['ad_name']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['website_name']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['zone_name']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['con_type']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['con_val_date']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['ip']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['strGeo_Report_Country']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['domain']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['language']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['os']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['browser']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }, { v: '<?php echo $GLOBALS['window_delay']; ?>', t: "s", s: { font: { bold: true }, fill: { fgColor: { rgb: "E9E9E9" } }, border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } } } }],
                                            ]);
                                        }

                                        var con_break = con_break1[j].details;
                                        var i;
                                        if (con_break.length > 0) {
                                            for (i = 0; i < con_break.length; i++) {
                                                var con_det_status;
                                                if (con_break[i].connectionstatus == '1') {
                                                    con_det_status = 'Ignore';
                                                } else if (con_break[i].connectionstatus == '2') {
                                                    con_det_status = 'Pending';
                                                } else if (con_break[i].connectionstatus == '4') {
                                                    con_det_status = 'Approved';
                                                }
                                                var days;
                                                var partDay;
                                                var hours;
                                                var partHour;
                                                var minutes;
                                                var seconds;
                                                var windowDelay;

                                                var eventDateSt = (Date.parse(con_break[i].ConnectionDateTime)) / 1000;
                                                var secondsLeft = eventDateSt - (Date.parse(con_break[i].ConnectingValueDate_Time) / 1000);
                                                days = parseInt(secondsLeft / 86400);  // 86400 seconds in a day
                                                partDay = secondsLeft - (days * 86400);
                                                hours = parseInt(partDay / 3600);  // 3600 seconds in an hour
                                                partHour = partDay - (hours * 3600);
                                                minutes = parseInt(partHour / 60);  // 60 seconds in a minute
                                                seconds = partHour - (minutes * 60);
                                                windowDelay = days + "d " + hours + "h " + minutes + "m " + seconds + "s";

                                                // var con_type;
                                                // if (con_break[i].connection_action == '0') {
                                                //     con_type = 'Impression';
                                                // } else {
                                                //     con_type = 'Click';
                                                // }
                                                var comments;
                                                if (con_break[i].connection_comments == null) {
                                                    comments = '-';
                                                } else {
                                                    comments = con_break[i].connection_comments;
                                                }
                                                var country;
                                                if (con_break[i].connection_country == null) {
                                                    country = '-';
                                                } else {
                                                    country = con_break[i].connection_country;
                                                }
                                                var domain;
                                                if (con_break[i].connection_domain == null) {
                                                    domain = '-';
                                                } else {
                                                    domain = con_break[i].connection_domain;
                                                }
                                                var language;
                                                if (con_break[i].connection_language == null) {
                                                    language = '-';
                                                } else {
                                                    language = con_break[i].connection_language;
                                                }
                                                var os;
                                                if (con_break[i].connection_os == null) {
                                                    os = '-';
                                                } else {
                                                    os = con_break[i].connection_os;
                                                }
                                                var browser;
                                                if (con_break[i].connection_browser == null) {
                                                    browser = '-';
                                                } else {
                                                    browser = con_break[i].connection_browser;
                                                }

                                                var con_row = [{ v: con_break[i].connectionid, t: "s", s: { border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: con_break[i].ConnectionDateTime, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: con_det_status, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: comments, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: "-", t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: con_break[i].advertisername, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: con_break[i].trackername, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: con_break[i].adName, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: con_break[i].websitename, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: con_break[i].zonename, t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }, { v: 'Impression', t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: con_break[i].ConnectingValueDate_Time, t: "s", s: { border: { left: { style: "thin" }, right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: con_break[i].connection_ip_address, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: country, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: domain, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: language, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: os, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: browser, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }, { v: windowDelay, t: "s", s: { border: { right: { style: "thin" }, bottom: { style: "thin" } } } }];
                                                con_table_row = con_table_row.concat([con_row]);
                                            }
                                        } else {
                                            var con_row = [{ v: '<?php echo $GLOBALS['strNo_Data_Meassages']; ?>', t: "s", s: { border: { left: { style: "thin" }, bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" } } } }, { v: '', t: "s", s: { border: { bottom: { style: "thin" }, right: { style: "thin" } } } }];
                                            con_table_row = con_table_row.concat([con_row]);
                                        }
                                        con_table_row = con_table_row.concat([''], ['']);
                                    }
                                    con_table_row = ctr_head.concat([''], ['']).concat(con_table_row);
                                    con_sheet = XLSX.utils.json_to_sheet(con_table_row, {
                                        skipHeader: true
                                    });

                                    con_sheet['!cols'] = [{ width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }, { width: 35 }];

                                    const workbook = XLSX.utils.book_new();
                                    $(".loader").hide();
                                    if (performance_val == true) {
                                        XLSX.utils.book_append_sheet(workbook, day_sheet, "Performance By Day");
                                    }
                                    if (connection_by_day_val == true) {
                                        XLSX.utils.book_append_sheet(workbook, con_day_sheet, "Connection Summary by Day");
                                    }
                                    if (variable_by_day_val == true) {
                                        XLSX.utils.book_append_sheet(workbook, var_sum_day_sheet, "Variable Summary by Day");
                                    }
                                    if (variable_by_variable_val == true) {
                                        XLSX.utils.book_append_sheet(workbook, var_sum_var_sheet, "Variable Summary by Variable");
                                    }
                                    if (connection_detail_val == true) {
                                        XLSX.utils.book_append_sheet(workbook, con_sheet, "Connection Detail");
                                    }
                                    return XLSX.writeFile(workbook, data.report_name + ' From ' + sdate + ' To ' + edate + '.xlsx');
                                }
                            }
                        });
                    }
                </script>

            </div>
            <!-- Overlay -->
            <div class="layout-overlay layout-menu-toggle"></div>
        </div>
</body>

</html>