<?php
include ('session.php');
include ('../config.php');
include ('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?>-
        <?php echo $GLOBALS['advanced']; ?>
    </title>
    <meta name="description" content="" />
    <?php include ('head.php'); ?>
    <style>
        .cancel-style {
            color: red !important
        }

        .cancel-style:hover {
            color: #fff !important
        }

        .nav {
            background: none !important;
        }

        .nav-pills .nav-link {

            border-radius: 0;
        }

        .alert {
            display: none;
        }
    </style>
</head>

<body onload="get_advanced()">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include ('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include ('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <form action="" method="POST" class=" mt-5">
                            <div class="nav-align-top mb-4">
                                <ul class="nav nav-tabs" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link" href="zone_edit.php?<?php if ($_GET['pubid']) {
                                            echo 'pubid=' . $_GET['pubid'] . '&' . 'affiliate_id=' . $_GET['affiliate_id'] . '&' . 'zoneid=' . $_GET['zoneid'];
                                        } else if ($_GET['pub_id']) {
                                            echo 'pub_id=' . $_GET['pub_id'] . '&' . 'affiliate_id=' . $_GET['affiliate_id'] . '&' . 'zoneid=' . $_GET['zoneid'];
                                        } else {
                                            echo 'zoneid=' . $_GET['zoneid'];
                                        }
                                        ?>"><span class="text-dark">
                                                <?php echo $GLOBALS['zone_prop']; ?>
                                            </span></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link active" href="#"><span class="text-primary">
                                                <?php echo $GLOBALS['advanced']; ?>
                                            </span></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="linked_banners.php?<?php if ($_GET['pubid']) {
                                            echo 'pubid=' . $_GET['pubid'] . '&' . 'affiliate_id=' . $_GET['affiliate_id'] . '&' . 'zoneid=' . $_GET['zoneid'];
                                        } else if ($_GET['pub_id']) {
                                            echo 'pub_id=' . $_GET['pub_id'] . '&' . 'affiliate_id=' . $_GET['affiliate_id'] . '&' . 'zoneid=' . $_GET['zoneid'];
                                        } else {
                                            echo 'zoneid=' . $_GET['zoneid'];
                                        }
                                        ?>"><span class="text-dark">
                                                <?php echo $GLOBALS['linked_banners']; ?>
                                            </span></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="probability.php?<?php if ($_GET['pubid']) {
                                            echo 'pubid=' . $_GET['pubid'] . '&' . 'affiliate_id=' . $_GET['affiliate_id'] . '&' . 'zoneid=' . $_GET['zoneid'];
                                        } else if ($_GET['pub_id']) {
                                            echo 'pub_id=' . $_GET['pub_id'] . '&' . 'affiliate_id=' . $_GET['affiliate_id'] . '&' . 'zoneid=' . $_GET['zoneid'];
                                        } else {
                                            echo 'zoneid=' . $_GET['zoneid'];
                                        }
                                        ?>"><span class="text-dark">
                                                <?php echo $GLOBALS['probability']; ?>
                                            </span></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="invocation.php?<?php if ($_GET['pubid']) {
                                            echo 'pubid=' . $_GET['pubid'] . '&' . 'affiliate_id=' . $_GET['affiliate_id'] . '&' . 'zoneid=' . $_GET['zoneid'];
                                        } else if ($_GET['pub_id']) {
                                            echo 'pub_id=' . $_GET['pub_id'] . '&' . 'affiliate_id=' . $_GET['affiliate_id'] . '&' . 'zoneid=' . $_GET['zoneid'];
                                        } else {
                                            echo 'zoneid=' . $_GET['zoneid'];
                                        }
                                        ?>"><span class="text-dark">
                                                <?php echo $GLOBALS['strInvocation']; ?>
                                            </span></a>
                                    </li>
                                </ul>

                                <div class="tab-content">
                                    <div class="tab-pane fade show active" id="navs-top-zoneproperties" role="tabpanel">
                                        <p class="alert bg-success alert-dismissible fade show text-white"
                                            id="alertsuccess"><i class="fa fa-check-circle"></i>&nbsp;
                                            <?php echo $GLOBALS['adv_success_msg']; ?>
                                        </p>
                                        <p class="alert bg-danger alert-dismissible fade show text-white"
                                            id="alertfailed"><i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['adv_fail_msg']; ?>
                                        </p>
                                        <div class="row mb-2">
                                            <p class="h5 text-dark">
                                                <?php echo $GLOBALS['chain_settings']; ?>
                                            </p>
                                        </div>
                                        <div class="row mb-2 mb-sm-2 mb-md-2 mb-lg-2 mb-xl-2 mb-xxl-2">
                                            <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                                <label class="col-form-label">
                                                    <?php echo $GLOBALS['no_ban']; ?>
                                                </label>
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                <select class="form-select text-dark" name="select_chain"
                                                    id="select_chain" onchange="get_zones();">
                                                    <option value="0">
                                                        <?php echo $GLOBALS['stop_del']; ?>
                                                    </option>
                                                    <option value="1" id="display_zone">
                                                        <?php echo $GLOBALS['display_sel_zone']; ?>
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row mb-2" id="other_zones">
                                            <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                <select class="form-select text-dark" name="instead_zones"
                                                    id="instead_zones">

                                                </select>
                                            </div>
                                        </div>
                                        <hr class="solid">

                                        <div class="row mb-2">
                                            <p class="h5 text-dark">
                                                <?php echo $GLOBALS['delivery_capping']; ?>
                                            </p>
                                            <p id="capping_error" class="h6 text-danger"></p>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                    <?php echo $GLOBALS['limit_views']; ?>
                                                </label>
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                <input type="number" name="limit_views" id="limit_views"
                                                    onchange="reset_time();" onkeyup="reset_time();"
                                                    class="form-control text-dark" onkeypress="return isNumber(event)"
                                                    placeholder="" />
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                    <?php echo $GLOBALS['limit_views_session']; ?>
                                                </label>
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                <input type="number" name="limit_views_session" id="limit_views_session"
                                                    onchange="reset_time();" onkeyup="reset_time();"
                                                    class="form-control text-dark" onkeypress="return isNumber(event)"
                                                    placeholder="" />
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                    <?php echo $GLOBALS['reset_view']; ?>
                                                </label>
                                            </div>
                                            <!-- &nbsp; -->
                                            <div class="col col-6 col-sm-6 col-md-1 col-lg-1 col-xl-1 col-xxl-1">
                                                <label class="form-label">
                                                    <?php echo $GLOBALS['hour']; ?>
                                                </label>
                                            </div>
                                            <div class="col col-6 col-sm-6 col-md-1 col-lg-1 col-xl-1 col-xxl-1">
                                                <input type="text" name="hour" id="hour" class="form-control text-dark"
                                                    onkeypress="return isNumber(event)" placeholder="" />
                                            </div>
                                            <div class="col col-6 col-sm-6 col-md-1 col-lg-1 col-xl-1 col-xxl-1">
                                                <label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['minutes']; ?>
                                                </label>
                                            </div>
                                            <div class="col col-6 col-sm-6 col-md-1 col-lg-1 col-xl-1 col-xxl-1 mt-2">
                                                <input type="text" name="minutes" id="minutes"
                                                    class="form-control text-dark" onkeypress="return isNumber(event)"
                                                    placeholder="" />
                                            </div>
                                            <div class="col col-6 col-sm-6 col-md-1 col-lg-1 col-xl-1 col-xxl-1">
                                                <label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['seconds']; ?>
                                                </label>
                                            </div>
                                            <div class="col col-6 col-sm-6 col-md-1 col-lg-1 col-xl-1 col-xxl-1 mt-2">
                                                <input type="text" name="seconds" id="seconds"
                                                    class="form-control text-dark" onkeypress="return isNumber(event)"
                                                    placeholder="" />
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                                <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                    <?php echo $GLOBALS['cookies']; ?>
                                                </label>
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                <input type="checkbox" class="form-check-input" id="cookies"
                                                    name="cookies" value="0"><label class="form-label">&nbsp;
                                                    <?php echo $GLOBALS['cookies_label']; ?>
                                                </label>
                                                <i class="fa fa-question-circle" data-toggle="tooltip"
                                                    title="<?php echo $GLOBALS['cookies_msg']; ?>"
                                                    aria-hidden="true"></i>
                                            </div>
                                        </div>
                                        <hr class="solid">
                                        <div class="row mb-2">
                                            <p class="h5 text-dark">
                                                <?php echo $GLOBALS['append_prepend_settings']; ?>
                                            </p>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                <input type="checkbox" class="form-check-input" id="forceappend">
                                                <label>&nbsp;
                                                    <?php echo $GLOBALS['prepend_append_nobanner']; ?>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                                <label class="col-form-label">
                                                    <?php echo $GLOBALS['prepend_html_code']; ?>
                                                </label>
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                <textarea type="textarea" class="form-control text-dark" rows="3"
                                                    id="prepend"></textarea>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                                <label class="col-form-label">
                                                    <?php echo $GLOBALS['append_html_code']; ?>
                                                </label>
                                            </div>
                                            <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                <textarea type="textarea" class="form-control text-dark" rows="3"
                                                    id="append"></textarea>
                                            </div>
                                        </div>
                                        <!-- style="position:relative;left:73%;" -->
                                        <div
                                            class="d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                            <button type="button" class="btn btn-outline-danger cancel-style"
                                                onclick="cancel()">
                                                <?php echo $GLOBALS['strCancel']; ?>
                                            </button>&nbsp;
                                            <button type="button" class="btn btn-primary"
                                                onclick="update_advanceddata()">
                                                <?php echo $GLOBALS['strUpdate']; ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <?php include ('footer.php'); ?>
            </div>
        </div>
    </div>

    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var zone_id = '<?php echo $_REQUEST['zoneid']; ?>';
        var affiliate_id = '<?php echo $_REQUEST['affiliate_id']; ?>';
        let publisherId = '<?php echo $_GET['pub_id'] ?>';
        var getZone_URL = live_URL + '/get_zone/' + zone_id;
        var agencyid = '<?php echo $_SESSION['agencyid']; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;

        $(document).ready(function () {
            $('#capping_error').hide();
            get_other_zones();
        });

        //get_other_zones
        function get_other_zones(id) {
            var x = $('#select_chain').val();
            if (x == 1) {
                $('#other_zones').show();
            } else {
                $('#other_zones').hide();
            }
            $.ajax({
                type: "GET",
                url: live_URL + '/get_sizewise_zone/' + agencyid + ',' + zone_id,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function (data) {
                console.log(data);
                var zones = [];
                if (!data.data) {
                    $('#display_zone').attr('disabled', true);
                } else {
                    $('#display_zone').attr('disabled', false);
                    data.data.map((data) => {
                        zones += `<option value=${data.zoneid}>${data.zonename}</option>`;
                    });
                    if (!id) {
                        $('#instead_zones').html(zones);
                    } else {
                        $('#instead_zones').val(id);
                    }
                }
            });
        }

        function get_zones() {
            var x = $('#select_chain').val();
            if (x == 1) {
                $('#other_zones').show();
            } else {
                $('#other_zones').hide();
            }
        }
        restrictAlphabets = (e) => {
            var x = e.which || e.keycode;
            if ((x >= 48 && x <= 57)) {
                return true;
            } else {
                return false;
            }
        };

        function reset_time() {
            capping = $('#limit_views').val();
            session_capping = $('#limit_views_session').val();
            if (capping == '' || Number(capping) < 0 || session_capping == '' || Number(session_capping) < 0) {
                $('#capping_error').show();
                $('#capping_error').html('<?php echo $GLOBALS['capping_error_msg']; ?>');
                return false;
            } else {
                $('#capping_error').hide();
            }
            if ($('#limit_views').val() > 0 || $('#limit_views_session').val() > 0) {
                $('#hour').prop("disabled", false);
                $('#minutes').prop("disabled", false);
                $('#seconds').prop("disabled", false);
            } else {
                $('#hour').val(0);
                $('#minutes').val(0);
                $('#seconds').val(0);
                $('#hour').prop("disabled", true);
                $('#minutes').prop("disabled", true);
                $('#seconds').prop("disabled", true);
            }
        }

        function isNumber(evt) {
            evt = (evt) ? evt : window.event;
            var charCode = (evt.which) ? evt.which : evt.keyCode;
            if (charCode > 31 && (charCode < 48 || charCode > 57)) {
                return false;
            }
            return true;
        }

        cancel = () => {
            console.log('hello');
            window.location.href = (affiliate_id != '') ?
                ('zonelist.php?affiliate_id=' + affiliate_id) : 'zonelist.php';
        };

        function get_advanced() {
            $.ajax({
                type: "GET",
                url: getZone_URL,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function (data) {
                console.log(data.data);

                var chain = data.data.chain;
                if (chain == '') {
                    $('#select_chain').val(0);
                } else {
                    $('#select_chain').val(1);
                    var zone_data = chain.split(':');
                    get_other_zones(zone_data[1]);
                }
                $('#limit_views').val(data.data.capping);
                $('#limit_views_session').val(data.data.session_capping);
                if ($('#limit_views').val() > 0 || $('#limit_views_session').val() > 0) {
                    $('#hour').prop("disabled", false);
                    $('#minutes').prop("disabled", false);
                    $('#seconds').prop("disabled", false);
                    var reset_time = data.data.block;
                    var h = Math.floor(reset_time / 3600);
                    var m = Math.floor(reset_time % 3600 / 60);
                    var s = Math.floor(reset_time % 3600 % 60);
                    $('#hour').val(h);
                    $('#minutes').val(m);
                    $('#seconds').val(s);
                } else {
                    $('#hour').val(0);
                    $('#minutes').val(0);
                    $('#seconds').val(0);
                    $('#hour').prop("disabled", true);
                    $('#minutes').prop("disabled", true);
                    $('#seconds').prop("disabled", true);
                }
                var cookie_set = data.data.show_capped_no_cookie;
                if (cookie_set == 1) {
                    $('#cookies').attr('checked', true);
                } else {
                    $('#cookies').attr('checked', false);
                }
                var forceappend = data.data.forceappend;
                if (forceappend == 't') {
                    $('#forceappend').attr('checked', true);
                } else {
                    $('#forceappend').attr('checked', false);
                }
                document.getElementById('prepend').value = data.data.prepend;
                document.getElementById('append').value = data.data.append;
            });
        }

        var editZone_URL = live_URL + '/edit_advanced_zone/' + zone_id;

        function update_advanceddata() {
            let chain_value;
            var chain, zone_value, cookies_value, force_append;
            chain_value = $('#select_chain').val();
            if (chain_value == 0) {
                chain = "";
            } else if (chain_value == 1) {
                zone_value = $('#instead_zones').val();
                chain = "zone:" + zone_value;
            }

            var capping = $('#limit_views').val();
            var session_capping = $('#limit_views_session').val();
            var hours = $('#hour').val();
            var minutes = $('#minutes').val();
            var seconds = $('#seconds').val();
            if (Number(capping) >= 0 && capping != '' && Number(session_capping) >= 0 && session_capping != '') {
                if (hours != '' && minutes != '' && seconds != '') {
                    var block = (hours * 3600 + minutes * 60 + seconds * 1);
                    var notanumber = isNaN(block);
                    if (notanumber == true) {
                        $('#capping_error').show();
                        $('#capping_error').html('<?php echo $GLOBALS['capping_error_msg']; ?>');
                        return false;
                    } else {
                        $('#capping_error').hide();
                    }
                } else {
                    $('#capping_error').show();
                    $('#capping_error').html('<?php echo $GLOBALS['capping_error']; ?>');
                    return false;
                }
            } else {
                $('#capping_error').show();
                $('#capping_error').html('<?php echo $GLOBALS['capping_error_msg']; ?>');
                return false;
            }

            if ($('#cookies').prop("checked") == true) {
                cookies_value = 1;
            } else {
                cookies_value = 0;
            }

            if ($('#forceappend').prop("checked") == true) {
                force_append = 't';
            } else {
                force_append = 'f';
            }
            let prepend = $('#prepend').val();
            let append = $('#append').val();

            let advancedData = {
                "chain": chain,
                "capping": capping,
                "session_capping": session_capping,
                "block": block,
                "show_capped_no_cookie": cookies_value,
                "forceappend": force_append,
                "append": append,
                "prepend": prepend,
                "mode": "edit"
            }

            $.ajax({
                type: "POST",
                url: editZone_URL,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: advancedData,
                dataType: "json",
                encode: true,
            }).done(function (data) {
                if (data.msg == "Advanced settings zone updated successfully") {
                    window.scrollTo(0, 0);
                    $("#alertsuccess").show('medium');
                    setTimeout(function () {
                        $("#alertsuccess").hide('medium');
                        location.reload();
                    }, 2000);
                } else {
                    window.scrollTo(0, 0);
                    $("#alertfailed").show('medium');
                    setTimeout(function () {
                        $("#alertfailed").hide('medium');
                    }, 1700);
                }
            });
        }
    </script>
</body>

</html>