<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['tracker']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        #trackername,
        #description,
        #type,
        #status {
            width: 50%;
            display: inline;
        }

        #check {
            margin-left: 4rem;
        }

        .alert {
            display: none;
        }
    </style>
</head>

<body onload=gettracker();>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="nav-align-top my-4 mx-3">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" href="#"><span class="text-primary">
                                            <?php echo $GLOBALS['tracker_properties']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_campaigns.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['link_campaigns']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_variables.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['variables']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_append.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['append_tracker_code']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_invocation.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['invocation_code']; ?>
                                        </span></a>
                                </li>
                            </ul>
                            <div class="tab-content">

                                <div>
                                    <p class="alert bg-success alert-dismissible fade show text-white"
                                        id="alertsuccess"><i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['tracker_update_success_msg']; ?>
                                    </p>
                                    <p class="alert bg-danger alert-dismissible fade show text-white" id="alertfailed">
                                        <i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['tracker_update_failed_msg']; ?>
                                    </p>
                                </div>
                                <form action="" method="POST">
                                    <div class="row mt-3">
                                        <h5>
                                            <?php echo $GLOBALS['tracker_info']; ?>
                                        </h5>
                                        <hr class="solid">
                                        <div class="mb-3 col-md-3">
                                            <label for="inputName" class="col-form-label" style="margin-left: 3rem;">
                                                <?php echo $GLOBALS['strName']; ?> <span class="required text-danger">
                                                    *</span>
                                            </label>
                                        </div>
                                        <div class="mb-3 col-md-9">
                                            <input type="text" class="form-control" id="trackername" name="trackername"
                                                oninput="onchangename(this.value);"
                                                onkeyup="onchangename(this.value);"
                                                onchange="onchangename(this.value);">
                                            <div id="name_msg"></div>
                                        </div>

                                        <div class="mb-3 col-md-3">
                                            <label for="inputName" class="col-form-label" style="margin-left: 3rem;">
                                                <?php echo $GLOBALS['strInventory_Description']; ?>
                                            </label>
                                        </div>
                                        <div class="mb-3 col-md-9">
                                            <input type="text" class="form-control" id="description" name="description">
                                        </div>

                                        <div class="mb-4 col-md-3">
                                            <label for="inputName" class="col-form-label" style="margin-left: 3rem;">
                                                <?php echo $GLOBALS['conversion_type']; ?>
                                            </label>
                                        </div>
                                        <div class="mb-4 col-md-9">
                                            <select id="type" name="type" class="form-select text-dark">
                                                <option value="1" selected>
                                                    <?php echo $GLOBALS['sale']; ?>
                                                </option>
                                                <option value="2">
                                                    <?php echo $GLOBALS['lead']; ?>
                                                </option>
                                                <option value="3">
                                                    <?php echo $GLOBALS['signup']; ?>
                                                </option>
                                            </select>
                                        </div>

                                        <div class="mb-4 col-md-3">
                                            <label for="inputName" class="col-form-label" style="margin-left: 3rem;">
                                                <?php echo $GLOBALS['default_status']; ?>
                                            </label>
                                        </div>
                                        <div class="mb-4 col-md-9">
                                            <select id="status" name="status" class="form-select text-dark">
                                                <option value="1">
                                                    <?php echo $GLOBALS['ignore']; ?>
                                                </option>
                                                <option value="2">
                                                    <?php echo $GLOBALS['pending']; ?>
                                                </option>
                                                <option value="4" selected>
                                                    <?php echo $GLOBALS['approved']; ?>
                                                </option>
                                            </select>
                                        </div>


                                        <div class="form-check mt-2" id="check">
                                            <input class="form-check-input" type="checkbox" id="linkcampaigns"
                                                name="linkcampaigns">
                                            <label class="form-check-label" for="flexSwitchCheckDefault">
                                                <?php echo $GLOBALS['link_campaigns_default']; ?>
                                            </label>
                                        </div>

                                    </div>
                                    <div class="row mb-3">
                                        <div
                                            class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        </div>
                                        <div
                                            class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                            <button type="button" class="btn btn-outline-danger" style=""
                                                onclick="window.location.href='advertiser_trackers.php?clientid=<?php echo $_REQUEST['clientid']; ?>'">
                                                <?php echo $GLOBALS['strCancel']; ?>
                                            </button>&nbsp;
                                            <button type="button" id="submitbtn" class="btn btn-primary submitbtn"
                                                onclick="trackeredit()">
                                                <?php echo $GLOBALS['strUpdate']; ?>
                                            </button>
                                        </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php include('footer.php'); ?>
        </div>
    </div>
    </div>
    <script src="../js/sweetalert.min.js"></script>
    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var clientid = '<?php echo $_REQUEST['clientid']; ?>';
        var trackerid = '<?php echo $_REQUEST['trackerid']; ?>';

        function gettracker() {
            $.ajax({
                url: live_URL + '/get_tracker_new/' + trackerid,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: 'json',
                encode: true,
            }).done(function (data) {
                document.getElementById('trackername').value = data.data.trackername;
                document.getElementById('description').value = data.data.description;
                document.getElementById('status').value = data.data.status;
                document.getElementById('type').value = data.data.type;
                var x = data.data.trackername;
                $('#len').html(x);

                var linkcampaigns = data.data.linkcampaigns;
                if (linkcampaigns == 't') {
                    $("#linkcampaigns").prop('checked', true);
                } else {
                    $("#linkcampaigns").prop('checked', false);
                }

            });
        }

        function onchangename(that) {
            if (that == "") {
                document.getElementById('name_msg').innerHTML = '<?php echo $GLOBALS['']; ?>Enter the Name';
                document.getElementById('name_msg').style.color = "red";
            } else if (that !== "") {
                document.getElementById('name_msg').innerHTML = "";
            }
        }

        function trackeredit() {
            var trackername = $('#trackername').val();
            var description = $('#description').val();
            var type = $('#type').val();
            var status = $('#status').val();
            var linkcampaigns;
            if ($('#linkcampaigns').prop("checked")) {
                linkcampaigns = "t";
            } else {
                linkcampaigns = "f";
            }

            var formData;
            formData = {
                "trackername": trackername,
                "description": description,
                "type": type,
                "status": status,
                "linkcampaigns": linkcampaigns
            };

            if (trackername == "") {
                document.getElementById('name_msg').innerHTML = '<?php echo $GLOBALS['']; ?>Enter the Name';
                document.getElementById('name_msg').style.color = "red";
            } else {
                document.getElementById('name_msg').innerHTML = "";

                $.ajax({
                    type: "POST",
                    url: live_URL + "/edit_tracker_new/" + clientid + ',' + trackerid,
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: formData,
                    dataType: "json",
                    encode: true,
                }).done(function (data) {
                    if (data.msg == "Tracker has been updated successfully!") {
                        window.scrollTo(0, 0);
                        $("#alertsuccess").show('medium');
                        setTimeout(function () {
                            $("#alertsuccess").hide('medium');
                        }, 2000);
                        setTimeout(function () {
                            location.reload();
                        }, 1200);
                    } else {
                        window.scrollTo(0, 0);
                        $("#alertfailed").show('medium');
                        setTimeout(function () {
                            $("#alertfailed").hide('medium');
                        }, 2000);
                    }
                })
            }
        }
    </script>


</body>

</html>