<?php

/*
 * @copyright   2016 Mautic, Inc. All rights reserved
 * @author      Mautic, Inc
 *
 * @link        https://mautic.org
 *
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
if ($tmpl == 'index') {
    $view->extend('MauticMyupcharSmsBundle:Myupchar:index.html.php');
}
?>
<?php if (count($items)): ?>
    <div class="table-responsive">
        <table class="table table-hover table-striped table-bordered monitoring-list" id="monitoringTable">
            <thead>
            <tr>
                <?php
                echo $view->render(
                    'MauticCoreBundle:Helper:tableheader.html.php',
                    [
                        'checkall'        => 'true',
                        'target'          => '#monitoringTable',
                        'langVar'         => 'mautic.myupchar.monitoring',
                        'routeBase'       => 'myupchar',
                        'templateButtons' => [
                            'delete' => $view['security']->isGranted('plugin:mauticMyupcharSms:myupchar:delete'),
                        ],
                    ]
                );
                echo $view->render(
                    'MauticCoreBundle:Helper:tableheader.html.php',
                    [
                        'sessionVar' => 'myupchar',
                        'orderBy'    => 'e.id',
                        'text'       => 'mautic.core.id',
                        'class'      => 'visible-md visible-lg col-asset-id',
                    ]
                );
                echo $view->render(
                    'MauticCoreBundle:Helper:tableheader.html.php',
                    [
                        'sessionVar' => 'text',
                        'orderBy'    => 'e.messgae',
                        'text'       => 'mautic.core.message',
                        'class'      => 'col-monitoring-title',
                        'default'    => true,
                    ]
                );
               /* echo $view->render(
                    'MauticCoreBundle:Helper:tableheader.html.php',
                    [
                        'sessionVar' => 'text',
                        'orderBy'    => 'e.contenttype',
                        'text'       => 'mautic.text.contenttype',
                        'class'      => 'col-monitoring-title',
                        'default'    => true,
                    ]
                );*/


                ?>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($items as $k => $item): ?>
                <tr>
                    <td>
                        <?php
                        echo $view->render(
                            'MauticCoreBundle:Helper:list_actions.html.php',
                            [
                                'item'            => $item,
                                'templateButtons' => [
                                    'edit'   => $view['security']->isGranted('plugin:mauticMyupcharSms:myupchar:edit'),
                                    'delete' => $view['security']->isGranted('plugin:mauticMyupcharSms:myupchar:delete'),
                                ],
                                'routeBase'  => 'myupchar',
                                'langVar'    => 'mautic.myupchar.monitoring',
                                'nameGetter' => 'getMessage',
                            ]
                        );
                        ?>
                    </td>
                    <td class="visible-md visible-lg"><?php echo $item->getId(); ?></td>
                    <td>
                        <div>
                       
                            <a href="<?php echo $view['router']->path(
                                'mautic_myupchar_action',
                                ['objectAction' => 'edit', 'objectId' => $item->getId()]
                            ); ?>"
                               data-toggle="ajax">
                                <?php echo $item->getMessage(); ?>
                            </a>
                        </div>
              
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="panel-footer">
        <?php echo $view->render(
            'MauticCoreBundle:Helper:pagination.html.php',
            [
                'totalItems' => count($items),
                'page'       => $page,
                'limit'      => $limit,
                'menuLinkId' => 'mautic_campaign_index',
                'baseUrl'    => $view['router']->path('mautic_myupchar_index'),
                'sessionVar' => 'myupchar',
                'routeBase'  => 'myupchar',
            ]
        ); ?>
    </div>
<?php else: ?>
    <?php echo $view->render('MauticCoreBundle:Helper:noresults.html.php', ['tip' => 'mautic.mautic.myupchar.noresults.tip']); ?>
<?php endif; ?>

<?php echo $view->render(
    'MauticCoreBundle:Helper:modal.html.php',
    [
        'id'     => 'MonitoringPreviewModal',
        'header' => false,
    ]
);
