<?php

return [
   'name'        => 'MyupcharSMS',
   'description' => 'Enables SMS Text message service with mautic',
   'version'     => '1.0',
   'author'      => 'Djaxtech',
    'services'    => [
        'integrations' => [
            'mautic.integration.myupcharsms' => [
                'class'     => \MauticPlugin\MauticMyupcharSmsBundle\Integration\MyupcharsmsIntegration::class,
                'arguments' => [
					'event_dispatcher',
                    'mautic.helper.cache_storage',
                    'doctrine.orm.entity_manager',
                    'session',
                    'request_stack',
                    'router',
                    'translator',
                    'logger',
                    'mautic.helper.encryption',
                    'mautic.lead.model.lead',
                    'mautic.lead.model.company',
                    'mautic.helper.paths',
                    'mautic.core.model.notification',
                    'mautic.lead.model.field',
                    'mautic.plugin.model.integration_entity',
                    'mautic.lead.model.dnc',
                ],
            ],
        ],

        'events' => [
            'mautic.myupcharsms.campaignbundle.subscriber' => [
                'class'     => 'MauticPlugin\MauticMyupcharSmsBundle\EventListener\CampaignSubscriber',
                'arguments' => [
                    'mautic.myupcharsms.helper.campaign',
                    'mautic.myupcharsms.model.myupcharsms',
                    'mautic.campaign.model.event',
                    'monolog.logger.mautic',
                    'mautic.campaign.executioner.realtime',
                    'mautic.myupchar.model.myupchar',
                ],
                'methodCalls' => [
                ],
            ],
            'mautic.myupcharsms.dashboard.subscriber' => [
                'class'     => 'MauticPlugin\MauticMyupcharSmsBundle\EventListener\DashboardSubscriber',
                'arguments' => [
                    'mautic.myupcharsms.model.myupcharsms',
                ],
            ],
        ],
         'forms' => [
           'mautic.form.type.myupcharsms' => [
               'class'     => 'MauticPlugin\MauticMyupcharSmsBundle\Form\Type\MyupcharsmsType',
               'alias'     => 'myupcharsms_form',
               'arguments' => [
                   'mautic.myupcharsms.model.myupcharsms'
               ],
           ],
		   'mautic.form.type.myupchar' => [
                'class' => 'MauticPlugin\MauticMyupcharSmsBundle\Form\Type\MyupcharyType',
                'alias' => 'myup',
			],
        ],
        'models' => [
            'mautic.myupcharsms.model.myupcharsms' => [
                'class' => 'MauticPlugin\MauticMyupcharSmsBundle\Model\MyupcharsmsModel',
                'arguments' => [
                   'mautic.lead.model.lead',
                    'mautic.helper.integration',
                    'mautic.user.model.user',
               ],
			],
            'mautic.myupchar.model.myupchar' => [
                 'class' => 'MauticPlugin\MauticMyupcharSmsBundle\Model\MyupcharModel',
             ],
        ],
        'others' => [
            'mautic.myupcharsms.helper.campaign' => [
                'class'     => 'MauticPlugin\MauticMyupcharSmsBundle\Helper\CampaignEventHelper',
                'arguments' => [
                    'mautic.helper.integration',
                    'mautic.page.model.trackable',
                    'mautic.page.helper.token',
                    'mautic.asset.helper.token',
                    'mautic.myupcharsms.model.myupcharsms',
                    'monolog.logger.mautic',
                ],
            ],
        ],
    ],
        
	'routes' => [
		'public' => [
		 'mautic_myupchar_public_index' => [
              'path'       => '/myupcharsms/callback',
               'controller' => 'MauticMyupcharSmsBundle:Public:callback',
           ],
         ],
        'main' => [
            'mautic_myupchar_index' => [
                'path'       => '/myupcharsms/{page}',
                'controller' => 'MauticMyupcharSmsBundle:Myupchar:index',
			],
			'mautic_myupchar_action' => [
                'path'       => '/myupcharsms/{objectAction}/{objectId}',
                'controller' => 'MauticMyupcharSmsBundle:Myupchar:execute',
            ],
        ],
    ],
    'menu' => [
		'main' => [
            'items' => [
                'mautic.myupcharsms.channel.myupchar' => [
                    'route'  => 'mautic_myupchar_index',
                    'access' => ['myupchar:myupchars:viewown', 'myupchar:myupchars:viewother'],
                    'parent' => 'mautic.core.channels',
                    'checks' => [
                        'integration' => [
                            'Myupcharsms' => [
                                'enabled' => true,
                            ],
                        ],
                    ],

                    'priority' => 11,
                ],
            ],
		]
	],
    
];
