<?php
include('session.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/' data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Revive Adservermod - Zone | Report </title>

    <meta name="description" content="" />
    <style>
        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        h5 {
            position: relative;
            left: 250%;
        }
    </style>
    <?php include('head.php'); ?>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
</head>

<body onload="onChangeDetails()">
    <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <?php include('sidebar.php'); ?>

            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3 mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-9">
                                        <p class="h4">Zone Report</p>
                                        <input type='hidden' name="campaignid" id="campaignid" value="<?php echo $_GET['campaignid']; ?>" />
                                        <input type='hidden' id="startDate" value="<?php echo $_GET['start_date']; ?>" />
                                        <input type='hidden' id="endDate" value="<?php echo $_GET['end_date']; ?>" />
                                    </div>
                                    <div class="col-3">
                                        <select id="getBanner" name="allfilter" class="form-select" aria-label="Default select example" onchange="onChangeDetails(this.value)">
                                            <option value="Today" selected>Today</option>
                                            <option value="Yesterday">Yesterday</option>
                                            <option value="Last 7 days">Last 7 days</option>
                                            <option value="Last 30 days">Last 30 days</option>
                                            <option value="This Month">This Month</option>
                                            <option value="Last Month">Last Month</option>
                                            <option value='All Statistics'>All Statistics</option>
                                            <option value="Custom">Custom</option>
                                        </select>
                                        <input style="display: none;" id="daterange" name="daterange" value="02/01/2023 - 02/15/2023" />
                                    </div>
                                </div>

                                <div>
                                    <div class="table-responsive text-nowrap mt-4">
                                        <table id="bannerrep" class="table table-striped">
                                            <thead>
                                                <tr class="text-dark">
                                                    <th class="text-dark">Name</th>
                                                    <th class="text-dark text-center">Impression</th>
                                                    <th class="text-dark text-center">Clicks</th>
                                                    <th class="text-dark text-center">Conversion</th>
                                                    <th class="text-dark text-center">CTR %</th>
                                                    <th class="text-dark text-center">revenue</th>
                                                    <th class="text-dark text-center">eCPM</th>
                                                </tr>
                                            </thead>
                                            <tbody id="ban_table"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include('footer.php'); ?>
                    <!-- / Footer -->
                    <!--<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>-->
                    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
                    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
                    <script>
                        var live_URL = 'http://3.6.236.135/adservermod/api/revive_stat';
                        var domain_url = live_URL + '/get_publisher_zone_statistics/';
                        var token = 'Bearer ' + document.getElementById('token').value;
                        var getBanData = "";
                        var affiliate_id = document.getElementById('affiliateid').value;
                        // var campaign_id = document.getElementById('campaignid').value;
                        // var endDate = document.getElementById('endDate').value;
                        // var startDate = document.getElementById('startDate').value;
                        // var endDate = document.getElementById('endDate').value;

                        function onChangeDetails() {
                            $(".loader").show();
                            const date = new Date();
                            let getSelectedDay = document.getElementById('getBanner').value;

                            if (getSelectedDay == 'Today') {
                                $("#daterange").css("display", "none");
                                let v3 = JSON.stringify(date);
                                v3 = v3.slice(1, 11);
                                var start_date = v3,
                                    end_date = v3;
                                getBannerDate(start_date, end_date);
                            } else if (getSelectedDay == 'Yesterday') {
                                $("#daterange").css("display", "none");
                                let current_date = date.setDate(date.getDate() - 1);
                                const get_date = new Date(date);
                                let yesterday_date = JSON.stringify(get_date);
                                yesterday_date = yesterday_date.slice(1, 11);
                                var start_date = yesterday_date,
                                    end_date = yesterday_date;
                                getBannerDate(start_date, end_date);
                            } else if (getSelectedDay == 'Last 7 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 7);
                                let get_date = new Date(date_start);
                                let first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                let current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                getBannerDate(first_day, date_end);
                            } else if (getSelectedDay == 'Last 30 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 30);
                                let get_date = new Date(date_start);
                                var first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                const current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                getBannerDate(first_day, date_end);
                            } else if (getSelectedDay == 'This Month') {
                                $("#daterange").css("display", "none");
                                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                let cDate = firstDay.getDate(),
                                    cMonth = firstDay.getMonth() + 1,
                                    cYear = firstDay.getFullYear();
                                let first_day = cYear + "-" + cMonth + "-" + cDate;

                                const current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                getBannerDate(first_day, date_end);
                            } else if (getSelectedDay == 'Last Month') {
                                $("#daterange").css("display", "none");
                                var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                var formatDateComponent = function(dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                                }
                                var formatDate = function(date) {
                                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                };
                                var start_date = formatDate(prevMonthFirstDate),
                                    end_date = formatDate(prevMonthLastDate);
                                getBannerDate(start_date, end_date);
                            } else if (getSelectedDay == 'All Statistics') {
                                $("#daterange").css("display", "none");
                                $.ajax({
                                    url: live_URL + '/get_all_publisher_zone_statistics/' + affiliate_id,
                                    type: 'GET',
                                    beforeSend: function(xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function(data) {
                                        // console.log("data", data);
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available') {
                                            let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                                            document.getElementById('ban_table').innerHTML = stat_msg;
                                        } else {
                                            data.map((data) => {

                                                getBanData += `<tr class="text-dark">
                                                        <td>${data.zonename}</td>
                                                        <td class="text-center">${data.impressions }</td>
                                                        <td class='text-center'>${data.clicks  }</td>
                                                        <td class="text-center">${data.conversions  }</td>
                                                        <td class='text-center'>${data.ctr} %</td>
                                                        <td class='text-center'>${data.revenue}</td>
                                                        <td class='text-center'>${data.ecpm}</td>
                                                    </tr>`

                                            });
                                            document.getElementById('ban_table').innerHTML = getBanData;
                                            $('#bannerrep').DataTable({
                                                "ordering": true,
                                                "destroy": true,
                                                data: data,
                                                columns: [

                                                    {
                                                        data: 'zonename'
                                                    },
                                                    {
                                                        data: 'impressions',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'clicks',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'conversions',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'ctr',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        "data": null,
                                                        "render": function(data, type, row, meta) {
                                                            if (row.revenue == null) {
                                                                return '0.00';
                                                            } else {
                                                                return row.revenue;
                                                            }
                                                        }
                                                    },

                                                    {
                                                        "data": null,
                                                        "render": function(data, type, row, meta) {
                                                            if (row.ecpm == null) {
                                                                return '0.00';
                                                            } else {
                                                                return row.ecpm;
                                                            }
                                                        }
                                                    },
                                                ],
                                            });
                                        }
                                    },
                                    error: function() {},
                                });
                            } else if (getSelectedDay == 'Custom') {
                                $(".loader").hide();
                                $("#daterange").css("display", "block");
                                $(document).on('change', '#daterange', function() {
                                    var dates = $('#daterange').val();
                                    const daterange = dates.split("-");
                                });
                                $(function() {
                                    $('input[name="daterange"]').daterangepicker({
                                        opens: 'left'
                                    }, function(start, end, label) {
                                        // console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
                                        // var start_date = start.format('YYYY-MM-DD'), end_date = end.format('YYYY-MM-DD');
                                        getBannerDate(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
                                    });
                                })
                            }
                        };

                        function getBannerDate(start_date, end_date) {

                            $.ajax({
                                url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + affiliate_id,
                                type: 'GET',
                                beforeSend: function(xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                success: function(data) {
                                    //$('#hmm').html(data);
                                    $(".loader").hide();
                                    console.log("data", data);
                                    if (data.msg == 'No Stats Available') {
                                        let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                                        document.getElementById('ban_table').innerHTML = stat_msg;
                                    } else {
                                        data.map((data) => {

                                            getBanData += `<tr class="text-dark">
                                                        <td>${data.zonename}</td>
                                                        <td class="text-center">${data.impressions}</td>
                                                        <td class='text-center'>${data.clicks }</td>
                                                        <td class="text-center">${data.conversions }</td>
                                                        <td class='text-center'>${data.ctr } %</td>
                                                        <td class='text-center'>${data.revenue }</td>
                                                        <td class='text-center'>${data.ecpm }</td>
                                                    </tr>`
                                        });
                                        document.getElementById('ban_table').innerHTML = getBanData;
                                        $('#bannerrep').DataTable({
                                            "ordering": true,
                                            "destroy": true,
                                            data: data,
                                            columns: [

                                                {
                                                    data: 'zonename'
                                                },
                                                {
                                                    data: 'impressions',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'clicks',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'conversions',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'ctr',
                                                },
                                                {
                                                    "data": null,
                                                    "render": function(data, type, row, meta) {
                                                        if (row.revenue == null) {
                                                            return '0.00';
                                                        } else {
                                                            return row.revenue;
                                                        }
                                                    }
                                                },

                                                {
                                                    "data": null,
                                                    "render": function(data, type, row, meta) {
                                                        if (row.ecpm == null) {
                                                            return '0.00';
                                                        } else {
                                                            return row.ecpm;
                                                        }
                                                    }
                                                },
                                                // { data: 'ecpm',},
                                            ],
                                        });
                                    }
                                },
                                error: function() {},
                            });
                        };
                    </script>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>
<!-- <script>
    $(function () {
        $("#example1").DataTable({
            "responsive": true, "lengthChange": false, "autoWidth": false,
            "buttons": ["excel", "csv", "pdf", "colvis"]
        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        $('#example2').DataTable({ //"copy", "print"
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
        });
    });
</script> -->

</html>