<?php 
	include('session.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Adserver - GEO | Report </title>

    <meta name="description" content="" />
    <style>
        .text-hide {
            display: block;
            width: 125px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: inherit;
            width: auto;
        }
        h5 {
            position: relative;
            left: 250%;
        }
    </style>

    <style>
        .svgMap-map-wrapper {
            background: #fff !important;
        }
        .svgMap-country {
            stroke: #8592a3 !important;
            stroke-width: 1 !important;
        }
        #svgMapLastthirtydays-map-country-IN{
            fill:#8080FF !important;
        }
    </style>

    <?php include('head.php'); ?>

    <!--<link href="https://code.jquery.com/ui/1.10.4/themes/ui-lightness/jquery-ui.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-1.12.4.min.js"></script>
    <script src="https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>-->

    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <link href="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.css" rel="stylesheet">
</head>


<body onload="onChangeDetails()">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3">
                            <div class="card-body">
                                <div class='row'>
                                    <div class='col-6'>
                                        <h4 class="mb-4">Geo Report</h4>
                                    </div>
                                    <div class="col-3">
                                        <select id='getZone' class="form-select" aria-label="Default select example"
                                            onchange="onChangeDetails()">
                                            <option value="" >Select Geo Type</option>
                                            <option value="country" selected>Country</option>
                                            <option value="region">Region</option>
                                            <option value="city">City</option>
                                        </select>
                                    </div>
                                    <div class='col-3'>
                                        <select id='getDuration' name="allfilter" class="form-select"
                                            aria-label="Default select example" onchange="onChangeDetails()">
                                            <option value="Today" selected>Today</option>
                                            <option value="Yesterday">Yesterday</option>
                                            <option value="Last 7 days">Last 7 days</option>
                                            <option value="Last 30 days">Last 30 days</option>
                                            <option value="This Month">This Month</option>
                                            <option value="Last Month">Last Month</option>
                                            <option value='all statistics'>All Statistics</option>
                                            <option value="custom">Custom</option>
                                        </select>
                                        <input style="display: none;" id="daterange" name="daterange"
                                            value="03/01/2023 - 03/15/2023" />
                                    </div>
                                </div>
                                <br />

                                <div class="row">
                                    <div id="svgMapSelectDuration"></div>
                                    <div id="svgMapToday"></div>
                                    <div id="svgMapYesterday"></div>
                                    <div id="svgMapLastsevendays"></div>
                                    <div id="svgMapLastthirtydays"></div>
                                    <div id="svgMapThismonth"></div>
                                    <div id="svgMapLastmonth"></div>
                                    <div id="svgMapAllstatistics"></div> 
                                    <div id="svgMapCustom"></div> 
                                </div>


                                <div class="row mt-5">
                                    <div class="mt-1 mb-3 container">
                                        <div class="table-responsive text-nowrap">
                                            <table id="georep" class="table table-hover">
                                                <thead id='geo_head'>
                                                    <tr class="text-nowrap text-dark">
                                                        <th class="th-color">Country</th>
                                                        <th class="th-color">Campaign</th>
                                                        <th class="th-color">Impression</th>
                                                        <th class="th-color">Clicks</th>
                                                        <!-- <th class="th-color">Conversion</th> -->
                                                        <th class="th-color">CTR %</th>
                                                        <th class="th-color">ECPM</th>
                                                        <th class="th-color">Spend</th>
                                                    </tr>
                                                </thead>
                                                <tbody id='geo_table'></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- / Content -->

                <!-- Footer -->
                <?php include('footer.php'); ?>
                <!-- / Footer -->
                <!--<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>-->
				<script src="https://cdn.jsdelivr.net/npm/svg-pan-zoom@3.6.1/dist/svg-pan-zoom.min.js"></script>
                <script src="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.js"></script>
                <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
                <script type="text/javascript"
                    src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
                <script>

                    var live_URL = 'http://43.204.47.201/adservermod/api/revive_stat';
                    var domain_url = live_URL+'/get_georeport_statistics/';
					var token = 'Bearer '+ document.getElementById('token').value;
                
                    function onChangeDetails() {
                        const date = new Date();
                        var getBanData = "";
                        var countryValue = document.getElementById('getZone').value;
                        var filtervalue = document.getElementById('getDuration').value;
                        let client_id = document.getElementById('clientid').value;
                        // document.getElementById('svgMapYesterday').style.display='none';
                        
                       if(filtervalue == 'Today') {
                        $("#daterange").css("display", "none");
                                              

                                let v3 = JSON.stringify(date);
                                v3 = v3.slice(1, 11);
                                var start_date = v3, end_date = v3; 
                            
                                $.ajax({
                                    url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,'+client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr){
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {  

                                        var removeSelectduration = document.getElementById("svgMapSelectDuration");

                                        removeSelectduration.remove();

                                        if (data.msg == 'No Stats Available') {
                                            let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`;
                                            document.getElementById('geo_table').innerHTML = stat_msg;


                                          

                                            //map
                                            new svgMap({                        
                                                targetElementID: 'svgMapToday',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:{} 
                                                }
                                            });
                                            console.log("check the map");
                                        }
                                        else 
                                        {
                                            //INDIA
                                            var clickIndia = data.map((c)=>{
                                            if(c.countrycode == "IN"){
                                                var clicksIN = [];
                                                clicksIN.push(c.clicks)
                                            } 
                                                return clicksIN
                                            })
                                            console.log("clickIndia",clickIndia)                                 

                                            let sumofclicksIndia = clickIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksIndia",sumofclicksIndia) 

                                            var impressionsIndia = data.map((c)=>{
                                                if(c.countrycode == "IN"){
                                                    var impressionsIN = [];
                                                    impressionsIN.push(c.impressions)
                                                }
                                                return impressionsIN
                                            })
                                            console.log("impressionsIndia",impressionsIndia)

                                            let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsIndia",sumofimpressionsIndia) 


                                            //United States
                                            var clickUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var clicksUS = [];
                                                    clicksUS.push(c.clicks)
                                                } 
                                                return clicksUS
                                            })
                                            console.log("clickUs",clickUs)                                 

                                            let sumofclicksUs = clickUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksUs",sumofclicksUs) 

                                            var impressionsUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var impressionsUS = [];
                                                    impressionsUS.push(c.impressions)
                                                }
                                                return impressionsUS
                                            })
                                            console.log("impressionsUs",impressionsUs)

                                            let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsUs",sumofimpressionsUs) 


                                            //German
                                            var clickDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var clicksDE = [];
                                                    clicksDE.push(c.clicks)
                                                } 
                                                return clicksDE
                                            })
                                            console.log("clickUs",clickDe)                                 

                                            let sumofclicksDe = clickDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksDe",sumofclicksDe) 

                                            var impressionsDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var impressionsDE = [];
                                                    impressionsDE.push(c.impressions)
                                                }
                                                return impressionsDE
                                            })
                                            console.log("impressionsDe",impressionsDe)

                                            let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsDe",sumofimpressionsDe) 


                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                    return c.countrycode
                                            })                                  

                                            console.log("countrycode",countrycode)

                                            const uniqueArr = countrycode.filter((c, index) => {
                                                return countrycode.indexOf(c) === index;
                                            });
                                        
                                            console.log("uniqueArr",uniqueArr);

                                            var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                            var DE = uniqueArr.includes("DE") ? DE ="DE" : ""
                                            var US = uniqueArr.includes("US") ? US ="US" : ""


                                            console.log("IN",IN);
                                            console.log("DE",DE);
                                            console.log("US",US);

                                            console.log("filtervalue",filtervalue)
                                        
                                            //map

                                            new svgMap({                        
                                                    targetElementID: 'svgMapToday',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            DE : {
                                                                clicks: sumofclicksDe, 
                                                                impression: sumofimpressionsDe
                                                            }, 
                                                            IN : {                                                    
                                                                clicks: sumofclicksIndia, 
                                                                impression: sumofimpressionsIndia
                                                            },    
                                                            US : {
                                                                clicks: sumofclicksUs, 
                                                                impression: sumofimpressionsUs
                                                            }                                                                       
                                                        } 
                                                    }
                                                });

                                            if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'region' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }

                                        }                                
                                    }
                                });
                            }
                            else if (filtervalue == 'Yesterday') {
                                $("#daterange").css("display", "none");
                                let current_date = date.setDate(date.getDate() - 1);
                                const get_date = new Date(date);
                                let yesterday_date = JSON.stringify(get_date);
                                yesterday_date = yesterday_date.slice(1, 11);
                                var start_date = yesterday_date, end_date = yesterday_date;

                                $.ajax(
                                {
                                    url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,'+client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {  
                                        var removeToday = document.getElementById("svgMapToday");
                                        removeToday.remove();

                                        if (data.msg == 'No Stats Available') {
                                            //map

                                            new svgMap({                        
                                                targetElementID: 'svgMapYesterday',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:
                                                    {                                               
                                                                                                   
                                                                                
                                                    } 
                                                }
                                            });
                                        }
                                        else 
                                        {

                                            //INDIA
                                            var clickIndia = data.map((c)=>{
                                            if(c.countrycode == "IN"){
                                                var clicksIN = [];
                                                clicksIN.push(c.clicks)
                                            } 
                                                return clicksIN
                                            })
                                            console.log("clickIndia",clickIndia)                                 

                                            let sumofclicksIndia = clickIndia.map(function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksIndia", sumofclicksIndia) 

                                            var impressionsIndia = data.map((c)=>{
                                                if(c.countrycode == "IN"){
                                                    var impressionsIN = [];
                                                    impressionsIN.push(c.impressions)
                                                }
                                                return impressionsIN
                                            })
                                            console.log("impressionsIndia",impressionsIndia)

                                            let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsIndia",sumofimpressionsIndia) 

                                            //United States
                                            var clickUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var clicksUS = [];
                                                    clicksUS.push(c.clicks)
                                                } 
                                                return clicksUS
                                            })
                                            console.log("clickUs",clickUs)                                 

                                            let sumofclicksUs = clickUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksUs",sumofclicksUs) 

                                            var impressionsUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var impressionsUS = [];
                                                    impressionsUS.push(c.impressions)
                                                }
                                                return impressionsUS
                                            })
                                            console.log("impressionsUs",impressionsUs)

                                            let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsUs",sumofimpressionsUs) 

                                            //German
                                            var clickDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var clicksDE = [];
                                                    clicksDE.push(c.clicks)
                                                } 
                                                return clicksDE
                                            })
                                            console.log("clickUs",clickDe)                                 

                                            let sumofclicksDe = clickDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksDe",sumofclicksDe) 

                                            var impressionsDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var impressionsDE = [];
                                                    impressionsDE.push(c.impressions)
                                                }
                                                return impressionsDE
                                            })
                                            console.log("impressionsDe",impressionsDe)

                                            let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsDe",sumofimpressionsDe) 


                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                    return c.countrycode
                                            })                                  

                                            console.log("countrycode",countrycode)

                                            const uniqueArr = countrycode.filter((c, index) => {
                                                return countrycode.indexOf(c) === index;
                                            });
                                        
                                            console.log("uniqueArr",uniqueArr);

                                            var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                            var DE = uniqueArr.includes("DE") ? DE ="DE" : ""
                                            var US = uniqueArr.includes("US") ? US ="US" : ""


                                            console.log("IN", IN);
                                            console.log("DE", DE);
                                            console.log("US", US);

                                            console.log("filtervalue",filtervalue)
                                        
                                            //map                

                                            new svgMap({                        
                                                    targetElementID: 'svgMapYesterday',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            DE : {
                                                                clicks: sumofclicksDe, 
                                                                impression: sumofimpressionsDe
                                                            }, 
                                                            IN : {                                                    
                                                                clicks: sumofclicksIndia, 
                                                                impression: sumofimpressionsIndia
                                                            },    
                                                            US : {
                                                                clicks: sumofclicksUs, 
                                                                impression: sumofimpressionsUs
                                                            }                      
                                                        } 
                                                    }
                                                });
                                                if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
												
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'region' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }
                                        }                                
                                    }
                                });                     
                            }
                            else if (filtervalue == 'Last 7 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 7);
                                let get_date = new Date(date_start);
                                let first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                let current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                var start_date = first_day, end_date = date_end;

                                $.ajax({
                                    url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,'+ client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {  
                                        var removeYesterday = document.getElementById("svgMapYesterday");
                                        removeYesterday.remove();

                                        if (data.msg == 'No Stats Available') {
                                            new svgMap({                        
                                                targetElementID: 'svgMapLastsevendays',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:
                                                    {                                               
                                                                                                   
                                                                                
                                                    } 
                                                }
                                            });
                                        }
                                        else {

                                            //INDIA
                                            var clickIndia = data.map((c)=>{
                                            if(c.countrycode == "IN"){
                                                var clicksIN = [];
                                                clicksIN.push(c.clicks)
                                            } 
                                                return clicksIN
                                            })
                                            console.log("clickIndia",clickIndia)                                 

                                            let sumofclicksIndia = clickIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksIndia",sumofclicksIndia) 

                                            var impressionsIndia = data.map((c)=>{
                                                if(c.countrycode == "IN"){
                                                    var impressionsIN = [];
                                                    impressionsIN.push(c.impressions)
                                                }
                                                return impressionsIN
                                            })
                                            console.log("impressionsIndia",impressionsIndia)

                                            let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsIndia",sumofimpressionsIndia) 


                                            //United States
                                            var clickUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var clicksUS = [];
                                                    clicksUS.push(c.clicks)
                                                } 
                                                return clicksUS
                                            })
                                            console.log("clickUs",clickUs)                                 

                                            let sumofclicksUs = clickUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksUs",sumofclicksUs) 

                                            var impressionsUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var impressionsUS = [];
                                                    impressionsUS.push(c.impressions)
                                                }
                                                return impressionsUS
                                            })
                                            console.log("impressionsUs",impressionsUs)

                                            let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsUs",sumofimpressionsUs) 


                                            //German
                                            var clickDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var clicksDE = [];
                                                    clicksDE.push(c.clicks)
                                                } 
                                                return clicksDE
                                            })
                                            console.log("clickUs",clickDe)                                 

                                            let sumofclicksDe = clickDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksDe",sumofclicksDe) 

                                            var impressionsDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var impressionsDE = [];
                                                    impressionsDE.push(c.impressions)
                                                }
                                                return impressionsDE
                                            })
                                            console.log("impressionsDe",impressionsDe)

                                            let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsDe",sumofimpressionsDe) 


                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                    return c.countrycode
                                            })                                  

                                            console.log("countrycode",countrycode)

                                            const uniqueArr = countrycode.filter((c, index) => {
                                                return countrycode.indexOf(c) === index;
                                            });
                                        
                                            console.log("uniqueArr",uniqueArr);

                                            var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                            var DE = uniqueArr.includes("DE") ? DE ="DE" : ""
                                            var US = uniqueArr.includes("US") ? US ="US" : ""


                                            console.log("IN",IN);
                                            console.log("DE",DE);
                                            console.log("US",US);

                                            console.log("filtervalue",filtervalue)
                                        
                                            //map

                                            new svgMap({                        
                                                    targetElementID: 'svgMapLastsevendays',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            DE : {
                                                                clicks: sumofclicksDe, 
                                                                impression: sumofimpressionsDe
                                                            }, 
                                                            IN : {                                                    
                                                                clicks: sumofclicksIndia, 
                                                                impression: sumofimpressionsIndia
                                                            },    
                                                            US : {
                                                                clicks: sumofclicksUs, 
                                                                impression: sumofimpressionsUs
                                                            }                                                
                                                                                    
                                                        } 
                                                    }
                                                });
                                                if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												  $('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'region' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }
                                        }                                
                                    }
                                });
                        
                            
                            }
                            else if (filtervalue == 'Last 30 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 30);
                                let get_date = new Date(date_start);
                                var first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                const current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                var start_date = first_day, end_date = date_end;

                                $.ajax({
                                    url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,'+client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {  
                                        var removeLastsevendays = document.getElementById("svgMapLastsevendays");
                                        removeLastsevendays.remove();


                                        if (data.msg == 'No Stats Available') {
                                            new svgMap({                        
                                                targetElementID: 'svgMapLastthirtydays',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:
                                                    {                                               
                                                                                                   
                                                                                
                                                    } 
                                                }
                                            });
                                        }
                                        else 
                                        {
                                            //INDIA
                                            var clickIndia = data.map((c)=>{
                                            if(c.countrycode == "IN"){
                                                var clicksIN = [];
                                                clicksIN.push(c.clicks)
                                            } 
                                                return clicksIN
                                            })
                                            console.log("clickIndia",clickIndia)                                 

                                            let sumofclicksIndia = clickIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksIndia",sumofclicksIndia) 

                                            var impressionsIndia = data.map((c)=>{
                                                if(c.countrycode == "IN"){
                                                    var impressionsIN = [];
                                                    impressionsIN.push(c.impressions)
                                                }
                                                return impressionsIN
                                            })
                                            console.log("impressionsIndia",impressionsIndia)

                                            let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsIndia",sumofimpressionsIndia) 


                                            //United States
                                            var clickUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var clicksUS = [];
                                                    clicksUS.push(c.clicks)
                                                } 
                                                return clicksUS
                                            })
                                            console.log("clickUs",clickUs)                                 

                                            let sumofclicksUs = clickUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksUs",sumofclicksUs) 

                                            var impressionsUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var impressionsUS = [];
                                                    impressionsUS.push(c.impressions)
                                                }
                                                return impressionsUS
                                            })
                                            console.log("impressionsUs",impressionsUs)

                                            let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsUs",sumofimpressionsUs) 


                                            //German
                                            var clickDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var clicksDE = [];
                                                    clicksDE.push(c.clicks)
                                                } 
                                                return clicksDE
                                            })
                                            console.log("clickUs",clickDe)                                 

                                            let sumofclicksDe = clickDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksDe",sumofclicksDe) 

                                            var impressionsDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var impressionsDE = [];
                                                    impressionsDE.push(c.impressions)
                                                }
                                                return impressionsDE
                                            })
                                            console.log("impressionsDe",impressionsDe)

                                            let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsDe",sumofimpressionsDe) 


                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                    return c.countrycode
                                            })                                  

                                            console.log("countrycode",countrycode)

                                            const uniqueArr = countrycode.filter((c, index) => {
                                                return countrycode.indexOf(c) === index;
                                            });
                                        
                                            console.log("uniqueArr",uniqueArr);

                                            var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                            var DE = uniqueArr.includes("DE") ? DE ="DE" : ""
                                            var US = uniqueArr.includes("US") ? US ="US" : ""


                                            console.log("IN",IN);
                                            console.log("DE",DE);
                                            console.log("US",US);

                                            console.log("filtervalue",filtervalue)
                                        
                                            //map

                                            new svgMap({                        
                                                    targetElementID: 'svgMapLastthirtydays',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            DE : {
                                                                clicks: sumofclicksDe, 
                                                                impression: sumofimpressionsDe
                                                            }, 
                                                            IN : {                                                    
                                                                clicks: sumofclicksIndia, 
                                                                impression: sumofimpressionsIndia
                                                            },    
                                                            US : {
                                                                clicks: sumofclicksUs, 
                                                                impression: sumofimpressionsUs
                                                            }                                                                         
                                                        } 
                                                    }
                                                });
                                                if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }
                                        }                                
                                    }
                                });
                            }
                            else if (filtervalue == 'This Month') {
                                $("#daterange").css("display", "none");
                                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                let cDate = firstDay.getDate(), cMonth = firstDay.getMonth() + 1, cYear = firstDay.getFullYear();
                                let first_day = cYear + "-" + cMonth + "-" + cDate;

                                const current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                var start_date = first_day, end_date = date_end;

                                $.ajax({
                                    url: domain_url+ start_date + ' 00:00:00,' + end_date + ' 12:00:00,'+client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {  
                                        var removeLastthirtydays = document.getElementById("svgMapLastthirtydays");
                                        removeLastthirtydays.remove();

                                        if (data.msg == 'No Stats Available') {
                                            new svgMap({                        
                                                targetElementID: 'svgMapThismonth',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:{} 
                                                }
                                            });
                                        }
                                        else 
                                        {
                                            //INDIA
                                            var clickIndia = data.map((c)=>{
                                            if(c.countrycode == "IN"){
                                                var clicksIN = [];
                                                clicksIN.push(c.clicks)
                                            } 
                                                return clicksIN
                                            })
                                            console.log("clickIndia",clickIndia)                                 

                                            let sumofclicksIndia = clickIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksIndia",sumofclicksIndia) 

                                            var impressionsIndia = data.map((c)=>{
                                                if(c.countrycode == "IN"){
                                                    var impressionsIN = [];
                                                    impressionsIN.push(c.impressions)
                                                }
                                                return impressionsIN
                                            })
                                            console.log("impressionsIndia",impressionsIndia)

                                            let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsIndia",sumofimpressionsIndia) 


                                            //United States
                                            var clickUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var clicksUS = [];
                                                    clicksUS.push(c.clicks)
                                                } 
                                                return clicksUS
                                            })
                                            console.log("clickUs",clickUs)                                 

                                            let sumofclicksUs = clickUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksUs",sumofclicksUs) 

                                            var impressionsUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var impressionsUS = [];
                                                    impressionsUS.push(c.impressions)
                                                }
                                                return impressionsUS
                                            })
                                            console.log("impressionsUs",impressionsUs)

                                            let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsUs",sumofimpressionsUs) 


                                            //German
                                            var clickDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var clicksDE = [];
                                                    clicksDE.push(c.clicks)
                                                } 
                                                return clicksDE
                                            })
                                            console.log("clickUs",clickDe)                                 

                                            let sumofclicksDe = clickDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksDe",sumofclicksDe) 

                                            var impressionsDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var impressionsDE = [];
                                                    impressionsDE.push(c.impressions)
                                                }
                                                return impressionsDE
                                            })
                                            console.log("impressionsDe",impressionsDe)

                                            let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsDe",sumofimpressionsDe) 


                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                    return c.countrycode
                                            })                                  

                                            console.log("countrycode",countrycode)

                                            const uniqueArr = countrycode.filter((c, index) => {
                                                return countrycode.indexOf(c) === index;
                                            });
                                        
                                            console.log("uniqueArr",uniqueArr);

                                            var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                            var DE = uniqueArr.includes("DE") ? DE ="DE" : ""
                                            var US = uniqueArr.includes("US") ? US ="US" : ""


                                            console.log("IN",IN);
                                            console.log("DE",DE);
                                            console.log("US",US);

                                            console.log("filtervalue",filtervalue)
                                        
                                            //map

                                            new svgMap({                        
                                                    targetElementID: 'svgMapThismonth',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            DE : {
                                                                clicks: sumofclicksDe, 
                                                                impression: sumofimpressionsDe
                                                            }, 
                                                            IN : {                                                    
                                                                clicks: sumofclicksIndia, 
                                                                impression: sumofimpressionsIndia
                                                            },    
                                                            US : {
                                                                clicks: sumofclicksUs, 
                                                                impression: sumofimpressionsUs
                                                            }                                                
                                                                                    
                                                        } 
                                                    }
                                                });
                                                if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'region' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }
                                        }                                
                                    }
                                });
                            }
                            else if (filtervalue == 'Last Month') {
                                
                                var removeThismonth = document.getElementById("svgMapThismonth");
                                removeThismonth.remove();


                                $("#daterange").css("display", "none");
                                var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                var formatDateComponent = function (dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                                }
                                var formatDate = function (date) {
                                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                };
                                var start_date = formatDate(prevMonthFirstDate),
                                    end_date = formatDate(prevMonthLastDate);


                              ;

                                $.ajax({
                                    url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,'+client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {  
                                       

                                        if (data.msg == 'No Stats Available') {
                                            new svgMap({                        
                                                targetElementID: 'svgMapLastmonth',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:{

                                                    } 
                                                }
                                            });
                                        }
                                        else 
                                        {
                                            //INDIA
                                            var clickIndia = data.map((c)=>{
                                            if(c.countrycode == "IN"){
                                                var clicksIN = [];
                                                clicksIN.push(c.clicks)
                                            } 
                                                return clicksIN
                                            })
                                            console.log("clickIndia",clickIndia)                                 

                                            let sumofclicksIndia = clickIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofclicksIndia",sumofclicksIndia) 

                                            var impressionsIndia = data.map((c)=>{
                                                if(c.countrycode == "IN"){
                                                    var impressionsIN = [];
                                                    impressionsIN.push(c.impressions)
                                                }
                                                return impressionsIN
                                            })
                                            console.log("impressionsIndia",impressionsIndia)

                                            let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofimpressionsIndia",sumofimpressionsIndia) 

                                            //United States
                                            var clickUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var clicksUS = [];
                                                    clicksUS.push(c.clicks)
                                                } 
                                                return clicksUS
                                            })
                                            console.log("clickUs",clickUs)                                 

                                            let sumofclicksUs = clickUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofclicksUs",sumofclicksUs) 

                                            var impressionsUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var impressionsUS = [];
                                                    impressionsUS.push(c.impressions)
                                                }
                                                return impressionsUS
                                            })
                                            console.log("impressionsUs",impressionsUs)

                                            let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofimpressionsUs",sumofimpressionsUs) 

                                            //German
                                            var clickDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var clicksDE = [];
                                                    clicksDE.push(c.clicks)
                                                } 
                                                return clicksDE
                                            })
                                            console.log("clickUs",clickDe)                                 

                                            let sumofclicksDe = clickDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofclicksDe",sumofclicksDe) 

                                            var impressionsDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var impressionsDE = [];
                                                    impressionsDE.push(c.impressions)
                                                }
                                                return impressionsDE
                                            })
                                            console.log("impressionsDe",impressionsDe)

                                            let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofimpressionsDe",sumofimpressionsDe) 

                                            //countrycode
                                            var countrycode = data.map((c)=>{
                                                    return c.countrycode
                                            })                                  
                                            console.log("countrycode",countrycode)

                                            const uniqueArr = countrycode.filter((c, index) => {
                                                return countrycode.indexOf(c) === index;
                                            });
                                            console.log("uniqueArr",uniqueArr);

                                            var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                            var DE = uniqueArr.includes("DE") ? DE ="DE" : ""
                                            var US = uniqueArr.includes("US") ? US ="US" : ""

                                            console.log("IN",IN);
                                            console.log("DE",DE);
                                            console.log("US",US);

                                            console.log("filtervalue",filtervalue)
                                        
                                            //map

                                            new svgMap({                        
                                                    targetElementID: 'svgMapLastmonth',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            DE : {
                                                                clicks: sumofclicksDe, 
                                                                impression: sumofimpressionsDe
                                                            }, 
                                                            IN : {                                                    
                                                                clicks: sumofclicksIndia, 
                                                                impression: sumofimpressionsIndia
                                                            },    
                                                            US : {
                                                                clicks: sumofclicksUs, 
                                                                impression: sumofimpressionsUs
                                                            }                                                                         
                                                        } 
                                                    }
                                                });


                                                if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'city' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }
                                        }                                
                                    }
                                }); 
                            }
                            else if (filtervalue == 'all statistics') {
                                $("#daterange").css("display", "none");

                                // alert("filtervalue",filtervalue);
                                var removeLastmonth = document.getElementById("svgMapLastmonth");
                                removeLastmonth.remove();

                                $.ajax(
                                {
                                    url: live_URL + '/get_all_georeport_statistics/'+client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {                           
                                        if (data.msg == 'No Stats Available') {

                                            //map
                                            new svgMap({                        
                                                targetElementID: 'svgMapAllstatistics',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:{} 
                                                }
                                            });
                                        }
                                        else 
                                        {

                                            //INDIA
                                            var clickIndia = data.map((c)=>{
                                            if(c.countrycode == "IN"){
                                                var clicksIN = [];
                                                clicksIN.push(c.clicks)
                                            } 
                                                return clicksIN
                                            })
                                            console.log("clickIndia",clickIndia)                                 

                                            let sumofclicksIndia = clickIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofclicksIndia",sumofclicksIndia) 

                                            var impressionsIndia = data.map((c)=>{
                                                if(c.countrycode == "IN"){
                                                    var impressionsIN = [];
                                                    impressionsIN.push(c.impressions)
                                                }
                                                return impressionsIN
                                            })
                                            console.log("impressionsIndia",impressionsIndia)

                                            let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofimpressionsIndia",sumofimpressionsIndia) 
                                            
                                            //United States
                                            var clickUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var clicksUS = [];
                                                    clicksUS.push(c.clicks)
                                                } 
                                                return clicksUS
                                            })
                                            console.log("clickUs",clickUs)                                 

                                            let sumofclicksUs = clickUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofclicksUs",sumofclicksUs) 

                                            var impressionsUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var impressionsUS = [];
                                                    impressionsUS.push(c.impressions)
                                                }
                                                return impressionsUS
                                            })
                                            console.log("impressionsUs",impressionsUs)

                                            let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofimpressionsUs",sumofimpressionsUs) 

                                            //German
                                            var clickDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var clicksDE = [];
                                                    clicksDE.push(c.clicks)
                                                } 
                                                return clicksDE
                                            })
                                            console.log("clickUs",clickDe)                                 

                                            let sumofclicksDe = clickDe.map(function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofclicksDe",sumofclicksDe) 

                                            var impressionsDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var impressionsDE = [];
                                                    impressionsDE.push(c.impressions)
                                                }
                                                return impressionsDE
                                            })
                                            console.log("impressionsDe",impressionsDe)

                                            let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofimpressionsDe",sumofimpressionsDe) 

                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                    return c.countrycode
                                            })                                  
                                            console.log("countrycode",countrycode)

                                            const uniqueArr = countrycode.filter((c, index) => {
                                                return countrycode.indexOf(c) === index;
                                            });
                                            console.log("uniqueArr",uniqueArr);

                                            var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                            var DE = uniqueArr.includes("DE") ? DE ="DE" : ""
                                            var US = uniqueArr.includes("US") ? US ="US" : ""

                                            console.log("IN",IN);
                                            console.log("DE",DE);
                                            console.log("US",US);
                                            console.log("filtervalue",filtervalue)
                                        
                                            //map

                                            new svgMap({                        
                                                    targetElementID: 'svgMapAllstatistics',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            DE : {
                                                                clicks: sumofclicksDe, 
                                                                impression: sumofimpressionsDe
                                                            }, 
                                                            IN : {                                                    
                                                                clicks: sumofclicksIndia, 
                                                                impression: sumofimpressionsIndia
                                                            },    
                                                            US : {
                                                                clicks: sumofclicksUs, 
                                                                impression: sumofimpressionsUs
                                                            }                                                
                                                                                    
                                                        } 
                                                    }
                                            });

                                            if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                                
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'region' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'ecpm' },
													{ data: 'total_revenue' },
												],
												});
                                              
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'ecpm' },
													{ data: 'total_revenue' },
												],
												});
                                              
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }
                                        }                                
                                    
                                    }
                                });
                            }
                            else if (filtervalue == 'custom') {
                                $("#daterange").css("display", "block");

                                $(document).on('change', '#daterange', function () {
                                    var dates = $('#daterange').val();
                                    const daterange = dates.split("-");
                                });
                                $(function () {
                                    $('input[name="daterange"]').daterangepicker({
                                        opens: 'left'
                                    }, function (start, end, label) {
                                        // console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
                                        var start_date = start.format('YYYY-MM-DD'), end_date = end.format('YYYY-MM-DD');

                                        $.ajax({
                                            url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                                            type: 'GET',
                                            beforeSend: function (xhr) {
                                                xhr.setRequestHeader('Authorization', token);
                                            },
                                            data: {},
                                            success: function (data) {
                                                console.log("geo data", data.msg);
                                                if (data.msg == 'No Stats Available') {
                                                    let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                                                    document.getElementById('geo_table').innerHTML = stat_msg;
                                                }
                                                else {
                                                     //INDIA
                                            var clickIndia = data.map((c)=>{
                                            if(c.countrycode == "IN"){
                                                var clicksIN = [];
                                                clicksIN.push(c.clicks)
                                            } 
                                                return clicksIN
                                            })
                                            console.log("clickIndia",clickIndia)                                 

                                            let sumofclicksIndia = clickIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksIndia",sumofclicksIndia) 

                                            var impressionsIndia = data.map((c)=>{
                                                if(c.countrycode == "IN"){
                                                    var impressionsIN = [];
                                                    impressionsIN.push(c.impressions)
                                                }
                                                return impressionsIN
                                            })
                                            console.log("impressionsIndia",impressionsIndia)

                                            let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsIndia",sumofimpressionsIndia) 


                                            
                                            //United States
                                            var clickUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var clicksUS = [];
                                                    clicksUS.push(c.clicks)
                                                } 
                                                return clicksUS
                                            })
                                            console.log("clickUs",clickUs)                                 

                                            let sumofclicksUs = clickUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksUs",sumofclicksUs) 

                                            var impressionsUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var impressionsUS = [];
                                                    impressionsUS.push(c.impressions)
                                                }
                                                return impressionsUS
                                            })
                                            console.log("impressionsUs",impressionsUs)

                                            let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsUs",sumofimpressionsUs) 


                                            //German
                                            var clickDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var clicksDE = [];
                                                    clicksDE.push(c.clicks)
                                                } 
                                                return clicksDE
                                            })
                                            console.log("clickUs",clickDe)                                 

                                            let sumofclicksDe = clickDe.map(function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksDe",sumofclicksDe) 

                                            var impressionsDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var impressionsDE = [];
                                                    impressionsDE.push(c.impressions)
                                                }
                                                return impressionsDE
                                            })
                                            console.log("impressionsDe",impressionsDe)

                                            let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsDe",sumofimpressionsDe) 


                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                    return c.countrycode
                                            })                                  

                                            console.log("countrycode",countrycode)

                                            const uniqueArr = countrycode.filter((c, index) => {
                                                return countrycode.indexOf(c) === index;
                                            });
                                        
                                            console.log("uniqueArr",uniqueArr);

                                            var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                            var DE = uniqueArr.includes("DE") ? DE ="DE" : ""
                                            var US = uniqueArr.includes("US") ? US ="US" : ""


                                            console.log("IN",IN);
                                            console.log("DE",DE);
                                            console.log("US",US);

                                            console.log("filtervalue",filtervalue);


                                            new svgMap({                        
                                                    targetElementID: 'svgMapAllstatistics',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            DE : {
                                                                clicks: sumofclicksDe, 
                                                                impression: sumofimpressionsDe
                                                            }, 
                                                            IN : {                                                    
                                                                clicks: sumofclicksIndia, 
                                                                impression: sumofimpressionsIndia
                                                            },    
                                                            US : {
                                                                clicks: sumofclicksUs, 
                                                                impression: sumofimpressionsUs
                                                            }                                                
                                                                                    
                                                        } 
                                                    }
                                                });

                                                    if (countryValue == 'country' || countryValue == '') {
                                                        var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    <th class="text-center">Revenue</th>
                                                                    </tr>`;
                                                        document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                        data.map((data) => {
                                                            getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                        </tr>`
                                                        });
                                                        document.getElementById('geo_table').innerHTML = getBanData;
														$('#georep').DataTable({
														"ordering": true,
														"destroy": true,
														data: data,
														columns: [
															{ data: 'country' },
															{ data: 'campaignname' },
															{ data: 'impressions' },
															{ data: 'clicks' },
															{ data: 'ctr' },
															{ data: 'ecpm' },
															{ data: 'total_revenue' },
														],
														});

                                                    
                                                    }
                                                    else if (countryValue == 'region') {
                                                        var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    <th class="text-center">Revenue</th>
                                                                </tr>`;
                                                        document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                        data.map((data) => {
                                                            getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                        </tr>`
                                                        });
                                                        document.getElementById('geo_table').innerHTML = getBanData;
														$('#georep').DataTable({
														"ordering": true,
														"destroy": true,
														data: data,
														columns: [
															{ data: 'country' },
															{ data: 'region' },
															{ data: 'campaignname' },
															{ data: 'impressions' },
															{ data: 'clicks' },
															{ data: 'ctr' },
															{ data: 'ecpm' },
															{ data: 'total_revenue' },
														],
														});
                                                   
                                                    }
                                                    else if (countryValue == 'city') {
                                                        var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">ECPM</th>
                                                                        <th class="text-center">Revenue</th>
                                                                </tr>`;
                                                        document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                        data.map((data) => {
                                                            getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                        </tr>`
                                                        });
                                                        document.getElementById('geo_table').innerHTML = getBanData;
														$('#georep').DataTable({
														"ordering": true,
														"destroy": true,
														data: data,
														columns: [
															{ data: 'country' },
															{ data: 'city' },
															{ data: 'campaignname' },
															{ data: 'impressions' },
															{ data: 'clicks' },
															{ data: 'ctr' },
															{ data: 'ecpm' },
															{ data: 'total_revenue' },
														],
														});
                                                   
                                                    }
                                                    else {
                                                        console.log("geo is Not working");
                                                    }
                                                }
                                            },
                                            error: function () { },
                                        });
                                    });
                                })
                            }

                            // if (filtervalue == "Today" || filtervalue == 'Yesterday' || filtervalue == 'Last 7 days' ||
                            //     filtervalue == 'Last 30 days' || filtervalue == 'This Month' || filtervalue == 'Last Month') {
                            //     $.ajax({
                            //         url: live_URL + '/get_georeport_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                            //         type: 'GET',
                            //         beforeSend: function (xhr) {
                            //             xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                            //         },
                            //         data: {},
                            //         success: function (data) {
                            //             console.log("geo data", data);
                            //             if (data.msg == 'No Stats Available') {
                            //                 let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                            //                 document.getElementById('geo_table').innerHTML = stat_msg;
                            //             }
                            //             else {
                            //                 if (countryValue == 'country' || countryValue == '') {
                            //                     var getGeoDataHead = `<tr class="text-dark">
                            //                                         <th class="text-start">Country</th>
                            //                                         <th class="text-center">Campaign</th>
                            //                                         <th class="text-center">Impression</th>
                            //                                         <th class="text-center">clicks</th>
                            //                                         <th class="text-center">Conversion</th>
                            //                                         <th class="text-center">CTR %</th>
                            //                                         <th class="text-center">ECPM</th>
                            //                                         <th class="text-center">Revenue</th>
                            //                                         </tr>`;
                            //                     document.getElementById('geo_head').innerHTML = getGeoDataHead;

                            //                     data.map((data) => {
                            //                         getBanData += `<tr class="text-dark">
                            //                                 <td class="text-start">${data.country}</td>
                            //                                 <td class="text-center">${data.campaignname}</td>
                            //                                 <td class="text-center">${data.impressions}</td>
                            //                                 <td class="text-center">${data.clicks}</td>
                            //                                 <td class="text-center">${data.conversions}</td>
                            //                                 <td class="text-center">${data.ctr} %</td>
                            //                                 <td class="text-center">${data.ecpm}</td>
                            //                                 <td class="text-center">${data.total_revenue}</td>
                            //                             </tr>`
                            //                     });
                            //                     document.getElementById('geo_table').innerHTML = getBanData;
							// 					$('#georep').DataTable({
							// 					"ordering": true,
							// 					"destroy": true,
							// 					data: data,
							// 					columns: [
							// 						{ data: 'country' },
							// 						{ data: 'campaignname' },
							// 						{ data: 'impressions' },
							// 						{ data: 'clicks' },
							// 						{ data: 'conversions' },
							// 						{ data: 'ctr' },
							// 						{ data: 'ecpm' },
							// 						{ data: 'total_revenue' },
							// 					],
							// 					});
                            //                 }
                            //                 else if (countryValue == 'region') {
                            //                     var getGeoDataHead = `<tr class="text-dark">
                            //                                         <th class="text-start">Country</th>
                            //                                         <th class="text-center">Region</th>
                            //                                         <th class="text-center">Campaign</th>
                            //                                         <th class="text-center">Impression</th>
                            //                                         <th class="text-center">clicks</th>
                            //                                         <th class="text-center">Conversion</th>
                            //                                         <th class="text-center">CTR %</th>
                            //                                         <th class="text-center">ECPM</th>
                            //                                         <th class="text-center">Revenue</th>
                            //                                     </tr>`;
                            //                     document.getElementById('geo_head').innerHTML = getGeoDataHead;

                            //                     data.map((data) => {
                            //                         getBanData += `<tr class="text-dark">
                            //                                 <td class="text-start">${data.country}</td>
                            //                                 <td class="text-center">${data.region}</td>
                            //                                 <td class="text-center">${data.campaignname}</td>
                            //                                 <td class="text-center">${data.impressions}</td>
                            //                                 <td class="text-center">${data.clicks}</td>
                            //                                 <td class="text-center">${data.conversions}</td>
                            //                                 <td class="text-center">${data.ctr} %</td>
                            //                                 <td class="text-center">${data.ecpm}</td>
                            //                                 <td class="text-center">${data.total_revenue}</td>
                            //                             </tr>`
                            //                     });
                            //                     document.getElementById('geo_table').innerHTML = getBanData;
							// 					$('#georep').DataTable({
							// 					"ordering": true,
							// 					"destroy": true,
							// 					data: data,
							// 					columns: [
							// 						{ data: 'country' },
							// 						{ data: 'region' },
							// 						{ data: 'campaignname' },
							// 						{ data: 'impressions' },
							// 						{ data: 'clicks' },
							// 						{ data: 'conversions' },
							// 						{ data: 'ctr' },
							// 						{ data: 'ecpm' },
							// 						{ data: 'total_revenue' },
							// 					],
							// 					});
                            //                 }
                            //                 else if (countryValue == 'city') {
                            //                     var getGeoDataHead = `<tr class="text-dark">
                            //                                             <th class="text-start">Country</th>
                            //                                             <th class="text-center">Cities</th>
                            //                                             <th class="text-center">Campaign</th>
                            //                                             <th class="text-center">Impression</th>
                            //                                             <th class="text-center">clicks</th>
                            //                                             <th class="text-center">Conversion</th>
                            //                                             <th class="text-center">CTR %</th>
                            //                                             <th class="text-center">ECPM</th>
                            //                                             <th class="text-center">Revenue</th>
                            //                                     </tr>`;
                            //                     document.getElementById('geo_head').innerHTML = getGeoDataHead;

                            //                     data.map((data) => {
                            //                         getBanData += `<tr class="text-dark">
                            //                                 <td class="text-start">${data.country}</td>
                            //                                 <td class="text-center">${data.city}</td>
                            //                                 <td>${data.campaignname}</td>
                            //                                 <td class="text-center">${data.impressions}</td>
                            //                                 <td class="text-center">${data.clicks}</td>
                            //                                 <td class="text-center">${data.conversions}</td>
                            //                                 <td class="text-center">${data.ctr} %</td>
                            //                                 <td class="text-center">${data.ecpm}</td>
                            //                                 <td class="text-center">${data.total_revenue}</td>
                            //                             </tr>`
                            //                     });
                            //                     document.getElementById('geo_table').innerHTML = getBanData;
							// 					$('#georep').DataTable({
							// 					"ordering": true,
							// 					"destroy": true,
							// 					data: data,
							// 					columns: [
							// 						{ data: 'country' },
							// 						{ data: 'city' },
							// 						{ data: 'campaignname' },
							// 						{ data: 'impressions' },
							// 						{ data: 'clicks' },
							// 						{ data: 'conversions' },
							// 						{ data: 'ctr' },
							// 						{ data: 'ecpm' },
							// 						{ data: 'total_revenue' },
							// 					],
							// 					});
                            //                 }
                            //                 else {
                            //                     console.log("geo is Not working");
                            //                 }
                            //             }
                            //         },
                            //         error: function () { },
                            //     });
                            // }
                    };

                </script>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>
<!--<script>
    $(function () {
        $("#example1").DataTable({
            "responsive": true, "lengthChange": false, "autoWidth": false,
            "buttons": ["excel", "csv", "pdf", "colvis"]
        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        $('#example2').DataTable({ //"copy", "print"
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
        });
    });
</script>-->

</html>