<?php 
	include('session.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Revive Adservermod - GEO | Report </title>

    <meta name="description" content="" />
    <style>
        .text-hide {
            display: block;
            width: 125px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: inherit;
            width: auto;
        }
        h5 {
            position: relative;
            left: 250%;
        }

        /* Geo Map Styles */
        #container1 {
            height: 500px;
            width: 800px;
            margin: 0 auto;
		}
			
		.highcharts-tooltip>span {
            padding: 10px;
            white-space: normal !important;
            width: 200px;
		}
			
		.loading {
            margin-top: 10em;
            text-align: center;
            color: gray;
		}
		
		.f32 .flag {
            vertical-align: middle !important;
		}

        .highcharts-legend-item{
		    display:none;
		}

         /* Close Button */
	   .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus){
	   box-shadow: 0 0 5px #fff!important;
		}
		.dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
		  -webkit-appearance: none!important;
		}
		.dataTables_wrapper .dataTables_filter button{
		  visibility: hidden;
		  outline: none;
		}
		.dataTables_wrapper .dataTables_filter input:valid ~ button{
		  visibility: visible;
		}
		
		button.close 
		{
		padding: 0;
		background-color: transparent;
		border: 0;
		-webkit-appearance: none;
		-moz-appearance: none;
		appearance: none;
		}
		.close {
		float: right;
		font-size: 1.5rem;
		font-weight: 700;
		line-height: 1;
		color: #000;
		text-shadow: 0 1px 0 #fff;
		opacity: .5;
	}
    </style>

    <style>
        .svgMap-map-wrapper {
            background: #fff !important;
        }
        .svgMap-country {
            stroke: #8592a3 !important;
            /* stroke: #ADD8E6 !important; */
            stroke-width: 1 !important;
        }
    </style>

    <?php include('head.php'); ?>

    <!--<link href="https://code.jquery.com/ui/1.10.4/themes/ui-lightness/jquery-ui.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-1.12.4.min.js"></script>
    <script src="https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>-->

    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <link href="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.css" rel="stylesheet">

    <!-- Geo Map -->
    <script src="https://cdn.jsdelivr.net/npm/svg-pan-zoom@3.6.1/dist/svg-pan-zoom.min.js"></script>
	<script src="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.js"></script>
	<link href="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.css" rel="stylesheet">
</head>


<body onload="onChangeDetails()">
    <!-- Geo Map -->
    <script src="https://code.highcharts.com/maps/highmaps.js"></script>
	<script src="https://code.highcharts.com/maps/modules/data.js"></script>
	<script src="https://code.highcharts.com/maps/modules/exporting.js"></script>
	<script src="https://code.highcharts.com/maps/modules/offline-exporting.js"></script>
	<script src="https://code.highcharts.com/maps/modules/accessibility.js"></script>
    <link rel="stylesheet" type="text/css" href="https://github.com/downloads/lafeber/world-flags-sprite/flags32.css">

    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3">
                            <div class="card-body">
                                <div class='row'>
                                    <div class='col-6'>
                                        <h4 class="mb-4">Geo Report</h4>
                                    </div>
                                    <div class="col-3">
                                        <select id='getZone' class="form-select text-dark" aria-label="Default select example"
                                            onchange="onChangeDetails()">
                                            <option value="country" selected>Country</option>
                                            <option value="region">Region</option>
                                            <option value="city">City</option>
                                        </select>
                                    </div>
                                    <div class='col-3'>
                                        <select id='getDuration' name="allfilter" class="form-select text-dark"
                                            aria-label="Default select example" onchange="onChangeDetails()">
                                            <option value="Today" selected>Today</option>
                                            <option value="Yesterday">Yesterday</option>
                                            <option value="Last 7 days">Last 7 days</option>
                                            <option value="Last 30 days">Last 30 days</option>
                                            <option value="This Month">This Month</option>
                                            <option value="Last Month">Last Month</option>
                                            <option value='all statistics'>All Statistics</option>
                                            <option value="custom">Custom</option>
                                        </select>
                                        <input style="display: none;" id="daterange" name="daterange"
                                            value="04/01/2023 - 04/15/2023" />
                                    </div>
                                </div>
                                <br />

                                <div id="container1"></div>

                                <div class="row mt-5">
                                    <div class="mt-1 mb-3 container">
                                        <div class="table-responsive text-nowrap">
                                            <table id="georep" class="table table-hover table-striped">
                                                <thead id='geo_head'>
                                                    <tr class="text-nowrap text-dark">
                                                        <th class="th-color">Country</th>
                                                        <th class="th-color">ZoneName</th>
                                                        <th class="th-color">Impression</th>
                                                        <th class="th-color">Clicks</th>
                                                        <th class="th-color">CTR %</th>
                                                        <th class="th-color">ECPM</th>
                                                        <th class="th-color">EARNINGS</th>
                                                    </tr>
                                                </thead>
                                                <tbody id='geo_table'></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- / Content -->

                <!-- Footer -->
                <?php include('footer.php'); ?>
                <!-- / Footer -->
                <!--<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>-->
				<script src="https://cdn.jsdelivr.net/npm/svg-pan-zoom@3.6.1/dist/svg-pan-zoom.min.js"></script>
                <script src="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.js"></script>
                <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
                <script type="text/javascript"
                    src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
                <script>

                    var live_URL = 'https://revphpe.djaxbidder.com/adservermod/api/revive_stat';
                    var domain_url = live_URL+'/get_georeport__publisher_statistics/';
                    var map_url = live_URL+'/get_georeport_map__publisher_statistics/';
					var token = 'Bearer '+ document.getElementById('token').value;
                    var affiliateid = document.getElementById('affiliateid').value;
                
                    function onChangeDetails() {
                        const date = new Date();
                        let getBanData = "";
                        let countryValue = document.getElementById('getZone').value;
                        let filtervalue = document.getElementById('getDuration').value;
                        
                        // document.getElementById('svgMapYesterday').style.display='none';
                        
                       if(filtervalue == 'Today') {
                            $("#daterange").css("display", "none");
                            let v3 = JSON.stringify(date);
                            v3 = v3.slice(1, 11);
                            getGeoDetails(v3,v3);
                        }
                        else if (filtervalue == 'Yesterday') {
                            $("#daterange").css("display", "none");
                            let current_date = date.setDate(date.getDate() - 1);
                            const get_date = new Date(date);
                            let yesterday_date = JSON.stringify(get_date);
                            yesterday_date = yesterday_date.slice(1, 11);
                            getGeoDetails(yesterday_date,yesterday_date);                     
                        }
                        else if (filtervalue == 'Last 7 days') {
                            $("#daterange").css("display", "none");
                            let date_start = date.setDate(date.getDate() - 7);
                            let get_date = new Date(date_start);
                            let first_day = JSON.stringify(get_date);
                            first_day = first_day.slice(1, 11);

                            let current_date = new Date();
                            let date_end = JSON.stringify(current_date);
                            date_end = date_end.slice(1, 11);
                            getGeoDetails(first_day,date_end);
                        }
                        else if (filtervalue == 'Last 30 days') {
                            $("#daterange").css("display", "none");
                            let date_start = date.setDate(date.getDate() - 30);
                            let get_date = new Date(date_start);
                            var first_day = JSON.stringify(get_date);
                            first_day = first_day.slice(1, 11);

                            const current_date = new Date();
                            let date_end = JSON.stringify(current_date);
                            date_end = date_end.slice(1, 11);
                            getGeoDetails(first_day,date_end);
                        }
                        else if (filtervalue == 'This Month') {
                            $("#daterange").css("display", "none");
                            let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                            let cDate = firstDay.getDate(), cMonth = firstDay.getMonth() + 1, cYear = firstDay.getFullYear();
                            let first_day = cYear + "-" + cMonth + "-" + cDate;

                            const current_date = new Date();
                            let date_end = JSON.stringify(current_date);
                            date_end = date_end.slice(1, 11);
                            getGeoDetails(first_day,date_end);
                        }
                        else if (filtervalue == 'Last Month') {
                            $("#daterange").css("display", "none");
                            var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                            var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                            var formatDateComponent = function (dateComponent) {
                                return (dateComponent < 10 ? '0' : '') + dateComponent;
                            }
                            var formatDate = function (date) {
                                return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                            };
                            getGeoDetails(formatDate(prevMonthFirstDate),formatDate(prevMonthLastDate)); 
                        }
                        else if (filtervalue == 'all statistics') {
                            $("#daterange").css("display", "none");

                            // Geo Map
                            $.ajax({
                                    url: live_URL + '/get_all_georeport_map__publisher_statistics/' + affiliateid,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
									},
                                    data: {},
                                    success: function (data) {
                                        // console.log("data", data);
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available') {
                                            (async () => {
										        const topology = await fetch(
										            'https://code.highcharts.com/mapdata/custom/world.topo.json'
										        ).then(response => response.json());
										     
										        // Initialize the chart
										        Highcharts.mapChart('container1', {
										            
                                                    chart: { map: topology },
										            title: { text: 'Geo Map' },
										            mapNavigation: {
										                enabled: true,
										                buttonOptions: {
										                    verticalAlign: 'bottom'
										                }
										            },
										     
										            tooltip: {
										                backgroundColor: 'none',
										                borderWidth: 0,
										                shadow: false,
										                useHTML: true,
										                padding: 0,
										                pointFormat: '<span class="f32"><span class="flag {point.properties.hc-key}">' +
										                '</span></span> <span style="font-size:18px">{point.country}</span><br>' +
										                '<span style="font-size:18px; color:blue">Impression: {point.impressions}</span><br>'+
										                '<span style="font-size:18px; color:blue">Click: {point.clicks}</span>',
										                positioner: function () {
										                    return { x: 0, y: 250 };
										                }
										            },
										
										            colorAxis: {
										                min: 1,
										                max: 1000,
										                type: 'logarithmic'
										            },
										    
										            series: [{
										                data: [],
										                joinBy: ['iso-a2', 'countrycode'],
										                name: 'Geo Data',
										                states: {
										                    hover: {
										                        color: '#a4edba'
										                    }
										                }
										            }],
											        credits: false
										        });
										    })();
                                        }
                                        else {
                                            (async () => {
										        const topology = await fetch(
										            'https://code.highcharts.com/mapdata/custom/world.topo.json'
										        ).then(response => response.json());
										     
										        // Initialize the chart
										        Highcharts.mapChart('container1', {
										            
                                                    chart: { map: topology },
										            title: { text: 'Geo Map' },
										            mapNavigation: {
										                enabled: true,
										                buttonOptions: {
										                    verticalAlign: 'bottom'
										                }
										            },
										     
										            tooltip: {
										                backgroundColor: 'none',
										                borderWidth: 0,
										                shadow: false,
										                useHTML: true,
										                padding: 0,
										                pointFormat: '<span class="f32"><span class="flag {point.properties.hc-key}">' +
										                '</span></span> <span style="font-size:18px">{point.country}</span><br>' +
										                '<span style="font-size:18px; color:blue">Impression: {point.impressions}</span><br>'+
										                '<span style="font-size:18px; color:blue">Click: {point.clicks}</span>',
										                positioner: function () {
										                    return { x: 0, y: 250 };
										                }
										            },
										
										            colorAxis: {
										                min: 1,
										                max: 1000,
										                type: 'logarithmic'
										            },
										    
										            series: [{
										                data: data,
										                joinBy: ['iso-a2', 'countrycode'],
										                name: 'Geo Data',
										                states: {
										                    hover: {
										                        color: '#a4edba'
										                    }
										                }
										            }],
											        credits: false,
                                                    responsive: {  
                                                      rules: [{  
                                                        condition: {  
                                                          maxWidth: 500  
                                                        },  
                                                        chartOptions: {  
                                                          legend: {  
                                                            enabled: false  
                                                          }  
                                                        }  
                                                      }]  
                                                    }
										        });
										    })();
                                        }
										},
										error: function () { },
							});

                            //Geo Table
                            $.ajax({
                                url: live_URL + '/get_all_georeport__publisher_statistics/'+affiliateid,
                                type: 'GET',
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                success: function (data) {                           
                                    if (data.msg == 'No Stats Available') {
                                        let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`;
                                        document.getElementById('geo_table').innerHTML = stat_msg;
                                    }
                                    else {
                                            if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">ZoneName</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Revenue</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                // data.map((data) => {
                                                //     getBanData += `<tr class="text-dark">
                                                //             <td class="text-start">${data.country}</td>
                                                //             <td class="text-start">${data.campaignname}</td>
                                                //             <td class="text-center">${data.impressions}</td>
                                                //             <td class="text-center">${data.clicks}</td>
                                                //             <!--<td class="text-center">${data.conversions}</td>-->
                                                //             <td class="text-center">${data.ctr} %</td>
                                                //             <td class="text-center">${data.total_revenue}</td>
                                                //             <td class="text-center">${data.ecpm}</td>
                                                //         </tr>`
                                                // });
                                                // document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
                                                    ordering: true,
										            destroy: true,
                                                    // responsive: true,
												    data: data,
												    columns: [
												    	{ data: 'country'},
												    	{ data: 'zonename' },
												    	{ data: 'impressions', className: "text-center" },
												    	{ data: 'clicks', className: "text-center" },
												    	{ data: 'ctr' },
												    	{ data: 'total_revenue' },
												    	{ data: 'ecpm'},
												    ],
                                                    initComplete: function(settings) 
											{
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  ` ).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw(); // reDraw table
											    });
											}
												});
                                                
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">ZoneName</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Revenue</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                // data.map((data) => {
                                                //     getBanData += `<tr class="text-dark">
                                                //             <td class="text-start">${data.country}</td>
                                                //             <td class="text-start">${data.region}</td>
                                                //             <td class="text-start">${data.campaignname}</td>
                                                //             <td class="text-center">${data.impressions}</td>
                                                //             <td class="text-center">${data.clicks}</td>
                                                //             <!--<td class="text-center">${data.conversions}</td>-->
                                                //             <td class="text-center">${data.ctr} %</td>
                                                //             <td class="text-center">${data.total_revenue}</td>
                                                //             <td class="text-center">${data.ecpm}</td>
                                                //         </tr>`
                                                // });
                                                // document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
                                                    ordering: true,
										            destroy: true,
                                                    // responsive: true,
												    data: data,
												    columns: [
												    	{ data: 'country' },
												    	{ data: 'region' },
												    	{ data: 'zonename' },
												    	{ data: 'impressions', className: "text-center"},
												    	{ data: 'clicks', className: "text-center"},
												    	{ data: 'ctr' },
												    	{ data: 'total_revenue' },
                                                        { data: 'ecpm' }
												    ],
                                                    initComplete: function(settings) 
											{
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  ` ).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw(); // reDraw table
											    });
											}
												});
                                              
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">ZoneName</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Revenue</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                // data.map((data) => {
                                                //     getBanData += `<tr class="text-dark">
                                                //             <td class="text-start">${data.country}</td>
                                                //             <td class="text-start">${data.city}</td>
                                                //             <td class="text-start">${data.campaignname}</td>
                                                //             <td class="text-center">${data.impressions}</td>
                                                //             <td class="text-center">${data.clicks}</td>
                                                //             <!--<td class="text-center">${data.conversions}</td>-->
                                                //             <td class="text-center">${data.ctr} %</td>
                                                //             <td class="text-center">${data.total_revenue}</td>
                                                //             <td class="text-center">${data.ecpm}</td>
                                                //         </tr>`
                                                // });
                                                // document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
                                                    ordering: true,
										            destroy: true,
                                                    // responsive: true,
												    data: data,
												    columns: [
												    	{ data: 'country' },
												    	{ data: 'city' },
												    	{ data: 'zonename' },
												    	{ data: 'impressions', className: "text-center" },
												    	{ data: 'clicks', className: "text-center" },
												    	{ data: 'ctr' },
												    	{ data: 'total_revenue' },
                                                        { data: 'ecpm' },
												    ],
                                                    initComplete: function(settings) 
											{
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  ` ).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw(); // reDraw table
											    });
											}
												});
                                              
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }
                                        }                                
                                    
                                    }
                                });
                        }
                        else if (filtervalue == 'custom') {
                            $("#daterange").css("display", "block");
                            $(document).on('change', '#daterange', function () {
                                var dates = $('#daterange').val();
                                const daterange = dates.split("-");
                            });
                            $(function () {
                                $('input[name="daterange"]').daterangepicker({
                                    opens: 'left'
                                }, function (start, end, label) {
                                    getGeoDetails(start.format('YYYY-MM-DD'),end.format('YYYY-MM-DD'));
                                });
                            })
                        }
                    };

                    function getGeoDetails(start_date,end_date) {
                        let countryValue = document.getElementById('getZone').value;
                        let getBanData = "";

                        // Map
                        $.ajax({
                            url: map_url+ start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + affiliateid,
                            type: 'GET',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
							},
                            data: {},
                            success: function (data) {
                                // console.log("data", data);
                                $(".loader").hide();
                                if (data.msg == 'No Stats Available') {
                                        (async () => {
										    const topology = await fetch(
										        'https://code.highcharts.com/mapdata/custom/world.topo.json'
										    ).then(response => response.json());
										     
										    // Initialize the chart
										    Highcharts.mapChart('container1', {
										            
                                                chart: { map: topology },
										        title: { text: 'Geo Map' },
										        mapNavigation: {
										            enabled: true,
										            buttonOptions: {
										                verticalAlign: 'bottom'
										            }
										        },
										        tooltip: {
										            backgroundColor: 'none',
										            borderWidth: 0,
										            shadow: false,
										            useHTML: true,
										            padding: 0,
										            pointFormat: '<span class="f32"><span class="flag {point.properties.hc-key}">' +
										            '</span></span> <span style="font-size:18px">{point.country}</span><br>' +
										            '<span style="font-size:18px; color:blue">Impression: {point.impressions}</span><br>'+
										            '<span style="font-size:18px; color:blue">Click: {point.clicks}</span>',
										            positioner: function () {
										                return { x: 0, y: 250 };
										            }
										        },
										        colorAxis: {
										            min: 1,
										            max: 1000,
										            type: 'logarithmic'
										        },
										        series: [{
										            data: [],
										            joinBy: ['iso-a2', 'countrycode'],
										            name: 'Geo Data',
										            states: {
										                hover: {
										                    color: '#a4edba'
										                }
										            }
										        }],
											    credits: false
										    });
										})();
                                        }
                                        else {
                                            (async () => {
										        const topology = await fetch(
										            'https://code.highcharts.com/mapdata/custom/world.topo.json'
										        ).then(response => response.json());
										     
										        // Initialize the chart
										        Highcharts.mapChart('container1', {
										            
                                                    chart: { map: topology },
										            title: { text: 'Geo Map' },
										            mapNavigation: {
										                enabled: true,
										                buttonOptions: {
										                    verticalAlign: 'bottom'
										                }
										            },
										     
										            tooltip: {
										                backgroundColor: 'none',
										                borderWidth: 0,
										                shadow: false,
										                useHTML: true,
										                padding: 0,
										                pointFormat: '<span class="f32"><span class="flag {point.properties.hc-key}">' +
										                '</span></span> <span style="font-size:18px">{point.country}</span><br>' +
										                '<span style="font-size:18px; color:blue">Impression: {point.impressions}</span><br>'+
										                '<span style="font-size:18px; color:blue">Click: {point.clicks}</span>',
										                positioner: function () {
										                    return { x: 0, y: 250 };
										                }
										            },
										
										            colorAxis: {
										                min: 1,
										                max: 1000,
										                type: 'logarithmic'
										            },
										    
										            series: [{
										                data: data,
										                joinBy: ['iso-a2', 'countrycode'],
										                name: 'Geo Data',
										                states: {
										                    hover: {
										                        color: '#a4edba'
										                    }
										                }
										            }],
											        credits: false
										        });
										    })();
                                        }
							},
							error: function () { },
						});

                        // Table
                        $.ajax({
                            url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + affiliateid,
                            type: 'GET',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            data: {},
                            success: function (data) {
                                if (data.msg == 'No Stats Available') {
                                    let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`;
                                        document.getElementById('geo_table').innerHTML = stat_msg;
                                }
                                else {
                                        if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">ZoneName</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">ECPM</th>
                                                                        <th class="text-center">Revenue</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                // data.map((data) => {
                                                //     getBanData += `<tr class="text-dark">
                                                //                     <td class="text-start">${data.country}</td>
                                                //                     <td class="text-start">${data.campaignname}</td>
                                                //                     <td class="text-center">${data.impressions}</td>
                                                //                     <td class="text-center">${data.clicks}</td>
                                                //                     <td class="text-center">${data.ctr} %</td>
                                                //                     <td class="text-center">${data.ecpm}</td>
                                                //                     <td class="text-center">${data.total_revenue}</td>
                                                //                 </tr>`
                                                // });
                                                // document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													ordering: true,
										            destroy: true,
                                                    // responsive: true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'zonename' },
														{ data: 'impressions', className: "text-center"},
														{ data: 'clicks', className: "text-center"},
														{ data: 'ctr' },
														{ data: 'ecpm' },
														{ data: 'total_revenue' },
													],
                                                    initComplete: function(settings) 
											{
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  ` ).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw(); // reDraw table
											    });
											}
												});
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                            <th class="text-start">Country</th>
                                                            <th class="text-start">Region</th>
                                                            <th class="text-start">ZoneName</th>
                                                            <th class="text-center">Impression</th>
                                                            <th class="text-center">clicks</th>
                                                            <th class="text-center">CTR %</th>
                                                            <th class="text-center">ECPM</th>
                                                            <th class="text-center">Revenue</th>
                                                        </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead
                                                // data.map((data) => {
                                                //     getBanData += `<tr class="text-dark">
                                                //     <td class="text-start">${data.country}</td>
                                                //     <td class="text-start">${data.region}</td>
                                                //     <td class="text-start">${data.campaignname}</td>
                                                //     <td class="text-center">${data.impressions}</td>
                                                //     <td class="text-center">${data.clicks}</td>
                                                //     <td class="text-center">${data.ctr} %</td>
                                                //     <td class="text-center">${data.ecpm}</td>
                                                //     <td class="text-center">${data.total_revenue}</td>
                                                // </tr>`
                                                // });
                                                // document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
                                                    ordering: true,
										            destroy: true,
                                                    // responsive: true,
												    data: data,
												    columns: [
												    	{ data: 'country' },
												    	{ data: 'region' },
												    	{ data: 'zonename' },
												    	{ data: 'impressions', className: "text-center"},
												    	{ data: 'clicks', className: "text-center"},
												    	{ data: 'ctr' },
												    	{ data: 'ecpm' },
												    	{ data: 'total_revenue' },
												    ],
                                                    initComplete: function(settings) 
											{
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  ` ).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw(); // reDraw table
											    });
											}
												});
                                            }
                                                    else if (countryValue == 'city') {
                                                        var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">ZoneName</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">ECPM</th>
                                                                        <th class="text-center">Revenue</th>
                                                                </tr>`;
                                                        document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                        // data.map((data) => {
                                                        //     getBanData += `<tr class="text-dark">
                                                        //     <td class="text-start">${data.country}</td>
                                                        //     <td class="text-start">${data.city}</td>
                                                        //     <td class="text-start">${data.campaignname}</td>
                                                        //     <td class="text-center">${data.impressions}</td>
                                                        //     <td class="text-center">${data.clicks}</td>
                                                        //     <td class="text-center">${data.ctr} %</td>
                                                        //     <td class="text-center">${data.ecpm}</td>
                                                        //     <td class="text-center">${data.total_revenue}</td>
                                                        // </tr>`
                                                        // });
                                                        // document.getElementById('geo_table').innerHTML = getBanData;
														$('#georep').DataTable({
                                                            ordering: true,
										                    destroy: true,
                                                            // responsive: true,
												            data: data,
														    columns: [
														    	{ data: 'country' },
														    	{ data: 'city' },
														    	{ data: 'zonename' },
														    	{ data: 'impressions', className: "text-center"},
														    	{ data: 'clicks', className: "text-center"},
														    	{ data: 'ctr' },
														    	{ data: 'ecpm' },
														    	{ data: 'total_revenue' },
														    ],
                                                            initComplete: function(settings) 
											{
											    //settings.nTable.id --> Get table ID
											    $('#'+settings.nTable.id+'_filter input').wrap(`
												    <div class="d-inline-flex position-relative"></div>
											  ` ).after(`
													<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
													  <span aria-hidden="true">&times;</span>
													</button>
											   `).attr('required','required').attr('title','Search');
                                              
											   // Click Event on Clear button
											    $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
												 $('#'+settings.nTable.id).DataTable({
												   "retrieve": true,
												  }).search('').draw(); // reDraw table
											    });
											}
														});
                                                   
                                                    }
                                                    else {
                                                        console.log("geo is Not working");
                                                    }
                                                }
                                            },
                                            error: function () { },
                        });
                    };

                </script>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>
</html>