<?php 
include('session.php'); ?>
<!DOCTYPE html>
<!-- beautify ignore:start -->
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="../assets/" data-template="vertical-menu-template-free">
  <head>
  <title>Adserver - Dashboard</title>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
  <meta name="description" content="" />
  <style>
    .text-hide{
    display: block;
    width: 125px;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    }

    .tooltip {
      position: relative;
      display: inline-block;
    }

    .tooltip .tooltiptext {
      visibility: hidden;
      width: 120px;
      background-color: gray;
      color: #fff;
      text-align: center;
      border-radius: 6px;
      padding: 5px 0;
    
      /* Position the tooltip */
      position: absolute;
      z-index: 1;
    }
    
    .tooltip:hover .tooltiptext {
      visibility: visible;
    }

    .text-hide:hover{
    overflow: inherit;
    width: auto;
    }

    .wrapper {
            width: 100%;
            display: block;
            overflow: hidden;
            margin: 0 auto;
            padding: 60px 50px;
            background: #fff;
            border-radius: 4px;
        }

        .bar_canvas {
            background: #fff;
            height: 300px;
        }
    </style>

	<?php include('head.php'); ?>
	<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.6.0/Chart.min.js"></script>

    <!-- Add icon library -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" />
  </head>

  <body onload="dash_filter()">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <?php include('sidebar.php'); ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          <?php include('navbar.php'); ?>
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
                <div class="row">
                    <div class="col col-3 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                        <div class="d-flex justify-content-start">
                            <p class="h3">Dashboard</p>
							<input type="hidden" name="clientid" id="clientid" value="<?php echo $_SESSION['clientid']; ?>">
                        </div>
                    </div>
                    <div class="col col-9 col-sm-12 col-md-8 col-lg-8 col-xl-8 col-xxl-8">
                        <div class="d-flex justify-content-end">
                            <div class="w-25 mb-3">
                                <select id="getDuration" class="form-select" 
                                onchange="dash_filter()">
                                    <option selected value="Today">Today</option>
                                    <option value="Yesterday">Yesterday</option>
                                    <option value="Last 7 days">Last 7 days</option>
                                    <option value="Last 30 days">Last 30 days</option>
                                    <option value="This Month">This Month</option>
                                    <option value="Last Month">Last Month</option>
                                    <option value='all statistics'>All Statistics</option>
                                    <option value="custom">Custom</option>
                                </select>
                                <input style="display: none;" id="daterange" name="daterange" 
                                value="03/01/2023 - 03/15/2023" />
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-1 d-flex justify-content-center">
                    <!-- Campaign Chart -->
                    <div class="col col-xs-12 col-sm-12 col-md-11 col-lg-7 col-xl-8 col-xxl-8">
                        <div class="col-12 col-lg-12 order-2 order-md-3 order-lg-2 mb-4">
                            <div class="card">
                              <div class="row row-bordered g-0">
                                <div class="col-md-12" >
                                    <div>
                                        <div class="row">
                                            <div class="col col-xs-4 col-sm-4 col-md-4 col-lg-4 col-xl-4">
                                                <h5 class="card-header m-0 me-2 pb-3">Campaigns</h5>
                                            </div>
                                            <div class="col col-xs-8 col-sm-8 col-md-8 col-lg-8 col-xl-8">
                                                <div class="d-flex justify-content-end">
                                                    <div class="w-50 mt-4" style="margin-right: 6%;">
                                                        <select id='campaignGraph' class="form-select" onchange='dash_filter()'>
                                                            <option value="impression" selected>Impression</option>
                                                            <option value="clicks">Clicks</option>
                                                            <option value="conversion">Conversion</option>
                                                            <option value="spend">Spend</option>
                                                            <option value="ctr">CTR</option>
                                                            <option value="ecpm">ECPM</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class='d-flex justify-content-end'>
    <div class="mt-3">
        <button class="btn" type="button" data-bs-toggle="modal" data-bs-target="#fullscreenModal"><i
                class="fa fa-arrows-alt"></i>
        </button>
    </div>
    <div class="modal fade" id="fullscreenModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalFullTitle">Campaign Chart</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <canvas id="line-chart"></canvas>
                    <script>
                        new Chart(document.getElementById("line-chart"), {
                            type: 'line',
                            data: {
                                labels: ["test1user", "test2user", "test3user", "test4user", "test5user"],
                                datasets: [{
                                    data: [0, 0, 0, 0, 0],
                                    label: "Impression",
                                    borderColor: "#3e95cd",
                                    fill: false
                                }
                                ]
                            },
                            options: {
                                responsive: true,
                                title: {
                                    display: true,
                                    // text: 'Campaign Chart'
                                },
                                scales: {
                                    xAxes: [{
                                        display: true,
                                        scaleLabel: {
                                            display: true,
                                            // labelString: 'Date'
                                        },
                                        ticks: {
                                            autoSkip: false,
                                            maxRotation: 0,
                                            minRotation: 0
                                        }

                                    }],
                                    yAxes: [
                                        {
                                            display: true,
                                            scaleLabel: {
                                                display: true
                                            }
                                        }
                                    ]
                                }
                            }
                        });
                        function campaignChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue) {
                            console.log("campaign name:", campaignName, "impression value", ImpressionValue);
                            var getValue = document.getElementById('campaignGraph').value;

                            if (getValue == 'impression') {
                                // console.log("impression is working", ImpressionValue);
                                new Chart(document.getElementById("line-chart"), {
                                    type: 'line',
                                    data: {
                                        labels: campaignName,
                                        // labels: ["13-03-2023", "", "", "", "", "", "", "", "18-03-2023"],
                                        datasets: [{
                                            data: ImpressionValue,
                                            label: "impression",
                                            borderColor: "#3e95cd",
                                            fill: false
                                        }]
                                    },
                                    options: {
                                        responsive: true,
                                        title: {
                                            display: true,
                                            text: 'Campaign Chart'
                                        },
                                        scales: {
                                            xAxes: [{
                                                display: true,
                                                // scaleLabel: {
                                                //     display: true,
                                                //     labelString: '13-03-2023 to 18-03-2023'
                                                // },
                                                // labelWrap: true,
                                                ticks: {
                                                    // callback: function (label) {
                                                    //     if (/\s/.test(label)) {
                                                    //         return label.split(" ");
                                                    //     }
                                                    //     else {
                                                    //         return label;
                                                    //     }
                                                    // },
                                                    maxRotation: 0,
                                                    minRotation: 0
                                                }
                                            }],
                                            yAxes: [
                                                {
                                                    display: true,
                                                    scaleLabel: {
                                                        display: true
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                });
                            }
                            else if (getValue == 'clicks') {
                                // console.log("clicks is working");
                                new Chart(document.getElementById("line-chart"), {
                                    type: 'line',
                                    data: {
                                        labels: campaignName,
                                        datasets: [
                                            {
                                                data: clickValue,
                                                label: "clicks",
                                                borderColor: "#8e5ea2",
                                                fill: false
                                            }
                                        ]
                                    },
                                    options: {
                                        responsive: true,
                                        title: {
                                            display: true,
                                            text: 'Clicks'
                                        },
                                        scales: {
                                            xAxes: [{
                                                display: true,
                                                scaleLabel: {
                                                    display: true,
                                                    // labelString: 'Date'
                                                },
                                                labelWrap: true,
                                                ticks: {
                                                    // callback: function (label) {
                                                    //     if (/\s/.test(label)) {
                                                    //         return label.split(" ");
                                                    //     }
                                                    //     else {
                                                    //         return label;
                                                    //     }
                                                    // }
                                                    maxRotation: 90,
                                                    minRotation: 90
                                                }

                                            }],
                                            yAxes: [
                                                {
                                                    display: true,
                                                    scaleLabel: {
                                                        display: true
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                });
                            }
                            else if (getValue == 'conversion') {
                                // console.log("conversation is working");
                                new Chart(document.getElementById("line-chart"), {
                                    type: 'line',
                                    data: {
                                        labels: campaignName,
                                        datasets: [
                                            {
                                                data: conversionsValue,
                                                label: "Conversion",
                                                borderColor: "#FF0000",
                                                fill: false
                                            },
                                        ]
                                    },
                                    options: {
                                        responsive: true,
                                        title: {
                                            display: true,
                                            text: 'Conversion'
                                        },
                                        scales: {
                                            xAxes: [{
                                                display: true,
                                                scaleLabel: {
                                                    display: true,
                                                    // labelString: 'Date'
                                                },
                                                labelWrap: true,
                                                ticks: {
                                                    // callback: function (label) {
                                                    //     if (/\s/.test(label)) {
                                                    //         return label.split(" ");
                                                    //     }
                                                    //     else {
                                                    //         return label;
                                                    //     }
                                                    // }
                                                    maxRotation: 90,
                                                    minRotation: 90
                                                }

                                            }],
                                            yAxes: [
                                                {
                                                    display: true,
                                                    scaleLabel: {
                                                        display: true
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                });
                            }
                            else if (getValue == 'spend') {
                                new Chart(document.getElementById("line-chart"), {
                                    type: 'line',
                                    data: {
                                        labels: campaignName,
                                        datasets: [
                                            {
                                                data: revenueValue,
                                                label: "Spend",
                                                borderColor: "#e8c3b9",
                                                fill: false
                                            }]
                                    },
                                    options: {
                                        responsive: true,
                                        title: {
                                            display: true,
                                            text: 'Spend'
                                        },
                                        scales: {
                                            xAxes: [{
                                                display: true,
                                                scaleLabel: {
                                                    display: true,
                                                    // labelString: 'Date'
                                                },
                                                labelWrap: true,
                                                ticks: {
                                                    // callback: function (label) {
                                                    //     if (/\s/.test(label)) {
                                                    //         return label.split(" ");
                                                    //     }
                                                    //     else {
                                                    //         return label;
                                                    //     }
                                                    // }
                                                    maxRotation: 90,
                                                    minRotation: 90
                                                }

                                            }],
                                            yAxes: [
                                                {
                                                    display: true,
                                                    scaleLabel: {
                                                        display: true
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                });
                            }
                            else if (getValue == 'ctr') {
                                new Chart(document.getElementById("line-chart"), {
                                    type: 'line',
                                    data: {
                                        labels: campaignName,
                                        datasets: [{
                                            data: ctrValue,
                                            label: "CTR",
                                            borderColor: "#c45850",
                                            fill: false
                                        }]
                                    },
                                    options: {
                                        responsive: true,
                                        title: {
                                            display: true,
                                            text: 'CTR'
                                        },
                                        scales: {
                                            xAxes: [{
                                                display: true,
                                                scaleLabel: {
                                                    display: true,
                                                    // labelString: 'Date'
                                                },
                                                labelWrap: true,
                                                ticks: {
                                                    // callback: function (label) {
                                                    //     if (/\s/.test(label)) {
                                                    //         return label.split(" ");
                                                    //     }
                                                    //     else {
                                                    //         return label;
                                                    //     }
                                                    // }
                                                    maxRotation: 90,
                                                    minRotation: 90
                                                }

                                            }],
                                            yAxes: [
                                                {
                                                    display: true,
                                                    scaleLabel: {
                                                        display: true
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                });
                            }
                            else if (getValue == 'ecpm') {
                                new Chart(document.getElementById("line-chart"), {
                                    type: 'line',
                                    data: {
                                        labels: campaignName,
                                        datasets: [{
                                            data: ecpmValue,
                                            label: "ECPM",
                                            borderColor: "#3e95cd",
                                            fill: false
                                        }]
                                    },
                                    options: {
                                        responsive: true,
                                        title: {
                                            display: true,
                                            text: 'ECPM'
                                        },
                                        scales: {
                                            xAxes: [{
                                                display: true,
                                                scaleLabel: {
                                                    display: true,
                                                    // labelString: 'Date'
                                                },
                                                labelWrap: true,
                                                ticks: {
                                                    // callback: function (label) {
                                                    //     if (/\s/.test(label)) {
                                                    //         return label.split(" ");
                                                    //     }
                                                    //     else {
                                                    //         return label;
                                                    //     }
                                                    // }
                                                    maxRotation: 90,
                                                    minRotation: 90
                                                }

                                            }],
                                            yAxes: [
                                                {
                                                    display: true,
                                                    scaleLabel: {
                                                        display: true
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                });
                            }
                            else {
                                console.log("chart is Not Working");
                            }
                        };
                    </script>
                </div>
            </div>
        </div>
    </div>
</div>
                                    <div>
                                        <canvas id="line-chart1"></canvas>
                                        <script>
                                            new Chart(document.getElementById("line-chart1"), {
                                                type: 'line',
                                                data: {
                                                    labels: ["test1user", "test2user", "test3user", "test4user", "test5user"],
                                                    datasets: [{
                                                        data: [0, 0, 0, 0, 0],
                                                        label: "Impression",
                                                        borderColor: "#3e95cd",
                                                        fill: false
                                                    }
                                                    ]
                                                },
                                                options: {
                                                    responsive: true,
                                                    title: {
                                                        display: true,
                                                        text: 'Campaign Chart'
                                                    },
                                                    scales: {
                                                        xAxes: [{
                                                            display: true,
                                                            scaleLabel: {
                                                                display: true,
                                                                // labelString: 'Date'
                                                            },
                                                            ticks: {
                                                                autoSkip: false,
                                                                maxRotation: 0,
                                                                minRotation: 0
                                                            }

                                                        }],
                                                        yAxes: [
                                                            {
                                                                display: true,
                                                                scaleLabel: {
                                                                    display: true
                                                                }
                                                            }
                                                        ]
                                                    }
                                                }
                                            });
                                            function testChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue) {
                                                // console.log("campaign name:", campaignName, "impression value", ImpressionValue);
                                                var getValue = document.getElementById('campaignGraph').value;

                                                if (getValue == 'impression') {
                                                    // console.log("impression is working", ImpressionValue);
                                                    new Chart(document.getElementById("line-chart1"), {
                                                        type: 'line',
                                                        data: {
                                                            labels: campaignName,
                                                            // labels: ["13-03-2023", "", "", "", "", "", "", "", "18-03-2023"],
                                                            datasets: [{
                                                                data: ImpressionValue,
                                                                label: "impression",
                                                                borderColor: "#3e95cd",
                                                                fill: false
                                                            }]
                                                        },
                                                        options: {
                                                            responsive: true,
                                                            title: {
                                                                display: true,
                                                                text: 'Campaign Chart'
                                                            },
                                                            scales: {
                                                                xAxes: [{
                                                                    display: true,
                                                                    // scaleLabel: {
                                                                    //     display: true,
                                                                    //     labelString: '13-03-2023 to 18-03-2023'
                                                                    // },
                                                                    // labelWrap: true,
                                                                    ticks: {
                                                                        // callback: function (label) {
                                                                        //     if (/\s/.test(label)) {
                                                                        //         return label.split(" ");
                                                                        //     }
                                                                        //     else {
                                                                        //         return label;
                                                                        //     }
                                                                        // },
                                                                        maxRotation: 0,
                                                                        minRotation: 0
                                                                    }
                                                                }],
                                                                yAxes: [
                                                                    {
                                                                        display: true,
                                                                        scaleLabel: {
                                                                            display: true
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        }
                                                    });
                                                }
                                                else if (getValue == 'clicks') {
                                                    // console.log("clicks is working");
                                                    new Chart(document.getElementById("line-chart1"), {
                                                        type: 'line',
                                                        data: {
                                                            labels: campaignName,
                                                            datasets: [
                                                                {
                                                                    data: clickValue,
                                                                    label: "clicks",
                                                                    borderColor: "#8e5ea2",
                                                                    fill: false
                                                                }
                                                            ]
                                                        },
                                                        options: {
                                                            responsive: true,
                                                            title: {
                                                                display: true,
                                                                text: 'Clicks'
                                                            },
                                                            scales: {
                                                                xAxes: [{
                                                                    display: true,
                                                                    scaleLabel: {
                                                                        display: true,
                                                                        // labelString: 'Date'
                                                                    },
                                                                    labelWrap: true,
                                                                    ticks: {
                                                                        // callback: function (label) {
                                                                        //     if (/\s/.test(label)) {
                                                                        //         return label.split(" ");
                                                                        //     }
                                                                        //     else {
                                                                        //         return label;
                                                                        //     }
                                                                        // }
                                                                        maxRotation: 90,
                                                                        minRotation: 90
                                                                    }

                                                                }],
                                                                yAxes: [
                                                                    {
                                                                        display: true,
                                                                        scaleLabel: {
                                                                            display: true
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        }
                                                    });
                                                }
                                                else if (getValue == 'conversion') {
                                                    // console.log("conversation is working");
                                                    new Chart(document.getElementById("line-chart1"), {
                                                        type: 'line',
                                                        data: {
                                                            labels: campaignName,
                                                            datasets: [
                                                                {
                                                                    data: conversionsValue,
                                                                    label: "Conversion",
                                                                    borderColor: "#FF0000",
                                                                    fill: false
                                                                },
                                                            ]
                                                        },
                                                        options: {
                                                            responsive: true,
                                                            title: {
                                                                display: true,
                                                                text: 'Conversion'
                                                            },
                                                            scales: {
                                                                xAxes: [{
                                                                    display: true,
                                                                    scaleLabel: {
                                                                        display: true,
                                                                        // labelString: 'Date'
                                                                    },
                                                                    labelWrap: true,
                                                                    ticks: {
                                                                        // callback: function (label) {
                                                                        //     if (/\s/.test(label)) {
                                                                        //         return label.split(" ");
                                                                        //     }
                                                                        //     else {
                                                                        //         return label;
                                                                        //     }
                                                                        // }
                                                                        maxRotation: 90,
                                                                        minRotation: 90
                                                                    }

                                                                }],
                                                                yAxes: [
                                                                    {
                                                                        display: true,
                                                                        scaleLabel: {
                                                                            display: true
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        }
                                                    });
                                                }
                                                else if (getValue == 'spend') {
                                                    new Chart(document.getElementById("line-chart1"), {
                                                        type: 'line',
                                                        data: {
                                                            labels: campaignName,
                                                            datasets: [
                                                                {
                                                                    data: revenueValue,
                                                                    label: "Spend",
                                                                    borderColor: "#e8c3b9",
                                                                    fill: false
                                                                }]
                                                        },
                                                        options: {
                                                            responsive: true,
                                                            title: {
                                                                display: true,
                                                                text: 'Spend'
                                                            },
                                                            scales: {
                                                                xAxes: [{
                                                                    display: true,
                                                                    scaleLabel: {
                                                                        display: true,
                                                                        // labelString: 'Date'
                                                                    },
                                                                    labelWrap: true,
                                                                    ticks: {
                                                                        // callback: function (label) {
                                                                        //     if (/\s/.test(label)) {
                                                                        //         return label.split(" ");
                                                                        //     }
                                                                        //     else {
                                                                        //         return label;
                                                                        //     }
                                                                        // }
                                                                        maxRotation: 90,
                                                                        minRotation: 90
                                                                    }

                                                                }],
                                                                yAxes: [
                                                                    {
                                                                        display: true,
                                                                        scaleLabel: {
                                                                            display: true
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        }
                                                    });
                                                }
                                                else if (getValue == 'ctr') {
                                                    new Chart(document.getElementById("line-chart1"), {
                                                        type: 'line',
                                                        data: {
                                                            labels: campaignName,
                                                            datasets: [{
                                                                data: ctrValue,
                                                                label: "CTR",
                                                                borderColor: "#c45850",
                                                                fill: false
                                                            }]
                                                        },
                                                        options: {
                                                            responsive: true,
                                                            title: {
                                                                display: true,
                                                                text: 'CTR'
                                                            },
                                                            scales: {
                                                                xAxes: [{
                                                                    display: true,
                                                                    scaleLabel: {
                                                                        display: true,
                                                                        // labelString: 'Date'
                                                                    },
                                                                    labelWrap: true,
                                                                    ticks: {
                                                                        // callback: function (label) {
                                                                        //     if (/\s/.test(label)) {
                                                                        //         return label.split(" ");
                                                                        //     }
                                                                        //     else {
                                                                        //         return label;
                                                                        //     }
                                                                        // }
                                                                        maxRotation: 90,
                                                                        minRotation: 90
                                                                    }

                                                                }],
                                                                yAxes: [
                                                                    {
                                                                        display: true,
                                                                        scaleLabel: {
                                                                            display: true
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        }
                                                    });
                                                }
                                                else if (getValue == 'ecpm') {
                                                    new Chart(document.getElementById("line-chart1"), {
                                                        type: 'line',
                                                        data: {
                                                            labels: campaignName,
                                                            datasets: [{
                                                                data: ecpmValue,
                                                                label: "ECPM",
                                                                borderColor: "#3e95cd",
                                                                fill: false
                                                            }]
                                                        },
                                                        options: {
                                                            responsive: true,
                                                            title: {
                                                                display: true,
                                                                text: 'ECPM'
                                                            },
                                                            scales: {
                                                                xAxes: [{
                                                                    display: true,
                                                                    scaleLabel: {
                                                                        display: true,
                                                                        // labelString: 'Date'
                                                                    },
                                                                    labelWrap: true,
                                                                    ticks: {
                                                                        // callback: function (label) {
                                                                        //     if (/\s/.test(label)) {
                                                                        //         return label.split(" ");
                                                                        //     }
                                                                        //     else {
                                                                        //         return label;
                                                                        //     }
                                                                        // }
                                                                        maxRotation: 90,
                                                                        minRotation: 90
                                                                    }

                                                                }],
                                                                yAxes: [
                                                                    {
                                                                        display: true,
                                                                        scaleLabel: {
                                                                            display: true
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        }
                                                    });
                                                }
                                                else {
                                                    console.log("chart is Not Working");
                                                }
                                            };
                                        </script>
                                      </div>
                                    </div>
                                </div>
                              </div>
                            </div>
                          </div>
                    </div>
                    
                    <!-- weights - Request, Impress, Click, Conversion  -->
                    <div class="col col-xs-12 col-sm-12 col-md-11 col-lg-4 col-xl-4 col-xxl-4">
                        <div class="row mb-4 mt-3">
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:90%'>
                                    <div class="card-body text-center">
                                        <i class="fa  fa-podcast  fa-2x text-info"  aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-primary  h6 mt-2 mb-2"><b>Request</b></span>
                                        <h3 class="card-title mb-1" id="req">0</h3>
                                        <small class="text-success fw-semibold">
                                            <i class="bx bx-up-arrow-alt"></i> +00.00%</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:90%'>
                                    <div class="card-body text-center">
                                        <i class="fa  fa-external-link  fa-2x text-info" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-primary h6 mt-2 mb-2"><b>Impression</b></span>
                                        <h3 class="card-title text-nowrap mb-1" id="imp">0</h3>
                                        <small class="text-success fw-semibold">
                                            <i class="bx bx-up-arrow-alt"></i> +00.00%</small>
                                    </div>
                                  </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:90%'>
                                    <div class="card-body text-center">
                                        <i class="fa  fa-paper-plane-o  fa-2x text-info" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block  text-primary h6 mt-2 mb-2"><b>Clicks</b></span>
                                        <h3 class="card-title text-nowrap mb-1" id="cli">0</h3>
                                        <small class="text-danger fw-semibold">
                                          <i class="bx bx-down-arrow-alt"></i> -00.00%</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:90%'>
                                    <div class="card-body text-center">
                                        <i class="fa  fa-credit-card-alt fa-2x text-info" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-primary h6 mt-2 mb-2"><b>Conversion</b></span>
                                        <h3 class="card-title mb-1" id="con">$0</h3>
                                        <small class="text-success fw-semibold">
                                            <i class="bx bx-up-arrow-alt"></i> +00.00%</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-3" >
                    <div class="row d-flex justify-content-center" style="margin-top: -10px;">
                    <!-- Top Campaigns -->
                        <div class="col col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="card mb-4" style='height: 94%'>
                                <div class="card-body table-responsive">
                                    <p class="h4">Top Campaigns</p>
                                    <table class="table table-hover table-responsive mt-3">
                                        <thead>
                                            <tr>
                                                <th >Name</th>
                                                <th class="text-center">Impression</th>
                                                <th class="text-center">Clicks</th>
                                                <th class="text-center">Conversions</th>
                                                <th class="text-center">Spend</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-center" id="campaign_table"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Top Banner -->
                        <div class="col col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="card mb-4" style='height: 94%'>
                                <div class="card-body table-responsive">
                                    <p class="h4">Top Banner</p>
                                    <table class="table table-hover mt-3">
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th class="text-center">Impression</th>
                                                <th class="text-center">Clicks</th>
                                                <th class="text-center">Conversions</th>
                                                <th class="text-center">Spend</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-center" id="banner_table"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Top Country -->
                    <div class="card mb-4">
                        <div class="card-body table-responsive">
                            <div class="row">
                                <div class="col col-xs-12 col-sm-12 col-md-5 col-lg-6 col-xl-6 col-xxl-6">
                                    <div class='card'>
                                        <div class='card-body table-responsive'>
                                        <p class="h4">Top Country</p>
                                    <table class="table table-hover  mt-3">
                                        <thead>
                                            <tr>
                                                <th class='text-center'>Name</th>
                                                <th class="text-center">Impression</th>
                                                <th class="text-center">Clicks</th>
                                                <th class="text-center">Conversions</th>
                                                <th class="text-center">Spend</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-center" id='country_table'></tbody>
                                    </table>
                                        </div>
                                    </div>  
                                </div>
                                <div class="col col-xs-12 col-sm-12 col-md-7 col-lg-6 col-xl-6 col-xxl-6">
                                    <!-- <canvas id="myChart" style="width:100%;max-width:600px"></canvas>
                                    <script>
                                        function biChangeChart(data1, data2) {
                                            var xValues = data2;
                                            var yValues = data1;
                                            var barColors = [
                                                "#003f5c",
                                                "#58508d",
                                                "#bc5090",
                                                "#ff6361",
                                                "#ffa600"
                                            ];

                                            new Chart("myChart", {
                                                type: "pie",
                                                data: {
                                                    labels: xValues,
                                                    datasets: [{
                                                        backgroundColor: barColors,
                                                        data: yValues
                                                    }]
                                                },
                                                options: {
                                                    title: {
                                                        display: true,
                                                        text: "Country List"
                                                    }
                                                }
                                            });
                                        };
                                    </script> -->
                                    <div class="wrapper">
                                        <canvas id="myChart4" class="bar_canvas"></canvas>
                                        <script>
                                            function biChangeChart(country_name, imp, click_value, conversion_value) {
                                                var ctx = document.getElementById("myChart4").getContext('2d');
                                                var myChart = new Chart(ctx, {
                                                    type: 'bar',
                                                    data: {
                                                        // labels: ["test1user", "test2user", "test3user", "test4user", "test5user"],
                                                        labels: country_name,
                                                        datasets: [{
                                                            label: 'Impression',
                                                            backgroundColor: "#caf270",
                                                            // data: [12, 59, 5, 56, 58, 12, 59, 87, 45],
                                                            data: imp
                                                        }, {
                                                            label: 'Click',
                                                            backgroundColor: "#45c490",
                                                            // data: [12, 59, 5, 56, 58, 12, 59, 85, 23],
                                                            data: click_value
                                                        }, {
                                                            label: 'Conversion',
                                                            backgroundColor: "#008d93",
                                                            // data: [12, 59, 5, 56, 58, 12, 59, 65, 51],
                                                            data: conversion_value
                                                        },
                                                            // {
                                                            //     label: 'Political parties',
                                                            //     backgroundColor: "#2e5468",
                                                            //     data: [12, 59, 5, 56, 58, 12, 59, 12, 74],
                                                            // }
                                                        ],
                                                    },
                                                    options: {
                                                        tooltips: {
                                                            displayColors: true,
                                                            callbacks: {
                                                                mode: 'x',
                                                            },
                                                        },
                                                        scales: {
                                                            xAxes: [{
                                                                stacked: true,
                                                                gridLines: {
                                                                    display: false,
                                                                }
                                                            }],
                                                            yAxes: [{
                                                                stacked: true,
                                                                // ticks: {
                                                                //     beginAtZero: true,
                                                                //     min: 0,
                                                                //     max: 1000,
                                                                //     stepSize: 100
                                                                // },
                                                                type: 'linear',
                                                            }]
                                                        },
                                                        responsive: true,
                                                        maintainAspectRatio: false,
                                                        legend: { position: 'top' },
                                                    }
                                                });
                                            };

                                        </script>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- / Content -->
		<?php include('footer.php'); ?>
		
		<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
        <script>
            function dash_filter() {
                const live_URL = 'http://43.204.47.201/revivemohan/adservernew/api/revive_stat';
                let client_id = document.getElementById('clientid').value;
                var filtervalue = document.getElementById('getDuration').value;
                const date = new Date();

                if (filtervalue == 'Today') {
                    let v3 = JSON.stringify(date);
                    v3 = v3.slice(1, 11);
                    var start_date = v3, end_date = v3;
                    if (filtervalue == 'Today') {
                        $("#daterange").css("display", "none");
                    }
                }
                else if (filtervalue == 'Yesterday') {
                    let current_date = date.setDate(date.getDate() - 1);
                    const get_date = new Date(date);
                    let yesterday_date = JSON.stringify(get_date);
                    yesterday_date = yesterday_date.slice(1, 11);
                    var start_date = yesterday_date, end_date = yesterday_date;
                    if (filtervalue == 'Yesterday') {
                        $("#daterange").css("display", "none");
                    }
                }
                else if (filtervalue == 'Last 7 days') {
                    let date_start = date.setDate(date.getDate() - 7);
                    let get_date = new Date(date_start);
                    let first_day = JSON.stringify(get_date);
                    first_day = first_day.slice(1, 11);

                    let current_date = new Date();
                    let date_end = JSON.stringify(current_date);
                    date_end = date_end.slice(1, 11);
                    // console.log("last 7 days", date_end);
                    var start_date = first_day, end_date = date_end;
                    if (filtervalue == 'Last 7 days') {
                        $("#daterange").css("display", "none");
                    }
                }
                else if (filtervalue == 'Last 30 days') {
                    let date_start = date.setDate(date.getDate() - 30);
                    let get_date = new Date(date_start);
                    var first_day = JSON.stringify(get_date);
                    first_day = first_day.slice(1, 11);

                    const current_date = new Date();
                    let date_end = JSON.stringify(current_date);
                    date_end = date_end.slice(1, 11);
                    var start_date = first_day, end_date = date_end;
                    // console.log("Last 30 days", date_end);
                    if (filtervalue == 'Last 30 days') {
                        $("#daterange").css("display", "none");
                    }
                }
                else if (filtervalue == 'This Month') {
                    if (filtervalue == 'This Month') {
                        $("#daterange").css("display", "none");
                    }
                    let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                    let cDate = firstDay.getDate(), cMonth = firstDay.getMonth() + 1, cYear = firstDay.getFullYear();
                    let first_day = cYear + "-" + cMonth + "-" + cDate;

                    const current_date = new Date();
                    let date_end = JSON.stringify(current_date);
                    date_end = date_end.slice(1, 11);
                    var start_date = first_day, end_date = date_end;
                    // console.log("date", date_end);
                    if (filtervalue == 'This Month') {
                        $("#daterange").css("display", "none");
                    }
                }
                else if (filtervalue == 'Last Month') {
                    if (filtervalue == 'Last Month') {
                        $("#daterange").css("display", "none");
                    }
                    var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                    var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                    var formatDateComponent = function (dateComponent) {
                        return (dateComponent < 10 ? '0' : '') + dateComponent;
                    }
                    var formatDate = function (date) {
                        return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                    };
                    var start_date = formatDate(prevMonthFirstDate), end_date = formatDate(prevMonthLastDate);
                    // console.log("last month", formatDate(prevMonthFirstDate));
                    if (filtervalue == 'Last Month') {
                        $("#daterange").css("display", "none");
                    }
                }
                else if (filtervalue == 'all statistics') {

                    // Start impression, click, request and conversion
                    $.ajax({
                        url: live_URL + '/get_all_dashboard_advertiser_campaign_statistics/' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzY1MzE2MTcsImV4cCI6MTcwODA2NzYxNywic3ViIjoicm9vdCJ9.lHIrVDshyRN4vtfHf7A-CTTin9xgD3SwMhpv1_mIp_A');
                        },
                        data: {},
                        success: function (data) {
                            // console.log("data", data);
                            if (data.msg == 'No Stats Available') {
                                document.getElementById('imp').innerHTML = 0;
                                document.getElementById('cli').innerHTML = 0;
                                document.getElementById('con').innerHTML = 0;
                                document.getElementById('req').innerHTML = 0;
                            }
                            else {
                                const entries = Object.values(data);
                                // console.log("data1", entries[0]['impressions']);
                                if (entries[0]['impressions'] == undefined) {
                                    document.getElementById('imp').innerHTML = 0;
                                }
                                else if (entries[0]['clicks'] == undefined) {
                                    document.getElementById('cli').innerHTML = 0;
                                }
                                else if (entries[0]['conversions'] == undefined) {
                                    document.getElementById('con').innerHTML = 0;
                                }
                                else if (entries[0]['requests'] == undefined) {
                                    document.getElementById('req').innerHTML = 0;
                                }
                                else {
                                    document.getElementById('imp').innerHTML = entries[0]['impressions'];
                                    document.getElementById('cli').innerHTML = entries[0]['clicks'];
                                    document.getElementById('con').innerHTML = entries[0]['conversions'];
                                    document.getElementById('req').innerHTML = entries[0]['requests'];
                                }
                            }
                        },
                        error: function () { },
                    });
                    // End impression, click, request and conversion

                    // Start Top Campaign and Banner
                    $.ajax({
                        url: live_URL + '/get_all_top_campaign_statistics/' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                        },
                        data: {},
                        success: function (data) {
                            // console.log("campaign data", data.msg);
                            if (data.msg == 'No Stats Available') {
                                let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                                document.getElementById('banner_table').innerHTML = stat_msg;
                                document.getElementById('campaign_table').innerHTML = stat_msg;
                            }
                            else {
                                var getBanData = "", TableData = "";

                                data.map((data) => {
                                    getBanData += `<tr>
                                                <td class="text-hide">${data.bannername}</td>
                                                <td>${data.impressions}</td>
                                                <td>${data.clicks}</td>
                                                <td>${data.conversions}</td>
                                                <td>${data.spend}</td>
                                            </tr>`
                                });
                                document.getElementById('banner_table').innerHTML = getBanData;

                                data.map((data) => {
                                    // console.log(data);
                                    TableData += `<tr>
                                    <td class="text-hide">${data.campaignname}</td>
                                    <td>${data.impressions}</td>
                                    <td>${data.clicks}</td>
                                    <td>${data.conversions}</td>
                                    <td>${data.spend}</td>
                                </tr>`
                                });
                                document.getElementById('campaign_table').innerHTML = TableData;
                            }
                        },
                        error: function () { },
                    });
                    // End Top Campaign and Banner

                    // Start Top Country
                    $.ajax({
                        url: live_URL + '/get_all_top_country_details/' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                        },
                        data: {},
                        success: function (data) {
                            // console.log("country data", data);
                            if (data.msg == 'No Stats Available') {
                                let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                                document.getElementById('country_table').innerHTML = stat_msg;
                            }
                            else {
                                var countryData = "";
                                data.map((data, index) => {
                                    countryData += `<tr key='index'>
                                    <td>${data.countryname}</td>
                                                        <td>${data.impressions}</td>
                                                        <td>${data.clicks}</td>
                                                        <td>${data.conversions}</td>
                                                        <td>${data.revenue}</td>
                                            </tr>`
                                });
                                document.getElementById('country_table').innerHTML = countryData;
                            }

                            var v1 = data.map((data) => {
                                return data.countryname;
                            });
                            // console.log("country chart name data", v1);

                            var imp = data.map((data) => {
                                var convert = parseInt(data.impressions, 10);
                                return convert;
                            })
                            // console.log("imp value", imp);

                            var click_value = data.map((data) => {
                                var convert = parseInt(data.clicks, 10);
                                return convert
                            });
                            // console.log("click value", click_value);

                            var conversion_value = data.map((data) => {
                                var convert = parseInt(data.conversions, 10);
                                return convert;
                            });
                            // console.log("conversion value", conversion_value);

                            biChangeChart(v1, imp, click_value, conversion_value);
                        },
                        error: function () { },
                    });
                    // End Top Country

                    // Campaign Chart Start
                    $.ajax({
                        url: live_URL + '/get_all_advertiser_campaign_graph_statistics/' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                        },
                        data: {},
                        success: function (data) {
                            // console.log("Campaign data", data);

                            if (data.msg == 'No Stats Available') {
                                testChart(campaignName = ["", "", "", "", ""], ImpressionValue = [0, 0, 0, 0, 0], clickValue = [0, 0, 0, 0, 0],
                                    conversionsValue = [0, 0, 0, 0, 0], revenueValue = [0, 0, 0, 0, 0], ctrValue = [0, 0, 0, 0, 0],
                                    ecpmValue = [0, 0, 0, 0, 0]);
                                campaignChart(campaignName = ["", "", "", "", ""], ImpressionValue = [0, 0, 0, 0, 0], clickValue = [0, 0, 0, 0, 0],
                                    conversionsValue = [0, 0, 0, 0, 0], revenueValue = [0, 0, 0, 0, 0], ctrValue = [0, 0, 0, 0, 0],
                                    ecpmValue = [0, 0, 0, 0, 0]);
                            }
                            else {
                                var campaignName = data.map((data) => {
                                    return data.campaignname;
                                });
                                // console.log("campaign name", campaignName);

                                var ImpressionValue = data.map((data, index) => {
                                    let convert = parseInt(data.impressions, 10);
                                    if (data.impressions == null) {
                                        convert[index] = 0;
                                    } else {
                                        return convert;
                                    }
                                });
                                // console.log("Impression Value", ImpressionValue);

                                var clickValue = data.map((data, index) => {
                                    let convert = parseInt(data.clicks, 10);
                                    if (data.clicks == null) {
                                        convert[index] = 0;
                                    } else {
                                        return convert;
                                    }
                                });
                                // console.log("click Value", clickValue);

                                var conversionsValue = data.map((data, index) => {
                                    let convert = parseInt(data.conversions, 10);
                                    if (data.conversions == null) {
                                        convert[index] = 0;
                                    } else {
                                        return convert;
                                    }
                                });
                                // console.log("conversions Value", conversionsValue);

                                var revenueValue = data.map((value, index) => {
                                    let convert = parseInt(value.revenue, 10);
                                    if (value.revenue == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("spend Value", revenueValue);

                                var ctrValue = data.map((data, index) => {
                                    let convert = parseInt(data.ctr, 10);
                                    if (data.ctr == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("ctr Value", ctrValue);

                                var ecpmValue = data.map((data, index) => {
                                    let convert = parseInt(data.ecpm, 10);
                                    if (data.ecpm == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                    return convert;
                                });
                                // console.log("ecpm Value", ecpmValue);

                                testChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue);
                                campaignChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue);
                            }
                        },
                        error: function () { },
                    });
                    // Campaign Chart End

                    if (filtervalue == 'all statistics') {
                        $("#daterange").css("display", "none");
                    }
                }
                else if (filtervalue == 'custom') {
                    if (filtervalue == 'custom') {
                        $("#daterange").css("display", "block");
                    }
                    $(document).on('change', '#daterange', function () {
                        var dates = $('#daterange').val();
                        const daterange = dates.split("-");
                    });
                    $(function () {
                        $('input[name="daterange"]').daterangepicker({
                            opens: 'left'
                        }, function (start, end, label) {
                            // console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
                            var start_date = start.format('YYYY-MM-DD'), end_date = end.format('YYYY-MM-DD');

                            // Start impression, click, request and conversion
                            $.ajax({
                                url: live_URL + '/get_advertiser_campaign_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                                type: 'GET',
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzY1MzE2MTcsImV4cCI6MTcwODA2NzYxNywic3ViIjoicm9vdCJ9.lHIrVDshyRN4vtfHf7A-CTTin9xgD3SwMhpv1_mIp_A');
                                },
                                data: {},
                                success: function (data) {
                                    // console.log("data", data);
                                    if (data.msg == 'No Stats Available') {
                                        document.getElementById('imp').innerHTML = 0;
                                        document.getElementById('cli').innerHTML = 0;
                                        document.getElementById('con').innerHTML = 0;
                                        document.getElementById('req').innerHTML = 0;
                                    }
                                    else {
                                        const entries = Object.values(data);
                                        // console.log("data1", entries[0]['impressions']);
                                        if (entries[0]['impressions'] == null) {
                                            document.getElementById('imp').innerHTML = 0;
                                        }
                                        else if (entries[0]['clicks'] == null) {
                                            document.getElementById('cli').innerHTML = 0;
                                        }
                                        else if (entries[0]['conversions'] == null) {
                                            document.getElementById('con').innerHTML = 0;
                                        }
                                        else if (entries[0]['requests'] == null) {
                                            document.getElementById('req').innerHTML = 0;
                                        }
                                        else {
                                            document.getElementById('imp').innerHTML = entries[0]['impressions'];
                                            document.getElementById('cli').innerHTML = entries[0]['clicks'];
                                            document.getElementById('con').innerHTML = entries[0]['conversions'];
                                            document.getElementById('req').innerHTML = entries[0]['requests'];
                                            // document.getElementById('imp').innerHTML = 270;
                                            // document.getElementById('cli').innerHTML = 180;
                                            // document.getElementById('con').innerHTML = 30;
                                            // document.getElementById('req').innerHTML = 320;
                                        }
                                    }
                                },
                                error: function () { },
                            });
                            // End impression, click, request and conversion

                            // Top Campaign Start
                            $.ajax({
                                url: live_URL + '/get_top_campaign_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                                type: 'GET',
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                                },
                                data: {},
                                success: function (data) {
                                    // console.log("campaign data", data.msg);
                                    if (data.msg == 'No Stats Available') {
                                        let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                                        document.getElementById('campaign_table').innerHTML = stat_msg;
                                    }
                                    else {
                                    //     let check = data.map((value, index) => {
                                    //         if (value.spend == null) {
                                    //     return data[index] = 0;
                                    // }
                                    // else {
                                    //     return value;
                                    // }
                                    //     });
                                    //     console.log("spend value", check);
                                        var getCamData = "";
                                        data.map((data) => {
                                            getCamData += `<tr>
                                                        <td class="text-hide">${data.campaignname}</td>
                                                        <td>${data.impressions}</td>
                                                        <td>${data.clicks}</td>
                                                        <td>${data.conversions}</td>
                                                        <td>${data.spend}</td>
                                                    </tr>`
                                        });
                                        document.getElementById('campaign_table').innerHTML = getCamData;
                                    }
                                },
                                error: function () { },
                            });
                            // End Top Campaign

                            // Start Top Banner
                            $.ajax({
                                url: live_URL + '/get_top_banner_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                                type: 'GET',
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                                },
                                data: {},
                                success: function (data) {
                                    // console.log("campaign data", data.msg);
                                    if (data.msg == 'No Stats Available') {
                                        let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                                        document.getElementById('banner_table').innerHTML = stat_msg;
                                        document.getElementById('campaign_table').innerHTML = stat_msg;
                                    }
                                    else {
                                        
                                        var getBanData = "";
                                        data.map((data) => {
                                            getBanData += `<tr>
                                                                <td class='text-hide'>${data.bannername}</td>
                                                                <td>${data.impressions}</td>
                                                                <td>${data.clicks}</td>
                                                                <td>${data.conversions}</td>
                                                                <td>${data.spend}</td>
                                                            </tr>`
                                        });
                                        document.getElementById('banner_table').innerHTML = getBanData;
                                    }
                                },
                                error: function () { },
                            });
                            // End Top Banner

                            // Start Top Country
                            $.ajax({
                                url: live_URL + '/get_top_country_details/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                                type: 'GET',
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                                },
                                data: {},
                                success: function (data) {
                                    // console.log("country data", data[0]);
                                    if (data.msg == 'No Stats Available') {
                                        let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                                        document.getElementById('country_table').innerHTML = stat_msg;
                                    }
                                    else {
                                        var countryData = "";
                                        data.map((data, index) => {
                                            countryData += `<tr key='index'>
                                            <td>${data.countryname}</td>
                                                        <td>${data.impressions}</td>
                                                        <td>${data.clicks}</td>
                                                        <td>${data.conversions}</td>
                                                        <td>${data.revenue}</td>
                                                            </tr>`
                                        });
                                        document.getElementById('country_table').innerHTML = countryData;
                                    }

                                    var v1 = data.map((data) => {
                                        return data.countryname;
                                    });
                                    // console.log("country chart name data", v1);

                                    var imp = data.map((data) => {
                                        var convert = parseInt(data.impressions, 10);
                                        return convert;
                                    })
                                    // console.log("imp value", imp);

                                    var click_value = data.map((data) => {
                                        var convert = parseInt(data.clicks, 10);
                                        return convert
                                    });
                                    // console.log("click value", click_value);

                                    var conversion_value = data.map((data) => {
                                        var convert = parseInt(data.conversions, 10);
                                        return convert;
                                    });
                                    // console.log("conversion value", conversion_value);

                                    biChangeChart(v1, imp, click_value, conversion_value);
                                },
                                error: function () { },
                            });
                            // End Top Country

                            // Campaign Chart Start
                            $.ajax({
                        url: live_URL + '/get_advertiser_campaign_graph_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                        },
                        data: {},
                        success: function (data) {
                            console.log("custom Campaign data", data);

                            if (data.msg == 'No Stats Available') {
                                testChart(campaignName = ["", "", "", "", ""], ImpressionValue = [0, 0, 0, 0, 0], clickValue = [0, 0, 0, 0, 0],
                                    conversionsValue = [0, 0, 0, 0, 0], revenueValue = [0, 0, 0, 0, 0], ctrValue = [0, 0, 0, 0, 0],
                                    ecpmValue = [0, 0, 0, 0, 0]);
                                    campaignChart(campaignName = ["", "", "", "", ""], ImpressionValue = [0, 0, 0, 0, 0], clickValue = [0, 0, 0, 0, 0],
                                    conversionsValue = [0, 0, 0, 0, 0], revenueValue = [0, 0, 0, 0, 0], ctrValue = [0, 0, 0, 0, 0],
                                    ecpmValue = [0, 0, 0, 0, 0]);
                            }
                            else {
                                var campaignName = data.map((data) => {
                                    return data.campaignname;
                                });
                                // console.log("campaign name", campaignName);

                                var ImpressionValue = data.map((data, index) => {
                                    let convert = parseInt(data.impressions, 10);
                                    if (data.impressions == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("Impression Value", ImpressionValue);

                                var clickValue = data.map((data) => {
                                    let convert = parseInt(data.clicks, 10);
                                    if (data.clicks == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("click Value", clickValue);

                                var conversionsValue = data.map((data) => {
                                    let convert = parseInt(data.conversions, 10);
                                    if (data.conversions == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("conversions Value", conversionsValue);

                                var revenueValue = data.map((value, index) => {
                                    let convert = parseInt(value.revenue, 10);
                                    if (value.revenue == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("spend Value", revenueValue);

                                var ctrValue = data.map((data, index) => {
                                    let convert = parseInt(data.ctr, 10);
                                    if (data.ctr == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("ctr Value", ctrValue);

                                var ecpmValue = data.map((data, index) => {
                                    let convert = parseInt(data.ecpm, 10);
                                    if (data.ecpm == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("ecpm Value", ecpmValue);

                                testChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue);
                                campaignChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue);
                            }
                        },
                        error: function () { },
                    });
                            // Campaign Chart End
                        })
                    });
                }


                if (filtervalue == "Today" || filtervalue == 'Yesterday' || filtervalue == 'Last 7 days' ||
                    filtervalue == 'Last 30 days' || filtervalue == 'This Month' || filtervalue == 'Last Month') {

                    // Start impression, click, request and conversion
                    $.ajax({
                        url: live_URL + '/get_advertiser_campaign_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzY1MzE2MTcsImV4cCI6MTcwODA2NzYxNywic3ViIjoicm9vdCJ9.lHIrVDshyRN4vtfHf7A-CTTin9xgD3SwMhpv1_mIp_A');
                        },
                        data: {},
                        success: function (data) {
                            //$('#hmm').html(data);
                            // console.log("data", data);
                            if (data.msg == 'No Stats Available') {
                                document.getElementById('imp').innerHTML = 0;
                                document.getElementById('cli').innerHTML = 0;
                                document.getElementById('con').innerHTML = "$0";
                                document.getElementById('req').innerHTML = 0;
                            }
                            else {

                                const entries = Object.values(data);
                                if (entries[0]['requests'] == null && entries[0]['impressions'] == null && entries[0]['clicks'] == null && entries[0]['conversions'] == null) {
                                    document.getElementById('req').innerHTML = 0;
                                    document.getElementById('imp').innerHTML = 0;
                                    document.getElementById('cli').innerHTML = 0;
                                    document.getElementById('con').innerHTML = "$0";
                                }
                                else {
                                    document.getElementById('imp').innerHTML = entries[0]['impressions'];
                                    document.getElementById('cli').innerHTML = entries[0]['clicks'];
                                    document.getElementById('con').innerHTML = entries[0]['conversions'];
                                    document.getElementById('req').innerHTML = entries[0]['requests'];
                                }

                            }
                        },
                        error: function () { },
                    });
                    // End impression, click, request and conversion

                    // Top Campaign Start
                    $.ajax({
                        url: live_URL + '/get_top_campaign_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                        },
                        data: {},
                        success: function (data) {
                            // console.log("campaign data", data.msg);
                            if (data.msg == 'No Stats Available') {
                                let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                                document.getElementById('campaign_table').innerHTML = stat_msg;
                            }
                            else {
                                var getCamData = "";
                                data.map((data) => {
                                    getCamData += `<tr>
                                                        <td class="text-hide">${data.campaignname}</td>
                                                        <td>${data.impressions}</td>
                                                        <td>${data.clicks}</td>
                                                        <td>${data.conversions}</td>
                                                        <td>${data.spend}</td>
                                                    </tr>`
                                });
                                document.getElementById('campaign_table').innerHTML = getCamData;
                            }
                        },
                        error: function () { },
                    });
                    // End Top Campaign

                    // Top Banner Start
                    $.ajax({
                        url: live_URL + '/get_top_banner_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                        },
                        data: {},
                        success: function (data) {
                            // console.log("campaign data", data.msg);
                            if (data.msg == 'No Stats Available') {
                                let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                                document.getElementById('banner_table').innerHTML = stat_msg;
                            }
                            else {
                                var getBanData = "";
                                data.map((data) => {
                                    getBanData += `<tr>
                                                        <td class="text-hide">${data.bannername}</td>
                                                        <td>${data.impressions}</td>
                                                        <td>${data.clicks}</td>
                                                        <td>${data.conversions}</td>
                                                        <td>${data.spend}</td>
                                                    </tr>`
                                });
                                document.getElementById('banner_table').innerHTML = getBanData;
                            }
                        },
                        error: function () { },
                    });
                    // Top Banner End

                    // Top Country Start
                    $.ajax({
                        url: live_URL + '/get_top_country_details/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                        },
                        data: {},
                        success: function (data) {
                            // console.log("country data", data[0]);
                            if (data.msg == 'No Stats Available') {
                                let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                                document.getElementById('country_table').innerHTML = stat_msg;
                                biChangeChart(v1 = [], imp = [], click_value = []);
                            }
                            else {
                                var countryData = "";
                                data.map((data, index) => {
                                    countryData += `<tr key='index'>
                                                        <td>${data.countryname}</td>
                                                        <td>${data.impressions}</td>
                                                        <td>${data.clicks}</td>
                                                        <td>${data.conversions}</td>
                                                        <td>${data.revenue}</td>
                                                    </tr>`
                                });
                                document.getElementById('country_table').innerHTML = countryData;

                                var v1 = data.map((data) => {
                                    // return country_name.push(data.countryname);
                                    return data.countryname;
                                });
                                // console.log("country chart name data", v1);

                                var imp = data.map((data) => {
                                    var convert = parseInt(data.impressions, 10);
                                    return convert;
                                })
                                // console.log("imp value", imp);

                                var click_value = data.map((data) => {
                                    var convert = parseInt(data.clicks, 10);
                                    return convert
                                });
                                // console.log("click value", click_value);

                                var conversion_value = data.map((data) => {
                                    var convert = parseInt(data.conversions, 10);
                                    return convert;
                                });
                                // console.log("conversion value", conversion_value);

                                biChangeChart(v1, imp, click_value, conversion_value);
                            }
                        },
                        error: function () { },
                    });
                    // Top Country End

                    // Campaign Chart Start
                    $.ajax({
                        url: live_URL + '/get_advertiser_campaign_graph_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                        },
                        data: {},
                        success: function (data) {
                            // console.log("Campaign data", data);

                            if (data.msg == 'No Stats Available') {
                                testChart(campaignName = ["", "", "", "", ""], ImpressionValue = [0, 0, 0, 0, 0], clickValue = [0, 0, 0, 0, 0],
                                    conversionsValue = [0, 0, 0, 0, 0], revenueValue = [0, 0, 0, 0, 0], ctrValue = [0, 0, 0, 0, 0],
                                    ecpmValue = [0, 0, 0, 0, 0]);
                                    campaignChart(campaignName = ["", "", "", "", ""], ImpressionValue = [0, 0, 0, 0, 0], clickValue = [0, 0, 0, 0, 0],
                                    conversionsValue = [0, 0, 0, 0, 0], revenueValue = [0, 0, 0, 0, 0], ctrValue = [0, 0, 0, 0, 0],
                                    ecpmValue = [0, 0, 0, 0, 0]);
                            }
                            else {
                                var campaignName = data.map((data) => {
                                    return data.campaignname;
                                });
                                // console.log("campaign name", campaignName);

                                var ImpressionValue = data.map((data, index) => {
                                    let convert = parseInt(data.impressions, 10);
                                    if (data.impressions == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("Impression Value", ImpressionValue);

                                var clickValue = data.map((data) => {
                                    let convert = parseInt(data.clicks, 10);
                                    if (data.clicks == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("click Value", clickValue);

                                var conversionsValue = data.map((data) => {
                                    let convert = parseInt(data.conversions, 10);
                                    if (data.conversions == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("conversions Value", conversionsValue);

                                var revenueValue = data.map((value, index) => {
                                    let convert = parseInt(value.revenue, 10);
                                    if (value.revenue == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("spend Value", revenueValue);

                                var ctrValue = data.map((data, index) => {
                                    let convert = parseInt(data.ctr, 10);
                                    if (data.ctr == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("ctr Value", ctrValue);

                                var ecpmValue = data.map((data, index) => {
                                    let convert = parseInt(data.ecpm, 10);
                                    if (data.ecpm == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("ecpm Value", ecpmValue);

                                testChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue);
                                campaignChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue);
                            }
                        },
                        error: function () { },
                    });
                    // Campaign Chart End
                }
            };
        </script>
        <script src="../assets/js/config.js"></script>
        <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>
  </body>
</html>