<?php

/*
 * 
 * File Created by DAC141
 * 
 */

/*---------------- Start of Agency Statistics -------------*/

$app->get('/get_agency_advertiser_statistics/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');              
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
    $input = $request->getParsedBody();
    $table_prefix= $this->get('settings')['path']['table_prefix'];
    $datetime=date('Y-m-d H:i:s');
	$startdate=$args['start_date'];
	$enddate=$args['end_date'];  
	$agencyid = $args['agency_id'];
	
	$stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
	$std = $this->db->prepare($stc);
	$std->bindParam("agency_id",$args['agency_id']);
	$std->execute();
	$agency = $std->fetchAll();

	if($agency)
	{
		$sql="select 		
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,		
		cl.clientname as clientname,		
		cl.clientid as clientid,
		cl.agencyid as agencyid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	 
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."agency as g
		where
		h.ad_id = b.bannerid
		AND b.campaignid = c.campaignid
		AND g.agencyid = :agencyid
		AND cl.agencyid = g.agencyid
		AND cl.clientid = c.clientid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by clientid";

    $sth = $this->db->prepare($sql);
    $sth->bindParam(":agencyid",$agencyid);

    $sth->execute();
    
    $todos = $sth->fetchAll();
    if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		// $response = array('response'=>'error','ok'=>'No Stats Available');
		$response = array('response'=>'ok','msg'=>'No Stats Available');

			return $this->response->withJson($response);
	}
  //  return $this->response->withJson($todos);
		
	}
	else{
		// $response = array('response'=>'error','ok'=>'Please enter valid Agency Id');

		$response = array('response'=>'error','msg'=>'Please enter valid Agency Id');
		return $this->response->withJson($response);

	}
	
		
  
}
    
})->add($container->get('datevalidation'));




$app->get('/get_agency_campaign_statistics/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
    $input = $request->getParsedBody();
    $table_prefix= $this->get('settings')['path']['table_prefix'];
    $datetime=date('Y-m-d H:i:s');
	$startdate=$args['start_date'];	
	$enddate=$args['end_date']; 
	$agencyid = $args['agency_id']; 
	
	$stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
	$std = $this->db->prepare($stc);
	$std->bindParam("agency_id",$args['agency_id']);
	$std->execute();
	$agency = $std->fetchAll();

	if($agency)
	{
		$sql="select 
		g.agencyid as agencyid,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		c.campaignname as campaignname,
		cl.clientid as clientid,
		cl.agencyid as agencyid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."agency as g
		where
		h.ad_id = b.bannerid
		AND b.campaignid = c.campaignid
		AND g.agencyid = :agencyid
		AND cl.agencyid = g.agencyid
		AND c.clientid = cl.clientid 
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by c.campaignid";

    $sth = $this->db->prepare($sql);
    $sth->bindParam(":agencyid",$agencyid);

    $sth->execute();
    
    $todos = $sth->fetchAll();
    
    if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		// $response = array('response'=>'error','ok'=>'No Stats Available');

		$response = array('response'=>'ok','msg'=>'No Stats Available');		
			return $this->response->withJson($response);
	}
	}
	else{
		
		// $response = array('response'=>'error','ok'=>'Please enter valid Agency Id');

		$response = array('response'=>'error','msg'=>'Please enter valid Agency Id');
		return $this->response->withJson($response);

	}
  
}
    
})->add($container->get('datevalidation'));



$app->get('/get_agency_banner_statistics/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
    $input = $request->getParsedBody();
    $table_prefix= $this->get('settings')['path']['table_prefix'];
    $datetime=date('Y-m-d H:i:s');
	$startdate=$args['start_date'];
	$enddate=$args['end_date']; 
	$agencyid = $args['agency_id']; 
		
	$stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
	$std = $this->db->prepare($stc);
	$std->bindParam("agency_id",$args['agency_id']);
	$std->execute();
	$agency = $std->fetchAll();

	if($agency)
	{
	$sql="select 
			g.agencyid as agencyid,
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.description as bannername,
			b.campaignid as campaignid,
			c.campaignid as camp,
			c.clientid as client,
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."agency as g
			where
			h.ad_id = b.bannerid
			AND g.agencyid = :agencyid
			AND cl.agencyid = g.agencyid
			AND b.campaignid = c.campaignid   
			AND c.clientid = cl.clientid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by ad_id"; 

	$sth = $this->db->prepare($sql);
	$sth->bindParam(":agencyid",$agencyid);
	$sth->execute();    
	$todos = $sth->fetchAll();    
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		// $response = array('response'=>'error','ok'=>'No Stats Available');
		$response = array('response'=>'ok','msg'=>'No Stats Available');

			return $this->response->withJson($response);
	}
	}
	else{
		
		$response = array('response'=>'error','msg'=>'Please enter valid Agency Id');
		return $this->response->withJson($response);

	}
  
}
    
})->add($container->get('datevalidation'));




$app->get('/get_agency_publisher_statistics/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$agency_id = $args['agency_id']; 
		
		$stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id",$args['agency_id']);
		$std->execute();
		$agency = $std->fetchAll();

		if($agency)
		{
		$sql="select 
			g.agencyid as agencyid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			a.name as affiliatename, 
			z.affiliateid as affiliateid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as a,
			".$table_prefix."zones as z,
			".$table_prefix."agency as g
			where
			h.zone_id = z.zoneid
			AND g.agencyid = :agencyid
			AND a.agencyid = g.agencyid
			AND a.affiliateid = z.affiliateid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by  affiliateid";

    $sth = $this->db->prepare($sql);
    $sth->bindParam(":agencyid",$agency_id);

    $sth->execute();
    
    $todos = $sth->fetchAll();
    
   if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
    }
	else{
		
		$response = array('response'=>'error','msg'=>'Please enter valid Agency Id');
		return $this->response->withJson($response);

	}
  
}
    
})->add($container->get('datevalidation'));



$app->get('/get_agency_zone_statistics/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$agencyid = $args['agency_id']; 
		
		$stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id",$args['agency_id']);
		$std->execute();
		$agency = $std->fetchAll();

		if($agency)
		{
		$sql="select 
		g.agencyid as agencyid,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		z.zoneid as zoneid,
		z.zonename as zonename,
		z.affiliateid as affiliateid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."affiliates as a,
		".$table_prefix."zones as z,
		".$table_prefix."agency as g
		where
		z.zoneid = h.zone_id
		AND g.agencyid = :agencyid
		AND a.agencyid = g.agencyid
		AND a.affiliateid = z.affiliateid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by zoneid";

    $sth = $this->db->prepare($sql);
    $sth->bindParam(":agencyid",$agencyid);

    $sth->execute();
    
    $todos = $sth->fetchAll();
    
   if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
	}
	else{
		
		$response = array('response'=>'error','msg'=>'Please enter valid Agency Id');
		return $this->response->withJson($response);

	}
}
    
})->add($container->get('datevalidation'));


$app->get('/get_agency_daily_statistics/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$agency_id = $args['agency_id']; 
	
		$stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id",$args['agency_id']);
		$std->execute();
		$agency = $std->fetchAll();

		if($agency)
		{
			$sql="select 
			g.agencyid as agencyid,
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."agency as g
			where
			h.ad_id = b.bannerid
			AND b.campaignid = c.campaignid
			AND c.clientid = cl.clientid
			AND g.agencyid = :agencyid		
			AND cl.agencyid = g.agencyid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by DATE(date_time)";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid",$agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
			
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Agency Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));


/*---------------- End of Agency Statistics -------------*/


// /*--------------- Start of Advertiser Statistics ------------*/

$app->get('/get_advertiser_daily_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:advertiser_id";
		$std = $this->db->prepare($stc);
		$std->bindParam(":advertiser_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			$sql="select 
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,			
			c.clientid as client,
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl
			where
			h.ad_id = b.bannerid
			AND b.campaignid = c.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiser
			AND DATE(h.date_time) between '".$startdate."' and 
			'".$enddate."' group by DATE(date_time)";
			
			$sth = $this->db->prepare($sql);			
			$sth->bindParam(":advertiser",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();
		
			if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
			
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
		
  
}
 
})->add($container->get('datevalidation'));

// Get Advertiser campaign Statistics

$app->get('/get_advertiser_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if($client)
		{
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."'";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

$app->get('/get_advertiser_campaign_object_statistics/[{start_date},{end_date},{advertiser_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if ($client) {

			$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND DATE(h.date_time) between '" . $startdate . "'
			AND '" . $enddate . "' group by campaignid";

			$sql2 = "select max(h.impressions) as maximpressions,
			min(h.impressions) as minimpressions,
			max(h.clicks) as maxclicks,
			min(h.clicks) as minclicks,
			max(h.conversions) as maxconversions,
			min(h.conversions) as minconversions 
			from
			" . $table_prefix . "data_summary_ad_hourly as h
			where
			DATE(h.date_time) between '" . $startdate . "'
			AND '" . $enddate . "'";

			$sth = $this->db->prepare($sql);
			$sth_minmax = $this->db->prepare($sql2);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();
			$sth_minmax->execute();

			$minmax = $sth_minmax->fetchAll();
			$todos = $sth->fetchAll();

			if ($todos) {
				//echo "<pre>";
				 print_r($todos);
				 print_r($minmax);
				//return $this->response->withJson($todos);
			} else {
				$response = array('response' => 'ok', 'msg' => 'No Stats Available');
				//return $this->response->withJson($response);
				 print_r($response);
				 print_r($minmax);
				//print_r($todos);
			}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));

//Campaign Report Statistics

$app->get('/get_advertiser_campaign_report_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them group by campaignid h.ad_id as ad_id,b.bannerid as bannerid,b.description as bannername,
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if($client)
		{
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

// All Advertiser Campaign Statistics

$app->get('/get_all_advertiser_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if($client)
		{
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			group by b.campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

// All Advertiser Campaign Statistics

$app->get('/get_all_dashboard_advertiser_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if($client)
		{
			
			$sql="select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		
		$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

//Advertiser Graph Statistics

$app->get('/get_advertiser_campaign_graph_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 
		cl.clientid as clientid,
		cl.clientname as clientname,
		CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
		TIMESTAMP(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.requests) as requests,
		round(sum(h.total_revenue),0) as revenue,
		
		round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by c.campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();
		
		/*$impressionsarr = array(); 
		$clicksarr = array(); 
		$conversionsarr = array(); 
		$revenuearr = array(); 
		$ctrarr = array(); 
		$ecpmarr = array(); 
		foreach($todos as $todorow => $imrow)
		{
		
		$impressionsarr[$todorow] = $imrow['impressions'];
		$clicksarr[$todorow] = $imrow['clicks'];
		$conversionsarr[$todorow] = $imrow['conversions'];
		$revenuearr[$todorow] = $imrow['revenue'];
		$ctrarr[$todorow] = $imrow['ctr'];
		$ecpmarr[$todorow] = $imrow['ecpm'];
		
		}
		$maximpressions = max($impressionsarr);
		$maxclicks = max($clicksarr);
		$maxconversions = max($conversionsarr);
		$maxrevenue = max($revenuearr);
		$maxctr = max($ctrarr);
		$maxecpm = max($ecpmarr);

		// find the key of the impression with the highest value
		$impression_key = array_search($maximpressions, $impressionsarr);
		$clicks_key = array_search($maxclicks, $clicksarr);
		$conversions_key = array_search($maxconversions, $conversionsarr);
		$revenue_key = array_search($maxrevenue, $revenuearr);
		$ctr_key = array_search($maxctr, $ctrarr);
		$ecpm_key = array_search($maxecpm, $ecpmarr);

		$impression_with_highest_value = $todos[$impression_key];
		$clicks_with_highest_value = $todos[$clicks_key];
		$conversions_with_highest_value = $todos[$conversions_key];
		$revenue_with_highest_value = $todos[$revenue_key];
		$ctr_with_highest_value = $todos[$ctr_key];
		$ecpm_with_highest_value = $todos[$ecpm_key];
        
		$impression = $impression_with_highest_value['impressions'];
		$clicks = $clicks_with_highest_value['clicks'];
		$conversions = $conversions_with_highest_value['conversions'];
		$revenue = $revenue_with_highest_value['revenue'];
		$ctr = $ctr_with_highest_value['ctr'];
		$ecpm = $ecpm_with_highest_value['ecpm'];
		 
		 $todos[] = array("maximpression" => ($impression),
					"maxclicks" => ($clicks),
					"maxconversions" => ($conversions),
					"maxrevenue" => ($revenue),
					"maxctr" => ($ctr),
					"maxecpm" => ($ecpm)); */
					//print_r($data);
        //exit;
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

//Advertiser All Graph Statistics

$app->get('/get_all_advertiser_campaign_graph_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 
		cl.clientid as clientid,
		cl.clientname as clientname,
		CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
		TIMESTAMP(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.requests) as requests,
		round(sum(h.total_revenue),0) as revenue,
		
		round((sum(h.clicks)/sum(h.impressions)),0) * 100 as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();
		/* $impressionsarr = array(); 
		$clicksarr = array(); 
		$conversionsarr = array(); 
		$revenuearr = array(); 
		$ctrarr = array(); 
		$ecpmarr = array(); 
		foreach($todos as $todorow => $imrow)
		{
		
		$impressionsarr[$todorow] = $imrow['impressions'];
		$clicksarr[$todorow] = $imrow['clicks'];
		$conversionsarr[$todorow] = $imrow['conversions'];
		$revenuearr[$todorow] = $imrow['revenue'];
		$ctrarr[$todorow] = $imrow['ctr'];
		$ecpmarr[$todorow] = $imrow['ecpm'];
		
		}
		$maximpressions = max($impressionsarr);
		$maxclicks = max($clicksarr);
		$maxconversions = max($conversionsarr);
		$maxrevenue = max($revenuearr);
		$maxctr = max($ctrarr);
		$maxecpm = max($ecpmarr);

		// find the key of the impression with the highest value
		$impression_key = array_search($maximpressions, $impressionsarr);
		$clicks_key = array_search($maxclicks, $clicksarr);
		$conversions_key = array_search($maxconversions, $conversionsarr);
		$revenue_key = array_search($maxrevenue, $revenuearr);
		$ctr_key = array_search($maxctr, $ctrarr);
		$ecpm_key = array_search($maxecpm, $ecpmarr);

		$impression_with_highest_value = $todos[$impression_key];
		$clicks_with_highest_value = $todos[$clicks_key];
		$conversions_with_highest_value = $todos[$conversions_key];
		$revenue_with_highest_value = $todos[$revenue_key];
		$ctr_with_highest_value = $todos[$ctr_key];
		$ecpm_with_highest_value = $todos[$ecpm_key];
        
		$impression = $impression_with_highest_value['impressions'];
		$clicks = $clicks_with_highest_value['clicks'];
		$conversions = $conversions_with_highest_value['conversions'];
		$revenue = $revenue_with_highest_value['revenue'];
		$ctr = $ctr_with_highest_value['ctr'];
		$ecpm = $ecpm_with_highest_value['ecpm'];
		 
		$todos[] = array("maximpression" => ($impression),
					"maxclicks" => ($clicks),
					"maxconversions" => ($conversions),
					"maxrevenue" => ($revenue),
					"maxctr" => ($ctr),
					"maxecpm" => ($ecpm));
					//print_r($data);
        //exit; */
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

// top  banner

$app->get('/get_top_banner_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 
		c.campaignname as campaignname,
		b.description as bannername,
        DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		round(sum(h.total_revenue),2) as spend,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by b.bannerid ORDER BY spend DESC limit 5";
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();

		// echo "query";
		// print_r($todos);exit;

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

// top campaign statistics

$app->get('/get_top_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 
		c.campaignname as campaignname,
        DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		round(sum(h.total_revenue),2) as spend,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by c.campaignid ORDER BY spend DESC limit 5";
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();

		// echo "query";
		// print_r($todos);exit;

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

//All top campaign and banner

$app->get('/get_all_top_campaign_banner_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 
		c.campaignname as campaignname,
		b.description as bannername,
        DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		round(sum(h.total_revenue),2) as spend,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by h.total_revenue ORDER BY spend DESC limit 5";
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();

		// echo "query";
		// print_r($todos);exit;

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

//All top campaign and banner

$app->get('/get_all_top_campaign_statistics/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 
		c.campaignname as campaignname,
		b.description as bannername,
        DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		round(sum(h.total_revenue),2) as spend,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid ORDER BY spend DESC limit 5";
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();

		// echo "query";
		// print_r($todos);exit;

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
});

//Top Country

$app->get('/get_top_country_details/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them AND c.clientid = cl.clientid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
     
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."campaigns where clientid=:clientid";
		$std = $this->db->prepare($stc);
		$std->bindParam("clientid",$advertiser_id);
		$std->execute();
		$campaign = $std->fetchAll();

		if($campaign)
		{
		$sql="select 		
		co.country_name as countryname,
		c.campaignname as campaignname,
		round((case when  c.revenue_type = 1 then h.impressions*c.revenue/1000 
             when c.revenue_type = 2 then h.clicks*c.revenue
             else h.impressions*c.revenue
             end),2) as revenue,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks
		from
		" . $table_prefix . "stats_country as h,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "clients as cl, 
		" . $table_prefix . "zones as z, 
        da_country as co
		where
        h.creative_id=b.bannerid
		And z.zoneid = h.zone_id
		AND c.campaignid = b.campaignid
		AND co.counrty_code = h.country
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
        AND DATE(h.date_time) between '".$startdate."' AND '".$enddate."'
		group by co.country_name ORDER BY revenue DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();
		$todos = $sth->fetchAll();

			if($todos)

		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}

		
}

  
})->add($container->get('datevalidation'));


//All Top Country

$app->get('/get_all_top_country_details/[{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
     
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."campaigns where clientid=:clientid";
		$std = $this->db->prepare($stc);
		$std->bindParam("clientid",$advertiser_id);
		$std->execute();
		$campaign = $std->fetchAll();

		if($campaign)
		{
		$sql="select 		
		co.country_name as countryname,
		c.campaignname as campaignname,
		round((case when  c.revenue_type = 1 then h.impressions*c.revenue/1000 
             when c.revenue_type = 2 then h.clicks*c.revenue
             else h.impressions*c.revenue
             end),2) as revenue,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks
		from
		" . $table_prefix . "stats_country as h,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "clients as cl, 
		" . $table_prefix . "zones as z, 
        da_country as co
		where
        h.creative_id=b.bannerid
		And z.zoneid = h.zone_id
		AND c.campaignid = b.campaignid
		AND co.counrty_code = h.country
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by co.country_name ORDER BY revenue DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->execute();
		$todos = $sth->fetchAll();

			if($todos)

		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Campaign Id');
			return $this->response->withJson($response);
		}

		
}

  
});

//Advertiser Banner Statistics

$app->get('/get_advertiser_banner_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
		$sql="select 
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		round(sum(h.total_revenue),2) as revenue,
		b.bannerid as bannerid,
		b.campaignid as campaignid,
		b.description as bannername,
		cl.clientid as clientid,		
		round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl
		where
		h.ad_id = b.bannerid
		AND c.clientid = :advertiserid
		AND cl.clientid = c.clientid
		AND b.campaignid = c.campaignid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' GROUP BY ad_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));

//Advertiser Campaignwise Banner Statistics

$app->get('/get_advertiser_campaignwise_banner_statistics/[{start_date},{end_date},{advertiser_id},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		$campaign_id = $args['campaign_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
		$sql="select 
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		round(sum(h.total_revenue),2) as revenue,
		b.bannerid as bannerid,
		b.campaignid as campaignid,
		c.campaignname as campaignname,
		b.description as bannername,
		cl.clientid as clientid,		
		round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl
		where
		h.ad_id = b.bannerid
		AND c.clientid = :advertiserid
		AND c.campaignid = :campaignid
		AND cl.clientid = c.clientid
		AND b.campaignid = c.campaignid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' GROUP BY ad_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);
		$sth->bindParam(":campaignid",$campaign_id);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));


// Geo report api - Advertiser

$app->get('/get_georeport_statistics/[{start_date},{end_date},{advertiser_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if ($client) {

	    $sql = "select 
		c.campaignname as campaignname,
		c.revenue as revenues,
		c.revenue_type as revenue_type,
		c.weight,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
		sum(adh.impressions) as impressions,
		sum(adh.clicks) as clicks,
        round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
		when c.revenue_type = 2 then adh.clicks*c.revenue
		else adh.impressions*c.revenue
		end),2) as revenue,
		round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
		round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
		from
		" . $table_prefix . "stats_country as adh,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "clients as cl,
		" . $table_prefix . "zones as z 
		where
		adh.creative_id=b.bannerid
		And z.zoneid = adh.zone_id
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		AND adh.creative_id >= 0
		AND DATE(adh.date_time) between '" . $startdate . "'
		AND '" . $enddate . "' group by adh.country,c.campaignid";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();
			
			// print_r($sql);exit;

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['conversions'] * $todos[$i]['revenues'];
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}

				if ($todos[$i]['country'] != "-") {
				    $todos[$i]['countrycode'] = $todos[$i]['country'];
					$todos[$i]['country'] = $country_array[$todos[$i]['country']];
					
				} else {

					$todos[$i]['country'] = "Others";
				}

				$data[] = array(
					"country" => ($todos[$i]['country'] ? $todos[$i]['country'] : 'Others'),
					"countrycode" => ($todos[$i]['countrycode'] ? $todos[$i]['countrycode'] : 'Others'),
					"region" => ($newArray[$key2]) ? $newArray[$key2] :  '-',
					"city" => ($todos[$i]['city']) ? $todos[$i]['city'] : '-',
					"campaignname" => ($todos[$i]['campaignname']) ? $todos[$i]['campaignname'] : '-',
					//"bannername" => ($todos[$i]['bannername']) ? $todos[$i]['bannername'] : '-',
					//"request"=>$row['requests'],
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"conversions"=>$todos[$i]['conversions'],
					"ctr" => ($todos[$i]['impressions'] > 0) ? round($todos[$i]['clicks'] / $todos[$i]['impressions'] * 100, 2) : 0.00,
					"ecpm" => ($todos[$i]['impressions'] > 0) ? round(($total_revenue / $todos[$i]['impressions']) * 1000, 2) : 0.00,
				   //	"pub_income" => $pub_income,
					"total_revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue']  : 0.00,
				);

				}


				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));

// Geo Report Map API 

$app->get('/get_georeport_map_statistics/[{start_date},{end_date},{advertiser_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if ($client) {

	    $sql = "select 
		c.campaignname as campaignname,
		c.revenue as revenues,
		c.revenue_type as revenue_type,
		c.weight,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
		sum(adh.impressions) as impressions,
		sum(adh.clicks) as clicks,
        round((adh.impressions*c.revenue/1000),2) as rev,
		round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
		round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
		from
		" . $table_prefix . "stats_country as adh,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "clients as cl, 
		" . $table_prefix . "zones as z 
		where
		adh.creative_id=b.bannerid
		And z.zoneid = adh.zone_id
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		AND DATE(adh.date_time) between '" . $startdate . "'
		AND '" . $enddate . "' group by adh.country";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();
			
			// print_r($sql);exit;

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['conversions'] * $todos[$i]['revenues'];
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}

				if ($todos[$i]['country'] != "-") {
				    $todos[$i]['countrycode'] = $todos[$i]['country'];
					$todos[$i]['country'] = $country_array[$todos[$i]['country']];
					
				} else {

					$todos[$i]['country'] = "Others";
				}

				$data[] = array(
					"country" => ($todos[$i]['country'] ? $todos[$i]['country'] : 'Others'),
					"countrycode" => ($todos[$i]['countrycode'] ? $todos[$i]['countrycode'] : 'Others'),
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
				);

				}


				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));

// All Geo Report Map API 

$app->get('/get_all_georeport_map_statistics/[{advertiser_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if ($client) {

	    $sql = "select 
		c.campaignname as campaignname,
		c.revenue as revenues,
		c.revenue_type as revenue_type,
		c.weight,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
		sum(adh.impressions) as impressions,
		sum(adh.clicks) as clicks,
        round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
		when c.revenue_type = 2 then adh.clicks*c.revenue
		else adh.impressions*c.revenue
		end),2) as revenue,
		round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
		round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
		from
		" . $table_prefix . "stats_country as adh,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "clients as cl, 
		" . $table_prefix . "zones as z 
		where
		adh.creative_id=b.bannerid
		And z.zoneid = adh.zone_id
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by adh.country";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();
			
			// print_r($sql);exit;

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['conversions'] * $todos[$i]['revenues'];
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}

				if ($todos[$i]['country'] != "-") {
				    $todos[$i]['countrycode'] = $todos[$i]['country'];
					$todos[$i]['country'] = $country_array[$todos[$i]['country']];
					
				} else {

					$todos[$i]['country'] = "Others";
				}

				$data[] = array(
					"country" => ($todos[$i]['country'] ? $todos[$i]['country'] : 'Others'),
					"countrycode" => ($todos[$i]['countrycode'] ? $todos[$i]['countrycode'] : 'Others'),
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
				);

				}


				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//All Geo report api

$app->get('/get_all_georeport_statistics/[{advertiser_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if ($client) {

			$sql = "select 
		c.campaignname as campaignname,
		c.revenue as revenues,
		c.revenue_type as revenue_type,
		c.weight,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
		sum(adh.impressions) as impressions,
		sum(adh.clicks) as clicks,
		round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
		when c.revenue_type = 2 then adh.clicks*c.revenue
		else adh.impressions*c.revenue
		end),2) as revenue,
		round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
		round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
		from
		" . $table_prefix . "stats_country as adh,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "clients as cl, 
		" . $table_prefix . "zones as z 
		where
		adh.creative_id=b.bannerid
		And z.zoneid = adh.zone_id
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by adh.country,c.campaignid ";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['conversions'] * $todos[$i]['revenues'];
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}

				if ($todos[$i]['country'] != "-") {
				    $todos[$i]['countrycode'] = $todos[$i]['country'];
					$todos[$i]['country'] = $country_array[$todos[$i]['country']];
					
				} else {

					$todos[$i]['country'] = "Others";
				}

				$data[] = array(
					"country" => ($todos[$i]['country'] ? $todos[$i]['country'] : 'Others'),
					"countrycode" => ($todos[$i]['countrycode'] ? $todos[$i]['countrycode'] : 'Others'),
					"region" => ($newArray[$key2]) ? $newArray[$key2] :  '-',
					"city" => ($todos[$i]['city']) ? $todos[$i]['city'] : '-',
					"campaignname" => ($todos[$i]['campaignname']) ? $todos[$i]['campaignname'] : '-',
					"bannername" => ($todos[$i]['bannername']) ? $todos[$i]['bannername'] : '-',
					//"request"=>$row['requests'],
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"conversions"=>$todos[$i]['conversions'],

					"ctr" => ($todos[$i]['impressions'] > 0) ? round($todos[$i]['clicks'] / $todos[$i]['impressions'] * 100, 2) : 0.00,
					"ecpm" => ($todos[$i]['impressions'] > 0) ? round(($todos[$i]['total_revenue'] / $todos[$i]['impressions']) * 1000, 2) : 0.00,
				   //	"pub_income" => $pub_income,
					"total_revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue'] : 0.00,
				);

				}


				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});


$app->get('/get_advertiser_publisher_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
		$sql="select 
		h.zone_id as zoneid,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
        b.campaignid as campaignid,
		p.name as affiliatename,
		cl.clientid as clientid,	
		p.affiliateid as affiliateid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."affiliates as p,
		".$table_prefix."zones as z
		where
		h.ad_id = b.bannerid
		AND c.clientid = :advertiserid
		AND cl.clientid = c.clientid
		AND z.affiliateid =  p.affiliateid
		AND z.zoneid = h.zone_id
		AND b.campaignid = c.campaignid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by affiliateid";
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
	$sth = $this->db->prepare($sql);
	$sth->bindParam(":advertiserid",$advertiser_id);

	$sth->execute();
	$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
  
}
 
})->add($container->get('datevalidation'));


$app->get('/get_advertiser_zone_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
		$sql="select 
		h.ad_id as ad_id,
		h.zone_id as zoneid,
		DATE(h.date_time) as date_time,
		h.impressions as impressions,
		h.clicks as clicks,
		h.conversions as conversions,
		h.total_revenue as revenue,
		b.bannerid as bannerid,
        b.campaignid as campaignid,
		cl.clientid as clientid,
		z.affiliateid as affiliateid,
		z.zonename as zonename,
		p.agencyid as agencyid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm 
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."affiliates as p,
		".$table_prefix."zones as z
		where
		h.ad_id = b.bannerid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		AND p.affiliateid = z.affiliateid
		AND h.zone_id = z.zoneid
		AND b.campaignid = c.campaignid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by zoneid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
	}
	else{
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
	}
}
 
})->add($container->get('datevalidation'));

/*--------------- End of Advertiser Statistics ------------*/

/*--------------- Start of Campaign Statistics ------------*/

$app->get('/get_campaign_daily_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$campaignid = $args['campaign_id']; 
		
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaign_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaign_id",$campaignid);
		$std->execute();
		$campaign = $std->fetchAll();

		if($campaign)
		{
		$sql="select 
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,	
		c.clientid as clientid,
		b.campaignid as campaignid,
		c.campaignname as campaignname,
		cl.agencyid as agencyid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."agency as a
		where
		h.ad_id = b.bannerid
		AND b.campaignid = c.campaignid
		AND c.campaignid = :campaignid
		AND a.agencyid=cl.agencyid
		AND cl.clientid=c.clientid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by DATE(date_time)";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":campaignid",$campaignid);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Campaign Id');
			return $this->response->withJson($response);
		}
  
}
 
})->add($container->get('datevalidation'));

$app->get('/get_campaign_banner_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$campaignid = $args['campaign_id']; 
		
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaign_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaign_id",$campaignid);
		$std->execute();
		$campaign = $std->fetchAll();

		if($campaign)
		{
		$sql="select 
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
		b.description as bannername,
		b.campaignid as campaignid,
		c.clientid as clientid,
		c.campaignname as campaignname,
		cl.agencyid as agencyid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm 
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."agency as a
		where
		h.ad_id = b.bannerid
		AND b.campaignid = c.campaignid
		AND c.campaignid = :campaign_id
		AND a.agencyid=cl.agencyid
		AND cl.clientid=c.clientid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by ad_id";
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":campaign_id",$campaignid);
		$sth->execute();
		$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Campaign Id');
			return $this->response->withJson($response);
		}
  
}
 
})->add($container->get('datevalidation'));

$app->get('/get_campaign_publisher_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
     
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$campaignid = $args['campaign_id']; 
		
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaign_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaign_id",$campaignid);
		$std->execute();
		$campaign = $std->fetchAll();

		if($campaign)
		{
		$sql="select 
		p.agencyid as agencyid,
		h.zone_id as zoneid,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
        b.description as bannername,
		b.campaignid as campaignid,
		p.affiliateid as affiliateid,		
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."affiliates as p,
		".$table_prefix."zones as z
		where
		h.ad_id = b.bannerid
		AND z.zoneid = h.zone_id
		AND b.campaignid =:campaignid
		AND c.campaignid =b.campaignid
		AND z.affiliateid = p.affiliateid
		AND DATE(h.date_time) between '".$startdate."'
		and '".$enddate."' group by affiliateid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":campaignid",$campaignid);
		$sth->execute();
		$todos = $sth->fetchAll();
			if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Campaign Id');
			return $this->response->withJson($response);
		}
}
 
})->add($container->get('datevalidation'));

$app->get('/get_campaign_zone_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    $table_prefix= $this->get('settings')['path']['table_prefix'];
    $input = $request->getParsedBody();		
	$datetime=date('Y-m-d H:i:s');
	$startdate=$args['start_date'];
	$enddate=$args['end_date']; 
	$campaignid = $args['campaign_id']; 
    $stc = "select * from ".$table_prefix."campaigns where campaignid=:campaign_id";
	$std = $this->db->prepare($stc);
	$std->bindParam("campaign_id",$campaignid);
	$std->execute();
	$campaign = $std->fetchAll();	
	if($campaign)
	{
		
		$sql="select 
		h.ad_id as ad_id,
		h.zone_id as zoneid,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
		b.campaignid as campaignid,
		p.affiliateid as affiliateid,
		z.zonename as zonename,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."affiliates as p,
		".$table_prefix."zones as z
		where
		h.ad_id = b.bannerid
		AND h.zone_id = z.zoneid
		AND b.campaignid = :campaignid
		AND c.campaignid = b.campaignid
		AND p.affiliateid = z.affiliateid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by zoneid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":campaignid",$campaignid);
		$sth->execute();
		$todos = $sth->fetchAll();
			if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
	}
	else{
			$response = array('response'=>'error','msg'=>'Please enter valid Campaign Id');
			return $this->response->withJson($response);
	}

}
 
})->add($container->get('datevalidation')); 

/*--------------- End of Campaign Statistics ------------*/

/*--------------- Start of Banner Statistics ------------*/

$app->get('/get_banner_daily_statistics/[{start_date},{end_date},{banner_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
		
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['banner_id']; 
		
		$stc = "select * from ".$table_prefix."banners where bannerid=:banner_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("banner_id",$bannerid);
		$std->execute();
		$banners = $std->fetchAll();
		if($banners)
		{		
			$sql="select 	 	
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,					
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b
			where
			h.ad_id = :bannerid
			AND b.bannerid = :bannerid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by DATE(date_time)";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":bannerid",$bannerid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Banner Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 



$app->get('/get_banner_publisher_statistics/[{start_date},{end_date},{banner_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['banner_id']; 
		
		$stc = "select * from ".$table_prefix."banners where bannerid=:banner_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("banner_id",$bannerid);
		$std->execute();
		$banners = $std->fetchAll();
		if($banners)
		{
			
		$sql="select 		
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,		
		b.bannerid as bannerid,
		p.name as affiliatename,
		p.affiliateid as affiliateid
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."affiliates as p,	
		".$table_prefix."zones as z
		where
		h.ad_id = :bannerid
		AND b.bannerid = h.ad_id
		AND p.affiliateid = z.affiliateid
		AND z.zoneid = h.zone_id 
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."'  group by affiliateid"; 


		$sth = $this->db->prepare($sql);
		$sth->bindParam(":bannerid",$bannerid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Banner Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 



$app->get('/get_banner_zone_statistics/[{start_date},{end_date},{banner_id}]', function($request, $response, $args)
{ 
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['banner_id']; 
		
		$stc = "select * from ".$table_prefix."banners where bannerid=:banner_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("banner_id",$bannerid);
		$std->execute();
		$banners = $std->fetchAll();
		
		if($banners)
		{
		$sql="select 
		h.zone_id as zoneid,		
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
		p.affiliateid as affiliateid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
		z.zonename as zonename
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."affiliates as p,	
		".$table_prefix."zones as z
		where
		h.ad_id = :bannerid
		AND b.bannerid = h.ad_id
		AND p.affiliateid = z.affiliateid 
		AND h.zone_id = z.zoneid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by zoneid"; 

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":bannerid",$bannerid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Banner Id');
			return $this->response->withJson($response);
		}
}
 
})->add($container->get('datevalidation')); 

/*--------------- End of Banner Statistics ------------*/


/*--------------- Start of Publisher Statistics ------------*/


$app->get('/get_publisher_daily_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select		
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,		
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
			p.name as name
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by DATE(date_time)";
		
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
}
 
})->add($container->get('datevalidation')); 

// Geo Report Map API  - publisher

$app->get('/get_georeport_map__publisher_statistics/[{start_date},{end_date},{publisher_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publisherid) {

	    $sql = "select 
		c.campaignname as campaignname,
		c.revenue as revenues,
		c.revenue_type as revenue_type,
		c.weight,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
		sum(adh.impressions) as impressions,
		sum(adh.clicks) as clicks,
        round((adh.impressions*c.revenue/1000),2) as rev,
		round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
		round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
		from
		".$table_prefix."stats_country as adh,
        ".$table_prefix."banners as b,
        ".$table_prefix."campaigns as c,
        ".$table_prefix."zones as z,
        ".$table_prefix."affiliates as p
        where
        adh.creative_id=b.bannerid
        And z.zoneid = adh.zone_id
        AND c.campaignid = b.campaignid
        AND p.affiliateid = :publisherid
		AND p.affiliateid = z.affiliateid
		AND DATE(adh.date_time) between '" . $startdate . "'
		AND '" . $enddate . "' group by adh.country";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);

			$sth->execute();

			$todos = $sth->fetchAll();
			
			// print_r($sql);exit;

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['conversions'] * $todos[$i]['revenues'];
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}

				if ($todos[$i]['country'] != "-") {
				    $todos[$i]['countrycode'] = $todos[$i]['country'];
					$todos[$i]['country'] = $country_array[$todos[$i]['country']];
					
				} else {

					$todos[$i]['country'] = "Others";
				}

				$data[] = array(
					"country" => ($todos[$i]['country'] ? $todos[$i]['country'] : 'Others'),
					"countrycode" => ($todos[$i]['countrycode'] ? $todos[$i]['countrycode'] : 'Others'),
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
				);

				}


				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));

// All Geo Report Map API -publisher

$app->get('/get_all_georeport_map__publisher_statistics/[{publisher_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id'];
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publisherid) {

	    $sql = "select 
		c.campaignname as campaignname,
		c.revenue as revenues,
		c.revenue_type as revenue_type,
		c.weight,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
		sum(adh.impressions) as impressions,
		sum(adh.clicks) as clicks,
        round((adh.impressions*c.revenue/1000),2) as rev,
		round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
		round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
		from
		".$table_prefix."stats_country as adh,
        ".$table_prefix."banners as b,
        ".$table_prefix."campaigns as c,
        ".$table_prefix."zones as z,
        ".$table_prefix."affiliates as p
        where
        adh.creative_id=b.bannerid
        And z.zoneid = adh.zone_id
        AND c.campaignid = b.campaignid
        AND p.affiliateid = :publisherid
		AND p.affiliateid = z.affiliateid
	    group by adh.country";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);

			$sth->execute();

			$todos = $sth->fetchAll();
			
			// print_r($sql);exit;

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['conversions'] * $todos[$i]['revenues'];
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}

				if ($todos[$i]['country'] != "-") {
				    $todos[$i]['countrycode'] = $todos[$i]['country'];
					$todos[$i]['country'] = $country_array[$todos[$i]['country']];
					
				} else {

					$todos[$i]['country'] = "Others";
				}

				$data[] = array(
					"country" => ($todos[$i]['country'] ? $todos[$i]['country'] : 'Others'),
					"countrycode" => ($todos[$i]['countrycode'] ? $todos[$i]['countrycode'] : 'Others'),
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
				);

				}


				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Geo report API - Publisher


$app->get('/get_georeport__publisher_statistics/[{start_date},{end_date},{publisher_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {

	    $sql = "select 
        z.zonename as zonename,
        c.revenue as revenues,
        c.revenue_type as revenue_type,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
        sum(adh.impressions) as impressions,
        sum(adh.clicks) as clicks,	
		round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
		when c.revenue_type = 2 then adh.clicks*c.revenue
		else adh.impressions*c.revenue
		end),2) as revenue,
        round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
        round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm        
        from
        ".$table_prefix."stats_country as adh,
        ".$table_prefix."banners as b,
        ".$table_prefix."campaigns as c,
        ".$table_prefix."zones as z,
        ".$table_prefix."affiliates as p
        where
        adh.creative_id=b.bannerid
        And z.zoneid = adh.zone_id
        AND c.campaignid = b.campaignid
        AND p.affiliateid = :publisherid
		AND p.affiliateid = z.affiliateid
		AND DATE(adh.date_time) between '" . $startdate . "'
		AND '" . $enddate . "' group by adh.zone_id,adh.country";
			$sth = $this->db->prepare($sql);
			// $sth->bindParam(":affiliateid", $publisherid);
			$sth->bindParam(":publisherid",$publisherid);
			$sth->execute();

			$todos = $sth->fetchAll();
			
			//print_r($sql);exit;

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['conversions'] * $todos[$i]['revenues'];
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}

				if ($todos[$i]['country'] != "-") {
				    $todos[$i]['countrycode'] = $todos[$i]['country'];
					$todos[$i]['country'] = $country_array[$todos[$i]['country']];
					
				} else {

					$todos[$i]['country'] = "Others";
				}

				$data[] = array(
					"country" => ($todos[$i]['country'] ? $todos[$i]['country'] : 'Others'),
					"countrycode" => ($todos[$i]['countrycode'] ? $todos[$i]['countrycode'] : 'Others'),
					"region" => ($newArray[$key2]) ? $newArray[$key2] :  '-',
					"city" => ($todos[$i]['city']) ? $todos[$i]['city'] : '-',
					"zonename" => ($todos[$i]['zonename']) ? $todos[$i]['zonename'] : '-',
					//"bannername" => ($todos[$i]['bannername']) ? $todos[$i]['bannername'] : '-',
					//"request"=>$row['requests'],
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"conversions"=>$todos[$i]['conversions'],
					"ctr" => ($todos[$i]['impressions'] > 0) ? round($todos[$i]['clicks'] / $todos[$i]['impressions'] * 100, 2) : 0.00,
					"ecpm" => ($todos[$i]['impressions'] > 0) ? round(($total_revenue / $todos[$i]['impressions']) * 1000, 2) : 0.00,
				   //	"pub_income" => $pub_income,
					"total_revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue'] : 0.00,
				);

				}

				// echo "data";
				// print_r($data);exit;

				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));


//All Geo report API - Publisher


$app->get('/get_all_georeport__publisher_statistics/[{publisher_id}]', function ($request, $response, $args)
{

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {

	    $sql = "select 
        z.zonename as zonename,
        c.revenue as revenues,
        c.revenue_type as revenue_type,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
        sum(adh.impressions) as impressions,
        sum(adh.clicks) as clicks,
		round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
		when c.revenue_type = 2 then adh.clicks*c.revenue
		else adh.impressions*c.revenue
		end),2) as revenue,
        round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
        round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm        
        from
        ".$table_prefix."stats_country as adh,
        ".$table_prefix."banners as b,
        ".$table_prefix."campaigns as c,
        ".$table_prefix."zones as z,
        ".$table_prefix."affiliates as p
        where
        adh.creative_id=b.bannerid
        And z.zoneid = adh.zone_id
        AND c.campaignid = b.campaignid
        AND p.affiliateid = :publisherid
		AND p.affiliateid = z.affiliateid
	    group by adh.zone_id,adh.country";
			$sth = $this->db->prepare($sql);
			// $sth->bindParam(":affiliateid", $publisherid);
			$sth->bindParam(":publisherid",$publisherid);
			$sth->execute();

			$todos = $sth->fetchAll();
			
			//print_r($sql);exit;

			$country_array = array("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
		
			for ($i = 0; $i < count($todos); $i++) {
		
				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue  = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
	
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['conversions'] * $todos[$i]['revenues'];
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}

				}

				if ($todos[$i]['country'] != "-") {
				    $todos[$i]['countrycode'] = $todos[$i]['country'];
					$todos[$i]['country'] = $country_array[$todos[$i]['country']];
					
				} else {

					$todos[$i]['country'] = "Others";
				}

				$data[] = array(
					"country" => ($todos[$i]['country'] ? $todos[$i]['country'] : 'Others'),
					"countrycode" => ($todos[$i]['countrycode'] ? $todos[$i]['countrycode'] : 'Others'),
					"region" => ($newArray[$key2]) ? $newArray[$key2] :  '-',
					"city" => ($todos[$i]['city']) ? $todos[$i]['city'] : '-',
					"zonename" => ($todos[$i]['zonename']) ? $todos[$i]['zonename'] : '-',
					//"bannername" => ($todos[$i]['bannername']) ? $todos[$i]['bannername'] : '-',
					//"request"=>$row['requests'],
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"conversions"=>$todos[$i]['conversions'],
					"ctr" => ($todos[$i]['impressions'] > 0) ? round($todos[$i]['clicks'] / $todos[$i]['impressions'] * 100, 2) : 0.00,
					"ecpm" => ($todos[$i]['impressions'] > 0) ? round(($total_revenue / $todos[$i]['impressions']) * 1000, 2) : 0.00,
				   //	"pub_income" => $pub_income,
					"total_revenue" => ($$todos[$i]['revenue'] > 0) ? $$todos[$i]['revenue'] : 0.00,
				);
				}
				if ($data) {
					return $this->response->withJson($data);
				} else {
					$response = array('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			//}
		} else {

			$response = array('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

// Publisher Zone Statistics

$app->get('/get_publisher_zone_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		// $sql="select 		  
		// 	DATE(h.date_time) as date_time,
		// 	sum(h.impressions) as impressions,
		// 	sum(h.clicks) as clicks,
		// 	sum(h.conversions) as conversions,
		// 	sum(h.total_revenue) as revenue,		
		// 	cl.clientid as clientid,
		// 	(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		// 	(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
		// 	p.affiliateid as affiliateid,
		// 	p.name as affiliatename,
		// 	z.zonename as zonename
		// 	from
		// 	".$table_prefix."data_summary_ad_hourly as h,
		// 	".$table_prefix."banners as b,
		// 	".$table_prefix."campaigns as c,
		// 	".$table_prefix."clients as cl,
		// 	".$table_prefix."affiliates as p,
		// 	".$table_prefix."zones as z
		// 	where
		// 	h.ad_id = b.bannerid
		// 	AND cl.clientid = c.clientid
		// 	AND p.affiliateid = :publisherid
		// 	and p.affiliateid=z.affiliateid
		// 	AND z.zoneid = h.zone_id
		// 	AND b.campaignid = c.campaignid
		// 	AND DATE(h.date_time) between '".$startdate."'
		// 	AND '".$enddate."' group by h.zone_id";

		$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by h.zone_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 

// All Publisher Zone Statistics

$app->get('/get_all_publisher_zone_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    group by h.zone_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
}); 

//Publisher Top Zone Statistics - Revenue

$app->get('/get_publisher_top_zone_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by z.zoneid ORDER BY spend DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation'));


// Publisher Top Zone Statistics - ctr

$app->get('/get_publisher_top_zone_ctr_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by z.zoneid ORDER BY ctr DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation'));

// All top zone
$app->get('/get_all_publisher_top_zone_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
			$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    group by z.zoneid ORDER BY spend DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
});

// All publisher top zone - ctr

$app->get('/get_all_publisher_top_zone_ctr_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
			$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    group by z.zoneid ORDER BY ctr DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
});

// Publisher Top Country

$app->get('/get_publisher_top_country_details/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them AND c.clientid = cl.clientid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
     
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisher_id = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisher_id);
		$std->execute();
		$campaign = $std->fetchAll();

		if($campaign)
		{
		$sql="select 		
		co.country_name as countryname,
		c.campaignname as campaignname,
		round((case when  c.revenue_type = 1 then h.impressions*c.revenue/1000 
             when c.revenue_type = 2 then h.clicks*c.revenue
             else h.impressions*c.revenue
             end),2) as revenue,
		round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks
		from
		" . $table_prefix . "stats_country as h,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "affiliates as p,
		" . $table_prefix . "zones as z,
        da_country as co
		where
		h.creative_id=b.bannerid
		And z.zoneid = h.zone_id
		And c.campaignid = b.campaignid
		AND co.counrty_code = h.country
		AND p.affiliateid = :publisherid
		AND p.affiliateid = z.affiliateid
        AND DATE(h.date_time) between '".$startdate."' AND '".$enddate."'
		group by co.country_name ORDER BY ctr DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisher_id);
		$sth->execute();
		$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
		}else{
			$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
		}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
		
}

})->add($container->get('datevalidation'));

//All Publisher Top Country

$app->get('/get_all_publisher_top_country_details/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them AND c.clientid = cl.clientid
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
     
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix']; 
		$publisher_id = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisher_id);
		$std->execute();
		$campaign = $std->fetchAll();

		if($campaign)
		{
		$sql="select 		
		co.country_name as countryname,
		c.campaignname as campaignname,
		round((case when  c.revenue_type = 1 then h.impressions*c.revenue/1000 
             when c.revenue_type = 2 then h.clicks*c.revenue
             else h.impressions*c.revenue
             end),2) as revenue,
		round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks
		from
		" . $table_prefix . "stats_country as h,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "affiliates as p,
		" . $table_prefix . "zones as z,
        da_country as co
		where
		h.creative_id=b.bannerid
		And z.zoneid = h.zone_id
		And c.campaignid = b.campaignid
		AND co.counrty_code = h.country
		AND p.affiliateid = :publisherid
		AND p.affiliateid = z.affiliateid
		group by co.country_name ORDER BY ctr DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisher_id);
		$sth->execute();
		$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
		}else{
			$response = array('response'=>'ok','msg'=>'No Stats Available');
				return $this->response->withJson($response);
		}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
		
}

});

// Publisher Website Statistics

$app->get('/get_publisher_website_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			p.name as website,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by DATE(h.date_time)";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 

//All Publisher Website Statistics

$app->get('/get_all_publisher_website_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			p.name as website,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			group by DATE(h.date_time)";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
}); 

//Publisher Zone Chart Statistics

$app->get('/get_publisher_zone_chart_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			CONCAT(SUBSTRING(z.zonename FROM 1 FOR 4),'-',z.zoneid) as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by h.zone_id";

		
			// echo "sql";
			// print_r($sql);exit;
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 

//All Publisher Zone Chart Statistics

$app->get('/get_all_publisher_zone_chart_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			CONCAT(SUBSTRING(z.zonename FROM 1 FOR 4),'-',z.zoneid) as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			group by h.zone_id";


		echo "sql";
		print_r($sql);
		exit;

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
}); 

//publisher total counts 

$app->get('/get_publisher_widget_count_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{

		$sql="select
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.requests) as requests,
		sum(h.total_revenue) as revenue,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm,
		p.affiliateid as affiliateid,
		p.name as affiliatename
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."affiliates as p,
		".$table_prefix."zones as z
		where
		p.affiliateid = :publisherid
		and p.affiliateid=z.affiliateid
		AND z.zoneid = h.zone_id
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by p.affiliateid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation'));


//All publisher widget counts statistics


$app->get('/get_all_publisher_widget_count_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{

		$sql="select
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.requests) as requests,
		sum(h.total_revenue) as revenue,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm,
		p.affiliateid as affiliateid,
		p.name as affiliatename
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."affiliates as p,
		".$table_prefix."zones as z
		where
		p.affiliateid = :publisherid
		and p.affiliateid=z.affiliateid
		AND z.zoneid = h.zone_id
		group by p.affiliateid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
});

// Publisher Advertiser Statistics

$app->get('/get_publisher_advertiser_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 			
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			sum(h.total_revenue) as revenue,			
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			cl.clientname as clientname
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by clientid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation'));

// Publisher Widgets Statistics

$app->get('/get_publisher_widgets_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 			
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			sum(h.total_revenue) as revenue,			
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			cl.clientname as clientname
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by clientid";

			/* echo "query";
			print_r($sql);exit; */
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation'));

// All Publisher Widgets Statistics

$app->get('/get_all_publisher_widgets_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 			
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			sum(h.total_revenue) as revenue,			
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			cl.clientname as clientname
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			group by clientid";

			
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
}); 

$app->get('/get_publisher_campaign_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,		
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm,
			p.affiliateid as affiliateid,
			p.name as name,
			c.campaignname as campaignname
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by b.campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 

//Publisher Top Banner Statistics

$app->get('/get_top_publisher_banner_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,	
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			And p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by h.ad_id ORDER BY spend DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 

//All Publisher Top Banner Statistics

$app->get('/get_all_top_publisher_banner_statistics/[{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,	
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			group by h.ad_id ORDER BY spend DESC limit 5";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
}); 

$app->get('/get_publisher_banner_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,	
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by h.ad_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'ok','msg'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 



/*--------------- End of Publisher Statistics ------------*/

/*--------------- Start of zone Statistics ------------*/


$app->get('/get_zone_daily_statistics/[{start_date},{end_date},{zone_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$zoneid = $args['zone_id']; 
		
		$stc = "select * from ".$table_prefix."zones where zoneid=:zone_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("zone_id",$zoneid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
            b.campaignid as campaignid,
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as name,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND z.zoneid = :zoneid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by DATE(date_time)";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":zoneid",$zoneid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
        {
        return $this->response->withJson($todos);
    }else{
        $response = array('response'=>'ok','msg'=>'No Stats Available');
            return $this->response->withJson($response);
    }
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Zone Id');
			return $this->response->withJson($response);
		}
}
 
})->add($container->get('datevalidation')); 


$app->get('/get_zone_advertiser_statistics/[{start_date},{end_date},{zone_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$zoneid = $args['zone_id']; 
		
		$stc = "select * from ".$table_prefix."zones where zoneid=:zone_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("zone_id",$zoneid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
			$sql="select 
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			cl.clientname as clientname,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND z.zoneid = :zoneid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by clientid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":zoneid",$zoneid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
        {
        return $this->response->withJson($todos);
    }else{
        $response = array('response'=>'ok','msg'=>'No Stats Available');
            return $this->response->withJson($response);
    }
		
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Zone Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 


$app->get('/get_zone_campaign_statistics/[{start_date},{end_date},{zone_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$zoneid = $args['zone_id']; 
		
		$stc = "select * from ".$table_prefix."zones where zoneid=:zone_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("zone_id",$zoneid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			c.campaignname as campaignname,
			cl.clientname as clientname,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND z.zoneid = :zoneid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":zoneid",$zoneid);
		$sth->execute();
		$todos = $sth->fetchAll();
	if($todos)
        {
        return $this->response->withJson($todos);
    }else{
        $response = array('response'=>'ok','msg'=>'No Stats Available');
            return $this->response->withJson($response);
    }
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Zone Id');
			return $this->response->withJson($response);
		}

} 
 
})->add($container->get('datevalidation')); 


$app->get('/get_zone_banner_statistics/[{start_date},{end_date},{zone_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$zoneid = $args['zone_id']; 
		
		$stc = "select * from ".$table_prefix."zones where zoneid=:zone_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("zone_id",$zoneid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			h.zone_id as zoneid,
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			c.campaignname as campaignname,
			cl.clientname as clientname,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND z.zoneid = :zoneid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND  '".$enddate."' group by ad_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":zoneid",$zoneid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
        {
        return $this->response->withJson($todos);
    }else{
        $response = array('response'=>'ok','msg'=>'No Stats Available');
            return $this->response->withJson($response);
    }
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid Zone Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 



/*--------------- End of zone Statistics ------------*/

//Worked by DAC141//

/*--------------- Start of vast video Statistics ------------*/

$app->get('/get_vastvideo_eventsbycampaign/[{start_date},{end_date},{campaign_id},{event_id}]', function($request, $response, $args)
{
	//rv_data_bkt_vast_e
	//rv_stats_vast
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$event_id = $args['event_id']; 
		$campaign_id = $args['campaign_id']; 
		
		//$stc = "select * from ".$table_prefix."stats_vast where vast_event_id=$event_id";
		$stc= "	select a.campaignid as campaignid,
			b.vast_event_id as event_id
			from
			rv_campaigns as a,
			rv_stats_djaxvast as b
			where
			a.campaignid='".$campaign_id."' AND b.vast_event_id='".$event_id."'";
			
		//~ $cam= "select * from ".$table_prefix."campaigns where campaignid=$campaign_id";
		//~ if(! $cam)
		//~ {
			//~ print_r("enter valid id");
			//~ exit;
		//~ }
		
		//$stc = "select * from ".$table_prefix."stats_vast where vast_event_id=$event_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("event_id",$event_id);
		$std->bindParam("campaign_id",$campaign_id);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
			
	//	$sql="SELECT creative_id, vast_event_id, SUM(count) FROM ".$table_prefix."stats_vast WHERE `creative_id`=$creative_id GROUP BY vast_event_id";
		$sql="select 

	h.creative_id as ad_id,
h.vast_event_id as vast_event_id,
	DATE(h.interval_start) as date_time,
	sum(h.count) as count,
	b.bannerid as bannerid,
	b.campaignid as campaignid,
	c.clientid as clientid,
	c.campaignname as campaignname,
	cl.agencyid as agencyid
	from
	rv_stats_djaxvast as h,
	rv_banners as b,
	rv_campaigns as c,
	rv_clients as cl,
	rv_agency as a
	where
	h.creative_id = b.bannerid
	AND b.campaignid = c.campaignid
	AND c.campaignid = '".$campaign_id."'
	AND a.agencyid=cl.agencyid
	AND cl.clientid=c.clientid
	AND DATE(h.interval_start) between '".$startdate."' AND  '".$enddate."' AND h.vast_event_id='".$event_id."' group by h.vast_event_id";
		
			

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":event_id",$event_id);
		$sth->bindParam(":campaign_id",$campaign_id);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
    {
		return $this->response->withJson($todos);
	}
	else
	{
		$response = array('response'=>'ok','msg'=>'current statistics not available for given id campaign id');
		return $this->response->withJson($response);
	}
		//return $this->response->withJson($todos);
		}
		else{
			$response = array('response'=>'error','msg'=>'Please enter valid event id or campaign id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 


$app->get('/get_vastvideo_allevents', function($request, $response, $args)
{
	//rv_data_bkt_vast_e
	//rv_stats_vast
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		//~ $input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		//~ $datetime=date('Y-m-d H:i:s');
		//~ $startdate=$args['start_date'];
		//~ $enddate=$args['end_date']; 
		//~ $creative_id = $args['creative_id']; 
		//~ 
		//~ $stc = "select * from ".$table_prefix."data_bkt_vast_e where vast_event_id=$creative_id";
		//~ $std = $this->db->prepare($stc);
		//~ $std->bindParam("event_id",$event_id);
		//~ $std->execute();
		//~ $publishers = $std->fetchAll();
		//~ 
		//~ if($publishers)
		//~ {
			
		$sql="SELECT vast_event_id, SUM( count )FROM ".$table_prefix."stats_djaxvast GROUP BY vast_event_id";
		
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":event_id",$event_id);
		$sth->execute();
		$todos = $sth->fetchAll();
		return $this->response->withJson($todos);
		//~ }
		//~ else{
			//~ $response = array('response'=>'error','ok'=>'Please enter valid Zone Id');
			//~ return $this->response->withJson($response);
		//~ }

}
 
});


$app->get('/get_vastvideo_eventsbyadvertiser/[{start_date},{end_date},{client_id},{event_id}]', function($request, $response, $args)
{
	//rv_data_bkt_vast_e
	//rv_stats_vast
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$client_id = $args['client_id']; 
		$event_id = $args['event_id']; 
		
		
		//~ $stc = "select * from ".$table_prefix."clients where clientid='".$client_id."'";
		$stc = "	select a.clientid as clientid,
			b.vast_event_id as event_id
			from
			rv_clients as a,
			rv_stats_djaxvast as b
			where
			a.clientid='".$client_id."' AND b.vast_event_id='".$event_id."'";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$client_id);
		$std->bindParam("event_id",$event_id);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
			
	//	$sql="SELECT zone_id, vast_event_id, SUM( count ) FROM ".$table_prefix."stats_vast WHERE `zone_id` =$zone_id GROUP BY vast_event_id";
		$sql="select 
			h.creative_id as ad_id,
h.vast_event_id as vast_event_id,
	sum(h.count) as count,
	DATE(h.interval_start) as date_time,
		b.bannerid as bannerid,
		b.campaignid as campaignid,
		cl.clientid as clientid
		
		from
		rv_stats_djaxvast as h,
		rv_banners as b,
		rv_campaigns as c,
		rv_clients as cl 
		where
		h.creative_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = '".$client_id."' AND h.vast_event_id='".$event_id."'
		AND DATE(h.interval_start) between '".$startdate."'
		AND '".$enddate."' group by campaignid";
		
			

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":client_id",$client_id);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
    {
		return $this->response->withJson($todos);
	}
	else
	{
		
		$response = array('response'=>'ok','msg'=>'current statistics not available for id:'.$client_id.' ');
		return $this->response->withJson($response);
	}
		//return $this->response->withJson($todos);
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid event id or client id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 


$app->get('/get_vastvideo_eventsbywebsite/[{start_date},{end_date},{agency_id},{event_id},{affiliate_id}]', function($request, $response, $args)
{
	//rv_data_bkt_vast_e
	//rv_stats_vast
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$agency_id = $args['agency_id']; 
		$event_id = $args['event_id']; 
		$affiliate_id = $args['affiliate_id']; 
		
		
		//~ $stc = "select * from ".$table_prefix."affiliates where affiliateid='".$affiliate_id."'";
		$stc = "select a.agencyid as agencyid,
			b.vast_event_id as event_id,
			c.affiliateid as affiliateid
			from
			rv_agency as a,
			rv_stats_djaxvast as b,
			rv_affiliates as c
			where
			a.agencyid='".$agency_id."' AND b.vast_event_id='".$event_id."' AND affiliateid='".$affiliate_id."'";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliate_id",$affiliate_id);
		$std->bindParam("agency_id",$agency_id);
		$std->bindParam("event_id",$event_id);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
			
	//	$sql="SELECT zone_id, vast_event_id, SUM( count ) FROM ".$table_prefix."stats_vast WHERE `zone_id` =$zone_id GROUP BY vast_event_id";
		$sql="select 
			g.agencyid as agencyid,
			h.zone_id as zoneid,
	sum(h.count) as count,
			h.creative_id as ad_id,
h.vast_event_id as vast_event_id,
	DATE(h.interval_start) as date_time,
			a.name as affiliatename, 
			z.affiliateid as affiliateid
			
			from
			rv_stats_djaxvast as h,
			rv_affiliates as a,
			rv_zones as z,
			rv_agency as g
			where
			h.zone_id = z.zoneid
			AND g.agencyid = '".$agency_id."' AND a.affiliateid='".$affiliate_id."' AND h.vast_event_id='".$event_id."'
			AND a.agencyid = g.agencyid
			AND a.affiliateid = z.affiliateid
			AND DATE(h.interval_start) between '".$startdate."'
			AND '".$enddate."' group by  affiliateid";
		
			

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":affiliate_id",$affiliate_id);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
    {
		return $this->response->withJson($todos);
	}
	else
	{
		
		$response = array('response'=>'ok','msg'=>'current statistics not available for given website id ');
		return $this->response->withJson($response);
	}
		//return $this->response->withJson($todos);
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid affilaitae id or event id or agency id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation'));  


$app->get('/get_vastvideo_eventsbyzone/[{start_date},{end_date},{zone_id},{event_id},{affiliate_id}]', function($request, $response, $args)
{
	//rv_data_bkt_vast_e
	//rv_stats_vast
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$zone_id = $args['zone_id']; 
		$event_id = $args['event_id']; 
		$affiliate_id = $args['affiliate_id']; 
		
		
		//~ $stc = "select * from ".$table_prefix."affiliates where affiliateid='".$affiliate_id."'";
		$stc = "select a.zoneid as zoneid,
			b.vast_event_id as event_id,
			c.affiliateid as affiliateid
			from
			rv_zones as a,
			rv_stats_djaxvast as b,
			rv_affiliates as c
			where
			a.zoneid='".$zone_id."' AND b.vast_event_id='".$event_id."' AND c.affiliateid='".$affiliate_id."'";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliate_id",$affiliate_id);
		$std->bindParam("zone_id",$zone_id);
		$std->bindParam("event_id",$event_id);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
			
	//	$sql="SELECT zone_id, vast_event_id, SUM( count ) FROM ".$table_prefix."stats_vast WHERE `zone_id` =$zone_id GROUP BY vast_event_id";
		$sql="select 
			h.zone_id as zoneid,
			DATE(h.interval_start) as date_time,
			b.bannerid as bannerid,
			h.vast_event_id as event_id,
			sum(h.count) as count,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as name,
			
			b.description as bannername
			from
			rv_stats_djaxvast as h,
			rv_banners as b,
			rv_campaigns as c,
			rv_clients as cl,
			rv_affiliates as p,
			rv_zones as z
			where
			h.creative_id = b.bannerid
			AND cl.clientid = c.clientid
			AND z.zoneid = '".$zone_id."' AND h.vast_event_id ='".$event_id."' AND p.affiliateid='".$affiliate_id."'
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.interval_start) between '".$startdate."'
			AND '".$enddate."' group by DATE(interval_start)";
		
			

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":affiliate_id",$affiliate_id);
		$sth->bindParam(":zone_id",$zone_id);
		$sth->bindParam(":event_id",$event_id);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
    {
		return $this->response->withJson($todos);
	}
	else
	{
		
		$response = array('response'=>'ok','msg'=>'current statistics not available for given website id ');
		return $this->response->withJson($response);
	}
		//return $this->response->withJson($todos);
		}
		else{
			
			$response = array('response'=>'error','msg'=>'Please enter valid affilaitae id or event id or zone id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 

/*---- Vast video ads Statistics end----*/

