<?php 
include('session.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
data-template="vertical-menu-template-free">
	
	<head>
		<meta charset="utf-8" />
		<meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
		<title>Adserver - GEO | Report </title>
		
		<meta name="description" content="" />
		<style>
			.text-hide {
            display: block;
            width: 125px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
			}
			
			.text-hide:hover {
            overflow: inherit;
            width: auto;
			}
			
			#container1 {
            height: 500px;
            width: 800px;
            margin: 0 auto;
			}
			
			.highcharts-tooltip>span {
            padding: 10px;
            white-space: normal !important;
            width: 200px;
			}
			
			.loading {
            margin-top: 10em;
            text-align: center;
            color: gray;
			}
			
			.f32 .flag {
            vertical-align: middle !important;
			}
			.highcharts-legend-item{
		    display:none;
		}
			h5 {
            position: relative;
            left: 200%;
        }
		.highcharts-legend-item{
		display:none;
		}
		</style>
		
		<style>
			.svgMap-map-wrapper {
            background: #fff !important;
			}
			.svgMap-country {
            stroke: #8592a3 !important;
            stroke-width: 1 !important;
			}
		</style>
		
		
		
		
		<?php include('head.php'); ?>
		
		<link href="https://code.jquery.com/ui/1.10.4/themes/ui-lightness/jquery-ui.css" rel="stylesheet" />
		<script src="https://code.jquery.com/jquery-1.12.4.min.js"></script>
		<script src="https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>
		
		<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
		
		<script src="https://cdn.jsdelivr.net/npm/svg-pan-zoom@3.6.1/dist/svg-pan-zoom.min.js"></script>
		<script src="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.js"></script>
		<link href="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.css" rel="stylesheet">
		
		
		
	</head>
	
	
	<body onload="onChangeDetails()">
		<script src="https://code.highcharts.com/maps/highmaps.js"></script>
		<script src="https://code.highcharts.com/maps/modules/data.js"></script>
		<script src="https://code.highcharts.com/maps/modules/exporting.js"></script>
		<script src="https://code.highcharts.com/maps/modules/offline-exporting.js"></script>
		<script src="https://code.highcharts.com/maps/modules/accessibility.js"></script>
		
		<link rel="stylesheet" type="text/css" href="https://github.com/downloads/lafeber/world-flags-sprite/flags32.css">
		<!-- Layout wrapper -->
		<div class="layout-wrapper layout-content-navbar">
			<div class="layout-container">
				<!-- Menu -->
				
				<?php include('sidebar.php'); ?>
				
				<!-- / Menu -->
				
				<!-- Layout container -->
				<div class="layout-page">
					<!-- Navbar -->
					<?php include('navbar.php'); ?>
					<!-- / Navbar -->
					
					<!-- Content wrapper -->
					<div class="content-wrapper">
						<!-- Content -->
						
						<div class="container">
							<div class="card mt-3">
								<div class="card-body">
									<div class='row'>
										<div class='col-6'>
											<h4 class="mb-4">Geo Report</h4>
										</div>
										<div class="col-3">
											<select id='getZone' class="form-select" aria-label="Default select example"
											onchange="onChangeDetails()">
												<option value="" >Select Geo Type</option>
												<option value="country" selected>Country</option>
												<option value="region">Region</option>
												<option value="city">City</option>
											</select>
										</div>
										<div class='col-3'>
											<select id='getDuration' name="allfilter" class="form-select"
                                            aria-label="Default select example" onchange="onChangeDetails()">
												<option>Select Duration</option>
												<option value="Today" selected>Today</option>
												<option value="Yesterday">Yesterday</option>
												<option value="Last 7 days">Last 7 days</option>
												<option value="Last 30 days">Last 30 days</option>
												<option value="This Month">This Month</option>
												<option value="Last Month">Last Month</option>
												<option value='All Statistics'>All Statistics</option>
												<option value="Custom">Custom</option>
											</select>
											<input style="display: none;" id="daterange" name="daterange"
                                            value="02/01/2023 - 02/15/2023" />
										</div>
									</div>
									<br />
									
									<!-- <div class="row">
										<div id="svgMapSelectDuration"></div>
										<div id="svgMapToday"></div>
										<div id="svgMapYesterday"></div>
										<div id="svgMapLastsevendays"></div>
										<div id="svgMapLastthirtydays"></div>
										<div id="svgMapThismonth"></div>
										<div id="svgMapLastmonth"></div>
										<div id="svgMapAllstatistics"></div> 
										<div id="svgMapCustom"></div> 
									</div> -->
									<div id="container1"></div>
									
									
									<div class="row mt-5">
										<div class="mt-1 mb-3 container">
											<div class="table-responsive text-nowrap">
												<table id="example2" class="table table-hover">
													<thead id='geo_head'>
														<tr class="text-nowrap text-dark">
															<th class="th-color">Country</th>
															<th class="th-color">Campaign</th>
															<th class="th-color">Impression</th>
															<th class="th-color">Clicks</th>
															<!-- <th class="th-color">Conversion</th> -->
															<th class="th-color">CTR %</th>
															<th class="th-color">ECPM</th>
															<th class="th-color">Spend</th>
														</tr>
													</thead>
													<tbody id='geo_table'></tbody>
												</table>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!-- / Content -->
					
					<!-- Footer -->
					<?php include('footer.php'); ?>
					<!-- / Footer -->
					<!--<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>-->
					<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
					<script type="text/javascript"
                    src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
					<script>
						var live_URL = 'http://3.6.236.135/adservermod/api/revive_stat';
						var map_url = live_URL + '/get_georeport_map_statistics/';
						var domain_url = live_URL + '/get_georeport_statistics/';
						var client_id = document.getElementById('clientid').value;
						var token = 'Bearer ' + document.getElementById('token').value;
						// var getBanData = "";
						
						function onChangeDetails() {
							const date = new Date();
							var countryValue = document.getElementById('getZone').value;
							var filtervalue = document.getElementById('getDuration').value;
							console.log("day value", filtervalue);
							let client_id = document.getElementById('clientid').value;
							var getBanData = "";
							
							
							// console.log("zone value:", countryValue, "Duration value:", filtervalue);
							
                            if(filtervalue == 'Today') {
                                $("#daterange").css("display", "none");
                                let v3 = JSON.stringify(date);
                                v3 = v3.slice(1, 11);
                                var start_date = v3, end_date = v3;
                                getMapDate(start_date, end_date);
								
							}
                            else if(filtervalue == 'Yesterday'){
                                $("#daterange").css("display", "none");
                                let current_date = date.setDate(date.getDate() - 1);
                                const get_date = new Date(date);
                                let yesterday_date = JSON.stringify(get_date);
                                yesterday_date = yesterday_date.slice(1, 11);
                                var start_date = yesterday_date, end_date = yesterday_date;
                                getMapDate(start_date, end_date)
							}
                            else if(filtervalue == 'Last 7 days'){
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 7);
                                let get_date = new Date(date_start);
                                let first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);
								
                                let current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                getMapDate(first_day, date_end)
							}
                            else if(filtervalue == 'Last 30 days'){
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 30);
                                let get_date = new Date(date_start);
                                var first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);
								
                                const current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                getMapDate(first_day, date_end);
							}
                            else if (filtervalue == 'This Month') {
                                $("#daterange").css("display", "none");
                                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                let cDate = firstDay.getDate(), cMonth = firstDay.getMonth() + 1, cYear = firstDay.getFullYear();
                                let first_day = cYear + "-" + cMonth + "-" + cDate;
								
                                const current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                getMapDate(first_day, date_end);
							}
                            else if (filtervalue == 'Last Month') {
                                $("#daterange").css("display", "none");
                                var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                var formatDateComponent = function (dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
								}
                                var formatDate = function (date) {
                                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
								};
                                // var start_date = formatDate(prevMonthFirstDate), end_date = formatDate(prevMonthLastDate);
                                getMapDate(formatDate(prevMonthFirstDate), formatDate(prevMonthLastDate));
							}
                            else if (filtervalue == 'All Statistics') {
                                $("#daterange").css("display", "none");
                                $.ajax({
                                    url: live_URL + '/get_all_georeport_map_statistics/' + client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
									},
                                    data: {},
                                    success: function (data) {
                                        // console.log("data", data);
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available') {
										let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
										document.getElementById('ban_table').innerHTML = stat_msg;
                                        }
                                        else {
										(async () => {
										const topology = await fetch(
										'https://code.highcharts.com/mapdata/custom/world.topo.json'
										).then(response => response.json()
										// console.log("res value", response)
										);
										
										// Initialize the chart
										Highcharts.mapChart('container1', {
										
										chart: {
										map: topology
										},
										
										title: {
										text: 'Geo Map'
										},
										
										mapNavigation: {
										enabled: true,
										buttonOptions: {
										verticalAlign: 'bottom'
										}
										},
										
										tooltip: {
										backgroundColor: 'none',
										borderWidth: 0,
										shadow: false,
										useHTML: true,
										padding: 0,
										pointFormat: '<span class="f32"><span class="flag {point.properties.hc-key}">' +
										'</span></span> <span style="font-size:18px">{point.country}</span><br>' +
										'<span style="font-size:18px; color:blue">Impression: {point.impressions}</span><br>'+
										'<span style="font-size:18px; color:blue">Click: {point.clicks}</span>',
										positioner: function () {
										return { x: 0, y: 250 };
										}
										},
										
										colorAxis: {
										min: 1,
										max: 1000,
										type: 'logarithmic'
										},
										
										series: [{
										data: data,
										joinBy: ['iso-a2', 'countrycode'],
										name: 'Geo Data',
										states: {
										hover: {
										color: '#a4edba'
										}
										}
										}]
										});
										
										})();
                                        }
										},
										error: function () { },
								});
							}
							else if (filtervalue == 'Custom') {
								$(".loader").hide();
								$("#daterange").css("display", "block");
								$(document).on('change', '#daterange', function () {
										var dates = $('#daterange').val();
										const daterange = dates.split("-");
								});
								$(function () {
										$('input[name="daterange"]').daterangepicker({
                                        opens: 'left'
										}, function (start, end, label) {
                                        // console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
                                        // var start_date = start.format('YYYY-MM-DD'), end_date = end.format('YYYY-MM-DD');
                                        getMapDate(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
									});
								})
							}
						};
										
									function getMapDate(startDate, endDate) {
										var countryValue = document.getElementById('getZone').value;

										console.log("start date", startDate, "end date", endDate);
										$.ajax({
										   url: map_url+ startDate + ' 00:00:00,' + endDate + ' 12:00:00,' + client_id,
										   type: 'GET',
										   beforeSend: function (xhr) {
                                                xhr.setRequestHeader('Authorization', token);
										    },
										    data: {},
										    success: function (data) {
                                                console.log("map value....", data);
												if(data.msg == 'No Stats Available'){
													(async () => {
										     
										     const topology = await fetch(
										     'https://code.highcharts.com/mapdata/custom/world.topo.json'
										     ).then(response => response.json()
										     // console.log("res value", response)
										     );
										     
										     // Initialize the chart
										     Highcharts.mapChart('container1', {
										     
										     chart: {
										     map: topology
										     },
										     
										     title: {
										     text: 'Geo Map'
										     },
										     
										     mapNavigation: {
										     enabled: true,
										     buttonOptions: {
										     verticalAlign: 'bottom'
										     }
										     },
										     
										     tooltip: {
										     backgroundColor: 'none',
										     borderWidth: 0,
										     shadow: false,
										     useHTML: true,
										     padding: 0,
										     pointFormat: '<span class="f32"><span class="flag {point.properties.hc-key}">' +
										     '</span></span> <span style="font-size:18px">{point.country}</span><br>' +
										     '<span style="font-size:18px; color:blue">Impression: {point.impressions}</span><br>'+
										     '<span style="font-size:18px; color:blue">Click: {point.clicks}</span>',
										     positioner: function () {
										     return { x: 0, y: 250 };
										     }
										     },
										
										    colorAxis: {
										    min: 1,
										    max: 1000,
										    type: 'logarithmic'
										    },
										    
										    series: [{
										    data: [],
										    joinBy: ['iso-a2', 'countrycode'],
										    name: 'Geo Data',
										    states: {
										    hover: {
										    color: '#a4edba'
										    }
										    }
										    }],
											credits: false
										    });
										    // });
										    
										    })();
												}
												else {
													(async () => {
										     
										     const topology = await fetch(
										     'https://code.highcharts.com/mapdata/custom/world.topo.json'
										     ).then(response => response.json()
										     // console.log("res value", response)
										     );
										     
										     // Initialize the chart
										     Highcharts.mapChart('container1', {
										     
										     chart: {
										     map: topology
										     },
										     
										     title: {
										     text: 'Geo Map'
										     },
										     
										     mapNavigation: {
										     enabled: true,
										     buttonOptions: {
										     verticalAlign: 'bottom'
										     }
										     },
										     
										     tooltip: {
										     backgroundColor: 'none',
										     borderWidth: 0,
										     shadow: false,
										     useHTML: true,
										     padding: 0,
										     pointFormat: '<span class="f32"><span class="flag {point.properties.hc-key}">' +
										     '</span></span> <span style="font-size:18px">{point.country}</span><br>' +
										     '<span style="font-size:18px; color:blue">Impression: {point.impressions}</span><br>'+
										     '<span style="font-size:18px; color:blue">Click: {point.clicks}</span>',
										     positioner: function () {
										     return { x: 0, y: 250 };
										     }
										     },
										
										    colorAxis: {
										    min: 1,
										    max: 1000,
										    type: 'logarithmic'
										    },
										    
										    series: [{
										    data: data,
										    joinBy: ['iso-a2', 'countrycode'],
										    name: 'Geo Data',
										    states: {
										    hover: {
										    color: '#a4edba'
										    }
										    }
										    }],
											credits: false
										    });
										    // });
										    
										    })();
												}
										    },
										    error: function () { },
										});

										//Geo Report Table Date Start
										$.ajax({
                                            url: domain_url + startDate + ' 00:00:00,' + endDate + ' 12:00:00,'+client_id,
                                            type: 'GET',
                                            beforeSend: function (xhr){
                                                xhr.setRequestHeader('Authorization', token);
                                            },
                                            data: {},
                                            success: function (data) {
												console.log("map table data", data);
                                            if (data.msg == 'No Stats Available') {
                                            let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`;
                                            document.getElementById('geo_table').innerHTML = stat_msg;
                                            }
                                            else {
												var getBanData ='';
                                                if (countryValue == 'country' || countryValue == '') {
                                                        var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                        document.getElementById('geo_head').innerHTML = getGeoDataHead;
                                                        data.map((data) => {
                                                            getBanData += `<tr class="text-dark">
                                                                <td class="text-start">${data.country}</td>
                                                                <td class="text-start">${data.campaignname}</td>
                                                                <td class="text-center">${data.impressions}</td>
                                                                <td class="text-center">${data.clicks}</td>
                                                                <!--<td class="text-center">${data.conversions}</td>-->
                                                                <td class="text-center">${data.ctr} %</td>
                                                                <td class="text-center">${data.total_revenue}</td>
                                                                <td class="text-center">${data.ecpm}</td>
                                                           </tr>`
                                                        });
                                                        document.getElementById('geo_table').innerHTML = getBanData;
												        $('#georep').DataTable({
													        "ordering": true,
													        "destroy": true,
													        data: data,
													        columns: [
													        	{ data: 'country' },
													        	{ data: 'campaignname' },
													        	{ data: 'impressions' },
													        	{ data: 'clicks' },
													        	{ data: 'ctr' },
													        	{ data: 'total_revenue' },
													        	{ data: 'ecpm' },
													        	
													        ],
													    });
                                                   }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'region' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }

                                        }                                
                                    }
                                });
										//Geo Report Table Date End 
									};
										
										
									</script>
									
									<div class="content-backdrop fade"></div>
								</div>
								<!-- Content wrapper -->
							</div>
							<!-- / Layout page -->
						</div>
						
						<!-- Overlay -->
						<div class="layout-overlay layout-menu-toggle"></div>
					</div>
				</body>
				
			</html>			