<?php 
	include('session.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Adserver - GEO | Report </title>

    <meta name="description" content="" />
    <style>
        .text-hide {
            display: block;
            width: 125px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: inherit;
            width: auto;
        }
        h5 {
            position: relative;
            left: 250%;
        }
    </style>

    <style>
        .svgMap-map-wrapper {
            background: #fff !important;
        }
        .svgMap-country {
            stroke: #8592a3 !important;
            stroke-width: 1 !important;
        }
        .svgMapToday-map-country-IN {
            fill:#8080FF !important;
        }
    </style>

    <?php include('head.php'); ?>

    <!--<link href="https://code.jquery.com/ui/1.10.4/themes/ui-lightness/jquery-ui.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-1.12.4.min.js"></script>
    <script src="https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>-->

    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <link href="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.css" rel="stylesheet">
</head>


<body onload="onChangeDetails()">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3">
                            <div class="card-body">
                                <div class='row'>
                                    <div class='col-6'>
                                        <h4 class="mb-4">Geo Report</h4>
                                    </div>
                                    <div class="col-3">
                                        <select id='getZone' class="form-select" aria-label="Default select example"
                                            onchange="onChangeDetails()">
                                            <option value="" >Select Geo Type</option>
                                            <option value="country" selected>Country</option>
                                            <option value="region">Region</option>
                                            <option value="city">City</option>
                                        </select>
                                    </div>
                                    <div class='col-3'>
                                        <select id='getDuration' name="allfilter" class="form-select"
                                            aria-label="Default select example" onchange="onChangeDetails()">
                                            <option value="Today" selected>Today</option>
                                            <option value="Yesterday">Yesterday</option>
                                            <option value="Last 7 days">Last 7 days</option>
                                            <option value="Last 30 days">Last 30 days</option>
                                            <option value="This Month">This Month</option>
                                            <option value="Last Month">Last Month</option>
                                            <option value='all statistics'>All Statistics</option>
                                            <option value="custom">Custom</option>
                                        </select>
                                        <input style="display: none;" id="daterange" name="daterange"
                                            value="03/01/2023 - 03/15/2023" />
                                    </div>
                                </div>
                                <br />

                                <div class="row">
                                    <div id="svgMapSelectDuration"></div>
                                    <div id="svgMapToday"></div>
                                    <div id="svgMapYesterday"></div>
                                    <div id="svgMapLastsevendays"></div>
                                    <div id="svgMapLastthirtydays"></div>
                                    <div id="svgMapThismonth"></div>
                                    <div id="svgMapLastmonth"></div>
                                    <div id="svgMapAllstatistics"></div> 
                                    <div id="svgMapCustom"></div> 
                                </div>


                                <div class="row mt-5">
                                    <div class="mt-1 mb-3 container">
                                        <div class="table-responsive text-nowrap">
                                            <table id="georep" class="table table-hover">
                                                <thead id='geo_head'>
                                                    <tr class="text-nowrap text-dark">
                                                        <th class="th-color">Country</th>
                                                        <th class="th-color">Campaign</th>
                                                        <th class="th-color">Impression</th>
                                                        <th class="th-color">Clicks</th>
                                                        <!-- <th class="th-color">Conversion</th> -->
                                                        <th class="th-color">CTR %</th>
                                                        <th class="th-color">ECPM</th>
                                                        <th class="th-color">Spend</th>
                                                    </tr>
                                                </thead>
                                                <tbody id='geo_table'></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- / Content -->

                <!-- Footer -->
                <?php include('footer.php'); ?>
                <!-- / Footer -->
                <!--<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>-->
				<script src="https://cdn.jsdelivr.net/npm/svg-pan-zoom@3.6.1/dist/svg-pan-zoom.min.js"></script>
                <script src="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.js"></script>
                <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
                <script type="text/javascript"
                    src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
                <script>

                    var live_URL = 'http://43.204.47.201/adservermod/api/revive_stat';
                    var domain_url = live_URL+'/get_georeport_map_statistics/';
					var token = 'Bearer '+ document.getElementById('token').value;
                
                    function onChangeDetails() {
                        const date = new Date();
                        var getBanData = "";
                        var countryValue = document.getElementById('getZone').value;
                        var filtervalue = document.getElementById('getDuration').value;
                        let client_id = document.getElementById('clientid').value;
                        // document.getElementById('svgMapYesterday').style.display='none';
                        
                       if(filtervalue == 'Today') {
                        $("#daterange").css("display", "none");
                                              
                                let v3 = JSON.stringify(date);
                                v3 = v3.slice(1, 11);
                                var start_date = v3, end_date = v3; 
                            
                                $.ajax({
                                    url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,'+client_id,
                                    type: 'GET',

                                    beforeSend: function (xhr){
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {  
                                        var removeSelectduration = document.getElementById("svgMapSelectDuration");

                                        removeSelectduration.remove();

                                        if (data.msg == 'No Stats Available') {
                                            let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`;
                                            document.getElementById('geo_table').innerHTML = stat_msg;
                                         

                                            //map
                                            new svgMap({                        
                                                targetElementID: 'svgMapToday',
                                                colorMin: '#03a9f4',
                                                colorMax: '#03a9f4',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:{} 
                                                }
                                            });
                                          
                                        }
                                        else 
                                        {                                           
                                       
                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                return c.countrycode
                                            })                                  

                                            console.log("countrycode",countrycode);                                        

                                            var IN = countrycode.includes("IN") ? IN = "IN" : ""

                                            //clicks
                                            
                                            var clicks = data.map((c)=>{
                                                return c.clicks
                                            })  
                                            console.log("clicks",clicks)


                                            //impressions

                                            var impressions = data.map((c)=>{
                                                return c.impressions
                                            })  
                                            console.log("impressions",impressions);
                                            
                                            var clicksIN=0,imprssionsIN=0;

                                            for(let i=0;i<data.length;i++){
                                                if(countrycode[i] == "AF") {                                                   
                                                    clicksAF = clicks[i];
                                                    imprssionsAF = impressions[i];
                                                } if(countrycode[i] == "AL"){
                                                    clicksAL = clicks[i];
                                                    imprssionsAL = impressions[i];
                                                } if(countrycode[i] == "DZ"){
                                                    clicksDZ = clicks[i];
                                                    imprssionsDZ = impressions[i];
                                                } if(countrycode[i] == "AS"){
                                                    clicksAS = clicks[i];
                                                    imprssionsAS = impressions[i];
                                                } if(countrycode[i] == "AD"){
                                                    clicksAD = clicks[i];
                                                    imprssionsAD = impressions[i];
                                                } if(countrycode[i] == "AO"){
                                                    clicksAO = clicks[i];
                                                    imprssionsAO = impressions[i];
                                                } if(countrycode[i] == "AI"){
                                                    clicksAI = clicks[i];
                                                    imprssionsAI = impressions[i];
                                                } if(countrycode[i] == "AQ"){
                                                    clicksAQ = clicks[i];
                                                    imprssionsAQ = impressions[i];
                                                } if(countrycode[i] == "AG"){
                                                    clicksAG = clicks[i];
                                                    imprssionsAG = impressions[i];
                                                } if(countrycode[i] == "AR"){
                                                    clicksAR = clicks[i];
                                                    imprssionsAR = impressions[i];
                                                } if(countrycode[i] == "AM"){
                                                    clicksAM = clicks[i];
                                                    imprssionsAM = impressions[i];
                                                } if(countrycode[i] == "AW"){
                                                    clicksAW = clicks[i];
                                                    imprssionsAW = impressions[i];
                                                } if(countrycode[i] == "AU"){
                                                    clicksAU = clicks[i];
                                                    imprssionsAU = impressions[i];
                                                } if(countrycode[i] == "AT"){
                                                    clicksAT = clicks[i];
                                                    imprssionsAT = impressions[i];
                                                } if(countrycode[i] == "AZ"){
                                                    clicksAZ = clicks[i];
                                                    imprssionsAZ = impressions[i];
                                                } if(countrycode[i] == "BS"){
                                                    clicksBS = clicks[i];
                                                    imprssionsBS = impressions[i];
                                                } if(countrycode[i] == "BH"){
                                                    clicksBH = clicks[i];
                                                    imprssionsBH = impressions[i];
                                                } if(countrycode[i] == "BD"){
                                                    clicksBD = clicks[i];
                                                    imprssionsBD = impressions[i];
                                                } if(countrycode[i] == "BB"){
                                                    clicksBB = clicks[i];
                                                    imprssionsBB = impressions[i];
                                                } if(countrycode[i] == "BY"){
                                                    clicksBY = clicks[i];
                                                    imprssionsBY = impressions[i];
                                                } if(countrycode[i] == "BW"){
                                                    clicksBW = clicks[i];
                                                    imprssionsBW = impressions[i];
                                                } if(countrycode[i] == "BV"){
                                                    clicksBV = clicks[i];
                                                    imprssionsBV = impressions[i];
                                                } if(countrycode[i] == "BR"){
                                                    clicksBR = clicks[i];
                                                    imprssionsBR = impressions[i];
                                                } if(countrycode[i] == "BQ"){
                                                    clicksBQ = clicks[i];
                                                    imprssionsBQ = impressions[i];
                                                } if(countrycode[i] == "IO"){
                                                    clicksIO = clicks[i];
                                                    imprssionsIO = impressions[i];
                                                } if(countrycode[i] == "CM"){
                                                    clicksCM = clicks[i];
                                                    imprssionsCM = impressions[i];
                                                } if(countrycode[i] == "CA"){
                                                    clicksCA = clicks[i];
                                                    imprssionsCA = impressions[i];
                                                } if(countrycode[i] == "CT"){
                                                    clicksCT = clicks[i];
                                                    imprssionsCT = impressions[i];
                                                } if(countrycode[i] == "CV"){
                                                    clicksCV = clicks[i];
                                                    imprssionsCV = impressions[i];
                                                } if(countrycode[i] == "KY"){
                                                    clicksKY = clicks[i];
                                                    imprssionsKY = impressions[i];
                                                } if(countrycode[i] == "CF"){
                                                    clicksCF = clicks[i];
                                                    imprssionsCF = impressions[i];
                                                } if(countrycode[i] == "KM"){
                                                    clicksKM = clicks[i];
                                                    imprssionsKM = impressions[i];
                                                } if(countrycode[i] == "CG"){
                                                    clicksCG = clicks[i];
                                                    imprssionsCG = impressions[i];
                                                } if(countrycode[i] == "CD"){
                                                    clicksCD = clicks[i];
                                                    imprssionsCD = impressions[i];
                                                } if(countrycode[i] == "CK"){
                                                    clicksCK = clicks[i];
                                                    imprssionsCK = impressions[i];
                                                } if(countrycode[i] == "CR"){
                                                    clicksCR = clicks[i];
                                                    imprssionsCR = impressions[i];
                                                } if(countrycode[i] == "HR"){
                                                    clicksHR = clicks[i];
                                                    imprssionsHR = impressions[i];
                                                } if(countrycode[i] == "CU"){
                                                    clicksCU = clicks[i];
                                                    imprssionsCU = impressions[i];
                                                } if(countrycode[i] == "CY"){
                                                    clicksCY = clicks[i];
                                                    imprssionsCY = impressions[i];
                                                } if(countrycode[i] == "CZ"){
                                                    clicksCZ = clicks[i];
                                                    imprssionsCZ = impressions[i];
                                                } if(countrycode[i] == "CI"){
                                                    clicksCI = clicks[i];
                                                    imprssionsCI = impressions[i];
                                                } if(countrycode[i] == "DK"){
                                                    clicksDK = clicks[i];
                                                    imprssionsDK = impressions[i];
                                                } if(countrycode[i] == "DJ"){
                                                    clicksDJ = clicks[i];
                                                    imprssionsDJ = impressions[i];
                                                } if(countrycode[i] == "DM"){
                                                    clicksDM = clicks[i];
                                                    imprssionsDM = impressions[i];
                                                } if(countrycode[i] == "DO"){
                                                    clicksDO = clicks[i];
                                                    imprssionsDO = impressions[i];
                                                } if(countrycode[i] == "NQ"){
                                                    clicksNQ = clicks[i];
                                                    imprssionsNQ = impressions[i];
                                                } if(countrycode[i] == "DD"){
                                                    clicksDD = clicks[i];
                                                    imprssionsDD = impressions[i];
                                                } if(countrycode[i] == "EC"){
                                                    clicksEC = clicks[i];
                                                    imprssionsEC = impressions[i];
                                                } if(countrycode[i] == "EG"){
                                                    clicksEG = clicks[i];
                                                    imprssionsEG = impressions[i];
                                                } if(countrycode[i] == "SV"){
                                                    clicksSV = clicks[i];
                                                    imprssionsSV = impressions[i];
                                                } if(countrycode[i] == "GQ"){
                                                    clicksGQ = clicks[i];
                                                    imprssionsGQ = impressions[i];
                                                } if(countrycode[i] == "ER"){
                                                    clicksER = clicks[i];
                                                    imprssionsER = impressions[i];
                                                } if(countrycode[i] == "EE"){
                                                    clicksEE = clicks[i];
                                                    imprssionsEE = impressions[i];
                                                } if(countrycode[i] == "ET"){
                                                    clicksET = clicks[i];
                                                    imprssionsET = impressions[i];
                                                } if(countrycode[i] == "FK"){
                                                    clicksFK = clicks[i];
                                                    imprssionsFK = impressions[i];
                                                } if(countrycode[i] == "FO"){
                                                    clicksFO = clicks[i];
                                                    imprssionsFO = impressions[i];
                                                } if(countrycode[i] == "FJ"){
                                                    clicksFJ = clicks[i];
                                                    imprssionsFJ = impressions[i];
                                                } if(countrycode[i] == "FI"){
                                                    clicksFI = clicks[i];
                                                    imprssionsFI = impressions[i];
                                                } if(countrycode[i] == "FR"){
                                                    clicksFR = clicks[i];
                                                    imprssionsFR = impressions[i];
                                                } if(countrycode[i] == "GF"){
                                                    clicksGF = clicks[i];
                                                    imprssionsGF = impressions[i];
                                                } if(countrycode[i] == "PF"){
                                                    clicksPF = clicks[i];
                                                    imprssionsPF = impressions[i];
                                                } if(countrycode[i] == "TF"){
                                                    clicksTF = clicks[i];
                                                    imprssionsTF = impressions[i];
                                                } if(countrycode[i] == "FQ"){
                                                    clicksFQ = clicks[i];
                                                    imprssionsFQ = impressions[i];
                                                } if(countrycode[i] == "GA"){
                                                    clicksGA = clicks[i];
                                                    imprssionsGA = impressions[i];
                                                } if(countrycode[i] == "GM"){
                                                    clicksGM = clicks[i];
                                                    imprssionsGM = impressions[i];
                                                } if(countrycode[i] == "GE"){
                                                    clicksGE = clicks[i];
                                                    imprssionsGE = impressions[i];
                                                } if(countrycode[i] == "DE"){
                                                    clicksDE = clicks[i];
                                                    imprssionsDE = impressions[i];
                                                } if(countrycode[i] == "GH"){
                                                    clicksGH = clicks[i];
                                                    imprssionsGH = impressions[i];
                                                } if(countrycode[i] == "GI"){
                                                    clicksGI = clicks[i];
                                                    imprssionsGI = impressions[i];
                                                } if(countrycode[i] == "GR"){
                                                    clicksGR = clicks[i];
                                                    imprssionsGR = impressions[i];
                                                } if(countrycode[i] == "GL"){
                                                    clicksGL = clicks[i];
                                                    imprssionsGL = impressions[i];
                                                } if(countrycode[i] == "GD"){
                                                    clicksGD = clicks[i];
                                                    imprssionsGD = impressions[i];
                                                } if(countrycode[i] == "GP"){
                                                    clicksGP = clicks[i];
                                                    imprssionsGP = impressions[i];
                                                } if(countrycode[i] == "GU"){
                                                    clicksGU = clicks[i];
                                                    imprssionsGU = impressions[i];
                                                } if(countrycode[i] == "GT"){
                                                    clicksGT = clicks[i];
                                                    imprssionsGT = impressions[i];
                                                } if(countrycode[i] == "GG"){
                                                    clicksGG = clicks[i];
                                                    imprssionsGG = impressions[i];
                                                } if(countrycode[i] == "GN"){
                                                    clicksGN = clicks[i];
                                                    imprssionsGN = impressions[i];
                                                } if(countrycode[i] == "GW"){
                                                    clicksGW = clicks[i];
                                                    imprssionsGW = impressions[i];
                                                } if(countrycode[i] == "GY"){
                                                    clicksGY = clicks[i];
                                                    imprssionsGY = impressions[i];
                                                } if(countrycode[i] == "HT"){
                                                    clicksHT = clicks[i];
                                                    imprssionsHT = impressions[i];
                                                } if(countrycode[i] == "HM"){
                                                    clicksHM = clicks[i];
                                                    imprssionsHM = impressions[i];
                                                } if(countrycode[i] == "HN"){
                                                    clicksHN = clicks[i];
                                                    imprssionsHN = impressions[i];
                                                } if(countrycode[i] == "HK"){
                                                    clicksHK = clicks[i];
                                                    imprssionsHK = impressions[i];
                                                } if(countrycode[i] == "HU"){
                                                    clicksHU = clicks[i];
                                                    imprssionsHU = impressions[i];
                                                } if(countrycode[i] == "IS"){
                                                    clicksIS = clicks[i];
                                                    imprssionsIS = impressions[i];
                                                } if(countrycode[i] == "IN"){
                                                    clicksIN = clicks[i];
                                                    imprssionsIN = impressions[i];
                                                } if(countrycode[i] == "ID"){
                                                    clicksID = clicks[i];
                                                    imprssionsID = impressions[i];
                                                } if(countrycode[i] == "IR"){
                                                    clicksIR = clicks[i];
                                                    imprssionsIR = impressions[i];
                                                } if(countrycode[i] == "IQ"){
                                                    clicksIQ = clicks[i];
                                                    imprssionsIQ = impressions[i];
                                                } if(countrycode[i] == "IE"){
                                                    clicksIE = clicks[i];
                                                    imprssionsIE = impressions[i];
                                                } if(countrycode[i] == "IM"){
                                                    clicksIM = clicks[i];
                                                    imprssionsIM = impressions[i];
                                                } if(countrycode[i] == "IL"){
                                                    clicksIL = clicks[i];
                                                    imprssionsIL = impressions[i];
                                                } if(countrycode[i] == "IT"){
                                                    clicksIT = clicks[i];
                                                    imprssionsIT = impressions[i];
                                                } if(countrycode[i] == "JM"){
                                                    clicksJM = clicks[i];
                                                    imprssionsJM = impressions[i];
                                                } if(countrycode[i] == "JP"){
                                                    clicksJP = clicks[i];
                                                    imprssionsJP = impressions[i];
                                                } if(countrycode[i] == "JE"){
                                                    clicksJE = clicks[i];
                                                    imprssionsJE = impressions[i];
                                                } if(countrycode[i] == "JT"){
                                                    clicksJT = clicks[i];
                                                    imprssionsJT = impressions[i];
                                                } if(countrycode[i] == "JO"){
                                                    clicksJO = clicks[i];
                                                    imprssionsJO = impressions[i];
                                                } if(countrycode[i] == "KZ"){
                                                    clicksKZ = clicks[i];
                                                    imprssionsKZ = impressions[i];
                                                } if(countrycode[i] == "KE"){
                                                    clicksKE = clicks[i];
                                                    imprssionsKE = impressions[i];
                                                } if(countrycode[i] == "KI"){
                                                    clicksKI = clicks[i];
                                                    imprssionsKI = impressions[i];
                                                } if(countrycode[i] == "KW"){
                                                    clicksKW = clicks[i];
                                                    imprssionsKW = impressions[i];
                                                } if(countrycode[i] == "KG"){
                                                    clicksKG = clicks[i];
                                                    imprssionsKG = impressions[i];
                                                } if(countrycode[i] == "LA"){
                                                    clicksLA = clicks[i];
                                                    imprssionsLA = impressions[i];
                                                } if(countrycode[i] == "LV"){
                                                    clicksLV = clicks[i];
                                                    imprssionsLV = impressions[i];
                                                } if(countrycode[i] == "LB"){
                                                    clicksLB = clicks[i];
                                                    imprssionsLB = impressions[i];
                                                } if(countrycode[i] == "LS"){
                                                    clicksLS = clicks[i];
                                                    imprssionsLS = impressions[i];
                                                } if(countrycode[i] == "LR"){
                                                    clicksLR = clicks[i];
                                                    imprssionsLR = impressions[i];
                                                } if(countrycode[i] == "LY"){
                                                    clicksLY = clicks[i];
                                                    imprssionsLY = impressions[i];
                                                } if(countrycode[i] == "LI"){
                                                    clicksLI = clicks[i];
                                                    imprssionsLI = impressions[i];
                                                } if(countrycode[i] == "LT"){
                                                    clicksLT = clicks[i];
                                                    imprssionsLT = impressions[i];
                                                } if(countrycode[i] == "LU"){
                                                    clicksLU = clicks[i];
                                                    imprssionsLU = impressions[i];
                                                } if(countrycode[i] == "MO"){
                                                    clicksMO = clicks[i];
                                                    imprssionsMO = impressions[i];
                                                } if(countrycode[i] == "MK"){
                                                    clicksMK = clicks[i];
                                                    imprssionsMK = impressions[i];
                                                } if(countrycode[i] == "MG"){
                                                    clicksMG = clicks[i];
                                                    imprssionsMG = impressions[i];
                                                } if(countrycode[i] == "MW"){
                                                    clicksMW = clicks[i];
                                                    imprssionsMW = impressions[i];
                                                } if(countrycode[i] == "MY"){
                                                    clicksMY = clicks[i];
                                                    imprssionsMY = impressions[i];
                                                } if(countrycode[i] == "MV"){
                                                    clicksMV = clicks[i];
                                                    imprssionsMV = impressions[i];
                                                } if(countrycode[i] == "ML"){
                                                    clicksML = clicks[i];
                                                    imprssionsML = impressions[i];
                                                } if(countrycode[i] == "MT"){
                                                    clicksMT = clicks[i];
                                                    imprssionsMT = impressions[i];
                                                } if(countrycode[i] == "MH"){
                                                    clicksMH = clicks[i];
                                                    imprssionsMH = impressions[i];
                                                } if(countrycode[i] == "MQ"){
                                                    clicksMQ = clicks[i];
                                                    imprssionsMQ = impressions[i];
                                                } if(countrycode[i] == "MR"){
                                                    clicksMR = clicks[i];
                                                    imprssionsMR = impressions[i];
                                                } if(countrycode[i] == "MU"){
                                                    clicksMU = clicks[i];
                                                    imprssionsMU = impressions[i];
                                                } if(countrycode[i] == "YT"){
                                                    clicksYT = clicks[i];
                                                    imprssionsYT = impressions[i];
                                                } if(countrycode[i] == "FX"){
                                                    clicksFX = clicks[i];
                                                    imprssionsFX = impressions[i];
                                                } if(countrycode[i] == "MX"){
                                                    clicksMX = clicks[i];
                                                    imprssionsMX = impressions[i];
                                                } if(countrycode[i] == "FM"){
                                                    clicksFM = clicks[i];
                                                    imprssionsFM = impressions[i];
                                                } if(countrycode[i] == "MI"){
                                                    clicksMI = clicks[i];
                                                    imprssionsMI = impressions[i];
                                                } if(countrycode[i] == "MD"){
                                                    clicksMD = clicks[i];
                                                    imprssionsMD = impressions[i];
                                                } if(countrycode[i] == "MC"){
                                                    clicksMC = clicks[i];
                                                    imprssionsMC = impressions[i];
                                                } if(countrycode[i] == "MN"){
                                                    clicksMN = clicks[i];
                                                    imprssionsMN = impressions[i];
                                                } if(countrycode[i] == "ME"){
                                                    clicksME = clicks[i];
                                                    imprssionsME = impressions[i];
                                                } if(countrycode[i] == "MS"){
                                                    clicksMS = clicks[i];
                                                    imprssionsMS = impressions[i];
                                                } if(countrycode[i] == "MA"){
                                                    clicksMA = clicks[i];
                                                    imprssionsMA = impressions[i];
                                                } if(countrycode[i] == "MZ"){
                                                    clicksMZ = clicks[i];
                                                    imprssionsMZ = impressions[i];
                                                } if(countrycode[i] == "MM"){
                                                    clicksMM = clicks[i];
                                                    imprssionsMM = impressions[i];
                                                } if(countrycode[i] == "NA"){
                                                    clicksNA = clicks[i];
                                                    imprssionsNA = impressions[i];
                                                } if(countrycode[i] == "NR"){
                                                    clicksNR = clicks[i];
                                                    imprssionsNR = impressions[i];
                                                } if(countrycode[i] == "NP"){
                                                    clicksNP = clicks[i];
                                                    imprssionsNP = impressions[i];
                                                } if(countrycode[i] == "NL"){
                                                    clicksNL = clicks[i];
                                                    imprssionsNL = impressions[i];
                                                } if(countrycode[i] == "AN"){
                                                    clicksAN = clicks[i];
                                                    imprssionsAN = impressions[i];
                                                } if(countrycode[i] == "NT"){
                                                    clicksNT = clicks[i];
                                                    imprssionsNT = impressions[i];
                                                } if(countrycode[i] == "NC"){
                                                    clicksNC = clicks[i];
                                                    imprssionsNC = impressions[i];
                                                } if(countrycode[i] == "NZ"){
                                                    clicksNZ = clicks[i];
                                                    imprssionsNZ = impressions[i];
                                                } if(countrycode[i] == "NI"){
                                                    clicksNI = clicks[i];
                                                    imprssionsNI = impressions[i];
                                                } if(countrycode[i] == "NE"){
                                                    clicksNE = clicks[i];
                                                    imprssionsNE = impressions[i];
                                                } if(countrycode[i] == "NG"){
                                                    clicksNG = clicks[i];
                                                    imprssionsNG = impressions[i];
                                                } if(countrycode[i] == "NU"){
                                                    clicksNU = clicks[i];
                                                    imprssionsNU = impressions[i];
                                                } if(countrycode[i] == "NF"){
                                                    clicksNF = clicks[i];
                                                    imprssionsNF = impressions[i];
                                                } if(countrycode[i] == "KP"){
                                                    clicksKP = clicks[i];
                                                    imprssionsKP = impressions[i];
                                                } if(countrycode[i] == "VD"){
                                                    clicksVD = clicks[i];
                                                    imprssionsVD = impressions[i];
                                                } if(countrycode[i] == "MP"){
                                                    clicksMP = clicks[i];
                                                    imprssionsMP = impressions[i];
                                                } if(countrycode[i] == "NO"){
                                                    clicksNO = clicks[i];
                                                    imprssionsNO = impressions[i];
                                                } if(countrycode[i] == "OM"){
                                                    clicksOM = clicks[i];
                                                    imprssionsOM = impressions[i];
                                                } if(countrycode[i] == "PC"){
                                                    clicksPC = clicks[i];
                                                    imprssionsPC = impressions[i];
                                                } if(countrycode[i] == "PK"){
                                                    clicksPK = clicks[i];
                                                    imprssionsPK = impressions[i];
                                                } if(countrycode[i] == "PW"){
                                                    clicksPW = clicks[i];
                                                    imprssionsPW = impressions[i];
                                                } if(countrycode[i] == "PS"){
                                                    clicksPS = clicks[i];
                                                    imprssionsPS = impressions[i];
                                                } if(countrycode[i] == "PA"){
                                                    clicksPA = clicks[i];
                                                    imprssionsPA = impressions[i];
                                                } if(countrycode[i] == "PZ"){
                                                    clicksPZ = clicks[i];
                                                    imprssionsPZ = impressions[i];
                                                } if(countrycode[i] == "PG"){
                                                    clicksPG = clicks[i];
                                                    imprssionsPG = impressions[i];
                                                } if(countrycode[i] == "PY"){
                                                    clicksPY = clicks[i];
                                                    imprssionsPY = impressions[i];
                                                } if(countrycode[i] == "YD"){
                                                    clicksYD = clicks[i];
                                                    imprssionsYD = impressions[i];
                                                } if(countrycode[i] == "PE"){
                                                    clicksPE = clicks[i];
                                                    imprssionsPE = impressions[i];
                                                } if(countrycode[i] == "PH"){
                                                    clicksPH = clicks[i];
                                                    imprssionsPH = impressions[i];
                                                } if(countrycode[i] == "PN"){
                                                    clicksPN = clicks[i];
                                                    imprssionsPN = impressions[i];
                                                } if(countrycode[i] == "PL"){
                                                    clicksPL = clicks[i];
                                                    imprssionsPL = impressions[i];
                                                } if(countrycode[i] == "PT"){
                                                    clicksPT = clicks[i];
                                                    imprssionsPT = impressions[i];
                                                } if(countrycode[i] == "PR"){
                                                    clicksPR = clicks[i];
                                                    imprssionsPR = impressions[i];
                                                } if(countrycode[i] == "QA"){
                                                    clicksQA = clicks[i];
                                                    imprssionsQA = impressions[i];
                                                } if(countrycode[i] == "RO"){
                                                    clicksRO = clicks[i];
                                                    imprssionsRO = impressions[i];
                                                } if(countrycode[i] == "RU"){
                                                    clicksRU = clicks[i];
                                                    imprssionsRU = impressions[i];
                                                } if(countrycode[i] == "RW"){
                                                    clicksRW = clicks[i];
                                                    imprssionsRW = impressions[i];
                                                } if(countrycode[i] == "RE"){
                                                    clicksRE = clicks[i];
                                                    imprssionsRE = impressions[i];
                                                } if(countrycode[i] == "BL"){
                                                    clicksBL = clicks[i];
                                                    imprssionsBL = impressions[i];
                                                } if(countrycode[i] == "SH"){
                                                    clicksSH = clicks[i];
                                                    imprssionsSH = impressions[i];
                                                } if(countrycode[i] == "KN"){
                                                    clicksKN = clicks[i];
                                                    imprssionsKN = impressions[i];
                                                } if(countrycode[i] == "LC"){
                                                    clicksLC = clicks[i];
                                                    imprssionsLC = impressions[i];
                                                } if(countrycode[i] == "MF"){
                                                    clicksMF = clicks[i];
                                                    imprssionsMF = impressions[i];
                                                } if(countrycode[i] == "PM"){
                                                    clicksPM = clicks[i];
                                                    imprssionsPM = impressions[i];
                                                } if(countrycode[i] == "VC"){
                                                    clicksVC = clicks[i];
                                                    imprssionsVC = impressions[i];
                                                } if(countrycode[i] == "WS"){
                                                    clicksWS = clicks[i];
                                                    imprssionsWS = impressions[i];
                                                } if(countrycode[i] == "SM"){
                                                    clicksSM = clicks[i];
                                                    imprssionsSM = impressions[i];
                                                } if(countrycode[i] == "SA"){
                                                    clicksSA = clicks[i];
                                                    imprssionsSA = impressions[i];
                                                } if(countrycode[i] == "SN"){
                                                    clicksSN = clicks[i];
                                                    imprssionsSN = impressions[i];
                                                } if(countrycode[i] == "RS"){
                                                    clicksRS = clicks[i];
                                                    imprssionsRS = impressions[i];
                                                } if(countrycode[i] == "CS"){
                                                    clicksCS = clicks[i];
                                                    imprssionsCS = impressions[i];
                                                } if(countrycode[i] == "SC"){
                                                    clicksSC = clicks[i];
                                                    imprssionsSC = impressions[i];
                                                } if(countrycode[i] == "SL"){
                                                    clicksSL = clicks[i];
                                                    imprssionsSL = impressions[i];
                                                } if(countrycode[i] == "SG"){
                                                    clicksSG = clicks[i];
                                                    imprssionsSG = impressions[i];
                                                } if(countrycode[i] == "SK"){
                                                    clicksSK = clicks[i];
                                                    imprssionsSK = impressions[i];
                                                } if(countrycode[i] == "SI"){
                                                    clicksSI = clicks[i];
                                                    imprssionsSI = impressions[i];
                                                } if(countrycode[i] == "SB"){
                                                    clicksSB = clicks[i];
                                                    imprssionsSB = impressions[i];
                                                } if(countrycode[i] == "ZA"){
                                                    clicksZA = clicks[i];
                                                    imprssionsZA = impressions[i];
                                                } if(countrycode[i] == "GS"){
                                                    clicksGS = clicks[i];
                                                    imprssionsGS = impressions[i];
                                                } if(countrycode[i] == "KR"){
                                                    clicksKR = clicks[i];
                                                    imprssionsKR = impressions[i];
                                                } if(countrycode[i] == "ES"){
                                                    clicksES = clicks[i];
                                                    imprssionsES = impressions[i];
                                                } if(countrycode[i] == "LK"){
                                                    clicksLK = clicks[i];
                                                    imprssionsLK = impressions[i];
                                                } if(countrycode[i] == "SD"){
                                                    clicksSD = clicks[i];
                                                    imprssionsSD = impressions[i];
                                                } if(countrycode[i] == "SR"){
                                                    clicksSR = clicks[i];
                                                    imprssionsSR = impressions[i];
                                                } if(countrycode[i] == "SJ"){
                                                    clicksSJ = clicks[i];
                                                    imprssionsSJ = impressions[i];
                                                } if(countrycode[i] == "SZ"){
                                                    clicksSZ = clicks[i];
                                                    imprssionsSZ = impressions[i];
                                                } if(countrycode[i] == "SE"){
                                                    clicksSE = clicks[i];
                                                    imprssionsSE = impressions[i];
                                                } if(countrycode[i] == "CH"){
                                                    clicksCH = clicks[i];
                                                    imprssionsCH = impressions[i];
                                                } if(countrycode[i] == "SY"){
                                                    clicksSY = clicks[i];
                                                    imprssionsSY = impressions[i];
                                                } if(countrycode[i] == "ST"){
                                                    clicksST = clicks[i];
                                                    imprssionsST = impressions[i];
                                                } if(countrycode[i] == "TW"){
                                                    clicksTW = clicks[i];
                                                    imprssionsTW = impressions[i];
                                                } if(countrycode[i] == "TJ"){
                                                    clicksTJ = clicks[i];
                                                    imprssionsTJ = impressions[i];
                                                } if(countrycode[i] == "TZ"){
                                                    clicksTZ = clicks[i];
                                                    imprssionsTZ = impressions[i];
                                                } if(countrycode[i] == "TH"){
                                                    clicksTH = clicks[i];
                                                    imprssionsTH = impressions[i];
                                                } if(countrycode[i] == "TL"){
                                                    clicksTL = clicks[i];
                                                    imprssionsTL = impressions[i];
                                                } if(countrycode[i] == "TG"){
                                                    clicksTG = clicks[i];
                                                    imprssionsTG = impressions[i];
                                                } if(countrycode[i] == "TK"){
                                                    clicksTK = clicks[i];
                                                    imprssionsTK = impressions[i];
                                                } if(countrycode[i] == "TO"){
                                                    clicksTO = clicks[i];
                                                    imprssionsTO = impressions[i];
                                                } if(countrycode[i] == "TT"){
                                                    clicksTT = clicks[i];
                                                    imprssionsTT = impressions[i];
                                                } if(countrycode[i] == "TN"){
                                                    clicksTN = clicks[i];
                                                    imprssionsTN = impressions[i];
                                                } if(countrycode[i] == "TR"){
                                                    clicksTR = clicks[i];
                                                    imprssionsTR = impressions[i];
                                                } if(countrycode[i] == "TM"){
                                                    clicksTM = clicks[i];
                                                    imprssionsTM = impressions[i];
                                                } if(countrycode[i] == "TC"){
                                                    clicksTC = clicks[i];
                                                    imprssionsTC = impressions[i];
                                                } if(countrycode[i] == "TV"){
                                                    clicksTV = clicks[i];
                                                    imprssionsTV = impressions[i];
                                                } if(countrycode[i] == "UM"){
                                                    clicksUM = clicks[i];
                                                    imprssionsUM = impressions[i];
                                                } if(countrycode[i] == "PU"){
                                                    clicksPU = clicks[i];
                                                    imprssionsPU = impressions[i];
                                                } if(countrycode[i] == "VI"){
                                                    clicksVI = clicks[i];
                                                    imprssionsVI = impressions[i];
                                                } if(countrycode[i] == "UG"){
                                                    clicksUG = clicks[i];
                                                    imprssionsUG = impressions[i];
                                                } if(countrycode[i] == "UA"){
                                                    clicksUA = clicks[i];
                                                    imprssionsUA = impressions[i];
                                                } if(countrycode[i] == "SU"){
                                                    clicksSU = clicks[i];
                                                    imprssionsSU = impressions[i];
                                                } if(countrycode[i] == "AE"){
                                                    clicksAE = clicks[i];
                                                    imprssionsAE = impressions[i];
                                                } if(countrycode[i] == "GB"){
                                                    clicksGB = clicks[i];
                                                    imprssionsGB = impressions[i];
                                                } if(countrycode[i] == "US"){
                                                    clicksUS = clicks[i];
                                                    imprssionsUS = impressions[i];
                                                } if(countrycode[i] == "ZZ"){
                                                    clicksZZ = clicks[i];
                                                    imprssionsZZ = impressions[i];
                                                } if(countrycode[i] == "UY"){
                                                    clicksUY = clicks[i];
                                                    imprssionsUY = impressions[i];
                                                } if(countrycode[i] == "UZ"){
                                                    clicksUZ = clicks[i];
                                                    imprssionsUZ = impressions[i];
                                                } if(countrycode[i] == "VU"){
                                                    clicksVU = clicks[i];
                                                    imprssionsVU = impressions[i];
                                                } if(countrycode[i] == "VA"){
                                                    clicksVA = clicks[i];
                                                    imprssionsVA = impressions[i];
                                                } if(countrycode[i] == "VE"){
                                                    clicksVE = clicks[i];
                                                    imprssionsVE = impressions[i];
                                                } if(countrycode[i] == "VN"){
                                                    clicksVN = clicks[i];
                                                    imprssionsVN = impressions[i];
                                                } if(countrycode[i] == "WK"){
                                                    clicksWK = clicks[i];
                                                    imprssionsWK = impressions[i];
                                                } if(countrycode[i] == "WF"){
                                                    clicksWF = clicks[i];
                                                    imprssionsWF = impressions[i];
                                                } if(countrycode[i] == "EH"){
                                                    clicksEH = clicks[i];
                                                    imprssionsEH = impressions[i];
                                                } if(countrycode[i] == "YE"){
                                                    clicksYE = clicks[i];
                                                    imprssionsYE = impressions[i];
                                                } if(countrycode[i] == "ZM"){
                                                    clicksZM = clicks[i];
                                                    imprssionsZM = impressions[i];
                                                } if(countrycode[i] == "ZW"){
                                                    clicksZW = clicks[i];
                                                    imprssionsZW = impressions[i];
                                                } if(countrycode[i] == "AX"){
                                                    clicksAX = clicks[i];
                                                    imprssionsAX = impressions[i];
                                                }
                                                
                                            }
                                            
                                            console.log("clicksIN",clicksIN);
                                            console.log("imprssionsIN",imprssionsIN);
                                                                                   
                                            //map

                                            new svgMap({                        
                                                    targetElementID: 'svgMapToday',
                                                    colorMin: '#03a9f4',
                                                    colorMax: '#03a9f4',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {    
                                                            IN : {                                              
                                                                clicks: clicksIN, 
                                                                impression: imprssionsIN
                                                            } 
                                                                                                                                 
                                                        } 
                                                    }
                                                });

                                            if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'region' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }

                                        }                                
                                    }
                                });
                            }
                            else if (filtervalue == 'Yesterday') {
                                $("#daterange").css("display", "none");
                                let current_date = date.setDate(date.getDate() - 1);
                                const get_date = new Date(date);
                                let yesterday_date = JSON.stringify(get_date);
                                yesterday_date = yesterday_date.slice(1, 11);
                                var start_date = yesterday_date, end_date = yesterday_date;

                                $.ajax(
                                {
                                    url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,'+client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {  
                                        var removeToday = document.getElementById("svgMapToday");
                                        removeToday.remove();

                                        if (data.msg == 'No Stats Available') {
                                            //map

                                            new svgMap({                        
                                                targetElementID: 'svgMapYesterday',
                                                colorMin: '#03a9f4',
                                                colorMax: '#03a9f4',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:
                                                    {                                               
                                                                                                   
                                                                                
                                                    } 
                                                }
                                            });
                                        }
                                        else 
                                        {
                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                return c.countrycode
                                            })                                  

                                            console.log("countrycode",countrycode);                                        

                                            var IN = countrycode.includes("IN") ? IN = "IN" : ""

                                            //clicks
                                            
                                            var clicks = data.map((c)=>{
                                                return c.clicks
                                            })  
                                            console.log("clicks",clicks)


                                            //impressions

                                            var impressions = data.map((c)=>{
                                                return c.impressions
                                            })  
                                            console.log("impressions",impressions);


                                            
                                            var clicksIN=0,imprssionsIN=0;

                                            for(let i=0;i<data.length;i++){
                                                if(countrycode[i] == "IN") {                                                   
                                                    clicksIN = clicks[i];
                                                    imprssionsIN = impressions[i];
                                                }else if(countrycode[i] == "AL"){
                                                    clicksAL = clicks[i];
                                                    imprssionsAL = impressions[i];
                                                }else {

                                                }
                                            }
                                            
                                            console.log("clicksIN",clicksIN);
                                            console.log("imprssionsIN",imprssionsIN);

                                            //map                    

                                          
                                            new svgMap({                        
                                                    targetElementID: 'svgMapYesterday',
                                                    colorMin: '#03a9f4',
                                                    colorMax: '#03a9f4',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },

                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values: {  
                                                            IN : {                                              
                                                                clicks: clicksIN, 
                                                                impression: imprssionsIN
                                                            }                                                           
                                                                               
                                                        } 
                                            
                                                      
                                                    }
                                                });
                                                if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
												
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'region' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }
                                        }                                
                                    }
                                });                     
                            }
                            else if (filtervalue == 'Last 7 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 7);
                                let get_date = new Date(date_start);
                                let first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                let current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                var start_date = first_day, end_date = date_end;

                                $.ajax({
                                    url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,'+ client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {  
                                        var removeYesterday = document.getElementById("svgMapYesterday");
                                        removeYesterday.remove();

                                        if (data.msg == 'No Stats Available') {
                                            new svgMap({                        
                                                targetElementID: 'svgMapLastsevendays',
                                                colorMin: '#03a9f4',
                                                colorMax: '#03a9f4',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:
                                                    {                                               
                                                                                                   
                                                                                
                                                    } 
                                                }
                                            });
                                        }
                                        else {

                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                return c.countrycode
                                            })                                  

                                            console.log("countrycode",countrycode);                                        

                                            var AL = countrycode.includes("AL") ? AL ="AL" : ""
                                            var DZ = countrycode.includes("DZ") ? DZ ="DZ" : ""
                                            var AS = countrycode.includes("AS") ? AS ="AS" : ""
                                            var AD = countrycode.includes("AD") ? AD ="AD" : ""
                                            var AO = countrycode.includes("AO") ? AO ="AO" : ""
                                            var AI = countrycode.includes("AI") ? AI ="AI" : ""
                                            var AQ = countrycode.includes("AQ") ? AQ ="AQ" : ""
                                            var AG = countrycode.includes("AG") ? AG ="AG" : ""
                                            var AR = countrycode.includes("AR") ? AR ="AR" : ""
                                            var BS = countrycode.includes("BS") ? BS ="BS" : ""
                                            var BH = countrycode.includes("BH") ? BH ="BH" : ""
                                            var BD = countrycode.includes("BD") ? BD ="BD" : ""
                                            var BB = countrycode.includes("BB") ? BB ="BB" : ""
                                            var BY = countrycode.includes("BY") ? BY ="BY" : ""
                                            var BE = countrycode.includes("BE") ? BE ="BE" : ""
                                            var BZ = countrycode.includes("BZ") ? BZ ="BZ" : ""
                                            var BJ = countrycode.includes("BJ") ? BJ ="BJ" : ""
                                            var BM = countrycode.includes("BM") ? BM ="BM" : ""
                                            var BT = countrycode.includes("BT") ? BT ="BT" : ""
                                            var BO = countrycode.includes("BO") ? BO ="BO" : ""
                                            var BA = countrycode.includes("BA") ? BA ="BA" : ""
                                            var BW = countrycode.includes("BW") ? BW ="BW" : ""
                                            var VG = countrycode.includes("VG") ? VG ="VG" : ""
                                            var BN = countrycode.includes("BN") ? BN ="BN" : ""
                                            var BG = countrycode.includes("BG") ? BG ="BG" : ""
                                            var BF = countrycode.includes("BF") ? BF ="BF" : ""
                                            var BI = countrycode.includes("BI") ? BI ="BI" : ""
                                            var KH = countrycode.includes("KH") ? KH ="KH" : ""
                                            var CM = countrycode.includes("CM") ? CM ="CM" : ""
                                            var CA = countrycode.includes("CA") ? CA ="CA" : ""
                                            var CT = countrycode.includes("CT") ? CT ="CT" : ""
                                            var CV = countrycode.includes("CV") ? CV ="CV" : ""
                                            var KY = countrycode.includes("KY") ? KY ="KY" : ""
                                            var CF = countrycode.includes("CF") ? CF ="CF" : ""
                                            var TD = countrycode.includes("TD") ? TD ="TD" : ""
                                            var CL = countrycode.includes("CL") ? CL ="CL" : ""
                                            var CN = countrycode.includes("CN") ? CN ="CN" : ""
                                            var CX = countrycode.includes("CX") ? CX ="CX" : ""
                                            var CC = countrycode.includes("CC") ? CC ="CC" : ""
                                            var CO = countrycode.includes("CO") ? CO ="CO" : ""
                                            var KM = countrycode.includes("KM") ? KM ="KM" : ""
                                            var CG = countrycode.includes("CG") ? CG ="CG" : ""
                                            var CD = countrycode.includes("CD") ? CD ="CD" : ""
                                            var CK = countrycode.includes("CK") ? CK ="CK" : ""
                                            var CR = countrycode.includes("CR") ? CR ="CR" : ""
                                            var HR = countrycode.includes("HR") ? HR ="HR" : ""
                                            var CU = countrycode.includes("CU") ? CU ="CU" : ""
                                            var CY = countrycode.includes("CY") ? CY ="CY" : ""
                                            var CZ = countrycode.includes("CZ") ? CZ ="CZ" : ""
                                            var CI = countrycode.includes("CI") ? CI ="CI" : ""
                                            var DK = countrycode.includes("DK") ? DK ="DK" : ""
                                            var DJ = countrycode.includes("DJ") ? DJ ="DJ" : ""
                                            var DM = countrycode.includes("DM") ? DM ="DM" : ""
                                            var DO = countrycode.includes("DO") ? DO ="DO" : ""
                                            var NQ = countrycode.includes("NQ") ? NQ ="NQ" : ""
                                            var DD = countrycode.includes("DD") ? DD ="DD" : ""
                                            var EC = countrycode.includes("EC") ? EC ="EC" : ""
                                            var EG = countrycode.includes("EG") ? EG ="EG" : ""
                                            var SV = countrycode.includes("SV") ? SV ="SV" : ""
                                            var GQ = countrycode.includes("GQ") ? GQ ="GQ" : ""
                                            var ER = countrycode.includes("ER") ? ER ="ER" : ""
                                            var EE = countrycode.includes("EE") ? EE ="EE" : ""
                                            var ET = countrycode.includes("ET") ? ET ="ET" : ""
                                            var FK = countrycode.includes("FK") ? FK ="FK" : ""
                                            var FO = countrycode.includes("FO") ? FO ="FO" : ""
                                            var FJ = countrycode.includes("FJ") ? FJ ="FJ" : ""
                                            var FI = countrycode.includes("FI") ? FI ="FI" : ""
                                            var FR = countrycode.includes("FR") ? FR ="FR" : ""
                                            var GF = countrycode.includes("GF") ? GF ="GF" : ""
                                            var PF = countrycode.includes("PF") ? PF ="PF" : ""
                                            var TF = countrycode.includes("TF") ? TF ="TF" : ""
                                            var FQ = countrycode.includes("FQ") ? FQ ="FQ" : ""
                                            var GA = countrycode.includes("GA") ? GA ="GA" : ""
                                            var GM = countrycode.includes("GM") ? GM ="GM" : ""
                                            var GE = countrycode.includes("GE") ? GE ="GE" : ""
                                            var DE = countrycode.includes("DE") ? DE ="DE" : ""
                                            var GH = countrycode.includes("GH") ? GH ="GH" : ""
                                            var GI = countrycode.includes("GI") ? GI ="GI" : ""
                                            var GR = countrycode.includes("GR") ? GR ="GR" : ""
                                            var GL = countrycode.includes("GL") ? GL ="GL" : ""
                                            var GD = countrycode.includes("GD") ? GD ="GD" : ""
                                            var GP = countrycode.includes("GP") ? GP ="GP" : ""
                                            var GU = countrycode.includes("GU") ? GU ="GU" : ""
                                            var GT = countrycode.includes("GT") ? GT ="GT" : ""
                                            var GG = countrycode.includes("GG") ? GG ="GG" : ""
                                            var GN = countrycode.includes("GN") ? GN ="GN" : ""
                                            var GW = countrycode.includes("GW") ? GW ="GW" : ""
                                            var GY = countrycode.includes("GY") ? GY ="GY" : ""
                                            var HT = countrycode.includes("HT") ? HT ="HT" : ""
                                            var HM = countrycode.includes("HM") ? HM ="HM" : ""
                                            var HN = countrycode.includes("HN") ? HN ="HN" : ""
                                            var HK = countrycode.includes("HK") ? HK ="HK" : ""
                                            var HU = countrycode.includes("HU") ? HU ="HU" : ""
                                            var IS = countrycode.includes("IS") ? IS ="IS" : ""
                                            var IN = countrycode.includes("IN") ? IN ="IN" : ""
                                            var ID = countrycode.includes("ID") ? ID ="ID" : ""
                                            var IR = countrycode.includes("IR") ? IR ="IR" : ""
                                            var IQ = countrycode.includes("IQ") ? IQ ="IQ" : ""
                                            var IE = countrycode.includes("IE") ? IE ="IE" : ""
                                            var IM = countrycode.includes("IM") ? IM ="IM" : ""
                                            var IL = countrycode.includes("IL") ? IL ="IL" : ""
                                            var IT = countrycode.includes("IT") ? IT ="IT" : ""
                                            var JM = countrycode.includes("JM") ? JM ="JM" : ""
                                            var JP = countrycode.includes("JP") ? JP ="JP" : ""
                                            var JE = countrycode.includes("JE") ? JE ="JE" : ""
                                            var JT = countrycode.includes("JT") ? JT ="JT" : ""
                                            var JO = countrycode.includes("JO") ? JO ="JO" : ""
                                            var KZ = countrycode.includes("KZ") ? KZ ="KZ" : ""
                                            var KE = countrycode.includes("KE") ? KE ="KE" : ""
                                            var KI = countrycode.includes("KI") ? KI ="KI" : ""
                                            var KW = countrycode.includes("KW") ? KW ="KW" : ""
                                            var KG = countrycode.includes("KG") ? KG ="KG" : ""
                                            var LA = countrycode.includes("LA") ? LA ="LA" : ""
                                            var LV = countrycode.includes("LV") ? LV ="LV" : ""
                                            var LB = countrycode.includes("LB") ? LB ="LB" : ""
                                            var LS = countrycode.includes("LS") ? LS ="LS" : ""
                                            var LR = countrycode.includes("LR") ? LR ="LR" : ""
                                            var LY = countrycode.includes("LY") ? LY ="LY" : ""
                                            var LI = countrycode.includes("LI") ? LI ="LI" : ""
                                            var LT = countrycode.includes("LT") ? LT ="LT" : ""
                                            var LU = countrycode.includes("LU") ? LU ="LU" : ""
                                            var MO = countrycode.includes("MO") ? MO ="MO" : ""
                                            var MK = countrycode.includes("MK") ? MK ="MK" : ""
                                            var MG = countrycode.includes("MG") ? MG ="MG" : ""
                                            var MW = countrycode.includes("MW") ? MW ="MW" : ""
                                            var MY = countrycode.includes("MY") ? MY ="MY" : ""
                                            var MV = countrycode.includes("MV") ? MV ="MV" : ""
                                            var ML = countrycode.includes("ML") ? ML ="ML" : ""
                                            var MH = countrycode.includes("MH") ? MH ="MH" : ""
                                            var MQ = countrycode.includes("MQ") ? MQ ="MQ" : ""
                                            var MR = countrycode.includes("MR") ? MR ="MR" : ""
                                            var MU = countrycode.includes("MU") ? MU ="MU" : ""
                                            var YT = countrycode.includes("YT") ? YT ="YT" : ""
                                            var FX = countrycode.includes("FX") ? FX ="FX" : ""
                                            var MX = countrycode.includes("MX") ? MX ="MX" : ""
                                            var FM = countrycode.includes("FM") ? FM ="FM" : ""
                                            var MI = countrycode.includes("MI") ? MI ="MI" : ""
                                            var MD = countrycode.includes("MD") ? MD ="MD" : ""
                                            var MC = countrycode.includes("MC") ? MC ="MC" : ""
                                            var MN = countrycode.includes("MN") ? MN ="MN" : ""
                                            var ME = countrycode.includes("ME") ? ME ="ME" : ""
                                            var MS = countrycode.includes("MS") ? MS ="MS" : ""
                                            var MA = countrycode.includes("MA") ? MA ="MA" : ""
                                            var MZ = countrycode.includes("MZ") ? MZ ="MZ" : ""
                                            var MM = countrycode.includes("MM") ? MM ="MM" : ""
                                            var NA = countrycode.includes("NA") ? NA ="NA" : ""
                                            var NR = countrycode.includes("NR") ? NR ="NR" : ""
                                            var NP = countrycode.includes("NP") ? NP ="NP" : ""
                                            var NL = countrycode.includes("NL") ? NL ="NL" : ""
                                            var AN = countrycode.includes("AN") ? AN ="AN" : ""
                                            var NT = countrycode.includes("NT") ? NT ="NT" : ""
                                            var NC = countrycode.includes("NC") ? NC ="NC" : ""
                                            var NZ = countrycode.includes("NZ") ? NZ ="NZ" : ""
                                            var NI = countrycode.includes("NI") ? NI ="NI" : ""
                                            var NE = countrycode.includes("NE") ? NE ="NE" : ""
                                            var NG = countrycode.includes("NG") ? NG ="NG" : ""
                                            var NU = countrycode.includes("NU") ? NU ="NU" : ""
                                            var NF = countrycode.includes("NF") ? NF ="NF" : ""
                                            var KP = countrycode.includes("KP") ? KP ="KP" : ""
                                            var VD = countrycode.includes("VD") ? VD ="VD" : ""
                                            var MP = countrycode.includes("MP") ? MP ="MP" : ""
                                            var NO = countrycode.includes("NO") ? NO ="NO" : ""
                                            var OM = countrycode.includes("OM") ? OM ="OM" : ""
                                            var PC = countrycode.includes("PC") ? PC ="PC" : ""
                                            var PK = countrycode.includes("PK") ? PK ="PK" : ""
                                            var PW = countrycode.includes("PW") ? PW ="PW" : ""
                                            var PS = countrycode.includes("PS") ? PS ="PS" : ""
                                            var PA = countrycode.includes("PA") ? PA ="PA" : ""
                                            var PZ = countrycode.includes("PZ") ? PZ ="PZ" : ""
                                            var PG = countrycode.includes("PG") ? PG ="PG" : ""
                                            var PY = countrycode.includes("PY") ? PY ="PY" : ""
                                            var YD = countrycode.includes("YD") ? YD ="YD" : ""
                                            var PE = countrycode.includes("PE") ? PE ="PE" : ""
                                            var PH = countrycode.includes("PH") ? PH ="PH" : ""
                                            var KP = countrycode.includes("KP") ? KP ="KP" : ""
                                            var PN = countrycode.includes("PN") ? PN ="PN" : ""
                                            var PL = countrycode.includes("PL") ? PL ="PL" : ""
                                            var KP = countrycode.includes("KP") ? KP ="KP" : ""
                                            var PT = countrycode.includes("PT") ? PT ="PT" : ""
                                            var PR = countrycode.includes("PR") ? PR ="PR" : ""
                                            var QA = countrycode.includes("QA") ? QA ="QA" : ""
                                            var RO = countrycode.includes("RO") ? RO ="RO" : ""
                                            var RU = countrycode.includes("RU") ? RU ="RU" : ""
                                            var RW = countrycode.includes("RW") ? RW ="RW" : ""
                                            var RE = countrycode.includes("RE") ? RE ="RE" : ""
                                            var BL = countrycode.includes("BL") ? BL ="BL" : ""
                                            var SH = countrycode.includes("SH") ? SH ="SH" : ""
                                            var KN = countrycode.includes("KN") ? KN ="KN" : ""
                                            var LC = countrycode.includes("LC") ? LC ="LC" : ""
                                            var MF = countrycode.includes("MF") ? MF ="MF" : ""
                                            var PM = countrycode.includes("PM") ? PM ="PM" : ""
                                            var VC = countrycode.includes("VC") ? VC ="VC" : ""
                                            var WS = countrycode.includes("WS") ? WS ="WS" : ""
                                            var SM = countrycode.includes("SM") ? SM ="SM" : ""
                                            var SA = countrycode.includes("SA") ? SA ="SA" : ""
                                            var SN = countrycode.includes("SN") ? SN ="SN" : ""
                                            var RS = countrycode.includes("RS") ? RS ="RS" : ""
                                            var CS = countrycode.includes("CS") ? CS ="CS" : ""
                                            var SC = countrycode.includes("SC") ? SC ="SC" : ""
                                            var SL = countrycode.includes("SL") ? SL ="SL" : ""
                                            var SG = countrycode.includes("SG") ? SG ="SG" : ""
                                            var SK = countrycode.includes("SK") ? SK ="SK" : ""
                                            var KP = countrycode.includes("KP") ? KP ="KP" : ""
                                            var SI = countrycode.includes("SI") ? SI ="SI" : ""
                                            var SB = countrycode.includes("SB") ? SB ="SB" : ""
                                            var SO = countrycode.includes("SO") ? SO ="SO" : ""
                                            var ZA = countrycode.includes("ZA") ? ZA ="ZA" : ""
                                            var GS = countrycode.includes("GS") ? GS ="GS" : ""
                                            var KR = countrycode.includes("KR") ? KR ="KR" : ""
                                            var ES = countrycode.includes("ES") ? ES ="ES" : ""
                                            var LK = countrycode.includes("LK") ? LK ="LK" : ""
                                            var SD = countrycode.includes("SD") ? SD ="SD" : ""
                                            var SR = countrycode.includes("SR") ? SR ="SR" : ""
                                            var SJ = countrycode.includes("SJ") ? SJ ="SJ" : ""
                                            var SZ = countrycode.includes("SZ") ? SZ ="SZ" : ""
                                            var SE = countrycode.includes("SE") ? SE ="SE" : ""
                                            var CH = countrycode.includes("CH") ? CH ="CH" : ""
                                            var SY = countrycode.includes("SY") ? SY ="SY" : ""
                                            var ST = countrycode.includes("ST") ? ST ="ST" : ""
                                            var TW = countrycode.includes("TW") ? TW ="TW" : ""
                                            var TJ = countrycode.includes("TJ") ? TJ ="TJ" : ""
                                            var TZ = countrycode.includes("TZ") ? TZ ="TZ" : ""
                                            var TH = countrycode.includes("TH") ? TH ="TH" : ""
                                            var TL = countrycode.includes("TL") ? TL ="TL" : ""
                                            var TG = countrycode.includes("TG") ? TG ="TG" : ""
                                            var TK = countrycode.includes("TK") ? TK ="TK" : ""
                                            var TO = countrycode.includes("TO") ? TO ="TO" : ""
                                            var TT = countrycode.includes("TT") ? TT ="TT" : ""
                                            var TN = countrycode.includes("TN") ? TN ="TN" : ""
                                            var TR = countrycode.includes("TR") ? TR ="TR" : ""
                                            var TM = countrycode.includes("TM") ? TM ="TM" : ""
                                            var TC = countrycode.includes("TC") ? TC ="TC" : ""
                                            var UM = countrycode.includes("UM") ? UM ="UM" : ""
                                            var PU = countrycode.includes("PU") ? PU ="PU" : ""
                                            var VI = countrycode.includes("VI") ? VI ="VI" : ""
                                            var UG = countrycode.includes("UG") ? UG ="UG" : ""
                                            var UA = countrycode.includes("UA") ? UA ="UA" : ""
                                            var SU = countrycode.includes("SU") ? SU ="SU" : ""
                                            var AE = countrycode.includes("AE") ? AE ="AE" : ""
                                            var GB = countrycode.includes("GB") ? GB ="GB" : ""
                                            var US = countrycode.includes("US") ? US ="US" : ""
                                            var ZZ = countrycode.includes("ZZ") ? ZZ ="ZZ" : ""
                                            var UY = countrycode.includes("UY") ? UY ="UY" : ""
                                            var UZ = countrycode.includes("UZ") ? UZ ="UZ" : ""
                                            var VU = countrycode.includes("VU") ? VU ="VU" : ""
                                            var VA = countrycode.includes("VA") ? VA ="VA" : ""
                                            var VE = countrycode.includes("VE") ? VE ="VE" : ""
                                            var VN = countrycode.includes("VN") ? VN ="VN" : ""
                                            var WK = countrycode.includes("WK") ? WK ="WK" : ""
                                            var WF = countrycode.includes("WF") ? WF ="WF" : ""
                                            var YE = countrycode.includes("YE") ? YE ="YE" : ""
                                            var ZM = countrycode.includes("ZM") ? ZM ="ZM" : ""
                                            var ZW = countrycode.includes("ZW") ? ZW ="ZW" : ""
                                            var AX = countrycode.includes("AX") ? AX ="AX" : ""
                                            //clicks
                                            
                                            var clicks = data.map((c)=>{
                                                return c.clicks
                                            })  
                                            console.log("clicks",clicks)


                                            //impressions

                                            var impressions = data.map((c)=>{
                                                return c.impressions
                                            })  
                                            console.log("impressions",impressions);

                                            var clicksAL=0,imprssionsAL=0,
                                            clicksDZ=0,imprssionsDZ=0,
                                            clicksAF=0,imprssionsAF=0,
                                            clicksAS=0,imprssionsAS=0,
                                            clicksAD=0,imprssionsAD=0,
                                            clicksAO=0,imprssionsAO=0,                                            
                                            clicksAI=0,imprssionsAI=0,
                                            clicksAQ=0,imprssionsAQ=0,
                                            clicksAG=0,imprssionsAG=0,
                                            clicksAR=0,imprssionsAR=0,
                                            clicksAM=0,imprssionsAM=0,
                                            clicksAW=0,imprssionsAW=0,
                                            clicksBH=0,imprssionsBH=0,
                                            clicksBD=0,imprssionsBD=0,
                                            clicksBB=0,imprssionsBB=0,
                                            clicksBY=0,imprssionsBY=0,
                                            clicksBH=0,imprssionsBH=0,
                                            clicksBE=0,imprssionsBE=0,
                                            clicksBA=0,imprssionsBA=0,
                                            clicksBW=0,imprssionsBW=0,
                                            clicksBV=0,imprssionsBV=0,
                                            clicksBH=0,imprssionsBH=0,
                                            clicksBR=0,imprssionsBR=0,
                                            clicksBQ=0,imprssionsBQ=0,
                                            clicksIO=0,imprssionsIO=0,
                                            clicksVG=0,imprssionsVG=0,
                                            clicksBN=0,imprssionsBN=0,
                                            clicksBG=0,imprssionsBG=0,
                                            clicksBF=0,imprssionsBF=0,
                                            clicksBI=0,imprssionsBI=0,
                                            clicksKH=0,imprssionsKH=0,
                                            clicksCM=0,imprssionsCM=0,
                                            clicksCA=0,imprssionsCA=0,
                                            clicksCT=0,imprssionsCT=0,
                                            clicksCV=0,imprssionsCV=0,
                                            clicksKY=0,imprssionsKY=0,
                                            clicksCF=0,imprssionsCF=0,
                                            clicksTD=0,imprssionsTD=0,
                                            clicksCL=0,imprssionsCL=0,
                                            clicksCN=0,imprssionsCN=0,
                                            clicksCX=0,imprssionsCX=0,
                                            clicksCC=0,imprssionsCC=0,
                                            clicksCO=0,imprssionsCO=0,
                                            clicksKM=0,imprssionsKM=0,
                                            clicksCG=0,imprssionsCG=0,
                                            clicksCD=0,imprssionsCD=0,
                                            clicksCK=0,imprssionsCK=0,
                                            clicksCR=0,imprssionsCR=0,
                                            clicksHR=0,imprssionsHR=0,
                                            clicksCU=0,imprssionsCU=0,
                                            clicksCY=0,imprssionsCY=0,
                                            clicksCZ=0,imprssionsCZ=0,
                                            clicksCI=0,imprssionsCI=0,
                                            clicksDK=0,imprssionsDK=0,
                                            clicksDJ=0,imprssionsDJ=0,
                                            clicksDM=0,imprssionsDM=0,
                                            clicksDO=0,imprssionsDO=0,
                                            clicksNQ=0,imprssionsNQ=0,
                                            clicksDD=0,imprssionsDD=0,
                                            clicksEC=0,imprssionsEC=0,
                                            clicksEG=0,imprssionsEG=0,
                                            clicksSV=0,imprssionsSV=0,
                                            clicksGQ=0,imprssionsGQ=0,
                                            clicksER=0,imprssionsER=0,
                                            clicksEE=0,imprssionsEE=0,
                                            clicksET=0,imprssionsET=0,
                                            clicksFK=0,imprssionsFK=0,
                                            clicksFO=0,imprssionsFO=0,
                                            clicksFJ=0,imprssionsFJ=0,
                                            clicksFI=0,imprssionsFI=0,
                                            clicksFR=0,imprssionsFR=0,
                                            clicksGF=0,imprssionsGF=0,
                                            clicksPF=0,imprssionsPF=0,
                                            clicksTF=0,imprssionsTF=0,
                                            clicksFQ=0,imprssionsFQ=0,
                                            clicksGM=0,imprssionsGM=0,
                                            clicksEC=0,imprssionsEC=0,
                                            clicksGE=0,imprssionsGE=0,
                                            clicksDE=0,imprssionsDE=0,
                                            clicksGH=0,imprssionsGH=0,
                                            clicksGI=0,imprssionsGI=0,
                                            clicksGR=0,imprssionsGR=0,
                                            clicksGL=0,imprssionsGL=0,
                                            clicksGD=0,imprssionsGD=0,
                                            clicksGP=0,imprssionsGP=0,
                                            clicksGU=0,imprssionsGU=0,
                                            clicksGG=0,imprssionsGG=0,
                                            clicksGN=0,imprssionsGN=0,
                                            clicksGW=0,imprssionsGW=0,
                                            clicksGY=0,imprssionsGY=0,
                                            clicksHT=0,imprssionsHT=0,
                                            clicksHM=0,imprssionsHM=0,
                                            clicksHN=0,imprssionsHN=0,
                                            clicksHK=0,imprssionsHK=0,
                                            clicksHU=0,imprssionsHU=0,
                                            clicksIS=0,imprssionsIS=0,
                                            clicksIN=0,imprssionsIN=0,
                                            clicksID=0,imprssionsID=0,
                                            clicksIR=0,imprssionsIR=0,
                                            clicksIQ=0,imprssionsIQ=0,
                                            clicksIE=0,imprssionsIE=0,
                                            clicksIM=0,imprssionsIM=0,
                                            clicksIL=0,imprssionsIL=0,
                                            clicksIT=0,imprssionsIT=0,
                                            clicksJM=0,imprssionsJM=0,
                                            clicksJP=0,imprssionsJP=0,
                                            clicksJE=0,imprssionsJE=0,
                                            clicksJT=0,imprssionsJT=0,
                                            clicksJO=0,imprssionsJO=0,
                                            clicksKZ=0,imprssionsKZ=0,
                                            clicksKE=0,imprssionsKE=0,
                                            clicksKI=0,imprssionsKI=0,
                                            clicksKM=0,imprssionsKM=0,
                                            clicksKG=0,imprssionsKG=0,
                                            clicksLA=0,imprssionsLA=0,
                                            clicksLV=0,imprssionsLV=0,
                                            clicksLB=0,imprssionsLB=0,
                                            clicksLS=0,imprssionsLS=0,
                                            clicksLR=0,imprssionsLR=0,
                                            clicksLY=0,imprssionsLY=0,
                                            clicksLI=0,imprssionsLI=0,
                                            clicksLU=0,imprssionsLU=0,
                                            clicksMO=0,imprssionsMO=0,
                                            clicksMK=0,imprssionsMK=0,
                                            clicksMG=0,imprssionsMG=0,
                                            clicksMM=0,imprssionsMM=0,
                                            clicksMY=0,imprssionsMY=0,
                                            clicksMV=0,imprssionsMV=0,
                                            clicksML=0,imprssionsML=0,
                                            clicksMT=0,imprssionsMT=0,
                                            clicksMH=0,imprssionsMH=0,
                                            clicksMQ=0,imprssionsMQ=0,
                                            clicksMR=0,imprssionsMR=0,
                                            clicksMU=0,imprssionsMU=0,
                                            clicksYT=0,imprssionsYT=0,
                                            clicksFX=0,imprssionsFX=0,
                                            clicksMX=0,imprssionsMX=0,
                                            clicksFM=0,imprssionsFM=0,
                                            clicksMI=0,imprssionsMI=0,
                                            clicksMD=0,imprssionsMD=0,
                                            clicksMC=0,imprssionsMC=0,
                                            clicksMN=0,imprssionsMN=0,
                                            clicksME=0,imprssionsME=0,
                                            clicksMS=0,imprssionsMS=0,
                                            clicksMA=0,imprssionsMA=0,
                                            clicksMZ=0,imprssionsMZ=0,
                                            clicksMM=0,imprssionsMM=0,
                                            clicksNA=0,imprssionsNA=0,
                                            clicksNR=0,imprssionsNR=0,
                                            clicksNP=0,imprssionsNP=0,
                                            clicksNL=0,imprssionsNL=0,
                                            clicksAN=0,imprssionsAN=0,
                                            clicksNT=0,imprssionsNT=0,
                                            clicksNC=0,imprssionsNC=0,
                                            clicksNZ=0,imprssionsNZ=0,
                                            clicksNI=0,imprssionsNI=0,
                                            clicksNE=0,imprssionsNE=0,
                                            clicksNG=0,imprssionsNG=0,
                                            clicksNU=0,imprssionsNU=0,
                                            clicksNF=0,imprssionsNF=0,
                                            clicksKP=0,imprssionsKP=0,
                                            clicksVD=0,imprssionsVD=0,
                                            clicksMP=0,imprssionsMP=0,
                                            clicksNO=0,imprssionsNO=0,
                                            clicksOM=0,imprssionsOM=0,
                                            clicksPC=0,imprssionsPC=0,
                                            clicksPK=0,imprssionsPK=0,
                                            clicksPW=0,imprssionsPW=0,
                                            clicksPS=0,imprssionsPS=0,
                                            clicksPA=0,imprssionsPA=0,
                                            clicksPZ=0,imprssionsPZ=0,
                                            clicksPG=0,imprssionsPG=0,
                                            clicksPY=0,imprssionsPY=0,
                                            clicksYD=0,imprssionsYD=0,
                                            clicksPE=0,imprssionsPE=0,
                                            clicksPH=0,imprssionsPH=0,
                                            clicksPN=0,imprssionsPN=0,
                                            clicksPL=0,imprssionsPL=0,
                                            clicksPT=0,imprssionsPT=0,
                                            clicksPR=0,imprssionsPR=0,
                                            clicksQA=0,imprssionsQA=0,
                                            clicksRO=0,imprssionsRO=0,
                                            clicksRU=0,imprssionsRU=0,
                                            clicksRW=0,imprssionsRW=0,
                                            clicksRE=0,imprssionsRE=0,
                                            clicksBL=0,imprssionsBL=0,
                                            clicksSH=0,imprssionsSH=0,
                                            clicksKN=0,imprssionsKN=0,
                                            clicksLC=0,imprssionsLC=0,
                                            clicksMF =0,imprssionsMF=0,
                                            clicksVC=0,imprssionsVC=0,
                                            clicksWS=0,imprssionsWS=0,
                                            clicksSM=0,imprssionsSM=0,
                                            clicksSA=0,imprssionsSA=0,
                                            clicksSN=0,imprssionsSN=0,
                                            clicksRS=0,imprssionsRS=0,
                                            clicksCS=0,imprssionsCS=0,
                                            clicksSC=0,imprssionsSC=0,
                                            clicksSL=0,imprssionsSL=0,
                                            clicksSG=0,imprssionsSG=0,
                                            clicksSK=0,imprssionsSK=0,
                                            clicksKP=0,imprssionsKP=0,
                                            clicksSI=0,imprssionsSI=0,
                                            clicksSB=0,imprssionsSB=0,
                                            clicksSO=0,imprssionsSO=0,
                                            clicksZA=0,imprssionsZA=0,
                                            clicksGS=0,imprssionsGS=0,
                                            clicksKR=0,imprssionsKR=0,
                                            clicksES=0,imprssionsES=0,
                                            clicksLK=0,imprssionsLK=0,
                                            clicksSD=0,imprssionsSD=0,
                                            clicksSR=0,imprssionsSR=0,
                                            clicksSJ=0,imprssionsSJ=0,
                                            clicksSZ=0,imprssionsSZ=0,
                                            clicksSE=0,imprssionsSE=0,
                                            clicksSY=0,imprssionsSY=0,
                                            clicksST=0,imprssionsST=0,
                                            clicksTW=0,imprssionsTW=0,
                                            clicksTJ=0,imprssionsTJ=0,
                                            clicksTZ=0,imprssionsTZ=0,
                                            clicksTH=0,imprssionsTH=0,
                                            clicksTL=0,imprssionsTL=0,
                                            clicksTG=0,imprssionsTG=0,
                                            clicksTK=0,imprssionsTK=0,
                                            clicksTO=0,imprssionsTO=0,
                                            clicksTT=0,imprssionsTT=0,
                                            clicksTN=0,imprssionsTN=0,
                                            clicksTR=0,imprssionsTR=0,
                                            clicksTM=0,imprssionsTM=0,
                                            clicksTC=0,imprssionsTC=0,
                                            clicksUM=0,imprssionsUM=0,
                                            clicksPU=0,imprssionsPU=0,
                                            clicksVI=0,imprssionsVI=0,
                                            clicksUG=0,imprssionsUG=0,
                                            clicksUA=0,imprssionsUA=0,
                                            clicksSU=0,imprssionsSU=0,
                                            clicksAE=0,imprssionsAE=0,
                                            clicksGB=0,imprssionsGB=0,
                                            clicksUS=0,imprssionsUS=0,
                                            clicksZZ=0,imprssionsZZ=0,
                                            clicksUY=0,imprssionsUY=0,
                                            clicksUZ=0,imprssionsUZ=0,
                                            clicksVU=0,imprssionsVU=0,
                                            clicksVA=0,imprssionsVA=0,
                                            clicksVE=0,imprssionsVE=0,
                                            clicksVN=0,imprssionsVN=0,
                                            clicksWK=0,imprssionsWK=0,
                                            clicksWF=0,imprssionsWF=0,
                                            clicksYE=0,imprssionsYE=0,
                                            clicksZM=0,imprssionsZM=0,
                                            clicksZW=0,imprssionsZW=0,
                                            clicksAX=0,imprssionsAX=0;
   
                                            


                                            for(let i=0;i<data.length;i++){
                                                if(countrycode[i] == "AF") {                                                   
                                                    clicksAF = clicks[i];
                                                    imprssionsAF = impressions[i];
                                                } if(countrycode[i] == "AL"){
                                                    clicksAL = clicks[i];
                                                    imprssionsAL = impressions[i];
                                                } if(countrycode[i] == "DZ"){
                                                    clicksDZ = clicks[i];
                                                    imprssionsDZ = impressions[i];
                                                } if(countrycode[i] == "AS"){
                                                    clicksAS = clicks[i];
                                                    imprssionsAS = impressions[i];
                                                } if(countrycode[i] == "AD"){
                                                    clicksAD = clicks[i];
                                                    imprssionsAD = impressions[i];
                                                } if(countrycode[i] == "AO"){
                                                    clicksAO = clicks[i];
                                                    imprssionsAO = impressions[i];
                                                } if(countrycode[i] == "AI"){
                                                    clicksAI = clicks[i];
                                                    imprssionsAI = impressions[i];
                                                } if(countrycode[i] == "AQ"){
                                                    clicksAQ = clicks[i];
                                                    imprssionsAQ = impressions[i];
                                                } if(countrycode[i] == "AG"){
                                                    clicksAG = clicks[i];
                                                    imprssionsAG = impressions[i];
                                                } if(countrycode[i] == "AR"){
                                                    clicksAR = clicks[i];
                                                    imprssionsAR = impressions[i];
                                                } if(countrycode[i] == "AM"){
                                                    clicksAM = clicks[i];
                                                    imprssionsAM = impressions[i];
                                                } if(countrycode[i] == "AW"){
                                                    clicksAW = clicks[i];
                                                    imprssionsAW = impressions[i];
                                                } if(countrycode[i] == "AU"){
                                                    clicksAU = clicks[i];
                                                    imprssionsAU = impressions[i];
                                                } if(countrycode[i] == "AT"){
                                                    clicksAT = clicks[i];
                                                    imprssionsAT = impressions[i];
                                                } if(countrycode[i] == "AZ"){
                                                    clicksAZ = clicks[i];
                                                    imprssionsAZ = impressions[i];
                                                } if(countrycode[i] == "BS"){
                                                    clicksBS = clicks[i];
                                                    imprssionsBS = impressions[i];
                                                } if(countrycode[i] == "BH"){
                                                    clicksBH = clicks[i];
                                                    imprssionsBH = impressions[i];
                                                } if(countrycode[i] == "BD"){
                                                    clicksBD = clicks[i];
                                                    imprssionsBD = impressions[i];
                                                } if(countrycode[i] == "BB"){
                                                    clicksBB = clicks[i];
                                                    imprssionsBB = impressions[i];
                                                } if(countrycode[i] == "BY"){
                                                    clicksBY = clicks[i];
                                                    imprssionsBY = impressions[i];
                                                } if(countrycode[i] == "BW"){
                                                    clicksBW = clicks[i];
                                                    imprssionsBW = impressions[i];
                                                } if(countrycode[i] == "BV"){
                                                    clicksBV = clicks[i];
                                                    imprssionsBV = impressions[i];
                                                } if(countrycode[i] == "BR"){
                                                    clicksBR = clicks[i];
                                                    imprssionsBR = impressions[i];
                                                } if(countrycode[i] == "BQ"){
                                                    clicksBQ = clicks[i];
                                                    imprssionsBQ = impressions[i];
                                                } if(countrycode[i] == "IO"){
                                                    clicksIO = clicks[i];
                                                    imprssionsIO = impressions[i];
                                                } if(countrycode[i] == "CM"){
                                                    clicksCM = clicks[i];
                                                    imprssionsCM = impressions[i];
                                                } if(countrycode[i] == "CA"){
                                                    clicksCA = clicks[i];
                                                    imprssionsCA = impressions[i];
                                                } if(countrycode[i] == "CT"){
                                                    clicksCT = clicks[i];
                                                    imprssionsCT = impressions[i];
                                                } if(countrycode[i] == "CV"){
                                                    clicksCV = clicks[i];
                                                    imprssionsCV = impressions[i];
                                                } if(countrycode[i] == "KY"){
                                                    clicksKY = clicks[i];
                                                    imprssionsKY = impressions[i];
                                                } if(countrycode[i] == "CF"){
                                                    clicksCF = clicks[i];
                                                    imprssionsCF = impressions[i];
                                                } if(countrycode[i] == "KM"){
                                                    clicksKM = clicks[i];
                                                    imprssionsKM = impressions[i];
                                                } if(countrycode[i] == "CG"){
                                                    clicksCG = clicks[i];
                                                    imprssionsCG = impressions[i];
                                                } if(countrycode[i] == "CD"){
                                                    clicksCD = clicks[i];
                                                    imprssionsCD = impressions[i];
                                                } if(countrycode[i] == "CK"){
                                                    clicksCK = clicks[i];
                                                    imprssionsCK = impressions[i];
                                                } if(countrycode[i] == "CR"){
                                                    clicksCR = clicks[i];
                                                    imprssionsCR = impressions[i];
                                                } if(countrycode[i] == "HR"){
                                                    clicksHR = clicks[i];
                                                    imprssionsHR = impressions[i];
                                                } if(countrycode[i] == "CU"){
                                                    clicksCU = clicks[i];
                                                    imprssionsCU = impressions[i];
                                                } if(countrycode[i] == "CY"){
                                                    clicksCY = clicks[i];
                                                    imprssionsCY = impressions[i];
                                                } if(countrycode[i] == "CZ"){
                                                    clicksCZ = clicks[i];
                                                    imprssionsCZ = impressions[i];
                                                } if(countrycode[i] == "CI"){
                                                    clicksCI = clicks[i];
                                                    imprssionsCI = impressions[i];
                                                } if(countrycode[i] == "DK"){
                                                    clicksDK = clicks[i];
                                                    imprssionsDK = impressions[i];
                                                } if(countrycode[i] == "DJ"){
                                                    clicksDJ = clicks[i];
                                                    imprssionsDJ = impressions[i];
                                                } if(countrycode[i] == "DM"){
                                                    clicksDM = clicks[i];
                                                    imprssionsDM = impressions[i];
                                                } if(countrycode[i] == "DO"){
                                                    clicksDO = clicks[i];
                                                    imprssionsDO = impressions[i];
                                                } if(countrycode[i] == "NQ"){
                                                    clicksNQ = clicks[i];
                                                    imprssionsNQ = impressions[i];
                                                } if(countrycode[i] == "DD"){
                                                    clicksDD = clicks[i];
                                                    imprssionsDD = impressions[i];
                                                } if(countrycode[i] == "EC"){
                                                    clicksEC = clicks[i];
                                                    imprssionsEC = impressions[i];
                                                } if(countrycode[i] == "EG"){
                                                    clicksEG = clicks[i];
                                                    imprssionsEG = impressions[i];
                                                } if(countrycode[i] == "SV"){
                                                    clicksSV = clicks[i];
                                                    imprssionsSV = impressions[i];
                                                } if(countrycode[i] == "GQ"){
                                                    clicksGQ = clicks[i];
                                                    imprssionsGQ = impressions[i];
                                                } if(countrycode[i] == "ER"){
                                                    clicksER = clicks[i];
                                                    imprssionsER = impressions[i];
                                                } if(countrycode[i] == "EE"){
                                                    clicksEE = clicks[i];
                                                    imprssionsEE = impressions[i];
                                                } if(countrycode[i] == "ET"){
                                                    clicksET = clicks[i];
                                                    imprssionsET = impressions[i];
                                                } if(countrycode[i] == "FK"){
                                                    clicksFK = clicks[i];
                                                    imprssionsFK = impressions[i];
                                                } if(countrycode[i] == "FO"){
                                                    clicksFO = clicks[i];
                                                    imprssionsFO = impressions[i];
                                                } if(countrycode[i] == "FJ"){
                                                    clicksFJ = clicks[i];
                                                    imprssionsFJ = impressions[i];
                                                } if(countrycode[i] == "FI"){
                                                    clicksFI = clicks[i];
                                                    imprssionsFI = impressions[i];
                                                } if(countrycode[i] == "FR"){
                                                    clicksFR = clicks[i];
                                                    imprssionsFR = impressions[i];
                                                } if(countrycode[i] == "GF"){
                                                    clicksGF = clicks[i];
                                                    imprssionsGF = impressions[i];
                                                } if(countrycode[i] == "PF"){
                                                    clicksPF = clicks[i];
                                                    imprssionsPF = impressions[i];
                                                } if(countrycode[i] == "TF"){
                                                    clicksTF = clicks[i];
                                                    imprssionsTF = impressions[i];
                                                } if(countrycode[i] == "FQ"){
                                                    clicksFQ = clicks[i];
                                                    imprssionsFQ = impressions[i];
                                                } if(countrycode[i] == "GA"){
                                                    clicksGA = clicks[i];
                                                    imprssionsGA = impressions[i];
                                                } if(countrycode[i] == "GM"){
                                                    clicksGM = clicks[i];
                                                    imprssionsGM = impressions[i];
                                                } if(countrycode[i] == "GE"){
                                                    clicksGE = clicks[i];
                                                    imprssionsGE = impressions[i];
                                                } if(countrycode[i] == "DE"){
                                                    clicksDE = clicks[i];
                                                    imprssionsDE = impressions[i];
                                                } if(countrycode[i] == "GH"){
                                                    clicksGH = clicks[i];
                                                    imprssionsGH = impressions[i];
                                                } if(countrycode[i] == "GI"){
                                                    clicksGI = clicks[i];
                                                    imprssionsGI = impressions[i];
                                                } if(countrycode[i] == "GR"){
                                                    clicksGR = clicks[i];
                                                    imprssionsGR = impressions[i];
                                                } if(countrycode[i] == "GL"){
                                                    clicksGL = clicks[i];
                                                    imprssionsGL = impressions[i];
                                                } if(countrycode[i] == "GD"){
                                                    clicksGD = clicks[i];
                                                    imprssionsGD = impressions[i];
                                                } if(countrycode[i] == "GP"){
                                                    clicksGP = clicks[i];
                                                    imprssionsGP = impressions[i];
                                                } if(countrycode[i] == "GU"){
                                                    clicksGU = clicks[i];
                                                    imprssionsGU = impressions[i];
                                                } if(countrycode[i] == "GT"){
                                                    clicksGT = clicks[i];
                                                    imprssionsGT = impressions[i];
                                                } if(countrycode[i] == "GG"){
                                                    clicksGG = clicks[i];
                                                    imprssionsGG = impressions[i];
                                                } if(countrycode[i] == "GN"){
                                                    clicksGN = clicks[i];
                                                    imprssionsGN = impressions[i];
                                                } if(countrycode[i] == "GW"){
                                                    clicksGW = clicks[i];
                                                    imprssionsGW = impressions[i];
                                                } if(countrycode[i] == "GY"){
                                                    clicksGY = clicks[i];
                                                    imprssionsGY = impressions[i];
                                                } if(countrycode[i] == "HT"){
                                                    clicksHT = clicks[i];
                                                    imprssionsHT = impressions[i];
                                                } if(countrycode[i] == "HM"){
                                                    clicksHM = clicks[i];
                                                    imprssionsHM = impressions[i];
                                                } if(countrycode[i] == "HN"){
                                                    clicksHN = clicks[i];
                                                    imprssionsHN = impressions[i];
                                                } if(countrycode[i] == "HK"){
                                                    clicksHK = clicks[i];
                                                    imprssionsHK = impressions[i];
                                                } if(countrycode[i] == "HU"){
                                                    clicksHU = clicks[i];
                                                    imprssionsHU = impressions[i];
                                                } if(countrycode[i] == "IS"){
                                                    clicksIS = clicks[i];
                                                    imprssionsIS = impressions[i];
                                                } if(countrycode[i] == "IN"){
                                                    clicksIN = clicks[i];
                                                    imprssionsIN = impressions[i];
                                                } if(countrycode[i] == "ID"){
                                                    clicksID = clicks[i];
                                                    imprssionsID = impressions[i];
                                                } if(countrycode[i] == "IR"){
                                                    clicksIR = clicks[i];
                                                    imprssionsIR = impressions[i];
                                                } if(countrycode[i] == "IQ"){
                                                    clicksIQ = clicks[i];
                                                    imprssionsIQ = impressions[i];
                                                } if(countrycode[i] == "IE"){
                                                    clicksIE = clicks[i];
                                                    imprssionsIE = impressions[i];
                                                } if(countrycode[i] == "IM"){
                                                    clicksIM = clicks[i];
                                                    imprssionsIM = impressions[i];
                                                } if(countrycode[i] == "IL"){
                                                    clicksIL = clicks[i];
                                                    imprssionsIL = impressions[i];
                                                } if(countrycode[i] == "IT"){
                                                    clicksIT = clicks[i];
                                                    imprssionsIT = impressions[i];
                                                } if(countrycode[i] == "JM"){
                                                    clicksJM = clicks[i];
                                                    imprssionsJM = impressions[i];
                                                } if(countrycode[i] == "JP"){
                                                    clicksJP = clicks[i];
                                                    imprssionsJP = impressions[i];
                                                } if(countrycode[i] == "JE"){
                                                    clicksJE = clicks[i];
                                                    imprssionsJE = impressions[i];
                                                } if(countrycode[i] == "JT"){
                                                    clicksJT = clicks[i];
                                                    imprssionsJT = impressions[i];
                                                } if(countrycode[i] == "JO"){
                                                    clicksJO = clicks[i];
                                                    imprssionsJO = impressions[i];
                                                } if(countrycode[i] == "KZ"){
                                                    clicksKZ = clicks[i];
                                                    imprssionsKZ = impressions[i];
                                                } if(countrycode[i] == "KE"){
                                                    clicksKE = clicks[i];
                                                    imprssionsKE = impressions[i];
                                                } if(countrycode[i] == "KI"){
                                                    clicksKI = clicks[i];
                                                    imprssionsKI = impressions[i];
                                                } if(countrycode[i] == "KW"){
                                                    clicksKW = clicks[i];
                                                    imprssionsKW = impressions[i];
                                                } if(countrycode[i] == "KG"){
                                                    clicksKG = clicks[i];
                                                    imprssionsKG = impressions[i];
                                                } if(countrycode[i] == "LA"){
                                                    clicksLA = clicks[i];
                                                    imprssionsLA = impressions[i];
                                                } if(countrycode[i] == "LV"){
                                                    clicksLV = clicks[i];
                                                    imprssionsLV = impressions[i];
                                                } if(countrycode[i] == "LB"){
                                                    clicksLB = clicks[i];
                                                    imprssionsLB = impressions[i];
                                                } if(countrycode[i] == "LS"){
                                                    clicksLS = clicks[i];
                                                    imprssionsLS = impressions[i];
                                                } if(countrycode[i] == "LR"){
                                                    clicksLR = clicks[i];
                                                    imprssionsLR = impressions[i];
                                                } if(countrycode[i] == "LY"){
                                                    clicksLY = clicks[i];
                                                    imprssionsLY = impressions[i];
                                                } if(countrycode[i] == "LI"){
                                                    clicksLI = clicks[i];
                                                    imprssionsLI = impressions[i];
                                                } if(countrycode[i] == "LT"){
                                                    clicksLT = clicks[i];
                                                    imprssionsLT = impressions[i];
                                                } if(countrycode[i] == "LU"){
                                                    clicksLU = clicks[i];
                                                    imprssionsLU = impressions[i];
                                                } if(countrycode[i] == "MO"){
                                                    clicksMO = clicks[i];
                                                    imprssionsMO = impressions[i];
                                                } if(countrycode[i] == "MK"){
                                                    clicksMK = clicks[i];
                                                    imprssionsMK = impressions[i];
                                                } if(countrycode[i] == "MG"){
                                                    clicksMG = clicks[i];
                                                    imprssionsMG = impressions[i];
                                                } if(countrycode[i] == "MW"){
                                                    clicksMW = clicks[i];
                                                    imprssionsMW = impressions[i];
                                                } if(countrycode[i] == "MY"){
                                                    clicksMY = clicks[i];
                                                    imprssionsMY = impressions[i];
                                                } if(countrycode[i] == "MV"){
                                                    clicksMV = clicks[i];
                                                    imprssionsMV = impressions[i];
                                                } if(countrycode[i] == "ML"){
                                                    clicksML = clicks[i];
                                                    imprssionsML = impressions[i];
                                                } if(countrycode[i] == "MT"){
                                                    clicksMT = clicks[i];
                                                    imprssionsMT = impressions[i];
                                                } if(countrycode[i] == "MH"){
                                                    clicksMH = clicks[i];
                                                    imprssionsMH = impressions[i];
                                                } if(countrycode[i] == "MQ"){
                                                    clicksMQ = clicks[i];
                                                    imprssionsMQ = impressions[i];
                                                } if(countrycode[i] == "MR"){
                                                    clicksMR = clicks[i];
                                                    imprssionsMR = impressions[i];
                                                } if(countrycode[i] == "MU"){
                                                    clicksMU = clicks[i];
                                                    imprssionsMU = impressions[i];
                                                } if(countrycode[i] == "YT"){
                                                    clicksYT = clicks[i];
                                                    imprssionsYT = impressions[i];
                                                } if(countrycode[i] == "FX"){
                                                    clicksFX = clicks[i];
                                                    imprssionsFX = impressions[i];
                                                } if(countrycode[i] == "MX"){
                                                    clicksMX = clicks[i];
                                                    imprssionsMX = impressions[i];
                                                } if(countrycode[i] == "FM"){
                                                    clicksFM = clicks[i];
                                                    imprssionsFM = impressions[i];
                                                } if(countrycode[i] == "MI"){
                                                    clicksMI = clicks[i];
                                                    imprssionsMI = impressions[i];
                                                } if(countrycode[i] == "MD"){
                                                    clicksMD = clicks[i];
                                                    imprssionsMD = impressions[i];
                                                } if(countrycode[i] == "MC"){
                                                    clicksMC = clicks[i];
                                                    imprssionsMC = impressions[i];
                                                } if(countrycode[i] == "MN"){
                                                    clicksMN = clicks[i];
                                                    imprssionsMN = impressions[i];
                                                } if(countrycode[i] == "ME"){
                                                    clicksME = clicks[i];
                                                    imprssionsME = impressions[i];
                                                } if(countrycode[i] == "MS"){
                                                    clicksMS = clicks[i];
                                                    imprssionsMS = impressions[i];
                                                } if(countrycode[i] == "MA"){
                                                    clicksMA = clicks[i];
                                                    imprssionsMA = impressions[i];
                                                } if(countrycode[i] == "MZ"){
                                                    clicksMZ = clicks[i];
                                                    imprssionsMZ = impressions[i];
                                                } if(countrycode[i] == "MM"){
                                                    clicksMM = clicks[i];
                                                    imprssionsMM = impressions[i];
                                                } if(countrycode[i] == "NA"){
                                                    clicksNA = clicks[i];
                                                    imprssionsNA = impressions[i];
                                                } if(countrycode[i] == "NR"){
                                                    clicksNR = clicks[i];
                                                    imprssionsNR = impressions[i];
                                                } if(countrycode[i] == "NP"){
                                                    clicksNP = clicks[i];
                                                    imprssionsNP = impressions[i];
                                                } if(countrycode[i] == "NL"){
                                                    clicksNL = clicks[i];
                                                    imprssionsNL = impressions[i];
                                                } if(countrycode[i] == "AN"){
                                                    clicksAN = clicks[i];
                                                    imprssionsAN = impressions[i];
                                                } if(countrycode[i] == "NT"){
                                                    clicksNT = clicks[i];
                                                    imprssionsNT = impressions[i];
                                                } if(countrycode[i] == "NC"){
                                                    clicksNC = clicks[i];
                                                    imprssionsNC = impressions[i];
                                                } if(countrycode[i] == "NZ"){
                                                    clicksNZ = clicks[i];
                                                    imprssionsNZ = impressions[i];
                                                } if(countrycode[i] == "NI"){
                                                    clicksNI = clicks[i];
                                                    imprssionsNI = impressions[i];
                                                } if(countrycode[i] == "NE"){
                                                    clicksNE = clicks[i];
                                                    imprssionsNE = impressions[i];
                                                } if(countrycode[i] == "NG"){
                                                    clicksNG = clicks[i];
                                                    imprssionsNG = impressions[i];
                                                } if(countrycode[i] == "NU"){
                                                    clicksNU = clicks[i];
                                                    imprssionsNU = impressions[i];
                                                } if(countrycode[i] == "NF"){
                                                    clicksNF = clicks[i];
                                                    imprssionsNF = impressions[i];
                                                } if(countrycode[i] == "KP"){
                                                    clicksKP = clicks[i];
                                                    imprssionsKP = impressions[i];
                                                } if(countrycode[i] == "VD"){
                                                    clicksVD = clicks[i];
                                                    imprssionsVD = impressions[i];
                                                } if(countrycode[i] == "MP"){
                                                    clicksMP = clicks[i];
                                                    imprssionsMP = impressions[i];
                                                } if(countrycode[i] == "NO"){
                                                    clicksNO = clicks[i];
                                                    imprssionsNO = impressions[i];
                                                } if(countrycode[i] == "OM"){
                                                    clicksOM = clicks[i];
                                                    imprssionsOM = impressions[i];
                                                } if(countrycode[i] == "PC"){
                                                    clicksPC = clicks[i];
                                                    imprssionsPC = impressions[i];
                                                } if(countrycode[i] == "PK"){
                                                    clicksPK = clicks[i];
                                                    imprssionsPK = impressions[i];
                                                } if(countrycode[i] == "PW"){
                                                    clicksPW = clicks[i];
                                                    imprssionsPW = impressions[i];
                                                } if(countrycode[i] == "PS"){
                                                    clicksPS = clicks[i];
                                                    imprssionsPS = impressions[i];
                                                } if(countrycode[i] == "PA"){
                                                    clicksPA = clicks[i];
                                                    imprssionsPA = impressions[i];
                                                } if(countrycode[i] == "PZ"){
                                                    clicksPZ = clicks[i];
                                                    imprssionsPZ = impressions[i];
                                                } if(countrycode[i] == "PG"){
                                                    clicksPG = clicks[i];
                                                    imprssionsPG = impressions[i];
                                                } if(countrycode[i] == "PY"){
                                                    clicksPY = clicks[i];
                                                    imprssionsPY = impressions[i];
                                                } if(countrycode[i] == "YD"){
                                                    clicksYD = clicks[i];
                                                    imprssionsYD = impressions[i];
                                                } if(countrycode[i] == "PE"){
                                                    clicksPE = clicks[i];
                                                    imprssionsPE = impressions[i];
                                                } if(countrycode[i] == "PH"){
                                                    clicksPH = clicks[i];
                                                    imprssionsPH = impressions[i];
                                                } if(countrycode[i] == "PN"){
                                                    clicksPN = clicks[i];
                                                    imprssionsPN = impressions[i];
                                                } if(countrycode[i] == "PL"){
                                                    clicksPL = clicks[i];
                                                    imprssionsPL = impressions[i];
                                                } if(countrycode[i] == "PT"){
                                                    clicksPT = clicks[i];
                                                    imprssionsPT = impressions[i];
                                                } if(countrycode[i] == "PR"){
                                                    clicksPR = clicks[i];
                                                    imprssionsPR = impressions[i];
                                                } if(countrycode[i] == "QA"){
                                                    clicksQA = clicks[i];
                                                    imprssionsQA = impressions[i];
                                                } if(countrycode[i] == "RO"){
                                                    clicksRO = clicks[i];
                                                    imprssionsRO = impressions[i];
                                                } if(countrycode[i] == "RU"){
                                                    clicksRU = clicks[i];
                                                    imprssionsRU = impressions[i];
                                                } if(countrycode[i] == "RW"){
                                                    clicksRW = clicks[i];
                                                    imprssionsRW = impressions[i];
                                                } if(countrycode[i] == "RE"){
                                                    clicksRE = clicks[i];
                                                    imprssionsRE = impressions[i];
                                                } if(countrycode[i] == "BL"){
                                                    clicksBL = clicks[i];
                                                    imprssionsBL = impressions[i];
                                                } if(countrycode[i] == "SH"){
                                                    clicksSH = clicks[i];
                                                    imprssionsSH = impressions[i];
                                                } if(countrycode[i] == "KN"){
                                                    clicksKN = clicks[i];
                                                    imprssionsKN = impressions[i];
                                                } if(countrycode[i] == "LC"){
                                                    clicksLC = clicks[i];
                                                    imprssionsLC = impressions[i];
                                                } if(countrycode[i] == "MF"){
                                                    clicksMF = clicks[i];
                                                    imprssionsMF = impressions[i];
                                                } if(countrycode[i] == "PM"){
                                                    clicksPM = clicks[i];
                                                    imprssionsPM = impressions[i];
                                                } if(countrycode[i] == "VC"){
                                                    clicksVC = clicks[i];
                                                    imprssionsVC = impressions[i];
                                                } if(countrycode[i] == "WS"){
                                                    clicksWS = clicks[i];
                                                    imprssionsWS = impressions[i];
                                                } if(countrycode[i] == "SM"){
                                                    clicksSM = clicks[i];
                                                    imprssionsSM = impressions[i];
                                                } if(countrycode[i] == "SA"){
                                                    clicksSA = clicks[i];
                                                    imprssionsSA = impressions[i];
                                                } if(countrycode[i] == "SN"){
                                                    clicksSN = clicks[i];
                                                    imprssionsSN = impressions[i];
                                                } if(countrycode[i] == "RS"){
                                                    clicksRS = clicks[i];
                                                    imprssionsRS = impressions[i];
                                                } if(countrycode[i] == "CS"){
                                                    clicksCS = clicks[i];
                                                    imprssionsCS = impressions[i];
                                                } if(countrycode[i] == "SC"){
                                                    clicksSC = clicks[i];
                                                    imprssionsSC = impressions[i];
                                                } if(countrycode[i] == "SL"){
                                                    clicksSL = clicks[i];
                                                    imprssionsSL = impressions[i];
                                                } if(countrycode[i] == "SG"){
                                                    clicksSG = clicks[i];
                                                    imprssionsSG = impressions[i];
                                                } if(countrycode[i] == "SK"){
                                                    clicksSK = clicks[i];
                                                    imprssionsSK = impressions[i];
                                                } if(countrycode[i] == "SI"){
                                                    clicksSI = clicks[i];
                                                    imprssionsSI = impressions[i];
                                                } if(countrycode[i] == "SB"){
                                                    clicksSB = clicks[i];
                                                    imprssionsSB = impressions[i];
                                                } if(countrycode[i] == "ZA"){
                                                    clicksZA = clicks[i];
                                                    imprssionsZA = impressions[i];
                                                } if(countrycode[i] == "GS"){
                                                    clicksGS = clicks[i];
                                                    imprssionsGS = impressions[i];
                                                } if(countrycode[i] == "KR"){
                                                    clicksKR = clicks[i];
                                                    imprssionsKR = impressions[i];
                                                } if(countrycode[i] == "ES"){
                                                    clicksES = clicks[i];
                                                    imprssionsES = impressions[i];
                                                } if(countrycode[i] == "LK"){
                                                    clicksLK = clicks[i];
                                                    imprssionsLK = impressions[i];
                                                } if(countrycode[i] == "SD"){
                                                    clicksSD = clicks[i];
                                                    imprssionsSD = impressions[i];
                                                } if(countrycode[i] == "SR"){
                                                    clicksSR = clicks[i];
                                                    imprssionsSR = impressions[i];
                                                } if(countrycode[i] == "SJ"){
                                                    clicksSJ = clicks[i];
                                                    imprssionsSJ = impressions[i];
                                                } if(countrycode[i] == "SZ"){
                                                    clicksSZ = clicks[i];
                                                    imprssionsSZ = impressions[i];
                                                } if(countrycode[i] == "SE"){
                                                    clicksSE = clicks[i];
                                                    imprssionsSE = impressions[i];
                                                } if(countrycode[i] == "CH"){
                                                    clicksCH = clicks[i];
                                                    imprssionsCH = impressions[i];
                                                } if(countrycode[i] == "SY"){
                                                    clicksSY = clicks[i];
                                                    imprssionsSY = impressions[i];
                                                } if(countrycode[i] == "ST"){
                                                    clicksST = clicks[i];
                                                    imprssionsST = impressions[i];
                                                } if(countrycode[i] == "TW"){
                                                    clicksTW = clicks[i];
                                                    imprssionsTW = impressions[i];
                                                } if(countrycode[i] == "TJ"){
                                                    clicksTJ = clicks[i];
                                                    imprssionsTJ = impressions[i];
                                                } if(countrycode[i] == "TZ"){
                                                    clicksTZ = clicks[i];
                                                    imprssionsTZ = impressions[i];
                                                } if(countrycode[i] == "TH"){
                                                    clicksTH = clicks[i];
                                                    imprssionsTH = impressions[i];
                                                } if(countrycode[i] == "TL"){
                                                    clicksTL = clicks[i];
                                                    imprssionsTL = impressions[i];
                                                } if(countrycode[i] == "TG"){
                                                    clicksTG = clicks[i];
                                                    imprssionsTG = impressions[i];
                                                } if(countrycode[i] == "TK"){
                                                    clicksTK = clicks[i];
                                                    imprssionsTK = impressions[i];
                                                } if(countrycode[i] == "TO"){
                                                    clicksTO = clicks[i];
                                                    imprssionsTO = impressions[i];
                                                } if(countrycode[i] == "TT"){
                                                    clicksTT = clicks[i];
                                                    imprssionsTT = impressions[i];
                                                } if(countrycode[i] == "TN"){
                                                    clicksTN = clicks[i];
                                                    imprssionsTN = impressions[i];
                                                } if(countrycode[i] == "TR"){
                                                    clicksTR = clicks[i];
                                                    imprssionsTR = impressions[i];
                                                } if(countrycode[i] == "TM"){
                                                    clicksTM = clicks[i];
                                                    imprssionsTM = impressions[i];
                                                } if(countrycode[i] == "TC"){
                                                    clicksTC = clicks[i];
                                                    imprssionsTC = impressions[i];
                                                } if(countrycode[i] == "TV"){
                                                    clicksTV = clicks[i];
                                                    imprssionsTV = impressions[i];
                                                } if(countrycode[i] == "UM"){
                                                    clicksUM = clicks[i];
                                                    imprssionsUM = impressions[i];
                                                } if(countrycode[i] == "PU"){
                                                    clicksPU = clicks[i];
                                                    imprssionsPU = impressions[i];
                                                } if(countrycode[i] == "VI"){
                                                    clicksVI = clicks[i];
                                                    imprssionsVI = impressions[i];
                                                } if(countrycode[i] == "UG"){
                                                    clicksUG = clicks[i];
                                                    imprssionsUG = impressions[i];
                                                } if(countrycode[i] == "UA"){
                                                    clicksUA = clicks[i];
                                                    imprssionsUA = impressions[i];
                                                } if(countrycode[i] == "SU"){
                                                    clicksSU = clicks[i];
                                                    imprssionsSU = impressions[i];
                                                } if(countrycode[i] == "AE"){
                                                    clicksAE = clicks[i];
                                                    imprssionsAE = impressions[i];
                                                } if(countrycode[i] == "GB"){
                                                    clicksGB = clicks[i];
                                                    imprssionsGB = impressions[i];
                                                } if(countrycode[i] == "US"){
                                                    clicksUS = clicks[i];
                                                    imprssionsUS = impressions[i];
                                                } if(countrycode[i] == "ZZ"){
                                                    clicksZZ = clicks[i];
                                                    imprssionsZZ = impressions[i];
                                                } if(countrycode[i] == "UY"){
                                                    clicksUY = clicks[i];
                                                    imprssionsUY = impressions[i];
                                                } if(countrycode[i] == "UZ"){
                                                    clicksUZ = clicks[i];
                                                    imprssionsUZ = impressions[i];
                                                } if(countrycode[i] == "VU"){
                                                    clicksVU = clicks[i];
                                                    imprssionsVU = impressions[i];
                                                } if(countrycode[i] == "VA"){
                                                    clicksVA = clicks[i];
                                                    imprssionsVA = impressions[i];
                                                } if(countrycode[i] == "VE"){
                                                    clicksVE = clicks[i];
                                                    imprssionsVE = impressions[i];
                                                } if(countrycode[i] == "VN"){
                                                    clicksVN = clicks[i];
                                                    imprssionsVN = impressions[i];
                                                } if(countrycode[i] == "WK"){
                                                    clicksWK = clicks[i];
                                                    imprssionsWK = impressions[i];
                                                } if(countrycode[i] == "WF"){
                                                    clicksWF = clicks[i];
                                                    imprssionsWF = impressions[i];
                                                } if(countrycode[i] == "EH"){
                                                    clicksEH = clicks[i];
                                                    imprssionsEH = impressions[i];
                                                } if(countrycode[i] == "YE"){
                                                    clicksYE = clicks[i];
                                                    imprssionsYE = impressions[i];
                                                } if(countrycode[i] == "ZM"){
                                                    clicksZM = clicks[i];
                                                    imprssionsZM = impressions[i];
                                                } if(countrycode[i] == "ZW"){
                                                    clicksZW = clicks[i];
                                                    imprssionsZW = impressions[i];
                                                } if(countrycode[i] == "AX"){
                                                    clicksAX = clicks[i];
                                                    imprssionsAX = impressions[i];
                                                }
                                                
                                            }
                                            
                                            console.log("clicksIN",clicksIN);
                                            console.log("imprssionsIN",imprssionsIN);
                                        
                                            //map

                                            new svgMap({                        
                                                    targetElementID: 'svgMapLastsevendays',                                                  
                                                    colorMin: '#03a9f4',
                                                    colorMax: '#03a9f4',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            AU : { clicks : clicksAU, impression : imprssionsAU }, 
                                                            BE : { clicks : clicksBE, impression : imprssionsBE },  
                                                            CA : { clicks : clicksCA, impression : imprssionsCA }, 
                                                            IN : { clicks : clicksIN, impression : imprssionsIN }, 
                                                            JP : { clicks : clicksJP, impression : imprssionsJP }, 
                                                            US : { clicks : clicksUS, impression : imprssionsUS }                                     
                                                                                    
                                                        } 
                                                    }
                                                });
                                                if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												  $('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'region' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }
                                        }                                
                                    }
                                });
                        
                            
                            }
                            else if (filtervalue == 'Last 30 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 30);
                                let get_date = new Date(date_start);
                                var first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                const current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                var start_date = first_day, end_date = date_end;

                                $.ajax({
                                    url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,'+client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {  
                                        var removeLastsevendays = document.getElementById("svgMapLastsevendays");
                                        removeLastsevendays.remove();


                                        if (data.msg == 'No Stats Available') {
                                            new svgMap({                        
                                                targetElementID: 'svgMapLastthirtydays',
                                                colorMin: '#03a9f4',
                                                colorMax: '#03a9f4',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:
                                                    {                                               
                                                                                                   
                                                                                
                                                    } 
                                                }
                                            });
                                        }
                                        else 
                                        {
                                            //INDIA
                                            var clickIndia = data.map((c)=>{
                                            if(c.countrycode == "IN"){
                                                var clicksIN = [];
                                                clicksIN.push(c.clicks)
                                            } 
                                                return clicksIN
                                            })
                                            console.log("clickIndia",clickIndia)                                 

                                            let sumofclicksIndia = clickIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksIndia",sumofclicksIndia) 

                                            var impressionsIndia = data.map((c)=>{
                                                if(c.countrycode == "IN"){
                                                    var impressionsIN = [];
                                                    impressionsIN.push(c.impressions)
                                                }
                                                return impressionsIN
                                            })
                                            console.log("impressionsIndia",impressionsIndia)

                                            let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsIndia",sumofimpressionsIndia) 


                                            //United States
                                            var clickUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var clicksUS = [];
                                                    clicksUS.push(c.clicks)
                                                } 
                                                return clicksUS
                                            })
                                            console.log("clickUs",clickUs)                                 

                                            let sumofclicksUs = clickUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksUs",sumofclicksUs) 

                                            var impressionsUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var impressionsUS = [];
                                                    impressionsUS.push(c.impressions)
                                                }
                                                return impressionsUS
                                            })
                                            console.log("impressionsUs",impressionsUs)

                                            let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsUs",sumofimpressionsUs) 


                                            //German
                                            var clickDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var clicksDE = [];
                                                    clicksDE.push(c.clicks)
                                                } 
                                                return clicksDE
                                            })
                                            console.log("clickUs",clickDe)                                 

                                            let sumofclicksDe = clickDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksDe",sumofclicksDe) 

                                            var impressionsDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var impressionsDE = [];
                                                    impressionsDE.push(c.impressions)
                                                }
                                                return impressionsDE
                                            })
                                            console.log("impressionsDe",impressionsDe)

                                            let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsDe",sumofimpressionsDe) 


                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                    return c.countrycode
                                            })                                  

                                            console.log("countrycode",countrycode)

                                            const uniqueArr = countrycode.filter((c, index) => {
                                                return countrycode.indexOf(c) === index;
                                            });
                                        
                                            console.log("uniqueArr",uniqueArr);

                                            var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                            var DE = uniqueArr.includes("DE") ? DE ="DE" : ""
                                            var US = uniqueArr.includes("US") ? US ="US" : ""


                                            console.log("IN",IN);
                                            console.log("DE",DE);
                                            console.log("US",US);

                                            console.log("filtervalue",filtervalue)
                                        
                                            //map

                                            new svgMap({                        
                                                    targetElementID: 'svgMapLastthirtydays',
                                                    colorMin: '#03a9f4',
                                                    colorMax: '#03a9f4',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            DE : {
                                                                clicks: sumofclicksDe, 
                                                                impression: sumofimpressionsDe
                                                            }, 
                                                            IN : {                                                    
                                                                clicks: sumofclicksIndia, 
                                                                impression: sumofimpressionsIndia
                                                            },    
                                                            US : {
                                                                clicks: sumofclicksUs, 
                                                                impression: sumofimpressionsUs
                                                            }                                                                         
                                                        } 
                                                    }
                                                });
                                                if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }
                                        }                                
                                    }
                                });
                            }
                            else if (filtervalue == 'This Month') {
                                $("#daterange").css("display", "none");
                                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                let cDate = firstDay.getDate(), cMonth = firstDay.getMonth() + 1, cYear = firstDay.getFullYear();
                                let first_day = cYear + "-" + cMonth + "-" + cDate;

                                const current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                var start_date = first_day, end_date = date_end;

                                $.ajax({
                                    url: domain_url+ start_date + ' 00:00:00,' + end_date + ' 12:00:00,'+client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {  
                                        var removeLastthirtydays = document.getElementById("svgMapLastthirtydays");
                                        removeLastthirtydays.remove();

                                        if (data.msg == 'No Stats Available') {
                                            new svgMap({                        
                                                targetElementID: 'svgMapThismonth',
                                                colorMin: '#03a9f4',
                                                colorMax: '#03a9f4',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:{} 
                                                }
                                            });
                                        }
                                        else 
                                        {
                                            //INDIA
                                            var clickIndia = data.map((c)=>{
                                            if(c.countrycode == "IN"){
                                                var clicksIN = [];
                                                clicksIN.push(c.clicks)
                                            } 
                                                return clicksIN
                                            })
                                            console.log("clickIndia",clickIndia)                                 

                                            let sumofclicksIndia = clickIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksIndia",sumofclicksIndia) 

                                            var impressionsIndia = data.map((c)=>{
                                                if(c.countrycode == "IN"){
                                                    var impressionsIN = [];
                                                    impressionsIN.push(c.impressions)
                                                }
                                                return impressionsIN
                                            })
                                            console.log("impressionsIndia",impressionsIndia)

                                            let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsIndia",sumofimpressionsIndia) 


                                            //United States
                                            var clickUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var clicksUS = [];
                                                    clicksUS.push(c.clicks)
                                                } 
                                                return clicksUS
                                            })
                                            console.log("clickUs",clickUs)                                 

                                            let sumofclicksUs = clickUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksUs",sumofclicksUs) 

                                            var impressionsUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var impressionsUS = [];
                                                    impressionsUS.push(c.impressions)
                                                }
                                                return impressionsUS
                                            })
                                            console.log("impressionsUs",impressionsUs)

                                            let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsUs",sumofimpressionsUs) 


                                            //German
                                            var clickDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var clicksDE = [];
                                                    clicksDE.push(c.clicks)
                                                } 
                                                return clicksDE
                                            })
                                            console.log("clickUs",clickDe)                                 

                                            let sumofclicksDe = clickDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksDe",sumofclicksDe) 

                                            var impressionsDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var impressionsDE = [];
                                                    impressionsDE.push(c.impressions)
                                                }
                                                return impressionsDE
                                            })
                                            console.log("impressionsDe",impressionsDe)

                                            let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsDe",sumofimpressionsDe) 


                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                    return c.countrycode
                                            })                                  

                                            console.log("countrycode",countrycode)

                                            const uniqueArr = countrycode.filter((c, index) => {
                                                return countrycode.indexOf(c) === index;
                                            });
                                        
                                            console.log("uniqueArr",uniqueArr);

                                            var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                            var DE = uniqueArr.includes("DE") ? DE ="DE" : ""
                                            var US = uniqueArr.includes("US") ? US ="US" : ""


                                            console.log("IN",IN);
                                            console.log("DE",DE);
                                            console.log("US",US);

                                            console.log("filtervalue",filtervalue)
                                        
                                            //map

                                            new svgMap({                        
                                                    targetElementID: 'svgMapThismonth',
                                                    colorMin: '#03a9f4',
                                                    colorMax: '#03a9f4',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            DE : {
                                                                clicks: sumofclicksDe, 
                                                                impression: sumofimpressionsDe
                                                            }, 
                                                            IN : {                                                    
                                                                clicks: sumofclicksIndia, 
                                                                impression: sumofimpressionsIndia
                                                            },    
                                                            US : {
                                                                clicks: sumofclicksUs, 
                                                                impression: sumofimpressionsUs
                                                            }                                                
                                                                                    
                                                        } 
                                                    }
                                                });
                                                if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'region' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }
                                        }                                
                                    }
                                });
                            }
                            else if (filtervalue == 'Last Month') {
                                
                                var removeThismonth = document.getElementById("svgMapThismonth");
                                removeThismonth.remove();


                                $("#daterange").css("display", "none");
                                var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                var formatDateComponent = function (dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                                }
                                var formatDate = function (date) {
                                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                };
                                var start_date = formatDate(prevMonthFirstDate),
                                    end_date = formatDate(prevMonthLastDate);


                              ;

                                $.ajax({
                                    url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,'+client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {  
                                       

                                        if (data.msg == 'No Stats Available') {
                                            new svgMap({                        
                                                targetElementID: 'svgMapLastmonth',
                                                colorMin: '#03a9f4',
                                                colorMax: '#03a9f4',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:{

                                                    } 
                                                }
                                            });
                                        }
                                        else 
                                        {
                                            //INDIA
                                            var clickIndia = data.map((c)=>{
                                            if(c.countrycode == "IN"){
                                                var clicksIN = [];
                                                clicksIN.push(c.clicks)
                                            } 
                                                return clicksIN
                                            })
                                            console.log("clickIndia",clickIndia)                                 

                                            let sumofclicksIndia = clickIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofclicksIndia",sumofclicksIndia) 

                                            var impressionsIndia = data.map((c)=>{
                                                if(c.countrycode == "IN"){
                                                    var impressionsIN = [];
                                                    impressionsIN.push(c.impressions)
                                                }
                                                return impressionsIN
                                            })
                                            console.log("impressionsIndia",impressionsIndia)

                                            let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofimpressionsIndia",sumofimpressionsIndia) 

                                            //United States
                                            var clickUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var clicksUS = [];
                                                    clicksUS.push(c.clicks)
                                                } 
                                                return clicksUS
                                            })
                                            console.log("clickUs",clickUs)                                 

                                            let sumofclicksUs = clickUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofclicksUs",sumofclicksUs) 

                                            var impressionsUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var impressionsUS = [];
                                                    impressionsUS.push(c.impressions)
                                                }
                                                return impressionsUS
                                            })
                                            console.log("impressionsUs",impressionsUs)

                                            let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofimpressionsUs",sumofimpressionsUs) 

                                            //German
                                            var clickDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var clicksDE = [];
                                                    clicksDE.push(c.clicks)
                                                } 
                                                return clicksDE
                                            })
                                            console.log("clickUs",clickDe)                                 

                                            let sumofclicksDe = clickDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofclicksDe",sumofclicksDe) 

                                            var impressionsDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var impressionsDE = [];
                                                    impressionsDE.push(c.impressions)
                                                }
                                                return impressionsDE
                                            })
                                            console.log("impressionsDe",impressionsDe)

                                            let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofimpressionsDe",sumofimpressionsDe) 

                                            //countrycode
                                            var countrycode = data.map((c)=>{
                                                    return c.countrycode
                                            })                                  
                                            console.log("countrycode",countrycode)

                                            const uniqueArr = countrycode.filter((c, index) => {
                                                return countrycode.indexOf(c) === index;
                                            });
                                            console.log("uniqueArr",uniqueArr);

                                            var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                            var DE = uniqueArr.includes("DE") ? DE ="DE" : ""
                                            var US = uniqueArr.includes("US") ? US ="US" : ""

                                            console.log("IN",IN);
                                            console.log("DE",DE);
                                            console.log("US",US);

                                            console.log("filtervalue",filtervalue)
                                        
                                            //map

                                            new svgMap({                        
                                                    targetElementID: 'svgMapLastmonth',
                                                    colorMin: '#03a9f4',
                                                    colorMax: '#03a9f4',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            DE : {
                                                                clicks: sumofclicksDe, 
                                                                impression: sumofimpressionsDe
                                                            }, 
                                                            IN : {                                                    
                                                                clicks: sumofclicksIndia, 
                                                                impression: sumofimpressionsIndia
                                                            },    
                                                            US : {
                                                                clicks: sumofclicksUs, 
                                                                impression: sumofimpressionsUs
                                                            }                                                                         
                                                        } 
                                                    }
                                                });


                                                if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;
												$('#georep').DataTable({
													"ordering": true,
													"destroy": true,
													data: data,
													columns: [
														{ data: 'country' },
														{ data: 'city' },
														{ data: 'campaignname' },
														{ data: 'impressions' },
														{ data: 'clicks' },
														{ data: 'ctr' },
														{ data: 'total_revenue' },
														{ data: 'ecpm' },
														
													],
													});

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }
                                        }                                
                                    }
                                }); 
                            }
                            else if (filtervalue == 'all statistics') {
                                $("#daterange").css("display", "none");

                                // alert("filtervalue",filtervalue);
                                var removeLastmonth = document.getElementById("svgMapLastmonth");
                                removeLastmonth.remove();

                                $.ajax(
                                {
                                    url: live_URL + '/get_all_georeport_statistics/'+client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) 
                                    {                           
                                        if (data.msg == 'No Stats Available') {

                                            //map
                                            new svgMap({                        
                                                targetElementID: 'svgMapAllstatistics',
                                                colorMin: '#03a9f4',
                                                colorMax: '#03a9f4',
                                                data: {
                                                    data: {
                                                        clicks: {
                                                            name: 'Clicks'
                                                        },
                                                        impression: {
                                                            name: 'Impressions'
                                                        }                                             
                                                    },  
                                                    applyData: 'clicks',
                                                    values:{} 
                                                }
                                            });
                                        }
                                        else 
                                        {

                                            //INDIA
                                            var clickIndia = data.map((c)=>{
                                            if(c.countrycode == "IN"){
                                                var clicksIN = [];
                                                clicksIN.push(c.clicks)
                                            } 
                                                return clicksIN
                                            })
                                            console.log("clickIndia",clickIndia)                                 

                                            let sumofclicksIndia = clickIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofclicksIndia",sumofclicksIndia) 

                                            var impressionsIndia = data.map((c)=>{
                                                if(c.countrycode == "IN"){
                                                    var impressionsIN = [];
                                                    impressionsIN.push(c.impressions)
                                                }
                                                return impressionsIN
                                            })
                                            console.log("impressionsIndia",impressionsIndia)

                                            let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofimpressionsIndia",sumofimpressionsIndia) 
                                            
                                            //United States
                                            var clickUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var clicksUS = [];
                                                    clicksUS.push(c.clicks)
                                                } 
                                                return clicksUS
                                            })
                                            console.log("clickUs",clickUs)                                 

                                            let sumofclicksUs = clickUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofclicksUs",sumofclicksUs) 

                                            var impressionsUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var impressionsUS = [];
                                                    impressionsUS.push(c.impressions)
                                                }
                                                return impressionsUS
                                            })
                                            console.log("impressionsUs",impressionsUs)

                                            let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofimpressionsUs",sumofimpressionsUs) 

                                            //German
                                            var clickDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var clicksDE = [];
                                                    clicksDE.push(c.clicks)
                                                } 
                                                return clicksDE
                                            })
                                            console.log("clickUs",clickDe)                                 

                                            let sumofclicksDe = clickDe.map(function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofclicksDe",sumofclicksDe) 

                                            var impressionsDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var impressionsDE = [];
                                                    impressionsDE.push(c.impressions)
                                                }
                                                return impressionsDE
                                            })
                                            console.log("impressionsDe",impressionsDe)

                                            let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });
                                            console.log("sumofimpressionsDe",sumofimpressionsDe) 

                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                    return c.countrycode
                                            })                                  
                                            console.log("countrycode",countrycode)

                                            const uniqueArr = countrycode.filter((c, index) => {
                                                return countrycode.indexOf(c) === index;
                                            });
                                            console.log("uniqueArr",uniqueArr);

                                            var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                            var DE = uniqueArr.includes("DE") ? DE ="DE" : ""
                                            var US = uniqueArr.includes("US") ? US ="US" : ""

                                            console.log("IN",IN);
                                            console.log("DE",DE);
                                            console.log("US",US);
                                            console.log("filtervalue",filtervalue)
                                        
                                            //map

                                            new svgMap({                        
                                                    targetElementID: 'svgMapAllstatistics',
                                                    colorMin: '#03a9f4',
                                                    colorMax: '#03a9f4',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            DE : {
                                                                clicks: sumofclicksDe, 
                                                                impression: sumofimpressionsDe
                                                            }, 
                                                            IN : {                                                    
                                                                clicks: sumofclicksIndia, 
                                                                impression: sumofimpressionsIndia
                                                            },    
                                                            US : {
                                                                clicks: sumofclicksUs, 
                                                                impression: sumofimpressionsUs
                                                            }                                                
                                                                                    
                                                        } 
                                                    }
                                            });

                                            if (countryValue == 'country' || countryValue == '') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'total_revenue' },
													{ data: 'ecpm' },
													
												],
												});
                                                
                                            }
                                            else if (countryValue == 'region') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">Spend</th>
                                                                    <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'region' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'ecpm' },
													{ data: 'total_revenue' },
												],
												});
                                              
                                            }
                                            else if (countryValue == 'city') {
                                                var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">Spend</th>
                                                                        <th class="text-center">ECPM</th>
                                                                </tr>`;
                                                document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                data.map((data) => {
                                                    getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                        </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
												$('#georep').DataTable({
												"ordering": true,
												"destroy": true,
												data: data,
												columns: [
													{ data: 'country' },
													{ data: 'city' },
													{ data: 'campaignname' },
													{ data: 'impressions' },
													{ data: 'clicks' },
													{ data: 'ctr' },
													{ data: 'ecpm' },
													{ data: 'total_revenue' },
												],
												});
                                              
                                            }
                                            else {
                                                console.log("geo is Not working");
                                            }
                                        }                                
                                    
                                    }
                                });
                            }
                            else if (filtervalue == 'custom') {
                                $("#daterange").css("display", "block");

                                $(document).on('change', '#daterange', function () {
                                    var dates = $('#daterange').val();
                                    const daterange = dates.split("-");
                                });
                                $(function () {
                                    $('input[name="daterange"]').daterangepicker({
                                        opens: 'left'
                                    }, function (start, end, label) {
                                        // console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
                                        var start_date = start.format('YYYY-MM-DD'), end_date = end.format('YYYY-MM-DD');

                                        $.ajax({
                                            url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                                            type: 'GET',
                                            beforeSend: function (xhr) {
                                                xhr.setRequestHeader('Authorization', token);
                                            },
                                            data: {},
                                            success: function (data) {
                                                console.log("geo data", data.msg);
                                                if (data.msg == 'No Stats Available') {
                                                    let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                                                    document.getElementById('geo_table').innerHTML = stat_msg;
                                                }
                                                else {
                                                     //INDIA
                                            var clickIndia = data.map((c)=>{
                                            if(c.countrycode == "IN"){
                                                var clicksIN = [];
                                                clicksIN.push(c.clicks)
                                            } 
                                                return clicksIN
                                            })
                                            console.log("clickIndia",clickIndia)                                 

                                            let sumofclicksIndia = clickIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksIndia",sumofclicksIndia) 

                                            var impressionsIndia = data.map((c)=>{
                                                if(c.countrycode == "IN"){
                                                    var impressionsIN = [];
                                                    impressionsIN.push(c.impressions)
                                                }
                                                return impressionsIN
                                            })
                                            console.log("impressionsIndia",impressionsIndia)

                                            let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                            return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsIndia",sumofimpressionsIndia) 


                                            
                                            //United States
                                            var clickUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var clicksUS = [];
                                                    clicksUS.push(c.clicks)
                                                } 
                                                return clicksUS
                                            })
                                            console.log("clickUs",clickUs)                                 

                                            let sumofclicksUs = clickUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksUs",sumofclicksUs) 

                                            var impressionsUs = data.map((c)=>{
                                                if(c.countrycode == "US"){
                                                    var impressionsUS = [];
                                                    impressionsUS.push(c.impressions)
                                                }
                                                return impressionsUS
                                            })
                                            console.log("impressionsUs",impressionsUs)

                                            let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsUs",sumofimpressionsUs) 


                                            //German
                                            var clickDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var clicksDE = [];
                                                    clicksDE.push(c.clicks)
                                                } 
                                                return clicksDE
                                            })
                                            console.log("clickUs",clickDe)                                 

                                            let sumofclicksDe = clickDe.map(function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofclicksDe",sumofclicksDe) 

                                            var impressionsDe = data.map((c)=>{
                                                if(c.countrycode == "DE"){
                                                    var impressionsDE = [];
                                                    impressionsDE.push(c.impressions)
                                                }
                                                return impressionsDE
                                            })
                                            console.log("impressionsDe",impressionsDe)

                                            let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                                return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                            })
                                            .reduce((a, b) => {
                                                return a + b;
                                            });

                                            console.log("sumofimpressionsDe",sumofimpressionsDe) 


                                            //countrycode

                                            var countrycode = data.map((c)=>{
                                                    return c.countrycode
                                            })                                  

                                            console.log("countrycode",countrycode)

                                            const uniqueArr = countrycode.filter((c, index) => {
                                                return countrycode.indexOf(c) === index;
                                            });
                                        
                                            console.log("uniqueArr",uniqueArr);

                                            var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                            var DE = uniqueArr.includes("DE") ? DE ="DE" : ""
                                            var US = uniqueArr.includes("US") ? US ="US" : ""


                                            console.log("IN",IN);
                                            console.log("DE",DE);
                                            console.log("US",US);

                                            console.log("filtervalue",filtervalue);


                                            new svgMap({                        
                                                    targetElementID: 'svgMapAllstatistics',
                                                    colorMin: '#03a9f4',
                                                    colorMax: '#03a9f4',
                                                    data: {
                                                        data: {
                                                            clicks: {
                                                                name: 'Clicks'
                                                            },
                                                            impression: {
                                                                name: 'Impressions'
                                                            }                                             
                                                        },  
                                                        applyData: 'clicks',
                                                        values:
                                                        {                                               
                                                            DE : {
                                                                clicks: sumofclicksDe, 
                                                                impression: sumofimpressionsDe
                                                            }, 
                                                            IN : {                                                    
                                                                clicks: sumofclicksIndia, 
                                                                impression: sumofimpressionsIndia
                                                            },    
                                                            US : {
                                                                clicks: sumofclicksUs, 
                                                                impression: sumofimpressionsUs
                                                            }                                                
                                                                                    
                                                        } 
                                                    }
                                                });

                                                    if (countryValue == 'country' || countryValue == '') {
                                                        var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    <th class="text-center">Revenue</th>
                                                                    </tr>`;
                                                        document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                        data.map((data) => {
                                                            getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                        </tr>`
                                                        });
                                                        document.getElementById('geo_table').innerHTML = getBanData;
														$('#georep').DataTable({
														"ordering": true,
														"destroy": true,
														data: data,
														columns: [
															{ data: 'country' },
															{ data: 'campaignname' },
															{ data: 'impressions' },
															{ data: 'clicks' },
															{ data: 'ctr' },
															{ data: 'ecpm' },
															{ data: 'total_revenue' },
														],
														});

                                                    
                                                    }
                                                    else if (countryValue == 'region') {
                                                        var getGeoDataHead = `<tr class="text-dark">
                                                                    <th class="text-start">Country</th>
                                                                    <th class="text-start">Region</th>
                                                                    <th class="text-start">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <!--<th class="text-center">Conversion</th>-->
                                                                    <th class="text-center">CTR %</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    <th class="text-center">Revenue</th>
                                                                </tr>`;
                                                        document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                        data.map((data) => {
                                                            getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.region}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                        </tr>`
                                                        });
                                                        document.getElementById('geo_table').innerHTML = getBanData;
														$('#georep').DataTable({
														"ordering": true,
														"destroy": true,
														data: data,
														columns: [
															{ data: 'country' },
															{ data: 'region' },
															{ data: 'campaignname' },
															{ data: 'impressions' },
															{ data: 'clicks' },
															{ data: 'ctr' },
															{ data: 'ecpm' },
															{ data: 'total_revenue' },
														],
														});
                                                   
                                                    }
                                                    else if (countryValue == 'city') {
                                                        var getGeoDataHead = `<tr class="text-dark">
                                                                        <th class="text-start">Country</th>
                                                                        <th class="text-start">City's</th>
                                                                        <th class="text-start">Campaign</th>
                                                                        <th class="text-center">Impression</th>
                                                                        <th class="text-center">clicks</th>
                                                                        <!--<th class="text-center">Conversion</th>-->
                                                                        <th class="text-center">CTR %</th>
                                                                        <th class="text-center">ECPM</th>
                                                                        <th class="text-center">Revenue</th>
                                                                </tr>`;
                                                        document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                                        data.map((data) => {
                                                            getBanData += `<tr class="text-dark">
                                                            <td class="text-start">${data.country}</td>
                                                            <td class="text-start">${data.city}</td>
                                                            <td class="text-start">${data.campaignname}</td>
                                                            <td class="text-center">${data.impressions}</td>
                                                            <td class="text-center">${data.clicks}</td>
                                                            <!--<td class="text-center">${data.conversions}</td>-->
                                                            <td class="text-center">${data.ctr} %</td>
                                                            <td class="text-center">${data.ecpm}</td>
                                                            <td class="text-center">${data.total_revenue}</td>
                                                        </tr>`
                                                        });
                                                        document.getElementById('geo_table').innerHTML = getBanData;
														$('#georep').DataTable({
														"ordering": true,
														"destroy": true,
														data: data,
														columns: [
															{ data: 'country' },
															{ data: 'city' },
															{ data: 'campaignname' },
															{ data: 'impressions' },
															{ data: 'clicks' },
															{ data: 'ctr' },
															{ data: 'ecpm' },
															{ data: 'total_revenue' },
														],
														});
                                                   
                                                    }
                                                    else {
                                                        console.log("geo is Not working");
                                                    }
                                                }
                                            },
                                            error: function () { },
                                        });
                                    });
                                })
                            }

                            // if (filtervalue == "Today" || filtervalue == 'Yesterday' || filtervalue == 'Last 7 days' ||
                            //     filtervalue == 'Last 30 days' || filtervalue == 'This Month' || filtervalue == 'Last Month') {
                            //     $.ajax({
                            //         url: live_URL + '/get_georeport_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                            //         type: 'GET',
                            //         beforeSend: function (xhr) {
                            //             xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                            //         },
                            //         data: {},
                            //         success: function (data) {
                            //             console.log("geo data", data);
                            //             if (data.msg == 'No Stats Available') {
                            //                 let stat_msg = `<h5 class="text-primary mt-3">No Data Found</h5>`
                            //                 document.getElementById('geo_table').innerHTML = stat_msg;
                            //             }
                            //             else {
                            //                 if (countryValue == 'country' || countryValue == '') {
                            //                     var getGeoDataHead = `<tr class="text-dark">
                            //                                         <th class="text-start">Country</th>
                            //                                         <th class="text-center">Campaign</th>
                            //                                         <th class="text-center">Impression</th>
                            //                                         <th class="text-center">clicks</th>
                            //                                         <th class="text-center">Conversion</th>
                            //                                         <th class="text-center">CTR %</th>
                            //                                         <th class="text-center">ECPM</th>
                            //                                         <th class="text-center">Revenue</th>
                            //                                         </tr>`;
                            //                     document.getElementById('geo_head').innerHTML = getGeoDataHead;

                            //                     data.map((data) => {
                            //                         getBanData += `<tr class="text-dark">
                            //                                 <td class="text-start">${data.country}</td>
                            //                                 <td class="text-center">${data.campaignname}</td>
                            //                                 <td class="text-center">${data.impressions}</td>
                            //                                 <td class="text-center">${data.clicks}</td>
                            //                                 <td class="text-center">${data.conversions}</td>
                            //                                 <td class="text-center">${data.ctr} %</td>
                            //                                 <td class="text-center">${data.ecpm}</td>
                            //                                 <td class="text-center">${data.total_revenue}</td>
                            //                             </tr>`
                            //                     });
                            //                     document.getElementById('geo_table').innerHTML = getBanData;
							// 					$('#georep').DataTable({
							// 					"ordering": true,
							// 					"destroy": true,
							// 					data: data,
							// 					columns: [
							// 						{ data: 'country' },
							// 						{ data: 'campaignname' },
							// 						{ data: 'impressions' },
							// 						{ data: 'clicks' },
							// 						{ data: 'conversions' },
							// 						{ data: 'ctr' },
							// 						{ data: 'ecpm' },
							// 						{ data: 'total_revenue' },
							// 					],
							// 					});
                            //                 }
                            //                 else if (countryValue == 'region') {
                            //                     var getGeoDataHead = `<tr class="text-dark">
                            //                                         <th class="text-start">Country</th>
                            //                                         <th class="text-center">Region</th>
                            //                                         <th class="text-center">Campaign</th>
                            //                                         <th class="text-center">Impression</th>
                            //                                         <th class="text-center">clicks</th>
                            //                                         <th class="text-center">Conversion</th>
                            //                                         <th class="text-center">CTR %</th>
                            //                                         <th class="text-center">ECPM</th>
                            //                                         <th class="text-center">Revenue</th>
                            //                                     </tr>`;
                            //                     document.getElementById('geo_head').innerHTML = getGeoDataHead;

                            //                     data.map((data) => {
                            //                         getBanData += `<tr class="text-dark">
                            //                                 <td class="text-start">${data.country}</td>
                            //                                 <td class="text-center">${data.region}</td>
                            //                                 <td class="text-center">${data.campaignname}</td>
                            //                                 <td class="text-center">${data.impressions}</td>
                            //                                 <td class="text-center">${data.clicks}</td>
                            //                                 <td class="text-center">${data.conversions}</td>
                            //                                 <td class="text-center">${data.ctr} %</td>
                            //                                 <td class="text-center">${data.ecpm}</td>
                            //                                 <td class="text-center">${data.total_revenue}</td>
                            //                             </tr>`
                            //                     });
                            //                     document.getElementById('geo_table').innerHTML = getBanData;
							// 					$('#georep').DataTable({
							// 					"ordering": true,
							// 					"destroy": true,
							// 					data: data,
							// 					columns: [
							// 						{ data: 'country' },
							// 						{ data: 'region' },
							// 						{ data: 'campaignname' },
							// 						{ data: 'impressions' },
							// 						{ data: 'clicks' },
							// 						{ data: 'conversions' },
							// 						{ data: 'ctr' },
							// 						{ data: 'ecpm' },
							// 						{ data: 'total_revenue' },
							// 					],
							// 					});
                            //                 }
                            //                 else if (countryValue == 'city') {
                            //                     var getGeoDataHead = `<tr class="text-dark">
                            //                                             <th class="text-start">Country</th>
                            //                                             <th class="text-center">Cities</th>
                            //                                             <th class="text-center">Campaign</th>
                            //                                             <th class="text-center">Impression</th>
                            //                                             <th class="text-center">clicks</th>
                            //                                             <th class="text-center">Conversion</th>
                            //                                             <th class="text-center">CTR %</th>
                            //                                             <th class="text-center">ECPM</th>
                            //                                             <th class="text-center">Revenue</th>
                            //                                     </tr>`;
                            //                     document.getElementById('geo_head').innerHTML = getGeoDataHead;

                            //                     data.map((data) => {
                            //                         getBanData += `<tr class="text-dark">
                            //                                 <td class="text-start">${data.country}</td>
                            //                                 <td class="text-center">${data.city}</td>
                            //                                 <td>${data.campaignname}</td>
                            //                                 <td class="text-center">${data.impressions}</td>
                            //                                 <td class="text-center">${data.clicks}</td>
                            //                                 <td class="text-center">${data.conversions}</td>
                            //                                 <td class="text-center">${data.ctr} %</td>
                            //                                 <td class="text-center">${data.ecpm}</td>
                            //                                 <td class="text-center">${data.total_revenue}</td>
                            //                             </tr>`
                            //                     });
                            //                     document.getElementById('geo_table').innerHTML = getBanData;
							// 					$('#georep').DataTable({
							// 					"ordering": true,
							// 					"destroy": true,
							// 					data: data,
							// 					columns: [
							// 						{ data: 'country' },
							// 						{ data: 'city' },
							// 						{ data: 'campaignname' },
							// 						{ data: 'impressions' },
							// 						{ data: 'clicks' },
							// 						{ data: 'conversions' },
							// 						{ data: 'ctr' },
							// 						{ data: 'ecpm' },
							// 						{ data: 'total_revenue' },
							// 					],
							// 					});
                            //                 }
                            //                 else {
                            //                     console.log("geo is Not working");
                            //                 }
                            //             }
                            //         },
                            //         error: function () { },
                            //     });
                            // }
                    };

                </script>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>
<!--<script>
    $(function () {
        $("#example1").DataTable({
            "responsive": true, "lengthChange": false, "autoWidth": false,
            "buttons": ["excel", "csv", "pdf", "colvis"]
        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        $('#example2').DataTable({ //"copy", "print"
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
        });
    });
</script>-->

</html>