<?php 
	include('session.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Adserver - GEO | Report </title>

    <meta name="description" content="" />
    <style>
        .text-hide {
            display: block;
            width: 125px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: inherit;
            width: auto;
        }
    </style>

    <?php include('head.php'); ?>

    <link href="https://code.jquery.com/ui/1.10.4/themes/ui-lightness/jquery-ui.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-1.12.4.min.js"></script>
    <script src="https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>




    <script src="https://cdn.jsdelivr.net/npm/svg-pan-zoom@3.6.1/dist/svg-pan-zoom.min.js"></script>
    <script src="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.js"></script>
    <link href="https://cdn.jsdelivr.net/gh/StephanWagner/svgMap@v2.7.2/dist/svgMap.min.css" rel="stylesheet">
    

     <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.min.js"></script> 
     -->
    
    <!-- <script>
        function showDate() {
            var selectDate = document.getElementById("custom");
            if (selectDate.style.display !== 'none') {
                selectDate.style.display = 'none'
            }
            else {
                selectDate.style.display = 'block'
            }
        }
    </script> -->
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
</head>

<style>
    .svgMap-map-wrapper {
        background: #708092 !important;
    }
</style>

<body onload="getGeoDetails()">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3">
                            <div class="card-body">
                                <div class='row'>
                                    <div class='col-6'>
                                        <h4 class="mb-4">Geo Report</h4>
                                    </div>
                                    <div class="col-3">
                                        <select class="form-select" aria-label="Default select example"
                                            onchange='getZone(this.value, start_date="2023-03-08", end_date="2023-03-08")'>
                                            <option selected>Select value</option>
                                            <option value="country">Country</option>
                                            <option value="region">Region</option>
                                            <option value="city">City</option>
                                        </select>
                                    </div>
                                    <div class='col-3'>
                                        <select id="allfilter" name="allfilter" class="form-select"
                                            aria-label="Default select example" onchange="onChangeDetails(this.value)">
                                            <option selected>Select Duration</option>
                                            <option value="Today" >Today</option>
                                            <option value="Yesterday">Yesterday</option>
                                            <option value="Last 7 days">Last 7 days</option>
                                            <option value="Last 30 days">Last 30 days</option>
                                            <option value="This Month">This Month</option>
                                            <option value="Last Month">Last Month</option>
                                            <!-- <option value='all statistics'>All Statistics</option> -->
                                            <option value="custom">Custom</option>
                                        </select>
                                        <input style="display: none;" id="daterange" name="daterange"
                                            value="02/01/2023 - 02/15/2023" />
                                    </div>
                                </div>
                                <br />


                                <div class="row">
                                    <div id="svgMap"></div>
                                </div>
                              

                              
                                <!-- <div>
                                    <canvas id="myChart"></canvas>
                                </div> -->


                                <div class="row mt-5">
                                    <div class="mt-1 mb-3 container">
                                        <div class="table-responsive text-nowrap">
                                            <table id="example2" class="table table-hover">
                                                <thead id='geo_head'>
                                                    <tr class="text-nowrap">
                                                        <th class="thauth-login-basic.html-color">Country</th>
                                                        <th class="th-color">Campaign</th>
                                                        <th class="th-color">Impression</th>
                                                        <th class="th-color">Clicks</th>
                                                        <th class="th-color">CTR</th>
                                                        <th class="th-color">ECPM</th>
                                                        <th class="th-color">Revenue</th>
                                                        <!-- <th class="th-color">Action</th> -->
                                                    </tr>
                                                </thead>
                                                <tbody id='geo_table'></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>
                <!-- / Content -->

                <!-- Footer -->
                <?php include('footer.php'); ?>
                <!-- / Footer -->
                <script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>
                <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
                <script type="text/javascript"
                    src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
                <script>



                    var mapdata = [];

                    function getGeoDetails() {
                        const date = new Date();
                        let v3 = JSON.stringify(date);
                        v3 = v3.slice(1, 11);
                        var start_date = v3, end_date = v3;

                        $.ajax({
                            url: 'http://43.204.47.201/revivemohan/adservernew/api/revive_stat/get_georeport_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,19',
                            type: 'GET',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                            },
                            data: {},                            
                            success: function (data) {   
                                // console.log("geo data", data);
                                if (data.msg == 'No Stats Available') {
                                    let stat_msg = `<h5 class="text-primary mt-3">No Data</h5>`
                                    document.getElementById('geo_table').innerHTML = stat_msg;
                                }
                                else {                                    
                                    var getBanData = data.map((data) => {
                                        return `<tr>
                                    <td>${data.country}</td>
                                    <td class="text-hide">${data.campaignname}</td>
                                    <td>${data.impressions}</td>
                                    <td>${data.clicks}</td>
                                    <td>${data.ctr}</td>
                                    <td>${data.ecpm}</td>
                                    <td>${data.total_revenue}</td>
                                </tr>`
                                    });
                                    document.getElementById('geo_table').innerHTML = getBanData;
                                   
                                }
                            },
                            error: function () { },
                        });
                    };

                    function onChangeDetails(filtervalue) {
                        const live_URL = 'http://43.204.47.201/revivemohan/adservernew/api/revive_stat';
                        const date = new Date();
                        var allfilter = $('#allfilter').val();
                        if (filtervalue == 'Today') {
                            let v3 = JSON.stringify(date);
                            v3 = v3.slice(1, 11);
                            var start_date = v3, end_date = v3;
                            // getZone(countryValue = "country", start_date, end_date)                           
                        }
                        else if (filtervalue == 'Yesterday') {
                            let current_date = date.setDate(date.getDate() - 1);
                            const get_date = new Date(date);
                            let yesterday_date = JSON.stringify(get_date);
                            yesterday_date = yesterday_date.slice(1, 11);
                            var start_date = yesterday_date, end_date = yesterday_date;
                            if (allfilter == 'Yesterday') {
                                $("#daterange").css("display", "none");
                            }
                        }
                        else if (filtervalue == 'Last 7 days') {
                            let date_start = date.setDate(date.getDate() - 7);
                            let get_date = new Date(date_start);
                            let first_day = JSON.stringify(get_date);
                            first_day = first_day.slice(1, 11);

                            let current_date = new Date();
                            let date_end = JSON.stringify(current_date);
                            date_end = date_end.slice(1, 11);
                            var start_date = first_day, end_date = date_end;
                            if (allfilter == 'Last 7 days') {
                                $("#daterange").css("display", "none");
                            }
                           
                        }
                        else if (filtervalue == 'Last 30 days') {
                            let date_start = date.setDate(date.getDate() - 30);
                            let get_date = new Date(date_start);
                            var first_day = JSON.stringify(get_date);
                            first_day = first_day.slice(1, 11);

                            const current_date = new Date();
                            let date_end = JSON.stringify(current_date);
                            date_end = date_end.slice(1, 11);
                            var start_date = first_day, end_date = date_end;
                            if (allfilter == 'Last 30 days') {
                                $("#daterange").css("display", "none");
                            }
                        }
                        else if (filtervalue == 'This Month') {
                            let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                            let cDate = firstDay.getDate(), cMonth = firstDay.getMonth() + 1, cYear = firstDay.getFullYear();
                            let first_day = cYear + "-" + cMonth + "-" + cDate;

                            const current_date = new Date();
                            let date_end = JSON.stringify(current_date);
                            date_end = date_end.slice(1, 11);
                            var start_date = first_day, end_date = date_end;
                            // console.log("date", date_end);
                            if (allfilter == 'This Month') {
                                $("#daterange").css("display", "none");
                            }
                        }
                        else if (filtervalue == 'Last Month') {
                            var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                            var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                            var formatDateComponent = function (dateComponent) {
                                return (dateComponent < 10 ? '0' : '') + dateComponent;
                            }
                            var formatDate = function (date) {
                                return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                            };
                            var start_date = formatDate(prevMonthFirstDate),
                                end_date = formatDate(prevMonthLastDate);
                            if (allfilter == 'Last Month') {
                                $("#daterange").css("display", "none");
                            }
                        }                       
                        else if (filtervalue == 'custom') {
                            if (allfilter == 'custom') {
                                $("#daterange").css("display", "block");
                            }
                            $(document).on('change', '#daterange', function () {
                                var dates = $('#daterange').val();
                                const daterange = dates.split("-");
                            });
                            $(function () {
                                $('input[name="daterange"]').daterangepicker({
                                    opens: 'left'
                                }, function (start, end, label) {
                                    console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
                                    var start_date = start.format('YYYY-MM-DD'), end_date = end.format('YYYY-MM-DD');

                                    $.ajax({
                                        url: live_URL + '/get_georeport_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,19',
                                        type: 'GET',
                                        beforeSend: function (xhr) {
                                            xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                                        },
                                        data: {},
                                        success: function (data) {

                                            console.log("geo data", data.msg);                                          

                                            if (data.msg == 'No Stats Available') {
                                                let stat_msg = `<h5 class="text-primary mt-3">No Data</h5>`
                                                document.getElementById('geo_table').innerHTML = stat_msg;
                                            }
                                            else {
                                                var getBanData = data.map((data) => {
                                                    return `<tr>
                                                                <td>${data.country}</td>
                                                                <td class="text-hide">${data.campaignname}</td>
                                                                <td>${data.impressions}</td>
                                                                <td>${data.clicks}</td>
                                                                <td>${data.ctr}</td>
                                                                <td>${data.ecpm}</td>
                                                                <td>${data.total_revenue}</td>
                                                            </tr>`
                                                });
                                                document.getElementById('geo_table').innerHTML = getBanData;
                                            }
                                        },
                                        error: function () { },
                                    });
                                });
                            })
                        }

                             $.ajax({
                                url: live_URL + '/get_georeport_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,19',
                                type: 'GET',
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                                },
                                data: {},
                                success: function (data) {  
                                    console.log("map data1", data);                                

                                //INDIA
                                    var clickIndia = data.map((c)=>{
                                        if(c.countrycode == "IN"){
                                            var clicksIN = [];
                                            clicksIN.push(c.clicks)
                                        } 
                                        return clicksIN
                                    })
                                    console.log("clickIndia",clickIndia)                                 

                                    let sumofclicksIndia = clickIndia.map( function(elt){ 
                                    return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                    })
                                    .reduce((a, b) => {
                                        return a + b;
                                    });

                                    console.log("sumofclicksIndia",sumofclicksIndia) 

                                    var impressionsIndia = data.map((c)=>{
                                        if(c.countrycode == "IN"){
                                            var impressionsIN = [];
                                            impressionsIN.push(c.impressions)
                                        }
                                        return impressionsIN
                                    })
                                    console.log("impressionsIndia",impressionsIndia)

                                    let sumofimpressionsIndia = impressionsIndia.map( function(elt){ 
                                    return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                    })
                                    .reduce((a, b) => {
                                        return a + b;
                                    });

                                    console.log("sumofimpressionsIndia",sumofimpressionsIndia) 


                                //United States
                                    var clickUs = data.map((c)=>{
                                        if(c.countrycode == "US"){
                                            var clicksUS = [];
                                            clicksUS.push(c.clicks)
                                        } 
                                        return clicksUS
                                    })
                                    console.log("clickUs",clickUs)                                 

                                    let sumofclicksUs = clickUs.map( function(elt){ 
                                        return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                    })
                                    .reduce((a, b) => {
                                        return a + b;
                                    });

                                    console.log("sumofclicksUs",sumofclicksUs) 

                                    var impressionsUs = data.map((c)=>{
                                        if(c.countrycode == "US"){
                                            var impressionsUS = [];
                                            impressionsUS.push(c.impressions)
                                        }
                                        return impressionsUS
                                    })
                                    console.log("impressionsUs",impressionsUs)

                                    let sumofimpressionsUs = impressionsUs.map( function(elt){ 
                                        return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                    })
                                    .reduce((a, b) => {
                                        return a + b;
                                    });

                                    console.log("sumofimpressionsUs",sumofimpressionsUs) 


                                //German
                                    var clickDe = data.map((c)=>{
                                        if(c.countrycode == "DE"){
                                            var clicksDE = [];
                                            clicksDE.push(c.clicks)
                                        } 
                                        return clicksDE
                                    })
                                    console.log("clickUs",clickDe)                                 

                                    let sumofclicksDe = clickDe.map( function(elt){ 
                                        return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                    })
                                    .reduce((a, b) => {
                                        return a + b;
                                    });

                                    console.log("sumofclicksDe",sumofclicksDe) 

                                    var impressionsDe = data.map((c)=>{
                                        if(c.countrycode == "DE"){
                                            var impressionsDE = [];
                                            impressionsDE.push(c.impressions)
                                        }
                                        return impressionsDE
                                    })
                                    console.log("impressionsDe",impressionsDe)

                                    let sumofimpressionsDe = impressionsDe.map( function(elt){ 
                                        return /^\d+$/.test(elt) ? parseInt(elt) : 0; 
                                    })
                                    .reduce((a, b) => {
                                        return a + b;
                                    });

                                    console.log("sumofimpressionsDe",sumofimpressionsDe) 


                                //countrycode

                                    var countrycode = data.map((c)=>{
                                            return c.countrycode
                                    })                                  

                                    console.log("countrycode",countrycode)

                                    const uniqueArr = countrycode.filter((c, index) => {
                                        return countrycode.indexOf(c) === index;
                                    });
                                  
                                    console.log("uniqueArr",uniqueArr);

                                    var IN = uniqueArr.includes("IN") ? IN ="IN" : ""
                                    var DE = uniqueArr.includes("DE") ? IN ="DE" : ""
                                    var US = uniqueArr.includes("US") ? IN ="US" : ""


                                    console.log("IN",IN);
                                    console.log("DE",DE);
                                    console.log("US",US);

                                    console.log("filtervalue",filtervalue)
                                   
                                    
                                    new svgMap({                        
                                            targetElementID: 'svgMap',
                                            data: {
                                                data: {
                                                    clicks: {
                                                        name: 'Clicks'
                                                    },
                                                    impression: {
                                                        name: 'Impressions'
                                                    }                                             
                                                },  
                                                applyData: 'clicks',
                                                values: allfilter === "Today" ?
                                                {                                               
                                                                                                       
                                                                              
                                                } : {
                                                    DE : {
                                                        clicks: sumofclicksDe, 
                                                        impression: sumofimpressionsDe
                                                    }, 
                                                    IN : {                                                    
                                                        clicks: sumofclicksIndia, 
                                                        impression: sumofimpressionsIndia
                                                    },    
                                                    US : {
                                                        clicks: sumofclicksUs, 
                                                        impression: sumofimpressionsUs
                                                    }       
                                                }
                                            }
                                        });

                                        const myTimeout = setTimeout(onChangeDetails, 5000);
                                      
                                        clearTimeout(myTimeout);

                                    console.log("geo data", data.msg);

                                    if (data.msg == 'No Stats Available') {
                                        let stat_msg = `<h5 class="text-primary mt-3">No Data</h5>`
                                        document.getElementById('geo_table').innerHTML = stat_msg;
                                    }

                                    else {
                                        var getBanData = data.map((data) => {
                                            return `<tr>
                                                        <td>${data.country}</td>
                                                        <td class="text-hide">${data.campaignname}</td>
                                                        <td>${data.impressions}</td>
                                                        <td>${data.clicks}</td>
                                                        <td>${data.ctr}</td>
                                                        <td>${data.ecpm}</td>
                                                        <td>${data.total_revenue}</td>
                                                    </tr>`
                                        });
                                        document.getElementById('geo_table').innerHTML = getBanData;
                                    }
                                },
                                error: function () { },
                            });
                          
                  
                    };


                   


                    function getZone(countryValue, start_date, end_date) {
                        // let start_date = start_date, end_date =end_date;
                        $.ajax({
                            url: 'http://43.204.47.201/revivemohan/adservernew/api/revive_stat/get_georeport_statistics/' + start_date + ' 00:00:00,' + end_date + ' 12:00:00,19',
                            type: 'GET',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
                            },
                            data: {},
                            success: function (data) {

                                console.log("geo data", data.msg);
                                
                                if (data.msg == 'No Stats Available') {
                                    let stat_msg = `<h5 class="text-primary mt-3">No Data</h5>`
                                    document.getElementById('geo_table').innerHTML = stat_msg;
                                }
                                else {
                                    if (countryValue == 'country') {
                                        var getGeoDataHead = `<tr>
                                                                   <th class="text-center">Country</th>
                                                                   <th class="text-center">Campaign</th>
                                                                   <th class="text-center">Impression</th>
                                                                   <th class="text-center">clicks</th>
                                                                   <th class="text-center">CTR</th>
                                                                   <th class="text-center">ECPM</th>
                                                                   <th class="text-center">Revenue</th>
                                                                </tr>`;
                                        document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                        var getBanData = data.map((data) => {
                                            return `<tr>
                                                        <td class="text-center">${data.country}</td>
                                                        <td class="text-hide">${data.campaignname}</td>
                                                        <td class="text-center">${data.impressions}</td>
                                                        <td class="text-center">${data.clicks}</td>
                                                        <td class="text-center">${data.ctr}</td>
                                                        <td class="text-center">${data.ecpm}</td>
                                                        <td class="text-center">${data.total_revenue}</td>
                                                    </tr>`
                                        });
                                        document.getElementById('geo_table').innerHTML = getBanData;
                                    }
                                    else if (countryValue == 'region') {
                                        var getGeoDataHead = `<tr>
                                                                <th class="text-center">Country</th>
                                                                <th class="text-center">Region</th>
                                                                <th class="text-center">Campaign</th>
                                                                <th class="text-center">Impression</th>
                                                                <th class="text-center">clicks</th>
                                                                <th class="text-center">CTR</th>
                                                                <th class="text-center">ECPM</th>
                                                                <th class="text-center">Revenue</th>
                                                            </tr>`;
                                        document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                        var getBanData = data.map((data) => {
                                            return `<tr>
                                                        <td class="text-center">${data.country}</td>
                                                        <td class="text-center">${data.region}</td>
                                                        <td class="text-hide">${data.campaignname}</td>
                                                        <td class="text-center">${data.impressions}</td>
                                                        <td class="text-center">${data.clicks}</td>
                                                        <td class="text-center">${data.ctr}</td>
                                                        <td class="text-center">${data.ecpm}</td>
                                                        <td class="text-center">${data.total_revenue}</td>
                                                    </tr>`
                                        });
                                        document.getElementById('geo_table').innerHTML = getBanData;
                                    }
                                    else if (countryValue == 'city') {
                                        var getGeoDataHead = `<tr>
                                                                    <th class="text-center">Country</th>
                                                                    <th class="text-center">Cities</th>
                                                                    <th class="text-center">Campaign</th>
                                                                    <th class="text-center">Impression</th>
                                                                    <th class="text-center">clicks</th>
                                                                    <th class="text-center">CTR</th>
                                                                    <th class="text-center">ECPM</th>
                                                                    <th class="text-center">Revenue</th>
                                                              </tr>`;
                                        document.getElementById('geo_head').innerHTML = getGeoDataHead;

                                        var getBanData = data.map((data) => {
                                            return `<tr>
                                                        <td class="text-center">${data.country}</td>
                                                        <td class="text-center">${data.city}</td>
                                                        <td class="text-hide">${data.campaignname}</td>
                                                        <td class="text-center">${data.impressions}</td>
                                                        <td class="text-center">${data.clicks}</td>
                                                        <td class="text-center">${data.ctr}</td>
                                                        <td class="text-center">${data.ecpm}</td>
                                                        <td class="text-center">${data.total_revenue}</td>
                                                    </tr>`
                                        });
                                        document.getElementById('geo_table').innerHTML = getBanData;
                                    }
                                    else {
                                        console.log("geo is Not working");
                                    }
                                }
                            },
                            error: function () { },
                        });
                    };

                    // function geomap(mapdata){                          
                    //     console.log("geomapdata", mapdata); 
                    // }    


                    // const datacounty = mapdata.map((d)=>{
                    //     d.countryname : {"clicks": d.clicks, "impression" : d.imp}
                    // })
                                      
                  
                   
                </script>
                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>
<script>
    $(function () {
        $("#example1").DataTable({
            "responsive": true, "lengthChange": false, "autoWidth": false,
            "buttons": ["excel", "csv", "pdf", "colvis"]
        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        $('#example2').DataTable({ //"copy", "print"
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
        });
    });
</script>





<script>
    //   var ctx = document.getElementById('myChart').getContext('2d');
    //   var myChart = new Chart(ctx, 
    //    {
    //       type: 'bar',
    //       data: {
    //         labels: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
    //         datasets: [{ 
    //             data: [86,114,106,106,107,111,133],
    //             label: "Total",
    //             borderColor: "rgb(62,149,205)",
    //             backgroundColor: "rgb(62,149,205,0.1)",
    //             borderWidth:2
    //           }, { 
    //             data: [70,90,44,60,83,90,100],
    //             label: "Accepted",
    //             borderColor: "rgb(60,186,159)",
    //             backgroundColor: "rgb(60,186,159,0.1)",
    //             borderWidth:2
    //           }, { 
    //             data: [10,21,60,44,17,21,17],
    //             label: "Pending",
    //             borderColor: "rgb(255,165,0)",
    //             backgroundColor:"rgb(255,165,0,0.1)",
    //             borderWidth:2
    //           }, { 
    //             data: [6,3,2,2,7,0,16],
    //             label: "Rejected",
    //             borderColor: "rgb(196,88,80)",
    //             backgroundColor:"rgb(196,88,80,0.1)",
    //             borderWidth:2
    //           }
    //         ]
    //       },
    //     });
    
</script>


<script>

// new svgMap({
    
//   targetElementID: 'svgMap',
//   data: {
//     data: {
//       clicks: {
//         name: 'Clicks',
//       },
//       impression: {
//         name: 'Impressions',
//       }
//     },  
//     applyData: 'clicks',
//     values: {
//       DZ: {clicks: 34, impression: 35},   
//       AT: {clicks: 35, impression: 36},
//       IN: {clicks: 33, impression: 37},
//       AU: {clicks: 32, impression: 31},
//     }
//   }
// });

</script>

</html>