<?php 
include('session.php'); ?>
<!DOCTYPE html>
<!-- beautify ignore:start -->
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="../assets/" data-template="vertical-menu-template-free">
  <head>
  <title>Adserver - Dashboard</title>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
  <meta name="description" content="" />

	<?php include('head.php'); ?>
	
	<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
	
	<script>
        var config = {
            type: 'line',
            data: {
                labels: ['January', 'February', 'March', 'April', 'May', 'June', 'July'],
                datasets: [{
                    label: 'Impression',
                    backgroundColor: window.chartColors.blue,
                    borderColor: window.chartColors.blue,
                    fill: false,
                    data: [
                        10,
                        100,
                        50,
                        150,
                        200,
                        75,
                        175
                        //randomScalingFactor(),
                        //randomScalingFactor(),
                        //randomScalingFactor(),
                        //randomScalingFactor(),
                        //randomScalingFactor(),
                        //randomScalingFactor(),
                        //randomScalingFactor()
                    ],
                },
                    // {
                    //     label: 'Clicks',
                    //     backgroundColor: window.chartColors.green,
                    //     borderColor: window.chartColors.green,
                    //     fill: false,
                    //     data: [
                    //         20,
                    //         80,
                    //         50,
                    //         120,
                    //         90,
                    //         150,
                    //         140
                    //     ],

                    // }, {
                    //     label: 'Convertion',
                    //     backgroundColor: window.chartColors.red,
                    //     borderColor: window.chartColors.red,
                    //     fill: false,
                    //     data: [
                    //         15,
                    //         25,
                    //         35,
                    //         45,
                    //         55,
                    //         65,
                    //         75
                    //     ],

                    // }, {
                    //     label: 'Spend',
                    //     backgroundColor: window.chartColors.purple,
                    //     borderColor: window.chartColors.purple,
                    //     fill: false,
                    //     data: [
                    //         25,
                    //         50,
                    //         75,
                    //         100,
                    //         125,
                    //         150,
                    //         175
                    //     ],

                    // }, {
                    //     label: 'CTR',
                    //     backgroundColor: window.chartColors.cyan,
                    //     borderColor: window.chartColors.cyan,
                    //     fill: false,
                    //     data: [
                    //         30,
                    //         60,
                    //         90,
                    //         120,
                    //         150,
                    //         180,
                    //         210
                    //     ],

                    // }, 
                    // {
                    //     label: 'ECPM',
                    //     backgroundColor: window.chartColors.yellow,
                    //     borderColor: window.chartColors.yellow,
                    //     fill: false,
                    //     data: [
                    //         50,
                    //         300,
                    //         100,
                    //         450,
                    //         150,
                    //         200,
                    //         300
                    //     ],

                    // }
                ]
            },
            options: {
                responsive: true,
                title: {
                    display: true,
                    text: 'Campaign - Chart'
                },
                scales: {
                    xAxes: [{
                        display: true,
                        scaleLabel: {
                            display: true,
                            //labelString: 'Date'
                        },

                    }],
                    yAxes: [{
                        display: true,
                        //type: 'logarithmic',
                        scaleLabel: {
                            display: true,
                            //labelString: 'Index Returns'
                        },
                        ticks: {
                            min: 0,
                            max: 500,

                            // forces step size to be 5 units
                            stepSize: 100
                        }
                    }]
                }
            }
        };

        window.onload = function () {
            var ctx = document.getElementById('canvas').getContext('2d');
            window.myLine = new Chart(ctx, config);
        };

        document.getElementById('randomizeData').addEventListener('click', function () {
            config.data.datasets.forEach(function (dataset) {
                dataset.data = dataset.data.map(function () {
                    return randomScalingFactor();
                });

            });

            window.myLine.update();
        });
    </script>
  <!--<script src="../assets/js/config.js"></script>-->
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <?php include('sidebar.php'); ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          <?php include('navbar.php'); ?>
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
                <div class="row">
                    <div class="col col-3 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                        <div class="d-flex justify-content-start">
                            <p class="h3">Dashboard</p>
                        </div>
                    </div>
                    <div class="col col-9 col-sm-12 col-md-8 col-lg-8 col-xl-8 col-xxl-8">
                        <div class="d-flex justify-content-end">
                            <div class="w-25 mb-3">
                                <select class="form-select" name="allfilter" id="allfilter" onchange="dash_filter(this.value)">
                                    <option selected>Today</option>
                                    <option value="Yesterday">Yesterday</option>
                                    <option value="Last Week">Last Week</option>
                                    <option value="Last Month">Last Month</option>
                                    <option value="This Month">This Month</option>
                                    <option value="Custom">Custom</option>
                                </select>
                                <input style="display: none;" id="daterange" name="daterange" value="01/01/2023 - 20/15/2023" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mt-1 d-flex justify-content-center">
                    <div class="col col-xs-12 col-sm-12 col-md-11 col-lg-7 col-xl-8 col-xxl-8">

                        <div class="col-12 col-lg-12 order-2 order-md-3 order-lg-2 mb-4">
                            <div class="card">
                              <div class="row row-bordered g-0">
                                <div class="col-md-12" >
                                    <div>
                                        <div class="row">
                                            <div class="col-4">
                                                <h5 class="card-header m-0 me-2 pb-3">Campaigns</h5>
                                            </div>
                                            <div class="col-8">
                                                <div class="d-flex justify-content-end">
                                                    <div class="w-50 mt-4" style="margin-right: 6%;">
                                                        <select class="form-select">
                                                            <option value="1" selected>Impression</option>
                                                            <option value="2">Clicks</option>
                                                            <option value="3">Conversion</option>
                                                            <option value="last month">Spend</option>
                                                            <option value="this month">CTR</option>
                                                            <option value="year">ECPM</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                      <div style="width:100%;">
                                          <div class="chartjs-size-monitor">
                                              <div class="chartjs-size-monitor-expand">
                                                  <div class=""></div>
                                              </div>
                                              <div class="chartjs-size-monitor-shrink">
                                                  <div class=""></div>
                                              </div>
                                          </div>
                                          <canvas id="canvas" style="display: block; width: 1379px; height: 689px;" width="1379" height="689" class="chartjs-render-monitor"></canvas>
                                          <p class="responsedata"></p>
                                        </div>
                                    </div>
                                </div>
                              </div>
                            </div>
                          </div>
                    </div>
                    <div class="col col-xs-12 col-sm-12 col-md-11 col-lg-5 col-xl-4 col-xxl-4">
                        <div class="row mb-2">
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card">
                                    <div class="card-body mt-2 text-center">
                                        <i class="fa  fa-podcast  fa-2x text-primary"  aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-info h5 mb-4">Request</span>
                                        <h3 class="card-title mb-2" id="req">00</h3>
                                        <small class="text-success fw-semibold">
                                            <i class="bx bx-up-arrow-alt"></i> +00.00%</small>
                                    </div>
                                  </div>
                            </div>
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card">
                                    <div class="card-body mt-2 text-center">
                                        <i class="fa  fa-external-link  fa-2x text-primary" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-info h5 mb-4">Impression</span>
                                        <h3 class="card-title text-nowrap mb-1" id="imp">00</h3>
                                        <small class="text-success fw-semibold">
                                            <i class="bx bx-up-arrow-alt"></i> +00.00%</small>
                                    </div>
                                  </div>
                            </div>
                        </div>
                        <div class="row mb-2">
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card">
                                    <div class="card-body mt-2 text-center">
                                        <i class="fa  fa-paper-plane-o  fa-2x text-primary" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-info h5 mb-4">Clicks</span>
                                        <h3 class="card-title text-nowrap mb-2" id="cli">00</h3>
                                        <small class="text-danger fw-semibold">
                                          <i class="bx bx-down-arrow-alt"></i> -00.00%</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card">
                                    <div class="card-body mt-2 text-center">
                                        <i class="fa  fa-credit-card-alt fa-2x text-primary" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-info h5 mb-4">Conversion</span>
                                        <h3 class="card-title mb-2" id="con">$ 00</h3>
                                        <small class="text-success fw-semibold"><i class="bx bx-up-arrow-alt"></i> +00.00%</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
                <div class="mt-3" >
                    <div class="row d-flex justify-content-center" style="margin-top: -10px;">
                        <div class="col col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="card mb-4">
                                <div class="card-body table-responsive">
                                    <p class="h4">Top Campaigns</p>
                                    <table class="table table-hover table-responsive table-borderless mt-3">
                                        <thead>
                                            <tr>
                                                <th >Name</th>
                                                <th class="text-center">Impression</th>
                                                <th class="text-center">Clicks</th>
                                                <th class="text-center">Spend</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-center">
                                            <tr>
                                                <td>campaign1</td>
                                                <td>2</td>
                                                <td>3</td>
                                                <td>5</td>
                                            </tr>
                                            <tr>
                                                <td>campaign2</td>
                                                <td>3</td>
                                                <td>4</td>
                                                <td>6</td>
                                            </tr>
                                            <tr>
                                                <td>campaign3</td>
                                                <td>4</td>
                                                <td>5</td>
                                                <td>7</td>
                                            </tr>
                                            <tr>
                                                <td>campaign4</td>
                                                <td>5</td>
                                                <td>6</td>
                                                <td>8</td>
                                            </tr>
                                            <tr>
                                                <td>campaign5</td>
                                                <td>6</td>
                                                <td>7</td>
                                                <td>9</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="card mb-4">
                                <div class="card-body table-responsive">
                                    <p class="h4">Top Banner</p>
                                    <table class="table table-hover table-borderless mt-3">
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th class="text-center">Impression</th>
                                                <th class="text-center">Clicks</th>
                                                <th class="text-center">Spend</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-center">
                                            <tr>
                                                <td>Banner1</td>
                                                <td>2</td>
                                                <td>3</td>
                                                <td>5</td>
                                            </tr>
                                            <tr>
                                                <td>Banner2</td>
                                                <td>3</td>
                                                <td>4</td>
                                                <td>6</td>
                                            </tr>
                                            <tr>
                                                <td>Banner3</td>
                                                <td>4</td>
                                                <td>5</td>
                                                <td>7</td>
                                            </tr>
                                            <tr>
                                                <td>Banner4</td>
                                                <td>5</td>
                                                <td>6</td>
                                                <td>8</td>
                                            </tr>
                                            <tr>
                                                <td>Banner5</td>
                                                <td>6</td>
                                                <td>7</td>
                                                <td>9</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card mb-4">
                        <div class="card-body table-responsive">
                            <div class="row">
                                <div class="col col-xs-12 col-sm-12 col-md-5 col-lg-6 col-xl-6 col-xxl-6">
                                    <p class="h4">Top Country</p>
                                    <table class="table table-hover table-borderless mt-3">
                                        <thead>
                                            <tr>
                                                <th class='text-center'>Name</th>
                                                <th class="text-center">Campaigns</th>
                                                <th class="text-center">Spend</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-center">
                                            <tr>
                                                <td>India</td>
                                                <td>2</td>
                                                <td>5</td>
                                            </tr>
                                            <tr>
                                                <td>USA</td>
                                                <td>3</td>
                                                <td>6</td>
                                            </tr>
                                            <tr>
                                                <td>UK</td>
                                                <td>4</td>
                                                <td>7</td>
                                            </tr>
                                            <tr>
                                                <td>Nepal</td>
                                                <td>5</td>
                                                <td>8</td>
                                            </tr>
                                            <tr>
                                                <td>Sri Lanks</td>
                                                <td>6</td>
                                                <td>9</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col col-xs-12 col-sm-12 col-md-7 col-lg-6 col-xl-6 col-xxl-6">
                                    <canvas id="myChart" style="width:100%;max-width:600px"></canvas>
                                    <script>
                                        var xValues = ["India", "USA", "UK", "Nepal", "Sri Lanks"];
                                        var yValues = [55, 49, 44, 24, 15];
                                        var barColors = [
                                            "#003f5c",
                                            "#58508d",
                                            "#bc5090",
                                            "#ff6361",
                                            "#ffa600"
                                        ];

                                        new Chart("myChart", {
                                            type: "pie",
                                            data: {
                                                labels: xValues,
                                                datasets: [{
                                                    backgroundColor: barColors,
                                                    data: yValues
                                                }]
                                            },
                                            options: {
                                                title: {
                                                    display: true,
                                                    text: "Country List"
                                                }
                                            }
                                        });
                                    </script>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- / Content -->
		<?php include('footer.php'); ?>

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>
	<script type="text/javascript" src="../assets/js/latest/jquery.min.js"></script>
    <script type="text/javascript" src="../assets/js/latest/moment.min.js"></script>
    <script type="text/javascript" src="../assets/js/daterangepicker.min.js"></script>
    <script>
	
	
	function dash_filter(filtervalue) 
	{
		//alert(filtervalue);
		if(filtervalue=='Today'){
		const date = new Date();
		let day = date.getDate();
		let month = date.getMonth() + 1;
		let year = date.getFullYear();
		let Today = `${year}-${month}-${day}`;
		var from_date = `${Today}`;
		var to_date = `${Today}`;
		//alert(from_date);
		}
		else if(filtervalue=='Yesterday')
		{
		const date = new Date();
		let yesterday = date.getDate() - 1;
		let day = date.getDate();
		let month = date.getMonth() + 1;
		let year = date.getFullYear();
		var from_date = `${year}-${month}-${day}`;
		var to_date = `${year}-${month}-${yesterday}`;
		}
		else if(filtervalue=='Last Week')
		{
		const date = new Date();
		let seveanday = date.getDate() - 7;
		let day = date.getDate();
		let month = date.getMonth() + 1;
		let year = date.getFullYear();
		var from_date = `${year}-${month}-${day}`;
		var to_date = `${year}-${month}-${seveanday}`;
		alert(to_date);
		}
		else if(filtervalue=='Last Month')
		{
		const date = new Date();
		let thirtyday =  30 - date.getDate();
		let day = date.getDate();
		let month = date.getMonth() + 1;
		let year = date.getFullYear();
		var from_date = `${year}-${month}-${day}`;
		var to_date = `${year}-${month}-${thirtyday}`;
		alert(thirtyday);
		}
		else if(filtervalue=='This Month')
		{
		const date = new Date();
		var firstdate = new Date(date.getFullYear(), date.getMonth(), 1);
		let firstday = firstdate.getDate();
		let day = date.getDate();
		let month = date.getMonth() + 1;
		let year = date.getFullYear();
		var from_date = `${year}-${month}-${firstday}`;
		var to_date = `${year}-${month}-${day}`;
		//alert(from_date);
		}
		else if(filtervalue=='Custom')
		{
	        var allfilter = $('#allfilter').val();
		
			if(allfilter=='Custom'){
			$("#daterange").css("display","block");
			}else{
			$("#daterange").css("display","none");
			}
		}
		$(document).on('change', '#daterange', function(){
		    var dates = $('#daterange').val();
			const daterange = dates.split("-");
			var from_date = daterange[0];
			var to_date   = daterange[1];
			alert(from_date);
			alert(to_date);
		});
		
			$.ajax({
			 url: 'http://43.204.47.201/revivemohan/adservernew/api/revive_stat/get_advertiser_campaign_statistics/2023-02-27 00:00:00,2023-02-27 12:00:00,17', 
			type: 'GET',
			beforeSend: function (xhr) {
				xhr.setRequestHeader('Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2NzczMDYwNTAsImV4cCI6MTcwODg0MjA1MCwic3ViIjoicm9vdCJ9.CYfjFYlMzqC3XHPlviqMrlfapRbHwvhTvF7eCF1f9DA');
			},
			data: {},
			success: function (data) 
			{
				//$('#hmm').html(data);
				console.log("data", data);
				const entries = Object.values(data);
				console.log("data1", entries[0].date_time);
				if(entries[0]['impressions']==undefined || entries[0]['clicks']==undefined || entries[0] ['conversions']==undefined || entries[0] ['requests']==undefined)
				{
				
				document.getElementById('imp').innerHTML = 0;
				document.getElementById('cli').innerHTML = 0;
				document.getElementById('con').innerHTML = 0;
				document.getElementById('req').innerHTML = 0;
				
				}else{
				
				document.getElementById('imp').innerHTML = entries[0]['impressions'];
				document.getElementById('cli').innerHTML = entries[0]['clicks'];
				document.getElementById('con').innerHTML = entries[0]['conversions'];
				document.getElementById('req').innerHTML = entries[0]['requests'];
				
				}
					
			},
			error: function () { },
			});
	}
	
	/* function date_range(dates)
	{
		//var daterange = $('#daterange').val();		
		//alert(dates);
		const daterange = dates.split("-");
	    var from_date = daterange[0];
	    var to_date   = daterange[1];
		alert(from_date);
		alert(to_date);
	} */
	
	$(function() {
		$('input[name="daterange"]').daterangepicker({
			opens: 'left'
		}, function(start, end, label) {
			console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
		});
	});
   </script>
  </body>
</html>