<?php
include('session.php'); ?>
<!DOCTYPE html>
<!-- beautify ignore:start -->
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="../assets/" data-template="vertical-menu-template-free">
  <head>
  <title>Revive Adservermod - Dashboard</title>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
  <meta name="description" content="" />
  <style>
    .text-hide{
    display: block;
    width: 125px;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    }

    .tooltip {
      position: relative;
      display: inline-block;
    }

    .tooltip .tooltiptext {
      visibility: hidden;
      width: 120px;
      background-color: gray;
      color: #fff;
      text-align: center;
      border-radius: 6px;
      padding: 5px 0;
    
      /* Position the tooltip */
      position: absolute;
      z-index: 1;
    }
    
    .tooltip:hover .tooltiptext {
      visibility: visible;
    }

    .text-hide:hover{
    overflow: inherit;
    width: auto;
    }

    .wrapper 
    {
        width: 100%;
        display: block;
        overflow: hidden;
        margin: 0 auto;
        padding: 60px 50px;
        background: #fff;
        border-radius: 4px;
    }

    .bar_canvas {
        background: #fff;
        height: 300px;
    }
    
    .loader
    {
        display: none;
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 999;
        background: rgba(255,255,255,0.8) url("../assets/img/loader.gif") center no-repeat;
    }

    /* colse button */
    .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus){
	   box-shadow: 0 0 5px #fff!important;
		}
		.dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
		  -webkit-appearance: none!important;
		}
		.dataTables_wrapper .dataTables_filter button{
		  visibility: hidden;
		  outline: none;
		}
		.dataTables_wrapper .dataTables_filter input:valid ~ button{
		  visibility: visible;
		}
    </style>

    <?php include('head.php'); ?>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.6.0/Chart.min.js"></script>
  </head>

  <body onload="dash_filter()">
  <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <?php include('sidebar.php'); ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          <?php include('navbar.php'); ?>
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
                <div class="row">
                    <div class="col col-3 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                        <div class="d-flex justify-content-start">
                            <p class="h3">Dashboard</p>
                            <input type="hidden" name="clientid" id="clientid" value="<?php echo $_SESSION['clientid']; ?>">
                        </div>
                    </div>
                    <div class="col col-9 col-sm-12 col-md-8 col-lg-8 col-xl-8 col-xxl-8">
                        <div class="d-flex justify-content-end">
                            <div class="w-25 mb-3">
                                <select id="getDuration" class="form-select text-dark" 
                                onchange="dash_filter()">
                                    <option selected value="Today">Today</option>
                                    <option value="Yesterday">Yesterday</option>
                                    <option value="Last 7 days">Last 7 days</option>
                                    <option value="Last 30 days">Last 30 days</option>
                                    <option value="Last Month">Last Month</option>
                                    <option value="This Month">This Month</option>
                                    <option value='all statistics'>All Statistics</option>
                                    <option value="custom">Custom</option>
                                </select>
                                <input style="display: none;" id="daterange" name="daterange" 
                                value="03/01/2023 - 03/15/2023" />
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-1 d-flex justify-content-center">
                    <!-- Campaign Chart -->
                    <div class="col col-xs-12 col-sm-12 col-md-11 col-lg-7 col-xl-8 col-xxl-8">
                        <div class="col-12 col-lg-12 order-2 order-md-3 order-lg-2 mb-4">
                            <div class="card">
                              <div class="row row-bordered g-0">
                                <div class="col-md-12" >
                                    <div class='card-body'>
                                        <div class='container'>
                                            <div class="row">
                                                <div class="col col-xs-4 col-sm-4 col-md-4 col-lg-4 col-xl-4">
                                                    <h5 class="card-header m-0 me-2 pb-3">Campaigns</h5>
                                                </div>
                                                <div class="col col-xs-8 col-sm-8 col-md-8 col-lg-8 col-xl-8">
                                                    <div class="d-flex justify-content-end">
                                                        <div class="w-50 mt-4" style="margin-right: 6%;">
                                                            <select id='campaignGraph' class="form-select text-dark" onchange='dash_filter()'>
                                                                <option value="impression" selected>Impression</option>
                                                                <option value="clicks">Clicks</option>
                                                                <option value="conversion">Conversion</option>
                                                                <option value="spend">Spend</option>
                                                                <option value="ctr">CTR</option>
                                                                <option value="ecpm">ECPM</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class='d-flex justify-content-end'>
                                                <div class="mt-3">
                                                    <button class="btn" type="button" data-bs-toggle="modal" title="Campaign Chart Zoom"
                                                        data-bs-target="#fullscreenModal" id='zoomButton'>
                                                        <i class="fa fa-arrows-alt text-primary"></i>
                                                    </button>
                                                </div>
                                                <div class="modal fade" id="fullscreenModal" tabindex="-1" aria-hidden="true">
                                                    <div class="modal-dialog modal-fullscreen" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="modalFullTitle">Campaign Chart</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <canvas id="line-chart2"></canvas>
                                                                <script>
                                                                    function campaignChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue) {
                                                                        console.log("campaign-", campaignName, "impression-", ImpressionValue);
                                                                        var getValue = document.getElementById('campaignGraph').value;
                                                                        console.log("get value", getValue);
                                            
                                                                      var zoomCampaignChart = new Chart(document.getElementById("line-chart2"), {
                                                                            type: 'line',
                                                                            data: {
                                                                                labels: campaignName,
                                                                                datasets: [{
                                                                                    data: getValue == 'impression' ? ImpressionValue : getValue == 'clicks' ? clickValue :
                                                                                        getValue == 'conversion' ? conversionsValue : getValue == 'spend' ? revenueValue :
                                                                                            getValue == 'ctr' ? ctrValue : getValue == 'ecpm' ? ecpmValue : "",
                                                                                    label: getValue == 'impression' ? "impression" : getValue == 'clicks' ? "Clicks" :
                                                                                        getValue == 'conversion' ? "Conversion" : getValue == 'spend' ? "Spend" :
                                                                                            getValue == 'ctr' ? "CTR" : getValue == 'ecpm' ? "ECPM" : "",
                                                                                    borderColor: getValue == 'impression' ? "#3e95cd" : getValue == 'clicks' ? "#8e5ea2" :
                                                                                        getValue == 'conversion' ? "#e83e8c" : getValue == 'spend' ? "#e79f0d" :
                                                                                            getValue == 'ctr' ? "#c45850" : getValue == 'ecpm' ? "#fd7e14" : "",
                                                                                    fill: false
                                                                                }]
                                                                            },
                                                                            options: {
                                                                                responsive: true,
                                                                                title: {
                                                                                    display: true,
                                                                                    text: 'Campaign Chart'
                                                                                },
                                                                                layout:{
                                                                                    padding:5
                                                                                },
                                                                                scales: {
                                                                                    xAxes: [{
                                                                                        display: true,
                                                                                        scaleLabel: {
                                                                                            display: true,
                                                                                            // labelString: '13-03-2023 to 18-03-2023'
                                                                                        },
                                                                                        labelWrap: true,
                                                                                        ticks: {
                                                                                            maxRotation: 90,
                                                                                            minRotation: 90
                                                                                        }
                                                                                    }],
                                                                                    yAxes: [
                                                                                        {
                                                                                            display: true,
                                                                                            scaleLabel: {
                                                                                                display: true
                                                                                            }
                                                                                        }
                                                                                    ]
                                                                                }
                                                                            }
                                                                        });

                                                                        var checkChart = document.getElementById("campaignGraph");
                                                                        campaignGraph.addEventListener("change", function () {
                                                                            zoomCampaignChart.destroy();
                                                                        });
                                                                    };
                                                                </script>
                                                            </div>
                                                        </div>
                                                   </div>
                                               </div>
                                            </div>
                                        </div>
                                        <div class='container'>
                                            <canvas id="line-chart1"></canvas>
                                            <script>
                                                function testChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue) {
                                                    console.log("campaign name:", campaignName, "impression value", ImpressionValue);
                                                    var getValue = document.getElementById('campaignGraph').value;
                                                    console.log("option value", getValue);

                                                    var newChart = new Chart(document.getElementById("line-chart1"), {
                                                        type: 'line',
                                                        data: {
                                                            labels: campaignName,
                                                            datasets: [{
                                                                data: getValue == 'impression'?ImpressionValue:getValue == 'clicks'?clickValue:
                                                                      getValue == 'conversion'?conversionsValue:getValue == 'spend'?revenueValue:
                                                                      getValue == 'ctr'?ctrValue:getValue == 'ecpm'?ecpmValue:"",
                                                                label:getValue == 'impression'?"impression":getValue == 'clicks'?"Clicks":
                                                                      getValue == 'conversion'?"Conversion":getValue == 'spend'?"Spend":
                                                                      getValue == 'ctr'?"CTR":getValue == 'ecpm'?"ECPM":"",
                                                                borderColor:getValue == 'impression'?"#3e95cd":getValue == 'clicks'?"#8e5ea2":
                                                                            getValue == 'conversion'?"#e83e8c":getValue == 'spend'?"#e79f0d":
                                                                            getValue == 'ctr'?"#c45850":getValue == 'ecpm'?"#fd7e14":"",
                                                                fill: false
                                                            }]
                                                        },
                                                        options: {
                                                            responsive: true,
                                                            title: {
                                                                display: true,
                                                                text: 'Campaign Chart'
                                                            },
                                                            layout:{
                                                                padding:5
                                                            },
                                                            // hover: {mode: null},
                                                            // events: [],
                                                            scales: {
                                                                xAxes: [{
                                                                    display: true,
                                                                    scaleLabel: {
                                                                        display: true,
                                                                        // labelString: "Campaign Name"
                                                                    },
                                                                    labelWrap: true,
                                                                    ticks: {
                                                                        maxRotation: 90,
                                                                        minRotation: 90
                                                                    },
                                                                }],
                                                                yAxes: [
                                                                    {
                                                                        display: true,
                                                                        scaleLabel: {
                                                                            display: true
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        }
                                                   });

                                                    var checkChart = document.getElementById("campaignGraph");
                                                    campaignGraph.addEventListener("change", function() {
                                                        newChart.destroy();
                                                    });
                                                };
                                            </script>
                                        </div>
                                    </div>
                                </div>
                              </div>
                            </div>
                          </div>
                    </div>
                    
                    <!-- weights - Request, Impress, Click, Conversion  -->
                    <div class="col col-xs-12 col-sm-12 col-md-11 col-lg-4 col-xl-4 col-xxl-4">
                        <div class="row mb-4 mt-sm-2 mt-md-2 mt-lg-5 mt-xl-5 mt-xxl-5">
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:95%'>
                                    <div class="card-body text-center">
                                        <i class="fa  fa-podcast  fa-2x text-primary"  aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-primary  h6 mt-2 mb-2"><b>Requests</b></span>
                                        <h3 class="card-title mb-1" id="req">0</h3>
                                        <!-- <small class="text-success fw-semibold">
                                            <i class="bx bx-up-arrow-alt"></i> +00.00%</small> -->
                                    </div>
                                </div>
                            </div>
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:95%'>
                                    <div class="card-body text-center">
                                        <i class="fa fa-external-link  fa-2x text-primary" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-primary h6 mt-2 mb-2"><b>Impressions</b></span>
                                        <h3 class="card-title text-nowrap mb-1" id="imp">0</h3>
                                        <!-- <small class="text-success fw-semibold"> fa-external-link
                                            <i class="bx bx-up-arrow-alt"></i> +00.00%</small> -->
                                    </div>
                                  </div>
                            </div>
                        </div>
                        <div class="row mb-4 mt-2">
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:95%'>
                                    <div class="card-body text-center">
                                        <i class="fa  fa-hand-pointer-o  fa-2x text-primary" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block  text-primary h6 mt-2 mb-2"><b>Clicks</b></span>
                                        <h3 class="card-title text-nowrap mb-1" id="cli">0</h3>
                                        <!-- <small class="text-danger fw-semibold"> a-paper-plane-o
                                          <i class="bx bx-down-arrow-alt"></i> -00.00%</small> -->
                                    </div>
                                </div>
                            </div>
                            <div class="col col-xs-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="card" style='width:95%'>
                                    <div class="card-body text-center">
                                        <i class="fa fa-credit-card-alt fa-2x text-primary" aria-hidden="true"></i>
                                        <span class="fw-semibold d-block text-primary h6 mt-2 mb-2"><b>Conversions</b></span>
                                        <h3 class="card-title mb-1" id="con">0</h3>
                                        <!-- <small class="text-success fw-semibold"> fa-credit-card-alt
                                            <i class="bx bx-up-arrow-alt"></i> +00.00%</small> -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-3" >
                    <div class="row d-flex justify-content-center" style="margin-top: -10px;">
                    <!-- Top Campaigns -->
                        <div class="col col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="card mb-4" style='height: 94%'>
                                <div class="card-body table-responsive">
                                    <p class="h4">Top Campaigns</p>
                                    <table id="top_campaign" class="table table-hover table-striped table-responsive mt-3">
                                        <thead>
                                            <tr>
                                                <th >Name</th>
                                                <th class="text-center">Impression</th>
                                                <th class="text-center">Clicks</th>
                                                <th class="text-center">Conversions</th>
                                                <th class="text-center">Spend</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-center" id="campaign_table"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Top Banner -->
                        <div class="col col-xs-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="card mb-4" style='height: 94%'>
                                <div class="card-body table-responsive">
                                    <p class="h4">Top Banners</p>
                                    <table id="top_banner" class="table table-hover table-striped mt-3">
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th class="text-center">Impression</th>
                                                <th class="text-center">Clicks</th>
                                                <th class="text-center">Conversions</th>
                                                <th class="text-center">Spend</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-center" id="banner_table"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Top Country -->
                    <div class="card mb-4">
                        <div class="card-body table-responsive">
                            <div class="row">
                                <div class="col col-xs-12 col-sm-12 col-md-5 col-lg-6 col-xl-6 col-xxl-6">
                                    <div class='card'>
                                        <div class='card-body table-responsive'>
                                        <p class="h4">Top Country</p>
                                    <table id="top_country" class="table table-hover table-striped mt-3">
                                        <thead>
                                            <tr>
                                                <th class='text-start'>Name</th>
                                                <th class="text-center">Impression</th>
                                                <th class="text-center">Clicks</th>
                                                <!-- <th class="text-center">Conversions</th> -->
                                                <th class="text-center">Spend</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-center" id='country_table'></tbody>
                                    </table>
                                        </div>
                                    </div>  
                                </div>
                                <div class="col col-xs-12 col-sm-12 col-md-7 col-lg-6 col-xl-6 col-xxl-6">
                                    <div class="wrapper">
                                        <canvas id="myChart4" class="bar_canvas"></canvas>
                                        <script>
                                            function biChangeChart(country_name, imp, click_value) {
                                                var ctx = document.getElementById("myChart4").getContext('2d');
                                                if (window.bar != undefined)
                                                    window.bar.destroy();

                                                window.bar = new Chart(ctx, {
                                                    type: 'bar',
                                                    data: {
                                                        labels: country_name,
                                                        datasets: [{
                                                            label: 'Impression',
                                                            backgroundColor: "#03c3ec",
                                                            data: imp
                                                        }, {
                                                            label: 'Click',
                                                            backgroundColor: "#007bff",
                                                            data: click_value
                                                        }],
                                                    },
                                                    options: {
                                                        tooltips: {
                                                            displayColors: true,
                                                            callbacks: {
                                                                mode: 'x',
                                                            },
                                                        },
                                                        scales: {
                                                            xAxes: [{
                                                                stacked: true,
                                                                gridLines: {
                                                                    display: false,
                                                                },
                                                                ticks: {
                                                                    callback: function (label) {
                                                                        if (/\s/.test(label)) {
                                                                            return label.split(" ");
                                                                        }
                                                                        else {
                                                                            return label;
                                                                        }
                                                                    },
                                                                    // maxRotation: 90,
                                                                    // minRotation: 90
                                                                }
                                                            }],
                                                            yAxes: [{
                                                                stacked: true,
                                                                // ticks: {
                                                                //     beginAtZero: true,
                                                                //     min: 0,
                                                                //     max: 1000,
                                                                //     stepSize: 100
                                                                // },
                                                                type: 'linear',
                                                            }]
                                                        },
                                                        responsive: true,
                                                        maintainAspectRatio: false,
                                                        legend: { position: 'top' },
                                                    }
                                                });
                                            };
                                        </script>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- / Content -->
        <?php include('footer.php'); ?>
        
        <script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
        <script>
            var live_URL = 'https://revphpe.djaxbidder.com/adservermod/api/revive_stat';
            var campaign_url = live_URL + '/get_advertiser_campaign_graph_statistics/';
            var widgets_url = live_URL + '/get_advertiser_campaign_statistics/';
            var topCampaign_url = live_URL + '/get_top_campaign_statistics/';
            var topBanner_url = live_URL + '/get_top_banner_statistics/';
            var topCountry_url = live_URL + '/get_top_country_details/';
            var token = 'Bearer ' + document.getElementById('token').value;
            var client_id = document.getElementById('clientid').value;

            function dash_filter() {
                $(".loader").show();
                // let client_id = document.getElementById('clientid').value;
                var filtervalue = document.getElementById('getDuration').value;
                const date = new Date();
                console.log("check");

                if (filtervalue == 'Today') {
                    $("#daterange").css("display", "none");

                    let v3 = JSON.stringify(date);
                    v3 = v3.slice(1, 11);
                    var start_date = v3, end_date = v3;
                    getDashboardDay(start_date, end_date);
                }
                else if (filtervalue == 'Yesterday') {
                    $("#daterange").css("display", "none");

                    let current_date = date.setDate(date.getDate() - 1);
                    const get_date = new Date(date);
                    let yesterday_date = JSON.stringify(get_date);
                    yesterday_date = yesterday_date.slice(1, 11);
                    var start_date = yesterday_date, end_date = yesterday_date;
                    getDashboardDay(start_date, end_date);
                }
                else if (filtervalue == 'Last 7 days') {
                    $("#daterange").css("display", "none");

                    let date_start = date.setDate(date.getDate() - 7);
                    let get_date = new Date(date_start);
                    let first_day = JSON.stringify(get_date);
                    first_day = first_day.slice(1, 11);

                    let current_date = new Date();
                    let date_end = JSON.stringify(current_date);
                    date_end = date_end.slice(1, 11);
                    getDashboardDay(first_day, date_end);
                }
                else if (filtervalue == 'Last 30 days') {
                    $("#daterange").css("display", "none");

                    let date_start = date.setDate(date.getDate() - 30);
                    let get_date = new Date(date_start);
                    var first_day = JSON.stringify(get_date);
                    first_day = first_day.slice(1, 11);

                    const current_date = new Date();
                    let date_end = JSON.stringify(current_date);
                    date_end = date_end.slice(1, 11);
                    getDashboardDay(first_day, date_end);
                }
                else if (filtervalue == 'This Month') {
                    $("#daterange").css("display", "none");

                    let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                    let cDate = firstDay.getDate(), cMonth = firstDay.getMonth() + 1, cYear = firstDay.getFullYear();
                    let first_day = cYear + "-" + cMonth + "-" + cDate;

                    let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                    let year = lastDay.getFullYear(), month = lastDay.getMonth() + 1, day = lastDay.getDate();
                    let date_end = year + "-" + month + "-" + day;
                    getDashboardDay(first_day, date_end);
                }
                else if (filtervalue == 'Last Month') {
                    $("#daterange").css("display", "none");

                    var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                    var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                    var formatDateComponent = function (dateComponent) {
                        return (dateComponent < 10 ? '0' : '') + dateComponent;
                    }
                    var formatDate = function (date) {
                        return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                    };
                    var start_date = formatDate(prevMonthFirstDate), end_date = formatDate(prevMonthLastDate);
                    getDashboardDay(start_date, end_date);
                }
                else if (filtervalue == 'all statistics') {
                    $("#daterange").css("display", "none");

                    // Start impression, click, request and conversion
                    $.ajax({
                        url: live_URL + '/get_all_dashboard_advertiser_campaign_statistics/' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        data: {},
                        success: function (data) {
                            // console.log("data", data);
                            $(".loader").hide();
                            if (data.msg == 'No Stats Available') {
                                document.getElementById('imp').innerHTML = 0;
                                document.getElementById('cli').innerHTML = 0;
                                document.getElementById('con').innerHTML = 0;
                                document.getElementById('req').innerHTML = 0;
                            }
                            else {
                                const entries = Object.values(data);
                                // console.log("data1", entries[0]['impressions']);
                                if (entries[0]['impressions'] == undefined) {
                                    document.getElementById('imp').innerHTML = 0;
                                }
                                else if (entries[0]['clicks'] == undefined) {
                                    document.getElementById('cli').innerHTML = 0;
                                }
                                else if (entries[0]['conversions'] == undefined) {
                                    document.getElementById('con').innerHTML = 0;
                                }
                                else if (entries[0]['requests'] == undefined) {
                                    document.getElementById('req').innerHTML = 0;
                                }
                                else {
                                    document.getElementById('imp').innerHTML = entries[0]['impressions'];
                                    document.getElementById('cli').innerHTML = entries[0]['clicks'];
                                    document.getElementById('con').innerHTML = entries[0]['conversions'];
                                    document.getElementById('req').innerHTML = entries[0]['requests'];
                                }
                            }
                        },
                        error: function () { },
                    });
                    // End impression, click, request and conversion

                    // Start Top Campaign and Banner
                    $.ajax({
                        url: live_URL + '/get_all_top_campaign_statistics/' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        data: {},
                        success: function (data) {
                            // console.log("campaign data", data.msg);
                            $(".loader").hide();
                            if (data.msg == 'No Stats Available') {
                                let stat_msg = `<p class="text-secondary bg-light mt-3 h5" style='position:relative; left:250%'>No Data Found</p>`;
                                document.getElementById('banner_table').innerHTML = stat_msg;
                                document.getElementById('campaign_table').innerHTML = stat_msg;
                                $('#top_banner').DataTable({
                                    ordering: false,
                                    destroy: true,
                                    responsive: true,
                                    bPaginate: false,
                                    bInfo: false,
                                    data:[],
                                    searching: false,
                                    oLanguage: {
                                        sEmptyTable:"No Data Found"
                                    }
                                });
                                $('#top_campaign').DataTable({
                                    ordering: false,
                                    destroy: true,
                                    responsive: true,
                                    bPaginate: false,
                                    bInfo: false,
                                    data:[],
                                    searching: false,
                                    oLanguage: {
                                        sEmptyTable:"No Data Found"
                                    }
                                });
                            }
                            else {
                                var getBanData = "", TableData = "";

                                data.map((data, index) => {
                                    // let sum = data.spend;
                                    if (data.spend == null) { var spend = 0.00; }
                                    else { var spend = data.spend; }
                                    getBanData += `<tr key='index'>
                                                <td class="text-hide">${data.bannername}</td>
                                                <td>${data.impressions}</td>
                                                <td>${data.clicks}</td>
                                                <td>${data.conversions}</td>
                                                <td>`+ spend + `</td>
                                            </tr>`
                                });
                                document.getElementById('banner_table').innerHTML = getBanData;

                                data.map((data, index) => {
                                    // console.log(data);
                                    if (data.spend == null) { var spend = 0.00; }
                                    else { var spend = data.spend; }
                                    TableData += `<tr key='index'>
                                    <td class="text-hide">${data.campaignname}</td>
                                    <td>${data.impressions}</td>
                                    <td>${data.clicks}</td>
                                    <td>${data.conversions}</td>
                                    <td>`+ spend + `</td>
                                </tr>`
                                });
                                document.getElementById('campaign_table').innerHTML = TableData;
                            }
                        },
                        error: function () { },
                    });
                    // End Top Campaign and Banner

                    // Start Top Country
                    $.ajax({
                        url: live_URL + '/get_all_top_country_details/' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        data: {},
                        success: function (data) {
                            // console.log("country data", data);
                            $(".loader").hide();
                            if (data.msg == 'No Stats Available') {
                                let stat_msg = `<p class="text-secondary bg-light mt-3 h5" style='position:relative; left:250%'>No Data Found</p>`;
                                document.getElementById('country_table').innerHTML = stat_msg;
                                biChangeChart(v1 = [], imp = [], click_value = []);
                            }
                            else {
                                var countryData = "";
                                data.map((data, index) => {
                                    countryData += `<tr key='index'>
                                    <td class='text-start'>${data.countryname}</td>
                                                        <td>${data.impressions}</td>
                                                        <td>${data.clicks}</td>
                                                        <!--<td>${data.conversions}</td>-->
                                                        <td>${data.revenue}</td>
                                            </tr>`
                                });
                                document.getElementById('country_table').innerHTML = countryData;

                                var v1 = data.map((data) => {
                                return data.countryname;
                            });
                            // console.log("country chart name data", v1);

                            var imp = data.map((data) => {
                                var convert = parseInt(data.impressions, 10);
                                return convert;
                            })
                            // console.log("imp value", imp);

                            var click_value = data.map((data) => {
                                var convert = parseInt(data.clicks, 10);
                                return convert
                            });
                            // console.log("click value", click_value);

                            // var conversion_value = data.map((data) => {
                            //     var convert = parseInt(data.conversions, 10);
                            //     return convert;
                            // });
                            // console.log("conversion value", conversion_value);

                            biChangeChart(v1, imp, click_value);
                            }
                        },
                        error: function () { },
                    });
                    // End Top Country

                    // Campaign Chart Start
                    $.ajax({
                        url: live_URL + '/get_all_advertiser_campaign_graph_statistics/' + client_id,
                        type: 'GET',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        data: {},
                        success: function (data) {
                            // console.log("Campaign data", data);
                            $(".loader").hide();
                            if (data.msg == 'No Stats Available') {
                                testChart(campaignName = [], ImpressionValue = [], clickValue = [],
                                    conversionsValue = [], revenueValue = [], ctrValue = [],
                                    ecpmValue = []);
                                    document.getElementById("zoomButton").disabled = true;
                                    document.getElementById("zoomButton").title="No data, so button disabled";
                            }
                            else {
                                document.getElementById("zoomButton").disabled = false;
                                document.getElementById("zoomButton").title="Zoom Button";
                                var campaignName = data.map((data) => {
                                    return data.campaignname;
                                });
                                // console.log("campaign name", campaignName);

                                var ImpressionValue = data.map((data, index) => {
                                    let convert = parseInt(data.impressions, 10);
                                    if (data.impressions == null) {
                                        convert[index] = 0;
                                    } else {
                                        return convert;
                                    }
                                });
                                // console.log("Impression Value", ImpressionValue);

                                var clickValue = data.map((data, index) => {
                                    let convert = parseInt(data.clicks, 10);
                                    if (data.clicks == null) {
                                        convert[index] = 0;
                                    } else {
                                        return convert;
                                    }
                                });
                                // console.log("click Value", clickValue);

                                var conversionsValue = data.map((data, index) => {
                                    let convert = parseInt(data.conversions, 10);
                                    if (data.conversions == null) {
                                        convert[index] = 0;
                                    } else {
                                        return convert;
                                    }
                                });
                                // console.log("conversions Value", conversionsValue);

                                var revenueValue = data.map((value, index) => {
                                    let convert = parseInt(value.revenue, 10);
                                    if (value.revenue == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("spend Value", revenueValue);

                                var ctrValue = data.map((data, index) => {
                                    let convert = parseInt(data.ctr, 10);
                                    if (data.ctr == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                });
                                // console.log("ctr Value", ctrValue);

                                var ecpmValue = data.map((data, index) => {
                                    let convert = parseInt(data.ecpm, 10);
                                    if (data.ecpm == null) {
                                        return convert[index] = 0;
                                    }
                                    else {
                                        return convert;
                                    }
                                    return convert;
                                });
                                // console.log("ecpm Value", ecpmValue);

                                testChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue);
                                campaignChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue);
                            }
                        },
                        error: function () { },
                    });
                    // Campaign Chart End
                }
                else if (filtervalue == 'custom') {
                    $("#daterange").css("display", "block");
                    $(".loader").hide();
                    var start_date,end_date
                    $(document).on('click', '#daterange', function () {
                        var dates = $('#daterange').val();
                        const daterange = dates.split("-");
                    });
                    $(function () {
                        $('input[name="daterange"]').daterangepicker({
                            opens: 'left'
                        }, function (start, end, label) {
                             start_date = start.format('YYYY-MM-DD'), end_date = end.format('YYYY-MM-DD');
                            console.log("custom start date", start_date, "custom end date", end_date);
                            getDashboardDay(start_date, end_date);
                        })
                    });
                    start_date != 'undefined'?testChart(campaignName = [], ImpressionValue = [], clickValue = [],
                                conversionsValue = [], revenueValue = [], ctrValue = [],
                                ecpmValue = []):"0"
                    // console.log("check1", start_date , );
                }
            };

            function getDashboardDay(startDate, endDate) {
                // Campaign Chart Start
                $.ajax({
                    url: campaign_url + startDate + ' 00:00:00,' + endDate + ' 12:00:00,' + client_id,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {
                        // console.log("Campaign data", data);
                        $(".loader").hide();
                        if (data.msg == 'No Stats Available') {
                            testChart(campaignName = [], ImpressionValue = [], clickValue = [],
                                conversionsValue = [], revenueValue = [], ctrValue = [],
                                ecpmValue = []);
                            document.getElementById("zoomButton").disabled = true;
                            document.getElementById("zoomButton").title="No data, so button disabled";
                        }
                        else {
                            document.getElementById("zoomButton").disabled = false;
                            document.getElementById("zoomButton").title="Zoom Button";
                            var campaignName = data.map((data) => {
                                return data.campaignname;
                            });
                            // console.log("campaign name", campaignName);

                            var ImpressionValue = data.map((data, index) => {
                                let convert = parseInt(data.impressions, 10);
                                if (data.impressions == null) {
                                    return convert[index] = 0;
                                }
                                else {
                                    return convert;
                                }
                            });
                            // console.log("Impression Value", ImpressionValue);

                            var clickValue = data.map((data) => {
                                let convert = parseInt(data.clicks, 10);
                                if (data.clicks == null) {
                                    return convert[index] = 0;
                                }
                                else {
                                    return convert;
                                }
                            });
                            // console.log("click Value", clickValue);

                            var conversionsValue = data.map((data) => {
                                let convert = parseInt(data.conversions, 10);
                                if (data.conversions == null) {
                                    return convert[index] = 0;
                                }
                                else {
                                    return convert;
                                }
                            });
                            // console.log("conversions Value", conversionsValue);

                            var revenueValue = data.map((value, index) => {
                                let convert = parseInt(value.revenue, 10);
                                if (value.revenue == null) {
                                    return convert[index] = 0;
                                }
                                else {
                                    return convert;
                                }
                            });
                            // console.log("spend Value", revenueValue);

                            var ctrValue = data.map((data, index) => {
                                let convert = parseInt(data.ctr, 10);
                                if (data.ctr == null) {
                                    return convert[index] = 0;
                                }
                                else {
                                    return convert;
                                }
                            });
                            // console.log("ctr Value", ctrValue);

                            var ecpmValue = data.map((data, index) => {
                                let convert = parseInt(data.ecpm, 10);
                                if (data.ecpm == null) {
                                    return convert[index] = 0;
                                }
                                else {
                                    return convert;
                                }
                            });
                            // console.log("ecpm Value", ecpmValue);

                            campaignChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue);
                            testChart(campaignName, ImpressionValue, clickValue, conversionsValue, revenueValue, ctrValue, ecpmValue);
                        }
                    },
                    error: function () { },
                });
                // Campaign Chart End

                // Start impression, click, request and conversion
                $.ajax({
                    url: widgets_url + startDate + ' 00:00:00,' + endDate + ' 12:00:00,' + client_id,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {
                        //$('#hmm').html(data);
                        // console.log("data", data);
                        $(".loader").hide();
                        if (data.msg == 'No Stats Available') {
                            document.getElementById('imp').innerHTML = 0;
                            document.getElementById('cli').innerHTML = 0;
                            document.getElementById('con').innerHTML = 0;
                            document.getElementById('req').innerHTML = 0;
                        }
                        else {
                            const entries = Object.values(data);
                            if (entries[0]['requests'] == null && entries[0]['impressions'] == null && entries[0]['clicks'] == null && entries[0]['conversions'] == null) {
                                document.getElementById('req').innerHTML = 0;
                                document.getElementById('imp').innerHTML = 0;
                                document.getElementById('cli').innerHTML = 0;
                                document.getElementById('con').innerHTML = 0;
                            }
                            else {
                                document.getElementById('imp').innerHTML = entries[0]['impressions'];
                                document.getElementById('cli').innerHTML = entries[0]['clicks'];
                                document.getElementById('con').innerHTML = entries[0]['conversions'];
                                document.getElementById('req').innerHTML = entries[0]['requests'];
                            }
                        }
                    },
                    error: function () { },
                });
                // End impression, click, request and conversion

                // Top Campaign Start
                $.ajax({
                    url: topCampaign_url + startDate + ' 00:00:00,' + endDate + ' 12:00:00,' + client_id,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {
                        // console.log("campaign data", data.msg);
                        $(".loader").hide();
                        if (data.msg == 'No Stats Available') {
                            let stat_msg = `<p class="text-secondary bg-light mt-3 h5" style='position:relative; left:250%'>No Data Found</p>`;
                            document.getElementById('campaign_table').innerHTML = stat_msg;
                            $('#top_campaign').DataTable({
                                    ordering: false,
                                    destroy: true,
                                    responsive: true,
                                    bPaginate: false,
                                    bInfo: false,
                                    data:[],
                                    searching: false,
                                    oLanguage: {
                                        sEmptyTable:"No Data Found"
                                    }
                                });
                        }
                        else {
                            var getCamData = "";
                            data.map((data, index) => {
                                if (data.spend == null) { var spend = 0.00; }
                                else { var spend = data.spend; }
                                getCamData += `<tr key='index'>
                                                 <td class="text-hide">${data.campaignname}</td>
                                                 <td>${data.impressions}</td>
                                                 <td>${data.clicks}</td>
                                                 <td>${data.conversions}</td>
                                                 <td>`+ spend + `</td>
                                             </tr>`
                            });
                            document.getElementById('campaign_table').innerHTML = getCamData;
                        }
                    },
                    error: function () { },
                });
                // End Top Campaign

                // Start Top Banner
                $.ajax({
                    url: topBanner_url + startDate + ' 00:00:00,' + endDate + ' 12:00:00,' + client_id,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {
                        // console.log("campaign data", data.msg);
                        $(".loader").hide();
                        if (data.msg == 'No Stats Available') {
                            let stat_msg = `<p class="text-secondary bg-light mt-3 h5" style='position:relative; left:250%'>No Data Found</p>`;
                            document.getElementById('banner_table').innerHTML = stat_msg;
                        }
                        else {
                            var getBanData = "";
                            data.map((data, index) => {
                                if (data.spend == null) { var spend = 0.00; }
                                else { var spend = data.spend; }
                                getBanData += `<tr key='index'>
                                                        <td class='text-hide text-start'>${data.bannername}</td>
                                                        <td>${data.impressions}</td>
                                                        <td>${data.clicks}</td>
                                                        <td>${data.conversions}</td>
                                                        <td>`+ spend + `</td>
                                                    </tr>`
                            });
                            document.getElementById('banner_table').innerHTML = getBanData;
                        }
                    },
                    error: function () { },
                });
                // End Top Banner

                // Start Top Country
                $.ajax({
                    url: topCountry_url + startDate + ' 00:00:00,' + endDate + ' 12:00:00,' + client_id,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: {},
                    success: function (data) {
                        // console.log("country data", data[0]);
                        $(".loader").hide();
                        if (data.msg == 'No Stats Available') {
                            let stat_msg = `<h5 class="text-secondary bg-light mt-3" style='position:relative; left:100%'>No Data Found</h5>`;
                            document.getElementById('country_table').innerHTML = stat_msg;
                            biChangeChart(v1 = [], imp = [], click_value = []);
                            // $('#top_country').DataTable({
                            //         ordering: false,
                            //         destroy: true,
                            //         responsive: true,
                            //         bPaginate: false,
                            //         bInfo: false,
                            //         data:[],
                            //         searching: false,
                            //         oLanguage: {
                            //             sEmptyTable:"No Data Found"
                            //         }
                            // });
                        }
                        else {
                            var countryData = "";
                            data.map((data, index) => {
                                countryData += `<tr key='index'>
                                    <td class='text-start'>${data.countryname}</td>
                                                <td>${data.impressions}</td>
                                                <td>${data.clicks}</td>
                                                <!--<td>${data.conversions}</td>-->
                                                <td>${data.revenue}</td>
                                                    </tr>`
                            });
                            document.getElementById('country_table').innerHTML = countryData;

                            // $('#top_country').DataTable({
                            //     ordering: true,
                            //     destroy: true,
                            //     responsive: true,
                            //     bPaginate: false,
                            //     bInfo: false,
                            //     data:data,
                            //     searching: false,
                            //     columns: [
                            //         { data: 'countryname' },
                            //         { data: 'impressions', className: "text-center" },
                            //         { data: 'clicks', className: "text-center" },
                            //         // { data: 'conversions', className: "text-center" },
                            //         { data: 'revenue', className: "text-center" },
                            //     ],
                            // });
                              

                            var v1 = data.map((data) => {
                            return data.countryname;
                        });
                        // console.log("country chart name data", v1)
                        var imp = data.map((data) => {
                            var convert = parseInt(data.impressions, 10);
                            return convert;
                        })
                        // console.log("imp value", imp)
                        var click_value = data.map((data) => {
                            var convert = parseInt(data.clicks, 10);
                            return convert
                        });
                        // console.log("click value", click_value)
                        // var conversion_value = data.map((data) => {
                        //     var convert = parseInt(data.conversions, 10);
                        //     return convert;
                        // });
                        // console.log("conversion value", conversion_value)
                        biChangeChart(v1, imp, click_value);
                        }
                    },
                    error: function () { },
                });
                // End Top Country
            };
        </script>
        <!-- <script src="../assets/js/config.js"></script> -->
        <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>
  </body>
</html>