<?php
include('session.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <title>Revive Adservermod - Campaign | Report</title>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <style>
        .text-hide {
            display: block;
            width: 125px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: inherit;
            width: auto;
        }

        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        h5 {
            position: relative;
            left: 200%;
        }
    </style>
</head>

<body onload="onChangeDetails()">
    <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3 mb-5">
                            <div class="card-body">
                                <div>
                                    <div class="row mb-4 mt-2">
                                        <div class="col-9">
                                            <p class='h4'>Campaign Report</p>
                                        </div>
                                        <div class="col-3">
                                            <select id="getCampaign" class="form-select"
                                                aria-label="Default select example" onchange="onChangeDetails()">
                                                <option selected value="Today">Today</option>
                                                <option value="Yesterday">Yesterday</option>
                                                <option value="Last 7 days">Last 7 days</option>
                                                <option value="Last 30 days">Last 30 days</option>
                                                <option value="Last Month">Last Month</option>
                                                <option value="This Month">This Month</option>
                                                <option value='all statistics'>All Statistics</option>
                                                <option value="custom">Custom</option>
                                            </select>
                                            <input style="display: none;" id="daterange" name="daterange"
                                                value="03/01/2023 - 03/15/2023" />
                                        </div>
                                    </div>
                                    <div class="table">
                                        <!-- id="example2" -->
                                        <table id="camapaignrep" class="table table-hover table-striped">
                                            <thead>
                                                <tr class="text-dark">
                                                    <!-- <th class="text-dark text-center" style="text-align: center; width: 20%">Date</th> -->
                                                    <th class="text-dark" style="text-align: center;">Name</th>
                                                    <th class="text-dark text-center" style="text-align: center;">Impression</th>
                                                    <th class="text-dark text-center" style="text-align: center;">Clicks</th>
                                                    <th class="text-dark text-center" style="text-align: center;">Conversion</th>
                                                    <th class="text-dark text-center" style="text-align: center;">CTR%</th>
                                                    <th class="text-dark text-center" style="text-align: center;">Spend</th>
                                                    <th class="text-dark text-center" style="text-align: center;">eCPM</th>
                                                </tr>
                                            </thead>
                                            <tbody id="camp_table"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include('footer.php'); ?>
                    <!-- / Footer -->
                    <!--<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>-->
                    <script type="text/javascript"
                        src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
                    <script type="text/javascript"
                        src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
                    <script>
                        var live_URL = 'http://3.6.236.135/adservermod/api/revive_stat';
                        var domain_url = live_URL + '/get_advertiser_campaign_report_statistics/';
                        var token = 'Bearer ' + document.getElementById('token').value;
                        var client_id = document.getElementById('clientid').value;
                        var getCampData = "";

                        function onChangeDetails() {
                            $(".loader").show();
                            const date = new Date();
                            var getSelectedDay = document.getElementById('getCampaign').value;
                            // console.log("client id", client_id);
                            var getCampData = "";

                            if (getSelectedDay == 'Today') {
                                $("#daterange").css("display", "none");
                                let v3 = JSON.stringify(date);
                                v3 = v3.slice(1, 11);
                                var start_date = v3, end_date = v3;
                                getCampaignDate(start_date, end_date);
                            }
                            else if (getSelectedDay == 'Yesterday') {
                                $("#daterange").css("display", "none");
                                let current_date = date.setDate(date.getDate() - 1);
                                const get_date = new Date(date);
                                let yesterday_date = JSON.stringify(get_date);
                                yesterday_date = yesterday_date.slice(1, 11);
                                var start_date = yesterday_date, end_date = yesterday_date;
                                getCampaignDate(start_date, end_date);
                            }
                            else if (getSelectedDay == 'Last 7 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 7);
                                let get_date = new Date(date_start);
                                let first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                let current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                // console.log("last 7 days", date_end);
                                getCampaignDate(first_day, date_end);
                            }
                            else if (getSelectedDay == 'Last 30 days') {
                                $("#daterange").css("display", "none");
                                let date_start = date.setDate(date.getDate() - 30);
                                let get_date = new Date(date_start);
                                var first_day = JSON.stringify(get_date);
                                first_day = first_day.slice(1, 11);

                                const current_date = new Date();
                                let date_end = JSON.stringify(current_date);
                                date_end = date_end.slice(1, 11);
                                getCampaignDate(first_day, date_end);
                            }
                            else if (getSelectedDay == 'This Month') {
                                $("#daterange").css("display", "none");
                                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                let cYear = firstDay.getFullYear(), cMonth = firstDay.getMonth() + 1, cDate = firstDay.getDate();
                                let first_day = cYear + "-" + cMonth + "-" + cDate;

                                let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                                let year = lastDay.getFullYear(), month = lastDay.getMonth() + 1, day = lastDay.getDate();
                                let date_end = year + "-" + month + "-" + day;
                                getCampaignDate(first_day, date_end);
                            }
                            else if (getSelectedDay == 'Last Month') {
                                $("#daterange").css("display", "none");
                                var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                var formatDateComponent = function (dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                                }
                                var formatDate = function (date) {
                                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                };
                                var start_date = formatDate(prevMonthFirstDate), end_date = formatDate(prevMonthLastDate);
                                getCampaignDate(start_date, end_date);
                            }
                            else if (getSelectedDay == 'all statistics') {
                                $("#daterange").css("display", "none");
                                $.ajax({
                                    url: live_URL + '/get_all_advertiser_campaign_statistics/' + client_id,
                                    type: 'GET',
                                    beforeSend: function (xhr) {
                                        xhr.setRequestHeader('Authorization', token);
                                    },
                                    data: {},
                                    success: function (data) {
                                        console.log("cm data", data);
                                        $(".loader").hide();
                                        if (data.msg == 'No Stats Available') {
                                            let stat_msg = `<h5 class="text-primary text-center mt-3">No Data Found</h5>`
                                            document.getElementById('camp_table').innerHTML = stat_msg;
                                        }
                                        else {
                                            data.map((data) => {
                                                if (data.ecpm == null) {
                                                    var raw = 0.00;
                                                }
                                                else {
                                                    var raw = data.ecpm;
                                                }
                                                if (data.revenue == null) {
                                                    var replace = 0.00;
                                                }                                                
                                                else {
                                                    var replace = data.revenue;
                                                }
                                                getCampData += `<tr class="text-dark">
                                                        <td class='text-hide text-start'>${data.campaignname}</td>
                                                        <td align="center">${data.impressions}</td>
                                                        <td>${data.clicks}</td>
                                                        <td>${data.conversions}</td>
                                                        <td>${data.ctr} %</td>
                                                        <td class="text-center">`+ replace + `</td>
                                                        <td class="text-center">`+ raw + `</td>
                                                    </tr>
                                                    <tfoot>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                    </tfoot>
                                                    `
                                                   
                                            });
                                            document.getElementById('camp_table').innerHTML = getCampData;
                                            $('#camapaignrep').DataTable({
                                                "ordering": true,
                                                "destroy": true,
                                                data: data,
                                                columns: [
                                                    { 'data': null, title: 'Name', wrap: true, "render": function (campaign) { return '<a href="bannerreport.php?campaignid='+campaign.campaignid+'&start_date='+start_date+'&end_date='+end_date+'">'+campaign.campaignname+'</a>' } },
                                                    { data: 'impressions', className: "text-center" },
                                                    { data: 'clicks', className: "text-center" },
                                                    { data: 'conversions', className: "text-center" },
                                                    { data: 'ctr', className: "text-center" },
                                                    { data: 'revenue', className: "text-center" },
                                                    { data: 'ecpm', className: "text-center" },
                                                ],
                                              
                                                    $('#camapaignrep').DataTable( {
                                                        drawCallback: function () {
                                                        var api = this.api();
                                                        var sum = 0;
                                                        var formated = 0;
                                                        //to show first th
                                                        $(api.column(0).footer()).html('Total');

                                                            for(var i=1; i<=7;i++)
                                                            {
                                                                sum = api.column(i, {page:'current'}).data().sum();

                                                                //to format this sum
                                                                formated = parseFloat(sum).toLocaleString(undefined, {minimumFractionDigits:2});
                                                                $(api.column(i).footer()).html('$'+formated);
                                                            }
                                                        
                                                        }
                                                    });
                                              
		
                                               
                                            });

                                         
                                        }
                                    },
                                    error: function () { },
                                });
                            }
                            else if (getSelectedDay == 'custom') {
                                $("#daterange").css("display", "block");
                                $(".loader").hide();
                                $(document).on('change', '#daterange', function () {
                                    var dates = $('#daterange').val();
                                    const daterange = dates.split("-");
                                });
                                $(function () {
                                    $('input[name="daterange"]').daterangepicker({
                                        opens: 'left'
                                    }, function (start, end, label) {
                                        console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
                                        var start_date = start.format('YYYY-MM-DD'), end_date = end.format('YYYY-MM-DD');
                                        getCampaignDate(start_date, end_date);
                                    })
                                })
                            }
                        };

                        function getCampaignDate(start_date, end_date) {
                            $.ajax({
                                url: domain_url + start_date + ' 00:00:00,' + end_date + ' 12:00:00,' + client_id,
                                type: 'GET',
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                success: function (data) {
                                    // console.log("data", data);
                                    $(".loader").hide();
                                    if (data.msg == 'No Stats Available') {
                                        let stat_msg = `<h5 class="text-primary text-center mt-3">No Data Found</h5>`
                                        // let stat_msg = `<tr class="text-primary mt-3 h5">
                                        // <td style='text-align: center'>No Data Found</td>
                                        
                                        // </tr>`
                                        document.getElementById('camp_table').innerHTML = stat_msg;
                                    }
                                    else {
                                        data.map((data) => {
                                            var campaignid = data.campaignid;
                                            if (data.ecpm == null) {
                                                var raw = 0.00;
                                            }
                                            else {
                                                var raw = data.ecpm;
                                            }
                                            if (data.revenue == null) {
                                                var replace = 0.00;
                                            }
                                            else {
                                                var replace = data.revenue;
                                            }
                                            getCampData += `<tr class="text-dark">
                                                        <!--<td class="text-center">${data.date_time}</td>-->
                                                        <td class="text-hide text-start">
                                                        <a href="bannerreport.php?campaignid=${data.campaignid}&campaignname=${data.campaignname}&start_date=` + start_date + `&end_date=` + end_date + `">${data.campaignname}</a></td>
                                                        <td align="center">${data.impressions}</td>
                                                        <td class="text-center">${data.clicks}</td>
                                                        <td class="text-center">${data.conversions}</td>
                                                        <td class="text-center">${data.ctr} %</td>
                                                        <td class="text-center">`+ replace + `</td>
                                                        <td class="text-center">`+ raw + `</td>
                                                    </tr>`
                                        });
                                        document.getElementById('camp_table').innerHTML = getCampData;
                                        $('#camapaignrep').DataTable({
                                            "ordering": true,
                                            "destroy": true,
                                            responsive: true,
                                            data: data,
                                            columns: [
                                                // { data: 'date_time', className: "text-center" },
                                                { 'data': null, title: 'Name', wrap: true, "render": function (campaign) { return '<a href="bannerreport.php?campaignid='+campaign.campaignid+'&campaignname='+campaign.campaignname+'&start_date='+start_date+'&end_date='+end_date+'">'+campaign.campaignname+'</a>' } },
                                                { data: 'impressions', className: "text-center" },
                                                { data: 'clicks', className: "text-center" },
                                                { data: 'conversions', className: "text-center" },
                                                { data: 'ctr', className: "text-center" },
                                                { data: 'revenue', className: "text-center" },
                                                { data: 'ecpm', className: "text-center" },
                                            ],
                                        });
                                    }
                                },
                                error: function () { },
                            });
                        };
                    </script>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/plug-ins/1.11.5/api/sum().js"></script>
	<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>
</body>

</html>