<?php
// DIC configuration
use Respect\Validation\Validator as v;
$container = $app->getContainer();

// view renderer
$container['renderer'] = function ($c) {
    $settings = $c->get('settings')['renderer'];
    return new Slim\Views\PhpRenderer($settings['template_path']);
};

// monolog
$container['logger'] = function ($c) {
    $settings = $c->get('settings')['logger'];
    $logger = new Monolog\Logger($settings['name']);
    $logger->pushProcessor(new Monolog\Processor\UidProcessor());
    $logger->pushHandler(new Monolog\Handler\StreamHandler($settings['path'], $settings['level']));
    return $logger;
};

// Database connection
$container['db'] = function ($c) {
    $settings = $c->get('settings')['db'];
    $pdo = new PDO("mysql:host=" . $settings['host'] . ";dbname=" . $settings['dbname'],
        $settings['user'], $settings['pass']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
    return $pdo;
};


/*----------------  SSP -------------*/
$container['dsp_validate'] = function ($c)
{
    //Create the validators
    $dspname = v::notEmpty();
    $ping_url = v::notEmpty();
    $auction_currency = v::intVal();
    $auction_type = v::intVal();
    $deal_limmit = v::notEmpty();
    $demandtype = v::notEmpty();
    $open_rtb_version = v::intVal();
    $gzip = v::intVal();
    $digital_signature = v::notEmpty();
    $validators = array(
        'exchange_name' => $dspname,
        'ping_url' => $ping_url,
        'auction_currency' => $auction_currency,
        'auction_type' => $auction_type,
        'deal_limmit' => $deal_limmit,
        'demandtype' => $demandtype,
        'open_rtb_version' => $open_rtb_version,
        'gzip' => $gzip,
        'digital_signature' => $digital_signature
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);
};
$container['dsp_edit'] = function ($c)
{
    //Create the validators
    $mode = v::notEmpty();
    $validators = array(
        'mode' => $mode
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);
};
/*----------------  SSP -------------*/ 
/*----------------  DSP -------------*/
$container['ssp_validate'] = function ($c)
{
    //Create the validators
    $ssp_label = v::notEmpty();
    $ssp_name = v::notEmpty();
    $web_reponse_type = v::notEmpty();
    $dspid = v::intVal();
    $digital_signature = v::notEmpty();
    $admin_share = v::notEmpty();
    $validators = array(
        'ssp_label' => $ssp_label,
        'ssp_name' => $ssp_name,
        'web_reponse_type' => $web_reponse_type,
        'dspid' => $dspid,
        'digital_signature' => $digital_signature,
        'admin_share' => $admin_share
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);
};
$container['ssp_edit'] = function ($c)
{
    //Create the validators
    $mode = v::notEmpty();
    $validators = array(
        'mode' => $mode
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);
};
/*----------------  DSP -------------*/

$container['agency_validate'] = function ($c) {
    //Create the validators
    $name =v::notEmpty();
	$contactname = v::notEmpty();
	$email = v::notEmpty();
	$status = v::intVal();
    $validators = array(
		  'name' => $name,
          'contact' => $contactname,
		  'email' => $email,
		  'status' => $status
    );    
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

$container['target_title'] = function ($c) {
    //Create the validators
    $title_name =v::notEmpty();
    $validators = array(
		  'title_name' => $title_name
    );    
    return new \DavidePastore\Slim\Validation\Validation($validators);
};
$container['target_episode'] = function ($c) {
    //Create the validators
    $episode_name =v::notEmpty();
    $validators = array(
		  'episode_name' => $episode_name
    );    
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

$container['target_series'] = function ($c) {
    //Create the validators
    $series_name =v::notEmpty();
    $validators = array(
		  'series_name' => $series_name
    );    
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

$container['target_gender'] = function ($c) {
    //Create the validators
    $gender_name =v::notEmpty();
    $validators = array(
		  'gender_name' => $gender_name
    );    
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

$container['agency_edit'] = function ($c) {
    //Create the validators
    $name =v::notEmpty();
	$contactname = v::notEmpty();
	$email = v::notEmpty();
	$status = v::intVal();
    $mode =v::notEmpty();
	 $validators = array(
		  'name' => $name,
          'contact' => $contactname,
		  'email' => $email,
		  'status' => $status,
		  'mode' => $mode
    );    
    return new \DavidePastore\Slim\Validation\Validation($validators);
};




$container['tracker_validate'] = function ($c) {
    //Create the validators

    $trackername = v::notEmpty();
    $description = v::notEmpty();
    $status = v::notEmpty();
    $type = v::numeric()->positive()->between(1,3);
    $appendcode = v::notEmpty();
    $clientid=v::numeric()->positive();
    $validators = array(
        'trackername' => $trackername,
        // 'description' => $description,
        // 'status' => $status,
        // 'type' => $type,
        // 'appendcode' => $appendcode,
        'clientid'	=> $clientid       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};

$container['tracker_edit'] = function ($c) {
    //Create the validators
    
    $trackerid=v::numeric()->positive();
    $validators = array(
        'trackerid'	=> $trackerid       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
};
$container['tracker_editmode'] = function ($c) {
    //Create the validators
    $trackername = v::numeric()->positive();
    $trackerid=v::numeric()->positive();
     $mode=v::notEmpty();
    $validators = array(
        'trackerid'	=> $trackerid,
        'mode' =>$mode ,
        'trackername'=>$trackername

    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
};
$container['advertiser_edit'] = function ($c) {
    //Create the validators
    
    //~ $trackerid=v::numeric()->positive();
     $contact = v::notEmpty();
	$email = v::notEmpty();
	$clientname= v::notEmpty();
    $mode=v::notEmpty();
    $validators = array(
        'contact' => $contact,
		  'email' => $email,
		  'clientname'=>$clientname,
        'mode' =>$mode       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
};


$container['client_val'] = function ($c) {
    //Create the validators
    
    $clientid=v::numeric()->positive();
    $validators = array(
        'clientid'	=> $clientid       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};


$container['zone_val'] = function ($c) {
    //Create the validators
    
    $zonename=v::notEmpty();

    $publisherid=v::notEmpty();
    // $delivery=v::notEmpty();
    $validators = array(
        'zonename'		=> $zonename,       		
    //    'delivery'=> $delivery	,	   		
        'publisherid'		=> $publisherid,      		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};




$container['target_val'] = function ($c) {
    //Create the validators
    
    $affiliateid=v::notEmpty();
    $name=v::notEmpty();
    // $logical=v::notEmpty();
    // $comparison=v::notEmpty();
    // $type=v::notEmpty();
    // $data=v::notEmpty();
    
    $validators = array(
        'affiliateid'		=> $affiliateid,       		
        'name'				=> $name
        // 'logical'           =>$logical,
        // 'comparison'           =>$comparison,
        // 'type'           =>$type,
        // 'data'           =>$data,
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};

// $container['target_edit'] = function ($c) {
//     //Create the validators
    
//     $affiliateid=v::notEmpty();
//     $name=v::notEmpty();
//     $logical=v::notEmpty();
//     $comparison=v::notEmpty();
//     $type=v::notEmpty();
//     $data=v::notEmpty();
//     $mode = v::notEmpty();
    
//     $validators = array(
//         'affiliateid'		=> $affiliateid,       		
//         'name'				=> $name,
//         'logical'           =>$logical,
//         'comparison'        =>$comparison,
//         'type'           =>$type,
//         'data'           =>$data,
//         'mode'=>$mode
//     );

//     return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
// };
$container['target_edit'] = function ($c) {
    //Create the validators
    
    $affiliateid=v::notEmpty();
    $name=v::notEmpty();
    $logical=v::notEmpty();
    $comparison=v::notEmpty();
    $type=v::notEmpty();
    $data=v::notEmpty();
    $mode = v::notEmpty();
    $validators = array(
        'affiliateid'		=> $affiliateid,       		
        'name'				=> $name,
        // 'logical'           =>$logical,
        // 'comparison'        =>$comparison,
        // 'type'           =>$type,
        // 'data'           =>$data,
        'mode'=>$mode
    );

return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};

$container['get_zone_val'] = function ($c) {
    //Create the validators
    
    $zoneid=v::notEmpty();
    
    $validators = array(
        'zoneid'		=> $zoneid     		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};




$container['zoneid_val'] = function ($c) {
    //Create the validators
    
    $zoneid=v::numeric()->positive();
    $validators = array(
        'zoneid'	=> $zoneid       		
    );

return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};

$container['zoneid_edit'] = function ($c) {
    //Create the validators
    
    $zoneid=v::numeric()->positive();
    $zonename=v::notEmpty();
    $width=v::notEmpty();
    $height=v::notEmpty();
     $mode = v::notEmpty();
    $validators = array(
        'zoneid'	=> $zoneid ,
          'zonename'=> $zonename,  
          'width'=>$width,
          'height'=>$height,     		    		 		   		
        'mode' =>$mode		
    );

return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};


$container['pubid_val'] = function ($c) {
    //Create the validators
    
    $publisherid=v::numeric()->positive();
    $validators = array(
        'publisherid'	=> $publisherid       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};


$container['pubid_edit'] = function ($c) {
    //Create the validators
    
    $publisherid=v::numeric()->positive();
    $contactname = v::notEmpty();
	$email = v::notEmpty();
	$website = v::notEmpty(); 
	$name = v::notEmpty();
    $mode = v::notEmpty();
    $validators = array(
        'publisherid'	=> $publisherid,
        'contact' => $contactname,
		  'email' => $email,
		  'website'=>$website,
		  'name'=>$name,
        'mode' =>$mode       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};


$container['publisheradd_val'] = function ($c) {
    //Create the validators
   $contactname = v::notEmpty();
	$email = v::notEmpty();
	$website = v::notEmpty(); 
	$name = v::notEmpty();
	$agencyid = v::numeric()->positive();
    $validators = array(
          'contact' => $contactname,
		  'email' => $email,
		  'website'=>$website,
		  'name'=>$name,
		  'agencyid'=>$agencyid 
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

$container['banneradd_val'] = function ($c) {
    //Create the validators
    $description = v::notEmpty();
	$storagetype = v::notEmpty();
	$weight = v::notEmpty();

    $validators = array(
          'description' => $description ,
		  'storagetype' => $storagetype
		 //'imageurl'=>$imageurl,
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};


$container['banneradd_edit'] = function ($c) {
    //Create the validators
   $mode = v::notEmpty();
   $description = v::notEmpty();
   $storagetype = v::notEmpty();
	
    $validators = array(
        'description' => $description,
        'storagetype' => $storagetype,
        'mode' => $mode 
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};



$container['userid_val'] = function ($c) {
    //Create the validators    
    $userid=v::numeric()->positive();
    $validators = array(
        'userid'	=> $userid       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};



$container['userid_edit'] = function ($c) {
    //Create the validators    
    $userid=v::numeric()->positive();
    $mode = v::notEmpty();
    $validators = array(
        'userid'	=> $userid  ,
        'mode' =>$mode     		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};




$container['advertiser_val'] = function ($c) {
    //Create the validators    
    $advertiserid=v::numeric()->positive();
    $validators = array(
        'advertiserid'	=> $advertiserid       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};


$container['accountid_val'] = function ($c) {
    //Create the validators    
    $accountid=v::numeric()->positive();
    $validators = array(
        'accountid'	=> $accountid       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};

$container['affid_val'] = function ($c) {
    //Create the validators    
    $affiliateid=v::numeric()->positive();
    $validators = array(
        'affiliateid'	=> $affiliateid       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};


$container['clientid_val'] = function ($c) {
    //Create the validators    
    $client_id=v::numeric()->positive();
    $validators = array(
        'client_id'	=> $client_id       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};

$container['agencyid_val'] = function ($c) {
    //Create the validators    
    $agencyid=v::numeric()->positive();
    $validators = array(
        'agencyid'	=> $agencyid       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};
 
 
$container['campaignid_val'] = function ($c) {
    //Create the validators    
    $campaign_id=v::numeric()->positive();
    $campaignname =v::notEmpty(); 
	$start_date =v::date("Y-m-d H:i:s");
	$revenue_type= v::notEmpty();    	
	$priority= v::notEmpty();    
    $weight= v::notEmpty();    		
    // $mode = v::notEmpty();
    $validators = array(
        'campaign_id'	=> $campaign_id ,
        'campaignname' => $campaignname,
        'start_date'=>$start_date,
		'revenue_type'=>$revenue_type,
        'weight'=>$weight, 
		'priority'=>$priority     	     		
              		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};



$container['campaignid_val1'] = function ($c) {
    //Create the validators    
    $campaignname =v::notEmpty(); 
	$start_date =v::date("Y-m-d H:i:s");
	$revenue_type= v::notEmpty();    	
	$weight= v::notEmpty();    	
    $mode = v::notEmpty();
    $validators = array( 
        'campaignname' => $campaignname,
        'start_date'=>$start_date,
		'revenue_type'=>$revenue_type,
		'weight'=>$weight,     		
        'mode'	=> $mode       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};




$container['user_val'] = function ($c) {
    //Create the validators
    $contactname=v::notEmpty();
    $email = v::notEmpty();
    $username = v::notEmpty();
    // $password = v::notEmpty();
    $accountid = v::notEmpty();
    $validators = array(
        'contactname'=> $contactname,
        'email'	=> $email,       		     		
        'username'	=> $username,       		
        // 'password'	=> $password,       		
        'accountid'	=> $accountid       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};





$container['advertiser_validate'] = function ($c) {
    //Create the validators
   $contact = v::notEmpty();
	$email = v::notEmpty();
	$clientname= v::notEmpty();
    $validators = array(
          'contact' => $contact,
		  'email' => $email,
		  'clientname'=>$clientname
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};



$container['campaign_validate'] = function ($c) {
    //Create the validators
    $campaignname =v::notEmpty(); 
	// $start_date =v::date("Y-m-d H:i:s");
	$revenue_type= v::notEmpty();    	
	// $priority= v::notEmpty();    	
    $validators = array(
		  'campaignname' => $campaignname,
		//   'start_date'=>$start_date,
		  'revenue_type'=>$revenue_type,
		//   'priority'=>$priority
		
    );    
    return new \DavidePastore\Slim\Validation\Validation($validators);
};
// $container['add_banner'] = function ($c) {
//     //Create the validators
//     $description =v::notEmpty(); 
// 	$imageurl =v::date("Y-m-d H:i:s");
// 	$width= v::notEmpty();    	
// 	$height= v::notEmpty();    	
//     $storagetype= v::notEmpty();    	
//     $validators = array(
// 		  'description' => $description,
// 		  'imageurl'=>$imageurl,
// 		  'width'=>$width,
// 		  'height'=>$height,
//           'storagetype'=>$storagetype
		
//     );    
//     return new \DavidePastore\Slim\Validation\Validation($validators);
// };


$container['datevalidation'] = function ($c) {
   
    $start_date =v::date("Y-m-d%20H:i:s");
    $end_date =v::date("Y-m-d%20H:i:s");
    $validators = array(
        'start_date' => $start_date,
        'end_date' => $end_date
        		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};


//~ $this->Model->set($this->request->data);
//~ 
//~ if (!$this->Model->validates()) {
    //~ $this->response->statusCode(400);
    //~ $this->set('_serialize', array(
       //~ 'message' => 'Invalid Parameter',
       //~ 'url' => '/resource',
    //~ ));
//~ }


$container['limitValidation'] = function ($c) {
	
    //Create the validators
    $bannerid =v::numeric()->positive();
    

    $validators = array(
        'bannerid' => $bannerid,
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};



$container['az_link'] = function ($c) {
	
    //Create the validators
    $zoneid = v::notEmpty();
    $bannerid = v::notEmpty();
   
	
    $validators = array(
        'bannerid' => $bannerid,
        'zoneid' => $zoneid
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};




$container['cz_link'] = function ($c) {
	
    //Create the validators
    $zoneid = v::notEmpty();
    $campaignid = v::notEmpty();
	
    $validators = array(
        'zoneid' => $zoneid,
        'campaignid' => $campaignid
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};

$container['add_bannerredirect'] = function ($c) {
    //Create the validators
   $description = v::notEmpty();
	$storagetype = v::notEmpty();
	//$imageurl = v::notEmpty(); 
	$url = v::notEmpty();
    $validators = array(
          'description' => $description ,
		  'storagetype' => $storagetype,
		  'url'=>$url
		 //'imageurl'=>$imageurl,
		  
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};






$container['edit_redirectbanner'] = function ($c) {
    //Create the validators
    $mode =v::notEmpty();
   $description = v::notEmpty();
	$storagetype = v::notEmpty();
	//$imageurl = v::notEmpty(); 
	$url = v::notEmpty();
    $validators = array(
		'mode' => $mode ,
        'description' => $description ,
		'storagetype' => $storagetype,
		'url'=>$url
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

$container['banner_addurlintoIframe'] = function ($c) {
    //Create the validators
   $description = v::notEmpty();
	$storagetype = v::notEmpty();
	//$imageurl = v::notEmpty(); 
	$url = v::notEmpty();
    $validators = array(
          'description' => $description ,
		  'storagetype' => $storagetype
		 //'imageurl'=>$imageurl,
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

$container['banner_editurlintoIframe'] = function ($c) {
    //Create the validators
   $description = v::notEmpty();
	$storagetype = v::notEmpty();
	//$imageurl = v::notEmpty(); 
	$url = v::notEmpty();
    $validators = array(
          'description' => $description ,
		  'storagetype' => $storagetype
		 //'imageurl'=>$imageurl,		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

//VAST 

$container['banneraddvastinline_val'] = function ($c) {
    //Create the validators
    $description = v::notEmpty();
	$storagetype = v::notEmpty();
	$vast_type = v::notEmpty(); 
	$vid_upload_type = v::notEmpty(); 
    $validators = array(
          'description' => $description ,
		  'storagetype' => $storagetype,
		  'vast_type' => $vast_type,
		   'vid_upload_type' => $vid_upload_type,
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};
$container['bannereditvastinline_val'] = function ($c) {
    //Create the validators
   $description = v::notEmpty();
	$storagetype = v::notEmpty();
	$vast_type = v::notEmpty();  
	$vid_upload_type = v::notEmpty(); 
    $validators = array(
          'description' => $description ,
		  'storagetype' => $storagetype,
		  'vast_type' => $vast_type,
		   'vid_upload_type' => $vid_upload_type,
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

$container['banneraddvastoverlay_val'] = function ($c) {
    //Create the validators
    $description = v::notEmpty();
	$storagetype = v::notEmpty();
	$vast_type = v::notEmpty(); 
	$vast_overlay_format = v::notEmpty(); 
	$url = v::notEmpty();
    $validators = array(
          'description' => $description ,
		  'storagetype' => $storagetype,
		  'vast_type' => $vast_type,
		  'vast_overlay_format' => $vast_overlay_format,
		  'url'=>$url 
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};
