<?php


/*----------------  SSP add -------------*/
$app->post('/dsp_add', function ($request, $response)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $response = array('response' => 'error', 'message' => 'Please check with input parameters');
        return $this->response->withJson($response);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $dspname = $input['exchange_name'];
        $ping_url = $input['ping_url'];
        $auction_currency = $input['auction_currency'];
        $auction_type = $input['auction_type'];
        $demandtype = $input['demandtype'];
		$deal_limit = $input['deal_limit'];
        $added_on = date('Y-m-d H:i:s');
        $open_rtb_version = $input['open_rtb_version'];
        $digital_signature = $input['digital_signature'];
		$gzip = $input['gzip'];
        if (!empty($dspname) || !empty($ping_url) || !empty($auction_currency) || !empty($auction_type) ||  !empty($demandtype) || !empty($added_on) || !empty($open_rtb_version)|| !empty($status)|| !empty($deal_limit)|| !empty($digital_signature)|| !empty($gzip))
        {
			
            $stvv = "INSERT INTO ".$table_prefix."dj_ad_exchange(exchange_name,ping_url,auction_currency,auction_type,demandtype,added_on,open_rtb_version,status,gzip,digital_signature,deal_limit) VALUES (:exchange_name,:ping_url,:auction_currency,:auction_type,:demandtype,now(),:open_rtb_version,1,:gzip,:digital_signature,:deal_limit)";
            $sthh = $this->db->prepare($stvv);
            $sthh->bindParam("exchange_name", $dspname);
            $sthh->bindParam("ping_url", $ping_url);
            $sthh->bindParam("auction_currency", $auction_currency);
            $sthh->bindParam("auction_type", $auction_type);
            $sthh->bindParam("demandtype", $demandtype);
            $sthh->bindParam("open_rtb_version", $open_rtb_version);
			$sthh->bindParam("deal_limit", $deal_limit);
			$sthh->bindParam("gzip", $gzip);
			$sthh->bindParam("digital_signature", $digital_signature);
            $sthh->execute();
            $exchange_id = $this->db->lastInsertId();
            if ($exchange_id)
            {
                $response = array('response' => 'ok', 'message' => 'DSP has been added successfully with id:'.$exchange_id);
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please check with input parameters', 'response' => 'error', 'status' => '204');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('dsp_validate'));
/*----------------  SSP add -------------*/

/*----------------  SSP edit -------------*/
$app->post('/dsp_edit/[{exchange_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $response = array('response' => 'error', 'message' => 'Please check with input parameters');
        return $this->response->withJson($response);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $dspname = $input['exchange_name'];
        $ping_url = $input['ping_url'];
        $auction_currency = $input['auction_currency'];
        $auction_type = $input['auction_type'];
        $deal_limit = $input['deal_limit'];
        $demandtype = $input['demandtype'];
        $open_rtb_version = $input['open_rtb_version'];
        $gzip = $input['gzip'];
        $digital_signature = $input['digital_signature'];
        $exchange_id = $args['exchange_id'];
        
        $auctype = array("1", "2");
        if (!in_array($auction_type, $auctype))
        {
            $response = array('response' => 'error', 'message' => 'Please insert valid auction_type field');
            return $this->response->withJson($response);
        }
        $auc = array("0");
        if (!in_array($auction_currency, $auc))
        {
            $response = array('response' => 'error', 'message' => 'Please insert valid auction_currency field');
            return $this->response->withJson($response);
        }
        $open = array("5", "6");
        if (!in_array($open_rtb_version, $open))
        {
            $response = array('response' => 'error', 'message' => 'Please insert valid open_rtb_version field');
            return $this->response->withJson($response);
        }
        $demandt = array("1", "2", "3");
        if (!in_array($demandtype, $demandt))
        {
            $response = array('response' => 'error', 'message' => 'Please insert valid demand type field');
            return $this->response->withJson($response);
        }
        
        $stcc = "SELECT * FROM ".$table_prefix."dj_ad_exchange where exchange_id =".$exchange_id;
        $stdd = $this->db->prepare($stcc);
        $stdd->execute();
        $users = $stdd->fetch();
        $mode = $input['mode'];
        if (empty($dspname))
        {
            $response = array('response' => 'error', 'message' => 'Please insert valid dspname field');
            return $this->response->withJson($response);
        }
        else if (empty($ping_url))
        {
            $response = array('response' => 'error', 'message' => 'Please insert valid ping_url field');
            return $this->response->withJson($response);
        }
        else if (empty($demandtype))
        {
            $response = array('response' => 'error', 'message' => 'Please insert valid Demand Type field');
            return $this->response->withJson($response);
        }
        if ($users)
        {
            $accc = "update ".$table_prefix."dj_ad_exchange set exchange_name='".$dspname."', ping_url='".$ping_url."', auction_currency='".$auction_currency."', auction_type='".$auction_type."', deal_limit='".$deal_limit."', demandtype='".$demandtype."', open_rtb_version='".$open_rtb_version."', gzip='".$gzip."', digital_signature='".$digital_signature."' where exchange_id=$exchange_id";
            $edit_accc = $this->db->prepare($accc);
            $edit_accc->execute();
            $response = array('response' => 'ok', 'message' => 'DSP details has been updated successfully with id:'.$exchange_id);
            return $this->response->withJson($response);
        }
        else
        {
            $response = array('message' => 'Please enter valid DSP id!', 'response' => 'error', 'status' => '204');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('dsp_edit'));
/*----------------  SSP edit -------------*/

/*----------------  SSP delete -------------*/
$app->delete('/dsp_delete/[{exchange_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $exchange_id = $args['exchange_id'];
        $stc = "SELECT * FROM ".$table_prefix."dj_ad_exchange where exchange_id =".$exchange_id;
        $std = $this->db->prepare($stc);
        $std->execute();
        $users = $std->fetch();
        if ($users)
        {
            $dsp = "DELETE FROM ".$table_prefix."dj_ad_exchange WHERE exchange_id=".$exchange_id;
            $del_dsp = $this->db->prepare($dsp);
            $del_dsp->execute();
            $response = array('response' => 'ok', 'message' => 'DSP details Deleted succesfully with exchange_id:'.$exchange_id);
            return $this->response->withJson($response);
        }
        else
        {
            $response = array('message' => 'Please enter valid DSP id!', 'response' => 'error', 'status' => '204');
            return $this->response->withJson($response);
        }
    }
});
/*----------------  SSP delete -------------*/

/*----------------  SSP block/unblock -------------*/
$app->post('/dsp_block/[{exchange_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $exchange_id = $args['exchange_id'];
        $status = $input['status'];
        $validstatus = array("0", "1");
        if (!in_array($status, $validstatus))
        {
            $response = array('response' => 'error', 'message' => 'Please insert valid status field');
            return $this->response->withJson($response);
        }
        $stc = "SELECT * FROM ".$table_prefix."dj_ad_exchange where exchange_id =".$exchange_id;
        $std = $this->db->prepare($stc);
        $std->execute();
        $users = $std->fetch();
        if ($users)
        {
            $dsp = "update {$table_prefix}dj_ad_exchange set status='".$status."' WHERE exchange_id='".$exchange_id."' ";
            $blk_dsp = $this->db->prepare($dsp);
            $blk_dsp->execute();
            if ($status == 1)
            {
                $response = array('response' => 'ok', 'message' => 'SSP Unblocked succesfully with exchange_id:'.$exchange_id);
            }
            else
            {
                $response = array('response' => 'ok', 'message' => 'SSP blocked succesfully with exchange_id:'.$exchange_id);
            }
            return $this->response->withJson($response);
        }
        else
        {
            $response = array('message' => 'Please enter valid DSP id!', 'response' => 'error', 'status' => '204');
            return $this->response->withJson($response);
        }
    }
});
/*----------------  SSP block/unblock -------------*/

/*----------------  SSP single List-------------*/
$app->get('/get_dsp/[{exchange_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $exchange_id = $args['exchange_id'];
        $stc = "select * from ".$table_prefix."dj_ad_exchange where exchange_id=".$exchange_id;
        $std = $this->db->prepare($stc);
        $std->execute();
        $users = $std->fetch();
        if ($users['exchange_id'])
        {
           $userdetails = ['exchange_id' => $users['exchange_id'], 'dspname' => $users['exchange_name'], 'ping_url' => $users['ping_url'], 'auction_currency' => $users['auction_currency'], 'auction_type' => $users['auction_type'], 'deal_limit' => $users['deal_limit'], 'demandtype' => $users['demandtype'], 'open_rtb_version' => $users['open_rtb_version'], 'gzip' => $users['gzip'], 'status' => $users['status'], 'digital_signature' => $users['digital_signature']];
            $data['data'] = $userdetails;
            $data['response'] = "success";
            $data['message'] = "SSP Portal single Data List";
            $data['status'] = "200";
            return $this->response->withJson($data);
        }
        else
        {
            $response = array('message' => 'No DSP Available', 'response' => 'error', 'status' => '204');
            return $this->response->withJson($response);
        }
    }
});
/*----------------  SSP single List-------------*/

/*----------------  SSP all List-------------*/
$app->get('/get_all_dsp', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $exchange_id = $args['exchange_id'];
        $stc = "select * from ".$table_prefix."dj_ad_exchange ORDER BY exchange_id ASC";
        $std = $this->db->prepare($stc);
        $std->execute();
        $users = $std->fetchAll();
        $userdetails = array();
        if ($users)
        {
            foreach ($users as $users)
            {
                $userdetails[] = array('exchange_id' => $users['exchange_id'], 'dspname' => $users['exchange_name'], 'ping_url' => $users['ping_url'], 'auction_currency' => $users['auction_currency'], 'auction_type' => $users['auction_type'], 'deal_limit' => $users['deal_limit'], 'demandtype' => $users['demandtype'], 'open_rtb_version' => $users['open_rtb_version'], 'gzip' => $users['gzip'], 'status' => $users['status'], 'digital_signature' => $users['digital_signature']);
            }
            $data['data'] = $userdetails;
            $data['response'] = "success";
            $data['message'] = "SSP Portal All Data List";
            $data['status'] = "200";
            return $this->response->withJson($data);
        }
        else
        {
            $response = array('message' => 'No DSP Available', 'response' => 'error', 'status' => '204');
            return $this->response->withJson($response);
        }
    }
});
/*----------------  SSP all List-------------*/

/*----------------  DSP add -------------*/
$app->post('/ssp_add', function ($request, $response)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $response = array('response' => 'error', 'message' => 'Please check with input parameters');
        return $this->response->withJson($response);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $ssp_label = $input['ssp_label'];
        $ssp_name = $input['ssp_name'];
        $web_reponse_type = $input['web_reponse_type'];
        $digital_signature = $input['digital_signature'];
		$dspid=$input['dspid'];
        $admin_share = $input['admin_share'];
        $auth_key1 = $input['auth_key'];
        $auth_key = md5($auth_key1.'-'.rand(100, 999));
       
		$dsp_id = "SELECT id as dsp_id FROM {$table_prefix}dj_dsp";
		$alldsp_get = $this->db->prepare($dsp_id);
		$alldsp_get->execute();
		$dspid1 = $alldsp_get->fetchAll();
		// print_r($dspid);exit;
		foreach ($dspid1 as $dsp) {
			if($dsp['dsp_id']==$input['dspid'])
			{
				$value[]=1;
			}
		}
		if(empty($value))
		{
			if ($dspid)  {
				$response = array('response' => 'error', 'msg' => 'Please insert valid dspid ');
				return $this->response->withJson($response);
			}
		}
	
		$webtype = array("html", "xml");	
        if (!in_array($web_reponse_type, $webtype))
        {
            $response = array('response' => 'error', 'message' => 'Please insert valid web_reponse_type field');
            return $this->response->withJson($response);
        }
        if (empty($ssp_label) || empty($ssp_name) || empty($web_reponse_type) || empty($digital_signature) || empty($admin_share) || empty($status) || empty($dspid))
        {
            $stv = "INSERT INTO ".$table_prefix."dj_dsp(label,dsp_portal_name,admin_share,web_response_type,digital_signature,auth_key,dspid,status ) VALUES (:label,:dsp_portal_name,:admin_share,:web_reponse_type,:digital_signature,:auth_key,:dspid,1);";
            $sth = $this->db->prepare($stv);
            $sth->bindParam("label", $ssp_label);
            $sth->bindParam("dsp_portal_name", $ssp_name);
            $sth->bindParam("admin_share", $admin_share);
            $sth->bindParam("web_reponse_type", $web_reponse_type);
            $sth->bindParam("dspid", $dspid);
            $sth->bindParam("digital_signature", $digital_signature);
            $sth->bindParam("auth_key", $auth_key);
            $sth->execute();
            $id = $this->db->lastInsertId();
            if ($id)
            {
                $response = array('response' => 'ok', 'message' => 'SSP has been added successfully with id:'.$id);
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please check with input parameters', 'response' => 'error', 'status' => '204');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('ssp_validate'));
/*----------------  DSP add -------------*/

/*----------------  DSP edit -------------*/
$app->post('/ssp_edit/[{id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $response = array('response' => 'error', 'message' => 'Please check with input parameters');
        return $this->response->withJson($response);
        exit;
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $ssp_label = (isset($input['ssp_label'])) ? $input['ssp_label'] : '';
        $web_response_type = (isset($input['web_response_type'])) ? $input['web_response_type'] : '';
        $digital_signature = (isset($input['digital_signature'])) ? $input['digital_signature'] : '';
        // $status = $input['status'];
        $dspid = $input['dspid'];
        $admin_share = $input['admin_share'];
        $datetime = date('Y-m-d H:i:s');
        $id = $args['id'];
        $stc = "SELECT * FROM ".$table_prefix."dj_dsp where id =".$id;
        $std = $this->db->prepare($stc);
        $std->execute();
        $users = $std->fetch();
		$dsp_id = "SELECT id as dsp_id FROM {$table_prefix}dj_dsp";
		$alldsp_get = $this->db->prepare($dsp_id);
		$alldsp_get->execute();
		$dspid1 = $alldsp_get->fetchAll();
		// print_r($dspid);exit;
		foreach ($dspid1 as $dsp) {
			if($dsp['dsp_id']==$input['dspid'])
			{
				$value[]=1;
			}
		}
		if(empty($value))
		{
			if ($dspid)  {
				$response = array('response' => 'error', 'msg' => 'Please insert valid dspid ');
				return $this->response->withJson($response);
			}
		}
        $webtype = array("html", "xml");
        if (!in_array($web_response_type, $webtype))
        {
            $response = array('response' => 'error', 'message' => 'Please insert valid web_reponse_type field');
            return $this->response->withJson($response);
        }
        $mode = $input['mode'];
        if (empty($ssp_label))
        {
            $response = array('response' => 'error', 'message' => 'Please insert ssp_label field');
            return $this->response->withJson($response);
        }
        elseif (empty($web_response_type))
        {
            $response = array('response' => 'error', 'message' => 'Please insert web_response_type field');
            return $this->response->withJson($response);
        }
        elseif (empty($digital_signature))
        {
            $response = array('response' => 'error', 'message' => 'Please insert digital_signature field');
            return $this->response->withJson($response);
        }
        elseif (empty($admin_share))
        {
            $response = array('response' => 'error', 'message' => 'Please insert admin_share field');
            return $this->response->withJson($response);
        }
        if ($users)
        {
            $acc = "update ".$table_prefix."dj_dsp set label='".$ssp_label."', web_response_type='".$web_response_type."', digital_signature='".$digital_signature."', admin_share='".$admin_share."',dspid='".$dspid."' where id=$id";
            $edit_acc = $this->db->prepare($acc);
            $edit_acc->execute();
            $response = array('response' => 'ok', 'message' => 'SSP details has been updated successfully with id:'.$id);
            return $this->response->withJson($response);
        }
        else
        {
            $response = array('message' => 'Please enter valid SSP id!', 'response' => 'error', 'status' => '204');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('ssp_edit'));
/*----------------  DSP edit -------------*/

/*----------------  DSP delete -------------*/
$app->delete('/ssp_delete/[{id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $id = $args['id'];
        $stc = "SELECT * FROM ".$table_prefix."dj_dsp where id =".$id;
        $std = $this->db->prepare($stc);
        $std->execute();
        $users = $std->fetch();
        if ($users)
        {
            $dsp = "DELETE FROM ".$table_prefix."dj_dsp WHERE id=".$id;
            $del_dsp = $this->db->prepare($dsp);
            $del_dsp->execute();
            $response = array('response' => 'ok', 'message' => 'SSP details Deleted succesfully with id:'.$id);
            return $this->response->withJson($response);
        }
        else
        {
            $response = array('message' => 'Please enter valid SSP id!', 'response' => 'error', 'status' => '204');
            return $this->response->withJson($response);
        }
    }
});
/*----------------  DSP delete -------------*/

/*----------------  DSP block/unblock -------------*/
$app->post('/ssp_block/[{id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $id = $args['id'];
        $status = $input['status'];
        $stc = "SELECT * FROM ".$table_prefix."dj_dsp where id =".$id;
        $std = $this->db->prepare($stc);
        $std->execute();
        $users = $std->fetch();
        $validstatus = array("0", "1");
        if (!in_array($status, $validstatus))
        {
            $response = array('response' => 'error', 'message' => 'Please insert valid status field');
            return $this->response->withJson($response);
        }
        if ($users)
        {
            $dsp = "update {$table_prefix}dj_dsp set status='".$status."' WHERE id='".$id."' ";
            $blk_dsp = $this->db->prepare($dsp);
            $blk_dsp->execute();
            if ($status == 1)
            {
                $response = array('response' => 'ok', 'message' => 'SSP Unblocked succesfully with id:'.$id);
            }
            else
            {
                $response = array('response' => 'ok', 'message' => 'SSP blocked succesfully with id:'.$id);
            }
            return $this->response->withJson($response);
        }
        else
        {
            $response = array('message' => 'Please enter valid SSP id!', 'response' => 'error', 'status' => '204');
            return $this->response->withJson($response);
        }
    }
});
/*----------------  DSP block/unblock -------------*/

/*----------------  DSP single List-------------*/
$app->get('/get_ssp/[{id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $id = $args['id'];
        $stc = "select * from ".$table_prefix."dj_dsp where id=".$id;
        $std = $this->db->prepare($stc);
        $std->execute();
        $users = $std->fetch();
        $web_response_type = $users['web_response_type'] ? "Html" : "XML";
        if ($users['id'])
        {
            $userdetails = array('id' => $users['id'], 'ssp_label' => $users['dsp_portal_name'], 'ssp_name' => $users['label'], 'web_response_type' => $web_response_type, 'digital_signature' => $users['digital_signature'], 'status' => $users['status'], 'dspid' => $users['dspid'], 'admin_share' => $users['admin_share']);
            $data['data'] = $userdetails;
            $data['response'] = "success";
            $data['message'] = "DSP Portal single Data List";
            $data['status'] = "200";
            return $this->response->withJson($data);
        }
        else
        {
            $response = array('message' => 'No SSP Available', 'response' => 'error', 'status' => '204');
            return $this->response->withJson($response);
        }
    }
});
/*----------------  DSP  single List-------------*/

/*----------------  DSP all List-------------*/
$app->get('/get_all_ssp', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $id = $args['id'];
        $stc = "select * from ".$table_prefix."dj_dsp ORDER BY id ASC";
        $std = $this->db->prepare($stc);
        $std->execute();
        $users = $std->fetchAll();
        $userdetails = array();
        if ($users)
        {
            foreach ($users as $users)
            {
                $userdetails[] = array('id' => $users['id'], 'ssp_label' => $users['dsp_portal_name'], 'ssp_name' => $users['label'], 'web_response_type' => $users['web_response_type'], 'digital_signature' => $users['digital_signature'], 'status' => $users['status'], 'dspid' => $users['dspid'], 'admin_share' => $users['admin_share']);
            }
            $data['data'] = $userdetails;
            $data['response'] = "success";
            $data['message'] = "DSP Portal All Data List";
            $data['status'] = "200";
            return $this->response->withJson($data);
        }
        else
        {
            $response = array('message' => 'No SSP Available', 'response' => 'error', 'status' => '204');
            return $this->response->withJson($response);
        }
    }
});
/*----------------  DSP all List-------------*/


$app->post('/add_title', function($request, $response)
{   
    if($request->getAttribute('has_errors')) {
        //There are errors, read them
        $response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit; 
    } else{
        $input = $request->getParsedBody();
        $table_prefix= $this->get('settings')['path']['table_prefix'];
        $title_name=$input['title_name'];

		$stc = "select * from ".$table_prefix."target_title where name=:title_name";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("title_name",$title_name);
		$std->execute();
		$titles = $std->fetchAll();
		$target_titles_id = $titles[0]['id'];
		if($target_titles_id == ""){
			$stc = "INSERT INTO ".$table_prefix."target_title (`name`) 	VALUES (:title_name);";
			$std = $this->db->prepare($stc);        
			$std->bindParam("title_name", $title_name);
			$std->execute();  
			$target_title_id = $this->db->lastInsertId();   
			if($target_title_id)
			{
				$response = array('response'=>'Success','message'=>'Title has been added successfully with id:'.$target_title_id,'status' => '200');
				return $this->response->withJson($response);  
			}
		}else{
			$response = array('response'=>'error','message'=>'Title name is already exists.','status' => '403');
			return $this->response->withJson($response); 
		}
        }
})->add($container->get('target_title'));

$app->post('/edit_title/[{title_id}]', function($request, $response, $args)
{   
    if($request->getAttribute('has_errors')) {
        //There are errors, read them
        $response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit; 
    } else{
        $input = $request->getParsedBody();

        $table_prefix= $this->get('settings')['path']['table_prefix'];
        $title_name=$input['title_name'];
		$title_id = $args['title_id'];

		$sql = "Select name from ".$table_prefix."target_title where id=".$title_id;
		$std = $this->db->prepare($sql);
		$std->execute();
		$title = $std->fetchAll();
		
		if($title){
			$std="update ".$table_prefix."target_title set name='".$title_name."' where id='".$title_id."'";
			$edit_std=$this->db->prepare($std);			
	
			if($edit_std->execute())
			{
				$response = array('response'=>'ok','message'=>'Title has been updated successfully','status' => '200');
				return $this->response->withJson($response);  
			}
        }else{
			$response = ['response'=>'error','message'=>'Please enter the valid Title id!','status' => '404'];
			return $this->response->withJson($response);
		}
	}
})->add($container->get('target_title'));


$app->delete('/delete_title/[{title_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors')) {
        //There are errors, read them
		$response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit;     
    } else {
		
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings')['path']['table_prefix'];
		$title_id = $args['title_id'];

		$stc = "select * from ".$table_prefix."target_title where id=:title_id";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("title_id",$title_id);
		$std->execute();
		$titles = $std->fetchAll();
		$target_title_id = $titles[0]['id'];
		if($target_title_id){
			$std = "DELETE FROM ".$table_prefix."target_title WHERE id=:title_id";
			$del_std=$this->db->prepare($std);
			$del_std->bindParam(":title_id",$args['title_id']);

			if($del_std->execute()){
				$response = array('response'=>'Success','message'=>'Title Deleted succesfully!','status' => '200');
				return $this->response->withJson($response);
			}
		}else{
			$response = array('response'=>'error','message'=>'Please enter valid title id!','status' => '404');
			return $this->response->withJson($response); 
		}	
	}
});


$app->get('/get_all_titles', function($request, $response)
{
    if ($request->getAttribute('has_errors')) {
        //There are errors, read them
		$response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit;      
    }else{
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings')['path']['table_prefix'];
			$stc = "SELECT * FROM ".$table_prefix."target_title";
			$std = $this->db->prepare($stc);
			$std->execute();
			$titles = $std->fetchAll();
			$titledetails = array();
			if(count($titles)>0)
			{				
				foreach($titles as $each_title){
					$titledetails[] = array(
						'title_id'=>$each_title['id'],
						'title_name'=>$each_title['name']
					);
				}	
				$data['data'] = $titledetails;
		        $data['response'] = "success";
		        $data['message'] = "Title List";
		        $data['status'] = "200";
					return $this->response->withJson($data);
			}
			else{	
				$response = array('response'=>'ok','message'=>'No titles available!','status' => '204');
				return $this->response->withJson($response);	
			}
    }
});

$app->get('/get_title/[{title_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors')) {
        //There are errors, read them
		$response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit;      
    }else{
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings')['path']['table_prefix'];
		$title_id = $args['title_id'];

		$stc = "select * from ".$table_prefix."target_title where id=:title_id";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("title_id",$title_id);
		$std->execute();
		$titles = $std->fetchAll();
		$target_title_id = $titles[0]['id'];

			if($target_title_id)
			{				
				$titledetails= array(
					'title_id'=>$titles[0]['id'],
					'title_name'=>$titles[0]['name']
				);
				$data['data'] = $titledetails;
		        $data['response'] = "success";
		        $data['message'] = "Title Data List";
		        $data['status'] = "200";
				
				return $this->response->withJson($data);
			}
			else{	
				$response = array('response'=>'ok','message'=>'No titles available!','status' => '204');
				return $this->response->withJson($response);	
			}
    }
});

$app->post('/add_episode', function($request, $response)
{   
    if($request->getAttribute('has_errors')) {
        //There are errors, read them
        $response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit; 
    } else{
        $input = $request->getParsedBody();
        $table_prefix= $this->get('settings')['path']['table_prefix'];
        $episode_name=$input['episode_name'];

		$stc = "select * from ".$table_prefix."target_episode where name=:episode_name";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("episode_name",$episode_name);
		$std->execute();
		$episode = $std->fetchAll();
		$target_episode_id = $episode[0]['id'];
		if($target_episode_id == ""){
			$stc = "INSERT INTO ".$table_prefix."target_episode (`name`) 	VALUES (:episode_name);";
			$std = $this->db->prepare($stc);        
			$std->bindParam("episode_name", $episode_name);
			$std->execute();  
			$target_episode_id = $this->db->lastInsertId();   
		if($target_episode_id)
		{
			$response = array('response'=>'Success','message'=>'Episode has been added successfully with id:'.$target_episode_id,'status' => '200');
			return $this->response->withJson($response);  
        }
		}else{
			$response = array('response'=>'error','message'=>'Episode name is already exists.','status'=>'403');
			return $this->response->withJson($response); 
		}
        }
})->add($container->get('target_episode'));

$app->post('/edit_episode/[{episode_id}]', function($request, $response, $args)
{   
    if($request->getAttribute('has_errors')) {
        //There are errors, read them
        $response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit; 
    } else{
        $input = $request->getParsedBody();
		
        $table_prefix= $this->get('settings')['path']['table_prefix'];
        $episode_name=$input['episode_name'];
		$target_episode_id = $args['episode_id'];
		$std = "Select name from ".$table_prefix."target_episode where id=".$target_episode_id;
		$edit_std=$this->db->prepare($std);			
		$edit_std->execute();
		$episode = $edit_std->fetchAll();
		if($episode)
		{
			$std="update ".$table_prefix."target_episode set name='".$episode_name."' where id='".$target_episode_id."'";
			$edit_std=$this->db->prepare($std);	
			if($edit_std->execute())
			{
			$response = array('response'=>'Success','message'=>'Episode has been updated successfully','status' => '200');
			return $this->response->withJson($response);  
			}
		}
			else{
				$response = ['response'=>'error','message'=>'Please enter the valid Episode id!','status' => '404'];
				return $this->response->withJson($response);
			}
      
        }
})->add($container->get('target_episode'));

$app->delete('/delete_episode/[{episode_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors')) {
        //There are errors, read them
		$response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit;     
    } else {
		
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings')['path']['table_prefix'];
		$episode_id = $args['episode_id'];

		$stc = "select * from ".$table_prefix."target_episode where id=:episode_id";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("episode_id",$episode_id);
		$std->execute();
		$episodes = $std->fetchAll();
		$target_episode_id = $episodes[0]['id'];
		if($target_episode_id){
			$std = "DELETE FROM ".$table_prefix."target_episode WHERE id=:episode_id";
			$del_std=$this->db->prepare($std);
			$del_std->bindParam(":episode_id",$args['episode_id']);

			if($del_std->execute()){
				$response = array('response'=>'Success','message'=>'Episode Deleted succesfully!','status' => '200');
				return $this->response->withJson($response);
			}
		}else{
			$response = array('response'=>'error','message'=>'Please enter valid episode id!','status' => '404');
			return $this->response->withJson($response); 
		}	
		}   
});

$app->get('/get_all_episodes', function($request, $response)
{
    if ($request->getAttribute('has_errors')) {
        //There are errors, read them
		$response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit;     
    }else{
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings')['path']['table_prefix'];
			$stc = "SELECT * FROM ".$table_prefix."target_episode";
			$std = $this->db->prepare($stc);
			$std->execute();
			$episodes = $std->fetchAll();
			$episodedetails = array();
			if(count($episodes)>0)
			{				
				foreach($episodes as $each_episode){
					$episodedetails[]= array(
						'episode_id'=>$each_episode['id'],
						'episode_name'=>$each_episode['name']
					);
				}	
				$data['data'] = $episodedetails;
		        $data['response'] = "success";
		        $data['message'] = "Episode List";
		        $data['status'] = "200";
					return $this->response->withJson($data);
			}
			else{	
				$response = array('response'=>'ok','Message'=>'No episode available!','status' => '204');
				return $this->response->withJson($response);	
			}
    }
});

$app->get('/get_episode/[{episode_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors')) {
        //There are errors, read them
		$response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit;    
    }else{
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings')['path']['table_prefix'];
		$episode_id = $args['episode_id'];

		$stc = "select * from ".$table_prefix."target_episode where id=:episode_id";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("episode_id",$episode_id);
		$std->execute();
		$episodes = $std->fetchAll();
		$target_episode_id = $episodes[0]['id'];
	
			if($target_episode_id)
			{				
				$episodedetails= array(
					'episode_id'=>$episodes[0]['id'],
					'episode_name'=>$episodes[0]['name']
				);
				$data['data'] = $episodedetails;
				$data['response'] = "success";
		        $data['message'] = "Episode Data List";
		        $data['status'] = "200";
				return $this->response->withJson($data);
			}
			else{	
				$response = array('response'=>'ok','message'=>'No episodes available!','status' => '404');
				return $this->response->withJson($response);	
			}
    }
});

$app->post('/add_series', function($request, $response)
{   
    if($request->getAttribute('has_errors')) {
        //There are errors, read them
        $response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit; 
    } else{
        $input = $request->getParsedBody();
        $table_prefix= $this->get('settings')['path']['table_prefix'];
        $series_name=$input['series_name'];
		$stc = "select * from ".$table_prefix."target_series where name=:series_name";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("series_name",$series_name);
		$std->execute();
		$series = $std->fetchAll();
		$target_series_id = $series[0]['id'];
		if($target_series_id == ""){
			$stc = "INSERT INTO ".$table_prefix."target_series (`name`) 	VALUES (:series_name);";
			$std = $this->db->prepare($stc);        
			$std->bindParam("series_name", $series_name);
			$std->execute();  
			$target_series_id = $this->db->lastInsertId();   
			if($target_series_id)
			{
				$response = array('response'=>'Success','message'=>'Series has been added successfully with id:'.$target_series_id,'status' => '200');
				return $this->response->withJson($response);  
			}
		}else{
			$response = array('response'=>'error','message'=>'Series name is already exists.','status'=>'403');
			return $this->response->withJson($response); 
		}
        }
})->add($container->get('target_series'));

$app->post('/edit_series/[{series_id}]', function($request, $response, $args)
{   
    if($request->getAttribute('has_errors')) {
        //There are errors, read them
        $response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit; 
    } else{
        $input = $request->getParsedBody();
		
        $table_prefix= $this->get('settings')['path']['table_prefix'];
        $series_name=$input['series_name'];
		$series_id = $args['series_id'];
		$stc = "select * from ".$table_prefix."target_series where id=:series_id";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("series_id",$series_id);
		$std->execute();
		$series = $std->fetchAll();
		$target_series_id = $series[0]['id'];
		if($target_series_id){
			$std="update ".$table_prefix."target_series set name='".$series_name."' where id='".$target_series_id."'";
			$edit_std=$this->db->prepare($std);			
	 
			if($edit_std->execute())
			{
				$response = array('response'=>'Success','message'=>'Series has been updated successfully','status' => '200');
				return $this->response->withJson($response);  
			}
		}else{
			$response = array('response'=>'error','message'=>'Please enter the valid series id.','status' => '404');
			return $this->response->withJson($response);  
		}
        }
})->add($container->get('target_series'));
 
$app->delete('/delete_series/[{series_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors')) {
        //There are errors, read them
		$response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit;     
    } else {
		
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings')['path']['table_prefix'];
		$series_id = $args['series_id'];

		$stc = "select * from ".$table_prefix."target_series where id=:series_id";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("series_id",$series_id);
		$std->execute();
		$series = $std->fetchAll();
		$target_series_id = $series[0]['id'];
		if($target_series_id){
			$std = "DELETE FROM ".$table_prefix."target_series WHERE id=:series_id";
			$del_std=$this->db->prepare($std);
			$del_std->bindParam(":series_id",$args['series_id']);

			if($del_std->execute()){
				$response = array('response'=>'Success','message'=>'Series Deleted Succesfully!','status' => '200');
				return $this->response->withJson($response);
			}
		}else{
			$response = array('response'=>'error','message'=>'Please enter valid series id!','status' => '404');
			return $this->response->withJson($response); 
		}	
		}   
});

$app->get('/get_all_series', function($request, $response)
{
    if ($request->getAttribute('has_errors')) {
        //There are errors, read them
		$response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit;       
    }else{
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings')['path']['table_prefix'];
			$stc = "SELECT * FROM ".$table_prefix."target_series";
			$std = $this->db->prepare($stc);
			$std->execute();
			$series = $std->fetchAll();
			$seriesdetails = array();
			if(count($series)>0)
			{				
				foreach($series as $each_series){
					$seriesdetails[]= array(
						'series_id'=>$each_series['id'],
						'series_name'=>$each_series['name']
					);
				}
				$data['data'] = $seriesdetails;
		        $data['response'] = "success";
		        $data['message'] = "Series List";
		        $data['status'] = "200";
				return $this->response->withJson($data);
			}
			else{	
				$response = array('response'=>'ok','message'=>'No series available!','status' => '204');
				return $this->response->withJson($response);	
			}
    }
});

$app->get('/get_series/[{series_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);     
    }else{
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings')['path']['table_prefix'];
		$series_id = $args['series_id'];

		$stc = "select * from ".$table_prefix."target_series where id=:series_id";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("series_id",$series_id);
		$std->execute();
		$series = $std->fetchAll();
		$target_series_id = $series[0]['id'];
	
			if($target_series_id)
			{				
				$seriesdetails = array(
					'series_id'=>$series[0]['id'],
					'series_name'=>$series[0]['name']
				);
				$data['data'] = $seriesdetails;
		        $data['response'] = "success";
		        $data['message'] = "Series single data list";
		        $data['status'] = "200";
				return $this->response->withJson($data);
			}
			else{	
				$response = array('response'=>'Error','message'=>'Please Enter the valid Series id!','status' => '204');
				return $this->response->withJson($response);	
			}
    }
});

$app->post('/add_gender', function($request, $response)
{   
    if($request->getAttribute('has_errors')) {
        //There are errors, read them
        $response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit; 
    }else{
        $input = $request->getParsedBody();
        $table_prefix= $this->get('settings')['path']['table_prefix'];
        $gender_name=$input['gender_name'];
		$stc = "select * from ".$table_prefix."target_gender where name=:gender_name";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("gender_name",$gender_name);
		$std->execute();
		$genders = $std->fetchAll();
		$target_genders_id = $genders[0]['id'];
		if($target_genders_id == ""){
			$stc = "INSERT INTO ".$table_prefix."target_gender (`name`) 	VALUES (:gender_name);";
			$std = $this->db->prepare($stc);        
			$std->bindParam("gender_name", $gender_name);
			$std->execute();  
			$target_gender_id = $this->db->lastInsertId();   
			if($target_gender_id)
			{
				$response = array('response'=>'Success','message'=>'Gender has been added successfully with id:'.$target_gender_id,'status' => '200');
				return $this->response->withJson($response);  
			}
		}else{
			$response = array('response'=>'error','message'=>'Gender name is already exists.','status'=>'403');
			return $this->response->withJson($response); 
		}
        }
})->add($container->get('target_gender'));

$app->post('/edit_gender/[{gender_id}]', function($request, $response, $args)
{   
    if($request->getAttribute('has_errors')) {
        //There are errors, read them
        $response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit; 
    } else{
        $input = $request->getParsedBody();
		
        $table_prefix= $this->get('settings')['path']['table_prefix'];
        $gender_name=$input['gender_name'];
		$gender_id = $args['gender_id'];
		$stc = "select * from ".$table_prefix."target_gender where id=:gender_id";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("gender_id",$gender_id);
		$std->execute();
		$genders = $std->fetchAll();
		$target_genders_id = $genders[0]['id'];
		if($target_genders_id){
			$std="update ".$table_prefix."target_gender set name='".$gender_name."' where id='".$target_genders_id."'";
			$edit_std=$this->db->prepare($std);			
	 
			if($edit_std->execute())
			{
				$response = array('response'=>'Success','message'=>'Gender has been updated successfully','status' => '200');
				return $this->response->withJson($response);  
			}
		}else{
			$response = array('response'=>'error','message'=>'Please enter the valid gender id.','status' => '404');
			return $this->response->withJson($response);  
		}
		
        }
})->add($container->get('target_gender'));
 
$app->delete('/delete_gender/[{gender_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors')) {
        //There are errors, read them
		$response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit; 
    } else {
		
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings')['path']['table_prefix'];
		$gender_id = $args['gender_id'];

		$stc = "select * from ".$table_prefix."target_gender where id=:gender_id";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("gender_id",$gender_id);
		$std->execute();
		$genders = $std->fetchAll();
		$target_genders_id = $genders[0]['id'];
		if($target_genders_id){
			$std = "DELETE FROM ".$table_prefix."target_gender WHERE id=:gender_id";
			$del_std=$this->db->prepare($std);
			$del_std->bindParam(":gender_id",$args['gender_id']);

			if($del_std->execute()){
				$response = array('response'=>'Success','message'=>'Gender Deleted Succesfully!','status' => '200');
				return $this->response->withJson($response);
			}
		}else{
			$response = array('response'=>'error','message'=>'Please enter valid gender id!','status' => '404');
			return $this->response->withJson($response); 
		}	
		}   
});

$app->get('/get_all_genders', function($request, $response)
{
    if ($request->getAttribute('has_errors')) {
        //There are errors, read them
		$response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit;   
    }else{
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings')['path']['table_prefix'];
			$stc = "SELECT * FROM ".$table_prefix."target_gender";
			$std = $this->db->prepare($stc);
			$std->execute();
			$genders = $std->fetchAll();
			$genderdetails = array();
			if(count($genders)>0)
			{				
				foreach($genders as $each_gender){
					$genderdetails[]= array(
						'gender_id'=>$each_gender['id'],
						'gender_name'=>$each_gender['name']
					);
				}
				$data['data'] = $genderdetails;
		        $data['response'] = "success";
		        $data['message'] = "Gender List";
		        $data['status'] = "200";
				return $this->response->withJson($data);
			}
			else{	
				$response = array('response'=>'ok','message'=>'No gender available!','status' => '204');
				return $this->response->withJson($response);	
			}
    }
});

$app->get('/get_genders/[{gender_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors')) {
        //There are errors, read them
		$response = array('response'=>'error','message'=>'Please check with input parameters','status' => '404');
		return $this->response->withJson($response);exit;      
    }else{
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings')['path']['table_prefix'];
		$gender_id = $args['gender_id'];

		$stc = "select * from ".$table_prefix."target_gender where id=:gender_id";		                 
		$std = $this->db->prepare($stc);
		$std->bindParam("gender_id",$gender_id);
		$std->execute();
		$genders = $std->fetchAll();
		$target_genders_id = $genders[0]['id'];
	
			if($target_genders_id)
			{				
				$gendersdetails= array(
					'genders_id'=>$genders[0]['id'],
					'genders_name'=>$genders[0]['name']
				);
				$data['data'] = $genderdetails;
		        $data['response'] = "success";
		        $data['message'] = "Gender single data List";
		        $data['status'] = "200";
				return $this->response->withJson($data);
			}
			else{	
				$response = array('response'=>'ok','message'=>'No genders available!','status' => '204');
				return $this->response->withJson($response);	
			}
    }
});


/* 
 * 
 * 
 * 
 */

/*----------------  Agency -------------*/
/*
 * Agency ADD
 * 
 * Input Parameters:
 * --------------- 
 * name 
 * contact
 * email
 * username 
 * password  
 */

//~ require("config.php");
$app->post('/agency_add', function ($request, $response) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$name = $input['name'];
		$contactname = $input['contact'];
		$email = $input['email'];
		$status = $input['status'];

		$datetime = date('Y-m-d H:i:s');
		/*  status value allowed 0-Active,1-Suspended and 4-Inactive  */
		if ($status != 0) {
			$validstatus = array("0", "1", "4");

			if (!in_array($status, $validstatus) || $status == -0) {
				$response = array('response' => 'error', 'message' => 'Please insert valid status field', 'status' => '404');
				return $this->response->withJson($response);
			}
		}

		if (!empty($name) || !empty($contactname) || !empty($email) || !empty($status)) {
			$stc = "INSERT INTO " . $table_prefix . "accounts (account_type, account_name) 	VALUES ('MANAGER',:name);";
			$std = $this->db->prepare($stc);
			$std->bindParam("name", $name);
			$std->execute();
			$account_id = $this->db->lastInsertId();

			$stv = "INSERT INTO " . $table_prefix . "agency(name, contact,email,status,updated,account_id) VALUES (:name,:contact,:email,:status,:updated,:account_id);";
			$sth = $this->db->prepare($stv);
			$sth->bindParam("name", $name);
			$sth->bindParam("contact", $contactname);
			$sth->bindParam("email", $email);
			$sth->bindParam("status", $status);
			$sth->bindParam("updated", $datetime);
			$sth->bindParam("account_id", $account_id);
			$sth->execute();
			$agency_id = $this->db->lastInsertId();

			if ($account_id) {
				$response = array('response' => 'success', 'message' => 'Agency has been added successfully with id:' . $agency_id, 'status' => '200');
				return $this->response->withJson($response);
			}
		} else {
			$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('agency_validate'));


/*
 * Agency EDIT
 * 
 * Input Parameters:
 * --------------- 
 * name 
 * contact
 * email
 * username
 * password 
 * mode
 * 
 * Arguments:
 * ---------
 * Agency ID
 */

$app->post('/agency_edit/[{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$input 			= $request->getParsedBody();
		$table_prefix	= $this->get('settings')['path']['table_prefix'];
		$name 			= (isset($input['name'])) ? $input['name'] : '';
		$contactname	= (isset($input['contact'])) ? $input['contact'] : '';
		$email			= (isset($input['email'])) ? $input['email'] : '';
		$status			= (isset($input['status'])) ? $input['status'] : '';
		$datetime 		= date('Y-m-d H:i:s');
		$agency_id		= $args['agency_id'];
		$mode = $input['mode'];

		$stc = "SELECT * FROM " . $table_prefix . "agency where agencyid =" . $agency_id;

		$std = $this->db->prepare($stc);
		$std->execute();
		$users = $std->fetch();

		/*  status value allowed 0-Active,1-Suspended and 4-Inactive  */
		if ($status != 0) {
			$validstatus = array("0", "1", "4");
			if (!in_array($status, $validstatus) || $status == '-0') {
				$response = array('response' => 'error', 'message' => 'Please insert valid status field', 'status' => '404');
				return $this->response->withJson($response);
			}
		}
		if ($users > 0) {

			$acc = "update " . $table_prefix . "accounts set account_name='" . $contactname . "' where account_id='" . $users['account_id'] . "' ";
			$edit_acc = $this->db->prepare($acc);
			$edit_acc->execute();


			$agency = "update " . $table_prefix . "agency set name=:name,contact=:contact,email=:email,status=:status,updated=:updated where agencyid=:agencyid";
			$edit_agency = $this->db->prepare($agency);
			$edit_agency->bindParam(":name", $name);
			$edit_agency->bindParam(":contact", $contactname);
			$edit_agency->bindParam(":email", $email);
			$edit_agency->bindParam(":status", $status);
			$edit_agency->bindParam(":updated", $datetime);
			$edit_agency->bindParam(":agencyid", $users['agencyid']);
			$edit_agency->execute();

			$results = array('response' => 'success', 'message' => 'Agency details has been updated successfully!', 'status' => '200');
			return $this->response->withJson($results);
		} else {
			$response = array('response' => 'error', 'message' => 'Please enter the valid Agency id!', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('agency_edit'));



/*
 * Agency Delete
 * 
 * Input Parameters:
 * --------------- 
 * Nil
 * 
 * Arguments:
 * ---------
 * Agency ID
 */

$app->delete('/agency_delete/[{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$agency_id = $args['agency_id'];

		$stc = "SELECT * FROM " . $table_prefix . "agency where agencyid =" . $agency_id;
		$std = $this->db->prepare($stc);
		$std->execute();
		$users = $std->fetch();
		if ($users > 0) {

			$acc = "DELETE FROM " . $table_prefix . "accounts WHERE account_id=:account_id";
			$del_acc = $this->db->prepare($acc);
			$del_acc->bindParam(":account_id", $users['account_id']);
			$del_acc->execute();

			$agency = "DELETE FROM " . $table_prefix . "agency WHERE account_id=:account_id";
			$del_agency = $this->db->prepare($agency);
			$del_agency->bindParam(":account_id", $users['account_id']);
			$del_agency->execute();

			$response = array('response' => 'success', 'message' => 'Agency details Deleted succesfully!', 'status' => '200');
			return $this->response->withJson($response);
		} else {

			$response = array('response' => 'error', 'message' => 'Please enter the valid Agency id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
});




/*
 * Fetch Agency Details
 * 
 * Input Parameters:
 * --------------- 
 * Nil
 * 
 * Arguments:
 * ---------
 * Account ID
 */


$app->get('/get_all_agency/[{account_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$account_id = $args['account_id'];
		if ($account_id == 1) {
			$stc = "SELECT * FROM " . $table_prefix . "accounts AS t1  JOIN " . $table_prefix . "agency AS t2 ON t1.account_id = t2.account_id AND t1.account_type = 'MANAGER'";
			$std = $this->db->prepare($stc);
			$std->execute();
			$users = $std->fetchAll();

			$agencydetails = array();
			if (count($users) > 0) {
				foreach ($users as $agency) {

					$agencydetails[] = array(
						'accountid' => $agency['account_id'],
						'agencyid' => $agency['agencyid'],
						'name' => $agency['name'],
						'accounttype' => $agency['account_type'],
						'contact' => $agency['contact'],
						'email' => $agency['email'],
						'status' => $users['status']
					);
				}

				$data['data'] = $agencydetails;
				$data['response'] = "success";
		        $data['message'] = "Agency List";
		        $data['status'] = "200";
				return $this->response->withJson($data);
			} else {

				$response = array('response' => 'error', 'message' => 'Please Enter the valid account Id!', 'status' => '404');
				return $this->response->withJson($response);
			}
		} else {
			$response = array('response' => 'error', 'message' => 'Permission denied for the user!', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
});


$app->get('/get_agency/[{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');

		$agency_id = $args['agency_id'];
		$stc = "select * from " . $table_prefix . "agency where agencyid=" . $agency_id;
		$std = $this->db->prepare($stc);
		$std->execute();
		$users = $std->fetch();
		if ($users['agencyid'] > 0) {
			$agencydetails = array(
				'accountid' => $users['account_id'],
				'agencyid' => $users['agencyid'],
				'name' => $users['name'],
				'contact' => $users['contact'],
				'email' => $users['email'],
				'status' => $users['status']
			);
			$data['data'] = $agencydetails;
			$data['response'] = "success";
			$data['message'] = "Agency Data List";
			$data['status'] = "200";
			
			return $this->response->withJson($data);
		} else {

			$response = array('response' => 'error', 'message' => 'please Enter the Valid Agency Id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
});


/*----------------  Agency -------------*/

/*----------------  Advertiser -------------*/

/*
 * Advertiser ADD
 * 
 * Input Parameters:
 * --------------- 
 * contact
 * email
 * username
 * password 
 * clientname
 * report - Email Campaign Delivery reports enable (true or false)
 * reportinterval - No of days between campaign delivery reports 
 * reportdeactivate - Email when a campaign is automatically activated/deactivated (true or false)
 * comments - comments for advertiser
 * advertiser_limitation -  Display only one banner from this advertiser on a web page ( 0 or 1)
 * 
 * Arguments:
 * ---------
 * Agency ID
 */


$app->post('/advertiser_add/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters ','status'=>'404');
		return $this->response->withJson($response);
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$clientname  	= (isset($input['clientname'])) ? $input['clientname'] : '';
		$contact  	= (isset($input['contact'])) ? $input['contact'] : '';
		$email		  	= (isset($input['email'])) ? $input['email'] : '';
		$report   	= (isset($input['report'])) ? $input['report'] : 'f';
		$reportinterval   	= (isset($input['reportinterval'])) ? $input['reportinterval'] : '7';
		$reportdeactivate   =  (isset($input['reportdeactivate'])) ? $input['reportdeactivate'] : 'f';
		$comments  			=  (isset($input['comments'])) ? $input['comments'] : '';
		$limitation   = (isset($input['advertiser_limitation'])) ? $input['advertiser_limitation'] : '0';
		$datetime = date('Y-m-d H:i:s');
		$agencyid = $args['agency_id'];

		$agencyid_det = "select agencyid from " . $table_prefix . "agency where agencyid=" . $agencyid;
		$agencyid_tab = $this->db->prepare($agencyid_det);
		$agencyid_tab->execute();
		$check = $agencyid_tab->fetch();
		if ($check['agencyid']) {
			$addacc = "INSERT INTO " . $table_prefix . "accounts (account_type,account_name) VALUES ('ADVERTISER',:clientname);";
			$acc = $this->db->prepare($addacc);
			$acc->bindParam(":clientname", $clientname);
			$acc->execute();
			$account_id = $this->db->lastInsertId();

			$addcl = "INSERT INTO " . $table_prefix . "clients (agencyid,clientname,contact,email,report,reportinterval,reportdeactivate,comments,advertiser_limitation,updated,account_id) VALUES (:agencyid,:clientname,:contact,:email,:report,:reportinterval,:reportdeactivate,:comments,:advertiser_limitation,:updated,:acccountid)";

			$adv = $this->db->prepare($addcl);
			$adv->bindParam(":agencyid", $agencyid);
			$adv->bindParam(":clientname", $clientname);
			$adv->bindParam(":contact", $contact);
			$adv->bindParam(":email", $email);
			$adv->bindParam(":report", $report);
			$adv->bindParam(":reportinterval", $reportinterval);
			$adv->bindParam(":reportdeactivate", $reportdeactivate);
			$adv->bindParam(":comments", $comments);
			$adv->bindParam(":advertiser_limitation", $limitation);
			$adv->bindParam(":updated", $datetime);
			$adv->bindParam(":acccountid", $account_id);
			$adv->execute();

			$client_id = $this->db->lastInsertId();

			if ($client_id) {

				$response = array('response' => 'success', 'message' => 'Advertiser has been added successfully with clientid: ' . $client_id, 'status' => '200');
				return $this->response->withJson($response);
			}
		} else {
			$response = array('response' => 'error', 'message' => 'Please Enter the Valid Agency Id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('advertiser_validate'));





/*
 * Advertiser EDIT
 * 
 * Input Parameters:
 * --------------- 
 * contact
 * email
 * username
 * password 
 * clientname
 * report - Email Campaign Delivery reports enable (true or false)
 * reportinterval - No of days between campaign delivery reports 
 * reportdeactivate - Email when a campaign is automatically activated/deactivated (true or false)
 * comments - comments for advertiser
 * advertiser_limitation -  Display only one banner from this advertiser on a web page ( 0 or 1)
 * mode
 * 
 * Arguments:
 * ---------
 * Advertiser ID
 */

$app->post('/advertiser_edit/[{advertiser_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$clientname  	= (isset($input['clientname'])) ? $input['clientname'] : '';
		$contact  	= (isset($input['contact'])) ? $input['contact'] : '';
		$email		  	= (isset($input['email'])) ? $input['email'] : '';
		$report   	= (isset($input['report'])) ? $input['report'] : 'f';
		$reportinterval   	= (isset($input['reportinterval'])) ? $input['reportinterval'] : '7';
		$reportdeactivate   =  (isset($input['reportdeactivate'])) ? $input['reportdeactivate'] : 'f';
		$comments  			=  (isset($input['comments'])) ? $input['comments'] : '';
		$limitation   = (isset($input['advertiser_limitation'])) ? $input['advertiser_limitation'] : '0';
		$datetime	  = date('Y-m-d H:i:s');
		$clientid	  = $args['advertiser_id'];
		$mode =   $input['mode'];

		$stc = "SELECT * FROM " . $table_prefix . "clients where clientid ='" . $clientid . "'";
		$std = $this->db->prepare($stc);
		$std->execute();
		$users = $std->fetch();
		if ($users) {
			$acc_upd = "update " . $table_prefix . "accounts set  account_name=:clientname where account_id=:account_id";
			$acc_edit = $this->db->prepare($acc_upd);
			$acc_edit->bindParam(":clientname", $clientname);
			$acc_edit->bindParam(":account_id", $users['account_id']);
			$acc_edit->execute();

			$cl_upd = "update " . $table_prefix . "clients set  clientname=:clientname,contact=:contact,email=:email,report=:report,reportinterval=:reportinterval,reportdeactivate=:reportdeactivate,advertiser_limitation=:advertiser_limitation,comments=:comments,updated=:updated where clientid=:clientid";
			$client_edit = $this->db->prepare($cl_upd);
			$client_edit->bindParam(":clientname", $clientname);
			$client_edit->bindParam(":contact", $contact);
			$client_edit->bindParam(":email", $email);
			$client_edit->bindParam(":report", $report);
			$client_edit->bindParam(":reportinterval", $reportinterval);
			$client_edit->bindParam(":reportdeactivate", $reportdeactivate);
			$client_edit->bindParam(":advertiser_limitation", $limitation);
			$client_edit->bindParam(":comments", $comments);
			$client_edit->bindParam(":updated", $datetime);
			$client_edit->bindParam(":clientid", $clientid);
			$update_adv = $client_edit->execute();
			if ($update_adv) {
				$response = array('response' => 'success', 'message' => 'Advertiser has been updated successfully!', 'status' => '200');
				return $this->response->withJson($response);
			}
		} else {
			$response = array('response' => 'error', 'message' => 'Please enter the valid advertiserid', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('advertiser_edit'));



/*
 * Advertiser DELETE
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Advertiser ID
 */
$app->delete('/advertiser_delete/[{clientid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$clientid = $args['clientid'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:clientid";
		$std = $this->db->prepare($stc);
		$std->bindParam("clientid", $clientid);
		$std->execute();
		$users = $std->fetchAll();
		$account_id = $users[0]['account_id'];


		if ($users) {

			$del_acc = "DELETE FROM " . $table_prefix . "accounts WHERE account_id=:account_id";
			$account_del = $this->db->prepare($del_acc);
			$account_del->bindParam(":account_id", $account_id);
			$acc_del = $account_del->execute();

			$del_pub = "DELETE FROM " . $table_prefix . "clients WHERE account_id=:account_id";
			$pub_del = $this->db->prepare($del_pub);
			$pub_del->bindParam(":account_id", $account_id);
			$pub_del->execute();

			if ($acc_del) {
				$response = array('response' => 'success', 'message' => 'Advertiser has been deleted successfully!', 'status' => '200');
				return $this->response->withJson($response);
			}
		} else {
			$response = array('response' => 'error', 'message' => 'Please enter the valid  Advertiser id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
});




/*
 * Get Advertiser details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Advertiser ID
 */
$app->get('/get_advertiser/[{advertiserid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiserid = $args['advertiserid'];
		$stc = "SELECT clientid,agencyid,clientname,contact,email,report,reportinterval,reportdeactivate,comments,advertiser_limitation FROM " . $table_prefix . "clients where clientid =:clientid";
		$std = $this->db->prepare($stc);
		$std->bindParam("clientid", $advertiserid);
		$std->execute();
		$users = $std->fetch();
		if ($users) {

			$adv_det =
				array(
					'clientid' => $users['clientid'],
					'clientname' => $users['clientname'],
					'contact' => $users['contact'],
					'email' => $users['email'],
					'report' => $users['report'],
					'reportinterval' => $users['reportinterval'],
					'reportdeactivate' => $users['reportdeactivate'],
					'comments' => $users['comments'],
					'advertiser_limitation' => $users['advertiser_limitation']
				);
				$data['data'] = $adv_det;
				$data['response'] = "success";
		        $data['message'] = "Advertiser Data List";
		        $data['status'] = "200";
			return $this->response->withJson($data);
		} else {
			$response = array('response' => 'error', 'message' => 'Please enter valid Advertiser id!', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('advertiser_val'));




/*
 * Get Advertiser details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Agency ID
 */

$app->get('/get_all_advertiser/[{agencyid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$agency_id = $args['agencyid'];

		$stc = "SELECT clientid,agencyid,clientname,contact,email,report,reportinterval,reportdeactivate,comments,advertiser_limitation FROM " . $table_prefix . "clients where agencyid =:agencyid";

		$std = $this->db->prepare($stc);
		$std->bindParam("agencyid", $agency_id);
		$std->execute();
		$users = $std->fetchAll();

		if ($users) {
			foreach ($users as $adv) {
				$adv_list[] =  $adv;
			}
			$data['data'] = $adv_list;
				$data['response'] = "success";
		        $data['message'] = "Advertiser List";
		        $data['status'] = "200";
			return $this->response->withJson($data);

		} else {
			$response = array('response' => 'error', 'message' => 'Please enter valid Agency id!', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('agencyid_val'));

/*----------------  Campaign -------------*/



/*
 * Campaign ADD
 * 
 * Input Parameters:
 * --------------- 
 * campaignname [mandatory]
 * clientid [mandatory]
 * views
 * clicks
 * conversions
 * weight
 * target_impression
 * target_click
 * target_conversion"
 * anonymous
 * companion 
 * comments
 * revenue
 * revenue_type [mandatory]
 * priority [mandatory]
 * block
 * capping
 * session_capping
 * status
 * hosted_views
 * hosted_clicks
 * min_impressions
 * start_date [mandatory]
 * end_date  [mandatory]
 * show_capped_no_cookie
 * 
 * Arguments:
 * ---------
 * Advertiser ID
 */
$app->post('/campaign_add/[{client_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$clientid = $args['client_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:clientid";
		$std = $this->db->prepare($stc);
		$std->bindParam("clientid", $clientid);
		$std->execute();
		$clients = $std->fetch();
		$datetime = date('Y-m-d H:i:s');
		$currentdate = date('Y-m-d');


		if ($clients) {
			$campaignname = $input['campaignname'];
			$views = (!empty($input['views'])) ? $input['views'] : '-1';
			$clicks = (!empty($input['clicks'])) ? $input['clicks'] : '-1';
			$conversions = (!empty($input['conversions'])) ? $input['conversions'] : '-1';
			$priority = (!empty($input['priority'])) ? $input['priority'] : '0';
			$weight = (!empty($input['weight'])) ? $input['weight'] : '1';
			$targetimp = (!empty($input['target_impression'])) ? $input['target_impression'] : '0';
			$targetclk = (!empty($input['target_click'])) ? $input['target_click'] : '0';
			$targetconv = (!empty($input['target_conversion'])) ? $input['target_conversion'] : '0';
			$companion = (!empty($input['companion'])) ? $input['companion'] : '0';
			$comments = $input['comments'];

			$revenue = (!empty($input['revenue'])) ? $input['revenue'] : '0';
			$revenuetype = (isset($input['revenue_type'])) ? $input['revenue_type'] : '1';

			$block = (!empty($input['block'])) ? $input['block'] : '0';
			$capping = (!empty($input['capping'])) ? $input['capping'] : '0';
			$session_capping = (!empty($input['session_capping'])) ? $input['session_capping'] : '0';
			$show_capped_no_cookie = (!empty($input['show_capped_no_cookie'])) ? $input['show_capped_no_cookie'] : '0';
            $anonymous = (!empty($input['anonymous'])) ? $input['anonymous'] : 'f';
			$start_date = (isset($input['start_date'])) ? $input['start_date'] : $datetime;
			$end_date = (isset($input['end_date'])) ? $input['end_date'] : 'NULL';
            $start_date = date('Y-m-d H:i:s', strtotime($start_date));
			$end_date = date('Y-m-d H:i:s', strtotime($end_date));
            $startdate = date('Y-m-d', strtotime($start_date));
			$enddate = date('Y-m-d', strtotime($end_date));

			$enddatenull = $input['end_date'];
			$allowedrevenuetype = array('1', '2', '3', '4');
			if (!in_array($revenuetype, $allowedrevenuetype)) {
				$response = array('response' => 'error', 'message' => 'Please insert correct revenue types', 'status' => '404');
				return $this->response->withJson($response);
			}
			if ($priority != 0) {
				$validpriority = array("0", "-1", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10");
				if (!in_array($priority, $validpriority) || $priority == -0) {

					$response = array('response' => 'error', 'message' => 'Please insert valid priority field', 'status' => '404');
					return $this->response->withJson($response);
				}
			}
			if ($priority == '5') {

				if (empty($enddatenull)) {

					$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
					return $this->response->withJson($response);
				}
			}

			if ($startdate && $enddatenull == '') {
				//Start Date And Dont' Expire Scenarios
				if ($currentdate == $startdate && $weight == 0) {
					//Inactive
					$status = 4;
				} else if ($currentdate == $startdate && $weight == 1) {
					//active
					$status = 0;
				} else if ($currentdate < $startdate && $weight == 1) {
					//Awaiting
					$status = 2;
				} else if ($currentdate < $startdate && $weight == 0) {
					//InActive
					$status = 2;
				} else if ($currentdate > $startdate && $weight == 0) {
					//InActive
					$status = 4;
				} else {
					//Active
					$status = 0;
				}
			} else if ($currentdate > $enddate) {
				//Completed
				$status = 3;
			} else if ($currentdate < $startdate && $currentdate < $enddate) {
				if ($weight == 0) {
					//Inactive
					$status = 2;
				} else if ($weight == 1) {
					//Awaiting 
					$status = 2;
				} else {
					//Active
					$status = 0;
				}
			} else if ($currentdate == $startdate || $currentdate == $enddate) {
				if ($weight == 0) {
					//inactive
					$status = 4;
				} else if ($weight == 1) {
					//active 
					$status = 0;
				}
			} else {
				$status = (isset($input['status'])) ? $input['status'] : $clients['status'];
			}

			//contract
			if ($startdate && $enddatenull == '') {
				if ($priority > 0 && $views == -1 && $targetimp == 1) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						//active 
						$status = 0;
					}
				} else if ($priority > 0 && $views == -1 && $targetimp == 0) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						$status = 4;
					}
				} else if ($priority > 0 && $views == 1 && $targetimp == 0) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						$status = 0;
					}
				} else if ($priority > 0 && $views == 0 && $targetimp == 0) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						$status = 4;
					}
				}
			} else {
				if ($priority > 0 && $views == -1 && $targetimp == 0) {
					//Inactive
					$status = 4;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed

						$status = 3;
					}
				} else if ($priority > 0 && $views == 1 && $targetimp == 0) {
					//active
					$status = 0;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == 0 && $targetimp == 0) {
					//Inactive
					$status = 4;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == -1 && $targetimp == 1) {
					//active
					$status = 0;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == 0 && $targetimp == 1) {
					//Inactive
					$status = 4;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				}
			}
			//validate for reqiured information

			if (empty($campaignname) || empty($revenuetype)) {
				$results = array('response' => 'error', 'message' => 'Please enter all data', 'status' => '404');
				return $this->response->withJson($response);
			}

			if ($startdate && $enddatenull != '') {
				if ($enddate < $startdate) {
					$response = array('response' => 'error', 'message' => 'The selected dates for this campaign are invalid(Campaign ends before it starts)', 'status' => '404');
					return $this->response->withJson($response);
				}
			}
			//contract campaign must have targetimpression/click/conversion
			if ($priority != -1 && $priority != 0) {
				if ($targetclk == '' && $targetimp == '' && $targetconv == '') {
					$results = array('response' => 'error', 'message' => 'Requested campaign need targetimpression or click or conversion value', 'status' => '404');
					return $this->response->withJson($response);
				}
			}

			if ($priority == -1 || $priority == 0) {

				$addcampaign = "INSERT INTO " . $table_prefix . "campaigns(
					campaignname,
					views,		
					clicks,		
					conversions,	
					clientid,		
					priority,
					weight,
					target_impression,
					target_click,
					target_conversion,
					anonymous,
					companion,
					comments,
					revenue,
					revenue_type,	
					updated,
					block,
					capping,
					session_capping,
					show_capped_no_cookie,
					status,
					activate_time,
					expire_time
					) 
					VALUES(
					'" . $campaignname . "',
					" . $views . ",		
					" . $clicks . " ,		
					" . $conversions . ",
					" . $clientid . ",
					" . $priority . ",		
					" . $weight . ",
					0,
					0,
					0,
					'" . $anonymous . "',
					" . $companion . ",
					'" . $comments . "',
					" . $revenue . ",
					" . $revenuetype . ",
					now(),
					" . $block . ",
					" . $capping . ",
					" . $session_capping . ",
					" . $show_capped_no_cookie . ",
					" . $status . ",
					'" . $start_date . "',
					'" . $end_date . "')";

				$djax_query_campaigns = $this->db->prepare($addcampaign);
				$djax_query_campaigns->execute();

				$campaignid = $this->db->lastInsertId();
			} else {

				$addcampaign = "INSERT INTO " . $table_prefix . "campaigns(
					campaignname,
					views,		
					clicks,		
					conversions,	
					clientid,		
					priority,
					weight,
					target_impression,
					target_click,
					target_conversion,
					anonymous,
					companion,
					comments,
					revenue,
					revenue_type,	
					updated,
					block,
					capping,
					session_capping,
					show_capped_no_cookie,
					status,
					activate_time,
					expire_time
					) 
					VALUES(
					'" . $campaignname . "',
					" . $views . ",		
					" . $clicks . " ,		
					" . $conversions . ",
					" . $clientid . ",
					" . $priority . ",		
					1,
					" . $targetimp . ",
					" . $targetclk . ",
					" . $targetconv . ",	
					'" . $anonymous . "',
					" . $companion . ",
					'" . $comments . "',
					" . $revenue . ",
					" . $revenuetype . ",
					now(),
					" . $block . ",
					" . $capping . ",
					" . $session_capping . ",
					" . $show_capped_no_cookie . ",
					" . $status . ",
					'" . $start_date . "',
					'" . $end_date . "')";

				$djax_query_campaigns = $this->db->prepare($addcampaign);

				$djax_query_campaigns->execute();

				$campaignid = $this->db->lastInsertId();
			}

			if ($campaignid) {
				if ((strpos($end_date, '1970') !== false) || ($end_date == 'NULL') || ($end_date == '-')) {
					$expdate = "Update " . $table_prefix . "campaigns set expire_time=NULL where campaignid='" . $campaignid . "'";
					$expdate = $this->db->prepare($expdate);
					$expdate->execute();
				}

				$response = array('response' => 'Success', 'message' => 'campaign has been added successfully with id:' . $campaignid, 'status' => '200');
				return $this->response->withJson($response);
			}
		} else {

			$response = array('response' => 'error', 'message' => 'Please enter the  valid clientid!', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('campaign_validate'));



/*
 * Campaign EDIT
 * 
 * Input Parameters:
 * --------------- 
 * campaignname [mandatory]
 * clientid [mandatory]
 * views
 * clicks
 * conversions
 * weight
 * target_impression
 * target_click
 * target_conversion
 * anonymous
 * companion 
 * comments
 * revenue
 * revenue_type [mandatory]
 * priority [mandatory]
 * block
 * capping
 * session_capping
 * status
 * hosted_views
 * hosted_clicks
 * min_impressions
 * start_date [mandatory]
 * end_date  [mandatory]
 * show_capped_no_cookie
 * mode
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */


$app->post('/campaign_edit/[{campaign_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them

		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$campaignid = $args['campaign_id'];

		$stc = "SELECT * FROM " . $table_prefix . "campaigns where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid", $campaignid);
		$std->execute();
		$campaign_det = $std->fetchAll();
		$datetime = date('Y-m-d H:i:s');
		$currentdate = date('Y-m-d');
		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array('response' => 'error', 'message' => 'mode must be edit', 'status' => '404');
			return $this->response->withJson($response);
			return $response;
			exit;
		}
		if (isset($input['campaignname'])) {
			$campaignname = $input['campaignname'];
			if (empty($campaignname)) {
				$results = json_encode(array('response' => 'Error', 'message' => 'Please Enter Campaignname', 'status' => '404'));
				return $results;
			}
		} else {
			$campaignname = $campaign_det['0']['campaignname'];
		}
		if (isset($input['start_date'])) {
			$start_date = $input['start_date'];
			if (empty($start_date)) {
				$results = json_encode(array('response' => 'Error', 'message' => 'Please Choose Start Date'));
				return $results;
			}
		} else {
			$start_date = $campaign_det['0']['activate_time'];;
		}
		if ($campaign_det) {

			$campaignname = (!empty($input['campaignname'])) ? $input['campaignname'] : $campaign_det['0']['campaignname'];
			$views = (!empty($input['views'])) ? $input['views'] : $campaign_det['0']['views'];
			$clicks = (!empty($input['clicks'])) ? $input['clicks'] : $campaign_det['0']['clicks'];
			$conversions = (!empty($input['conversions'])) ? $input['conversions'] : $campaign_det['0']['conversions'];
			$priority = (isset($input['priority'])) ? $input['priority'] : $campaign_det['0']['priority'];
			$weight = (!empty($input['weight'])) ? $input['weight'] : $campaign_det['0']['weight'];
			$companion = (!empty($input['companion'])) ? $input['companion'] : $campaign_det['0']['companion'];

			$targetimp = (!empty($input['target_impression'])) ? $input['target_impression'] : '0';
			$targetclk = (!empty($input['target_click'])) ? $input['target_click'] : '0';
			$targetconv = (!empty($input['target_conversion'])) ? $input['target_conversion'] : '0';
			$comments = (!empty($input['comments'])) ? $input['comments'] : $campaign_det['0']['comments'];
			$revenue = (!empty($input['revenue'])) ? $input['revenue'] : $campaign_det['0']['revenue'];
			$revenuetype = (!empty($input['revenue_type'])) ? $input['revenue_type'] : $campaign_det['0']['revenue_type'];

			$block = (!empty($input['block'])) ? $input['block'] : $campaign_det['0']['block'];
			$capping = (!empty($input['capping'])) ? $input['capping'] : $campaign_det['0']['capping'];
			$session_capping = (!empty($input['session_capping'])) ? $input['session_capping'] : $campaign_det['0']['session_capping'];
			$show_capped_no_cookie = (!empty($input['show_capped_no_cookie'])) ? $input['show_capped_no_cookie'] : $campaign_det['0']['show_capped_no_cookie'];

			$anonymous = (!empty($input['anonymous'])) ? $input['anonymous'] : $campaign_det['0']['anonymous'];
			$start_date = (isset($input['start_date'])) ? $input['start_date'] : $campaign_det['0']['activate_time'];
			$end_date = (isset($input['end_date'])) ? $input['end_date'] : $campaign_det['0']['expire_time'];
		
			$start_date = date('Y-m-d H:i:s', strtotime($start_date));
			$end_date = date('Y-m-d H:i:s', strtotime($end_date));

			$startdate = date('Y-m-d', strtotime($start_date));
			$enddate = date('Y-m-d', strtotime($end_date));
			$enddatenull = $input['end_date'];

			if ($priority == '5') {

				if (empty($enddatenull)) {

					$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
					return $this->response->withJson($response);
				}
			}

			if ($priority != 0) {

				$allowedpriority = array('0', '-1', '1', '2', '3', '4', '5', '6', '7', '8', '9', '10');
				if (!in_array($priority, $allowedpriority)) {
					$response = array('response' => 'error', 'message' => 'Please insert a valid priority field', 'status' => '404');
					return $this->response->withJson($response);
				}
			}
			$allowedrevenuetype = array('1', '2', '3', '4');
			if (!in_array($revenuetype, $allowedrevenuetype)) {
				$response = array('response' => 'error', 'message' => 'Please insert correct revenue types', 'status' => '404');
				return $this->response->withJson($response);
			}

			if ($startdate && $enddatenull != '') {
				if ($enddate < $startdate) {
					$response = array('response' => 'error', 'message' => 'The selected dates for this campaign are invalid(Campaign ends before it starts)', 'status' => '404');
					return $this->response->withJson($response);
				}
			}

			//Status Add All Scenarios 
			if ($startdate && $enddatenull == '') {
				//Start Date And Dont' Expire Scenarios
				if ($currentdate == $startdate && $weight == 0) {
					//Inactive
					$status = 4;
				} else if ($currentdate == $startdate && $weight == 1) {
					//active
					$status = 0;
				} else if ($currentdate < $startdate && $weight == 1) {
					//Awaiting
					$status = 2;
				} else if ($currentdate < $startdate && $weight == 0) {
					//InActive
					$status = 2;
				} else if ($currentdate > $startdate && $weight == 0) {
					//awaiting
					$status = 4;
				} else {
					//Active
					$status = 0;
				}
			} else if ($currentdate > $enddate) {
				//Completed
				$status = 3;
			} else if ($currentdate < $startdate && $currentdate < $enddate) {
				if ($weight == 0) {
					//awaiting
					$status = 2;
				} else if ($weight == 1) {
					//Awaiting 
					$status = 2;
				} else {
					//Active
					$status = 0;
				}
			} else if ($currentdate == $startdate || $currentdate == $enddate) {
				if ($weight == 0) {
					//inactive
					$status = 4;
				} else if ($weight == 1) {
					//active 
					$status = 0;
				}
			} else {
				$status = (isset($input['status'])) ? $input['status'] : $campaign_det['0']['status'];
			}

			//contract
			if ($startdate && $enddatenull == '') {
				if ($priority > 0 && $views == -1 && $targetimp == 1) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						//active 
						$status = 0;
					}
				} else if ($priority > 0 && $views == -1 && $targetimp == 0) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						$status = 4;
					}
				} else if ($priority > 0 && $views == 1 && $targetimp == 0) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						$status = 0;
					}
				} else if ($priority > 0 && $views == 0 && $targetimp == 0) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						$status = 4;
					}
				}
			} else {
				if ($priority > 0 && $views == -1 && $targetimp == 0) {
					$status = 4;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == 1 && $targetimp == 0) {
					$status = 0;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == 0 && $targetimp == 0) {
					$status = 4;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == -1 && $targetimp == 1) {
					$status = 0;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == 0 && $targetimp == 1) {
					$status = 4;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				}
			}

			if ($priority == -1 || $priority == 0) {
				$edit_cmp = "UPDATE  " . $table_prefix . "campaigns set 
					campaignname='" . $campaignname . "',
					views=" . $views . ",		
					clicks=" . $clicks . ",		
					conversions=" . $conversions . ",		
					priority=" . $priority . ",
					weight=" . $weight . ",
					target_impression=0,
					target_click=0,
					target_conversion=0,
					anonymous='" . $anonymous . "',
					companion=" . $companion . ",
					comments='" . $comments . "',
					revenue='" . $revenue . "',
					revenue_type=" . $revenuetype . ",	
					updated='" . $datetime . "',
					block=" . $block . ",
					capping=" . $capping . ",
					session_capping=" . $session_capping . ",
					show_capped_no_cookie=" . $show_capped_no_cookie . ",
					status=" . $status . ",
					activate_time='" . $start_date . "',
					expire_time='" . $end_date . "'
					where campaignid=" . $campaignid;
			} else {
				$edit_cmp = "UPDATE  " . $table_prefix . "campaigns set 
					campaignname='" . $campaignname . "',
					views=" . $views . ",		
					clicks=" . $clicks . ",		
					conversions=" . $conversions . ",		
					priority=" . $priority . ",
					weight=1,
					target_impression=" . $targetimp . ",
					target_click=" . $targetclk . ",
					target_conversion=" . $targetconv . ",
					anonymous='" . $anonymous . "',
					companion=" . $companion . ",
					comments='" . $comments . "',
					revenue='" . $revenue . "',
					revenue_type=" . $revenuetype . ",	
					updated='" . $datetime . "',
					block=" . $block . ",
					capping=" . $capping . ",
					session_capping=" . $session_capping . ",
					show_capped_no_cookie=" . $show_capped_no_cookie . ",
					status=" . $status . ",
					activate_time='" . $start_date . "',
					expire_time='" . $end_date . "'
					where campaignid=" . $campaignid;
			}
			$cmp = $this->db->prepare($edit_cmp);
			$campaignid = $cmp->execute();

			if ($campaignid) {

				if ((strpos($end_date, '1970') !== false) || ($end_date == 'NULL') || ($end_date == '-')) {

					$expdate = "Update " . $table_prefix . "campaigns set expire_time=NULL where campaignid='" . $args['campaign_id'] . "'";
					$expdate = $this->db->prepare($expdate);
					$expdate->execute();
				}

				$response = array('response' => 'success', 'message' => 'campaign has been updated successfully!', 'status' => '200');
				return $this->response->withJson($response);
			}
		} else {

			$response = array('response' => 'error', 'message' => ' Please enter the valid Campaignid!', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('campaignid_val1'));

/*
 * Campaign DELETE
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */

$app->delete('/campaign_delete/[{campaign_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$campaignid = $args['campaign_id'];

		$stc = "SELECT * FROM " . $table_prefix . "campaigns where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid", $campaignid);
		$std->execute();
		$campaign_det = $std->fetchAll();
		$datetime	  = date('Y-m-d H:i:s');

		if ($campaign_det) {
			$del_camp = "DELETE FROM " . $table_prefix . "campaigns WHERE campaignid=:campaignid";
			$cmp = $this->db->prepare($del_camp);
			$cmp->bindParam("campaignid", $campaignid);
			$success = $cmp->execute();

			if ($success) {
				$response = array('response' => 'Success', 'message' => 'Campaign has been deleted successfully!', 'status' => '200');
				return $this->response->withJson($response);
			}
		} else {
			$response = array('response' => 'error', 'message' => 'Please enter the valid campaignid!', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
});


/*
 * Campaign Details
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */

$app->get('/get_campaign/[{campaign_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$campaignid = $args['campaign_id'];

		$stc = "SELECT * FROM " . $table_prefix . "campaigns where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid", $campaignid);
		$std->execute();
		$campaign_det = $std->fetchAll();
		$datetime	  = date('Y-m-d H:i:s');
		$campaigndetail = array();

		if (count($campaign_det) > 0) {

			$campaigndetail = array(
				'campaignid' => $campaignid,
				'campaignid' => $campaign_det[0]['campaignid'],
				'campaignname' => $campaign_det[0]['campaignname'],
				'clientid' => $campaign_det[0]['clientid'],
				'views' => $campaign_det[0]['views'],
				'clicks' => $campaign_det[0]['clicks'],
				'conversions' => $campaign_det[0]['conversions'],
				'priority' => $campaign_det[0]['priority'],
				'weight' => $campaign_det[0]['conversions'],
				'target_impression' => $campaign_det[0]['target_impression'],
				'target_click' => $campaign_det[0]['target_click'],
				'target_conversion' => $campaign_det[0]['target_conversion'],
				'anonymous' => $campaign_det[0]['anonymous'],
				'companion' => $campaign_det[0]['companion'],
				'comments' => $campaign_det[0]['comments'],
				'revenue' => $campaign_det[0]['revenue'],
				'revenue_type' => $campaign_det[0]['revenue_type'],
				'updated' => $campaign_det[0]['updated'],
				'block' => $campaign_det[0]['block'],
				'capping' => $campaign_det[0]['capping'],
				'session_capping' => $campaign_det[0]['session_capping'],
				'status' => $campaign_det[0]['status'],
				'min_impressions' => $campaign_det[0]['min_impressions'],
				'start_date' => $campaign_det[0]['activate_time'],
				'end_date' => $campaign_det[0]['expire_time'],
				'show_capped_no_cookie' => $campaign_det[0]['show_capped_no_cookie']
			);
			$data['data'] = $campaigndetail;
			$data['response'] = "success";
			$data['message'] = "Campaign Data List";
			$data['status'] = "200";
		return $this->response->withJson($data);
			
		} else {
			$response = array(
				'response' => 'error',
				'message' => 'Please Enter the Valid Campaign Id!',
				'status' => '404'
			);

			return $this->response->withJson($response);
		}
	}
});


/*
 * GET ALL CAMPAIGNS
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Advertiser ID
 */
$app->get('/get_all_campaigns/[{client_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$clientid = $args['client_id'];

		$clients = "SELECT * FROM " . $table_prefix . "clients where clientid =:clientid";
		$stc = $this->db->prepare($clients);
		$stc->bindParam("clientid", $clientid);
		$stc->execute();
		$client_det = $stc->fetchAll();
		if ($client_det) {
			$stc = "SELECT * FROM " . $table_prefix . "campaigns where clientid=:clientid";
			$std = $this->db->prepare($stc);
			$std->bindParam("clientid", $clientid);
			$std->execute();
			$campaign_det = $std->fetchAll();
			$datetime	  = date('Y-m-d H:i:s');

			if (count($campaign_det) > 0) {
				$campaigndetail = array();
				foreach ($campaign_det as $campaign) {

					$campaigndetail[] = array(
						'clientid' => $clientid,

						'campaignid' => $campaign['campaignid'],
						'campaignname' => $campaign['campaignname'],
						'clientid' => $campaign['clientid'],
						'views' => $campaign['views'],
						'clicks' => $campaign['clicks'],
						'conversions' => $campaign['conversions'],
						'priority' => $campaign['priority'],
						'weight' => $campaign['conversions'],
						'target_impression' => $campaign['target_impression'],
						'target_click' => $campaign['target_click'],
						'target_conversion' => $campaign['target_conversion'],
						'anonymous' => $campaign['anonymous'],
						'companion' => $campaign['companion'],
						'comments' => $campaign['comments'],
						'revenue' => $campaign['revenue'],
						'revenue_type' => $campaign['revenue_type'],
						'updated' => $campaign['updated'],
						'block' => $campaign['block'],
						'capping' => $campaign['capping'],
						'session_capping' => $campaign['session_capping'],
						'status' => $campaign['status'],
						'min_impressions' => $campaign['min_impressions'],
						'start_date' => $campaign['activate_time'],
						'end_date' => $campaign['expire_time'],
						'show_capped_no_cookie' => $campaign['show_capped_no_cookie']
					);
				}
				$data['data'] = $campaigndetail;
				$data['response'] = "success";
				$data['message'] = "Campaign  List";
				$data['status'] = "200";
			return $this->response->withJson($data);
				
			} else {

				$response = array(
					'response' => 'error',
					'message' => 'No campaigns available for this clientid!',
					'status' => '204'
				);

				return $this->response->withJson($response);
			}
		} else {
			$response = array(
				'response' => 'error',
				'message' => 'Please Enter the Valid Client Id!',
				'status' => '404'
			);

			return $this->response->withJson($response);
		}
	}
})->add($container->get('clientid_val'));



/*----------------  Campaign -------------*/

/*---------------- BANNER ---------------*/


/*
 * BANNER ADD
 * 
 * Input Parameters:
 * ----------------
 * description [mandatory]
 * contenttype
 * storagetype [mandatory]
 * imageurl
 * width
 * height
 * weight
 * url
 * target
 * alt
 * statustext
 * bannertext
 * comments
 * updated
 * keyword
 * append
 * prepend
 * 
 * Arguments:
 * ---------
 * Campaignid
 */
$app->post('/add_banner/[{campaign_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$campaignid = $args['campaign_id'];
		$datetime = date('Y-m-d H:i:s');
		$paths = dirname(__FILE__);
		//Delivery path
		$full_url = $this->get('settings')['path']['delivery'];

		//Database connection
		$db_host = $this->get('settings')['db']['host'];
		$db_user = $this->get('settings')['db']['user'];
		$db_pass = $this->get('settings')['db']['pass'];
		$db_dbname = $this->get('settings')['db']['dbname'];

		$full_url = substr($full_url, 0, -9);

		$image_path = '../../www/images/';
		define('DIRECTORY', $image_path);
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$get_banner_id1 = "CREATE TABLE IF NOT EXISTS banner_vast_element_seq (ID int(11) NOT NULL AUTO_INCREMENT, PRIMARY KEY (ID))";
		$query_banner_vast_id1 = $this->db->prepare($get_banner_id1);
		$query_banner_vast_id1->execute();

		$stc = "SELECT campaignid FROM " . $table_prefix . "campaigns where campaignid ='" . $campaignid . "'";
		$std = $this->db->prepare($stc);
		$std->execute();
		$campaignids = $std->fetchAll();

		if ($campaignids) {

			$table_prefix = $this->get('settings')['path']['table_prefix'];
			$tot_num_impression = isset($input['total_impressions']) ? $input['total_impressions'] : 0;
			if ($input['unlimited_impression'] == 'true') {
				$unlimit_impression = 't';
			} else {
				$unlimit_impression = 'f';
			}
			$limit_y_num_impressions = isset($input['y_num_impression']) ? $input['y_num_impression'] : 0;
			$impr_time = isset($input['impressions_time']) ? $input['impressions_time'] : 0;

			//mandatory fields added in dependency
			$description = $input['description'];
			$storagetype = $input['storagetype'];

			//non-mandatory fields available for all banner types
			$keyword = isset($input['keyword']) ? $input['keyword'] : '';
			$append = isset($input['append']) ? $input['append'] : '';
			$prepend = isset($input['prepend']) ? $input['prepend'] : '';
			$comments = isset($input['comments']) ? $input['comments'] : '';
			$weight = (isset($input['weight'])) ? $input['weight'] : '1';

			if ($input['storagetype'] == 'web' || $input['storagetype'] == 'txt' || $input['storagetype'] == 'sql' || $input['storagetype'] == 'url') {

				$contenttype = isset($input['contenttype']) ? $input['contenttype'] : '';
				$url_banner_imageurl = isset($input['url_banner_imageurl']) ? $input['url_banner_imageurl'] : '';
				$width = isset($input['width']) ? $input['width'] : '';
				$height = isset($input['height']) ? $input['height'] : '';
				$imageurl = isset($input['imageurl']) ? $input['imageurl'] : '';
				$bannertext = isset($input['bannertext']) ? $input['bannertext'] : '';

				//validation	
				if ($storagetype == 'web' || $storagetype == 'sql') {

					if (empty($width) || empty($height) || empty($contenttype) || empty($imageurl)) {

						$results = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($results);
					}
				} else if ($storagetype == 'txt') {
					if (empty($contenttype) || empty($bannertext)) {
						$results = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($results);
					}
				} else if ($storagetype == 'url') {
					if (empty($width) || empty($height) || empty($contenttype) || empty($url_banner_imageurl)) {

						$results = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($results);
					}
				}

				if ($input['storagetype'] == 'web') {
					$img_size = get_headers($imageurl, 1);

					if ($img_size["Content-Length"] <= 4294967295) {
						if ($imageurl) {
							$valid_exts = array("jpg", "jpeg", "gif", "png"); // default image only extensions
							$ext = explode(".", strtolower(basename($imageurl)));

							$ext = end($ext);

							$filename = basename($imageurl);
							$new = explode(".", $filename);
							$encryptfilename = md5($new[0]);
							$ac = $encryptfilename . "." . $new[1];
							$c[] = '';
							array_push($c, $ac);

							if (in_array($ext, $valid_exts)) {
								$rand = rand(10000, 99999);
								$newfile = $rand . $c[1]; // replace "downloads" with whatever directory you wish.
								$content = file_get_contents($imageurl);
								file_put_contents(DIRECTORY . $c[1], $content);
							}
						}
					} else {
						$results = array('response' => 'error', 'message' => 'Image size is higher');
						return $this->response->withJson($results);
					}
				} else if ($input['storagetype'] == 'sql') {

					if ($imageurl) {
						$valid_exts = array("jpg", "jpeg", "gif", "png"); // default image only extensions
						$ext = explode(".", strtolower(basename($imageurl)));
						$ext = end($ext);
						$filename = basename($imageurl);
						$new = explode(".", $filename);
						$encryptfilename = md5($new[0]);
						$ac = $encryptfilename . "." . $new[1];
						$c[] = '';
						//checking for existing name
						$exp_time_sql = "SELECT filename FROM " . $table_prefix . "banners WHERE storagetype='sql'";
						$exp_time_sql1 = $this->db->prepare($exp_time_sql);
						$exp_time_sql1->execute();
						$exp_time_sql1 = $exp_time_sql1->fetchAll();


						if (in_array($ext, $valid_exts)) {

							function in_array_r($filename, $exp_time_sql1)
							{
								$found = false;
								foreach ($exp_time_sql1 as $item) {
									if ($item === $filename) {
										$found = true;
										break;
									} elseif (is_array($item)) {
										$found = in_array_r($filename, $item);
										if ($found) {
											break;
										}
									}
								}
								return $found;
							}
							$con = new mysqli($db_host, $db_user, $db_pass, $db_dbname);

							// Check connection
							if ($con->connect_errno) {
								echo "Failed to connect to MySQL: " . $con->connect_error;
								exit();
							}

							if (in_array_r($filename, $exp_time_sql1)) {

								array_push($c, $ac);
								$rand = rand(10000, 99999);
								$newfile = $rand . $c[1]; // replace "downloads" with whatever directory you wish.
								$filename = $newfile;
								$content = file_get_contents($imageurl);
								$target_data2 = file_put_contents(DIRECTORY . $newfile, $content);
								$target_Path = DIRECTORY . $filename;
								$target_data = file_get_contents($target_Path);
								$target_data1 = mysqli_real_escape_string($con, $target_data);
							} else {
								array_push($c, $ac);
								$rand = rand(10000, 99999);
								$newfile = $rand . $c[1]; // replace "downloads" with whatever directory you wish.
								$filename = $newfile;
								$content = file_get_contents($imageurl);
								$target_data2 = file_put_contents(DIRECTORY . $newfile, $content);
								$target_Path = DIRECTORY . $filename;
								$target_data = file_get_contents($target_Path);
								$db_host = $this->get('settings')['db']['host'];
								$db_user = $this->get('settings')['db']['user'];
								$db_pass = $this->get('settings')['db']['pass'];
								$db_dbname = $this->get('settings')['db']['dbname'];

								$con = new mysqli($db_host, $db_user, $db_pass, $db_dbname);

								// Check connection
								if ($con->connect_errno) {
									echo "Failed to connect to MySQL: " . $con->connect_error;
									exit();
								}
								$target_data1 = mysqli_real_escape_string($con, $target_data);
							}
						}
					}
					$sql = "INSERT INTO " . $table_prefix . "images(filename,contents,t_stamp) values('" . $filename . "','" . $target_data1 . "',now())";
					$djax_query_ban = $this->db->prepare($sql);
					$djax_query_ban->execute();
				}

				$url = isset($input['url']) ? $input['url'] : '';
				$target = isset($input['target']) ? $input['target'] : 0;
				$alt = isset($input['alt']) ? $input['alt'] : '';
				$statustext = isset($input['statustext']) ? $input['statustext'] : '';
				$ext_bannertype = isset($input['ext_bannertype']) ? $input['ext_bannertype'] : '';

				if ($storagetype == 'web') {

					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						campaignid,
						description,
						contenttype,
						storagetype,
						filename,
						width,
						height,
						url,
						weight,
						target,
						alt,
						statustext,
						bannertext,
						keyword,
						comments,
						updated,
                        append,
                        prepend
						) VALUES(
						:campaignid,
						:description,
						:contenttype,
						:storagetype,
						:filename,
						:width,
						:height,
						:url,
						:weight,
						:target,
						:alt,
						:statustext,
						:bannertext,
						:keyword,
						:comments,
						now(),
						:append,
						:prepend
						)";
				} else if ($storagetype == 'txt') {

					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						campaignid,
						description,
						contenttype,
						storagetype,
						weight,
						target,
						alt,
						statustext,
						bannertext,
						keyword,
						comments,
						url,
						ext_bannertype,
						updated,
                        append,
                        prepend					
						) VALUES(
						:campaignid,
						:description,
						:contenttype,
						:storagetype,
						:weight,
						:target,
						:alt,
						:statustext,
						:bannertext,
						:keyword,
						:comments,
						:url,
						'bannerTypeText:oxText:genericText',
						now(),
						:append,
						:prepend
						)";
				} else if ($storagetype == 'url') {
					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						campaignid,
						description,
						contenttype,
						storagetype,
						imageurl,
						width,
						height,
						url,
						weight,
						target,
						alt,
						statustext,
						bannertext,
						keyword,
						comments,
						updated,
                        append,
                        prepend
						) VALUES(
						:campaignid,
						:description,
						:contenttype,
						:storagetype,
						:imageurl,
						:width,
						:height,
						:url,
						:weight,
						:target,
						:alt,
						:statustext,
						:bannertext,
						:keyword,
						:comments,
						now(),
						:append,
						:prepend
						)";
				} else if ($storagetype == 'sql') {
					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						campaignid,
						description,
						contenttype,
						storagetype,
						filename,
						width,
						height,
						url,
						weight,
						target,
						alt,
						statustext,
						bannertext,
						keyword,
						comments,
						updated,
                        append,
                        prepend
						) VALUES(
						:campaignid,
						:description,
						:contenttype,
						:storagetype,
						:filename,
						:width,
						:height,
						:url,
						:weight,
						:target,
						:alt,
						:statustext,
						:bannertext,
						:keyword,
						:comments,
						now(),
						:append,
						:prepend
						)";
				}

				$djax_query_banners = $this->db->prepare($addbanner);

				//contract campaign must have target value
				if ($storagetype == 'web') {
					$djax_query_banners->bindParam(":filename", $c[1]);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
				}

				if ($storagetype == 'sql') {

					$djax_query_banners->bindParam(":filename", $filename);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
				}

				if ($storagetype == 'url') {
					$djax_query_banners->bindParam(":imageurl", $url_banner_imageurl);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
				}

				/* if ($storagetype == 'txt') {
					$djax_query_banners->bindParam(":bannertext", $bannertext);
				} */

				$djax_query_banners->bindParam(":campaignid", $campaignid);
				$djax_query_banners->bindParam(":description", $description);
				$djax_query_banners->bindParam(":contenttype", $contenttype);
				$djax_query_banners->bindParam(":storagetype", $storagetype);
				$djax_query_banners->bindParam(":url", $url);
				$djax_query_banners->bindParam(":weight", $weight);
				$djax_query_banners->bindParam(":target", $target);
				$djax_query_banners->bindParam(":alt", $alt);
				$djax_query_banners->bindParam(":statustext", $statustext);
				$djax_query_banners->bindParam(":bannertext", $bannertext);
				$djax_query_banners->bindParam(":keyword", $keyword);
				$djax_query_banners->bindParam(":comments", $comments);
				$djax_query_banners->bindParam(":append", $append);
				$djax_query_banners->bindParam(":prepend", $prepend);

				if ($storagetype == 'sql') {

					$exp_time_img = "SELECT * FROM " . $table_prefix . "images WHERE t_stamp IN (SELECT max(t_stamp) FROM " . $table_prefix . "images)";
					$exp_time_img1 = $this->db->prepare($exp_time_img);
					$exp_time_img1->execute();
					$exp_time_img1 = $exp_time_img1->fetchAll();
					$date_t = $exp_time_img1[0]['t_stamp'];
				}

				$djax_query_banners->execute();
				$bannerid = $this->db->lastInsertId();
				if ($bannerid) {
					$zoneval = "select zone_id from {$table_prefix}placement_zone_assoc where placement_id=:campaignid";
					$get_zone_det = $this->db->prepare($zoneval);
					$get_zone_det->bindParam(":campaignid", $campaignid);
					$get_zone_det->execute();
					$stmtzonevalue = $get_zone_det->fetchAll();
				}

				$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
				$get_banner_det = $this->db->prepare($bannerval);
				$get_banner_det->bindParam(":bannerid", $bannerid);
				$get_banner_det->execute();
				$stmtbannervalue = $get_banner_det->fetchAll();


				$bannerwidth = $stmtbannervalue[0]['width'];
				$bannerheight = $stmtbannervalue[0]['height'];
				$storagetype = $stmtbannervalue[0]['storagetype'];
				foreach ($stmtzonevalue as $zone_id) {

					$zoneid = $zone_id['zone_id'];
					if ($zoneid) {
						if ($storagetype == 'txt') {

							$zoneval1 = "select * from {$table_prefix}zones where zoneid=$zoneid and delivery=3";
							$get_zone_det1 = $this->db->prepare($zoneval1);

							$get_zone_det1->execute();
							$stmtzonevalue1 = $get_zone_det1->fetchAll();
						} else if ($storagetype == 'web' || $storagetype == 'url' || $storagetype == 'sql') {
							$zoneval1 = "select * from {$table_prefix}zones where zoneid=$zoneid and width=:bannerwidth and height=:bannerheight";
							$get_zone_det1 = $this->db->prepare($zoneval1);
							$get_zone_det1->bindParam(":bannerwidth", $bannerwidth);
							$get_zone_det1->bindParam(":bannerheight", $bannerheight);
							$get_zone_det1->execute();
							$stmtzonevalue1 = $get_zone_det1->fetchAll();
						}
					}


					foreach ($stmtzonevalue1 as $zoneid) {
						$id = $zoneid['zoneid'];
						$zoneids = explode(',', $id);

						foreach ($zoneids as $zoneid) {
							$adzoneassoc = "INSERT INTO {$table_prefix}ad_zone_assoc(zone_id,ad_id,
								priority, link_type,priority_factor,to_be_delivered) 
									VALUES (:zoneid, $bannerid,0,1,1,1);";

							$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
							$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
							$djax_query_adzoneassoc->execute();
						}
					}
				}

				$response = array('response' => 'success', 'message' => 'Banner has been added successfully with id:'.$bannerid, 'status' => '200');
				return $this->response->withJson($response);
			} else if (($input['storagetype'] == 'html') && !(isset($input['vast_overlay_format']))) {
				$width = $input['width'];
				$height = $input['height'];
				$filename = isset($input['filename']) ? $input['filename'] : '';
				$ext_bannertype = isset($input['ext_bannertype']) ? $input['ext_bannertype'] : '';

				$htmltemplate = isset($input['htmltemplate']) ? $input['htmltemplate'] : '';
				if ($input['unlimited_impression'] == 'true') {
					$unlimit_impression = 't';
				} else {
					$unlimit_impression = 'f';
				}
				$tot_num_impression = isset($input['total_impressions']) ? $input['total_impressions'] : 0;
				$limit_y_num_impressions = isset($input['y_num_impression']) ? $input['y_num_impression'] : 0;
				$impr_time = isset($input['impressions_time']) ? $input['impressions_time'] : 0;
				//adding html5 banner type

				if ($ext_bannertype == 'bannerTypeHtml:oxHtml:html5') {

					if (empty($width) || empty($height) || empty($filename)) {
						$results = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($results);
					}

					if ($filename) {

						/* Source File URL */
						$remote_file_url = $filename;

						$image_path = '../../www/images/';

						/* New file name and path for this file */
						$local_file = $image_path . 'test_html5.zip';

						/* Copy the file from source url to server */
						$copy = copy($remote_file_url, $local_file);

						$file = $local_file;
						$path = pathinfo(realpath($file), PATHINFO_DIRNAME);
						$baseurl = explode('/', $file);
						array_pop($baseurl);
						array_pop($baseurl);
						$randfolder = uniqid(); 
						$furl = implode('/', $baseurl) . "/images/" . $randfolder;

						$zip = new ZipArchive;

						$res = $zip->open($file);


						for ($i = 0; $i < $zip->numFiles; $i++) {
							$kowsi = $zip->getNameIndex($i);

							$fileinfo = pathinfo($kowsi);

							if ($fileinfo['filename'] == 'index') {
								$indexfolder = $fileinfo['dirname'];
							}

							$kowsi = substr_replace($kowsi, "", -1);
						}

						$kowsi = substr($kowsi, 0, strpos($kowsi, "/"));

						chmod($furl . "/" . $kowsi, 0777);


						if ($res === TRUE) {
							$tt = $zip->extractTo($furl);

							chmod($furl . "/" . $kowsi, 0777);
							

							$zip->close();
							unlink($local_file);
						} else {
							echo "try again with crct zip file";
						}
					}

					$img_size = get_headers($remote_file_url, 1);
					$img_siz = $img_size["Content-Length"];

					//zip serialize
					$var = array();
					$var1 = array(
						"html5_name" => $randfolder . '.zip',
						"html5_size" => $img_siz
					);

					$parameter1 = serialize($var1);

					if ($kowsi) {
						$html5filename = $randfolder . '/' . $indexfolder;
					} else {
						$html5filename = $randfolder;
					}

					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						campaignid,
						contenttype,
						filename,
						storagetype,
						htmltemplate,
						htmlcache,
						width,
						height,
						weight,
						url,
						description,
						parameters,
						ext_bannertype,
						updated,
						keyword,
						comments,
                        append,
                        prepend
						) VALUES(
						:campaignid,
						'',
						'" . $html5filename . "',
						:storagetype,
						:htmltemplate,
						:htmlcache,
						:width,
						:height,
						$weight,
						:url,
						:description,
						'" . $parameter1 . "',
						'bannerTypeHtml:oxHtml:html5',
						now(),
                        '" . $keyword . "',
                        '" . $comments . "',
                        '" . $append . "',
                        '" . $prepend . "'
						);";
				} else if ($ext_bannertype == 'bannerTypeHtml:apVideo:Network' || $input['bannertext']) {
					$bannertext = isset($input['bannertext']) ? $input['bannertext'] : '';

					if (empty($bannertext)) {
						$results = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($results);
					}

					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						campaignid,
						description,
						contenttype,
						storagetype,
						width,
						height,
						weight,
						bannertext,
						parameters,
						ext_bannertype,
						updated,
						keyword,
						comments,
                        append,
                        prepend
						) VALUES(
						:campaignid,
						:description,
						'',
						:storagetype,
						-3,
						-3,
						$weight,
						:bannertext,
						'N;',
						'bannerTypeHtml:apVideo:Network',
						now(),
                        '" . $keyword . "',
                        '" . $comments . "',
                        '" . $append . "',
                        '" . $prepend . "'
						);";

					$djax_query_banners = $this->db->prepare($addbanner);
					$djax_query_banners->bindParam(":campaignid", $campaignid);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":storagetype", $storagetype);
					$djax_query_banners->bindParam(":bannertext", $bannertext);

					$banner = $djax_query_banners->execute();
					$bannerid = $this->db->lastInsertId();

					$overlay_banner_id = "select * from banner_vast_element_seq";
					$overlay_banner_vast_id = $this->db->prepare($overlay_banner_id);
					$overlay_banner_vast_id->execute();
					$overlay_vast_id = $overlay_banner_vast_id->fetchAll();

					if (count($overlay_vast_id) > 0) {
						$b = $overlay_vast_id[0]['id'];
						$banner_vast_element_id = $b + 1;
					} else {
						$banner_vast_element_id = 1;
					}

					$addparameters = "insert into " . $table_prefix . "banner_vast_element(banner_vast_element_id, banner_id) values(:banner_vast_element_id, :banner_id)";

					$djax_query_banners_parameters = $this->db->prepare($addparameters);

					$djax_query_banners_parameters->bindParam(":banner_vast_element_id", $banner_vast_element_id);
					$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);

					$djax_query_banners_parameters->execute();

					if ($bannerid) {
						$zoneval = "select zone_id from {$table_prefix}placement_zone_assoc where placement_id=:campaignid";
						$get_zone_det = $this->db->prepare($zoneval);
						$get_zone_det->bindParam(":campaignid", $campaignid);
						$get_zone_det->execute();
						$stmtzonevalue = $get_zone_det->fetchAll();
					}

					$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
					$get_banner_det = $this->db->prepare($bannerval);
					$get_banner_det->bindParam(":bannerid", $bannerid);
					$get_banner_det->execute();
					$stmtbannervalue = $get_banner_det->fetchAll();


					$bannerwidth = $stmtbannervalue[0]['width'];
					$bannerheight = $stmtbannervalue[0]['height'];
					$ext_bannertype = $stmtbannervalue[0]['ext_bannertype'];
					foreach ($stmtzonevalue as $zone_id) {

						$zoneid = $zone_id['zone_id'];
						if ($zoneid) {
							if ($ext_bannertype == 'bannerTypeHtml:apVideo:Network') {

								$zoneval1 = "select * from {$table_prefix}zones where zoneid=$zoneid and delivery=6 and width=:bannerwidth and height=:bannerheight";
								$get_zone_det1 = $this->db->prepare($zoneval1);
								$get_zone_det1->bindParam(":bannerwidth", $bannerwidth);
								$get_zone_det1->bindParam(":bannerheight", $bannerheight);
								$get_zone_det1->execute();
								$stmtzonevalue1 = $get_zone_det1->fetchAll();
							}
						}

						foreach ($stmtzonevalue1 as $zoneid) {
							$id = $zoneid['zoneid'];
							$zoneids = explode(',', $id);

							foreach ($zoneids as $zoneid) {
								$adzoneassoc = "INSERT INTO {$table_prefix}ad_zone_assoc(zone_id,ad_id,
									priority, link_type,priority_factor,to_be_delivered) 
										VALUES (:zoneid, $bannerid,0,1,1,1);";

								$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
								$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
								$djax_query_adzoneassoc->execute();
							}
						}
					}
					if ($banner) {
						$response = array('response' => 'success', 'message' => 'Banner added successfully with id:' . $bannerid, 'status' => '200');
						return $this->response->withJson($response);
					}
				} else {
					if (!isset($input['vast_video_outgoing_filename'])) {
						if (empty($width) || empty($height) || empty($htmltemplate)) {
							$results = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
							return $this->response->withJson($results);
						}

						$addbanner = "INSERT INTO " . $table_prefix . "banners(
						campaignid,
						contenttype,
						storagetype,
						htmltemplate,
						htmlcache,
						width,
						height,
						weight,
						url,
						description,
						parameters,
						ext_bannertype,
						updated,
						keyword,
						comments,
                        append,
                        prepend				
						) VALUES(
						:campaignid,
						'',
						:storagetype,
						:htmltemplate,
						:htmlcache,
						:width,
						:height,
						$weight,
						:url,
						:description,
						'N;',
						'bannerTypeHtml:oxHtml:genericHtml',
						now(),
						'" . $keyword . "',
                        '" . $comments . "',
                        '" . $append . "',
                        '" . $prepend . "'
						);";
					}
				}

				if (($width > -2) && ($height > -2)) {
					$contenttype = $input['contenttype'];
					$filename = $input['filename'];
					$width = $input['width'];
					$height = $input['height'];
					$url = $input['url'];
					$htmltemplate = isset($input['htmltemplate']) ? $input['htmltemplate'] : '';
					$htmlcache = '<a href="{clickurl}" target="{target}">' . $htmltemplate . '</a>';
					$djax_query_banners = $this->db->prepare($addbanner);
					$djax_query_banners->bindParam(":campaignid", $campaignid);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":storagetype", $storagetype);
					$djax_query_banners->bindParam(":url", $url);
					$djax_query_banners->bindParam(":htmltemplate", $htmltemplate);
					$djax_query_banners->bindParam(":htmlcache", $htmlcache);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);

					$banner = $djax_query_banners->execute();
					$bannerid = $this->db->lastInsertId();
					if ($bannerid) {
						$zoneval = "select zone_id from {$table_prefix}placement_zone_assoc where placement_id=:campaignid";
						$get_zone_det = $this->db->prepare($zoneval);
						$get_zone_det->bindParam(":campaignid", $campaignid);
						$get_zone_det->execute();
						$stmtzonevalue = $get_zone_det->fetchAll();
					}

					$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
					$get_banner_det = $this->db->prepare($bannerval);
					$get_banner_det->bindParam(":bannerid", $bannerid);
					$get_banner_det->execute();
					$stmtbannervalue = $get_banner_det->fetchAll();

					$bannerwidth = $stmtbannervalue[0]['width'];
					$bannerheight = $stmtbannervalue[0]['height'];
					$ext_bannertype = $stmtbannervalue[0]['ext_bannertype'];
					foreach ($stmtzonevalue as $zone_id) {

						$zoneid = $zone_id['zone_id'];

						if ($zoneid) {
							if ($ext_bannertype == 'bannerTypeHtml:oxHtml:genericHtml' || $ext_bannertype == 'bannerTypeHtml:oxHtml:html5') {

								$zoneval1 = "select * from {$table_prefix}zones where zoneid=$zoneid and delivery=0 and width=:bannerwidth and height=:bannerheight";
								$get_zone_det1 = $this->db->prepare($zoneval1);
								$get_zone_det1->bindParam(":bannerwidth", $bannerwidth);
								$get_zone_det1->bindParam(":bannerheight", $bannerheight);
								$get_zone_det1->execute();
								$stmtzonevalue1 = $get_zone_det1->fetchAll();
							}
						}


						foreach ($stmtzonevalue1 as $zoneid) {
							$id = $zoneid['zoneid'];
							$zoneids = explode(',', $id);

							foreach ($zoneids as $zoneid) {
								$adzoneassoc = "INSERT INTO {$table_prefix}ad_zone_assoc(zone_id,ad_id,
								priority, link_type,priority_factor,to_be_delivered) 
									VALUES (:zoneid, $bannerid,0,1,1,1);";

								$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
								$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
								$djax_query_adzoneassoc->execute();
							}
						}
					}
					if ($banner) {
						$response = array('response' => 'success', 'message' => 'Banner has been added successfully with id:'.$bannerid, 'status' => '200');
						return $this->response->withJson($response);
					}
				} else {
					///////// inline html ///////////////

					$vast_video_outgoing_filename = $input['vast_video_outgoing_filename'];
					$vast_video_duration = $input['vast_video_duration'];
					$vast_video_type = $input['vast_video_type'];

					if (empty($vast_video_outgoing_filename) || empty($vast_video_type) || empty($vast_video_duration)) {
						$results = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($results);
					}

					$vast_video_clickthrough_url = $input['vast_video_clickthrough_url'];
					$vast_video_id = isset($input['vast_video_id']) ? $input['vast_video_id'] : null;
					$vast_companion_banner_id = $input['vast_companion_banner_id'];
					$vast_thirdparty_impression = isset($input['vast_thirdparty_impression']) ? $input['vast_thirdparty_impression'] : '';
					$vast_overlay_height = isset($input['vast_overlay_height']) ? $input['vast_overlay_height'] : '';
					$vast_overlay_width = isset($input['vast_overlay_width']) ? $input['vast_overlay_width'] : '';
					$vast_overlay_text_title = isset($input['vast_overlay_text_title']) ? $input['vast_overlay_text_title'] : '';
					$vast_overlay_text_description = isset($input['vast_overlay_text_description']) ? $input['vast_overlay_text_description'] : '';
					$vast_overlay_text_call = isset($input['vast_overlay_text_call']) ? $input['vast_overlay_text_call'] : '';
					$vast_video_delivery = isset($input['vast_video_delivery']) ? $input['vast_video_delivery'] : 'progressive';

					$var = [
						"banner_vast_element_id" => 'banner_vast_element_id',
						"vast_element_type" => 'singlerow',
						"vast_video_id" => 'N',
						"vast_video_duration" => $vast_video_duration,
						"vast_video_type" => $vast_video_type,
						"vast_video_bitrate" => 400,
						"vast_video_height" => 480,
						"vast_video_width" => 640,
						"vast_video_outgoing_filename" => $vast_video_outgoing_filename,
						"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
						"vast_video_delivery" => $vast_video_delivery,
						"vast_overlay_height" => 'N',
						"vast_overlay_width" => 'N',
						"vast_overlay_text_title" => 'N',
						"vast_overlay_text_description" => 'N',
						"vast_overlay_text_call" => 'N',
						"vast_overlay_format" => 'N',
						"vast_overlay_action" => 'N',
						"vast_companion_banner_id" => $vast_companion_banner_id,
						"vast_creative_type" => 'N',
						"vast_thirdparty_impression" => $vast_thirdparty_impression
					];

					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						campaignid,
						storagetype,
						width,
						height,
						weight,
						description,
						parameters,
						updated,
						ext_bannertype,
                        keyword,
						comments,
						append,
                        prepend)  VALUES (
						:campaignid,
						:storagetype,
						-3,
						-3,
						:weight,
						:description,
						:parameters,
						now(),
						'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml',
                        '" . $keyword . "',
                        '" . $comments . "',
                        '" . $append . "',
                        '" . $prepend . "')";

					$parameter = serialize($var);

					if (empty($parameter)) {
						$parameter = 'N;';
					}

					$djax_query_banners = $this->db->prepare($addbanner);

					$djax_query_banners->bindParam(":campaignid", $campaignid);
					$djax_query_banners->bindParam(":storagetype", $storagetype);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":parameters", $parameter);
					$djax_query_banners->bindParam(":weight", $weight);

					$djax_query_banners->execute();
					$bannerid = $this->db->lastInsertId();

					$get_banner_id = "select * from banner_vast_element_seq";
					$query_banner_vast_id = $this->db->prepare($get_banner_id);
					$query_banner_vast_id->execute();
					$banner_vast_id = $query_banner_vast_id->fetchAll();

					if (count($banner_vast_id) > 0) {
						$a = $banner_vast_id[0]['id'];
						$banner_vast_element_id = $a + 1;
					} else {
						$banner_vast_element_id = 1;
					}

					$vast_element_type = 'singlerow';
					$vast_video_bitrate = 400;
					$vast_video_height = 480;
					$vast_video_width = 640;

					$addparameters = "insert into " . $table_prefix . "banner_vast_element(
							banner_vast_element_id,
							banner_id,
							vast_element_type,
							vast_video_id,
							vast_video_duration,
							vast_video_delivery,
							vast_video_type,
							vast_video_bitrate,
							vast_video_height,
							vast_video_width,
							vast_video_outgoing_filename,
							vast_companion_banner_id,
							vast_overlay_height,
							vast_overlay_width,
							vast_video_clickthrough_url,
							vast_overlay_text_title,
							vast_overlay_text_description,
							vast_overlay_text_call,
						    vast_creative_type,
						    vast_thirdparty_impression)
							values(
							:banner_vast_element_id,
							:banner_id,
							:vast_element_type,
							:vast_video_id,
							:vast_video_duration,
							:vast_video_delivery,
							:vast_video_type,
							:vast_video_bitrate,
							:vast_video_height,
							:vast_video_width,
							:vast_video_outgoing_filename,
							:vast_companion_banner_id,
							:vast_overlay_height,
							:vast_overlay_width,
							:vast_video_clickthrough_url,
							:vast_overlay_text_title,
							:vast_overlay_text_description,
							:vast_overlay_text_call,
						    :vast_creative_type,
						    :vast_thirdparty_impression
							)";

					$djax_query_banners_parameters = $this->db->prepare($addparameters);
					$djax_query_banners_parameters->bindParam(":banner_vast_element_id", $banner_vast_element_id);
					$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);

					$djax_query_banners_parameters->bindParam(":vast_element_type", $vast_element_type);
					$djax_query_banners_parameters->bindParam(":vast_video_id", $vast_video_id);
					$djax_query_banners_parameters->bindParam(":vast_video_duration", $vast_video_duration);
					$djax_query_banners_parameters->bindParam(":vast_video_delivery", $vast_video_delivery);

					$djax_query_banners_parameters->bindParam(":vast_video_type", $vast_video_type);
					$djax_query_banners_parameters->bindParam(":vast_video_bitrate", $vast_video_bitrate);
					$djax_query_banners_parameters->bindParam(":vast_video_height", $vast_video_height);
					$djax_query_banners_parameters->bindParam(":vast_video_width", $vast_video_width);
					$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename", $vast_video_outgoing_filename);
					$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
					$djax_query_banners_parameters->bindParam(":vast_overlay_height", $vast_overlay_height);
					$djax_query_banners_parameters->bindParam(":vast_overlay_width", $vast_overlay_width);
					$djax_query_banners_parameters->bindParam(":vast_video_clickthrough_url", $vast_video_clickthrough_url);
					$djax_query_banners_parameters->bindParam(":vast_overlay_text_title", $vast_overlay_text_title);
					$djax_query_banners_parameters->bindParam(":vast_overlay_text_description", $vast_overlay_text_description);
					$djax_query_banners_parameters->bindParam(":vast_overlay_text_call", $vast_overlay_text_call);

					$djax_query_banners_parameters->bindParam(":vast_creative_type", $vast_creative_type);
					$djax_query_banners_parameters->bindParam(":vast_thirdparty_impression", $vast_thirdparty_impression);
					$djax_query_banners_parameters->execute();
					$addelement_id = "update banner_vast_element_seq set id=:banner_vast_element_id;";
					$djax_query_banners_elements = $this->db->prepare($addelement_id);
					$djax_query_banners_elements->bindParam(":banner_vast_element_id", $banner_vast_element_id);
					$djax_query_banners_elements->execute();


					if ($bannerid) {
						$zoneval = "select zone_id from {$table_prefix}placement_zone_assoc where placement_id=:campaignid";
						$get_zone_det = $this->db->prepare($zoneval);
						$get_zone_det->bindParam(":campaignid", $campaignid);
						$get_zone_det->execute();
						$stmtzonevalue = $get_zone_det->fetchAll();
					}

					$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
					$get_banner_det = $this->db->prepare($bannerval);
					$get_banner_det->bindParam(":bannerid", $bannerid);
					$get_banner_det->execute();
					$stmtbannervalue = $get_banner_det->fetchAll();


					$bannerwidth = $stmtbannervalue[0]['width'];
					$bannerheight = $stmtbannervalue[0]['height'];
					$ext_bannertype = $stmtbannervalue[0]['ext_bannertype'];
					foreach ($stmtzonevalue as $zone_id) {

						$zoneid = $zone_id['zone_id'];
						if ($zoneid) {
							if ($ext_bannertype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml') {

								$zoneval1 = "select * from {$table_prefix}zones where zoneid=$zoneid and delivery=6";
								$get_zone_det1 = $this->db->prepare($zoneval1);

								$get_zone_det1->execute();
								$stmtzonevalue1 = $get_zone_det1->fetchAll();
							}
						}


						foreach ($stmtzonevalue1 as $zoneid) {
							$id = $zoneid['zoneid'];
							$zoneids = explode(',', $id);

							foreach ($zoneids as $zoneid) {
								$adzoneassoc = "INSERT INTO {$table_prefix}ad_zone_assoc(zone_id,ad_id,
								priority, link_type,priority_factor,to_be_delivered) 
									VALUES (:zoneid, $bannerid,0,1,1,1);";

								$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
								$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
								$djax_query_adzoneassoc->execute();
							}
						}
					}
					$response = array('response' => 'success', 'message' => 'Banner has been added successfully with id:'.$bannerid, 'status' => '200');
					return $this->response->withJson($response);
				}
			}
			/////////////  Overlay  ////////////////////
			else if (($input['storagetype'] == 'html') && ($input['vast_overlay_format'] == 'text_overlay' || $input['vast_overlay_format'] == 'html_overlay' || $input['vast_overlay_format'] == 'image_overlay')) {

				$vast_overlay_format = $input['vast_overlay_format'];
				$vast_overlay_action = $input['vast_overlay_action'];

				if (empty($vast_overlay_format) || empty($vast_overlay_action)) {
					$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
					return $this->response->withJson($response);
					exit;
				}

				$url = isset($input['url']) ? $input['url'] : '';
				$vast_video_duration = isset($input['vast_video_duration']) ? $input['vast_video_duration'] : '';
				$vast_video_type = isset($input['vast_video_type']) ? $input['vast_video_type'] : '';
				$saving_file = isset($input['vast_video_outgoing_filename']) ? $input['vast_video_outgoing_filename'] : '';
				$vast_video_delivery = isset($input['vast_video_delivery']) ? $input['vast_video_delivery'] : "progressive";

				if ($vast_overlay_action == 'click_to_video') {
					if (empty($vast_video_duration) || empty($vast_video_type) || empty($saving_file)) {
						$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($response);
						exit;
					}
				}

				if ($vast_video_delivery == "streaming") {
					if (isset($input['vast_net_connection_url']) && $input['vast_net_connection_url'] != "") {
						$vast_net_connection_url = $input['vast_net_connection_url'];
						$videotype = $input['videotype'];
						$vast_video_filename = $input['vast_video_filename'];
						$qot = ':';
						$saving_file = $vast_net_connection_url . $videotype . $qot . $vast_video_filename;
					}
				}


				if ($vast_overlay_action == 'click_to_page') {
					if (empty($url)) {
						$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($response);
						exit;
					}
					$vast_video_duration = '';
					$vast_video_delivery = '';
					$vast_video_type = '';
					$saving_file = '';
					$vast_video_clickthrough_url = '';
				}

				//text overlay
				$vast_overlay_text_title = isset($input['vast_overlay_text_title']) ? $input['vast_overlay_text_title'] : '';
				$vast_overlay_text_description = isset($input['vast_overlay_text_description']) ? $input['vast_overlay_text_description'] : '';
				$vast_overlay_text_call = isset($input['vast_overlay_text_call']) ? $input['vast_overlay_text_call'] : '';

				if ($vast_overlay_format == 'text_overlay') {
					if (empty($vast_overlay_text_title) || empty($vast_overlay_text_description) || empty($vast_overlay_text_call)) {
						$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($response);
					}
				}
				//html overlay
				$htmltemplate = isset($input['htmltemplate']) ? $input['htmltemplate'] : '';
				if ($vast_overlay_format == 'html_overlay') {
					if (empty($htmltemplate)) {
						$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($response);
					}
				}

				$htmlcache = '<a href="{clickurl}" target="{target}">' . $htmltemplate . '</a>';

				//image overlay
				$imageurl = isset($input['imageurl']) ? $input['imageurl'] : '';
				if ($vast_overlay_format == "image_overlay") {
					if (empty($imageurl)) {
						$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($response);
						exit;
					}
				}

				if ($imageurl) {
					$valid_exts = array("jpg", "jpeg", "gif", "png", "swf"); // default image only extensions
					$ext = explode(".", strtolower(basename($imageurl)));
					$ext = end($ext);
					$filename = basename($imageurl);
					$new = explode(".", $filename);
					$encryptfilename = md5($new[0]);
					$ac = $encryptfilename . "." . $new[1];
					$c[] = '';
					array_push($c, $ac);
					if (in_array($ext, $valid_exts)) {

						$rand = rand(10000, 99999);
						$newfile = $rand . $c[1]; // replace "downloads" with whatever directory you wish.
						$content = file_get_contents($imageurl);
						file_put_contents(DIRECTORY . $c[1], $content);
					}
				} else {
					$ac = '';
				}

				$vast_element_type = 'singlerow';
				$vast_overlay_height = $input['vast_overlay_height'];
				$vast_overlay_width = $input['vast_overlay_width'];
				$vast_overlay_format = $input['vast_overlay_format'];
				$vast_creative_type = $input['vast_creative_type'];
				$vast_thirdparty_impression = isset($input['vast_thirdparty_impression']) ? $input['vast_thirdparty_impression'] : '';
				$vast_video_clickthrough_url = isset($input['vast_video_clickthrough_url']) ? $input['vast_video_clickthrough_url'] : '';

				if ($input['vast_companion_banner_id']) {
					$vast_companion_banner_id = $input['vast_companion_banner_id'];
				} else {
					$vast_companion_banner_id = '';
				}
				$var = [
					"banner_vast_element_id" => 'banner_vast_element_id',
					"vast_element_type" => $vast_element_type,
					"vast_video_id" => 'N',
					"vast_video_duration" => $vast_video_duration,
					"vast_video_type" => $vast_video_type,
					"vast_video_bitrate" => 400,
					"vast_video_height" => 480,
					"vast_video_width" => 640,
					"vast_video_outgoing_filename" => $saving_file,
					"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
					"vast_video_delivery" => $vast_video_delivery,
					"vast_overlay_height" => $vast_overlay_height,
					"vast_overlay_width" => $vast_overlay_width,
					"vast_overlay_text_title" => $vast_overlay_text_title,
					"vast_overlay_text_description" => $vast_overlay_text_description,
					"vast_overlay_text_call" => $vast_overlay_text_call,
					"vast_overlay_format" => $vast_overlay_format,
					"vast_overlay_action" => $vast_overlay_action,
					"vast_companion_banner_id" => $vast_companion_banner_id,
					"vast_creative_type" => $vast_creative_type,
					"vast_thirdparty_impression" => $vast_thirdparty_impression
				];

				$parameter = serialize($var);
				$addbanner = "INSERT INTO " . $table_prefix . "banners(
					campaignid , 
					storagetype ,
					filename ,
					htmlcache ,
					htmltemplate,
					url ,
					width ,
					height ,
					weight ,
					description ,
					parameters ,
					updated,
					ext_bannertype,
					keyword,
					comments,
					append,
					prepend)
					VALUES 
					(:campaignid,
					:storagetype,
					:filename,
					:htmlcache,
					:htmltemplate,
					:url,
					-2,
					-2,
					" . $weight . ",
					:description,
					:parameters,
					now(),
					'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml',
					'" . $keyword . "',
					'" . $comments . "',
					'" . $append . "',
					'" . $prepend . "')";

				$djax_query_banners = $this->db->prepare($addbanner);
				$djax_query_banners->bindParam(":campaignid", $campaignid);
				$djax_query_banners->bindParam(":storagetype", $storagetype);
				$djax_query_banners->bindParam(":filename", $ac);
				$djax_query_banners->bindParam(":htmlcache", $htmlcache);
				$djax_query_banners->bindParam(":htmltemplate", $htmltemplate);
				$djax_query_banners->bindParam(":url", $url);
				$djax_query_banners->bindParam(":description", $description);
				$djax_query_banners->bindParam(":parameters", $parameter);

				$djax_query_banners->execute();
				$bannerid = $this->db->lastInsertId();

				$overlay_banner_id = "select * from banner_vast_element_seq";
				$overlay_banner_vast_id = $this->db->prepare($overlay_banner_id);
				$overlay_banner_vast_id->execute();
				$overlay_vast_id = $overlay_banner_vast_id->fetchAll();

				if (count($overlay_vast_id) > 0) {
					$b = $overlay_vast_id[0]['id'];
					$banner_vast_element_id = $b + 1;
				} else {

					$banner_vast_element_id = 1;
				}
				$vast_element_type = 'singlerow';
				$vast_video_bitrate = 400;
				$vast_video_height = 480;
				$vast_video_width = 640;

				$addparameters = "insert into " . $table_prefix . "banner_vast_element(
					banner_vast_element_id,
					banner_id,
					vast_element_type,
					vast_video_id,
					vast_video_duration,
					vast_video_type,
					vast_video_bitrate,
					vast_video_height,
					vast_video_width,
					vast_video_outgoing_filename,
					vast_companion_banner_id,
					vast_video_delivery,
					vast_overlay_height,
					vast_overlay_width,
					vast_video_clickthrough_url,
					vast_overlay_action,
					vast_overlay_format,
					vast_overlay_text_title,
					vast_overlay_text_description,
					vast_overlay_text_call,
					vast_creative_type,
					vast_thirdparty_impression		
					)
					values(
					:banner_vast_element_id,
					:banner_id,
					:vast_element_type,
					:vast_video_id,
					:vast_video_duration,
					:vast_video_type,
					:vast_video_bitrate,
					:vast_video_height,
					:vast_video_width,
					:vast_video_outgoing_filename,
					:vast_companion_banner_id,
					:vast_video_delivery,
					:vast_overlay_height,
					:vast_overlay_width,
					:vast_video_clickthrough_url,
					:vast_overlay_action,
					:vast_overlay_format,
					:vast_overlay_text_title,
					:vast_overlay_text_description,
					:vast_overlay_text_call,
					:vast_creative_type,
					:vast_thirdparty_impression
					)";

				$djax_query_banners_parameters = $this->db->prepare($addparameters);

				$djax_query_banners_parameters->bindParam(":banner_vast_element_id", $banner_vast_element_id);
				$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);
				$djax_query_banners_parameters->bindParam(":vast_element_type", $vast_element_type);
				$djax_query_banners_parameters->bindParam(":vast_video_id", $vast_video_id);
				$djax_query_banners_parameters->bindParam(":vast_video_duration", $vast_video_duration);
				$djax_query_banners_parameters->bindParam(":vast_video_type", $vast_video_type);
				$djax_query_banners_parameters->bindParam(":vast_video_bitrate", $vast_video_bitrate);
				$djax_query_banners_parameters->bindParam(":vast_video_height", $vast_video_height);
				$djax_query_banners_parameters->bindParam(":vast_video_width", $vast_video_width);
				$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename", $saving_file);
				$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
				$djax_query_banners_parameters->bindParam(":vast_video_delivery", $vast_video_delivery);
				$djax_query_banners_parameters->bindParam(":vast_overlay_height", $vast_overlay_height);
				$djax_query_banners_parameters->bindParam(":vast_overlay_width", $vast_overlay_width);
				$djax_query_banners_parameters->bindParam(":vast_video_clickthrough_url", $vast_video_clickthrough_url);
				$djax_query_banners_parameters->bindParam(":vast_overlay_format", $vast_overlay_format);
				$djax_query_banners_parameters->bindParam(":vast_overlay_action", $vast_overlay_action);
				$djax_query_banners_parameters->bindParam(":vast_overlay_text_title", $vast_overlay_text_title);
				$djax_query_banners_parameters->bindParam(":vast_overlay_text_description", $vast_overlay_text_description);
				$djax_query_banners_parameters->bindParam(":vast_overlay_text_call", $vast_overlay_text_call);
				$djax_query_banners_parameters->bindParam(":vast_creative_type", $vast_creative_type);
				$djax_query_banners_parameters->bindParam(":vast_thirdparty_impression", $vast_thirdparty_impression);

				$djax_query_banners_parameters->execute();


				$overlay_addelement_id = "update banner_vast_element_seq set id=:banner_vast_element_id;";
				$overlay_elements = $this->db->prepare($overlay_addelement_id);
				$overlay_elements->bindParam(":banner_vast_element_id", $banner_vast_element_id);
				$overlay_elements->execute();

				///////////////////////////////////////////////////////NEWLY ADDED /////////////////////////////////////////////////////////////////////////////////

				if ($bannerid) {
					$zoneval = "select zone_id from {$table_prefix}placement_zone_assoc where placement_id=:campaignid";
					$get_zone_det = $this->db->prepare($zoneval);
					$get_zone_det->bindParam(":campaignid", $campaignid);
					$get_zone_det->execute();
					$stmtzonevalue = $get_zone_det->fetchAll();
				}

				$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
				$get_banner_det = $this->db->prepare($bannerval);
				$get_banner_det->bindParam(":bannerid", $bannerid);
				$get_banner_det->execute();
				$stmtbannervalue = $get_banner_det->fetchAll();


				$bannerwidth = $stmtbannervalue[0]['width'];
				$bannerheight = $stmtbannervalue[0]['height'];
				$ext_bannertype = $stmtbannervalue[0]['ext_bannertype'];
				foreach ($stmtzonevalue as $zone_id) {

					$zoneid = $zone_id['zone_id'];
					if ($zoneid) {
						if ($ext_bannertype == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml') {

							$zoneval1 = "select * from {$table_prefix}zones where zoneid=$zoneid and delivery=7";
							$get_zone_det1 = $this->db->prepare($zoneval1);

							$get_zone_det1->execute();
							$stmtzonevalue1 = $get_zone_det1->fetchAll();
						}
					}


					foreach ($stmtzonevalue1 as $zoneid) {
						$id = $zoneid['zoneid'];
						$zoneids = explode(',', $id);

						foreach ($zoneids as $zoneid) {
							$adzoneassoc = "INSERT INTO {$table_prefix}ad_zone_assoc(zone_id,ad_id,
								priority, link_type,priority_factor,to_be_delivered) 
									VALUES (:zoneid, $bannerid,0,1,1,1);";

							$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
							$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
							$djax_query_adzoneassoc->execute();
						}
					}
				}
				$response = ['response' => 'success', 'message' => 'Banner has been added successfully with id:'.$bannerid, 'status' => '200'];
				return $this->response->withJson($response);
			} else {

				$response = array('response' => 'error', 'message' => 'Please check with parameters provided and spellings or quotes', 'status' => '404');
				return $this->response->withJson($response);
			}
		} else {

			$response = array('response' => 'error', 'message' => 'Please enter valid Campaignid', 'status' => '200','status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('banneradd_val'));


/*
 * BANNER EDIT
 * 
 * Input Parameters:
 * ----------------
 * description [mandatory]
 * contenttype
 * storagetype 
 * imageurl
 * width
 * height
 * weight
 * url
 * target
 * alt
 * statustext
 * bannertext
 * comments
 * updated
 * keyword
 * append
 * prepend
 * mode
 * 
 * Arguments:
 * ---------
 * Bannerid
 */

$app->post('/edit_banner/[{banner_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$bannerid = $args['banner_id'];
		$datetime = date('Y-m-d H:i:s');
		$paths = dirname(__FILE__);
		//Database connection
		$db_host = $this->get('settings')['db']['host'];
		$db_user = $this->get('settings')['db']['user'];
		$db_pass = $this->get('settings')['db']['pass'];
		$db_dbname = $this->get('settings')['db']['dbname'];

		if ($_SERVER["HTTPS"] == "on") {
			$https = 'https://';
		} else {
			$https = 'http://';
		}

		$imagefull_path = $this->get('settings')['path']['image_path'];

		$imagenew_path = $https . $this->get('settings')['path']['image_path'] . '/';

		include_once('../../config.php');

		$image_path = $reviveapiPath;

		define('DIRECTORY', $image_path);
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$results = array();

		$getbanners = "select * from " . $table_prefix . "banners where bannerid=:bannerid";
		$djax_query_banner = $this->db->prepare($getbanners);
		$djax_query_banner->bindParam(":bannerid", $bannerid);
		$djax_query_banner->execute();
		$stmtbanner = $djax_query_banner->fetchAll();
		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array('response' => 'error', 'message' => 'mode must be edit', 'status' => '404');
			return $this->response->withJson($response);
			return $response;
			exit;
		}

		if (count($stmtbanner) > 0) {

			$description = $input['description'];

			$weight = isset($input['weight']) ? $input['weight'] : $stmtbanner[0]['weight'];

			if (isset($input['storagetype']) && $input['storagetype'] != "") {
				$storagetype = $input['storagetype'];
			} else {
				$response = ['response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404'];
				return $this->response->withJson($response);
				exit;
			}

			$keyword = isset($input['keyword']) ? $input['keyword'] : $stmtbanner[0]['keyword'];
			$append = isset($input['append']) ? $input['append'] : $stmtbanner[0]['append'];
			$prepend = isset($input['prepend']) ? $input['prepend'] : $stmtbanner[0]['prepend'];
			$comments = isset($input['comments']) ? $input['comments'] : $stmtbanner[0]['comments'];

			if (isset($input['filename'])) {
				$filename = $input['filename'];
			} else {
				$filename = $stmtbanner[0]['filename'];
			}

			if (isset($input['total_impressions'])) {
				$tot_num_impression = $input['total_impressions'];
			} else {
				$tot_num_impression = $stmtbanner[0]['impressions_total'];
			}

			if (isset($input['unlimited_impression'])) {
				if ($input['unlimited_impression'] == 'true') {
					$unlimit_impression = 't';
				} else {
					$unlimit_impression = 'f';
				}
			} else {
				if ($stmtbanner[0]['impr_unlimited'] == 't') {
					$unlimit_impression = 't';
				} else {
					$unlimit_impression = 'f';
				}
			
			}

			if (isset($input['y_num_impression'])) {
				$limit_y_num_impressions = $input['y_num_impression'];
			} else {
				$limit_y_num_impressions = $stmtbanner[0]['impressions_number'];
			}

			if (isset($input['impressions_time'])) {
				$impr_time = $input['impressions_time'];
			} else {
				$impr_time = $stmtbanner[0]['impressions_time'];
			}
			///////////////////////////////////////text,web,sql,url////////////////////////////////////

			$dbfilename = $stmtbanner[0]['filename'];

			if ($storagetype == 'web' || $storagetype == 'txt' || $storagetype == 'sql' || $storagetype == 'url') {

				if (isset($input['contenttype']) && $input['contenttype'] != "") {
					$contenttype = $input['contenttype'];
				} else {
					$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
					return $this->response->withJson($response);
					exit;
				}

				if (isset($input['imageurl'])) {
					$imageurl = $input['imageurl'];

					if ($storagetype == 'web') {
						//web banner upload in edit

						if ($imageurl && $imageurl != "") {
							$img_size = get_headers($imageurl, 1);

							if ($img_size["Content-Length"] <= 4294967295) {
								if ($imageurl) {
									$valid_exts = array("jpg", "jpeg", "gif", "png"); // default image only extensions
									$ext = explode(".", strtolower(basename($imageurl)));
									$ext = end($ext);

									$filename = basename($imageurl);
									$new = explode(".", $filename);
									$encryptfilename = md5($new[0]);
									$ac = $encryptfilename . "." . $new[1];
									$c[] = '';
									array_push($c, $ac);
									if (in_array($ext, $valid_exts)) {
										$rand = rand(10000, 99999);
										$newfile = $rand . $c[1]; // replace "downloads" with whatever directory you wish.
										$content = file_get_contents($imageurl);
										file_put_contents(DIRECTORY . $c[1], $content);
									}
								}
							}
						} else {
							$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
							return $this->response->withJson($response);
							exit;
						}
					}

					if ($storagetype == 'sql') {
						if ($imageurl && $imageurl != "") {
							$valid_exts = array("jpg", "jpeg", "gif", "png"); // default image only extensions
							$ext = explode(".", strtolower(basename($imageurl)));
							$ext = end($ext);
							$filename = basename($imageurl);
							$new = explode(".", $filename);
							$encryptfilename = md5($new[0]);
							$ac = $encryptfilename . "." . $new[1];
							$c[] = '';
							//checking for existing name
							$exp_time_sql = "SELECT filename FROM " . $table_prefix . "banners WHERE storagetype='sql'";
							$exp_time_sql1 = $this->db->prepare($exp_time_sql);
							$exp_time_sql1->execute();
							$exp_time_sql1 = $exp_time_sql1->fetchAll();

							if (in_array($ext, $valid_exts)) {

								function in_array_r($filename, $exp_time_sql1)
								{
									$found = false;
									foreach ($exp_time_sql1 as $item) {
										if ($item === $filename) {
											$found = true;
											break;
										} elseif (is_array($item)) {
											$found = in_array_r($filename, $item);
											if ($found) {
												break;
											}
										}
									}
									return $found;
								}
								$con = new mysqli($db_host, $db_user, $db_pass, $db_dbname);

								// Check connection
								if ($con->connect_errno) {
									echo "Failed to connect to MySQL: " . $con->connect_error;
									exit();
								}

								if (in_array_r($filename, $exp_time_sql1)) {
									array_push($c, $ac);
									$rand = rand(10000, 99999);
									$newfile = $rand . $c[1]; // replace "downloads" with whatever directory you wish.
									$filename = $newfile;
									$content = file_get_contents($imageurl);
									$target_data2 = file_put_contents(DIRECTORY . $newfile, $content);
									$target_Path = DIRECTORY . $filename;
									$target_data = file_get_contents($target_Path);
									$target_data1 = mysqli_real_escape_string($con, $target_data);
								} else {
									array_push($c, $ac);
									$rand = rand(10000, 99999);
									$newfile = $rand . $c[1]; // replace "downloads" with whatever directory you wish.
									$filename = $newfile;
									$content = file_get_contents($imageurl);
									$target_data2 = file_put_contents(DIRECTORY . $newfile, $content);
									$target_Path = DIRECTORY . $filename;
									$target_data = file_get_contents($target_Path);
									$db_host = $this->get('settings')['db']['host'];
									$db_user = $this->get('settings')['db']['user'];
									$db_pass = $this->get('settings')['db']['pass'];
									$db_dbname = $this->get('settings')['db']['dbname'];

									$con = new mysqli($db_host, $db_user, $db_pass, $db_dbname);

									// Check connection
									if ($con->connect_errno) {
										echo "Failed to connect to MySQL: " . $con->connect_error;
										exit();
									}
									$target_data1 = mysqli_real_escape_string($con, $target_data);
								}
							}
							$sql = "INSERT INTO " . $table_prefix . "images(filename,contents,t_stamp) values('" . $filename . "','" . $target_data1 . "',now())";
							$djax_query_ban = $this->db->prepare($sql);
							$djax_query_ban->execute();
						} else {
							$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
							return $this->response->withJson($response);
							exit;
						}
					}
				}

				//check if parameter exists or not
				if ($storagetype == 'web' || $storagetype == 'sql' || $storagetype == 'url') {
					$width = $input['width'];
					$height = $input['height'];
					if (empty($width) || empty($height)) {
						$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($response);
						exit;
					}
				}

				//image url for url banner
				if ($storagetype == 'url') {
					$url_banner_imageurl = $input['url_banner_imageurl'];
					if (empty($url_banner_imageurl)) {
						$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($response);
						exit;
					}
				}

				if (isset($input['url'])) {
					$url = $input['url'];
				} else {
					$url = $stmtbanner[0]['url'];
				}

				$target = isset($input['target']) ? $input['target'] : $stmtbanner[0]['target'];
				$alt = isset($input['alt']) ? $input['alt'] : $stmtbanner[0]['alt'];
				$statustext = isset($input['statustext']) ? $input['statustext'] : $stmtbanner[0]['statustext'];
				$bannertext = isset($input['bannertext']) ? $input['bannertext'] : $stmtbanner[0]['bannertext'];

				if ($storagetype == 'txt') {
					$bannertext = $input['bannertext'];
					if (empty($bannertext)) {
						$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($response);
						exit;
					}
				}

				if ($storagetype == 'web') {
					$editbanner = "update " . $table_prefix . "banners set
						description=:description,
						contenttype=:contenttype,
						storagetype='web',
						filename=:filename,
						width=:width,
						height=:height,
						weight=:weight,
						target=:target,
						alt=:alt,
						statustext=:statustext,
						bannertext=:bannertext,
						keyword=:keyword,
						comments=:comments,
						url=:url,
						append=:append,
						prepend=:prepend,
						updated=now()
						where bannerid=:bannerid";
				} else if ($storagetype == 'url') {
					$editbanner = "update " . $table_prefix . "banners set
						description=:description,
						contenttype=:contenttype,
						storagetype='url',
						imageurl=:imageurl,
						width=:width,
						height=:height,
						weight=:weight,
						url=:url,
						target=:target,
						alt=:alt,
						statustext=:statustext,
						bannertext=:bannertext,
						keyword=:keyword,
						comments=:comments,
						append=:append,
						prepend=:prepend,
						updated=now()
						where  bannerid=:bannerid";
				} else if ($storagetype == 'sql') {
					$editbanner = "update " . $table_prefix . "banners set
						contenttype=:contenttype,
						storagetype='sql',
						filename=:filename,
						width=:width,
						height=:height,
						weight=:weight,
						target=:target,
						alt=:alt,
						statustext=:statustext,
						bannertext=:bannertext,
						keyword=:keyword,
						comments=:comments,
						url=:url,
						description=:description,
						append=:append,
						prepend=:prepend,
						updated=now()
						where bannerid=:bannerid";
				} else if ($storagetype == 'txt') {
					$editbanner = "update " . $table_prefix . "banners set
						description=:description,
						contenttype=:contenttype,
						storagetype='txt',
						bannertext=:bannertext,
						url=:url,
						target=:target,
						statustext=:statustext,
						weight=:weight,
						keyword=:keyword,
						comments=:comments,
						append=:append,
						prepend=:prepend,
						updated=now()
						where bannerid=:bannerid";
				}
				$djax_query_banners = $this->db->prepare($editbanner);

				//contract campaign must have target value
				if ($storagetype == 'web') {

					//edit upload if they pass imageurl else take it from db
					if (isset($input['imageurl'])) {
						if ($c[1]) {
							$djax_query_banners->bindParam(":filename", $c[1]);
						} else {
							$djax_query_banners->bindParam(":filename", $filename);
						}
					} else {
						$djax_query_banners->bindParam(":filename", $filename);
					}

					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
					$djax_query_banners->bindParam(":contenttype", $contenttype);
					$djax_query_banners->bindParam(":alt", $alt);
				}

				if ($storagetype == 'sql') {
					$djax_query_banners->bindParam(":filename", $filename);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
					$djax_query_banners->bindParam(":contenttype", $contenttype);
					$djax_query_banners->bindParam(":alt", $alt);
				}

				if ($storagetype == 'url') {

					$djax_query_banners->bindParam(":imageurl", $url_banner_imageurl);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
					$djax_query_banners->bindParam(":contenttype", $contenttype);
					$djax_query_banners->bindParam(":alt", $alt);
				}

				if ($storagetype == 'txt') {
					$djax_query_banners->bindParam(":contenttype", $contenttype);
				}

				$djax_query_banners->bindParam(":bannerid", $bannerid);
				$djax_query_banners->bindParam(":description", $description);
				$djax_query_banners->bindParam(":weight", $weight);
				$djax_query_banners->bindParam(":target", $target);
				$djax_query_banners->bindParam(":statustext", $statustext);
				$djax_query_banners->bindParam(":bannertext", $bannertext);
				$djax_query_banners->bindParam(":keyword", $keyword);
				$djax_query_banners->bindParam(":comments", $comments);
				$djax_query_banners->bindParam(":url", $url);
				$djax_query_banners->bindParam(":append", $append);
				$djax_query_banners->bindParam(":prepend", $prepend);

				$djax_query_banners->execute();
			} else {

				//////// HTMLBANNER ///////////
				//echo "this is html banner";

				if (isset($input['width'])) {
					$width = $input['width'];
				} else {
					$width = $stmtbanner[0]['width'];
				}

				if (isset($input['height'])) {
					$height = $input['height'];
				} else {
					$height = $stmtbanner[0]['height'];
				}

				if (isset($input['contenttype'])) {
					$contenttype = $input['contenttype'];
				} else {
					$contenttype = $stmtbanner[0]['contenttype'];
				}

				$ext_bannertype = $stmtbanner[0]['ext_bannertype'];
				$url = isset($input['url']) ? $input['url'] : $stmtbanner[0]['url'];
				$target = isset($input['target']) ? $input['target'] : $stmtbanner[0]['target'];
				$keyword = isset($input['keyword']) ? $input['keyword'] : $stmtbanner[0]['keyword'];
				$comments = isset($input['comments']) ? $input['comments'] : $stmtbanner[0]['comments'];
				$append = isset($input['append']) ? $input['append'] : $stmtbanner[0]['append'];
				$prepend = isset($input['prepend']) ? $input['prepend'] : $stmtbanner[0]['prepend'];

				if (isset($input['total_impressions'])) {
					$tot_num_impression = $input['total_impressions'];
				} else {
					$tot_num_impression = $stmtbanner[0]['impressions_total'];
				}

				if (isset($input['unlimited_impression'])) {
					//~ $unlimit_impression = isset($input['unlimited_impression'])?'t':'f';
					if ($input['unlimited_impression'] == 'true') {
						$unlimit_impression = 't';
					} else {
						$unlimit_impression = 'f';
					}
				} else {
					//~ $unlimit_impression = isset($stmtbanner[0]['impr_unlimited'])?'t':'f';
					if ($stmtbanner[0]['impr_unlimited'] == 't') {
						$unlimit_impression = 't';
					} else {
						$unlimit_impression = 'f';
					}
				}

				if (isset($input['y_num_impression'])) {
					$limit_y_num_impressions = $input['y_num_impression'];
				} else {
					$limit_y_num_impressions = $stmtbanner[0]['impressions_number'];
				}

				if (isset($input['impressions_time'])) {
					$impr_time = $input['impressions_time'];
				} else {
					$impr_time = $stmtbanner[0]['impressions_time'];
				}


				if ($storagetype == 'html' && $ext_bannertype == 'bannerTypeHtml:oxHtml:genericHtml') {
					// "this is general html banner";
					$width = $input['width'];
					$height = $input['height'];
					$htmltemplate = $input['htmltemplate'];
					if (empty($width) || empty($height) || empty($htmltemplate)) {
						$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($response);
						exit;
					}
					$htmlcache = '<a href="{clickurl}" target="{target}">' . $htmltemplate . '</a>';

					$editbanner = "update " . $table_prefix . "banners set
						description=:description,
						storagetype='html',
						htmltemplate=:htmltemplate,
						htmlcache=:htmlcache,
						width=:width,
						height=:height,
						weight=:weight,
						url=:url,
						target=:target,
						keyword=:keyword,
						comments=:comments,
						append=:append,
						prepend=:prepend,
						updated=now()
						where bannerid=:bannerid;";

					$djax_query_banners = $this->db->prepare($editbanner);
					$djax_query_banners->bindParam(":bannerid", $bannerid);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":url", $url);
					$djax_query_banners->bindParam(":htmltemplate", $htmltemplate);
					$djax_query_banners->bindParam(":htmlcache", $htmlcache);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
					$djax_query_banners->bindParam(":weight", $weight);
					$djax_query_banners->bindParam(":target", $target);
					$djax_query_banners->bindParam(":keyword", $keyword);
					$djax_query_banners->bindParam(":comments", $comments);
					$djax_query_banners->bindParam(":append", $append);
					$djax_query_banners->bindParam(":prepend", $prepend);

					$djax_query_banners->execute();
				}

				//HTML5 Zip BANNER

				if ($storagetype == 'html' && $ext_bannertype == 'bannerTypeHtml:oxHtml:html5') {
					$width = $input['width'];
					$height = $input['height'];
					$filename = $input['filename'];
					if (empty($width) || empty($height) || empty($filename)) {
						$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($response);
						exit;
					}

					if (isset($input['filename'])) {

						/* Source File URL */
						$remote_file_url = $filename;

						include_once('../../config.php');

						$image_revivepath = $reviveapiPath;

						/* New file name and path for this file */
						$local_file = $image_revivepath . 'test_html5.zip';

						/* Copy the file from source url to server */
						$copy = copy($remote_file_url, $local_file);

						$file = $local_file;

						$path = pathinfo(realpath($file), PATHINFO_DIRNAME);


						$baseurl = explode('/', $path);
						array_pop($baseurl);
						array_pop($baseurl);
						$randfolder = uniqid(); 
						$furl = implode('/', $baseurl) . "/www/images/" . $randfolder;

						$zip = new ZipArchive;

						$res = $zip->open($file);

						for ($i = 0; $i < $zip->numFiles; $i++) {
							$kowsi = $zip->getNameIndex($i);
							$fileinfo = pathinfo($kowsi);
							$kowsi = substr_replace($kowsi, "", -1);

							if ($fileinfo['filename'] == 'index') {
								$indexfolder = $fileinfo['dirname'];
							}
						}

						$kowsi = substr($kowsi, 0, strpos($kowsi, "/"));

						if ($kowsi)
							$html5filename = $randfolder . '/' . $indexfolder;
						else
							$html5filename = $randfolder;

						chmod($furl . "/" . $kowsi, 0777);

						if ($res === TRUE) {
							$tt = $zip->extractTo($furl);

							chmod($furl . "/" . $kowsi, 0777);

							$zip->close();
							$local_file = $image_revivepath . $randfolder;
							unlink($local_file);
						} else if ($input['filename']) {
							$randfolder = $input['filename'];
						} else {
							echo "try again with crct zip file";
						}
					}

					$editbanner = "update " . $table_prefix . "banners set
						description=:description,
						storagetype='html',
						filename='" . $html5filename . "',
						width=:width,
						height=:height,
						weight=:weight,
						url=:url,
						keyword=:keyword,
						comments=:comments,
						append=:append,
						prepend=:prepend,
						updated=now()
						where bannerid=:bannerid";

					$djax_query_banners = $this->db->prepare($editbanner);
					$djax_query_banners->bindParam(":bannerid", $bannerid);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":url", $url);

					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
					$djax_query_banners->bindParam(":weight", $weight);
					$djax_query_banners->bindParam(":keyword", $keyword);
					$djax_query_banners->bindParam(":comments", $comments);
					$djax_query_banners->bindParam(":append", $append);
					$djax_query_banners->bindParam(":prepend", $prepend);

					$djax_query_banners->execute();
				} else if ($storagetype == 'html' && $width == -3 && $height == -3 && $ext_bannertype == 'bannerTypeHtml:apVideo:Network') {
					$bannertext = $input['bannertext'];

					if (empty($bannertext)) {
						$results = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($results);
					}

					$editbanner = "Update " . $table_prefix . "banners set
						description=:description,
						storagetype='html',
						weight=:weight,
						bannertext=:bannertext,
						ext_bannertype='bannerTypeHtml:apVideo:Network',
						updated=now(),
						keyword=:keyword,
						comments=:comments,
                        append=:append,
                        prepend=:prepend
						where bannerid=:bannerid";

					$djax_query_banners = $this->db->prepare($editbanner);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":weight", $weight);
					$djax_query_banners->bindParam(":bannertext", $bannertext);
					$djax_query_banners->bindParam(":keyword", $keyword);
					$djax_query_banners->bindParam(":comments", $comments);
					$djax_query_banners->bindParam(":append", $append);
					$djax_query_banners->bindParam(":prepend", $prepend);
					$djax_query_banners->bindParam(":bannerid", $bannerid);

					
					$djax_query_banners->execute();
				} else if ($storagetype == 'html' && $width == -3 && $height == -3 && $ext_bannertype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml') {

					$dbparameters = $stmtbanner[0]['parameters'];
					$unparameters = unserialize($dbparameters);

					$vast_video_duration = $input['vast_video_duration'];
					$vast_video_type = $input['vast_video_type'];
					$vast_video_outgoing_filename = $input['vast_video_outgoing_filename'];
					if (empty($vast_video_duration) || empty($vast_video_type) || empty($vast_video_outgoing_filename)) {
						$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($response);
						exit;
					}

					$vast_video_clickthrough_url = isset($input['vast_video_clickthrough_url']) ? $input['vast_video_clickthrough_url'] : $unparameters['vast_video_clickthrough_url'];
					$vast_video_delivery = isset($input['vast_video_delivery']) ? $input['vast_video_delivery'] : $unparameters['vast_video_delivery'];
					$vast_companion_banner_id = isset($input['vast_companion_banner_id']) ? $input['vast_companion_banner_id'] : $unparameters['vast_companion_banner_id'];
					$vast_thirdparty_impression = isset($input['vast_thirdparty_impression']) ? $input['vast_thirdparty_impression'] : $unparameters['vast_thirdparty_impression'];

					if ($vast_video_delivery == "progressive") {
						$saving_file = $vast_video_outgoing_filename;
					}

					if ($vast_video_delivery == "streaming") {
						if (isset($input['vast_net_connection_url']) && $input['vast_net_connection_url'] != "") {
							$vast_net_connection_url = $input['vast_net_connection_url'];
							$videotype = $input['videotype'];
							$vast_video_filename = $input['vast_video_filename'];
							$qot = ':';
							$vast_video_outgoing_filename = $vast_net_connection_url . $videotype . $qot . $vast_video_filename;
							$saving_file = $vast_net_connection_url . $videotype . ':' . $vast_video_filename;
						} else {
							$vast_video_outgoing_filename = $unparameters['vast_video_outgoing_filename'];
							$saving_file = $input['vast_video_outgoing_filename'];
						}
					}

					$var = [
						"banner_vast_element_id" => 'banner_vast_element_id',
						"vast_element_type" => 'singlerow',
						"vast_video_id" => 'N',
						"vast_video_duration" => $vast_video_duration,
						"vast_video_delivery" => $vast_video_delivery,
						"vast_video_type" => $vast_video_type,
						"vast_video_bitrate" => 400,
						"vast_video_height" => 480,
						"vast_video_width" => 640,
						"vast_video_outgoing_filename" => $saving_file,
						"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
						"vast_overlay_height" => 'N',
						"vast_overlay_width" => 'N',
						"vast_overlay_text_title" => 'N',
						"vast_overlay_text_description" => 'N',
						"vast_overlay_text_call" => 'N',
						"vast_overlay_format" => 'N',
						"vast_overlay_action" => 'N',
						"vast_companion_banner_id" => $vast_companion_banner_id,
						"vast_creative_type" => 'N',
						"vast_thirdparty_impression" => $vast_thirdparty_impression
					];

					$parameters = serialize($var);

					$editbanner = "update " . $table_prefix . "banners set
						description=:description,
						weight=:weight,
						url=:url,
						keyword=:keyword,
						comments=:comments,
						append=:append,
						prepend=:prepend,
						updated=now(),
						parameters=:parameters
						where bannerid=:bannerid";

					$djax_query_banners = $this->db->prepare($editbanner);
					$djax_query_banners->bindParam(":bannerid", $bannerid);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":url", $url);
					$djax_query_banners->bindParam(":parameters", $parameters);
					$djax_query_banners->bindParam(":weight", $weight);
					$djax_query_banners->bindParam(":keyword", $keyword);
					$djax_query_banners->bindParam(":comments", $comments);
					$djax_query_banners->bindParam(":append", $append);
					$djax_query_banners->bindParam(":prepend", $prepend);

					$djax_query_banners->execute();

					$editparameters = "update " . $table_prefix . "banner_vast_element set
						vast_video_duration=:vast_video_duration,
						vast_video_delivery=:vast_video_delivery,
						vast_video_type=:vast_video_type,
						vast_video_outgoing_filename=:vast_video_outgoing_filename,
						vast_companion_banner_id=:vast_companion_banner_id,
						vast_video_clickthrough_url=:vast_video_clickthrough_url,
						vast_thirdparty_impression=:vast_thirdparty_impression where banner_id=:banner_id ";

					$djax_query_banners_parameters = $this->db->prepare($editparameters);

					$djax_query_banners_parameters->bindParam(":vast_video_duration", $vast_video_duration);
					$djax_query_banners_parameters->bindParam(":vast_video_delivery", $vast_video_delivery);
					$djax_query_banners_parameters->bindParam(":vast_video_type", $vast_video_type);
					$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename", $vast_video_outgoing_filename);
					$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
					$djax_query_banners_parameters->bindParam(":vast_video_clickthrough_url", $vast_video_clickthrough_url);
					$djax_query_banners_parameters->bindParam(":vast_thirdparty_impression", $vast_thirdparty_impression);
					$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);
					$djax_query_banners_parameters->execute();
				} elseif ($storagetype == 'html' && $width == -2 && $height == -2) {
					$dbparameters = $stmtbanner[0]['parameters'];
					$unparameters = unserialize($dbparameters);

					$vast_overlay_format = $input['vast_overlay_format'];
					$vast_overlay_action = $input['vast_overlay_action'];

					if (empty($vast_overlay_format) || empty($vast_overlay_action)) {
						$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
						return $this->response->withJson($response);
						exit;
					}

					$vast_video_duration = $input['vast_video_duration'];
					$vast_video_type = $input['vast_video_type'];
					$saving_file = $input['vast_video_outgoing_filename'];

					if ($vast_overlay_action == 'click_to_video') {
						if (empty($vast_video_duration) || empty($vast_video_type) || empty($saving_file)) {
							$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
							return $this->response->withJson($response);
							exit;
						}
					}

					$url = $input['url'];
					if ($vast_overlay_action == 'click_to_page') {
						if (empty($url)) {
							$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
							return $this->response->withJson($response);
							exit;
						}
					}

					if (isset($input['vast_video_delivery'])) {
						$vast_video_delivery = $input['vast_video_delivery'];
					} else {
						$vast_video_delivery = $unparameters['vast_video_delivery'];
					}

					if (isset($input['vast_thirdparty_impression'])) {
						$vast_thirdparty_impression = $input['vast_thirdparty_impression'];
					} else {
						$vast_thirdparty_impression = $unparameters['vast_thirdparty_impression'];
					}


					if (isset($input['vast_video_clickthrough_url'])) {
						$vast_video_clickthrough_url = $input['vast_video_clickthrough_url'];
					} else {
						$vast_video_clickthrough_url = $unparameters['vast_video_clickthrough_url'];
					}

					if (isset($input['vast_companion_banner_id'])) {
						$vast_companion_banner_id = $input['vast_companion_banner_id'];
					} else {
						$vast_companion_banner_id = $unparameters['vast_companion_banner_id'];
					}

					if (isset($input['vast_creative_type'])) {
						$vast_creative_type = $input['vast_creative_type'];
					} else {
						$vast_creative_type = $unparameters['vast_creative_type'];
					}

					if (isset($input['vast_overlay_height'])) {
						$vast_overlay_height = $input['vast_overlay_height'];
					} else {
						$vast_overlay_height = $unparameters['vast_overlay_height'];
					}

					if (isset($input['vast_overlay_width'])) {
						$vast_overlay_width = $input['vast_overlay_width'];
					} else {
						$vast_overlay_width = $unparameters['vast_overlay_width'];
					}

					$htmltemplate = $input['htmltemplate'];
					if ($vast_overlay_format == 'html_overlay') {
						if (empty($htmltemplate)) {
							$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
							return $this->response->withJson($response);
							exit;
						} else {
							$htmlcache = '<a href="{clickurl}" target="{target}">' . $htmltemplate . '</a>';
						}
					} else {
						$htmltemplate = '';
						$htmlcache = '<a href="{clickurl}" target="{target}"></a>';
					}

					$vast_overlay_text_title = $input['vast_overlay_text_title'];
					$vast_overlay_text_description = $input['vast_overlay_text_description'];
					$vast_overlay_text_call = $input['vast_overlay_text_call'];
					if ($vast_overlay_format == 'text_overlay') {
						if (empty($vast_overlay_text_title) || empty($vast_overlay_text_description) || empty($vast_overlay_text_call)) {
							$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
							return $this->response->withJson($response);
							exit;
						}
					}

					$imageurl = $input['imageurl'];
					if ($vast_overlay_format == "image_overlay") {
						if (empty($imageurl)) {
							$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
							return $this->response->withJson($response);
							exit;
						}
					}

					if ($imageurl) {
						$file = fopen($imageurl, "rb");
						if ($file) {

							$valid_exts = array("jpg", "jpeg", "gif", "png"); // default image only extensions
							$ext = explode(".", strtolower(basename($imageurl)));
							$ext = end($ext);

							$filename = basename($imageurl);
							$new = explode(".", $filename);
							$encryptfilename = md5($new[0]);

							$ac = $encryptfilename . "." . $new[1];
							$c[] = '';

							array_push($c, $ac);
							if (in_array($ext, $valid_exts)) {
								$rand = rand(10000, 99999);
								$newfile = fopen("" . $image_path . "" . $c[1], "wb"); // replace "downloads" with whatever directory you wish.

								if ($newfile) {
									while (!feof($file)) {
										// Write the url file to the directory.
										fwrite($newfile, fread($file, 1024 * 8), 1024 * 8); // write the file to the new directory at a rate of 8kb/sec. until we reach the end.
									}
								}
							}
						}
					}

					if ($vast_video_delivery == "progressive") {
						$saving_file = $input['vast_video_outgoing_filename'];
					}

					if ($vast_video_delivery == "streaming") {
						if (isset($input['vast_net_connection_url'])) {
							$vast_net_connection_url = $input['vast_net_connection_url'];
							$videotype = $input['videotype'];
							$vast_video_filename = $input['vast_video_filename'];
							$qot = ':';
							$vast_video_outgoing_filename = $vast_net_connection_url . $videotype . $qot . $vast_video_filename;
							$saving_file = $vast_net_connection_url . $videotype . ':' . $vast_video_filename;
						} else {
							$vast_video_outgoing_filename = $unparameters['vast_video_outgoing_filename'];
							$saving_file = $vast_video_outgoing_filename;
						}
					}

					if ($vast_overlay_action == 'click_to_page') {
						$vast_video_duration = '';
						$vast_video_delivery = '';
						$vast_video_type = '';
						$saving_file = '';
						$vast_video_clickthrough_url = '';
					}

					$var = array();
					$var = array(
						"banner_vast_element_id" => 'banner_vast_element_id',
						"vast_element_type" => 'singlerow',
						"vast_video_id" => 'N',
						"vast_video_duration" => $vast_video_duration,
						"vast_video_delivery" => $vast_video_delivery,
						"vast_video_type" => $vast_video_type,
						"vast_video_bitrate" => 400,
						"vast_video_height" => 480,
						"vast_video_width" => 640,
						"vast_video_outgoing_filename" => $saving_file,
						"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
						"vast_overlay_height" => $vast_overlay_height,
						"vast_overlay_width" => $vast_overlay_width,
						"vast_overlay_text_title" => $vast_overlay_text_title,
						"vast_overlay_text_description" => $vast_overlay_text_description,
						"vast_overlay_text_call" => $vast_overlay_text_call,

						"vast_overlay_format" => $vast_overlay_format,
						"vast_overlay_action" => $vast_overlay_action,
						"vast_companion_banner_id" => $vast_companion_banner_id,
						"vast_creative_type" => $vast_creative_type,
						"vast_thirdparty_impression" => $vast_thirdparty_impression
					);

					$parameter = serialize($var);

					$editbanner = "update " . $table_prefix . "banners set
						description=:description,
						filename=:filename,
						htmlcache =:htmlcache,
						htmltemplate=:htmltemplate,
						weight=:weight,
						url=:url,
						parameters=:parameters,
						keyword=:keyword,
						comments=:comments,
						append=:append,
						prepend=:prepend
						where bannerid=:bannerid";

					$djax_query_banners = $this->db->prepare($editbanner);

					$djax_query_banners->bindParam(":filename", $ac);
					$djax_query_banners->bindParam(":url", $url);
					$djax_query_banners->bindParam(":htmlcache", $htmlcache);
					$djax_query_banners->bindParam(":htmltemplate", $htmltemplate);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":parameters", $parameter);
					$djax_query_banners->bindParam(":weight", $weight);
					$djax_query_banners->bindParam(":keyword", $keyword);
					$djax_query_banners->bindParam(":comments", $comments);
					$djax_query_banners->bindParam(":append", $append);
					$djax_query_banners->bindParam(":prepend", $prepend);

					$djax_query_banners->bindParam(":bannerid", $bannerid);

					$djax_query_banners->execute();

					$banner_vast_element_id = 40;

					$editparameters = "update " . $table_prefix . "banner_vast_element set
						vast_video_duration=:vast_video_duration,
						vast_video_delivery=:vast_video_delivery,
						vast_video_type=:vast_video_type,
						vast_video_outgoing_filename=:vast_video_outgoing_filename,
						vast_companion_banner_id=:vast_companion_banner_id,
						vast_overlay_height=:vast_overlay_height,
						vast_overlay_width=:vast_overlay_width,
						vast_video_clickthrough_url=:vast_video_clickthrough_url,
						vast_overlay_action=:vast_overlay_action,
						vast_overlay_format=:vast_overlay_format,
						vast_overlay_text_title=:vast_overlay_text_title,
						vast_overlay_text_description=:vast_overlay_text_description,
						vast_overlay_text_call=:vast_overlay_text_call,
						vast_creative_type=:vast_creative_type,
						vast_thirdparty_impression=:vast_thirdparty_impression		
						where banner_id=:banner_id";

					$djax_query_banners_parameters = $this->db->prepare($editparameters);

					$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);
					$djax_query_banners_parameters->bindParam(":vast_video_duration", $vast_video_duration);
					$djax_query_banners_parameters->bindParam(":vast_video_delivery", $vast_video_delivery);

					$djax_query_banners_parameters->bindParam(":vast_video_type", $vast_video_type);

					$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename", $saving_file);
					$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
					$djax_query_banners_parameters->bindParam(":vast_overlay_height", $vast_overlay_height);
					$djax_query_banners_parameters->bindParam(":vast_overlay_width", $vast_overlay_width);
					$djax_query_banners_parameters->bindParam(":vast_video_clickthrough_url", $vast_video_clickthrough_url);

					$djax_query_banners_parameters->bindParam(":vast_overlay_format", $vast_overlay_format);
					$djax_query_banners_parameters->bindParam(":vast_overlay_action", $vast_overlay_action);

					$djax_query_banners_parameters->bindParam(":vast_overlay_text_title", $vast_overlay_text_title);
					$djax_query_banners_parameters->bindParam(":vast_overlay_text_description", $vast_overlay_text_description);
					$djax_query_banners_parameters->bindParam(":vast_overlay_text_call", $vast_overlay_text_call);

					$djax_query_banners_parameters->bindParam(":vast_creative_type", $vast_creative_type);
					$djax_query_banners_parameters->bindParam(":vast_thirdparty_impression", $vast_thirdparty_impression);

					$djax_query_banners_parameters->execute();
				}
			}

			$response = array('response' => 'Success', 'message' => 'Banner details has been updated successfully', 'status' => '200');
			return $this->response->withJson($response);
		} else {
			$response = array('response' => 'error', 'message' => 'Please enter valid bannerid', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('banneradd_edit'));


$app->post('/set_limitation/[{bannerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$input    = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$req = "select *  from " . $table_prefix . "banners WHERE bannerid=:bannerid";
		$cam      = $this->db->prepare($req);
		$cam->bindParam("bannerid", $args['bannerid']);
		$cam->execute();
		$campaign  = $cam->fetch();

		if (!$campaign) {
			$res = array(
				'response' => 'error',
				'message' => 'Bannerid is not valid.',
				'status' => '404'
			);
			return $this->response->withJson($res);
		}


		$bannerid = "select bannerid  from " . $table_prefix . "banners WHERE bannerid=:bannerid";
		$bnr      = $this->db->prepare($bannerid);
		$bnr->bindParam("bannerid", $args['bannerid']);
		$bnr->execute();
		$banner  = $bnr->fetchAll();
		$data['compiledlimitation'] = '';
		$data['acl_plugins']        = '';

		if (!$banner) {
			$res = array(
				'response' => 'error',
				'message' => 'No banner under this campaignid!Atleast one banner required for campaign targetting!',
				'status' => '404'
			);
			return $this->response->withJson($res);
		}

		$comparison = array('==', '!=', '=~', '!~', '=x', '!x', 'gt', 'lt', 'le', 'ge', '>', '<', '>=', '<=', 'nn');
		
		foreach ($input as $inp) {
			if(($inp['logical'] && $inp['type'] && $inp['comparison'] && $inp['data'])) 
			{
		
				if (!in_array($inp['comparison'], $comparison)) {

					$response = array(
						'response' => 'error',
						'message' => 'Comparision operator passed in array is not supported!',
						'status' => '404'
					);

					return $this->response->withJson($response);
				
			}
		}else{
			$response = array(
				'response' => 'error',
				'message' => 'Please check with input parameters.',
				'status' => '404'
				);
				
				 return $this->response->withJson($response);
		}
		}


		foreach ($banner as $dat) {
			$executionid = "Delete from " . $table_prefix . "acls WHERE bannerid=:bannerid";
			$bnr         = $this->db->prepare($executionid);
			$bnr->bindParam("bannerid", $dat['bannerid']);
			$bnr->execute();
		}


		foreach ($banner as $dat) {
			if ($input) {
				foreach ($input as $inp) {

					//set function name using delivery limitations


					switch ($inp['type']) {
						case 'deliveryLimitations:Client:Browser':
							$function_name  = 'MAX_checkClient_Browser';
							$string_compare = 'Client:Browser';
							break;
						case 'deliveryLimitations:Client:BrowserVersion':
							$function_name  = 'MAX_checkClient_BrowserVersion';
							$string_compare = 'Client:BrowserVersion';
							break;
						case 'deliveryLimitations:Client:Domain':
							$function_name  = 'MAX_checkClient_Domain';
							$string_compare = 'Client:Domain';
							break;
						case 'deliveryLimitations:Client:Ip':
							$function_name  = 'MAX_checkClient_Ip';
							$string_compare = 'Client:Ip';
							break;
						case 'deliveryLimitations:Client:Language':
							$function_name  = 'MAX_checkClient_Language';
							$string_compare = 'Client:Language';
							break;
						case 'deliveryLimitations:Client:Os':
							$function_name  = 'MAX_checkClient_Os';
							$string_compare = 'Client:Os';
							break;
						case 'deliveryLimitations:Client:OsVersion':
							$function_name  = 'MAX_checkClient_OsVersion';
							$string_compare = 'Client:OsVersion';
							break;
						case 'deliveryLimitations:Client:Useragent':
							$function_name  = 'MAX_checkClient_Useragent';
							$string_compare = 'Client:Useragent';
							break;
						case 'deliveryLimitations:Site:Pageurl':
							$function_name  = 'MAX_checkSite_Pageurl';
							$string_compare = 'Site:Pageurl';
							break;

						case 'deliveryLimitations:Site:Referingpage':
							$function_name  = 'MAX_checkSite_Referingpage';
							$string_compare = 'Site:Referingpage';
							break;
						case 'deliveryLimitations:Site:Registerabledomainlist':
							$function_name  = 'MAX_checkSite_Registerabledomainlist';
							$string_compare = 'Site:Registerabledomainlist';
							break;
						case 'deliveryLimitations:Site:Hostnamelist':
							$function_name  = 'MAX_checkSite_Hostnamelist';
							$string_compare = 'Site:Hostnamelist';
							break;
						case 'deliveryLimitations:Site:Source':
							$function_name  = 'MAX_checkSite_Source';
							$string_compare = 'Site:Source';
							break;
						case 'deliveryLimitations:Site:Variable':
							$function_name  = 'MAX_checkSite_Variable';
							$string_compare = 'Site:Variable';
							break;
						case 'deliveryLimitations:Time:Date':
							$function_name  = 'MAX_checkTime_Date';
							$string_compare = 'Time:Date';
							break;
						case 'deliveryLimitations:Time:Day':
							$function_name  = 'MAX_checkTime_Day';
							$string_compare = 'Time:Day';
							break;
						case 'deliveryLimitations:Time:Hour':
							$function_name  = 'MAX_checkTime_Hour';
							$string_compare = 'Time:Hour';
							break;
						case 'deliveryLimitations:Geo:Areacode':
							$function_name  = 'MAX_checkGeo_Areacode';
							$string_compare = 'Geo:Areacode';
							break;
						case 'deliveryLimitations:Geo:City':
							$function_name  = 'MAX_checkGeo_City';
							$string_compare = 'Geo:City';
							break;
						case 'deliveryLimitations:Geo:Country':
							$function_name  = 'MAX_checkGeo_Country';
							$string_compare = 'Geo:Country';
							break;
						case 'deliveryLimitations:Geo:Dma':
							$function_name  = 'MAX_checkGeo_Dma';
							$string_compare = 'Geo:Dma';
							break;
						case 'deliveryLimitations:Geo:Latlong':
							$function_name  = 'MAX_checkGeo_Latlong';
							$string_compare = 'Geo:Latlong';
							break;
						case 'deliveryLimitations:Geo:Netspeed':
							$function_name  = 'MAX_checkGeo_Netspeed';
							$string_compare = 'Geo:Netspeed';
							break;
						case 'deliveryLimitations:Geo:Organisation':
							$function_name  = 'MAX_checkGeo_Organisation';
							$string_compare = 'Geo:Organisation';
							break;
						case 'deliveryLimitations:Geo:Postalcode':
							$function_name  = 'MAX_checkGeo_Postalcode';
							$string_compare = 'Geo:Postalcode';
							break;
						case 'deliveryLimitations:Geo:Region':
							$function_name  = 'MAX_checkGeo_Region';
							$string_compare = 'Geo:Region';
							break;
						case 'deliveryLimitations:Geo:Continent':
							$function_name  = 'MAX_checkGeo_Continent';
							$string_compare = 'Geo:Continent';
							break;
						case 'deliveryLimitations:Parameter:Gender':
							$function_name  = 'MAX_checkParameter_Gender';
							$string_compare = 'Param:Gender';
							break;
						case 'deliveryLimitations:Parameter:Title':
							$function_name  = 'MAX_checkParameter_Title';
							$string_compare = 'Param:Title';
							break;
						case 'deliveryLimitations:Parameter:Episode':
							$function_name  = 'MAX_checkParameter_Episode';
							$string_compare = 'Param:Episode';
							break;
						case 'deliveryLimitations:Parameter:Series':
							$function_name  = 'MAX_checkParameter_Series';
							$string_compare = 'Param:Series';
							break;
						default:
							$function_name  = 'Empty';
							$string_compare = 'Empty';
							break;
					}


					//Insert values into ".$table_prefix."acls table
					//select maximum values from the table
					$executionid = "select MAX(executionorder) as execid,data  from " . $table_prefix . "acls WHERE bannerid=:bannerid";
					$bnr         = $this->db->prepare($executionid);
					$bnr->bindParam("bannerid", $dat['bannerid']);
					$bnr->execute();
					$bnr_exec = $bnr->fetchAll();
					if ($bnr_exec['0']['data']) {
						$bnr_exec['0']['execid'] += 1;
					} else {
						$bnr_exec['0']['execid'] = 0;
					}

					if ($inp["type"]) {
						//Insert values into ".$table_prefix."acls table
						$sql = "INSERT INTO " . $table_prefix . "acls (bannerid,logical,type,comparison,data,executionorder) VALUES (:bannerid,:logic,:type,:comparison,:data,:executionorder)";
						$sth = $this->db->prepare($sql);
						$sth->bindParam("bannerid", $dat['bannerid']);
						$sth->bindParam("logic", $inp['logical']);
						$sth->bindParam("type", $inp['type']);
						$sth->bindParam("comparison", $inp['comparison']);
						$sth->bindParam("data", $inp['data']);
						$sth->bindParam("executionorder", $bnr_exec['0']['execid']);
						$sth->execute();



						if ($inp["type"]) {

							//continent-geo


							if ($inp["type"] == 'deliveryLimitations:Geo:Continent') {
								$inp["data"] = explode(",", $inp["data"]);

								$continent_array = array();
								foreach ($inp["data"] as $kk => $test_limit) {
									if ($test_limit == "AF") {
										$con_val = 'ao,bf,bi,bj,bw,cd,cf,cg,ci,cm,cv,dj,dz,eg,eh,er,et,ga,gh,gm,gn,gq,gw,ke,km,lr,ls,ly,ma,mg,ml,mr,mu,mw,mz,na,ne,ng,re,rw,sc,sd,sh,sl,sn,so,st,sz,td,tg,tn,tz,ug,yt,za,zm,zw,ss';
									}
									if ($test_limit == "IN") {
										$con_val = 'kowsi';
									}
									if ($test_limit == "AQ") {
										$con_val = '';
									}
									if ($test_limit == "CA") {
										$con_val = '';
									}
									if ($test_limit == "AS") {
										$con_val = 'ap,ae,af,am,az,bd,bh,bn,bt,cc,cn,cx,cy,ge,hk,id,il,in,io,iq,ir,jo,jp,kg,kh,kp,kr,kw,kz,la,lb,lk,mm,mn,mo,mv,my,np,om,ph,pk,ps,qa,sa,sg,sy,th,tj,tm,tl,tw,uz,vn,ye';
									}
									if ($test_limit == "EU") {
										$con_val = 'eu,ad,al,at,ba,be,bg,by,ch,cz,de,dk,ee,es,fi,fo,fr,gb,gi,gr,hr,hu,ie,is,it,li,lt,lu,lv,mc,md,mk,mt,nl,no,pl,pt,ro,ru,se,si,sj,sk,sm,tr,ua,va,rs,me,ax,gg,im,je';
									}
									if ($test_limit == "EU") {
										$con_val = 'eu,ad,al,at,ba,be,bg,by,ch,cz,de,dk,ee,es,fi,fo,fr,gb,gi,gr,hr,hu,ie,is,it,li,lt,lu,lv,mc,md,mk,mt,nl,no,pl,pt,ro,ru,se,si,sj,sk,sm,tr,ua,va,rs,me,ax,gg,im,je';
									}
									if ($test_limit == "NA") {
										$con_val = 'ag,ai,cw,aw,bb,bm,bs,bz,ca,cr,cu,dm,do,sx,gd,gl,gp,gt,hn,ht,jm,kn,ky,lc,mq,ms,mx,ni,pa,pm,pr,sv,tc,tt,us,vc,vg,vi,bl,mf,bq';
									}
									if ($test_limit == "OC") {
										$con_val = 'as,au,ck,fj,fm,gu,ki,mh,mp,nc,nf,nr,nu,nz,pf,pg,pn,pw,sb,tk,to,tv,um,vu,wf,ws';
									}
									if ($test_limit == "SA") {
										$con_val = 'ar,bo,br,cl,co,ec,fk,gf,gy,pe,py,sr,uy,ve';
									}
									if ($test_limit == "AN") {
										$con_val = 'bv,gs,hm,tf';
									}

									$continent_array[] = $con_val;
								}
								$inp["data"] = implode(",", array_filter($continent_array));
							}

							//end

							if ($inp["type"] == 'deliveryLimitations:Geo:City') {
								$inp["data"] =   strtolower($inp["data"]);
							}
							if ($inp["type"] == 'deliveryLimitations:Geo:Region') {
								$inp["data"] =   strtolower($inp["data"]);
							}

							if ($data['compiledlimitation'] && $data['acl_plugins']) {
								$data['compiledlimitation'] .= ' ' . $inp["logical"] . " " . $function_name . "('" . $inp["data"] . "', '" . $inp["comparison"] . "')";
								$chk = '"' . $inp["type"] . '"';
								if (strpos(strtolower($data["acl_plugins"]), strtolower($string_compare)) == false) {

									$data["acl_plugins"] .= ',' . $inp["type"];
								}
							} else {
								$data["compiledlimitation"] .= $function_name . "('" . $inp["data"] . "', '" . $inp["comparison"] . "')";
								$data["acl_plugins"] .= $inp["type"];
							}
						} else {
							$data['compiledlimitation'] = '';
							$data['acl_plugins'] = '';
						}
					} else {
						$data['compiledlimitation'] = '';
						$data['acl_plugins'] = '';
					}



					$sqlupdate = "UPDATE " . $table_prefix . "banners SET compiledlimitation=:check,acl_plugins=:type WHERE bannerid=:bannerid";
					$stc       = $this->db->prepare($sqlupdate);
					$stc->bindParam("type", $data['acl_plugins']);
					$stc->bindParam("check", $data['compiledlimitation']);
					$stc->bindParam("bannerid", $dat['bannerid']);
					$stc->execute();
				}
			} else {

				$res = array(
					'response' => 'error',
					'message' => 'Please check with input parameters',
					'status' => '404'
				);
				return $this->response->withJson($res);
			}
		}

		$res = array(
			'response' => 'Success',
			'message' => 'Banner delivery limitations has been updated successfully',
			'status' => '200'
		);
		return $this->response->withJson($res);
		return $response;
	}
})->add($container->get('limitValidation'));



$app->get('/get_limitation/[{bannerid}]', function ($request, $response, $args) {
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$bannerid = $args['bannerid'];
	$getlimitation = "SELECT * from " . $table_prefix . "acls where bannerid=:bannerid";
	$djax_query_getlimitation = $this->db->prepare($getlimitation);
	$djax_query_getlimitation->bindParam(":bannerid", $bannerid);
	$djax_query_getlimitation->execute();
	$stmtlimitations = $djax_query_getlimitation->fetchAll();
	$num = count($stmtlimitations);
	$banner_limitationdetail = array();
	if (count($stmtlimitations) > 0) {
		foreach ($stmtlimitations as $limitations) {
			$banner_limitationdetail = array(
				'bannerid' => $limitations['bannerid'],
				'data' => $limitations['data'],
				'type' => $limitations['type'],
				'executionorder' => $limitations['executionorder'],
				'logical' => $limitations['logical']
			);
		}
		$data['data'] = $banner_limitationdetail;

				$data['response'] = "success";
		        $data['message'] = "Limitation single data list'";
		        $data['status'] = "200";
			return $this->response->withJson($data);
	
	} else {
		$results = array('response' => 'Error', 'message' => 'No limitations available for the bannerid provided!', 'status' => '204');
		return $this->response->withJson($results);
	}
});




$app->delete('/deletebanner_all_limitation/[{bannerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$bannerid = $args['bannerid'];
		$referchannel = "select * from  {$table_prefix}acls where bannerid=:bannerid";
		$djax_query_referchannel = $this->db->prepare($referchannel);
		$djax_query_referchannel->bindParam(":bannerid", $bannerid);
		$djax_query_referchannel->execute();

		$stmtchannel = $djax_query_referchannel->fetch();


		if (count($stmtchannel) > 0) {

			$deletechannel = "update {$table_prefix}banners set compiledlimitation='true' , acl_plugins='' where bannerid=:bannerid";
			$djax_query_deletechannel = $this->db->prepare($deletechannel);
			$djax_query_deletechannel->bindParam(":bannerid", $bannerid);
			$djax_query_deletechannel->execute();


			$deleteacls = "DELETE FROM  {$table_prefix}acls WHERE bannerid=:bannerid";
			$djax_query_deleteacls = $this->db->prepare($deleteacls);
			$djax_query_deleteacls->bindParam(":bannerid", $bannerid);
			$djax_query_deleteacls->execute();


			$response = array('response' => 'Success', 'message' => 'all limitation under banner Successfully deleted', 'status' => '200');
		} else {

			$response = array('response' => 'error', 'message' => 'Please Enter the Valid Banner Id', 'status' => '404');
		}
	}



	return $this->response->withJson($response);
});




/*
 * Get Banner details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */

$app->get('/get_all_banner/[{campaignid}]', function ($request, $response, $args) {

	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$campaignid = $args['campaignid'];
	$banner_list = "select * from " . $table_prefix . "banners where campaignid=:campaignid";
	$allbanners_det = $this->db->prepare($banner_list);
	$allbanners_det->bindParam(":campaignid", $campaignid);
	$allbanners_det->execute();
	$details = $allbanners_det->fetchAll();
	$num = count($details);
	$bannerdetails = array();
	if ($num > 0) {

		foreach ($details as $banner) {
			$bannerdetails[] = array(
				'campaignid' => $banner['campaignid'],
				'bannerid' => $banner['bannerid'],
				'contenttype' => $banner['contenttype'],
				'storagetype' => $banner['storagetype'],
				'filename' => $banner['filename'],
				'imageurl' => $banner['imageurl'],
				'htmltemplate' => $banner['htmltemplate'],
				'htmlcache' => $banner['htmlcache'],
				'width' => $banner['width'],
				'height' => $banner['height'],
				'weight' => $banner['weight'],
				'seq' => $banner['seq'],
				'htmltemplate' => $banner['htmltemplate'],
				'target' => $banner['target'],
				'url' => $banner['url'],
				'alt' => $banner['alt'],
				'statustext' => $banner['statustext'],
				'bannertext' => $banner['bannertext'],
				'adserver' => $banner['adserver'],
				'description' => $banner['description'],
				'block' => $banner['block'],
				'capping' => $banner['capping'],
				'session_capping' => $banner['session_capping'],
				'compiledlimitation' => $banner['compiledlimitation'],
				'acl_plugins' => $banner['acl_plugins'],
				'append' => $banner['append'],
				'comments' => $banner['comments'],
				'updated' => $banner['updated'],
				'acls_updated' => $banner['acls_updated'],
				'keyword' => $banner['keyword'],
				'parameters' => unserialize($banner['parameters']),
				'ext_bannertype' => $banner['ext_bannertype'],
				'status' => $banner['status'],
				'transparent' => $banner['transparent'],
				'bannertype' => $banner['bannertype'],
				'iframe_friendly' => $banner['iframe_friendly'],

			);
		}
		$data['data'] = $bannerdetails;
		$data['response'] = "success";
		$data['message'] = "Banner All Data List";
		$data['status'] = "200";
		return $this->response->withJson($data);

	} else {
		$results = array('response' => 'error', 'message' => 'Please Enter the valid campaign Id', 'status' => '404');
		return $this->response->withJson($results);
	}
});

/*
 * Get Banner details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Banner ID
 */

$app->get('/get_banner/[{bannerid}]', function ($request, $response, $args) {
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	if ($_SERVER["HTTPS"] == "on") {
		$https = 'https';
	} else {
		$https = 'http';
	}
	$image_path = $https . '://' . $this->get('settings')['path']['image_path'];
	$bannerid = $args['bannerid'];
	$datetime = date('Y-m-d H:i:s');
	$results = array();
	$bannerdetail = "SELECT ban.bannerid,ban.campaignid,cam.campaignname,ban.contenttype,ban.description,ban.storagetype,ban.filename,ban.imageurl,ban.htmltemplate,ban.width,ban.height,ban.weight,ban.url,ban.bannertext,ban.ext_bannertype,ban.append,ban.prepend,bva.vast_video_delivery,bva.vast_video_duration,bva.vast_video_type,bva.vast_overlay_format,bva.vast_overlay_action,bva.vast_overlay_text_title,bva.vast_overlay_text_description,bva.vast_overlay_text_call,bva.vast_video_outgoing_filename,bva.vast_video_clickthrough_url,bva.vast_companion_banner_id,bva.vast_thirdparty_impression from " . $table_prefix . "banners ban LEFT JOIN " . $table_prefix . "banner_vast_element bva on ban.bannerid = bva.banner_id LEFT JOIN " . $table_prefix . "campaigns cam on cam.campaignid = ban.campaignid where ban.bannerid=:bannerid";
	$getbanner = $this->db->prepare($bannerdetail);
	$getbanner->bindParam(":bannerid", $bannerid);
	$getbanner->execute();
	$bannerdet = $getbanner->fetch();
	$bannerdetail = array();

	if (count($bannerdet) > 0) {
		if ($bannerdet['storagetype'] == 'web') {
			$ext_bannertype = $bannerdet['storagetype'];
		} else if ($bannerdet['storagetype'] == 'sql') {
			$ext_bannertype = $bannerdet['storagetype'];
		} else if ($bannerdet['storagetype'] == 'url') {
			$ext_bannertype = $bannerdet['storagetype'];
		} else {
			$ext_bannertype = $bannerdet['ext_bannertype'];
		}
		if ($bannerdet['imageurl']) {
			$imageurl = $bannerdet['imageurl'];
		} else {
			if ($bannerdet['storagetype'] == 'url') {
				if ($bannerdet['imageurl']) {
					$imageurl = $bannerdet['imageurl'];
				} else {
					$imageurl = '';
				}
			} else {
				$imageurl = $image_path . '/' . $bannerdet['filename'];
			}
		}
		if ($imageurl) {
			$imagefolderoriginalsize = getimagesize($imageurl);
			$width = $imagefolderoriginalsize[0];
			$height = $imagefolderoriginalsize[1];
		} else {
			$width = $bannerdet['width'];
			$height = $bannerdet['height'];
		}
		//[$bannerid] 
		if($bannerdet['bannerid']){
			$bannerdetail = [
			'bannerid' => $bannerid,
				'campaignid' => $bannerdet['campaignid'],
				'campaignname' => $bannerdet['campaignname'],
				'contenttype' => $bannerdet['contenttype'],
				'description' => $bannerdet['description'],
				'storagetype' => $bannerdet['storagetype'],
				'filename' => $bannerdet['filename'],
			'imageurl' => $imageurl,
				'htmltemplate' => $bannerdet['htmltemplate'],
				'width' => $bannerdet['width'],
				'height' => $bannerdet['height'],
				'weight' => $bannerdet['weight'],
				'url' => $bannerdet['url'],
				'bannertext' => $bannerdet['bannertext'],
			'ext_bannertype' => $ext_bannertype,
				'append' => $bannerdet['append'],
				'prepend' => $bannerdet['prepend']
			];

			if($bannerdet['vast_video_outgoing_filename']){
				$bannerdetail['vast_video_outgoing_filename'] = $bannerdet['vast_video_outgoing_filename'];
				$bannerdetail['vast_video_clickthrough_url'] = $bannerdet['vast_video_clickthrough_url'];
				$bannerdetail['vast_video_delivery'] = $bannerdet['vast_video_delivery'];
				$bannerdetail['vast_video_duration'] = $bannerdet['vast_video_duration'];
				$bannerdetail['vast_video_type'] = $bannerdet['vast_video_type'];
				$bannerdetail['vast_overlay_format'] = $bannerdet['vast_overlay_format'];
				$bannerdetail['vast_overlay_action'] = $bannerdet['vast_overlay_action'];
				$bannerdetail['vast_overlay_text_title'] = $bannerdet['vast_overlay_text_title'];
				$bannerdetail['vast_overlay_text_description'] = $bannerdet['vast_overlay_text_description'];
				$bannerdetail['vast_overlay_text_call'] = $bannerdet['vast_overlay_text_call'];
				$bannerdetail['vast_companion_banner_id'] = $bannerdet['vast_companion_banner_id'];
				$bannerdetail['vast_thirdparty_impression'] = $bannerdet['vast_thirdparty_impression'];
			}

			$data['data'] = $bannerdetail;
            $data['response'] = "success";
            $data['message'] = "Banner single Data List";
            $data['status'] = "200";
            return $this->response->withJson($data);

		} else {
			$response = array('response' => 'error', 'message' => 'No Data', 'status' => '204');
			return $this->response->withJson($response);
		}
	} else {
		$response = array(
			'response' => 'error',
			'message' => 'Please enter the valid banner id',
			'status' => '404'
		);

		return $this->response->withJson($response);
	}
});


/*
 * Banner DELETE
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Banner ID
 */

$app->delete('/delete_banner/[{bannerid}]', function ($request, $response, $args) {

	$results = array();

	$input = $request->getParsedBody();
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$bannerid   = $args['bannerid'];
	$referbanner = "select * from " . $table_prefix . "banners where bannerid=:bannerid";
	$djax_query_referbanner = $this->db->prepare($referbanner);
	$djax_query_referbanner->bindParam(":bannerid", $bannerid);
	$djax_query_referbanner->execute();

	$stmtbanner = $djax_query_referbanner->fetchAll();


	if (count($stmtbanner) > 0) {

		$deleteaccounts = "DELETE FROM " . $table_prefix . "banners WHERE bannerid=:bannerid";
		$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
		$djax_query_deleteaccount->bindParam(":bannerid", $bannerid);
		$djax_query_deleteaccount->execute();


		$delete_element = "DELETE FROM " . $table_prefix . "banner_vast_element WHERE banner_id=:bannerid";
		$djax_query_delete_element = $this->db->prepare($delete_element);
		$djax_query_delete_element->bindParam(":bannerid", $bannerid);
		$banner_del = $djax_query_delete_element->execute();

		if ($banner_del) {
			$response = ['response' => 'Success', 'message' => 'Banner deleted successfully!', 'status' => '200'];
			return $this->response->withJson($response);
		}
	} else {

		$response = [
			'response' => 'error',
			'message' => 'Bannerid provided is invalid',
			'status' => '404'
		];

		return $this->response->withJson($response);
	}
});

/*
 * Banner Activate
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Banner ID
 */

$app->post('/banner_activate/[{bannerid}]', function ($request, $response, $args) {

	$results = array();

	$input = $request->getParsedBody();
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$bannerid   = $args['bannerid'];
	$referbanner = "select * from " . $table_prefix . "banners where bannerid=:bannerid";
	$djax_query_referbanner = $this->db->prepare($referbanner);
	$djax_query_referbanner->bindParam(":bannerid", $bannerid);
	$djax_query_referbanner->execute();

	$stmtbanner = $djax_query_referbanner->fetchAll();


	if (count($stmtbanner) > 0) {
		$banner_status = $stmtbanner[0]['status'];

		if ($banner_status == 1) {
			$update_status = "update {$table_prefix}banners set  status= 0 WHERE bannerid=:bannerid";
			$djax_query_update_status = $this->db->prepare($update_status);
			$djax_query_update_status->bindParam(":bannerid", $bannerid);
			$update_bannerstatus = $djax_query_update_status->execute();

			if ($update_bannerstatus) {
				$response = array(
					'response' => 'Success',
					'message' => 'Banner Activated successfully!',
					'status' => '200'
				);

				return $this->response->withJson($response);
			} else {

				$response = array(
					'response' => 'error',
					'message' => 'Banner not Activated!',
					'status' => '404'
				);

				return $this->response->withJson($response);
			}
		} else {

			$response = array(
				'response' => 'error',
				'message' => 'Banner already in Activated status!'
			);

			return $this->response->withJson($response);
		}
	} else {

		$response = array(
			'response' => 'error',
			'message' => 'Please Enter the Valid Banner Id',
			'status' => '404'
		);

		return $this->response->withJson($response);
	}
})->add($container->get('limitValidation'));

/*
 * Banner Deactivate
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Banner ID
 */

$app->post('/banner_deactivate/[{bannerid}]', function ($request, $response, $args) {

	$results = array();

	$input = $request->getParsedBody();
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$bannerid   = $args['bannerid'];
	$referbanner = "select * from " . $table_prefix . "banners where bannerid=:bannerid";
	$djax_query_referbanner = $this->db->prepare($referbanner);
	$djax_query_referbanner->bindParam(":bannerid", $bannerid);
	$djax_query_referbanner->execute();

	$stmtbanner = $djax_query_referbanner->fetchAll();


	if (count($stmtbanner) > 0) {
		$banner_status = $stmtbanner[0]['status'];

		if ($banner_status == 0) {
			$update_status = "update {$table_prefix}banners set  status=1 WHERE bannerid=:bannerid";
			$djax_query_update_status = $this->db->prepare($update_status);
			$djax_query_update_status->bindParam(":bannerid", $bannerid);
			$update_bannerstatus = $djax_query_update_status->execute();

			if ($update_bannerstatus) {
				$response = array(
					'response' => 'Success',
					'message' => 'Banner Deactivated successfully!',
					'status' => '200'
				);

				return $this->response->withJson($response);
			} else {

				$response = array(
					'response' => 'error',
					'message' => 'Banner not Dectivated!',
					'status' => '404'
				);

				return $this->response->withJson($response);
			}
		} else {

			$response = array(
				'response' => 'error',
				'message' => 'Banner already in Dectivated status!'
			);

			return $this->response->withJson($response);
		}
	} else {

		$response = array(
			'response' => 'error',
			'message' => 'Bannerid provided is invalid',
			'status' => '404'
		);

		return $this->response->withJson($response);
	}
})->add($container->get('limitValidation'));

/*---------------- BANNER ---------------*/
/*---------------- PUBLISHER ---------------*/
/*
 * PUBLISHER ADD
 * 
 * Input Parameters:
 * ----------------
 * contactname
 * email
 * website
 * username
 * password
 * name
 * 
 * Arguments:
 * ---------
 * Agency ID
 */


$app->post('/add_publisher/[{agencyid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$agencyid = $args['agencyid'];
		$agencyid_det = "select agencyid from " . $table_prefix . "agency where agencyid=" . $agencyid;
		$agencyid_tab = $this->db->prepare($agencyid_det);
		$agencyid_tab->execute();
		$check = $agencyid_tab->fetchAll();

		if (count($check) > 0) {
			$email = $input['email'];
			if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
				$results = array('response' => 'error', 'ERROR' => 'Invalid email format');
				return $this->response->withJson($results);
			}
			$website = $input['website'];
			if (!filter_var($website, FILTER_VALIDATE_URL)) {
				$results = array('response' => 'error', 'ERROR' => 'Please enter a valid Website name(website name should start with the prefix of http:// or https://)');
				return $this->response->withJson($results);
			}
			$contactname = $input['contact'];
			$name = $input['name'];


			$addacc = "INSERT INTO {$table_prefix}accounts(account_type, account_name) VALUES ('TRAFFICKER',:contactname);";
			$acc_dat = $this->db->prepare($addacc);
			$acc_dat->bindParam(":contactname", $contactname);
			$acc_dat->execute();
			$acccountid = $this->db->lastInsertId();
			$addpub = "INSERT INTO {$table_prefix}affiliates(agencyid,name,contact,email,website,updated,account_id) VALUES (:agencyid,:name,:contact,:email,:website,:updated,:acccountid);";
			$pub_det = $this->db->prepare($addpub);
			$pub_det->bindParam(":agencyid", $agencyid);
			$pub_det->bindParam(":name", $name);
			$pub_det->bindParam(":contact", $contactname);
			$pub_det->bindParam(":email", $email);
			$pub_det->bindParam(":website", $website);
			$pub_det->bindParam(":updated", $datetime);
			$pub_det->bindParam(":acccountid", $acccountid);
			$pub_det->execute();
			$publisherid = $this->db->lastInsertId();
			$response = array('response' => 'Success', 'message' => 'Publisher added successfully with affiliateid:' . $publisherid, 'status' => '200');
			return $this->response->withJson($response);
		} else {
			$response = array('response' => 'error', 'message' => 'Please Enter the Valid Agency Id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('publisheradd_val'));

/*
* PUBLISHER EDIT
* 
* Input Parameters:
* ----------------
* contactname
* email
* website
* username
* password
* name
* mode

* Arguments:
* ---------
* Publisher ID
*/


$app->post('/edit_publisher/[{publisherid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$input 			= $request->getParsedBody();
		$table_prefix	= $this->get('settings')['path']['table_prefix'];
		$name 			= (isset($input['name'])) ? $input['name'] : '';
		$contactname	= (isset($input['contact'])) ? $input['contact'] : '';
		$email			= (isset($input['email'])) ? $input['email'] : '';
		$website		= (isset($input['website'])) ? $input['website'] : '';
		$username		= (isset($input['username'])) ? $input['username'] : '';
		$datetime 		= date('Y-m-d H:i:s');
		$publisherid = $args['publisherid'];
		$results = array();

		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = ['response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404'];
			return $this->response->withJson($response);
			exit;
		}

		$getpublisher = "SELECT * FROM {$table_prefix}affiliates where affiliateid =:affiliateid";

		$pub_edit = $this->db->prepare($getpublisher);
		$pub_edit->bindParam(":affiliateid", $publisherid);
		$pub_edit->execute();
		$stmt = $pub_edit->fetchAll();

		if (count($stmt) > 0) {
			if (isset($input['email'])) {
				$email = $input['email'];
				if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
					$results = array('response' => 'error', 'ERROR' => 'Invalid email format');
					return $this->response->withJson($results);
				}
			} else {
				$email = $stmt[0]['email'];
			}

			if (isset($input['website'])) {
				$website = $input['website'];
			}
			$accounts = "update {$table_prefix}accounts set  account_name=:account_name where  account_id=:account_id";
			$acc_dat = $this->db->prepare($accounts);
			$acc_dat->bindParam(":account_name", $name);
			$acc_dat->bindParam(":account_id", $stmt[0]['account_id']);
			$acc_dat->execute();

			$update_pub = "update {$table_prefix}affiliates set  name=:name,contact=:contact,website=:website,email=:email,updated=:updated where account_id=:account_id";
			$pub_query = $this->db->prepare($update_pub);
			$pub_query->bindParam(":name", $name);
			$pub_query->bindParam(":contact", $contactname);
			$pub_query->bindParam(":website", $website);
			$pub_query->bindParam(":email", $email);
			$pub_query->bindParam(":updated", $datetime);
			$pub_query->bindParam(":account_id", $stmt[0]['account_id']);
			$pub_query->execute();
			$results = array('response' => 'Success', 'message' => 'Publisher details has been updated successfully!', 'status' => '200');
			return $this->response->withJson($results);
		} else {
			$response = array('response' => 'error', 'message' => 'Please enter the valid Publisher id!', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('pubid_edit'));

/*
 * Publisher Delete
 * 
 * Input Parameters:
 * --------------- 
 * Nil
 * 
 * Arguments:
 * ---------
 * Account ID
 */

$app->delete('/delete_publisher/[{accountid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$accountid = $args['accountid'];
		$publisher = "select * from {$table_prefix}affiliates where affiliateid=:account_id";
		$pub_data = $this->db->prepare($publisher);

		$pub_data->bindParam(":account_id", $accountid);
		$pub_data->execute();
		$stmtpub = $pub_data->fetchAll();

		if (count($stmtpub) > 0) {
			$deleteacc = "DELETE FROM {$table_prefix}accounts WHERE account_id=:account_id";
			$del_acc = $this->db->prepare($deleteacc);
			$del_acc->bindParam(":account_id", $accountid);
			$del_acc->execute();


			$deletepub = "DELETE FROM {$table_prefix}affiliates WHERE affiliateid=:account_id";
			$del_data = $this->db->prepare($deletepub);
			$del_data->bindParam(":account_id", $accountid);
			$del_data->execute();


			$deleteusers = "DELETE FROM {$table_prefix}users WHERE default_account_id=:default_account_id";
			$djax_query_deleteuser = $this->db->prepare($deleteusers);
			$djax_query_deleteuser->bindParam(":default_account_id", $accountid);
			$djax_query_deleteuser->execute();


			$deleteuserassoc = "DELETE FROM {$table_prefix}account_user_assoc WHERE account_id=:account_id";
			$del_assoc = $this->db->prepare($deleteuserassoc);
			$del_assoc->bindParam(":account_id", $accountid);
			$del_assoc->execute();


			$deletepermission = "DELETE FROM {$table_prefix}account_user_permission_assoc WHERE account_id=:account_id";
			$del_user_permission = $this->db->prepare($deletepermission);
			$del_user_permission->bindParam(":account_id", $accountid);
			$del_user_permission->execute();

			$response = array('response' => 'Success', 'message' => 'Publisher has been deleted successfully', 'status' => '200');
			return $this->response->withJson($response);
		} else {

			$response = array('response' => 'Error', 'message' => 'Please enter the valid publisherid', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('accountid_val'));


/*
 * Get Publisher details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Affiliate ID
 */

$app->get('/getpublisherdetails/[{affiliateid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$affiliateid = $args['affiliateid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherdetails = "SELECT * FROM {$table_prefix}affiliates where affiliateid = :affiliateid";

		$get_details = $this->db->prepare($publisherdetails);
		$get_details->bindParam(":affiliateid", $affiliateid);
		$get_details->execute();
		$publisher = $get_details->fetchAll();
		$publisherdetail = array();

		if (count($publisher) > 0) {
			$publisherdetail = [
				'affiliateid' => $affiliateid,
				'name' => $publisher[0]['name'],
				'contact' => $publisher[0]['contact'],
				'email' => $publisher[0]['email'],
				'website' => $publisher[0]['website']
			];
			$data['data'] = $publisherdetail;
			$data['response'] = "success";
			$data['message'] = "Publisher single data list";
			$data['status'] = "200";
			return $this->response->withJson($data);
		} else {
			$response = array(
				'response' => 'error',
				'message' => 'Please Enter the Valid Publisher Id!',
				'status' => '404'
			);

			return $this->response->withJson($response);
		}
	}
})->add($container->get('affid_val'));

/*
 * Get All Publisher details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Agency ID
 */

$app->get('/getallpublisher/[{agencyid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$agencyid = $args['agencyid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$agencyid_det = "select agencyid from " . $table_prefix . "agency where agencyid=" . $agencyid;
		$agencyid_tab = $this->db->prepare($agencyid_det);
		$agencyid_tab->execute();
		$check = $agencyid_tab->fetch();
		if ($check > 0) {

			$allpublisher = "SELECT * FROM {$table_prefix}affiliates AS t1 where t1.agencyid =:agencyid";

			$get_all_pub = $this->db->prepare($allpublisher);
			$get_all_pub->bindParam(":agencyid", $agencyid);
			$get_all_pub->execute();
			$stmtpublisher = $get_all_pub->fetchAll();
			$num = count($stmtpublisher);
			$publisherdetails = array();

			if ($num > 0) {
				foreach ($stmtpublisher as $publisher) {
					$publisherdetails[] = array(
						'agencyid' => $agencyid,
						'account_id' => $publisher['account_id'],
						'affiliateid' => $publisher['affiliateid'],
						'name' => $publisher['name'],
						'contact' => $publisher['contact'],
						'email' => $publisher['email'],
						'website' => $publisher['website']
					);
				}
				$data['data'] = $publisherdetails;
				$data['response'] = "success";
				$data['message'] = "Publisher list";
				$data['status'] = "200";
				return $this->response->withJson($data);
			} else {
				$response = array(
					'response' => 'error',
					'message' => 'No publisher availabe under the provided Agency!',
					'status' => '204'
				);
			}

			return $response;
		} else {
			$response = array('response' => 'error', 'message' => 'Please Enter the Valid Agency id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('agencyid_val'));



/********************************Publisher End*******************************/

/********************************Zone Add***********************************/
/*
 * ZONE ADD
 * 
 * Input Parameters:
 * ----------------
 * zonename
 * description
 * delivery
 * category
 * width
 * height
 * 
 * Arguments:
 * ---------
 * Publisher ID
 */

$app->post('/add_zone/[{publisherid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$publisherid = $args['publisherid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();

		$zonename = $input['zonename'];
		$description = $input['description'];
		$delivery = $input['delivery'];
		$category = $input['category'];
		$comments = $input['comments'];
		if ($delivery != 0) {
			$validdelivery = array("0", "1", "4", "6", "7", "3");
			if (!in_array($delivery, $validdelivery) || $delivery == -0) {

				$response = array('response' => 'error', 'message' => 'Please insert valid delivery field');
				return $this->response->withJson($response);
			}
		}
		if ($delivery == 0 || $delivery == 1 || $delivery == 4) {
			$width = $input['width'];
			$height = $input['height'];
			if (empty($width) || empty($height)) {
				$response = array('response' => 'error', 'message' => 'Please enter width and height');
				return $this->response->withJson($response);
				return $response;
			}
		} elseif ($delivery == 6) {
			$width = -3;
			$height = -3;
		} else if ($delivery == 7) {
			$width = -2;
			$height = -2;
		} else if ($delivery == 8) {
			$width = -5;
			$height = -5;
		} else if ($delivery == 3) {
			$width = 0;
			$height = 0;
		}



		$allpublisher = "SELECT affiliateid FROM {$table_prefix}affiliates where 
		affiliateid = :affiliateid";

		$get_all_pub = $this->db->prepare($allpublisher);
		$get_all_pub->bindParam(":affiliateid", $publisherid);
		$get_all_pub->execute();
		$stmtpublisher = $get_all_pub->fetch();
		$num = $stmtpublisher;
		$publisherdetails = array();

		if ($num > 0) {
			$addzones = "INSERT INTO {$table_prefix}zones(zonename,zonetype,description,delivery,category,width,height,affiliateid,comments,updated) VALUES (:zonename,3,:description,:delivery,:category,:width,:height,:affiliateid,:comments,now());";

			$djax_query_zone = $this->db->prepare($addzones);
			$djax_query_zone->bindParam(":zonename", $zonename);
			$djax_query_zone->bindParam(":description", $description);
			$djax_query_zone->bindParam(":delivery", $delivery);
			$djax_query_zone->bindParam(":category", $category);
			$djax_query_zone->bindParam(":width", $width);
			$djax_query_zone->bindParam(":height", $height);
			$djax_query_zone->bindParam(":comments", $comments);
			$djax_query_zone->bindParam(":affiliateid", $publisherid);
			$djax_query_zone->execute();
			$zoneid = $this->db->lastInsertId();
			if ($zoneid) {
				$response = array(
					'response' => 'Success',
					'message' => 'Zone added successfully with zoneid:' . $zoneid,
					'status' => '200'
				);
			}
		} else {
			$response = array(
				'response' => 'error',
				'message' => 'Please Enter the Valid Publisher Id',
				'status' => '404'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('zone_val'));

/*
 * ZONE EDIT
 * 
 * Input Parameters:
 * ----------------
 * zonename
 * description
 * delivery
 * category
 * width
 * height
 * mode
 * 
 * Arguments:
 * ---------
 * Zone ID
 */

$app->post('/edit_zone/[{zoneid}]', function ($request, $response, $args) {


	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$getzone = "select zoneid from {$table_prefix}zones where zoneid=:zoneid";
		$zonedata = $this->db->prepare($getzone);
		$zonedata->bindParam(":zoneid", $zoneid);
		$zonedata->execute();
		$stmt = $zonedata->fetch();
		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = ['response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404'];
			return $this->response->withJson($response);
			exit;
		}

		if (isset($input['zonename'])) {
			$zonename = $input['zonename'];
		} else {
			$zonename = $stmt[0]['zonename'];
		}
		if (isset($input['description'])) {
			$description = $input['description'];
		} else {
			$description = $stmt[0]['description'];
		}

		if (isset($input['category'])) {
			$category = $input['category'];
		} else {
			$category = $stmt[0]['category'];
		}
		if (isset($input['comments'])) {
			$comments = $input['comments'];
		} else {
			$comments = $stmt[0]['comments'];
		}
		if (isset($input['delivery'])) {

			$delivery = $input['delivery'];
			if ($delivery != 0) {
				$validdelivery = array("0", "1", "4", "6", "7", "3");
				if (!in_array($delivery, $validdelivery) || $delivery == -0) {
					$response = array('response' => 'error', 'message' => 'Please insert valid delivery field');
					return $this->response->withJson($response);
				}
			}
			if ($delivery == 0 || $delivery == 1 || $delivery == 4) {
				$width = $input['width'];
				$height = $input['height'];
				if (empty($width) || empty($height)) {
					$results = json_encode(array('ERROR' => 'Please enter width and height'));
					return $results;
				}
			} else if ($delivery == 6) {
				$width = -3;
				$height = -3;
			} else if ($delivery == 7) {
				$width = -2;
				$height = -2;
			} else if ($delivery == 8) {
				$width = -5;
				$height = -5;
			} else {
				$width = 0;
				$height = 0;
			}
		} else {

			$delivery = $stmt[0]['delivery'];

			if ($input['width']) {
				$width = $input['width'];
			} else {
				$width = $stmt[0]['width'];
			}

			if ($input['height']) {
				$height = $input['height'];
			} else {
				$height = $stmt[0]['height'];
			}
		}


		if ($stmt > 0) {

			$addzones = "update  {$table_prefix}zones setzonename=:zonename,description=:description,delivery=:delivery,category=:category,width=:width,height=:height,comments=:comments where zoneid=:zoneid;";


			$zone_data = $this->db->prepare($addzones);
			$zone_data->bindParam(":zonename", $zonename);
			$zone_data->bindParam(":description", $description);
			$zone_data->bindParam(":delivery", $delivery);
			$zone_data->bindParam(":category", $category);
			$zone_data->bindParam(":width", $width);
			$zone_data->bindParam(":height", $height);
			$zone_data->bindParam(":zoneid", $zoneid);
			$zone_data->bindParam(":comments", $comments);

			$zone_data->execute();


			$response = array(
				'response' => 'Success',
				'message' => 'zone details has been updated successfully',
				'status' => '200'
			);
		} else {
			$response = array(
				'response' => 'error',
				'message' => 'Please Enter the Valid Zone id',
				'status' => '404'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('zoneid_edit'));

/*
 * Zone Delete
 * 
 * Input Parameters:
 * --------------- 
 * Nil
 * 
 * Arguments:
 * ---------
 * Zone ID
 */

$app->delete('/delete_zone/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$referzone = "select zoneid from {$table_prefix}zones where zoneid=:zoneid";
		$djax_query_referzones = $this->db->prepare($referzone);
		$djax_query_referzones->bindParam(":zoneid", $zoneid);
		$djax_query_referzones->execute();
		$stmtzone = $djax_query_referzones->fetch();


		if ($stmtzone > 0) {

			$deleteaccounts = "DELETE FROM {$table_prefix}zones WHERE zoneid=:zoneid";
			$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
			$djax_query_deleteaccount->bindParam(":zoneid", $zoneid);
			$djax_query_deleteaccount->execute();

			$response = array(
				'response' => 'Success',
				'message' => 'Zone has been deleted successfully!',
				'status' => '200'
			);
		} else {

			$response = array(
				'response' => 'Error',
				'message' => 'Please Enter the valid Zone Id',
				'status' => '404'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('zoneid_val'));

/*
 * Get Zone details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Zone ID
 */

$app->get('/get_zone/[{zoneid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();

		$zonedetails = "SELECT * from {$table_prefix}zones where zoneid=:zoneid";
		$djax_query_zonedetail = $this->db->prepare($zonedetails);
		$djax_query_zonedetail->bindParam(":zoneid", $zoneid);
		$djax_query_zonedetail->execute();
		$stmtzone = $djax_query_zonedetail->fetchAll();

		$zonedetail = array();

		if (count($stmtzone) > 0) {

			$zonedetail = array(
				'affiliateid' => $stmtzone[0]['affiliateid'],
				'zoneid' => $stmtzone[0]['zoneid'],
				'zonename' => $stmtzone[0]['zonename'],
				'description' => $stmtzone[0]['description'],
				'delivery' => $stmtzone[0]['delivery'],
				'width' => $stmtzone[0]['width'],
				'height' => $stmtzone[0]['height']
			);
			$data['data'] = $zonedetail;
			$data['response'] = "success";
			$data['message'] = "Zone single data list";
			$data['status'] = "200";
			return $this->response->withJson($data);
		} else {

			$response = array(
				'response' => 'Error',
				'message' => 'Please Enter the Valid Zone Id',
				'status' => '404'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('get_zone_val'));

/*
 * Get All Zone details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Publisher ID
 */

$app->get('/get_all_zone/[{publisherid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$publisherid = $args['publisherid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$allzone = "SELECT * FROM {$table_prefix}zones where affiliateid=:affiliateid";
		$djax_query_allzones = $this->db->prepare($allzone);
		$djax_query_allzones->bindParam(":affiliateid", $publisherid);
		$djax_query_allzones->execute();
		$stmtzone = $djax_query_allzones->fetchAll();
		$num = count($stmtzone);
		$zonedetails = array();
		if ($num > 0) {
			foreach ($stmtzone as $zone) {
				$zonedetails[] = array(
					'affiliateid' => $publisherid,
					'zonename' => $zone['zonename'],
					'description' => $zone['description'],
					'delivery' => $zone['delivery'],
					'width' => $zone['width'],
					'height' => $zone['height']
				);
			}
			$data['data'] = $zonedetails;
			$data['response'] = "success";
			$data['message'] = "Zone list";
			$data['status'] = "200";
			return $this->response->withJson($data);
		} else {
			$response = array(
				'response' => 'Error',
				'message' => 'Invalid Publisher Id!',
				'status' => '404'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('pubid_val'));

//~ /************************Zone *******************/

//~ /************************User *******************/
/*
 *  USER ADD
 * 
 * Input Parameters:
 * --------------- 
 * contactname
 * email
 * username
 * password
 * 
 * Arguments:
 * ---------
 * Account ID
 */


$app->post('/add_user/[{accountid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$accountid = $args['accountid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$server = $this->get('settings')['path']['server'];
		$djprotocol = $this->get('settings')['path']['protocol'];
		$input    = $request->getParsedBody();

		$email = $input['email'];
		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			$results = array('response' => 'error', 'ERROR' => 'Invalid email format');
			return $this->response->withJson($results);
		}
		$contactname = $input['contactname'];
		$username = $input['username'];


		if (empty($contactname) && empty($email) && empty($username)) {
			$response = array('Error' => 'Please enter all required data', 'status' => '404');

			return $this->response->withJson($response);
		}
		$usercount = strlen($username);
		if ($usercount <= 4) {
			$response = array('error' => 'username length should be greater than or equal to five','status' => '404');

			return $this->response->withJson($response);
		}

		$check_user = "Select username from {$table_prefix}users where username = :username ;";
		$user_det = $this->db->prepare($check_user);
		$user_det->bindParam(":username", $username);
		$user_det->execute();
		$user_data = $user_det->fetch();

		if ($user_data) {
			$response = array('response' => 'error', 'message' => 'Username already exists','status' => '404');
			return $this->response->withJson($response);
		}


		$account_data = "SELECT * from {$table_prefix}accounts where account_id=:accountid";
		$account_details = $this->db->prepare($account_data);
		$account_details->bindParam(":accountid", $accountid);
		$account_details->execute();
		$accounts = $account_details->fetchAll();

		if ($accounts) {
			$adduser = "INSERT INTO {$table_prefix}users(contact_name, email_address, username,default_account_id,active,date_created,email_updated) 
				VALUES (:contactname,:email,:username,:accountid,1,:datetime,:email_updated);";
			$users = $this->db->prepare($adduser);
			$users->bindParam(":contactname", $contactname);
			$users->bindParam(":email", $email);
			$users->bindParam(":username", $username);

			$users->bindParam(":accountid", $accountid);
			$users->bindParam(":datetime", $datetime);
			$users->bindParam(":email_updated", $datetime);
			$users->execute();

			$userid = $this->db->lastInsertId();


			$user_perm = "INSERT INTO {$table_prefix}account_user_assoc(account_id,user_id,linked) VALUES (:accountid,:userid,:datetime);";

			$user_dat_perm = $this->db->prepare($user_perm);
			$user_dat_perm->bindParam(":accountid", $accountid);
			$user_dat_perm->bindParam(":userid", $userid);
			$user_dat_perm->bindParam(":datetime", $datetime);
			$user_dat_perm->execute();

			$user_assoc = "INSERT INTO {$table_prefix}account_user_permission_assoc(account_id, user_id, permission_id, is_allowed) VALUES
	(:accountid,:userid,10,1),
	(:accountid,:userid,4,1),
	(:accountid,:userid,2,1),
	(:accountid,:userid,1,1),
	(:accountid,:userid,11,1),
	(:accountid,:userid,5,1),
	(:accountid,:userid,6,1),
	(:accountid,:userid,8,1),
	(:accountid,:userid,9,1),
	(:accountid,:userid,7,1),
	(:accountid,:userid,12,1);";


			$user_assoc_details = $this->db->prepare($user_assoc);
			$user_assoc_details->bindParam(":accountid", $accountid);
			$user_assoc_details->bindParam(":userid", $userid);
			$user_assoc_details->execute();

			$account_type = "SELECT account_type FROM  " . $table_prefix . "accounts as act, " . $table_prefix . "users as u
								 where u.default_account_id = act.account_id AND u.user_id=$userid";

			$account_type_details = $this->db->prepare($account_type);
			$account_type_details->execute();
			$account_type_details = $account_type_details->fetchAll();
			$account_type_details = $account_type_details[0]['account_type'];


			if ($account_type_details == "MANAGER") {
				$adminid = "SELECT email_address FROM " . $table_prefix . "users WHERE user_id='1' ";
				$user_details = $this->db->prepare($adminid);
				$user_details->execute();
				$fromusers = $user_details->fetchAll();

				$username = "select * from  " . $table_prefix . "users order by user_id DESC LIMIT 1";
				$username = $this->db->prepare($username);
				$username->execute();
				$username1 = $username->fetchAll();


				$recoveryId = strtoupper(bin2hex(random_bytes(12)));
				$recoveryId = substr(chunk_split($recoveryId, 8, "-"), 0, -1);

				$user_type = "user";
				$user_recovery = "INSERT INTO {$table_prefix}password_recovery(user_type, user_id, recovery_id, updated)
									VALUES ('" . $user_type . "','" . $userid . "','" . $recoveryId . "','" . $datetime . "')";
				$user_dat_recovery = $this->db->prepare($user_recovery);
				$user_dat_recovery->execute();

				$pieces = explode("/", $_SERVER['REQUEST_URI']);
				$recoveryUrl = ($djprotocol . $server . "/" . $pieces[1] . "/www/admin/password-recovery.php?id={$recoveryId}");

				$to = $email;
				$subject = 'Set up your password';
				$headers = "MIME-Version: 1.0\r\n";
				$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
				$headers .= 'From: ' . $fromusers[0]['email_address'] . "\r\n";
				$message = '<html><style type="text/css">strong {background: #eee;}</style><body>';
				$message .= '<table width="70%" style="border-color: rgb(102, 102, 102); background: none repeat scroll 0% 0% rgb(226, 226, 226);"  cellspacing="10" cellpadding="10" >';
				$message .= "<tr><td>Dear " . $username1[0]['username'] . ",</td></tr>";
				$message .= "<tr><td>Your username is  " . $username1[0]['username'] . "  </td></tr>";
				$message .= "<tr><td>To set your password, please click the following link: </td></tr>";
				$message .= "<tr><td><a href='$recoveryUrl' title='Manager Login'>'$recoveryUrl'</a></td></tr><br>";
				$message .= "<tr><td>Please make sure to enter a safe and unique password.</td></tr><br>";
				$message .= '<tr><td style="margin:50px;line-height:1;width:650px; word-spacing:2px;font-size:15px;color:#14773A; ">Regards,  <br/><b>Administrator</b></td></tr>';
				$message .= "</body></html>";
				$message .= "</table>";

				mail($to, $subject, $message, $headers);
			} elseif ($account_type_details == "ADVERTISER") {

				$adminid = "SELECT email_address FROM " . $table_prefix . "users WHERE user_id='1' ";
				$user_details = $this->db->prepare($adminid);
				$user_details->execute();
				$fromusers = $user_details->fetchAll();

				$username = "select * from  " . $table_prefix . "users order by user_id DESC LIMIT 1";
				$username = $this->db->prepare($username);
				$username->execute();
				$username1 = $username->fetchAll();

				$recoveryId = strtoupper(bin2hex(random_bytes(12)));
				$recoveryId = substr(chunk_split($recoveryId, 8, "-"), 0, -1);

				$user_type = "user";
				$user_recovery = "INSERT INTO {$table_prefix}password_recovery(user_type, user_id, recovery_id, updated)
									  VALUES ('" . $user_type . "','" . $userid . "','" . $recoveryId . "','" . $datetime . "')";
				$user_dat_recovery = $this->db->prepare($user_recovery);
				$user_dat_recovery->execute();

				$pieces = explode("/", $_SERVER['REQUEST_URI']);
				$recoveryUrl = ($djprotocol . $server . "/" . $pieces[1] . "/www/admin/password-recovery.php?id={$recoveryId}");

				$to = $email;
				$subject = 'Set up your password';
				$headers = "MIME-Version: 1.0\r\n";
				$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
				$headers .= 'From: ' . $fromusers[0]['email_address'] . "\r\n";
				$message = '<html><style type="text/css">strong {background: #eee;}</style><body>';
				$message .= '<table width="70%" style="border-color: rgb(102, 102, 102); background: none repeat scroll 0% 0% rgb(226, 226, 226);"  cellspacing="10" cellpadding="10" >';
				$message .= "<tr><td>Dear " . $username1[0]['username'] . ",</td></tr>";
				$message .= "<tr><td>Your username is  " . $username1[0]['username'] . "  </td></tr>";
				$message .= "<tr><td>To set your password, please click the following link: </td></tr>";
				$message .= "<tr><td><a href='$recoveryUrl' title='Advertiser Login'>'$recoveryUrl'</a></td></tr><br>";
				$message .= "<tr><td>Please make sure to enter a safe and unique password.</td></tr><br>";
				$message .= '<tr><td style="margin:50px;line-height:1;width:650px; word-spacing:2px;font-size:15px;color:#14773A; ">Regards,  <br/><b>Administrator</b></td></tr>';
				$message .= "</body></html>";
				$message .= "</table>";

				mail($to, $subject, $message, $headers);
			} elseif ($account_type_details == "TRAFFICKER") {

				$adminid = "SELECT email_address FROM " . $table_prefix . "users WHERE user_id='1' ";
				$user_details = $this->db->prepare($adminid);
				$user_details->execute();

				$fromusers = $user_details->fetchAll();

				$username = "select * from  " . $table_prefix . "users order by user_id DESC LIMIT 1";
				$username = $this->db->prepare($username);
				$username->execute();
				$username1 = $username->fetchAll();

				$recoveryId = strtoupper(bin2hex(random_bytes(12)));
				$recoveryId = substr(chunk_split($recoveryId, 8, "-"), 0, -1);

				$user_type = "user";
				$user_recovery = "INSERT INTO {$table_prefix}password_recovery(user_type, user_id, recovery_id, updated)
									VALUES ('" . $user_type . "','" . $userid . "','" . $recoveryId . "','" . $datetime . "')";
				$user_dat_recovery = $this->db->prepare($user_recovery);
				$user_dat_recovery->execute();

				$pieces = explode("/", $_SERVER['REQUEST_URI']);
				$recoveryUrl = ($djprotocol . $server . "/" . $pieces[1] . "/www/admin/password-recovery.php?id={$recoveryId}");

				$to = $email;
				$subject = 'Set up your password';
				$headers = "MIME-Version: 1.0\r\n";
				$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
				$headers .= 'From: ' . $fromusers[0]['email_address'] . "\r\n";
				$message = '<html><style type="text/css">strong {background: #eee;}</style><body>';
				$message .= '<table width="70%" style="border-color: rgb(102, 102, 102); background: none repeat scroll 0% 0% rgb(226, 226, 226);"  cellspacing="10" cellpadding="10" >';
				$message .= "<tr><td>Dear " . $username1[0]['username'] . ",</td></tr>";
				$message .= "<tr><td>Your username is  " . $username1[0]['username'] . "  </td></tr>";
				$message .= "<tr><td>To set your password, please click the following link: </td></tr>";
				$message .= "<tr><td><a href='$recoveryUrl' title='Publisher Login'>'$recoveryUrl'</a></td></tr><br>";
				$message .= "<tr><td>Please make sure to enter a safe and unique password.</td></tr><br>";
				$message .= '<tr><td style="margin:50px;line-height:1;width:650px; word-spacing:2px;font-size:15px;color:#14773A; ">Regards,  <br/><b>Administrator</b></td></tr>';
				$message .= "</body></html>";
				$message .= "</table>";

				mail($to, $subject, $message, $headers);
			}

			$response = array(
				'response' => 'Success',
				'message' => 'user has been added successfully with id:' . $userid,
				'status' => '200'

			);

			return $this->response->withJson($response);
		} else {
			$response = array(
				'response' => 'Error',
				'message' => 'Please Enter the Valid Account Id',
				'status' => '404'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('user_val'));




/*
 * User Delete
 * 
 * Input Parameters:
 * --------------- 
 * Nil
 * 
 * Arguments:
 * ---------
 * User ID
 */

$app->delete('/delete_user/[{userid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$userid = $args['userid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();

		$user_details = "SELECT user_id from {$table_prefix}users where user_id=:userid";
		$get_userdet = $this->db->prepare($user_details);
		$get_userdet->bindParam(":userid", $userid);
		$get_userdet->execute();
		$stmtuser = $get_userdet->fetch();
		if ($stmtuser) {


			$delete_user = "DELETE FROM {$table_prefix}users WHERE user_id=:userid";
			$del_user = $this->db->prepare($delete_user);
			$del_user->bindParam(":userid", $userid);
			$del_user->execute();


			$user_assoc = "DELETE FROM {$table_prefix}account_user_assoc WHERE user_id=:userid";
			$delete_assoc = $this->db->prepare($user_assoc);
			$delete_assoc->bindParam(":userid", $userid);
			$delete_assoc->execute();


			$rem_permission = "DELETE FROM {$table_prefix}account_user_permission_assoc WHERE user_id=:userid";
			$user_permission = $this->db->prepare($rem_permission);
			$user_permission->bindParam(":userid", $userid);
			$user_permission->execute();
			$response = array(
				'response' => 'Success',
				'message' => 'User has been deleted successfully!',
				'status' => '200'
			);
			return $this->response->withJson($response);
		} else {
			$response = array(
				'response' => 'Error',
				'message' => 'Please Enter the Valid User id',
				'status' => '404'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('userid_val'));

/*
 * Get User details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * User ID
 */

$app->get('/get_user/[{userid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$userid = $args['userid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();

		$userdet = "select * from {$table_prefix}users where user_id=:userid";
		$userdetail = $this->db->prepare($userdet);
		$userdetail->bindParam(":userid", $userid);
		$userdetail->execute();
		$stmtuser = $userdetail->fetchAll();

		$usrdetail = array();

		if (count($stmtuser) > 0) {

			$usrdetail = array(
				'userid' => $userid,
				'username' => $stmtuser[0]['username'],
				'contact_name' => $stmtuser[0]['contact_name'],
				'email_address' => $stmtuser[0]['email_address'],
				'password' => $stmtuser[0]['password']
			);
			$data['data'] = $usrdetail;
			$data['response'] = "success";
			$data['message'] = "User single data list";
			$data['status'] = "200";
			return $this->response->withJson($data);
		} else {
			$response = array('response' => 'error', 'message' => 'Please Enter the Valid User id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('userid_val'));


/*
 * Get All User details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Account ID
 */


$app->get('/get_all_user/[{accountid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$accountid = $args['accountid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$alluserdet = "select * from {$table_prefix}users where default_account_id=:accountid";
		$userdetail = $this->db->prepare($alluserdet);
		$userdetail->bindParam(":accountid", $accountid);
		$userdetail->execute();
		$stmtusers = $userdetail->fetchAll();
		$userdetails = array();


		if (count($stmtusers) > 0) {

			foreach ($stmtusers as $alluser) {
				$userdetails[] = array(
					'accountid' => $accountid,
					'userid' => $alluser['user_id'],
					'username' => $alluser['username'],
					'username' => $alluser['username'],
					'contact_name' => $alluser['contact_name'],
					'email_address' => $alluser['email_address'],
					'password' => $alluser['password']
				);
			}
			$data['data'] = $userdetails;
			$data['response'] = "success";
			$data['message'] = "Users list";
			$data['status'] = "200";
			$this->response->withJson($data);
		} else {
			$response = array('response' => 'error', 'message' => 'Please Enter the Valid account Id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('accountid_val'));





/***********************************************************************/

/*************************** Linked Ad by zone ********************************************/
/*
 * Linked Ad by zone
 * 
 * Input Parameters:
 * --------------- 
 * Banner ID
 * 
 * Arguments:
 * ---------
 * Zone ID
 */

$app->post('/adbyzone_link/[{zoneid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);

		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$id = $input['bannerid'];
		$getbannerid = explode(',', $id);


		$zoneval = "select * from {$table_prefix}zones where zoneid=:zoneid";
		$zonedet = $this->db->prepare($zoneval);
		$zonedet->bindParam(":zoneid", $zoneid);
		$zonedet->execute();
		$stmtzonevalue = $zonedet->fetchAll();
		if (!$stmtzonevalue) {
			$response = array('response' => 'error', 'message' => 'Please provide valid zoneid!');
			return $this->response->withJson($response);
		}


		$bannerval = "select bannerid from {$table_prefix}banners where bannerid=:banner_id";
		$bannerdet = $this->db->prepare($bannerval);
		$bannerdet->bindParam(":banner_id", $id);
		$bannerdet->execute();
		$stmtbannervalue = $bannerdet->fetch();
		if (!$stmtbannervalue) {
			$response = array('response' => 'error', 'message' => 'Please provide valid Bannerid!');
			return $this->response->withJson($response);
		}


		$zonenum = count($stmtzonevalue);

		foreach ($getbannerid as $bannerid) {
			$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
			$get_banner_det = $this->db->prepare($bannerval);
			$get_banner_det->bindParam(":bannerid", $bannerid);
			$get_banner_det->execute();
			$stmtbannervalue = $get_banner_det->fetchAll();
			$bannernum = count($stmtbannervalue);


			//validation for zone and banner
			if (!$stmtbannervalue) {
				$response = array('response' => 'error', 'message' => 'Please provide valid Bannerid!', 'status' => '404');
				return $this->response->withJson($response);
			}


			foreach ($stmtbannervalue as $bannervalue) {

				$width = $bannervalue['width'];
				$height = $bannervalue['height'];
				$bannertype = $bannervalue['storagetype'];
				$exttype = $bannervalue['ext_bannertype'];
			}

			$zonewidth = $stmtzonevalue[0]['width'];
			$zoneheight = $stmtzonevalue[0]['height'];
			$zonetype = $stmtzonevalue[0]['delivery'];

			//type validation
			if (
				(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 0) ||
				(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 1) ||
				($bannertype == 'txt' && $zonetype == 3) ||
				(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 4) ||

				(($bannertype == 'html' &&
					$exttype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml') && $zonetype == 6) ||
				(($bannertype == 'html' &&
					$exttype == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml') &&  $zonetype == 7) ||
				(($bannertype == 'html' &&
					$exttype == 'bannerTypeHtml:oxHtml:genericHtml')
					&&  ($zonetype == 7 || $zonetype == 0 || $zonetype == 0 || $zonetype == 4))
			) {

				//validation for width and height
				if ($width == $zonewidth && $height == $zoneheight) {

					$adzoneassoc = "INSERT INTO {$table_prefix}ad_zone_assoc(zone_id,ad_id,
										priority, link_type,priority_factor,to_be_delivered) 
										VALUES (:zoneid, :bannerid,0,1,1,1);";

					$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
					$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
					$djax_query_adzoneassoc->bindParam(":bannerid", $bannerid);
					$djax_query_adzoneassoc->execute();

					$response = array(
						'response' => 'Success',
						'message' => 'Banners linked successfully to the zoneid!',
						'status' => '200'
					);
				} else {

					$response = array('response' => 'error', 'message' => 'Width and height doesnot match for banner and zone', 'status' => '404');
				}
			} else {

				$response = array('response' => 'error', 'message' => 'Type doesnot match for banner and zone', 'status' => '404');
			}
		}
		return $this->response->withJson($response);
	}
})->add($container->get('az_link'));

/***************************Linked Ad campaign by zone ********************************************/


/*****************************************************************************************/
/*
 * Linked Ad campaign by zone 
 * 
 * Input Parameters:
 * --------------- 
 * Campaign ID
 * 
 * Arguments:
 * ---------
 * Zone ID
 */

$app->post('/campaignbyzone_link/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$id = $input['campaignid'];
		$getid = explode(',', $id);

		$zonevalue = "select * from {$table_prefix}zones where zoneid=:zoneid";
		$djax_query_zonevalue = $this->db->prepare($zonevalue);
		$djax_query_zonevalue->bindParam(":zoneid", $zoneid);
		$djax_query_zonevalue->execute();

		$stmtzonevalue = $djax_query_zonevalue->fetchAll();
		$zonenum = count($stmtzonevalue);

		if ($stmtzonevalue) {

			foreach ($getid as $campaignid) {
				//get banners
				$campaignvalue = "select * from {$table_prefix}campaigns where campaignid=:campaignid";
				$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
				$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
				$djax_query_campaignvalue->execute();

				$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();

				$num = count($stmtcampaignvalue);

				$bannerval = "select * from {$table_prefix}banners where campaignid=:campaignid";
				$get_banner_det = $this->db->prepare($bannerval);
				$get_banner_det->bindParam(":campaignid", $campaignid);
				$get_banner_det->execute();
				$stmtbannervalue = $get_banner_det->fetchAll();
				$bannernum = count($stmtbannervalue);

				$zonewidth = $stmtzonevalue[0]['width'];
				$zoneheight = $stmtzonevalue[0]['height'];
				$zonetype = $stmtzonevalue[0]['delivery'];
				//banner validation
				if (empty($num)) {

					$response = array(
						'response' => 'Error',
						'message' => 'There is no campaign or banner exists under this requested id!',
						'status' => '404'
					);
					return $this->response->withJson($response);
				}

				foreach ($stmtbannervalue as $campaignvalue) {

					$bannerid = $campaignvalue['bannerid'];
					$width = $campaignvalue['width'];
					$height = $campaignvalue['height'];
					$bannertype = $campaignvalue['storagetype'];
					$exttype = $campaignvalue['ext_bannertype'];

					if (
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 0) ||
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 1) ||
						($bannertype == 'txt' && $zonetype == 3) ||
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 4) ||

						(($bannertype == 'html' &&  $exttype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml')
							&& $zonetype == 6) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml')
							&&  $zonetype == 7) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:oxHtml:genericHtml') &&  ($zonetype == 7
							|| $zonetype == 0 || $zonetype == 0 || $zonetype == 4))
					) {

						if ($width == $zonewidth  && $height == $zoneheight) {
							$placementcampaign = "insert 
						into {$table_prefix}placement_zone_assoc(zone_id,placement_id)
						values(:zoneid,:placement_id) ";
							$djax_query_placementcampaign = $this->db->prepare($placementcampaign);
							$djax_query_placementcampaign->bindParam(":zoneid", $zoneid);
							$djax_query_placementcampaign->bindParam(":placement_id", $campaignid);
							$djax_query_placementcampaign->execute();

							$adzoneassoc = "insert into {$table_prefix}ad_zone_assoc
						(zone_id,ad_id,priority,link_type,priority_factor,to_be_delivered)
						 VALUES (:zoneid, :bannerid,0,1,1,1)";

							$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
							$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
							$djax_query_adzoneassoc->bindParam(":bannerid", $bannerid);
							$djax_query_adzoneassoc->execute();

							$response = array(
								'response' => 'Success',
								'message' => 'Campaigns linked successfully to the zoneid!',
								'status' => '200'
							);
						} else {
							$response = array(
								'response' => 'Error',
								'message' => 'Width and height doesnot match for banner and zone',
								'status' => '404'
							);
						}
					} else {
						$response = array(
							'response' => 'Error',
							'message' => 'Type doesnot match for banner and zone',
							'status' => '404'
						);
					}
				}
			}
			return $this->response->withJson($response);
		} else {
			$response = array(
				'response' => 'Error',
				'message' => 'There is no zone exists under this requested id!',
				'status' => '404'
			);
			return $this->response->withJson($response);
		}
	}
})->add($container->get('cz_link'));

/***************************Linked Ad zone by banner ********************************************/


/*****************************************************************************************/
/*
 * Linked Ad zone by banner
 * 
 * Input Parameters:
 * --------------- 
 * Zone ID
 * 
 * Arguments:
 * ---------
 * Banner ID
 */

$app->post('/zonebyad_link/[{bannerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$bannerid = $args['bannerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$id = $input['zoneid'];
		$getid = explode(',', $id);

		$banner_data = "select bannerid from {$table_prefix}banners where bannerid=:bannerid";
		$banner_data = $this->db->prepare($banner_data);
		$banner_data->bindParam(":bannerid", $bannerid);
		$banner_data->execute();

		$stmtbannervalue = $banner_data->fetch();

		$bannercount = count($stmtbannervalue);

		if ($stmtbannervalue) {
			$width = $stmtbannervalue[0]['width'];
			$height = $stmtbannervalue[0]['height'];
			$bannertype = $stmtbannervalue[0]['storagetype'];
			$exttype = $stmtbannervalue[0]['ext_bannertype'];

			foreach ($getid as $zoneid) {
				$zonevalue = "SELECT * FROM {$table_prefix}zones WHERE zoneid=:zoneid";
				$zone_data = $this->db->prepare($zonevalue);
				$zone_data->bindParam(":zoneid", $zoneid);
				$zone_data->execute();
				$stmtzonevalue = $zone_data->fetchAll();
				$zonecount = count($stmtzonevalue);

				if ($stmtzonevalue) {

					$zonewidth = $stmtzonevalue[0]['width'];
					$zoneheight = $stmtzonevalue[0]['height'];
					$zonetype = $stmtzonevalue[0]['delivery'];

					if (
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 0) ||
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 1) ||
						($bannertype == 'txt' && $zonetype == 3) ||
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 4) ||

						(($bannertype == 'html' &&  $exttype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml') && $zonetype == 6) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml') &&  $zonetype == 7) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:oxHtml:genericHtml') &&  ($zonetype == 7 || $zonetype == 0 || $zonetype == 0 || $zonetype == 4))
					) {

						if ($width == $zonewidth && $height == $zoneheight) {
							$linkzone = "INSERT INTO {$table_prefix}ad_zone_assoc(zone_id,ad_id,priority,link_type,priority_factor,to_be_delivered) VALUES (:zoneid, :bannerid,0,1,1,1)";

							$linkzonebyad = $this->db->prepare($linkzone);
							$linkzonebyad->bindParam(":zoneid", $zoneid);
							$linkzonebyad->bindParam(":bannerid", $bannerid);
							$linkzonebyad->execute();

							$response = array('response' => 'Success', 'message' => "Zones linked successfully to the Bannerid!", 'status' => '404');
							//return $this->response->withJson($response);	
						} else {
							$response = array('response' => 'Error', 'message' => 'Width and height doesnot match for banner and zone', 'status' => '404');
						}
					} else {
						$response = array('response' => 'Error', 'message' => 'Type doesnot match for banner and zone', 'status' => '404');
					}
				} else {
					$response = array('response' => 'Error', 'message' => 'There is no zone available for Requested id!', 'status' => '404');
				}
			}
			return $this->response->withJson($response);
		} else {

			$response = array('Response' => 'Error', 'message' => 'Enter a valid banner id!', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('az_link'));



/***************************Linked Ad zone by campaign ********************************************/


/*****************************************************************************************/
/*
 * Linked Ad zone by campaign
 * 
 * Input Parameters:
 * --------------- 
 * Zone ID
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */
$app->post('/zonebycampaign_link/[{campaignid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$campaignid = $args['campaignid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$id = $input['zoneid'];
		$getid = explode(',', $id);

		//for validation purpose
		$validation = "SELECT campaignid FROM {$table_prefix}campaigns
					WHERE campaignid =:campaignid";

		$djax_query_validation = $this->db->prepare($validation);
		$djax_query_validation->bindParam(":campaignid", $campaignid);
		$djax_query_validation->execute();
		$stmtvalidation = $djax_query_validation->fetch();
		$valid = count($stmtvalidation);

		if ($stmtvalidation) {

			foreach ($getid as $zoneid) {
				$zonevalue = "select * from {$table_prefix}zones where zoneid=:zoneid";
				$djax_query_zonevalue = $this->db->prepare($zonevalue);
				$djax_query_zonevalue->bindParam(":zoneid", $zoneid);
				$djax_query_zonevalue->execute();

				$stmtzonevalue = $djax_query_zonevalue->fetchAll();
				$zonenum = count($stmtzonevalue);

				if (empty($zonenum)) {

					$response = array('response' => 'Error', 'message' => 'Zone not exist for requested id', 'status' => '404');
					return $this->response->withJson($response);
				}

				//to get banners under given campaign
				$campaignvalue = "select * from {$table_prefix}banners where campaignid=:campaignid";
				$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
				$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
				$djax_query_campaignvalue->execute();

				$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();

				$num = count($stmtcampaignvalue);

				//to get zonewidth and height

				if ($stmtcampaignvalue) {

					foreach ($stmtzonevalue as $zonevalue) {

						$zonewidth = $zonevalue['width'];
						$zoneheight = $zonevalue['height'];
						$zonetype = $zonevalue['delivery'];
					}

					foreach ($stmtcampaignvalue as $campaignvalue) {

						$bannerid = $campaignvalue['bannerid'];

						$bannerwidth = $campaignvalue['width'];
						$bannerheight = $campaignvalue['height'];
						$bannertype = $campaignvalue['storagetype'];
						$exttype = $campaignvalue['ext_bannertype'];

						if (
							(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 0) ||
							(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 1) ||
							($bannertype == 'txt' && $zonetype == 3) ||
							(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 4) ||

							(($bannertype == 'html' &&
								$exttype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml') && $zonetype == 6) ||
							(($bannertype == 'html' &&
								$exttype == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml') &&  $zonetype == 7) ||
							(($bannertype == 'html' &&
								$exttype == 'bannerTypeHtml:oxHtml:genericHtml') &&
								($zonetype == 7 || $zonetype == 0 || $zonetype == 0 || $zonetype == 4))
						) {
							if ($zonewidth == $bannerwidth && $zoneheight == $bannerheight) {

								$placementcampaign = "
							insert into {$table_prefix}placement_zone_assoc(zone_id,placement_id)
							values(:zoneid,:placement_id) ";
								$djax_query_placementcampaign = $this->db->prepare($placementcampaign);
								$djax_query_placementcampaign->bindParam(":zoneid", $zoneid);
								$djax_query_placementcampaign->bindParam(":placement_id", $campaignid);
								$djax_query_placementcampaign->execute();

								$adzoneassoc = "insert into {$table_prefix}ad_zone_assoc
							(zone_id,ad_id,priority,link_type,priority_factor,to_be_delivered)
							 VALUES (:zoneid, :bannerid,0,1,1,1)";
								$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
								$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
								$djax_query_adzoneassoc->bindParam(":bannerid", $bannerid);
								$djax_query_adzoneassoc->execute();

								$response = array('response' => 'Success', 'message' => 'Zones linked sucessfully', 'status' => '200');
							} else {
								$placementcampaign = "
							insert into {$table_prefix}placement_zone_assoc(zone_id,placement_id)
							values(:zoneid,:placement_id) ";
								$djax_query_placementcampaign = $this->db->prepare($placementcampaign);
								$djax_query_placementcampaign->bindParam(":zoneid", $zoneid);
								$djax_query_placementcampaign->bindParam(":placement_id", $campaignid);
								$djax_query_placementcampaign->execute();

								$response = array('response' => 'Error', 'message' => 'Zones linked sucessfully');
							}
						} else {
							$placementcampaign = "
						insert into {$table_prefix}placement_zone_assoc(zone_id,placement_id)
						values(:zoneid,:placement_id) ";
							$djax_query_placementcampaign = $this->db->prepare($placementcampaign);
							$djax_query_placementcampaign->bindParam(":zoneid", $zoneid);
							$djax_query_placementcampaign->bindParam(":placement_id", $campaignid);
							$djax_query_placementcampaign->execute();

							$response = array('response' => 'Success', 'message' => 'Zones linked sucessfully', 'status' => '200');
						}
					}
				} else {
					$placementcampaign = "
							insert into {$table_prefix}placement_zone_assoc(zone_id,placement_id)
							values(:zoneid,:placement_id) ";
					$djax_query_placementcampaign = $this->db->prepare($placementcampaign);
					$djax_query_placementcampaign->bindParam(":zoneid", $zoneid);
					$djax_query_placementcampaign->bindParam(":placement_id", $campaignid);
					$djax_query_placementcampaign->execute();

					$response = array('response' => 'Success', 'message' => 'Zones linked sucessfully', 'status' => '200');
				}
			}
			return $this->response->withJson($response);
		} else {

			$response = array('response' => 'error', 'message' => 'Please enter valid campaignid', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('cz_link'));




/***********************************************************************/

/*************************** Unlinked Ad by zone ********************************************/
/*
 * 
 * Input Parameters:
 * --------------- 
 * Banner ID
 * 
 * Arguments:
 * ---------
 * Zone ID
 */

$app->post('/adbyzone_unlink/[{zoneid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$id = $input['bannerid'];
		$getbannerid = explode(',', $id);


		$zoneval = "select zoneid from {$table_prefix}zones where zoneid=:zoneid";
		$zonedet = $this->db->prepare($zoneval);
		$zonedet->bindParam(":zoneid", $zoneid);
		$zonedet->execute();
		$stmtzonevalue = $zonedet->fetch();
		if (!$stmtzonevalue) {
			$response = array('response' => 'error', 'message' => 'Please provide valid zoneid!', 'status' => '404');
			return $this->response->withJson($response);
		}
		foreach ($getbannerid as $bannerid) {
			$bannerval = "select bannerid from {$table_prefix}banners where bannerid=:bannerid";
			$get_banner_det = $this->db->prepare($bannerval);
			$get_banner_det->bindParam(":bannerid", $bannerid);
			$get_banner_det->execute();
			$stmtbannervalue = $get_banner_det->fetch();
			$bannernum = count($stmtbannervalue);
			if (!$stmtbannervalue) {
				$response = array('response' => 'error', 'message' => 'Please provide valid Bannerid!', 'status' => '404');
				return $this->response->withJson($response);
			}

			$linkval = "select * from {$table_prefix}ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
			$linkdet = $this->db->prepare($linkval);
			$linkdet->bindParam(":zoneid", $zoneid);
			$linkdet->bindParam(":bannerid", $bannerid);
			$linkdet->execute();
			$stmtlinkvalue = $linkdet->fetchAll();

			if ($stmtlinkvalue) {


				$deleteaccounts = "DELETE FROM " . $table_prefix . "ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
				$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
				$djax_query_deleteaccount->bindParam(":bannerid", $bannerid);
				$djax_query_deleteaccount->bindParam(":zoneid", $zoneid);

				$banner_del = $djax_query_deleteaccount->execute();

				$response = array(
					'response' => 'Success',
					'message' => 'Banners Unlinked successfully!',
					'status' => '200'
				);
			} else {
				$response = array(
					'response' => 'error',
					'message' => 'Banners not linked !',
					'status' => '404'
				);
			}
		}
		return $this->response->withJson($response);
	}
})->add($container->get('az_link'));

/***********************************************************************/

/*************************** Unlinked Zone by Ad ********************************************/
/*
 * 
 * Input Parameters:
 * --------------- 
 * Zone ID
 * 
 * Arguments:
 * ---------
 * Banner ID
 */
$app->post('/zonebyad_unlink/[{bannerid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$id = $input['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$bannerid = $args['bannerid'];
		$getzoneid = explode(',', $id);

		$bannerval = "select bannerid from {$table_prefix}banners where bannerid=:bannerid";
		$get_banner_det = $this->db->prepare($bannerval);
		$get_banner_det->bindParam(":bannerid", $bannerid);
		$get_banner_det->execute();
		$stmtbannervalue = $get_banner_det->fetch();

		if (!$stmtbannervalue) {
			$response = array('response' => 'error', 'message' => 'Please provide valid Bannerid!', 'status' => '404');
			return $this->response->withJson($response);
		}


		foreach ($getzoneid as $zoneid) {

			$zoneval = "select zoneid from {$table_prefix}zones where zoneid=:zoneid";
			$zonedet = $this->db->prepare($zoneval);
			$zonedet->bindParam(":zoneid", $zoneid);
			$zonedet->execute();
			$stmtzonevalue = $zonedet->fetch();

			if (!$stmtzonevalue) {
				$response = array('response' => 'error', 'message' => 'Please provide valid zoneid!', 'status' => '404');
				return $this->response->withJson($response);
			}

			$linkval = "select * from {$table_prefix}ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
			$linkdet = $this->db->prepare($linkval);
			$linkdet->bindParam(":zoneid", $zoneid);
			$linkdet->bindParam(":bannerid", $bannerid);
			$linkdet->execute();
			$stmtlinkvalue = $linkdet->fetchAll();

			if ($stmtlinkvalue) {


				$deleteaccounts = "DELETE FROM " . $table_prefix . "ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
				$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
				$djax_query_deleteaccount->bindParam(":bannerid", $bannerid);
				$djax_query_deleteaccount->bindParam(":zoneid", $zoneid);

				$banner_del = $djax_query_deleteaccount->execute();

				$response = array(
					'response' => 'Success',
					'message' => 'Zones Unlinked successfully!',
					'status' => '200'
				);
			} else {
				$response = array(
					'response' => 'error',
					'message' => 'Zones not linked !',
					'status' => '404'
				);
			}
		}
		return $this->response->withJson($response);
	}
})->add($container->get('az_link'));





/***********************************************************************/

/*************************** Unlinked Campaign by zone ********************************************/
/*
 * 
 * Input Parameters:
 * --------------- 
 * Campaign ID
 * 
 * Arguments:
 * ---------
 * Zone ID
 */


$app->post('/campaignbyzone_unlink/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$id = $input['campaignid'];
		$getid = explode(',', $id);

		$zonevalue = "select * from {$table_prefix}zones where zoneid=:zoneid";
		$djax_query_zonevalue = $this->db->prepare($zonevalue);
		$djax_query_zonevalue->bindParam(":zoneid", $zoneid);
		$djax_query_zonevalue->execute();

		$stmtzonevalue = $djax_query_zonevalue->fetchAll();
		$zonenum = count($stmtzonevalue);

		if (empty($zonenum)) {
			$response = array(
				'response' => 'Error',
				'message' => 'There is no zone exists under this requested id!',
				'status' => '404'
			);
			return $this->response->withJson($response);
		}

		foreach ($getid as $campaignid) {
			$campaignvalue1 = "select campaignid from {$table_prefix}campaigns where campaignid=:campaignid";
			$djax_query_campaignvalue1 = $this->db->prepare($campaignvalue1);
			$djax_query_campaignvalue1->bindParam(":campaignid", $campaignid);
			$djax_query_campaignvalue1->execute();

			$stmtcampaignvalue1 = $djax_query_campaignvalue1->fetch();
			$stmtcampaignvalue1num = count($stmtcampaignvalue1);
			if (empty($stmtcampaignvalue1num)) {
				$response = array(
					'response' => 'Error',
					'message' => 'There is no Campaign exists under this requested id!',
					'status' => '404'
				);
				return $this->response->withJson($response);
			}


			$linkval = "select * from {$table_prefix}placement_zone_assoc WHERE placement_id=:campaignid AND zone_id=:zoneid";
			$linkdet = $this->db->prepare($linkval);
			$linkdet->bindParam(":zoneid", $zoneid);
			$linkdet->bindParam(":campaignid", $campaignid);
			$linkdet->execute();
			$stmtlinkvalue = $linkdet->fetchAll();

			if ($stmtlinkvalue) {
				$deleteplaceaccounts = "DELETE FROM " . $table_prefix . "placement_zone_assoc WHERE placement_id=:campaignid AND zone_id=:zoneid";
				$djax_query_deleteplaceaccount = $this->db->prepare($deleteplaceaccounts);
				$djax_query_deleteplaceaccount->bindParam(":campaignid", $campaignid);
				$djax_query_deleteplaceaccount->bindParam(":zoneid", $zoneid);

				$campaign_del = $djax_query_deleteplaceaccount->execute();

				//get banners
				$campaignvalue = "select * from {$table_prefix}banners where campaignid=:campaignid";
				$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
				$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
				$djax_query_campaignvalue->execute();

				$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();

				$num = count($stmtcampaignvalue);


				if ($stmtcampaignvalue) {

					foreach ($stmtcampaignvalue as $campaignvalue) {

						$bannerid = $campaignvalue['bannerid'];

						$deleteaccounts = "DELETE FROM " . $table_prefix . "ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
						$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
						$djax_query_deleteaccount->bindParam(":bannerid", $bannerid);
						$djax_query_deleteaccount->bindParam(":zoneid", $zoneid);

						$banner_del = $djax_query_deleteaccount->execute();
					}

					$response = array(
						'response' => 'Success',
						'message' => 'Campaigns unlinked successfully!',
						'status' => '404'
					);
				} else {
					$response = array(
						'response' => 'Error',
						'message' => 'Banners not linked!',
						'status' => '404'
					);
				}
			} else {
				$response = array(
					'response' => 'Error',
					'message' => 'Campaigns not linked!',
					'status' => '404'
				);
			}
		}
		return $this->response->withJson($response);
	}
})->add($container->get('cz_link'));



/***********************************************************************/

/*************************** Unlinked Zone by Campaign ********************************************/
/*
 * 
 * Input Parameters:
 * --------------- 
 * Zone ID
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */



$app->post('/zonebycampaign_unlink/[{campaignid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$campaignid = $args['campaignid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$id = $input['zoneid'];
		$getid = explode(',', $id);

		//for validation purpose
		$validation = "SELECT campaignid FROM {$table_prefix}campaigns 
					WHERE campaignid =:campaignid";

		$djax_query_validation = $this->db->prepare($validation);
		$djax_query_validation->bindParam(":campaignid", $campaignid);
		$djax_query_validation->execute();
		$stmtvalidation = $djax_query_validation->fetchAll();
		$valid = count($stmtvalidation);

		if ($stmtvalidation) {

			$bannerval = "SELECT zoneid FROM {$table_prefix}zones WHERE zoneid=:zone_id";

			$banner_ck = $this->db->prepare($bannerval);
			$banner_ck->bindParam(":zone_id", $id);
			$banner_ck->execute();
			$bnn = $banner_ck->fetch();
			$banner_count = count($bnn);

			if (!$banner_count) {

				$response = array('response' => 'error', 'message' => 'Please enter valid Zoneid', 'status' => '404');
				return $this->response->withJson($response);
			}


			foreach ($getid as $zoneid) {

				//to get banners under given campaign


				//to get zonewidth and height
				$zonevalue = "select * from {$table_prefix}zones where zoneid=:zoneid";
				$djax_query_zonevalue = $this->db->prepare($zonevalue);
				$djax_query_zonevalue->bindParam(":zoneid", $zoneid);
				$djax_query_zonevalue->execute();

				$stmtzonevalue = $djax_query_zonevalue->fetchAll();
				$zonenum = count($stmtzonevalue);

				if (empty($zonenum)) {

					$response = array('response' => 'Error', 'message' => 'Zone not exist for requested id', 'status' => '404');
					return $this->response->withJson($response);
				}
				$linkval = "select * from {$table_prefix}placement_zone_assoc WHERE placement_id=:campaignid AND zone_id=:zoneid";
				$linkdet = $this->db->prepare($linkval);
				$linkdet->bindParam(":zoneid", $zoneid);
				$linkdet->bindParam(":campaignid", $campaignid);
				$linkdet->execute();
				$stmtlinkvalue = $linkdet->fetchAll();

				if ($stmtlinkvalue) {

					$deleteplaceaccounts = "DELETE FROM " . $table_prefix . "placement_zone_assoc WHERE placement_id=:campaignid AND zone_id=:zoneid";
					$djax_query_deleteplaceaccount = $this->db->prepare($deleteplaceaccounts);
					$djax_query_deleteplaceaccount->bindParam(":campaignid", $campaignid);
					$djax_query_deleteplaceaccount->bindParam(":zoneid", $zoneid);

					$zone_del = $djax_query_deleteplaceaccount->execute();

					$campaignvalue = "select * from {$table_prefix}banners where campaignid=:campaignid";
					$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
					$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
					$djax_query_campaignvalue->execute();

					$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();

					$num = count($stmtcampaignvalue);

					foreach ($stmtcampaignvalue as $campaignvalue) {

						$bannerid = $campaignvalue['bannerid'];

						$deleteaccounts = "DELETE FROM " . $table_prefix . "ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
						$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
						$djax_query_deleteaccount->bindParam(":bannerid", $bannerid);
						$djax_query_deleteaccount->bindParam(":zoneid", $zoneid);

						$banner_del = $djax_query_deleteaccount->execute();
						$response = array(
							'response' => 'Success',
							'message' => 'Zones Unlinked successfully!',
							'status' => '200'
						);
					}
				} else {
					$response = array(
						'response' => 'error',
						'message' => 'Zones not linked!',
						'status' => '404'
					);
				}
			}
			return $this->response->withJson($response);
		} else {
			$response = array('response' => 'error', 'Error' => 'Please enter valid campaign Id ');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('cz_link'));

/*************************** Linked banner details by zone ********************************************/
/*
 * Input Parameters:
 * --------------- 
 * NULL
 * 
 * Arguments:
 * ---------
 * Zone ID
 */
$app->get('/get_linked_banners/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$zoneval = "select zoneid from {$table_prefix}zones where zoneid=:zoneid";
		$zonedet = $this->db->prepare($zoneval);
		$zonedet->bindParam(":zoneid", $zoneid);
		$zonedet->execute();
		$stmtzonevalue = $zonedet->fetch();
		if ($stmtzonevalue) {
			$sql = "SELECT b.description AS bannername, b.bannerid, b.contenttype, b.storagetype, b.filename, b.imageurl, b.htmltemplate, b.width, b.height, b.weight,
		    b.htmltemplate, b.target, b.url, b.alt, b.statustext, b.bannertext, b.append, b.status, b.bannertype
		    FROM " . $table_prefix . "ad_zone_assoc AS az  
			JOIN " . $table_prefix . "zones AS z ON (z.zoneid = az.zone_id)  
			JOIN " . $table_prefix . "banners AS b ON (b.bannerid = az.ad_id)
			WHERE az.zone_id = :zoneid GROUP BY az.ad_id;";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":zoneid", $zoneid);

			$sth->execute();

			$todos = $sth->fetchAll();
			
			if ($todos) {
				$data['data'] = $todos;
				$data['response'] = "success";
				$data['message'] = "Linked banners list";
				$data['status'] = "200";
				return $this->response->withJson($data);
			} else {
				$response = array('response' => 'error', 'message' => 'There is no linked Banners', 'status' => '404');
				return $this->response->withJson($response);
			}
		} else {

			$response = array('response' => 'error', 'message' => 'Please enter the valid Zone Id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('zoneid_val'));





/***********************************************************************/

/*************************** Linked zone details by banner ********************************************/
/*
 * Input Parameters:
 * --------------- 
 * NULL
 * 
 * Arguments:
 * ---------
 * Banner ID
 */

$app->get('/get_linked_zones/[{bannerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$bannerid = $args['bannerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$bannerval = "select bannerid from {$table_prefix}banners where bannerid=:bannerid";
		$bannerdet = $this->db->prepare($bannerval);
		$bannerdet->bindParam(":bannerid", $bannerid);
		$bannerdet->execute();
		$stmtbannervalue = $bannerdet->fetch();

		if ($stmtbannervalue) {
			$sql = "SELECT z.zoneid, z.zonename, z.description, z.delivery, z.height, z.width
FROM " . $table_prefix . "ad_zone_assoc AS az  
JOIN " . $table_prefix . "zones AS z ON (z.zoneid = az.zone_id)  
JOIN " . $table_prefix . "banners AS b ON (b.bannerid = az.ad_id)
WHERE az.ad_id = :bannerid GROUP BY az.zone_id;";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":bannerid", $bannerid);

			$sth->execute();

			$todos = $sth->fetchAll();
			$data['data'] = $todos;
			if ($todos) {
				return $this->response->withJson($data);
			} else {
				$response = array('response' => 'error', 'message' => 'There is no linked Zones', 'status' => '404');
				return $this->response->withJson($response);
			}
		} else {

			$response = array('response' => 'error', 'message' => 'Please enter valid Banner Id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('limitValidation'));

/***********************************************************************/

/*************************** Linked campaign details by zone ********************************************/
/*
 * Input Parameters:
 * --------------- 
 * NULL
 * 
 * Arguments:
 * ---------
 * Zone ID
 */
$app->get('/get_linked_campaigns/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$zoneval = "select zoneid from {$table_prefix}zones where zoneid=:zoneid";
		$zonedet = $this->db->prepare($zoneval);
		$zonedet->bindParam(":zoneid", $zoneid);
		$zonedet->execute();
		$stmtzonevalue = $zonedet->fetch();

		if ($stmtzonevalue) {
			$sql = "SELECT ca.campaignid, ca.campaignname, ca.clientid, ca.views, ca.clicks, ca.conversions, ca.priority, ca.weight, ca.target_impression, ca.target_click, ca.target_conversion, ca.anonymous, ca.companion, ca.comments, ca.revenue, ca.revenue_type, ca.updated, ca.block, ca.capping, ca.session_capping, ca.status, ca.min_impressions, ca.activate_time, ca.expire_time, ca.show_capped_no_cookie
		    FROM " . $table_prefix . "placement_zone_assoc AS pz  
			JOIN " . $table_prefix . "zones AS z ON (z.zoneid = pz.zone_id)  
			JOIN " . $table_prefix . "campaigns AS ca ON (ca.campaignid = pz.placement_id)
			WHERE pz.zone_id = :zoneid GROUP BY pz.placement_id;";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":zoneid", $zoneid);

			$sth->execute();

			$todos = $sth->fetchAll();
			$data['data'] = $todos;
			if ($todos) {
				return $this->response->withJson($data);
			} else {
				$response = array('response' => 'error', 'message' => 'There is no linked Banners', 'status' => '404');
				return $this->response->withJson($response);
			}
		} else {

			$response = array('response' => 'error', 'message' => 'Please enter valid Zone Id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('zoneid_val'));

/***********************************************************************/

/*************************** Linked zone details by campaign ********************************************/
/*
 * Input Parameters:
 * --------------- 
 * NULL
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */
$app->get('/get_campaign_linked_zones/[{campaign_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$campaignid = $args['campaign_id'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$campaignval = "select campaignid from {$table_prefix}campaigns where campaignid=:campaignid";
		$campaigndet = $this->db->prepare($campaignval);
		$campaigndet->bindParam(":campaignid", $campaignid);
		$campaigndet->execute();
		$stmtcampaignvalue = $campaigndet->fetch();
		if ($stmtcampaignvalue) {
			$sql = "SELECT z.zoneid, z.zonename, z.description, z.delivery, z.height, z.width
		    FROM " . $table_prefix . "placement_zone_assoc AS pz  
			JOIN " . $table_prefix . "zones AS z ON (z.zoneid = pz.zone_id)  
			JOIN " . $table_prefix . "campaigns AS ca ON (ca.campaignid = pz.placement_id)
			WHERE pz.placement_id = :campaignid GROUP BY pz.zone_id;";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaignid", $campaignid);

			$sth->execute();

			$todos = $sth->fetchAll();
			$data['data'] = $todos;
			if ($todos) {
				return $this->response->withJson($data);
			} else {
				$response = array('response' => 'error', 'message' => 'There is no linked Zones', 'status' => '404');
				return $this->response->withJson($response);
			}
		} else {

			$response = array('response' => 'error', 'message' => 'Please enter valid Campaign Id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('campaignid_val'));

/*----------------  Tracker -------------*/

/*
 * Tracker ADD
 * 
 * Input Parameters:
 * --------------- 
 * trackername
 * description
 * status
 * type
 * appendcode
 * 
 * Arguments:
 * ---------
 * Client ID
 */
$app->post('/add_tracker/[{clientid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {


		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$clientid = $args['clientid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();

		$trackername = $input['trackername'];
		$description = $input['description'];
		$status = $input['status'];
		$type = $input['type'];
		$appendcode = $input['appendcode'];

		$stc = "SELECT * FROM " . $table_prefix . "clients where clientid =" . $clientid;
		$std = $this->db->prepare($stc);
		$std->execute();
		$clients = $std->fetchAll();

		if (count($clients) <= 0) {
			$response = array('response' => 'error', 'message' => 'Please Enter the valid clientid', 'status' => '404');
			return $this->response->withJson($response);
		}
		//variable table
		if (isset($input['variable_name'])) {
			$varname = $input['variable_name'];
		} else {
			$varname = '';
		}
		if (isset($input['variable_description'])) {
			$vardescription = $input['variable_description'];
		} else {
			$vardescription = '';
		}
		if (isset($input['variable_datatype'])) {
			$vardatatype = $input['variable_datatype'];
		} else {
			$vardatatype = '';
		}

		if (isset($input['linkcampaigns'])) {
			$linkcampaigns = $input['linkcampaigns'];
		} else {
			$linkcampaigns = '';
		}
		$addtracker = "insert into {$table_prefix}trackers( trackername,description,clientid,status,type,appendcode,updated,linkcampaigns) values(:trackername,:description,:clientid,:status,:type,:appendcode,:updated,:linkcampaigns)";
		$tracker_add = $this->db->prepare($addtracker);
		$tracker_add->bindParam(":clientid", $clientid);
		$tracker_add->bindParam(":trackername", $trackername);
		$tracker_add->bindParam(":description", $description);
		$tracker_add->bindParam(":status", $status);
		$tracker_add->bindParam(":type", $type);
		$tracker_add->bindParam(":appendcode", $appendcode);
		$tracker_add->bindParam(":updated", $datetime);
		$tracker_add->bindParam(":linkcampaigns", $linkcampaigns);

		$tracker_add->execute();


		$trackerid = $this->db->lastInsertId();

		$addtrackerappend = "insert into {$table_prefix}tracker_append(tracker_id,rank,tagcode,paused,autotrack)values(:tracker_id,1,:tagcode,'f','f')";


		$trackerappend = $this->db->prepare($addtrackerappend);
		$trackerappend->bindParam(":tracker_id", $trackerid);
		$trackerappend->bindParam(":tagcode", $appendcode);
		$trackerappend->execute();

		$variabletrackers = "insert into {$table_prefix}variables(
		trackerid,
		name,
		description,
		datatype,
		purpose,
		reject_if_empty,
		is_unique,
		unique_window,
		hidden,
		updated)values(
		:trackerid,
		:name,
		:description,
		:datatype,
		'basket_value',
		1,
		0,
		0,
		'f',
		:updated)";


		$var_trackers = $this->db->prepare($variabletrackers);
		$var_trackers->bindParam(":trackerid", $trackerid);
		$var_trackers->bindParam(":name", $varname);
		$var_trackers->bindParam(":description", $vardescription);
		$var_trackers->bindParam(":datatype", $vardatatype);
		$var_trackers->bindParam(":updated", $datetime);

		$var_trackers->execute();

		$response = array('response' => 'Success', 'message' => 'Tracker has been added successfully!', 'id' => $trackerid, 'status' => '200');

		return $this->response->withJson($response);
	}
})->add($container->get('tracker_validate'));

/*
 * Tracker EDIT
 * 
 * Input Parameters:
 * --------------- 
 * trackername
 * description
 * status
 * type
 * appendcode
 * mode
 * 
 * Arguments:
 * ---------
 * Tracker ID
 */

$app->post('/edit_tracker/[{trackerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$value = "select * from {$table_prefix}trackers where trackerid=:trackerid";
		$tracker_data = $this->db->prepare($value);
		$tracker_data->bindParam(":trackerid", $trackerid);
		$tracker_data->execute();
		$stmt = $tracker_data->fetchAll();
		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array('response' => 'error', 'Message' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}

		if (count($stmt)) {
			if (isset($input['trackername'])) {
				$trackername = $input['trackername'];
			} else {
				$trackername = $stmt[0]['trackername'];
			}
			if (isset($input['description'])) {
				$description = $input['description'];
			} else {
				$description = $stmt[0]['description'];
			}
			if (isset($input['status'])) {
				$status = $input['status'];
			} else {
				$status = $stmt[0]['status'];
			}
			if (isset($input['type'])) {
				$type = $input['type'];
			} else {
				$type = $stmt[0]['type'];
			}
			if (isset($input['linkcampaigns'])) {
				$linkcampaigns = $input['linkcampaigns'];
			} else {
				$linkcampaigns = $stmt[0]['linkcampaigns'];
			}
			if (isset($input['appendcode'])) {
				$appendcode = $input['appendcode'];
			} else {
				$appendcode = $stmt[0]['appendcode'];
			}

			$edittracker = "update  {$table_prefix}trackers set 
	trackername=:trackername,
	description=:description,
	status=:status,
	type=:type,
	linkcampaigns=:linkcampaigns,
	appendcode=:appendcode where trackerid=:trackerid";

			$edit_tracker = $this->db->prepare($edittracker);
			$edit_tracker->bindParam(":trackerid", $trackerid);
			$edit_tracker->bindParam(":trackername", $trackername);
			$edit_tracker->bindParam(":description", $description);
			$edit_tracker->bindParam(":status", $status);
			$edit_tracker->bindParam(":type", $type);
			$edit_tracker->bindParam(":appendcode", $appendcode);
			$edit_tracker->bindParam(":linkcampaigns", $linkcampaigns);
			$edit_tracker->execute();


			$trackerappend = "update  {$table_prefix}tracker_append set tagcode=:tagcode where tracker_id=:tracker_id";


			$edittrackerappend = $this->db->prepare($trackerappend);
			$edittrackerappend->bindParam(":tracker_id", $trackerid);
			$edittrackerappend->bindParam(":tagcode", $appendcode);
			$edittrackerappend->execute();


			$editcampaignstrackers = "update {$table_prefix}campaigns_trackers set campaignid=:campaignid where trackerid=:trackerid";


			$campaigntrackers = $this->db->prepare($editcampaignstrackers);
			$campaigntrackers->bindParam(":trackerid", $trackerid);
			$campaigntrackers->bindParam(":campaignid", $campaignid);
			$campaigntrackers->execute();

			$variabletrackers = "update {$table_prefix}variables set 	name=:name,description=:description where trackerid=:trackerid";
			$variable_trackers = $this->db->prepare($variabletrackers);
			$variable_trackers->bindParam(":trackerid", $trackerid);
			$variable_trackers->bindParam(":name", $name);
			$variable_trackers->bindParam(":description", $description);
			$variable_trackers->execute();

			$response = array('response' => 'Success', 'Message' => 'Tracker has been updated successfully!', 'status' => '200');

			return $this->response->withJson($response);
		} else {
			$response = array('response' => 'Error', 'Message' => 'Please Enter the Valid Tracker Id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('tracker_editmode'));

/*
 * Tracker DELETE
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Tracker ID
 */

$app->delete('/delete_tracker/[{trackerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();

		$tracker = "select * from {$table_prefix}trackers where trackerid=:trackerid";
		$dat_tracker = $this->db->prepare($tracker);
		$dat_tracker->bindParam(":trackerid", $trackerid);
		$dat_tracker->execute();

		$stmttracker = $dat_tracker->fetchAll();

		if (count($stmttracker) > 0) {

			$deltracker = "DELETE FROM {$table_prefix}trackers where trackerid=:trackerid";
			$deletetracker = $this->db->prepare($deltracker);
			$deletetracker->bindParam(":trackerid", $trackerid);
			$deletetracker->execute();


			$deleteappend = "DELETE FROM {$table_prefix}tracker_append WHERE tracker_id=:trackerid";
			$del_append = $this->db->prepare($deleteappend);
			$del_append->bindParam(":trackerid", $trackerid);
			$del_append->execute();


			$campaigntracker = "DELETE FROM {$table_prefix}campaigns_trackers WHERE trackerid=:trackerid";
			$del_campaign = $this->db->prepare($campaigntracker);
			$del_campaign->bindParam(":trackerid", $trackerid);
			$del_campaign->execute();


			$deletevariable = "DELETE FROM {$table_prefix}variables WHERE trackerid=:trackerid";
			$del_variable = $this->db->prepare($deletevariable);
			$del_variable->bindParam(":trackerid", $trackerid);
			$del_variable->execute();


			$response = array('response' => 'Success', 'Message' => 'Tracker has been deleted successfully!', 'status' => '200');

			return $this->response->withJson($response);
		} else {

			$response = array('response' => 'error', 'Message' => 'Please Enter the Valid Tracker id', 'status' => '404');

			return $this->response->withJson($response);
		}
	}
})->add($container->get('tracker_edit'));

/*
 * Get Tracker Details
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Tracker ID
 */
$app->get('/get_tracker/[{trackerid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');

		$results = array();
		$refertracker = "SELECT *	FROM {$table_prefix}trackers AS t1 JOIN {$table_prefix}variables AS t2 ON t1.trackerid = t2.trackerid AND t1.trackerid =:trackerid";
		$dat_tracker = $this->db->prepare($refertracker);
		$dat_tracker->bindParam(":trackerid", $trackerid);
		$dat_tracker->execute();

		$stmttracker = $dat_tracker->fetchAll();

		$count = count($stmttracker);

		$trackerdetail = array();

		if ($count) {
			$trackerdetail = array(
				'trackerid' => $trackerid,
				'trackername' => $stmttracker[0]['trackername'],
				'description' => $stmttracker[0]['description'],
				'clientid' => $stmttracker[0]['clientid'],
				'status' => $stmttracker[0]['status'],
				'type' => $stmttracker[0]['type'],
				'linkcampaigns' => $stmttracker[0]['linkcampaigns'],
				'variablemethod' => $stmttracker[0]['variablemethod'],
				'appendcode' => $stmttracker[0]['appendcode'],
				'variableid' => $stmttracker[0]['variableid'],
				'name' => $stmttracker[0]['name'],
				'description' => $stmttracker[0]['description'],
				'datatype' => $stmttracker[0]['datatype'],
				'purpose' => $stmttracker[0]['purpose'],
				'variablecode' => $stmttracker[0]['variablecode']

			);
			$data['data'] = $trackerdetail;
			
			$data['response'] = "success";
			$data['message'] = "Tracker Data List";
			$data['status'] = "200";
	
			$response = array($trackerid => $data);
			return $this->response->withJson($response);
		} else {
			$refertrackers = "SELECT * FROM {$table_prefix}trackers where trackerid =:trackerid";
			$tracker_det = $this->db->prepare($refertrackers);
			$tracker_det->bindParam(":trackerid", $trackerid);
			$tracker_det->execute();
			$stmttracker = $tracker_det->fetchAll();
			$counts = count($stmttracker);
			$trackerdetails = array();
			if ($counts) {
				$trackerdetails[$trackerid] = array(
					'trackerid' => $trackerid,
					'trackername' => $stmttracker[0]['trackername'],
					'description' => $stmttracker[0]['description'],
					'clientid' => $stmttracker[0]['clientid'],
					'status' => $stmttracker[0]['status'],
					'type' => $stmttracker[0]['type'],
					'linkcampaigns' => $stmttracker[0]['linkcampaigns'],
					'variablemethod' => $stmttracker[0]['variablemethod'],
					'appendcode' => $stmttracker[0]['appendcode']
				);

				$data['data'] = $trackerdetails;

				return $this->response->withJson($data);
			} else {

				$response = array('response' => 'error', 'Message' => 'Please Enter the valid Trackerid!', 'status' => '404');

				return $this->response->withJson($response);
			}
		}
	}
})->add($container->get('tracker_edit'));



$app->get('/get_tracker_by_advertiser/[{clientid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$clientid = $args['clientid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();


		$tracker_data = "select * from {$table_prefix}trackers where clientid=:clientid";
		$std_tracker = $this->db->prepare($tracker_data);
		$std_tracker->bindParam(":clientid", $clientid);
		$std_tracker->execute();
		$stmttracker = $std_tracker->fetchAll();
		$a = count($stmttracker);
		if ($stmttracker) {
			foreach ($stmttracker as $trackerinfo) {
				$trackerid = $trackerinfo['trackerid'];
				$camptracker = "select * from {$table_prefix}campaigns_trackers where trackerid=:trackerid";
				$cmp_camptracker = $this->db->prepare($camptracker);
				$cmp_camptracker->bindParam(":trackerid", $trackerid);
				$cmp_camptracker->execute();

				$stmtcamptracker = $cmp_camptracker->fetchAll();

				$variablestracker = "select * from {$table_prefix}variables where trackerid=:trackerid";
				$vb_tracker = $this->db->prepare($variablestracker);
				$vb_tracker->bindParam(":trackerid", $trackerid);
				$vb_tracker->execute();

				$stmtvariablestracker = $vb_tracker->fetchAll();

				$appendtracker = "select * from  {$table_prefix}tracker_append where tracker_id=:trackerid";
				$gd_tracker = $this->db->prepare($appendtracker);
				$gd_tracker->bindParam(":trackerid", $trackerid);
				$gd_tracker->execute();


				$stmtappendtracker = $gd_tracker->fetchAll();

				$trackerdetail = array();
				$campaigntrackerdetail = array();
				$appendtrackerdetail = array();
				$variabletrackerdetail = array();

				if (count($stmttracker) > 0) {
					foreach ($stmttracker as $tracker) {

						$trackerdetail[] = array(
							'trackerid' => $tracker['trackerid'],
							'trackername' => $tracker['trackername'],
							'description' => $tracker['description'],
							'clientid' => $clientid,
							'status' => $tracker['status'],
							'type' => $tracker['type'],
							'linkcampaigns' => $tracker['linkcampaigns'],
							'variablemethod' => $tracker['variablemethod'],
							'appendcode' => $tracker['appendcode'],
							'updated' => $tracker['updated']
						);
						$data['data'] = $trackerdetail;
				$data['response'] = "success";
		        $data['message'] = "Tracker  List";
		        $data['status'] = "200";
		
						$results = json_encode(array('Tracker details' => $data));
					}

					if (count($stmtcamptracker)) {

						foreach ($stmtcamptracker as $camptracker) {

							$campaigntrackerdetail[$camptracker['campaign_trackerid']] = array(
								'campaign_trackerid' => $camptracker['campaign_trackerid'],
								'campaignid' => $camptracker['campaignid'],
								'status' => $camptracker['status']
							);
							$data['data'] = $campaigntrackerdetail;
							$results = json_encode(array('Campaign Tracker details' => $data));
						}
					}
					if (count($stmtvariablestracker)) {

						foreach ($stmtvariablestracker as  $variablestracker) {

							$variabletrackerdetail[$variablestracker['variableid']] = array(
								'variableid' => $variablestracker['variableid'],
								'name' => $variablestracker['name'],
								'description' => $variablestracker['description'],
								'datatype' => $variablestracker['datatype'],
								'purpose' => $variablestracker['purpose'],
								'reject_if_empty' => $variablestracker['reject_if_empty'],
								'is_unique' => $variablestracker['is_unique'],
								'unique_window' => $variablestracker['unique_window'],
								'variablecode' => $variablestracker['variablecode']
							);
							$data['data'] = $variabletrackerdetail;
							$results = json_encode(array('Variable Tracker details' => $data));
						}
					}
					if (count($stmtappendtracker)) {

						foreach ($stmtappendtracker as $appendtracker) {


							$appendtrackerdetail[$appendtracker['tracker_append_id']] = array(
								'tracker_append_id' => $appendtracker['tracker_append_id'],
								'rank' => $appendtracker['rank'],
								'tagcode' => $appendtracker['tagcode'],
								'paused' => $appendtracker['paused'],
								'autotrack' => $appendtracker['autotrack']
							);


							$data['data'] = $stmttracker;
							return $this->response->withJson($data);
						}
					}
				} else {

					$response = array('response' => 'error', 'Message' => 'Requested tracker not available', 'status' => '404');

					return $this->response->withJson($response);
				}
			}
		} else {
			$response = array('response' => 'error', 'Message' => 'Please Enter the Valid Client Id', 'status' => '404');

			return $this->response->withJson($response);
		}
	}
})->add($container->get('client_val'));


/*****************************************************************************************/




/*********************************Targetting channel********************************************************/

/*
 * Targetting channel ADD
 * 
 * Input Parameters:
 * --------------- 
 * affiliateid
 * name
 * description
 * comments
 * logical
 * comparison
 * type
 * data
 * 
 * Arguments:
 * ---------
 * Agency ID
 */
$app->post('/add_targeting_channel/[{agencyid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$agencyid = $args['agencyid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();

		$affiliateid = $input['affiliateid'];
		$name = $input['name'];
		$description = $input['description'];
		$comments = $input['comments'];

		//".$table_prefix."acls_channel
		$value = "select * from {$table_prefix}affiliates where affiliateid=:affiliateid";
		$tracker_data = $this->db->prepare($value);
		$tracker_data->bindParam(":affiliateid", $affiliateid);
		$tracker_data->execute();
		$stmt = $tracker_data->fetchAll();

		if (count($stmt)) {
			$value1 = "select * from {$table_prefix}affiliates where affiliateid=:affiliateid and agencyid=:agencyid";
			$tracker_data1 = $this->db->prepare($value1);
			$tracker_data1->bindParam(":affiliateid", $affiliateid);
			$tracker_data1->bindParam(":agencyid", $agencyid);
			$tracker_data1->execute();
			$stmt1 = $tracker_data1->fetchAll();

			if (count($stmt1)) {
				$multiplelogical = $input['logical'];
				$samlogical = explode(',', $multiplelogical);


				$multiplecomparison = $input['comparison'];
				$comparison = explode(',', $multiplecomparison);

				$multipletype = $input['type'];
				$type = explode(',', $multipletype);

				$multipledata = $input['data'];
				$data = explode('||', $multipledata);




				//Complile LImitation filed in banner
				$c[] = '';

				$j = 0;
				foreach ($type as  $value) {
					$newvalue = explode(':', $value);
					$getvalues = $newvalue[1] . "_" . $newvalue[2];

					$compiledlimitation = "Max_check" . $getvalues . "('" . $data[$j] . "','" . $comparison[$j] . "')" . $samlogical[$j] . " ";

					array_push($c, $compiledlimitation);
					$j++;
				}

				$compilevalue = implode('', $c);
				$acl_plugins = $input['type'];


				$addchannel = "insert into  {$table_prefix}channel
               (agencyid,
			    affiliateid,
			    name,
			    description,
			    compiledlimitation,
			    acl_plugins,
				acls_updated,
			    active,
			    comments )
			   values(
				:agencyid,
				:affiliateid,
				:name,
				:description,
				:compiledlimitation,
				:acl_plugins,
				:acls_updated,
				1,
				:comments)";




				$djax_query_addchannel = $this->db->prepare($addchannel);
				$djax_query_addchannel->bindParam(":agencyid", $agencyid);
				$djax_query_addchannel->bindParam(":affiliateid", $affiliateid);
				$djax_query_addchannel->bindParam(":name", $name);
				$djax_query_addchannel->bindParam(":description", $description);
				$djax_query_addchannel->bindParam(":compiledlimitation", $compilevalue);
				$djax_query_addchannel->bindParam(":acl_plugins", $acl_plugins);
				$djax_query_addchannel->bindParam(":acls_updated", $datetime);
				$djax_query_addchannel->bindParam(":comments", $comments);

				$djax_query_addchannel->execute();



				$logical = $input['logical'];
				$type = $input['type'];
				$comparison = $input['comparison'];
				$data = $input['data'];

				$channelid = $this->db->lastInsertId();

				$multiplelogical = $input['logical'];
				$samlogical = explode(',', $multiplelogical);


				$multiplecomparison = $input['comparison'];
				$comparison = explode(',', $multiplecomparison);

				$multipletype = $input['type'];
				$type = explode(',', $multipletype);

				$multipledata = $input['data'];
				$data = explode('||', $multipledata);

				//need to check 
				$executionorder = 0;
				$i = 0;


				foreach ($samlogical as $logical) {


					$addacls = "insert into 
				 {$table_prefix}acls_channel(channelid,logical,type,comparison,data,executionorder) 
				   values(:channelid,:logical,:type,:comparison,:data,:executionorder)";



					$djax_query_addacls = $this->db->prepare($addacls);
					$djax_query_addacls->bindParam(":channelid", $channelid);
					$djax_query_addacls->bindParam(":logical", $logical);
					$djax_query_addacls->bindParam(":type", $type[$i]);
					$djax_query_addacls->bindParam(":comparison", $comparison[$i]);
					$djax_query_addacls->bindParam(":data", $data[$i]);
					$djax_query_addacls->bindParam(":executionorder", $executionorder);
					$djax_query_addacls->execute();


					$executionorder++;
					$i++;
				}

				$response = array('response' => 'Success', 'Message' => 'Targeting channel added successfully with channelid:' . $channelid, 'status' => '200');
				return $this->response->withJson($response);

			} else {
				$response = array(
					'response' => 'error',
					'Message' => 'Please Enter the valid Agency Id',
					'status' => '404'
				);

				return $this->response->withJson($response);
			}
		} else {
			$response = array(
				'response' => 'error',
				'Message' => 'entered affiliate id not available',
				'status' => '404'
			);

			return $this->response->withJson($response);
		}
	}
})->add($container->get('target_val'));
//~ ///////////////////////////////

//targeting channel limitation method
$app->post('/add_targeting_limitation(test)/[{channelid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input    = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$req = "select *  from " . $table_prefix . "channel WHERE channelid=:channelid";
		$cam      = $this->db->prepare($req);
		$cam->bindParam("channelid", $args['channelid']);
		$cam->execute();
		$campaign  = $cam->fetchAll();



		if (!$campaign) {
			$res = array(
				'response' => 'error',
				'Message' => 'channelid is not valid.',
				'status' => '404'
			);
			return $this->response->withJson($res);
		}


		$channelid = "select channelid  from " . $table_prefix . "channel WHERE channelid=:channelid";
		$bnr      = $this->db->prepare($channelid);
		$bnr->bindParam("channelid", $args['channelid']);
		$bnr->execute();
		$banner  = $bnr->fetchAll();
		$data['compiledlimitation'] = '';
		$data['acl_plugins']        = '';

		if (!$banner) {
			$res = array(
				'response' => 'error',
				'Message' => 'No channel for given channelid!Please check the channelid!',
				'status' => '404'
			);
			return $this->response->withJson($res);
		}

		$comparison = array('==', '!=', '=~', '!~', '=x', '!x', 'gt', 'lt', 'le', 'ge', '>', '<', '>=', '<=', 'nn');
		foreach ($input as $inp) {
			if (($inp['type'])) {
				if (!in_array($inp['comparison'], $comparison)) {
					$response = array(
						'response' => 'error',
						'Message' => 'Parameters must be inside [ ] & comparision operators must be valid format',
						'status' => '404'
					);

					return $this->response->withJson($response);
				}
			}
		}


		foreach ($banner as $dat) {
			$executionid = "Delete from " . $table_prefix . "acls_channel WHERE channelid=:channelid";
			$bnr         = $this->db->prepare($executionid);
			$bnr->bindParam("channelid", $dat['channelid']);
			$bnr->execute();
		}


		foreach ($banner as $dat) {
			if ($input) {
				foreach ($input as $inp) {

					//set function name using delivery limitations

					switch ($inp['type']) {
						case 'deliveryLimitations:Client:Browser':
							$function_name  = 'MAX_checkClient_Browser';
							$string_compare = 'Client:Browser';
							break;
						case 'deliveryLimitations:Client:BrowserVersion':
							$function_name  = 'MAX_checkClient_BrowserVersion';
							$string_compare = 'Client:BrowserVersion';
							break;
						case 'deliveryLimitations:Client:Domain':
							$function_name  = 'MAX_checkClient_Domain';
							$string_compare = 'Client:Domain';
							break;
						case 'deliveryLimitations:Client:Ip':
							$function_name  = 'MAX_checkClient_Ip';
							$string_compare = 'Client:Ip';
							break;
						case 'deliveryLimitations:Client:Language':
							$function_name  = 'MAX_checkClient_Language';
							$string_compare = 'Client:Language';
							break;
						case 'deliveryLimitations:Client:Os':
							$function_name  = 'MAX_checkClient_Os';
							$string_compare = 'Client:Os';
							break;
						case 'deliveryLimitations:Client:OsVersion':
							$function_name  = 'MAX_checkClient_OsVersion';
							$string_compare = 'Client:OsVersion';
							break;
						case 'deliveryLimitations:Client:Useragent':
							$function_name  = 'MAX_checkClient_Useragent';
							$string_compare = 'Client:Useragent';
							break;
						case 'deliveryLimitations:Site:Pageurl':
							$function_name  = 'MAX_checkSite_Pageurl';
							$string_compare = 'Site:Pageurl';
							break;

						case 'deliveryLimitations:Site:Referingpage':
							$function_name  = 'MAX_checkSite_Referingpage';
							$string_compare = 'Site:Referingpage';
							break;
						case 'deliveryLimitations:Site:Registerabledomainlist':
							$function_name  = 'MAX_checkSite_Registerabledomainlist';
							$string_compare = 'Site:Registerabledomainlist';
							break;
						case 'deliveryLimitations:Site:Hostnamelist':
							$function_name  = 'MAX_checkSite_Hostnamelist';
							$string_compare = 'Site:Hostnamelist';
							break;
						case 'deliveryLimitations:Site:Source':
							$function_name  = 'MAX_checkSite_Source';
							$string_compare = 'Site:Source';
							break;
						case 'deliveryLimitations:Site:Variable':
							$function_name  = 'MAX_checkSite_Variable';
							$string_compare = 'Site:Variable';
							break;
						case 'deliveryLimitations:Time:Date':
							$function_name  = 'MAX_checkTime_Date';
							$string_compare = 'Time:Date';
							break;
						case 'deliveryLimitations:Time:Day':
							$function_name  = 'MAX_checkTime_Day';
							$string_compare = 'Time:Day';
							break;
						case 'deliveryLimitations:Time:Hour':
							$function_name  = 'MAX_checkTime_Hour';
							$string_compare = 'Time:Hour';
							break;
						default:
							$function_name  = 'Empty';
							$string_compare = 'Empty';
							break;
					}


					//Insert values into ".$table_prefix."acls table
					//select maximum values from the table
					$executionid = "select MAX(executionorder) as execid,data  from " . $table_prefix . "acls_channel WHERE channelid=:channelid";
					$bnr         = $this->db->prepare($executionid);
					$bnr->bindParam("channelid", $dat['channelid']);
					$bnr->execute();
					$bnr_exec = $bnr->fetchAll();
					if ($bnr_exec['0']['data']) {
						$bnr_exec['0']['execid'] += 1;
					} else {
						$bnr_exec['0']['execid'] = 0;
					}

					if ($inp["type"]) {
						//Insert values into ".$table_prefix."acls table
						$sql = "INSERT INTO " . $table_prefix . "acls_channel (channelid,logical,type,comparison,data,executionorder) VALUES (:channelid,:logic,:type,:comparison,:data,:executionorder)";
						$sth = $this->db->prepare($sql);
						$sth->bindParam("channelid", $dat['channelid']);
						$sth->bindParam("logic", $inp['logical']);
						$sth->bindParam("type", $inp['type']);
						$sth->bindParam("comparison", $inp['comparison']);
						$sth->bindParam("data", $inp['data']);
						$sth->bindParam("executionorder", $bnr_exec['0']['execid']);
						$sth->execute();
						if ($inp["type"]) {
							if ($data['compiledlimitation'] && $data['acl_plugins']) {
								$data['compiledlimitation'] .= ' ' . $inp["logical"] . " " . $function_name . "('" . $inp["data"] . "', '" . $inp["comparison"] . "')";
								$chk = '"' . $inp["type"] . '"';
								if (strpos(strtolower($data["acl_plugins"]), strtolower($string_compare)) == false) {

									$data["acl_plugins"] .= ',' . $inp["type"];
								}
							} else {
								$data["compiledlimitation"] .= $function_name . "('" . $inp["data"] . "', '" . $inp["comparison"] . "')";
								$data["acl_plugins"] .= $inp["type"];
							}
						} else {
							$data['compiledlimitation'] = '';
							$data['acl_plugins'] = '';
						}
					} else {
						$data['compiledlimitation'] = '';
						$data['acl_plugins'] = '';
					}


					$sqlupdate = "UPDATE " . $table_prefix . "channel SET compiledlimitation=:check,acl_plugins=:type WHERE channelid=:channelid";
					$stc       = $this->db->prepare($sqlupdate);
					$stc->bindParam("type", $data['acl_plugins']);
					$stc->bindParam("check", $data['compiledlimitation']);
					$stc->bindParam("channelid", $dat['channelid']);
					$stc->execute();
				}
			} else {

				$res = array(
					'response' => 'error',
					'Message' => 'Request Is Empty',
					'status' => '404'
				);
				return $this->response->withJson($res);
			}
		}

		$res = array(
			'response' => 'Success',
			'Message' => 'channel successfully updated with delivery limitation',
			'status' => '200'
		);
		return $this->response->withJson($res);
		return $response;
	}
});


$app->post('/add_targeting_limitation/[{channelid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input    = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$req = "select *  from " . $table_prefix . "channel WHERE channelid=:channelid";
		$cam      = $this->db->prepare($req);
		$cam->bindParam("channelid", $args['channelid']);
		$cam->execute();
		$campaign  = $cam->fetchAll();

		if (!$campaign) {
			$res = array(
				'response' => 'error',
				'Message' => 'No channel for given channelid!Please check the channelid!',
				'status' => '404'

			);
			return $this->response->withJson($res);
		}


		$channelid = "select channelid  from " . $table_prefix . "channel WHERE channelid=:channelid";
		$bnr      = $this->db->prepare($channelid);
		$bnr->bindParam("channelid", $args['channelid']);
		$bnr->execute();
		$banner  = $bnr->fetchAll();
		$data['compiledlimitation'] = '';
		$data['acl_plugins']        = '';

		if (!$banner) {
			$res = array(
				'response' => 'error',
				'Message' => ' channelid Not available!',
				'status' => '404'
			);
			return $this->response->withJson($res);
		}

		$comparison = array('==', '!=', '=~', '!~', '=x', '!x', 'gt', 'lt', 'le', 'ge', '>', '<', '>=', '<=', 'nn');
		foreach ($input as $inp) {
			if (($inp['type'])) {
				if (!in_array($inp['comparison'], $comparison)) {
					$response = array(
						'response' => 'error',
						'Message' => 'Comparision operator passed in array is not supported!',
						'status' => '404'
					);

					return $this->response->withJson($response);
				}
			}
		}


		foreach ($banner as $dat) {
			$executionid = "Delete from " . $table_prefix . "acls_channel WHERE channelid=:channelid";
			$bnr         = $this->db->prepare($executionid);
			$bnr->bindParam("channelid", $dat['channelid']);
			$bnr->execute();
		}


		foreach ($banner as $dat) {
			if ($input) {
				foreach ($input as $inp) {

					//set function name using delivery limitations

					switch ($inp['type']) {
						case 'deliveryLimitations:Client:Browser':
							$function_name  = 'MAX_checkClient_Browser';
							$string_compare = 'Client:Browser';
							break;
						case 'deliveryLimitations:Client:BrowserVersion':
							$function_name  = 'MAX_checkClient_BrowserVersion';
							$string_compare = 'Client:BrowserVersion';
							break;
						case 'deliveryLimitations:Client:Domain':
							$function_name  = 'MAX_checkClient_Domain';
							$string_compare = 'Client:Domain';
							break;
						case 'deliveryLimitations:Client:Ip':
							$function_name  = 'MAX_checkClient_Ip';
							$string_compare = 'Client:Ip';
							break;
						case 'deliveryLimitations:Client:Language':
							$function_name  = 'MAX_checkClient_Language';
							$string_compare = 'Client:Language';
							break;
						case 'deliveryLimitations:Client:Os':
							$function_name  = 'MAX_checkClient_Os';
							$string_compare = 'Client:Os';
							break;
						case 'deliveryLimitations:Client:OsVersion':
							$function_name  = 'MAX_checkClient_OsVersion';
							$string_compare = 'Client:OsVersion';
							break;
						case 'deliveryLimitations:Client:Useragent':
							$function_name  = 'MAX_checkClient_Useragent';
							$string_compare = 'Client:Useragent';
							break;
						case 'deliveryLimitations:Site:Pageurl':
							$function_name  = 'MAX_checkSite_Pageurl';
							$string_compare = 'Site:Pageurl';
							break;

						case 'deliveryLimitations:Site:Referingpage':
							$function_name  = 'MAX_checkSite_Referingpage';
							$string_compare = 'Site:Referingpage';
							break;
						case 'deliveryLimitations:Site:Registerabledomainlist':
							$function_name  = 'MAX_checkSite_Registerabledomainlist';
							$string_compare = 'Site:Registerabledomainlist';
							break;
						case 'deliveryLimitations:Site:Hostnamelist':
							$function_name  = 'MAX_checkSite_Hostnamelist';
							$string_compare = 'Site:Hostnamelist';
							break;
						case 'deliveryLimitations:Site:Source':
							$function_name  = 'MAX_checkSite_Source';
							$string_compare = 'Site:Source';
							break;
						case 'deliveryLimitations:Site:Variable':
							$function_name  = 'MAX_checkSite_Variable';
							$string_compare = 'Site:Variable';
							break;
						case 'deliveryLimitations:Time:Date':
							$function_name  = 'MAX_checkTime_Date';
							$string_compare = 'Time:Date';
							break;
						case 'deliveryLimitations:Time:Day':
							$function_name  = 'MAX_checkTime_Day';
							$string_compare = 'Time:Day';
							break;
						case 'deliveryLimitations:Time:Hour':
							$function_name  = 'MAX_checkTime_Hour';
							$string_compare = 'Time:Hour';
							break;
						case 'deliveryLimitations:Geo:Areacode':
							$function_name  = 'MAX_checkGeo_Areacode';
							$string_compare = 'Geo:Areacode';
							break;
						case 'deliveryLimitations:Geo:City':
							$function_name  = 'MAX_checkGeo_City';
							$string_compare = 'Geo:City';
							break;
						case 'deliveryLimitations:Geo:Country':
							$function_name  = 'MAX_checkGeo_Country';
							$string_compare = 'Geo:Country';
							break;
						case 'deliveryLimitations:Geo:Dma':
							$function_name  = 'MAX_checkGeo_Dma';
							$string_compare = 'Geo:Dma';
							break;
						case 'deliveryLimitations:Geo:Latlong':
							$function_name  = 'MAX_checkGeo_Latlong';
							$string_compare = 'Geo:Latlong';
							break;
						case 'deliveryLimitations:Geo:Netspeed':
							$function_name  = 'MAX_checkGeo_Netspeed';
							$string_compare = 'Geo:Netspeed';
							break;
						case 'deliveryLimitations:Geo:Organisation':
							$function_name  = 'MAX_checkGeo_Organisation';
							$string_compare = 'Geo:Organisation';
							break;
						case 'deliveryLimitations:Geo:Postalcode':
							$function_name  = 'MAX_checkGeo_Postalcode';
							$string_compare = 'Geo:Postalcode';
							break;
						case 'deliveryLimitations:Geo:Region':
							$function_name  = 'MAX_checkGeo_Region';
							$string_compare = 'Geo:Region';
							break;
						case 'deliveryLimitations:Geo:Continent':
							$function_name  = 'MAX_checkGeo_Continent';
							$string_compare = 'Geo:Continent';
							break;
						default:
							$function_name  = 'Empty';
							$string_compare = 'Empty';
							break;
					}


					//Insert values into ".$table_prefix."acls_channel table

					//select maximum values from the table
					$executionid = "select MAX(executionorder) as execid,data  from " . $table_prefix . "acls_channel WHERE channelid=:channelid";
					$bnr         = $this->db->prepare($executionid);
					$bnr->bindParam("channelid", $dat['channelid']);
					$bnr->execute();
					$bnr_exec = $bnr->fetchAll();
					if ($bnr_exec['0']['data']) {
						$bnr_exec['0']['execid'] += 1;
					} else {
						$bnr_exec['0']['execid'] = 0;
					}

					if ($inp["type"]) {
						//Insert values into ".$table_prefix."acls_channel table
						$sql = "INSERT INTO " . $table_prefix . "acls_channel (channelid,logical,type,comparison,data,executionorder) VALUES (:channelid,:logic,:type,:comparison,:data,:executionorder)";
						$sth = $this->db->prepare($sql);
						$sth->bindParam("channelid", $dat['channelid']);
						$sth->bindParam("logic", $inp['logical']);
						$sth->bindParam("type", $inp['type']);
						$sth->bindParam("comparison", $inp['comparison']);
						$sth->bindParam("data", $inp['data']);
						$sth->bindParam("executionorder", $bnr_exec['0']['execid']);
						$sth->execute();



						if ($inp["type"]) {

							//continent-geo


							if ($inp["type"] == 'deliveryLimitations:Geo:Continent') {
								$inp["data"] = explode(",", $inp["data"]);

								$continent_array = array();
								foreach ($inp["data"] as $kk => $test_limit) {
									if ($test_limit == "AF") {
										$con_val = 'ao,bf,bi,bj,bw,cd,cf,cg,ci,cm,cv,dj,dz,eg,eh,er,et,ga,gh,gm,gn,gq,gw,ke,km,lr,ls,ly,ma,mg,ml,mr,mu,mw,mz,na,ne,ng,re,rw,sc,sd,sh,sl,sn,so,st,sz,td,tg,tn,tz,ug,yt,za,zm,zw,ss';
									}
									if ($test_limit == "IN") {
										$con_val = 'kowsi';
									}
									if ($test_limit == "AQ") {
										$con_val = '';
									}
									if ($test_limit == "CA") {
										$con_val = '';
									}
									if ($test_limit == "AS") {
										$con_val = 'ap,ae,af,am,az,bd,bh,bn,bt,cc,cn,cx,cy,ge,hk,id,il,in,io,iq,ir,jo,jp,kg,kh,kp,kr,kw,kz,la,lb,lk,mm,mn,mo,mv,my,np,om,ph,pk,ps,qa,sa,sg,sy,th,tj,tm,tl,tw,uz,vn,ye';
									}
									if ($test_limit == "EU") {
										$con_val = 'eu,ad,al,at,ba,be,bg,by,ch,cz,de,dk,ee,es,fi,fo,fr,gb,gi,gr,hr,hu,ie,is,it,li,lt,lu,lv,mc,md,mk,mt,nl,no,pl,pt,ro,ru,se,si,sj,sk,sm,tr,ua,va,rs,me,ax,gg,im,je';
									}
									if ($test_limit == "EU") {
										$con_val = 'eu,ad,al,at,ba,be,bg,by,ch,cz,de,dk,ee,es,fi,fo,fr,gb,gi,gr,hr,hu,ie,is,it,li,lt,lu,lv,mc,md,mk,mt,nl,no,pl,pt,ro,ru,se,si,sj,sk,sm,tr,ua,va,rs,me,ax,gg,im,je';
									}
									if ($test_limit == "NA") {
										$con_val = 'ag,ai,cw,aw,bb,bm,bs,bz,ca,cr,cu,dm,do,sx,gd,gl,gp,gt,hn,ht,jm,kn,ky,lc,mq,ms,mx,ni,pa,pm,pr,sv,tc,tt,us,vc,vg,vi,bl,mf,bq';
									}
									if ($test_limit == "OC") {
										$con_val = 'as,au,ck,fj,fm,gu,ki,mh,mp,nc,nf,nr,nu,nz,pf,pg,pn,pw,sb,tk,to,tv,um,vu,wf,ws';
									}
									if ($test_limit == "SA") {
										$con_val = 'ar,bo,br,cl,co,ec,fk,gf,gy,pe,py,sr,uy,ve';
									}
									if ($test_limit == "AN") {
										$con_val = 'bv,gs,hm,tf';
									}

									$continent_array[] = $con_val;
								}
								$inp["data"] = implode(",", array_filter($continent_array));
							}

							//end

							if ($inp["type"] == 'deliveryLimitations:Geo:City') {
								$inp["data"] =   strtolower($inp["data"]);
							}
							if ($inp["type"] == 'deliveryLimitations:Geo:Region') {
								$inp["data"] =   strtolower($inp["data"]);
							}

							if ($data['compiledlimitation'] && $data['acl_plugins']) {
								$data['compiledlimitation'] .= ' ' . $inp["logical"] . " " . $function_name . "('" . $inp["data"] . "', '" . $inp["comparison"] . "')";
								$chk = '"' . $inp["type"] . '"';
								if (strpos(strtolower($data["acl_plugins"]), strtolower($string_compare)) == false) {

									$data["acl_plugins"] .= ',' . $inp["type"];
								}
							} else {
								$data["compiledlimitation"] .= $function_name . "('" . $inp["data"] . "', '" . $inp["comparison"] . "')";
								$data["acl_plugins"] .= $inp["type"];
							}
						} else {
							$data['compiledlimitation'] = '';
							$data['acl_plugins'] = '';
						}
					} else {
						$data['compiledlimitation'] = '';
						$data['acl_plugins'] = '';
					}



					$sqlupdate = "UPDATE " . $table_prefix . "channel SET compiledlimitation=:check,acl_plugins=:type WHERE channelid=:channelid";
					$stc       = $this->db->prepare($sqlupdate);
					$stc->bindParam("type", $data['acl_plugins']);
					$stc->bindParam("check", $data['compiledlimitation']);
					$stc->bindParam("channelid", $dat['channelid']);
					$stc->execute();
				}
			} else {

				$res = array(
					'response' => 'error',
					'Message' => 'Request Is Empty',
					'status' => '404'
				);
				return $this->response->withJson($res);
			}
		}

		$res = array(
			'response' => 'Success',
			'Message' => 'channel delivery limitations has been updated successfully',
			'status' => '404'
		);
		return $this->response->withJson($res);
		return $response;
	}
});
/*
 * Targetting channel EDIT
 * 
 * Input Parameters:
 * --------------- 
 * affiliateid
 * name
 * description
 * comments
 * logical
 * comparison
 * type
 * data
 * 
 * Arguments:
 * ---------
 * Channel ID
 */
$app->post('/edit_targeting_channel/[{channelid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$input    		= $request->getParsedBody();
		$table_prefix 	= $this->get('settings')['path']['table_prefix'];

		//~ $results = array();

		$affiliateid  	= (isset($input['affiliateid'])) ? $input['affiliateid'] : '';
		$name		  	= (isset($input['name'])) ? $input['name'] : '';
		$description	= (isset($input['description'])) ? $input['description'] : '';
		$comments	    = (isset($input['comments'])) ? $input['comments'] : '';
		$logical  	    = (isset($input['logical'])) ? $input['logical'] : '';
		$comparison		= (isset($input['comparison'])) ? $input['comparison'] : '';
		$type   		= (isset($input['type'])) ? $input['type'] : '';
		$data   		= (isset($input['data'])) ? $input['data'] : '';

		$datetime 		= date('Y-m-d H:i:s');
		$channelid 		= $args['channelid'];
		$getchannel = "SELECT * FROM " . $table_prefix . "channel AS t1 JOIN " . $table_prefix . "acls_channel AS t2 ON t1.channelid =" . $channelid . " AND t1.channelid = t2.channelid";
		$std = $this->db->prepare($getchannel);
		$std->execute();
		$targets = $std->fetchAll();

		if ($targets) {
			if (isset($affiliateid) && !empty($affiliateid)) {
				$sql_affiliateid = $affiliateid;
			} else {
				$sql_affiliateid = $targets[0]['affiliateid'];
			}
			if (isset($name) && !empty($name)) {
				$sql_name = $name;
			} else {
				$sql_name = $targets[0]['name'];
			}
			if (isset($description) && !empty($description)) {
				$sql_description = $description;
			} else {
				$sql_description = $targets[0]['description'];
			}
			if (isset($comments) && !empty($comments)) {
				$sql_comments = $comments;
			} else {
				$sql_comments = $targets[0]['comments'];
			}
			if (isset($logical) && !empty($logical)) {
				$sql_logical = $logical;
			} else {
				$sql_logical = $targets[0]['logical'];
			}
			if (isset($comparison) && !empty($comparison)) {
				$sql_comparison = $comparison;
			} else {
				$sql_comparison = $targets[0]['comparison'];
			}
			if (isset($type) && !empty($type)) {
				$sql_type = $type;
			} else {
				$sql_type = $targets[0]['acl_plugins'];
			}
			if (isset($data) && !empty($data)) {
				$sql_data = $data;
			} else {
				$sql_data = $targets[0]['data'];
			}


			//".$table_prefix."acls_channel

			$multiplelogical = $input['logical'];
			$samlogical = explode(',', $multiplelogical);

			$multiplecomparison = $input['comparison'];
			$comparison = explode(',', $multiplecomparison);

			$multipletype = $input['type'];
			$type = explode(',', $multipletype);

			$multipledata = $input['data'];
			$data = explode('||', $multipledata);

			//Complile LImitation filed in banner
			$c[] = '';

			$j = 0;
			foreach ($type as  $value) {
				$newvalue = explode(':', $value);
				$getvalues = $newvalue[1] . "_" . $newvalue[2];

				$compiledlimitation = "Max_check" . $getvalues . "('" . $data[$j] . "','" . $comparison[$j] . "')" . $samlogical[$j] . " ";

				array_push($c, $compiledlimitation);
				$j++;
			}

			$compilevalue = implode('', $c);
			$acl_plugins = $input['type'];

			$cha_upd = "update {$table_prefix}channel set  affiliateid=:affiliateid,name=:name,description=:description,compiledlimitation=:compiledlimitation,acl_plugins=:acl_plugins,comments=:comments where channelid=:channelid";

			$channel_edit = $this->db->prepare($cha_upd);
			$channel_edit->bindParam(":affiliateid", $sql_affiliateid);
			$channel_edit->bindParam(":name", $sql_name);
			$channel_edit->bindParam(":description", $sql_description);
			$channel_edit->bindParam(":compiledlimitation", $compiledlimitation);
			$channel_edit->bindParam(":acl_plugins", $sql_type);
			$channel_edit->bindParam(":comments", $sql_comments);
			$channel_edit->bindParam(":channelid", $channelid);
			$abc = $channel_edit->execute();


			$acls_cha_upd = "update {$table_prefix}acls_channel set  logical=:logical,type=:type,comparison=:comparison,data=:data where channelid=:channelid";


			$acls_edit = $this->db->prepare($acls_cha_upd);
			$acls_edit->bindParam(":logical", $sql_logical);
			$acls_edit->bindParam(":type", $sql_type);
			$acls_edit->bindParam(":comparison", $sql_comparison);
			$acls_edit->bindParam(":data", $sql_data);
			$acls_edit->bindParam(":channelid", $channelid);
			$update_cha = $acls_edit->execute();

			if ($update_cha) {
				$response = array('response' => 'Success', 'Message' => 'channel has been updated successfully!', 'status' => '200');
				return $this->response->withJson($response);
			}
		} else {
			$response = array('response' => 'error', 'Message' => 'Please enter the valid channelid', 'status' => '404');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('target_edit'));


$app->delete('/deletechannel/[{channelid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$channelid = $args['channelid'];
		$referchannel = "select * from  {$table_prefix}channel where channelid=:channelid";
		$djax_query_referchannel = $this->db->prepare($referchannel);
		$djax_query_referchannel->bindParam(":channelid", $channelid);
		$djax_query_referchannel->execute();

		$stmtchannel = $djax_query_referchannel->fetchAll();


		if (count($stmtchannel) > 0) {

			$deletechannel = "DELETE FROM  {$table_prefix}channel where channelid=:channelid";
			$djax_query_deletechannel = $this->db->prepare($deletechannel);
			$djax_query_deletechannel->bindParam(":channelid", $channelid);
			$djax_query_deletechannel->execute();


			$deleteacls = "DELETE FROM  {$table_prefix}acls_channel WHERE channelid=:channelid";
			$djax_query_deleteacls = $this->db->prepare($deleteacls);
			$djax_query_deleteacls->bindParam(":channelid", $channelid);
			$djax_query_deleteacls->execute();



			$response = array('response' => 'Success', 'Message' => 'Channel has been deleted successfully', 'status' => '200');
			return $this->response->withJson($response);
		} else {

			$response = array('response' => 'error', 'Message' => 'Please Enter the Valid Channel id', 'status' => '404');
			return $this->response->withJson($response);
		}
	}



	return $this->response->withJson($response);
});


$app->get('/gettargetingchannel/[{channelid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$channelid = $args['channelid'];
		$referchannel = "select * from {$table_prefix}channel where channelid=:channelid";
		$djax_query_referchannel = $this->db->prepare($referchannel);
		$djax_query_referchannel->bindParam(":channelid", $channelid);
		$djax_query_referchannel->execute();

		$stmtchannel = $djax_query_referchannel->fetchAll();

		$bannerchannel = array();

		if (count($stmtchannel) > 0) {

			$bannerchannel =
				array(
					'agencyid' => $stmtchannel[0]['agencyid'],
					'affiliateid' => $stmtchannel[0]['affiliateid'],
					'name' => $stmtchannel[0]['name'],
					'description' => $stmtchannel[0]['description'],
					'compiledlimitation' => $stmtchannel[0]['compiledlimitation'],
					'acl_plugins' => $stmtchannel[0]['acl_plugins'],
					'comments' => $stmtchannel[0]['comments']
				);
			$data['data'] = $bannerchannel;
            $data['response'] = "success";
		        $data['message'] = "Targetingchannel Data List";
		        $data['status'] = "200";

			$response = array('Target channel details' => $data);
		} else {

			$response = array('response' => 'error', 'Message' => 'Requested channelid doesnot found', 'status' => '404');
		}
		return $this->response->withJson($response);
	}
});

/*******************************Invocation Tag generation**********************************************************/



// Invocation Tag generation

//Asynchronous tag generation


/*
 * Asynchronous tag
 * 
 * Input Parameters:
 * --------------- 
 * thirdparty 
 * showpage
 * show
 * source
 * target 
 */

$app->post('/invoke_asy/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$sql = "select zoneid,width,height from " . $table_prefix . "zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();

		$input = $request->getParsedBody();
		$tparty = (isset($input['thirdparty'])) ? $input['thirdparty'] : '';
		$samepage = (isset($input['showpage'])) ? $input['showpage'] : '';
		$show = (isset($input['show'])) ? $input['show'] : '';
		$target = (isset($input['target'])) ? $input['target'] : '';
		$source = (isset($input['source'])) ? $input['source'] : '';

		if (!$zoneav) {
			$res = array(
				'response' => 'Error',
				'Message' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}
		//target validation

		if ($target == 1) {
			$b = "_blank";
		} else if ($target == 0) {
			$b = "_top";
		} else if ($target != 0 || $target != 1) {
			$b = "";
		}

		//third party validation
		if ($tparty == 0) {
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
		} else if ($tparty == 1) {

			$tparty = "%c";
		} else if ($tparty == 2) {

			$tparty = "%%c%%?";
		} else if ($tparty == 3) {

			$tparty = "{clickurl_enc}";
		} else {
			$tparty = "";
		}

		//source validation
		if ($source == $source) {

			$source = $source;
		} else {
			$source = "";
		}

		$full_url = $this->get('settings')['path']['delivery'];

		//~ $full_url=substr($full_url, 0, -9).'delivery';
		$d_c = '"';

		$mi = md5("{$this->get('settings')['path']['delivery']}*{$this->get('settings')['path']['deliverySSL']}");

		$asytag = '<ins data-revive-zoneid="' . $args['zoneid'] . '" data-revive-target="' . $b . '" data-revive-id="' . $mi . '"></ins><script async src="//' . $full_url . '/asyncjs.php"></script>';
		//$asyntag =stripslashes($asytag);

		$res = array(
			// 'response' => 'success',
			// 'statuscode' => '200',
			'async' => $asytag

		);

		return stripcslashes(json_encode($res));
		//return json_encode($res, JSON_UNESCAPED_SLASHES);    
		//return $this->response->withJson($res);

		//return $response;
	}
});



//Iframe tag generation


/*
 * Iframe tag
 * 
 * Input Parameters:
 * --------------- 
 * target 
 * thirdparty
 * source
 * refresh
 * transparency 
 * gtrack 
 * netscape 
 * cache 
 * comments 
 */


$app->post('/invoke_iframe/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$sql = "select zoneid,width,height from " . $table_prefix . "zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$input = $request->getParsedBody();
		$tparty = (isset($input['thirdparty'])) ? $input['thirdparty'] : '';
		$target = (isset($input['target'])) ? $input['target'] : '';
		$source = (isset($input['source'])) ? $input['source'] : '';
		$refresh = (isset($input['refresh'])) ? $input['refresh'] : '';
		$trans = (isset($input['transparency'])) ? $input['transparency'] : '';
		$netscape = (isset($input['netscape'])) ? $input['netscape'] : '';
		$gtrack = (isset($input['gtrack'])) ? $input['gtrack'] : '';
		$cache = (isset($input['cache'])) ? $input['cache'] : '';
		$cmnd = (isset($input['comments'])) ? $input['comments'] : '';
		$https_protocol = (isset($input['https_protocol'])) ? $input['https_protocol'] : '';
		// $ff = rand();
		$ff = 'a' . substr(md5(uniqid('', 1)), 0, 7);
		$fb = 'a' . substr(md5(uniqid('', 1)), 0, 7);
		if (!$zoneav) {
			$res = array(
				'response' => 'Error',
				'Message' => 'Zone is Not Avaliable',
				'status' => '404'

			);
			return $this->response->withJson($res);
		}
		//target validtaion
		if ($target == 1) {
			$target = "_blank";
		} elseif ($target == 0) {
			$target = "_top";
		} else {
			$target = "";
		}
		//third party validation
		if ($tparty == 0) {
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_ENCODED_CLICKURL_HERE";
		} else if ($tparty == 1) {

			$tparty = "%c";
			$cb = "%n";
		} else if ($tparty == 2) {

			$tparty = "%%c%%?";
			$cb = "%%RAND%%";
		} else if ($tparty == 3) {

			$tparty = "{clickurl_enc}";
			$cb = "(random)";
		} else {
			$tparty = "";
			$cb = "INSERT_ENCODED_CLICKURL_HERE";
		}

		//source validation
		if ($source == $source) {

			$source = $source;
		} else {
			$source = "";
		}
		//refresh validation

		if ($refresh == $refresh) {

			$refresh = $refresh;
		} else {
			$refresh = "";
		}
		if ($trans == 1) {
			$trans = "true";
		} else {
			$trans = "false";
		}

		if ($https_protocol) {
			$protocal = 'https';
		} else {
			$protocal = 'http';
		}

		// comments validation
		if ($cmnd == 1) {
			$cmnd = "<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
		  * a generated random number (or timestamp).
		  *
		  * If iFrames are not supported by the viewer's browser, then this
		  * tag only shows image banners. There is no width or height in these
		  * banners, so if you want these tags to allocate space for the ad
		  * before it shows, you will need to add this information to the <img>
		  * tag.
		  */-->";
		} else {
			$cmnd = "";
		}



		$full_url = $this->get('settings')['path']['delivery'];
		//~ $full_url=substr($full_url, 0, -5).'delivery'; "&amp;n=" . $ff .
		$d_c = '"';

		$iFrametag = "<!-- Revive Adserver iFrame Tag - Generated with Revive Adserver v5.4.1 -->" . $cmnd . "
			<iframe id='" . $ff . "' name='" . $ff . "' src='//" . $full_url . "/afr.php?zoneid=" . $args['zoneid'] . "&amp;source=" . $source . "&amp;target=" . $target . "&amp;cb=" . $cb . "' frameborder='0' scrolling='no' width='" . $zoneav[0]['width'] . "' height='" . $zoneav[0]['height'] . "' allowtransparency='" . $trans . "'>
			<a href='//" . $full_url . "/ck.php?n=" . $fb . "' target='" . $target . "'></a>
			<img src='//" . $full_url . "/avw.php?n=" . $fb . "&amp;zoneid=" . $args['zoneid'] . "&amp;source=" . $source . "&refresh=" . $refresh . "&amp;cb=" . $cb . "' border='0' alt='' /></a>
			</iframe>";
		$res = array(
			'response' => 'success',
			'status' => '200',
			'iframe' => $iFrametag

		);
		//return stripcslashes($this->response->withJson($res));
		//return $this->response->withJson($res);
		return stripcslashes(json_encode($res));
		//return $response;
	}
});


//javascript Invocation tag

/*
 * javascript tag
 * 
 * Input Parameters:
 * --------------- 
 * thirdparty 
 * samepage
 * show
 * target
 * source 
 * showtext 
 * setchar 
 * comments 
 */

$app->post('/invoke_javascript/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$sql = "select zoneid,width,height from " . $table_prefix . "zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$input = $request->getParsedBody();
		$tparty 			= (isset($input['thirdparty'])) ? $input['thirdparty'] : '';
		$samepage 			= (isset($input['samepage'])) ? $input['samepage'] : '';
		$show 			= (isset($input['show'])) ? $input['show'] : '';
		$target 			= (isset($input['target'])) ? $input['target'] : '';
		$source 			= (isset($input['source'])) ? $input['source'] : '';
		$showtext 			= (isset($input['showtext'])) ? $input['showtext'] : '';
		$setchar 			= (isset($input['setchar'])) ? $input['setchar'] : '';
		$cmnd 			= (isset($input['comments'])) ? $input['comments'] : '';

		if (!$zoneav) {
			$res = array(
				'response' => 'Error',
				'Message' => 'Zone is Not Avaliable',
				'status' => '404'

			);
			return $this->response->withJson($res);
		}
		// target validation
		if ($target == 1) {
			$target = "_blank";
		} else {
			$target = "_top";
		}
		//third party validation
		if ($tparty == 0) {
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_ENCODED_CLICKURL_HERE";
		} else if ($tparty == 1) {
			$tparty = "%c";
			$cb = "%n";
		} else if ($tparty == 2) {
			$tparty = "%%c%%?";
			$cb = "%%RAND%%";
		} else if ($tparty == 3) {

			$tparty = "{clickurl_enc}";
			$cb = "(random)";
		} else {
			$tparty = "";
			$cb = "INSERT_ENCODED_CLICKURL_HERE";
		}

		$full_url = $this->get('settings')['path']['delivery'];
		//~ $full_url=substr($full_url, 0, -5).'delivery';
		$d_c = '"';

		//Character set validation

		if ($setchar == 0) {
			$setchar = "";
		} else if ($setchar == 1) {
			$setchar = "ISO-8859-6";
		} else if ($setchar == 2) {
			$setchar = "Windows-1256";
		} else if ($setchar == 3) {
			$setchar = "ISO-8859-4";
		} else if ($setchar == 4) {
			$setchar = "Windows-1257";
		} else if ($setchar == 5) {
			$setchar = "ISO-8859-2";
		} else if ($setchar == 6) {
			$setchar = "Windows-1250";
		} else if ($setchar == 7) {
			$setchar = "GB18030";
		} else if ($setchar == 8) {
			$setchar = "GB2312";
		} else if ($setchar == 9) {
			$setchar = "HZ";
		} else if ($setchar == 10) {
			$setchar = "Big5";
		} else if ($setchar == 11) {
			$setchar = "ISO-8859-5";
		} else if ($setchar == 12) {
			$setchar = "KOI8-R";
		} else if ($setchar == 13) {
			$setchar = "Windows-1251";
		} else if ($setchar == 14) {
			$setchar = "ISO-8859-13";
		} else if ($setchar == 15) {
			$setchar = "ISO-8859-7";
		} else if ($setchar == 16) {
			$setchar = "Windows-1253";
		} else if ($setchar == 17) {
			$setchar = "ISO-8859-8-l";
		} else if ($setchar == 18) {
			$setchar = "ISO-8859-8";
		} else if ($setchar == 19) {
			$setchar = "Windows-1255";
		} else if ($setchar == 20) {
			$setchar = "EUC-JP";
		} else if ($setchar == 21) {
			$setchar = "Shift-JIS";
		} else if ($setchar == 22) {
			$setchar = "EUC-KR";
		} else if ($setchar == 23) {
			$setchar = "ISO-8859-15";
		} else if ($setchar == 24) {
			$setchar = "TIS-620";
		} else if ($setchar == 25) {
			$setchar = "ISO-8859-9";
		} else if ($setchar == 26) {
			$setchar = "Windows-1254";
		} else if ($setchar == 27) {
			$setchar = "UTF-8";
		} else if ($setchar == 28) {
			$setchar = "Windows-1258";
		} else if ($setchar == 29) {
			$setchar = "ISO-8859-1";
		} else if ($setchar == 30) {
			$setchar = "Windows-1252";
		}
		if ($cmnd == 0) {
			$cmnd = "";
		} else {
			$cmnd = "";
		}


		$a = '"text/javascript"';
		$x = '"&amp;charset=' . $setchar . '"';
		$y = '"&amp;loc="';
		$z = '"';
		$ff = rand();


		$javascripttag = " <!--/*
  *
  * Revive Adserver Javascript Tag
  * - Generated with Revive Adserver v4.0.2
  * - Doubleclick/DFP
  *
  */-->

" . $cmnd . "

<script type='text/javascript'><!--//

   var m3_u = (location.protocol=='https:'?'https://" . $full_url . "/ajs.php':'http://" . $full_url . "/ajs.php');
   var m3_r = Math.floor(Math.random()*99999999999);
   if (!document.MAX_used) document.MAX_used = ',';
   document.write ('<scr'+'ipt type=" . $a . " src=" . $z . "'+m3_u);
   document.write ('?zoneid=" . $args['zoneid'] . "&amp;source=" . $source . "&amp;target=" . $target . "&amp;charset=" . $setchar . "&amp;withtext=" . $showtext . "&amp;block=" . $samepage . "&amp;blockcampaign=" . $show . "');
   document.write ('&amp;cb=' + m3_r);
   if (document.MAX_used != ',') document.write ('&amp;exclude=' + document.MAX_used);
   document.write (" . $x . ");
   document.write (" . $y . " + escape(window.location));
   if (document.referrer) document.write ('&amp;referer=' + escape(document.referrer));
   if (document.context) document.write ('&context=' + escape(document.context));
   if ((typeof(document.MAX_ct0) != 'undefined') && (document.MAX_ct0.substring(0,4) == 'http')) {
       document.write ('&amp;ct0=' + escape(document.MAX_ct0));
   }
   if (document.mmm_fo) document.write ('&amp;mmm_fo=1');
   document.write ('" . $z . "><\/scr'+'ipt>');
//>--></script><noscript><a href='http://" . $full_url . "/ck.php?n=" . $ff . "&amp;cb=" . $cb . "' target='" . $target . "'><img src=" . $z . "http://" . $full_url . "/avw.php?zoneid=" . $args['zoneid'] . "&amp;source=" . $source . "&amp;charset=" . $setchar . "&amp;cb=" . $cb . "&amp;n=" . $ff . "&amp;ct0=" . $tparty . "" . $z . " border=" . $z . "0" . $z . " alt=" . $z . "" . $z . " /></a></noscript>


";
		$res = array(
			'response' => 'Success',
			'status' => '404',
			'Javascript Invocation Code' =>
			$javascripttag

		);
		return stripcslashes($this->response->withJson($res));

		return $response;
	}
});


// inline network video - Vast2 invocation tag

$app->post('/vast2_invocation/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$zoneid = $args['zoneid'];
		$sql = "select zoneid,width,height from " . $table_prefix . "zones WHERE delivery=6 and zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $zoneid);
		$sth->execute();
		$zoneav = $sth->fetchAll();


		$full_url = $this->get('settings')['path']['delivery'];

		if (!$zoneav) {
			$res = ['response' => 'error', 'Message' => 'Please enter valid Zone id', 'status' => '404'];
			return $this->response->withJson($res);
		}

		$full_url = $this->get('settings')['path']['delivery'];

		if ($_SERVER["HTTPS"] == "on") {
			$https = 'https';
		} else {
			$https = 'http';
		}

		$vast2_inline = "$https://$full_url/fc.php?script=apVideo:vast2&zoneid=$zoneid";

		$res = ['response' => 'tag', 'Vast2 Invocation tag' => $vast2_inline];

		return stripcslashes($this->response->withJson($res));
	}
});


//tracker image tag


$app->post('/track_imagetag/[{trackerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$value = "select * from {$table_prefix}trackers where trackerid=:trackerid";
		$tracker_data = $this->db->prepare($value);
		$tracker_data->bindParam(":trackerid", $trackerid);
		$tracker_data->execute();
		$stmt = $tracker_data->fetchAll();
		$full_url = $this->get('settings')['path']['delivery'];
		if (!$stmt) {
			$response = array('response' => 'Success', 'Message' => 'No Tracker exist with provided tracker id!', 'status' => '200');
			return $this->response->withJson($response);
		} else {
			$abb = "<!--/*
  *
  *  Revive Adserver Image Beacon Tracker Code
  *  - Generated with Revive Adserver v4.0.2
  *
  *  If this tag is being served on a secure (SSL) page, you must replace
  *  '" . $full_url . "...'
  * with
  *  '" . $full_url . "...'
  *
  *  To help prevent caching of this tracker beacon, if possible,
  *  Replace %%RANDOM_NUMBER%% with a randomly generated number (or timestamp)
  *
  *
  *  Place this code at the top of your thank-you page, just after the <body> tag.
  *
  */-->

<div id='m3_tracker_" . $trackerid . "' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='http://" . $full_url . "/ti.php?trackerid=" . $trackerid . "&amp;cb=%%RANDOM_NUMBER%%' width='0' height='0' alt='' /></div>
";
			$res = array(
				'response' => 'tag',
				'status' => '200',
				'Tracker image tag' => $abb


			);

			return stripcslashes($this->response->withJson($res));
		}
	}
})->add($container->get('tracker_edit'));


//tracker javascript tag


$app->post('/track_javascript/[{trackerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'Message' => 'Please check with input parameters', 'status' => '404');
		return $this->response->withJson($response);
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input    = $request->getParsedBody();
		$append = (isset($input['append'])) ? $input['append'] : '';
		$value = "select * from {$table_prefix}trackers where trackerid=:trackerid";
		$tracker_data = $this->db->prepare($value);
		$tracker_data->bindParam(":trackerid", $trackerid);
		$tracker_data->execute();
		$stmt = $tracker_data->fetchAll();
		$dc = '"';
		if ($append == 1) {
			$append = "1";
		} else {
			$append = "0";
		}

		$full_url = $this->get('settings')['path']['delivery'];
		if (!$stmt) {
			$response = array('response' => 'Error', 'Message' => 'No Tracker exist with provided tracker id!', 'status' => '404');
			return $this->response->withJson($response);
		} else {
			$abb = "<!--/*
  *
  *  Revive Adserver JavaScript Tracker Code
  *  - Generated with Revive Adserver v4.0.2
  *
  *  To help prevent caching of the <noscript> beacon, if possible,
  *  Replace %%RANDOM_NUMBER%% with a randomly generated number (or timestamp)
  *
  */-->

<!--/*
  *
  *  Place this code at the top of your thank-you page, just after the <body> tag,
  *  below any definitions of Javascript variables that need to be tracked.
  *
  */-->

<script type='text/javascript'><!--//<![CDATA[
    var p = (location.protocol=='https:'?'https://" . $full_url . "/tjs.php':'http://" . $full_url . "/tjs.php');

    var r=Math.floor(Math.random()*999999);
    document.write (" . $dc . "<" . $dc . " + " . $dc . "script language='JavaScript' " . $dc . ");
    document.write (" . $dc . "type='text/javascript' src='" . $dc . "+p);
    document.write (" . $dc . "?trackerid=" . $trackerid . "&amp;append=" . $append . "&amp;r=" . $dc . "+r+" . $dc . "'><" . $dc . " + " . $dc . "\/script>" . $dc . ");
//]]>--></script><noscript><div id='m3_tracker_" . $trackerid . "' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='http://" . $full_url . "/ti.php?trackerid=" . $trackerid . "&amp;cb=%%RANDOM_NUMBER%%' width='0' height='0' alt='' /></div></noscript>";
			$res = array(
				'response' => 'tag',
				'status' => '200',
				'Tracker javascript tag' => $abb


			);

			return stripcslashes($this->response->withJson($res));
		}
	}
})->add($container->get('tracker_edit'));




//VAST 

//vast video ads features
//inline third party vast video ads

$app->post('/advancedvast_add_banner_vastinline/[{campaign_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$campaignid = $args['campaign_id'];
		$datetime   = date('Y-m-d H:i:s');
		$paths = dirname(__FILE__);
		//~ $image_path = '../../www/images/';

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		//~ define('DIRECTORY', $image_path);
		$validation = "SELECT * FROM {$table_prefix}campaigns WHERE campaignid =:campaignid";

		$djax_query_validation = $this->db->prepare($validation);
		$djax_query_validation->bindParam(":campaignid", $campaignid);
		$djax_query_validation->execute();
		$stmtvalidation = $djax_query_validation->fetchAll();
		$valid = count($stmtvalidation);

		if (empty($input['width'])  && $input['width'] != '-3' || empty($input['height'])  && $input['height'] = '-3') {
			$response = array('response' => 'error', 'Message' => 'Please enter valid width or height', 'status' => '403');
			return $this->response->withJson($response);
		} else if ($valid && ($input['storagetype'] == 'html') && ($input['width'] == '-3') && ($input['height'] == '-3') && (($input['vast_video_delivery'] == '') || ($input['vast_video_delivery'] == 'progressive'))) {

			/////////////////////////////////////inline html/////////////////////////////////////////////
			//~ $storagetype = $input['storagetype'];
			$description 		= isset($input['description']) ? $input['description'] : '';
			$storagetype 		= isset($input['storagetype']) ? $input['storagetype'] : '';
			$vast_video_clickthrough_url = isset($input['vast_video_clickthrough_url']) ? $input['vast_video_clickthrough_url'] : '';
			$vast_wrapper_url = isset($input['vast_wrapper_url']) ? $input['vast_wrapper_url'] : '';

			$target 		= isset($input['target']) ? $input['target'] : '';
			$keyword 		= isset($input['keyword']) ? $input['keyword'] : '';
			$append 		= isset($input['append']) ? $input['append'] : '';
			$prepend 		= isset($input['prepend']) ? $input['prepend'] : '';
			$comments		= isset($input['comments']) ? $input['comments'] : '';
			$alt 			= isset($input['alt']) ? $input['alt'] : '';
			$statustext 	= isset($input['statustext']) ? $input['statustext'] : '';
			$bannertext 	= isset($input['bannertext']) ? $input['bannertext'] : '';
			$vid_upload_type 	= isset($input['vid_upload_type']) ? $input['vid_upload_type'] : '';
			$vast_type 	= isset($input['vast_type']) ? $input['vast_type'] : '';
			$vast_video_duration 	= isset($input['vast_video_duration']) ? $input['vast_video_duration'] : '';
			$vast_video_outgoing_filename 	= isset($input['vast_video_outgoing_filename']) ? $input['vast_video_outgoing_filename'] : '';
			$get_third_internal_type 	= isset($input['get_third_internal_type']) ? $input['get_third_internal_type'] : '';
			//~ $imageurl 		= isset($input['imageurl'])?$input['imageurl']:'';
			$vast_video_id 	= isset($input['vast_video_id']) ? $input['vast_video_id'] : null;
			//new

			$vast_video_type 		= isset($input['vast_video_type']) ? $input['vast_video_type'] : '';
			$vast_thirdparty_clicktracking 		= isset($input['vast_thirdparty_clicktracking']) ? $input['vast_thirdparty_clicktracking'] : '';
			$vast_thirdparty_clickcustom 		= isset($input['vast_thirdparty_clickcustom']) ? $input['vast_thirdparty_clickcustom'] : '';
			$vast_thirdparty_companion_expandedwidth = isset($input['vast_thirdparty_companion_expandedwidth']) ? $input['vast_thirdparty_companion_expandedwidth'] : '';
			$vast_thirdparty_companion_expandedheight = isset($input['vast_thirdparty_companion_expandedheight']) ? $input['vast_thirdparty_companion_expandedheight'] : '';
			$vast_thirdparty_companion_clicktracking = isset($input['vast_thirdparty_companion_clicktracking']) ? $input['vast_thirdparty_companion_clicktracking'] : '';
			$vast_video_skip_duration = isset($input['vast_video_skip_duration']) ? $input['vast_video_skip_duration'] : '';
			$vast_video_skip_progress_duration = isset($input['vast_video_skip_progress_duration']) ? $input['vast_video_skip_progress_duration'] : '';

			//end

			$vast_companion_banner_id 	= isset($input['vast_companion_banner_id']) ? $input['vast_companion_banner_id'] : null;
			$vast_thirdparty_impression = isset($input['vast_thirdparty_impression']) ? $input['vast_thirdparty_impression'] : null;
			$vast4_min_bitrate = isset($input['vast4_min_bitrate']) ? $input['vast4_min_bitrate'] : null;
			$vast4_max_bitrate = isset($input['vast4_max_bitrate']) ? $input['vast4_max_bitrate'] : null;
			$vast_thirdparty_companion_assetwidth = isset($input['vast_thirdparty_companion_assetwidth']) ? $input['vast_thirdparty_companion_assetwidth'] : null;
			$vast_thirdparty_companion_assetheight = isset($input['vast_thirdparty_companion_assetheight']) ? $input['vast_thirdparty_companion_assetheight'] : null;
			$vast_thirdparty_companion_pxratio = isset($input['vast_thirdparty_companion_pxratio']) ? $input['vast_thirdparty_companion_pxratio'] : null;
			$vast_thirdparty_companion_alttext = isset($input['vast_thirdparty_companion_alttext']) ? $input['vast_thirdparty_companion_alttext'] : null;
			$vast_wrapper_fallbacknoads = isset($input['vast_wrapper_fallbacknoads']) ? $input['vast_wrapper_fallbacknoads'] : null;
			$vast_wrapper_followadditional = isset($input['vast_wrapper_followadditional']) ? $input['vast_wrapper_followadditional'] : null;
			$vast_wrapper_allowmultipleads = isset($input['vast_wrapper_allowmultipleads']) ? $input['vast_wrapper_allowmultipleads'] : null;
			$icon_click_url = isset($input['icon_click_url']) ? $input['icon_click_url'] : null;
			$icon_track_url = isset($input['icon_track_url']) ? $input['icon_track_url'] : null;
			$vast_icon_filename = isset($input['vast_icon_filename']) ? $input['vast_icon_filename'] : null;
			$vast_icon_height = isset($input['vast_icon_height']) ? $input['vast_icon_height'] : null;
			$vast_icon_width = isset($input['vast_icon_width']) ? $input['vast_icon_width'] : null;
			$vast_icon_xposition = isset($input['vast_icon_xposition']) ? $input['vast_icon_xposition'] : null;
			$vast_icon_yposition = isset($input['vast_icon_yposition']) ? $input['vast_icon_yposition'] : null;
			$vast_icon_duration = isset($input['vast_icon_duration']) ? $input['vast_icon_duration'] : null;
			$vast_icon_offset = isset($input['vast_icon_offset']) ? $input['vast_icon_offset'] : null;
			$ad_type = isset($input['ad_type']) ? $input['ad_type'] : null;
			$vast_video_outgoing_filename1 = isset($input['vast_video_outgoing_filename1']) ? $input['vast_video_outgoing_filename1'] : null;
			$vast_video_bitrate_1 = isset($input['vast_video_bitrate_1']) ? $input['vast_video_bitrate_1'] : null;
			$vast_video_type_1 = isset($input['vast_video_type_1']) ? $input['vast_video_type_1'] : null;
			$vast_video_outgoing_filename2 = isset($input['vast_video_outgoing_filename2']) ? $input['vast_video_outgoing_filename2'] : null;
			$vast_video_bitrate_2 = isset($input['vast_video_bitrate_2']) ? $input['vast_video_bitrate_2'] : null;
			$vast_video_type_2 = isset($input['vast_video_type_2']) ? $input['vast_video_type_2'] : null;
			$is_mezzininefile = isset($input['is_mezzininefile']) ? $input['is_mezzininefile'] : null;
			$mezzanine_en = isset($input['mezzanine_en']) ? $input['mezzanine_en'] : null;
			$url_file = isset($input['url_file']) ? $input['url_file'] : null;
			$internal_file = isset($input['internal_file']) ? $input['internal_file'] : null;
			$vast_4_1_url = isset($input['vast_4_1_url']) ? $input['vast_4_1_url'] : null;
			$vast_4_1_type_file = isset($input['vast_4_1_type_file']) ? $input['vast_4_1_type_file'] : null;
			$vast_4_1_language = isset($input['vast_4_1_language']) ? $input['vast_4_1_language'] : null;
			$vast_4_1_url_1 = isset($input['vast_4_1_url_1']) ? $input['vast_4_1_url_1'] : null;
			$vast_4_1_type_file_1 = isset($input['vast_4_1_type_file_1']) ? $input['vast_4_1_type_file_1'] : null;
			$vast_4_1_language_1 = isset($input['vast_4_1_language_1']) ? $input['vast_4_1_language_1'] : null;
			$vast_4_1_url_2 = isset($input['vast_4_1_url_2']) ? $input['vast_4_1_url_2'] : null;
			$vast_4_1_type_file_2 = isset($input['vast_4_1_type_file_2']) ? $input['vast_4_1_type_file_2'] : null;
			$vast_4_1_language_2 = isset($input['vast_4_1_language_2']) ? $input['vast_4_1_language_2'] : null;
			$interactive_mediafile = isset($input['interactive_mediafile']) ? $input['interactive_mediafile'] : null;

			$banner_list = "select * from " . $table_prefix . "banners where campaignid=:campaignid";
			$allbanners_det = $this->db->prepare($banner_list);
			$allbanners_det->bindParam(":campaignid", $campaignid);
			$allbanners_det->execute();
			$details = $allbanners_det->fetchAll();
			$num = count($details);
			$bannerdetails = array();
			if ($num > 0) {
				if (isset($vast_companion_banner_id)) {
					foreach ($details as $banner) {
						$bannerdetails[$banner['bannerid']] = array(
							'campaignid' => $banner['campaignid'],
							'bannerid' => $banner['bannerid']
						);
						if ($vast_companion_banner_id == ($bannerdetails[$banner['bannerid']]['bannerid'])) {
							$flag = 1;
							break;
						} else {
							$flag = 2;
						}
					}
					if ($flag == 2) {
						$response = array('response' => 'error', 'Message' => 'Please enter valid banner id','status' => '403');
						return $this->response->withJson($response);
					}
				}
			}

			if ($get_third_internal_type == 1) {
				$vast_video_delivery = isset($input['vast_video_delivery']) ? $input['vast_video_delivery'] : null;
				if (empty($vast_video_delivery) && ($get_third_internal_type == 1)) {
					$response = array('response' => 'error', 'Message' => 'Please enter Video delivery method','status' => '403');
					return $this->response->withJson($response);
				}
			} else {
				$vast_video_delivery = isset($input['vast_video_delivery']) ? $input['vast_video_delivery'] : null;
				$vast_wrapper_url = isset($input['vast_wrapper_url']) ? $input['vast_wrapper_url'] : '';
				//url validation
				if (!empty($vast_wrapper_url) && !filter_var($vast_wrapper_url, FILTER_VALIDATE_URL)) {

					echo ("Given third party url  is not a valid URL" . "<br>" . "please make sure your vast wrapper url(third party url) contains http:// or https://");
					exit;
				}
				if (isset($vast_video_delivery) && ($get_third_internal_type == 2)) {
					$response = array('response' => 'error', 'Message' => 'Please Check input parameter','status' => '403') ;

					return $this->response->withJson($response);
				}
			}

			$var = array();
			$var  = array(
				"banner_vast_element_id" => 'banner_vast_element_id',
				"vid_upload_type" => $vid_upload_type,
				"vast_element_type" => 'singlerow',
				"vast_type" => $vast_type,
				"vast_video_id" => 'N',
				"vast_video_duration" => $vast_video_duration,
				"vast_video_delivery" => $vast_video_delivery,
				"get_third_internal_type" => $get_third_internal_type,
				"vast_video_type" => $vast_video_type,
				"vast_video_outgoing_filename" => $vast_video_outgoing_filename,
				"vast_video_bitrate" => 400,
				"vast_video_height" => 480,
				"vast_video_width" => 640,
				"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
				"vast_thirdparty_clickcustom" => $vast_thirdparty_clickcustom,
				"vast_thirdparty_clicktracking" => $vast_thirdparty_clicktracking,
				"vast_thirdparty_companion_expandedwidth" => $vast_thirdparty_companion_expandedwidth,
				"vast_thirdparty_companion_expandedheight" => $vast_thirdparty_companion_expandedheight,
				"vast_wrapper_url" => $vast_wrapper_url,
				"vast_thirdparty_companion_clicktracking" => $vast_thirdparty_companion_clicktracking,
				"vast_video_skip_duration" => $vast_video_skip_duration,
				"vast_video_skip_progress_duration" => $vast_video_skip_progress_duration,
				"vast_overlay_height" => 'N',
				"vast_overlay_width" => 'N',
				"vast_overlay_text_title" => 'N',
				"vast_overlay_text_description" => 'N',
				"vast_overlay_text_call" => 'N',
				"vast_overlay_format" => 'N',
				"vast_overlay_action" => 'N',
				"vast_creative_type" => 'N',
				"vast_thirdparty_impression" => $vast_thirdparty_impression,
				"vast4_min_bitrate" => $vast4_min_bitrate,
				"vast4_max_bitrate" => $vast4_max_bitrate,
				"vast_companion_banner_id" => $vast_companion_banner_id,
				"vast_thirdparty_companion_assetwidth" => $vast_thirdparty_companion_assetwidth,
				"vast_thirdparty_companion_assetheight" => $vast_thirdparty_companion_assetheight,
				"vast_thirdparty_companion_pxratio" => $vast_thirdparty_companion_pxratio,
				"vast_thirdparty_companion_alttext" => $vast_thirdparty_companion_alttext,
				"vast_wrapper_fallbacknoads" => $vast_wrapper_fallbacknoads,
				"vast_wrapper_followadditional" => $vast_wrapper_followadditional,
				"vast_wrapper_allowmultipleads" => $vast_wrapper_allowmultipleads,
				"icon_click_url" => $icon_click_url,
				"icon_track_url" => $icon_track_url,
				"vast_icon_filename" => $vast_icon_filename,
				"vast_icon_height" => $vast_icon_height,
				"vast_icon_width" => $vast_icon_width,
				"vast_icon_xposition" => $vast_icon_xposition,
				"vast_icon_yposition" => $vast_icon_yposition,
				"vast_icon_duration" => $vast_icon_duration,
				"vast_icon_offset" => $vast_icon_offset,
				"ad_type" => $ad_type,
				"vast_video_outgoing_filename1" => $vast_video_outgoing_filename1,
				"vast_video_bitrate_1" => $vast_video_bitrate_1,
				"vast_video_type_1" => $vast_video_type_1,
				"vast_video_outgoing_filename2" => $vast_video_outgoing_filename2,
				"vast_video_bitrate_2" => $vast_video_bitrate_2,
				"vast_video_type_2" => $vast_video_type_2,
				"is_mezzininefile" => $is_mezzininefile,
				"mezzanine_en" => $mezzanine_en,
				"url_file" => $url_file,
				"internal_file" => $internal_file,
				"vast_4_1_url" => $vast_4_1_url,
				"vast_4_1_type_file" => $vast_4_1_type_file,
				"vast_4_1_language" => $vast_4_1_language,
				"vast_4_1_url_1" => $vast_4_1_url_1,
				"vast_4_1_type_file_1" => $vast_4_1_type_file_1,
				"vast_4_1_language_1" => $vast_4_1_language_1,
				"vast_4_1_url_2" => $vast_4_1_url_2,
				"vast_4_1_type_file_2" => $vast_4_1_type_file_2,
				"vast_4_1_language_2" => $vast_4_1_language_2,
				"interactive_mediafile" => $interactive_mediafile
			);

			$addbanner = "INSERT INTO " . $table_prefix . "banners(
				   campaignid,
				   storagetype,
				   width,
				   height,
				   weight,
				   description,
				   comments,
				   updated,
				   keyword,
				   append,
				   prepend,
				   parameters,
				   ext_bannertype)  VALUES (
				   :campaignid,
				   :storagetype,
				   -3,
				   -3,
				   1,
				   :description,
				   :comments,
				   :updated,
				   :keyword,
				   '" . $append . "',
				    '" . $prepend . "',
				   :parameters,
				   'bannerTypeHtml:djaxvastInlineBannerTypeHtml:vastInlineHtml')";

			$parameter = serialize($var);
			if (empty($parameter)) {
				$parameter = 'N;';
			}

			$djax_query_banners = $this->db->prepare($addbanner);
			$djax_query_banners->bindParam(":campaignid", $campaignid);
			$djax_query_banners->bindParam(":storagetype", $storagetype);
			$djax_query_banners->bindParam(":description", $description);
			$djax_query_banners->bindParam(":comments", $comments);
			$djax_query_banners->bindParam(":updated", $datetime);
			$djax_query_banners->bindParam(":keyword", $keyword);
			$djax_query_banners->bindParam(":parameters", $parameter);
			$djax_query_banners->execute();
			$bannerid = $this->db->lastInsertId();

			//auto increment

			$get_banner_id = "select * from djaxbanner_vast_element_seq";
			$query_banner_vast_id = $this->db->prepare($get_banner_id);
			$query_banner_vast_id->execute();
			$banner_vast_id = $query_banner_vast_id->fetchAll();

			if (count($banner_vast_id) > 0) {
				$a = $banner_vast_id[0]['id'];
				$banner_vast_element_id = $a + 1;
			} else {
				$banner_vast_element_id = 1;
			}

			$vast_element_type = 'singlerow';
			$vast_video_bitrate = 400;
			$vast_video_height = 480;
			$vast_video_width = 640;

			$addparameters = "insert into " . $table_prefix . "djaxbanner_vast_element(
			banner_vast_element_id,
			banner_id,
			vid_upload_type,
			vast_element_type,
			vast_video_id,
			vast_video_duration,
			vast_video_delivery,
			vast_video_type,
			vast_video_outgoing_filename,
			vast_video_bitrate,
			vast_video_height,
			vast_video_width,
			vast_companion_banner_id,
			vast_overlay_height,
			vast_overlay_width,
			vast_video_clickthrough_url,
			vast_overlay_text_title,
			vast_overlay_text_description,
			vast_overlay_text_call,
			vast_creative_type,
			vast_wrapper_url,
			vast_video_skip_duration,
			vast_video_skip_progress_duration,
			vast_type,
			get_third_internal_type,
			vast_thirdparty_clicktracking,
			vast_thirdparty_clickcustom,
			vast_thirdparty_companion_clicktracking,
			vast_thirdparty_companion_expandedwidth,
			vast_thirdparty_companion_expandedheight,
			vast_thirdparty_impression,
			vast4_min_bitrate,
			vast4_max_bitrate,
			vast_thirdparty_companion_assetwidth,
			vast_thirdparty_companion_assetheight,
			vast_thirdparty_companion_pxratio,
			vast_thirdparty_companion_alttext,
			vast_wrapper_fallbacknoads,
			vast_wrapper_followadditional,
			vast_wrapper_allowmultipleads,
			icon_click_url,
			icon_track_url,
			vast_icon_filename,
			vast_icon_height,
			vast_icon_width,
			vast_icon_xposition,
			vast_icon_yposition,
			vast_icon_duration,
			vast_icon_offset,
			ad_type,
			vast_video_outgoing_filename1,
			vast_video_bitrate_1,
			vast_video_type_1,
			vast_video_outgoing_filename2,
			vast_video_bitrate_2,
			vast_video_type_2,
			is_mezzininefile,
			mezzanine_en,
			url_file,
			internal_file,
			vast_4_1_url,
			vast_4_1_type_file,
			vast_4_1_language,
			vast_4_1_url_1,
			vast_4_1_type_file_1,
			vast_4_1_language_1,
			vast_4_1_url_2,
			vast_4_1_type_file_2,
			vast_4_1_language_2,
			interactive_mediafile
			)
			values(
			:banner_vast_element_id,
			:banner_id,
			:vid_upload_type,
			:vast_element_type,
			:vast_video_id,
			:vast_video_duration,
			:vast_video_delivery,
			:vast_video_type,
			:vast_video_outgoing_filename,
			:vast_video_bitrate,
			:vast_video_height,
			:vast_video_width,
			:vast_companion_banner_id,
			:vast_overlay_height,
			:vast_overlay_width,
			:vast_video_clickthrough_url,
			:vast_overlay_text_title,
			:vast_overlay_text_description,
			:vast_overlay_text_call,
			:vast_creative_type,
			'" . $vast_wrapper_url . "',
			'" . $vast_video_skip_duration . "',
			'" . $vast_video_skip_progress_duration . "',
			'" . $vast_type . "',
			'" . $get_third_internal_type . "',
			'" . $vast_thirdparty_clicktracking . "',
			'" . $vast_thirdparty_clickcustom . "',
			'" . $vast_thirdparty_companion_clicktracking . "',
			'" . $vast_thirdparty_companion_expandedwidth . "',
			'" . $vast_thirdparty_companion_expandedheight . "',
			:vast_thirdparty_impression,
			:vast4_min_bitrate,
			:vast4_max_bitrate,
			:vast_thirdparty_companion_assetwidth,
			:vast_thirdparty_companion_assetheight,
			:vast_thirdparty_companion_pxratio,
			:vast_thirdparty_companion_alttext,
			:vast_wrapper_fallbacknoads,
			:vast_wrapper_followadditional,
			:vast_wrapper_allowmultipleads,
			:icon_click_url,
			:icon_track_url,
			:vast_icon_filename,
			:vast_icon_height,
			:vast_icon_width,
			:vast_icon_xposition,
			:vast_icon_yposition,
			:vast_icon_duration,
			:vast_icon_offset,
			:ad_type,
			:vast_video_outgoing_filename1,
			:vast_video_bitrate_1,
			:vast_video_type_1,
			:vast_video_outgoing_filename2,
			:vast_video_bitrate_2,
			:vast_video_type_2,
			:is_mezzininefile,
			:mezzanine_en,
			:url_file,
			:internal_file,
			:vast_4_1_url,
			:vast_4_1_type_file,
			:vast_4_1_language,
			:vast_4_1_url_1,
			:vast_4_1_type_file_1,
			:vast_4_1_language_1,
			:vast_4_1_url_2,
			:vast_4_1_type_file_2,
			:vast_4_1_language_2,
			:interactive_mediafile
			)";

			$djax_query_banners_parameters = $this->db->prepare($addparameters);

			$djax_query_banners_parameters->bindParam(":banner_vast_element_id", $banner_vast_element_id);
			$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);
			$djax_query_banners_parameters->bindParam(":vid_upload_type", $vid_upload_type);

			$djax_query_banners_parameters->bindParam(":vast_element_type", $vast_element_type);
			$djax_query_banners_parameters->bindParam(":vast_video_id", $vast_video_id);
			$djax_query_banners_parameters->bindParam(":vast_video_duration", $vast_video_duration);
			$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename", $vast_video_outgoing_filename);
			$djax_query_banners_parameters->bindParam(":vast_video_delivery", $vast_video_delivery);

			$djax_query_banners_parameters->bindParam(":vast_video_type", $vast_video_type);
			$djax_query_banners_parameters->bindParam(":vast_video_bitrate", $vast_video_bitrate);
			$djax_query_banners_parameters->bindParam(":vast_video_height", $vast_video_height);
			$djax_query_banners_parameters->bindParam(":vast_video_width", $vast_video_width);
			$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
			$djax_query_banners_parameters->bindParam(":vast_overlay_height", $vast_overlay_height);
			$djax_query_banners_parameters->bindParam(":vast_overlay_width", $vast_overlay_width);
			$djax_query_banners_parameters->bindParam(":vast_video_clickthrough_url", $vast_video_clickthrough_url);
			$djax_query_banners_parameters->bindParam(":vast_overlay_text_title", $vast_overlay_text_title);
			$djax_query_banners_parameters->bindParam(":vast_overlay_text_description", $vast_overlay_text_description);
			$djax_query_banners_parameters->bindParam(":vast_overlay_text_call", $vast_overlay_text_call);

			$djax_query_banners_parameters->bindParam(":vast_creative_type", $vast_creative_type);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_impression", $vast_thirdparty_impression);

			$djax_query_banners_parameters->bindParam(":vast4_min_bitrate", $vast4_min_bitrate);
			$djax_query_banners_parameters->bindParam(":vast4_max_bitrate", $vast4_max_bitrate);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_companion_assetwidth", $vast_thirdparty_companion_assetwidth);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_companion_assetheight", $vast_thirdparty_companion_assetheight);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_companion_pxratio", $vast_thirdparty_companion_pxratio);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_companion_alttext", $vast_thirdparty_companion_alttext);
			$djax_query_banners_parameters->bindParam(":vast_wrapper_fallbacknoads", $vast_wrapper_fallbacknoads);
			$djax_query_banners_parameters->bindParam(":vast_wrapper_followadditional", $vast_wrapper_followadditional);
			$djax_query_banners_parameters->bindParam(":vast_wrapper_allowmultipleads", $vast_wrapper_allowmultipleads);
			$djax_query_banners_parameters->bindParam(":icon_click_url", $icon_click_url);
			$djax_query_banners_parameters->bindParam(":icon_track_url", $icon_track_url);
			$djax_query_banners_parameters->bindParam(":vast_icon_filename", $vast_icon_filename);
			$djax_query_banners_parameters->bindParam(":vast_icon_height", $vast_icon_height);
			$djax_query_banners_parameters->bindParam(":vast_icon_width", $vast_icon_width);
			$djax_query_banners_parameters->bindParam(":vast_icon_xposition", $vast_icon_xposition);
			$djax_query_banners_parameters->bindParam(":vast_icon_yposition", $vast_icon_yposition);
			$djax_query_banners_parameters->bindParam(":vast_icon_duration", $vast_icon_duration);
			$djax_query_banners_parameters->bindParam(":vast_icon_offset", $vast_icon_offset);
			$djax_query_banners_parameters->bindParam(":ad_type", $ad_type);
			$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename1", $vast_video_outgoing_filename1);
			$djax_query_banners_parameters->bindParam(":vast_video_bitrate_1", $vast_video_bitrate_1);
			$djax_query_banners_parameters->bindParam(":vast_video_type_1", $vast_video_type_1);
			$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename2", $vast_video_outgoing_filename2);
			$djax_query_banners_parameters->bindParam(":vast_video_bitrate_2", $vast_video_bitrate_2);
			$djax_query_banners_parameters->bindParam(":vast_video_type_2", $vast_video_type_2);
			$djax_query_banners_parameters->bindParam(":is_mezzininefile", $is_mezzininefile);
			$djax_query_banners_parameters->bindParam(":mezzanine_en", $mezzanine_en);
			$djax_query_banners_parameters->bindParam(":url_file", $url_file);
			$djax_query_banners_parameters->bindParam(":internal_file", $internal_file);
			$djax_query_banners_parameters->bindParam(":vast_4_1_url", $vast_4_1_url);
			$djax_query_banners_parameters->bindParam(":vast_4_1_type_file", $vast_4_1_type_file);
			$djax_query_banners_parameters->bindParam(":vast_4_1_language", $vast_4_1_language);
			$djax_query_banners_parameters->bindParam(":vast_4_1_url_1", $vast_4_1_url_1);
			$djax_query_banners_parameters->bindParam(":vast_4_1_type_file_1", $vast_4_1_type_file_1);
			$djax_query_banners_parameters->bindParam(":vast_4_1_language_1", $vast_4_1_language_1);
			$djax_query_banners_parameters->bindParam(":vast_4_1_url_2", $vast_4_1_url_2);
			$djax_query_banners_parameters->bindParam(":vast_4_1_type_file_2", $vast_4_1_type_file_2);
			$djax_query_banners_parameters->bindParam(":vast_4_1_language_2", $vast_4_1_language_2);
			$djax_query_banners_parameters->bindParam(":interactive_mediafile", $interactive_mediafile);
			$djax_query_banners_parameters->execute();

			$addelement_id = "update djaxbanner_vast_element_seq set id=:banner_vast_element_id;";
			$djax_query_banners_elements = $this->db->prepare($addelement_id);
			$djax_query_banners_elements->bindParam(":banner_vast_element_id", $banner_vast_element_id);
			$djax_query_banners_elements->execute();

			$response = array('response' => 'ok', 'bannerid' => $bannerid, 'Message' => 'Inline Banner added successfully!','status' => '200');
			return $this->response->withJson($response);
		} else {
			$response = array('response' => 'error', 'Message' => 'Please enter valid Campaignid','status' => '403');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('banneraddvastinline_val'));


$app->post('/advancedvast_edit_banner_vastinline/[{banner_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$bannerid = $args['banner_id'];
		$datetime   = date('Y-m-d H:i:s');
		$paths = dirname(__FILE__);
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$getbanners = "select * from " . $table_prefix . "banners where bannerid=:bannerid";
		$djax_query_banner = $this->db->prepare($getbanners);
		$djax_query_banner->bindParam(":bannerid", $bannerid);
		$djax_query_banner->execute();
		$stmtbanner = $djax_query_banner->fetchAll();

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		//new
		if (count($stmtbanner) > 0) {
			if (isset($input['storagetype'])) {
				$storagetype = $input['storagetype'];
			} else {
				$storagetype = $stmtbanner[0]['storagetype'];
			}

			if (isset($input['contenttype'])) {
				$contenttype = $input['contenttype'];
			} else {
				$contenttype = $stmtbanner[0]['contenttype'];
			}

			if (isset($input['description'])) {
				$description = $input['description'];
			} else {
				$description = $stmtbanner[0]['description'];
			}


			if (isset($input['keyword'])) {
				$keyword = $input['keyword'];
			} else {
				$keyword = $stmtbanner[0]['keyword'];
			}

			if (isset($input['append'])) {
				$append = $input['append'];
			} else {
				$append = $stmtbanner[0]['append'];
			}
			if (isset($input['prepend'])) {
				$prepend = $input['prepend'];
			} else {
				$prepend = $stmtbanner[0]['prepend'];
			}

			if (isset($input['comments'])) {
				$comments = $input['comments'];
			} else {
				$comments = $stmtbanner[0]['comments'];
			}

			//end
			if (empty($input['width'])  && $input['width'] != '-3' || empty($input['height'])  && $input['height'] = '-3') {
				$response = array('response' => 'error', 'Message' => 'Please enter valid width or height','status' => '403');
				return $this->response->withJson($response);
			}

			$dbparameters = $stmtbanner[0]['parameters'];
			$unparameters = unserialize($dbparameters);

			if (isset($input['vast_video_clickthrough_url'])) {
				$vast_video_clickthrough_url = $input['vast_video_clickthrough_url'];
			} else {
				$vast_video_clickthrough_url = $unparameters['vast_video_clickthrough_url'];
			}

			if (isset($input['vast_thirdparty_clicktracking'])) {
				$vast_thirdparty_clicktracking = $input['vast_thirdparty_clicktracking'];
			} else {
				$vast_thirdparty_clicktracking = $unparameters['vast_thirdparty_clicktracking'];
			}

			if (isset($input['vast_thirdparty_clickcustom'])) {
				$vast_thirdparty_clickcustom = $input['vast_thirdparty_clickcustom'];
			} else {
				$vast_thirdparty_clickcustom = $unparameters['vast_thirdparty_clickcustom'];
			}

			if (isset($input['vast_thirdparty_companion_expandedwidth'])) {
				$vast_thirdparty_companion_expandedwidth = $input['vast_thirdparty_companion_expandedwidth'];
			} else {
				$vast_thirdparty_companion_expandedwidth = $unparameters['vast_thirdparty_companion_expandedwidth'];
			}

			if (isset($input['vast_video_delivery'])) {
				$vast_video_delivery = $input['vast_video_delivery'];
			} else {
				$vast_video_delivery = $unparameters['vast_video_delivery'];
			}

			if (isset($input['vast_thirdparty_companion_expandedheight'])) {
				$vast_thirdparty_companion_expandedheight = $input['vast_thirdparty_companion_expandedheight'];
			} else {
				$vast_thirdparty_companion_expandedheight = $unparameters['vast_thirdparty_companion_expandedheight'];
			}

			if (isset($input['vast_companion_banner_id'])) {
				$vast_companion_banner_id = $input['vast_companion_banner_id'];
			} else {
				$vast_companion_banner_id = $unparameters['vast_companion_banner_id'];
			}

			if (isset($input['vast_thirdparty_impression'])) {
				$vast_thirdparty_impression = $input['vast_thirdparty_impression'];
			} else {
				$vast_thirdparty_impression = $unparameters['vast_thirdparty_impression'];
			}

			if (isset($input['vast_thirdparty_companion_clicktracking'])) {
				$vast_thirdparty_companion_clicktracking = $input['vast_thirdparty_companion_clicktracking'];
			} else {
				$vast_thirdparty_companion_clicktracking = $unparameters['vast_thirdparty_companion_clicktracking'];
			}

			if (isset($input['vast_wrapper_url'])) {
				$vast_wrapper_url = $input['vast_wrapper_url'];
			} else {
				$vast_wrapper_url = $unparameters['vast_wrapper_url'];
			}

			if (isset($input['vast_type'])) {
				$vast_type = $input['vast_type'];
			} else {
				$vast_type = $unparameters['vast_type'];
			}

			if (isset($input['vast_video_skip_duration'])) {
				$vast_video_skip_duration = $input['vast_video_skip_duration'];
			} else {
				$vast_video_skip_duration = $unparameters['vast_video_skip_duration'];
			}
			if (isset($input['vast_video_skip_progress_duration'])) {
				$vast_video_skip_progress_duration = $input['vast_video_skip_progress_duration'];
			} else {
				$vast_video_skip_progress_duration = $unparameters['vast_video_skip_progress_duration'];
			}

			if (isset($input['get_third_internal_type'])) {
				$get_third_internal_type = $input['get_third_internal_type'];
			} else {
				$get_third_internal_type = $unparameters['get_third_internal_type'];
			}
			$vid_upload_type = isset($input['vid_upload_type']) ? $input['vid_upload_type'] : $unparameters['vid_upload_type'];
			$vast_video_outgoing_filename = isset($input['vast_video_outgoing_filename']) ? $input['vast_video_outgoing_filename'] : $unparameters['vast_video_outgoing_filename'];
			$vast4_min_bitrate = isset($input['vast4_min_bitrate']) ? $input['vast4_min_bitrate'] : $unparameters['vast4_min_bitrate'];

			$vast4_max_bitrate = isset($input['vast4_max_bitrate']) ? $input['vast4_max_bitrate'] : $unparameters['vast4_max_bitrate'];
			$vast_thirdparty_companion_assetwidth = isset($input['vast_thirdparty_companion_assetwidth']) ? $input['vast_thirdparty_companion_assetwidth'] : $unparameters['vast_thirdparty_companion_assetwidth'];
			$vast_thirdparty_companion_assetheight = isset($input['vast_thirdparty_companion_assetheight']) ? $input['vast_thirdparty_companion_assetheight'] : $unparameters['vast_thirdparty_companion_assetheight'];
			$vast_thirdparty_companion_pxratio = isset($input['vast_thirdparty_companion_pxratio']) ? $input['vast_thirdparty_companion_pxratio'] : $unparameters['vast_thirdparty_companion_pxratio'];
			$vast_thirdparty_companion_alttext = isset($input['vast_thirdparty_companion_alttext']) ? $input['vast_thirdparty_companion_alttext'] : $unparameters['vast_thirdparty_companion_alttext'];
			$vast_wrapper_fallbacknoads = isset($input['vast_wrapper_fallbacknoads']) ? $input['vast_wrapper_fallbacknoads'] : $unparameters['vast_wrapper_fallbacknoads'];
			$vast_wrapper_followadditional = isset($input['vast_wrapper_followadditional']) ? $input['vast_wrapper_followadditional'] : $unparameters['vast_wrapper_followadditional'];
			$vast_wrapper_allowmultipleads = isset($input['vast_wrapper_allowmultipleads']) ? $input['vast_wrapper_allowmultipleads'] : $unparameters['vast_wrapper_allowmultipleads'];
			$icon_click_url = isset($input['icon_click_url']) ? $input['icon_click_url'] : $unparameters['icon_click_url'];
			$icon_track_url = isset($input['icon_track_url']) ? $input['icon_track_url'] : $unparameters['icon_track_url'];
			$vast_icon_filename = isset($input['vast_icon_filename']) ? $input['vast_icon_filename'] : $unparameters['vast_icon_filename'];
			$vast_icon_height = isset($input['vast_icon_height']) ? $input['vast_icon_height'] : $unparameters['vast_icon_height'];
			$vast_icon_width = isset($input['vast_icon_width']) ? $input['vast_icon_width'] : $unparameters['vast_icon_width'];
			$vast_icon_xposition = isset($input['vast_icon_xposition']) ? $input['vast_icon_xposition'] : $unparameters['vast_icon_xposition'];
			$vast_icon_yposition = isset($input['vast_icon_yposition']) ? $input['vast_icon_yposition'] : $unparameters['vast_icon_yposition'];
			$vast_icon_duration = isset($input['vast_icon_duration']) ? $input['vast_icon_duration'] : $unparameters['vast_icon_duration'];
			$vast_icon_offset = isset($input['vast_icon_offset']) ? $input['vast_icon_offset'] : $unparameters['vast_icon_offset'];
			$ad_type = isset($input['ad_type']) ? $input['ad_type'] : $unparameters['ad_type'];
			$vast_video_outgoing_filename1 = isset($input['vast_video_outgoing_filename1']) ? $input['vast_video_outgoing_filename1'] : $unparameters['vast_video_outgoing_filename1'];
			$vast_video_bitrate_1 = isset($input['vast_video_bitrate_1']) ? $input['vast_video_bitrate_1'] : $unparameters['vast_video_bitrate_1'];
			$vast_video_type_1 = isset($input['vast_video_type_1']) ? $input['vast_video_type_1'] : $unparameters['vast_video_type_1'];
			$vast_video_outgoing_filename2 = isset($input['vast_video_outgoing_filename2']) ? $input['vast_video_outgoing_filename2'] : $unparameters['vast_video_outgoing_filename2'];
			$vast_video_bitrate_2 = isset($input['vast_video_bitrate_2']) ? $input['vast_video_bitrate_2'] : $unparameters['vast_video_bitrate_2'];
			$vast_video_type_2 = isset($input['vast_video_type_2']) ? $input['vast_video_type_2'] : $unparameters['vast_video_type_2'];
			$is_mezzininefile = isset($input['is_mezzininefile']) ? $input['is_mezzininefile'] : $unparameters['is_mezzininefile'];
			$mezzanine_en = isset($input['mezzanine_en']) ? $input['mezzanine_en'] : $unparameters['mezzanine_en'];
			$url_file = isset($input['url_file']) ? $input['url_file'] : $unparameters['url_file'];
			$internal_file = isset($input['internal_file']) ? $input['internal_file'] : $unparameters['internal_file'];
			$vast_4_1_url = isset($input['vast_4_1_url']) ? $input['vast_4_1_url'] : $unparameters['vast_4_1_url'];
			$vast_4_1_type_file = isset($input['vast_4_1_type_file']) ? $input['vast_4_1_type_file'] : $unparameters['vast_4_1_type_file'];
			$vast_4_1_language = isset($input['vast_4_1_language']) ? $input['vast_4_1_language'] : $unparameters['vast_4_1_language'];
			$vast_4_1_url_1 = isset($input['vast_4_1_url_1']) ? $input['vast_4_1_url_1'] : $unparameters['vast_4_1_url_1'];
			$vast_4_1_type_file_1 = isset($input['vast_4_1_type_file_1']) ? $input['vast_4_1_type_file_1'] : $unparameters['vast_4_1_type_file_1'];
			$vast_4_1_language_1 = isset($input['vast_4_1_language_1']) ? $input['vast_4_1_language_1'] : $unparameters['vast_4_1_language_1'];
			$vast_4_1_url_2 = isset($input['vast_4_1_url_2']) ? $input['vast_4_1_url_2'] : $unparameters['vast_4_1_url_2'];
			$vast_4_1_type_file_2 = isset($input['vast_4_1_type_file_2']) ? $input['vast_4_1_type_file_2'] : $unparameters['vast_4_1_type_file_2'];
			$vast_4_1_language_2 = isset($input['vast_4_1_language_2']) ? $input['vast_4_1_language_2'] : $unparameters['vast_4_1_language_2'];
			$interactive_mediafile = isset($input['interactive_mediafile']) ? $input['interactive_mediafile'] : $unparameters['interactive_mediafile'];

			//url validation
			if (!empty($vast_wrapper_url) && !filter_var($vast_wrapper_url, FILTER_VALIDATE_URL)) {

				echo ("Given third party url  is not a valid URL" . "<br>" . "please make sure your vast wrapper url(third party url) contains http:// or https://");
				exit;
			}

			$campaignid = "select campaignid from " . $table_prefix . "banners where bannerid=:bannerid";
			$campaignid_det = $this->db->prepare($campaignid);
			$campaignid_det->bindParam(":bannerid", $bannerid);
			$campaignid_det->execute();
			$campaignid_det = $campaignid_det->fetch();

			$banner_list = "select * from " . $table_prefix . "banners where campaignid=:campaignid";
			$allbanners_det = $this->db->prepare($banner_list);
			$allbanners_det->bindParam(":campaignid", $campaignid_det['campaignid']);
			$allbanners_det->execute();
			$details = $allbanners_det->fetchAll();
			$num = count($details);
			$bannerdetails = array();
			if ($num > 0) {
				if (isset($vast_companion_banner_id)) {
					foreach ($details as $banner) {
						$bannerdetails[$banner['bannerid']] = array(
							'campaignid' => $banner['campaignid'],
							'bannerid' => $banner['bannerid']
						);

						if ($vast_companion_banner_id == ($bannerdetails[$banner['bannerid']]['bannerid'])) {
							$flag = 1;
							break;
						} else {
							$flag = 2;
						}
					}

					if ($flag == 2) {
						$response = array('response' => 'error', 'Message' => 'Please enter valid banner id','status' => '403');
						return $this->response->withJson($response);
					}
				}
			}

			$var = array();
			$var  = array(
				"banner_vast_element_id" => 'banner_vast_element_id',
				"vast_element_type" => 'singlerow',
				"vast_video_id" => 'N',
				"vast_video_delivery" => $vast_video_delivery,
				"vast_thirdparty_clicktracking" => $vast_thirdparty_clicktracking,
				"vast_type" => $vast_type,
				"get_third_internal_type" => $get_third_internal_type,
				"vast_thirdparty_companion_clicktracking" => $vast_thirdparty_companion_clicktracking,
				"vast_video_skip_duration" => $vast_video_skip_duration,
				"vast_thirdparty_clickcustom" => $vast_thirdparty_clickcustom,
				"vast_video_bitrate" => 400,
				"vast_video_height" => 480,
				"vast_video_width" => 640,
				"vast_wrapper_url" => $vast_wrapper_url,
				"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
				"vast_thirdparty_companion_expandedwidth" => $vast_thirdparty_companion_expandedwidth,
				"vast_thirdparty_companion_expandedheight" => $vast_thirdparty_companion_expandedheight,
				"vast_video_skip_progress_duration" => $vast_video_skip_progress_duration,
				"vast_overlay_height" => 'N',
				"vast_overlay_width" => 'N',
				"vast_overlay_text_title" => 'N',
				"vast_overlay_text_description" => 'N',
				"vast_overlay_text_call" => 'N',
				"vast_overlay_format" => 'N',
				"vast_overlay_action" => 'N',
				"vast_companion_banner_id" => $vast_companion_banner_id,
				"vast_creative_type" => 'N',
				"vast_thirdparty_impression" => $vast_thirdparty_impression,
				"vid_upload_type" => $vid_upload_type,
				"vast_video_outgoing_filename" => $vast_video_outgoing_filename,
				"vast4_min_bitrate" => $vast4_min_bitrate,
				"vast4_max_bitrate" => $vast4_max_bitrate,
				"vast_thirdparty_companion_assetwidth" => $vast_thirdparty_companion_assetwidth,
				"vast_thirdparty_companion_assetheight" => $vast_thirdparty_companion_assetheight,
				"vast_thirdparty_companion_pxratio" => $vast_thirdparty_companion_pxratio,
				"vast_thirdparty_companion_alttext" => $vast_thirdparty_companion_alttext,
				"vast_wrapper_fallbacknoads" => $vast_wrapper_fallbacknoads,
				"vast_wrapper_followadditional" => $vast_wrapper_followadditional,
				"vast_wrapper_allowmultipleads" => $vast_wrapper_allowmultipleads,
				"icon_click_url" => $icon_click_url,
				"icon_track_url" => $icon_track_url,
				"vast_icon_filename" => $vast_icon_filename,
				"vast_icon_height" => $vast_icon_height,
				"vast_icon_width" => $vast_icon_width,
				"vast_icon_xposition" => $vast_icon_xposition,
				"vast_icon_yposition" => $vast_icon_yposition,
				"vast_icon_duration" => $vast_icon_duration,
				"vast_icon_offset" => $vast_icon_offset,
				"ad_type" => $ad_type,
				"vast_video_outgoing_filename1" => $vast_video_outgoing_filename1,
				"vast_video_bitrate_1" => $vast_video_bitrate_1,
				"vast_video_type_1" => $vast_video_type_1,
				"vast_video_outgoing_filename2" => $vast_video_outgoing_filename2,
				"vast_video_bitrate_2" => $vast_video_bitrate_2,
				"vast_video_type_2" => $vast_video_type_2,
				"is_mezzininefile" => $is_mezzininefile,
				"mezzanine_en" => $mezzanine_en,
				"url_file" => $url_file,
				"internal_file" => $internal_file,
				"vast_4_1_url" => $vast_4_1_url,
				"vast_4_1_type_file" => $vast_4_1_type_file,
				"vast_4_1_language" => $vast_4_1_language,
				"vast_4_1_url_1" => $vast_4_1_url_1,
				"vast_4_1_type_file_1" => $vast_4_1_type_file_1,
				"vast_4_1_language_1" => $vast_4_1_language_1,
				"vast_4_1_url_2" => $vast_4_1_url_2,
				"vast_4_1_type_file_2" => $vast_4_1_type_file_2,
				"vast_4_1_language_2" => $vast_4_1_language_2,
				"interactive_mediafile" => $interactive_mediafile

			);

			$parameters = serialize($var);

			$editbanner1 = "update " . $table_prefix . "banners set
			description=:description,
			comments=:comments,
			updated=:updated,
			keyword=:keyword,
			append=:append,
			prepend=:prepend,
			parameters=:parameters
			where bannerid=:bannerid";

			$djax_query_banners = $this->db->prepare($editbanner1);
			$djax_query_banners->bindParam(":bannerid", $bannerid);
			$djax_query_banners->bindParam(":description", $description);
			$djax_query_banners->bindParam(":comments", $comments);
			$djax_query_banners->bindParam(":updated", $datetime);
			$djax_query_banners->bindParam(":keyword", $keyword);
			$djax_query_banners->bindParam(":append", $append);
			$djax_query_banners->bindParam(":prepend", $prepend);
			$djax_query_banners->bindParam(":parameters", $parameters);
			$djax_query_banners->execute();

			$editvastparameters = "update " . $table_prefix . "djaxbanner_vast_element set
			vast_video_delivery=:vast_video_delivery,
			vast_wrapper_url='" . $vast_wrapper_url . "',
			vast_video_skip_duration='" . $vast_video_skip_duration . "',
			vast_video_skip_progress_duration='" . $vast_video_skip_progress_duration . "',
			vast_type='" . $vast_type . "',
			get_third_internal_type='" . $get_third_internal_type . "',
			vast_thirdparty_clicktracking='" . $vast_thirdparty_clicktracking . "',
			vast_thirdparty_clickcustom='" . $vast_thirdparty_clickcustom . "',
			vast_thirdparty_companion_clicktracking='" . $vast_thirdparty_companion_clicktracking . "',
			vast_thirdparty_companion_expandedwidth='" . $vast_thirdparty_companion_expandedwidth . "',
			vast_thirdparty_companion_expandedheight='" . $vast_thirdparty_companion_expandedheight . "',
			vast_companion_banner_id=:vast_companion_banner_id,
			vast_video_clickthrough_url=:vast_video_clickthrough_url,
			vast_thirdparty_impression=:vast_thirdparty_impression,
			vid_upload_type=:vid_upload_type,
			vast_video_outgoing_filename=:vast_video_outgoing_filename,
			vast4_min_bitrate=:vast4_min_bitrate,
			vast4_max_bitrate=:vast4_max_bitrate,
			vast_thirdparty_companion_assetwidth=:vast_thirdparty_companion_assetwidth,
			vast_thirdparty_companion_assetheight=:vast_thirdparty_companion_assetheight,
			vast_thirdparty_companion_pxratio=:vast_thirdparty_companion_pxratio,
			vast_thirdparty_companion_alttext=:vast_thirdparty_companion_alttext,
			vast_wrapper_fallbacknoads=:vast_wrapper_fallbacknoads,
			vast_wrapper_followadditional=:vast_wrapper_followadditional,
			vast_wrapper_allowmultipleads=:vast_wrapper_allowmultipleads,
			icon_click_url=:icon_click_url,
			icon_track_url=:icon_track_url,
			vast_icon_filename=:vast_icon_filename,
			vast_icon_height=:vast_icon_height,
			vast_icon_width=:vast_icon_width,
			vast_icon_xposition=:vast_icon_xposition,
			vast_icon_yposition=:vast_icon_yposition,
			vast_icon_duration=:vast_icon_duration,
			vast_icon_offset=:vast_icon_offset,
			ad_type=:ad_type,
			vast_video_outgoing_filename1=:vast_video_outgoing_filename1,
			vast_video_bitrate_1=:vast_video_bitrate_1,
			vast_video_type_1=:vast_video_type_1,
			vast_video_outgoing_filename2=:vast_video_outgoing_filename2,
			vast_video_bitrate_2=:vast_video_bitrate_2,
			vast_video_type_2=:vast_video_type_2,
			is_mezzininefile=:is_mezzininefile,
			mezzanine_en=:mezzanine_en,
			url_file=:url_file,
			internal_file=:internal_file,
			vast_4_1_url=:vast_4_1_url,
			vast_4_1_type_file=:vast_4_1_type_file,
			vast_4_1_language=:vast_4_1_language,
			vast_4_1_url_1=:vast_4_1_url_1,
			vast_4_1_type_file_1=:vast_4_1_type_file_1,
			vast_4_1_language_1=:vast_4_1_language_1,
			vast_4_1_url_2=:vast_4_1_url_2,
			vast_4_1_type_file_2=:vast_4_1_type_file_2,
			vast_4_1_language_2=:vast_4_1_language_2,
			interactive_mediafile=:interactive_mediafile	
			where banner_id=:banner_id ";

			$djax_query_banners_parameters = $this->db->prepare($editvastparameters);
			$djax_query_banners_parameters->bindParam(":vast_video_delivery", $vast_video_delivery);
			$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
			$djax_query_banners_parameters->bindParam(":vast_video_clickthrough_url", $vast_video_clickthrough_url);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_impression", $vast_thirdparty_impression);
			//new
			$djax_query_banners->bindParam(":vast_thirdparty_companion_expandedheight", $vast_thirdparty_companion_expandedheight);
			$djax_query_banners->bindParam(":vast_thirdparty_companion_expandedwidth", $vast_thirdparty_companion_expandedwidth);
			$djax_query_banners->bindParam(":vast_thirdparty_clickcustom", $vast_thirdparty_clickcustom);
			$djax_query_banners->bindParam(":vast_thirdparty_clicktracking", $vast_thirdparty_clicktracking);
			$djax_query_banners->bindParam(":vast_type", $vast_type);
			$djax_query_banners->bindParam(":vast_video_skip_progress_duration", $vast_video_skip_progress_duration);
			$djax_query_banners->bindParam(":vast_video_skip_duration", $vast_video_skip_duration);
			$djax_query_banners->bindParam(":vast_wrapper_url", $vast_wrapper_url);
			$djax_query_banners_parameters->bindParam(":vid_upload_type", $vid_upload_type);
			$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename", $vast_video_outgoing_filename);
			$djax_query_banners_parameters->bindParam(":vast4_min_bitrate", $vast4_min_bitrate);
			$djax_query_banners_parameters->bindParam(":vast4_max_bitrate", $vast4_max_bitrate);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_companion_assetwidth", $vast_thirdparty_companion_assetwidth);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_companion_assetheight", $vast_thirdparty_companion_assetheight);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_companion_pxratio", $vast_thirdparty_companion_pxratio);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_companion_alttext", $vast_thirdparty_companion_alttext);
			$djax_query_banners_parameters->bindParam(":vast_wrapper_fallbacknoads", $vast_wrapper_fallbacknoads);
			$djax_query_banners_parameters->bindParam(":vast_wrapper_followadditional", $vast_wrapper_followadditional);
			$djax_query_banners_parameters->bindParam(":vast_wrapper_allowmultipleads", $vast_wrapper_allowmultipleads);
			$djax_query_banners_parameters->bindParam(":icon_click_url", $icon_click_url);
			$djax_query_banners_parameters->bindParam(":icon_track_url", $icon_track_url);
			$djax_query_banners_parameters->bindParam(":vast_icon_filename", $vast_icon_filename);
			$djax_query_banners_parameters->bindParam(":vast_icon_height", $vast_icon_height);
			$djax_query_banners_parameters->bindParam(":vast_icon_width", $vast_icon_width);
			$djax_query_banners_parameters->bindParam(":vast_icon_xposition", $vast_icon_xposition);
			$djax_query_banners_parameters->bindParam(":vast_icon_yposition", $vast_icon_yposition);
			$djax_query_banners_parameters->bindParam(":vast_icon_duration", $vast_icon_duration);
			$djax_query_banners_parameters->bindParam(":vast_icon_offset", $vast_icon_offset);
			$djax_query_banners_parameters->bindParam(":ad_type", $ad_type);
			$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename1", $vast_video_outgoing_filename1);
			$djax_query_banners_parameters->bindParam(":vast_video_bitrate_1", $vast_video_bitrate_1);
			$djax_query_banners_parameters->bindParam(":vast_video_type_1", $vast_video_type_1);
			$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename2", $vast_video_outgoing_filename2);
			$djax_query_banners_parameters->bindParam(":vast_video_bitrate_2", $vast_video_bitrate_2);
			$djax_query_banners_parameters->bindParam(":vast_video_type_2", $vast_video_type_2);
			$djax_query_banners_parameters->bindParam(":is_mezzininefile", $is_mezzininefile);
			$djax_query_banners_parameters->bindParam(":mezzanine_en", $mezzanine_en);
			$djax_query_banners_parameters->bindParam(":url_file", $url_file);
			$djax_query_banners_parameters->bindParam(":internal_file", $internal_file);
			$djax_query_banners_parameters->bindParam(":vast_4_1_url", $vast_4_1_url);
			$djax_query_banners_parameters->bindParam(":vast_4_1_type_file", $vast_4_1_type_file);
			$djax_query_banners_parameters->bindParam(":vast_4_1_language", $vast_4_1_language);
			$djax_query_banners_parameters->bindParam(":vast_4_1_url_1", $vast_4_1_url_1);
			$djax_query_banners_parameters->bindParam(":vast_4_1_type_file_1", $vast_4_1_type_file_1);
			$djax_query_banners_parameters->bindParam(":vast_4_1_language_1", $vast_4_1_language_1);
			$djax_query_banners_parameters->bindParam(":vast_4_1_url_2", $vast_4_1_url_2);
			$djax_query_banners_parameters->bindParam(":vast_4_1_type_file_2", $vast_4_1_type_file_2);
			$djax_query_banners_parameters->bindParam(":vast_4_1_language_2", $vast_4_1_language_2);
			$djax_query_banners_parameters->bindParam(":interactive_mediafile", $interactive_mediafile);

			//end
			$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);
			$djax_query_banners_parameters->execute();

			if (isset($input['description']) && $input['description'] == '') {
				$response2 = array('response' => 'error', 'Message' => 'description must not be empty','status' => '403');
				return $this->response->withJson($response2);
			}


			if (isset($input['vast_type']) && $input['vast_type'] == '') {
				$response3 = array('response' => 'error', 'Message' => 'vast_version must not be empty','status' => '403');
				return $this->response->withJson($response3);
			} else {
				$response = array('response' => 'ok', 'Message' => 'Banner Updated Successfully','status' => '200');
				return $this->response->withJson($response);
			}
		} else {
			$response = array('response' => 'error', 'Message' => 'Please enter valid bannerid','status' => '403');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('bannereditvastinline_val'));;

//delete vast banner

$app->delete('/advancedvast_delete_banner_vastinline/[{bannerid}]', function ($request, $response, $args) {

	$results = array();
	$input = $request->getParsedBody();
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$bannerid   = $args['bannerid'];

	$referbanner = "select * from " . $table_prefix . "banners where bannerid=:bannerid";
	$djax_query_referbanner = $this->db->prepare($referbanner);
	$djax_query_referbanner->bindParam(":bannerid", $bannerid);
	$djax_query_referbanner->execute();

	$stmtbanner = $djax_query_referbanner->fetchAll();

	if (count($stmtbanner) > 0) {

		$deleteaccounts = "DELETE FROM " . $table_prefix . "banners WHERE bannerid=:bannerid";
		$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
		$djax_query_deleteaccount->bindParam(":bannerid", $bannerid);
		$djax_query_deleteaccount->execute();
		$delete_element = "DELETE FROM " . $table_prefix . "djaxbanner_vast_element WHERE banner_id=:bannerid";
		$djax_query_delete_element = $this->db->prepare($delete_element);
		$djax_query_delete_element->bindParam(":bannerid", $bannerid);
		$banner_del = $djax_query_delete_element->execute();

		if ($banner_del) {
			$response = array(
				'response' => 'ok',
				'Message' => 'Banner deleted successfully!',
				'status' => '200'
			);

			return $this->response->withJson($response);
		}
	} else {

		$response = array(
			'response' => 'error',
			'Message' => 'Bannerid provided is invalid',
			'status' => '403'
		);

		return $this->response->withJson($response);
	}
});

//get the vast banner
$app->get('/advancedvast_get_vastbanner/[{bannerid}]', function ($request, $response, $args) {
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$bannerid   = $args['bannerid'];
	$datetime     = date('Y-m-d H:i:s');
	$results      = array();
	$bannerdetail = "SELECT * from " . $table_prefix . "banners where bannerid=:bannerid";
	$getbanner = $this->db->prepare($bannerdetail);
	$getbanner->bindParam(":bannerid", $bannerid);
	$getbanner->execute();
	$bannerdet  = $getbanner->fetch();

	// $bannerdetail = array();

	if (count($bannerdet) > 0) {
		
		
		$bannerdetail = array(
			'campaignid' => $bannerdet['campaignid'],
			'contenttype' => $bannerdet['contenttype'],
			'storagetype' => $bannerdet['storagetype'],
			'filename' => $bannerdet['filename'],
			'width' => $bannerdet['width'],
			'height' => $bannerdet['height'],
			'weight' => $bannerdet['weight'],
			'description' => $bannerdet['description'],
			'append' => $bannerdet['append'],
			'prepend' => $bannerdet['prepend'],
			'parameters' => unserialize($bannerdet['parameters']),

		);
		$data['data'] = $bannerdetail;
		$data['response'] = "success";
		$data["message"] = "Advanced Vast single Banner List";
		$data['status'] = "200";
		return $this->response->withJson($data);
		// $response = array(
		// 	'response' => 'ok',
		// 	'Message' => $bannerdetail,
		// 	'status' => '200'
		

		// return $this->response->withJson($response);
	} else {
		$response = array(
			'response' => 'error',
			'Message' => 'Requested Banner Doesnot available',
			'status' => '404'
		);

		return $this->response->withJson($response);
	}
});

//get all vast banner 

$app->get('/advancedvast_get_all_vastbanner/[{campaignid}]', function ($request, $response, $args) {

	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$campaignid = $args['campaignid'];
	$banner_list = "select * from " . $table_prefix . "banners where campaignid=:campaignid";
	$allbanners_det = $this->db->prepare($banner_list);
	$allbanners_det->bindParam(":campaignid", $campaignid);
	$allbanners_det->execute();
	$details = $allbanners_det->fetchAll();
	$num = count($details);
	$bannerdetails = array();
	if ($num > 0) {

		foreach ($details as $banner) {
			$bannerdetails[] = array(
				'campaignid' => $banner['campaignid'],
				'bannerid' => $banner['bannerid'],
				'contenttype' => $banner['contenttype'],
				'storagetype' => $banner['storagetype'],
				'filename' => $banner['filename'],
				'width' => $banner['width'],
				'height' => $banner['height'],
				'url' => $banner['url'],
				'description' => $banner['description'],
				'append' => $banner['append'],
				'prepend' => $banner['prepend'],
				'parameters' => unserialize($banner['parameters'])
			);
		}
		$data['data'] = $bannerdetails;
		$data['response'] = "success";
		$data['message'] = "Advanced Vast All Banner List";
		$data['status'] = "200";
		return $this->response->withJson($data);

		// $results = $this->response->withJson($bannerdetails);

		// return $results;
	} else {
		$results = array('response' => 'error', 'Message' => 'Requested campaign not available','status' => '404');
		return $this->response->withJson($results);
	}
});

$app->post("/advancedvast_add_banner_vastoverlay/[{campaign_id}]", function ($request, $response, $args) {
	if ($request->getAttribute("has_errors")) {
		//There are errors, read them
		$errors = $request->getAttribute("errors");
		return $this->response->withJson($errors);
	} else {

		$campaignid = $args["campaign_id"];
		$datetime = date("Y-m-d H:i:s");
		$paths = dirname(__FILE__);
		$input = $request->getParsedBody();
		$table_prefix = $this->get("settings")["path"]["table_prefix"];
		//~ define('DIRECTORY', $image_path);
		$validation = "SELECT * FROM {$table_prefix}campaigns WHERE campaignid =:campaignid";

		$djax_query_validation = $this->db->prepare($validation);
		$djax_query_validation->bindParam(":campaignid", $campaignid);
		$djax_query_validation->execute();
		$stmtvalidation = $djax_query_validation->fetchAll();
		$valid = count($stmtvalidation);

		if (empty($input['width'])  && $input['width'] != '-2' || empty($input['height'])  && $input['height'] = '-2') {
			$response = array('response' => 'error', 'Message' => 'Please enter valid width or height','status' => '403');
			return $this->response->withJson($response);
		}
		if ($valid && $input["storagetype"] == "html" && $input["width"] == "-2" && $input["height"] == "-2" && ($input["vast_overlay_format"] == "image_overlay" || $input["vast_overlay_format"] == "wrapper_overlay")) {

			/////////////////////////////////////inline html/////////////////////////////////////////////
			//~ $storagetype = $input['storagetype'];
			$description = isset($input["description"]) ? $input["description"] : "";
			$storagetype = isset($input["storagetype"]) ? $input["storagetype"] : "";
			$url = $input["url"];
			//url validation
			if (!empty($url) && !filter_var($url, FILTER_VALIDATE_URL)) {
				echo "Given  url  is not a valid URL" .
					"<br>" .
					"please make sure your url contains http:// or https://";
				exit();
			}
			$vast_overlay_format = $input["vast_overlay_format"];
			$vast_overlay_wrapper = isset($input["vast_overlay_wrapper"]) ? $input["vast_overlay_wrapper"] : "";
			$target = isset($input["target"]) ? $input["target"] : "";
			$vast_overlay_action = isset($input["vast_overlay_action"]) ? $input["vast_overlay_action"] : "";
			$keyword = isset($input["keyword"]) ? $input["keyword"] : "";
			$append = isset($input["append"]) ? $input["append"] : "";
			$prepend = isset($input["prepend"]) ? $input["prepend"] : "";
			$comments = isset($input["comments"]) ? $input["comments"] : "";
			$alt = isset($input["alt"]) ? $input["alt"] : "";
			$statustext = isset($input["statustext"]) ? $input["statustext"] : "";
			$bannertext = isset($input["bannertext"]) ? $input["bannertext"] : "";
			$imageurl = isset($input["imageurl"]) ? $input["imageurl"] : "";
			$vast_video_id = isset($input["vast_video_id"]) ? $input["vast_video_id"] : null;
			//new
			$vast_overlay_height = isset($input["vast_overlay_height"]) ? $input["vast_overlay_height"] : "";
			$vast_overlay_width = isset($input["vast_overlay_width"]) ? $input["vast_overlay_width"] : "";
			$vast_creative_type = isset($input["vast_creative_type"]) ? $input["vast_creative_type"] : "";
			$vast_thirdparty_clicktracking = isset($input["vast_thirdparty_clicktracking"]) ? $input["vast_thirdparty_clicktracking"] : "";
			$vast_thirdparty_clickcustom = isset($input["vast_thirdparty_clickcustom"]) ? $input["vast_thirdparty_clickcustom"] : "";
			$vast_thirdparty_companion_expandedwidth = isset($input["vast_thirdparty_companion_expandedwidth"])
				? $input["vast_thirdparty_companion_expandedwidth"] : "";
			$vast_thirdparty_companion_expandedheight = isset($input["vast_thirdparty_companion_expandedheight"])
				? $input["vast_thirdparty_companion_expandedheight"] : "";
			$vast_thirdparty_companion_clicktracking = isset($input["vast_thirdparty_companion_clicktracking"]) ? $input["vast_thirdparty_companion_clicktracking"] : "";
			$vast_type = isset($input["vast_type"]) ? $input["vast_type"] : "";
			$vast_video_skip_duration = isset($input["vast_video_skip_duration"]) ? $input["vast_video_skip_duration"] : "";
			$vast_video_skip_progress_duration = isset($input["vast_video_skip_progress_duration"])
				? $input["vast_video_skip_progress_duration"] : "";
			$vast_overlay_expanded_width = isset($input["vast_overlay_expanded_width"])
				? $input["vast_overlay_expanded_width"] : "";
			$vast_overlay_expanded_height = isset($input["vast_overlay_expanded_height"])
				? $input["vast_overlay_expanded_height"] : "";
			$vast_overlay_expandedminduration = isset($input["vast_overlay_expandedminduration"])
				? $input["vast_overlay_expandedminduration"] : "";
			//end

			$vast_companion_banner_id = $input["vast_companion_banner_id"];
			$vast_thirdparty_impression = $input["vast_thirdparty_impression"];
			$vast_overlay_height = isset($input["vast_overlay_height"]) ? $input["vast_overlay_height"] : null;
			$vast_overlay_width = isset($input["vast_overlay_width"]) ? $input["vast_overlay_width"] : null;
			$vast_overlay_text_title = isset($input["vast_overlay_text_title"]) ? $input["vast_overlay_text_title"]
				: null;
			$vast_overlay_text_description = isset($input["vast_overlay_text_description"])
				? $input["vast_overlay_text_description"] : null;
			$vast_overlay_text_call = isset($input["vast_overlay_text_call"]) ? $input["vast_overlay_text_call"]
				: null;

			//url validation

			if (
				!empty($vast_overlay_wrapper) &&
				!filter_var($vast_overlay_wrapper, FILTER_VALIDATE_URL)
			) {
				echo "Given third party url  is not a valid URL" .
					"<br>" .
					"please make sure your vast wrapper url(third party url) contains http:// or https://";
				exit();
			}

			$banner_list = "select * from " . $table_prefix . "banners where campaignid=:campaignid";
			$allbanners_det = $this->db->prepare($banner_list);
			$allbanners_det->bindParam(":campaignid", $campaignid);
			$allbanners_det->execute();
			$details = $allbanners_det->fetchAll();
			// echo "details";
			// print_r($details);exit;
			$num = count($details);
			$bannerdetails = array();
			if ($num > 0) {
				if (isset($vast_companion_banner_id)) {
					foreach ($details as $banner) {
						$bannerdetails[$banner['bannerid']] = array(
							'campaignid' => $banner['campaignid'],
							'bannerid' => $banner['bannerid']
						);
// print_r($bannerdetails[$banner['bannerid']]['bannerid']);exit;
						if ($vast_companion_banner_id == ($bannerdetails[$banner['bannerid']]['bannerid'])) {
							$flag = 1;
							break;
						} else {
							$flag = 2;
						}
						// echo $flag;
					
					}
					if ($flag == 2) {
						$response = array('response' => 'error', 'Message' => 'Please enter valid banner id','status' => '403');
						return $this->response->withJson($response);
					}
					}

					
			}
// exit;
			$var = [];
			$var = [
				"banner_vast_element_id" => "banner_vast_element_id",
				"vast_element_type" => "singlerow",
				"vast_video_id" => "N",
				"vast_overlay_format" => $vast_overlay_format,
				"vast_video_bitrate" => 400,
				"vast_overlay_height" => 480,
				"vast_overlay_width" => 640,
				"vast_video_clickthrough_url" => "vast_video_clickthrough_url",
				"vast_overlay_action" => $vast_overlay_action,
				"vast_thirdparty_clickcustom" => $vast_thirdparty_clickcustom,
				"vast_thirdparty_companion_expandedwidth" => $vast_thirdparty_companion_expandedwidth,
				"vast_thirdparty_companion_expandedheight" => $vast_thirdparty_companion_expandedheight,
				"vast_overlay_wrapper" => $vast_overlay_wrapper,
				"vast_type" => $vast_type,
				"vast_thirdparty_companion_clicktracking" => $vast_thirdparty_companion_clicktracking,
				"vast_video_skip_duration" => $vast_video_skip_duration,
				"vast_video_skip_progress_duration" => $vast_video_skip_progress_duration,
				"vast_overlay_expandedminduration" => $vast_overlay_expandedminduration,
				"vast_overlay_expanded_height" => $vast_overlay_expanded_height,
				"vast_overlay_expanded_width" => $vast_overlay_expanded_width,
				"vast_overlay_height" => $vast_overlay_height,
				"vast_overlay_width" => $vast_overlay_width,
				"vast_overlay_text_title" => "N",
				"vast_overlay_text_description" => "N",
				"vast_overlay_text_call" => "N",
				"vast_overlay_action" => "N",
				"vast_companion_banner_id" => $vast_companion_banner_id,
				"vast_creative_type" => $vast_creative_type,
				"vast_thirdparty_impression" => $vast_thirdparty_impression,
			];

			$addbanner =
				"INSERT INTO " .
				$table_prefix .
				"banners(
				   campaignid,
				   storagetype,
				   width,
				   height,
				   weight,
				   description,
				   comments,
				   updated,
				   keyword,
				   append,
				   prepend,
				   url,
				   filename,
				   parameters,
				   ext_bannertype)  VALUES (
				   :campaignid,
				   :storagetype,
				   -2,
				   -2,
				   1,
				   :description,
				   :comments,
				   :updated,
				   :keyword,
				   '" .
				$append .
				"',
				    '" .
				$prepend .
				"',
				    '" .
				$url .
				"',
				    '" .
				$imageurl .
				"',
				   :parameters,
				   'bannerTypeHtml:djaxvastOverlayBannerTypeHtml:vastOverlayHtml')";

			$parameter = serialize($var);

			if (empty($parameter)) {
				$parameter = "N;";
			}

			$djax_query_banners = $this->db->prepare($addbanner);

			$djax_query_banners->bindParam(":campaignid", $campaignid);
			$djax_query_banners->bindParam(":storagetype", $storagetype);
			$djax_query_banners->bindParam(":description", $description);
			$djax_query_banners->bindParam(":comments", $comments);
			$djax_query_banners->bindParam(":updated", $datetime);
			$djax_query_banners->bindParam(":keyword", $keyword);
			$djax_query_banners->bindParam(":parameters", $parameter);

			$djax_query_banners->execute();
			$bannerid = $this->db->lastInsertId();

			//auto increment

			$get_banner_id = "select * from djaxbanner_vast_element_seq";
			$query_banner_vast_id = $this->db->prepare($get_banner_id);
			$query_banner_vast_id->execute();
			$banner_vast_id = $query_banner_vast_id->fetchAll();

			if (count($banner_vast_id) > 0) {
				$a = $banner_vast_id[0]["id"];
				$banner_vast_element_id = $a + 1;
			} else {
				$banner_vast_element_id = 1;
			}

			$vast_element_type = "singlerow";
			$vast_video_bitrate = 400;

			$addparameters =
				"insert into " .
				$table_prefix .
				"djaxbanner_vast_element(
				banner_vast_element_id,
				banner_id,
				vast_element_type,
				vast_video_id,
				vast_video_duration,
				vast_overlay_format,
				vast_video_type,
				vast_video_bitrate,
				vast_overlay_height,
				vast_overlay_width,
				vast_video_outgoing_filename,
				vast_companion_banner_id,
				vast_video_clickthrough_url,
				vast_overlay_text_title,
				vast_overlay_text_description,
				vast_overlay_text_call,
				vast_creative_type,
				vast_overlay_wrapper,
				vast_video_skip_duration,
				vast_video_skip_progress_duration,
				vast_type,
				vast_thirdparty_clicktracking,
				vast_thirdparty_clickcustom,
				vast_thirdparty_companion_clicktracking,
				vast_thirdparty_companion_expandedwidth,
				vast_thirdparty_companion_expandedheight,
				vast_overlay_action,
				vast_overlay_expanded_width,
				vast_overlay_expanded_height,
				vast_overlay_expandedminduration,
				vast_thirdparty_impression)
				values(
				:banner_vast_element_id,
				:banner_id,
				:vast_element_type,
				:vast_video_id,
				:vast_video_duration,
				:vast_overlay_format,
				:vast_video_type,
				:vast_video_bitrate,
				:vast_overlay_height,
				:vast_overlay_width,
				:vast_video_outgoing_filename,
				:vast_companion_banner_id,
				:url,
				:vast_overlay_text_title,
				:vast_overlay_text_description,
				:vast_overlay_text_call,
				:vast_creative_type,
				'" .
				$vast_overlay_wrapper .
				"',
				'" .
				$vast_video_skip_duration .
				"',
				'" .
				$vast_video_skip_progress_duration .
				"',
				'" .
				$vast_type .
				"',
				'" .
				$vast_thirdparty_clicktracking .
				"',
				'" .
				$vast_thirdparty_clickcustom .
				"',
				'" .
				$vast_thirdparty_companion_clicktracking .
				"',
				'" .
				$vast_thirdparty_companion_expandedwidth .
				"',
				'" .
				$vast_thirdparty_companion_expandedheight .
				"',
				'" .
				$vast_overlay_action .
				"',
				'" .
				$vast_overlay_expanded_width .
				"',
				'" .
				$vast_overlay_expanded_height .
				"',
				'" .
				$vast_overlay_expandedminduration .
				"',
				:vast_thirdparty_impression
				)";

			$djax_query_banners_parameters = $this->db->prepare($addparameters);

			$djax_query_banners_parameters->bindParam(":banner_vast_element_id", $banner_vast_element_id);
			$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);
			$djax_query_banners_parameters->bindParam(":vast_element_type", $vast_element_type);
			$djax_query_banners_parameters->bindParam(":vast_video_id", $vast_video_id);
			$djax_query_banners_parameters->bindParam(":vast_video_duration", $vast_video_duration);
			$djax_query_banners_parameters->bindParam(":vast_overlay_format", $vast_overlay_format);
			$djax_query_banners_parameters->bindParam(":vast_video_type", $vast_video_type);
			$djax_query_banners_parameters->bindParam(":vast_video_bitrate", $vast_video_bitrate);
			$djax_query_banners_parameters->bindParam(":vast_overlay_height", $vast_overlay_height);
			$djax_query_banners_parameters->bindParam(":vast_overlay_width", $vast_overlay_width);
			$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename", $vast_video_outgoing_filename);
			$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
			$djax_query_banners_parameters->bindParam(":url", $url);
			$djax_query_banners_parameters->bindParam(":vast_overlay_text_title", $vast_overlay_text_title);
			$djax_query_banners_parameters->bindParam(":vast_overlay_text_description", $vast_overlay_text_description);
			$djax_query_banners_parameters->bindParam(":vast_overlay_text_call", $vast_overlay_text_call);
			$djax_query_banners_parameters->bindParam(":vast_creative_type", $vast_creative_type);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_impression", $vast_thirdparty_impression);
			$djax_query_banners_parameters->execute();

			$addelement_id =
				"update djaxbanner_vast_element_seq set id=:banner_vast_element_id;";
			$djax_query_banners_elements = $this->db->prepare($addelement_id);
			$djax_query_banners_elements->bindParam(
				":banner_vast_element_id",
				$banner_vast_element_id
			);
			$djax_query_banners_elements->execute();

			$response = array('response' => 'ok', 'bannerid' => $bannerid, 'Message' => 'Overlay Banner added successfully!','status' => '200');
			return $this->response->withJson($response);
		} else {
			$response = [
				"response" => "error",
				"Message" => "Please enter valid Campaignid",
				'status' => '404'
			];
			return $this->response->withJson($response);
		}
	}
})->add($container->get("banneraddvastoverlay_val"));

//new vast edit

$app->post("/advancedvast_edit_banner_vastoverlay/[{banner_id}]", function ($request, $response, $args) {
	if ($request->getAttribute("has_errors")) {
		//There are errors, read them
		$errors = $request->getAttribute("errors");
		return $this->response->withJson($errors);
	} else {
		$bannerid = $args["banner_id"];
		$datetime = date("Y-m-d H:i:s");
		$paths = dirname(__FILE__);
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$getbanners = "select * from " . $table_prefix . "banners where bannerid=:bannerid";
		$djax_query_banner = $this->db->prepare($getbanners);
		$djax_query_banner->bindParam(":bannerid", $bannerid);
		$djax_query_banner->execute();
		$stmtbanner = $djax_query_banner->fetchAll();

		$input = $request->getParsedBody();
		$table_prefix = $this->get("settings")["path"]["table_prefix"];

		if (count($stmtbanner) > 0) {
			if (isset($input["storagetype"])) {
				$storagetype = $input["storagetype"];
			} else {
				$storagetype = $stmtbanner[0]["storagetype"];
			}

			if (isset($input["width"])) {
				$width = $input["width"];
			} else {
				$width = $stmtbanner[0]["width"];
			}

			if (isset($input["height"])) {
				$height = $input["height"];
			} else {
				$height = $stmtbanner[0]["height"];
			}

			if (isset($input["contenttype"])) {
				$contenttype = $input["contenttype"];
			} else {
				$contenttype = $stmtbanner[0]["contenttype"];
			}

			if (isset($input["description"])) {
				$description = $input["description"];
			} else {
				$description = $stmtbanner[0]["description"];
			}

			if (isset($input["keyword"])) {
				$keyword = $input["keyword"];
			} else {
				$keyword = $stmtbanner[0]["keyword"];
			}

			if (isset($input["append"])) {
				$append = $input["append"];
			} else {
				$append = $stmtbanner[0]["append"];
			}
			if (isset($input["prepend"])) {
				$prepend = $input["prepend"];
			} else {
				$prepend = $stmtbanner[0]["prepend"];
			}

			if (isset($input["comments"])) {
				$comments = $input["comments"];
			} else {
				$comments = $stmtbanner[0]["comments"];
			}
			if (isset($input["url"])) {
				$url = $input["url"];
			} else {
				$url = $stmtbanner[0]["url"];
			}

			$imageurl = isset($input["imageurl"]) ? $input["imageurl"] : "";
			if (empty($input['width'])  && $input['width'] != '-2' || empty($input['height'])  && $input['height'] = '-2') {
				$response = array('response' => 'error', 'Message' => 'Please enter valid width or height','status' => '403');
				return $this->response->withJson($response);
			}

			//url validation
			if (!empty(isset($input["url"]))) {
				if (!filter_var($url, FILTER_VALIDATE_URL)) {
					echo "Given url  is not a valid URL" .
						"<br>" .
						"please make sure your url contains http:// or https://";
					exit();
				}
			}

			//end

			$dbparameters = $stmtbanner[0]["parameters"];
			$unparameters = unserialize($dbparameters);

			if (isset($input["vast_video_clickthrough_url"])) {
				$vast_video_clickthrough_url = $input["vast_video_clickthrough_url"];
			} else {
				$vast_video_clickthrough_url = $unparameters["vast_video_clickthrough_url"];
			}

			if (isset($input["vast_thirdparty_clicktracking"])) {
				$vast_thirdparty_clicktracking = $input["vast_thirdparty_clicktracking"];
			} else {
				$vast_thirdparty_clicktracking = $unparameters["vast_thirdparty_clicktracking"];
			}

			if (isset($input["vast_thirdparty_clickcustom"])) {
				$vast_thirdparty_clickcustom = $input["vast_thirdparty_clickcustom"];
			} else {
				$vast_thirdparty_clickcustom = $unparameters["vast_thirdparty_clickcustom"];
			}

			if (isset($input["vast_thirdparty_companion_expandedwidth"])) {
				$vast_thirdparty_companion_expandedwidth = $input["vast_thirdparty_companion_expandedwidth"];
			} else {
				$vast_thirdparty_companion_expandedwidth = $unparameters["vast_thirdparty_companion_expandedwidth"];
			}

			if (isset($input["vast_video_delivery"])) {
				$vast_video_delivery = $input["vast_video_delivery"];
			} else {
				$vast_video_delivery = $unparameters["vast_video_delivery"];
			}

			if (isset($input["vast_thirdparty_companion_expandedheight"])) {
				$vast_thirdparty_companion_expandedheight = $input["vast_thirdparty_companion_expandedheight"];
			} else {
				$vast_thirdparty_companion_expandedheight = $unparameters["vast_thirdparty_companion_expandedheight"];
			}

			if (isset($input["vast_companion_banner_id"])) {
				$vast_companion_banner_id = $input["vast_companion_banner_id"];
			} else {
				$vast_companion_banner_id = $unparameters["vast_companion_banner_id"];
			}

			if (isset($input["vast_thirdparty_impression"])) {
				$vast_thirdparty_impression = $input["vast_thirdparty_impression"];
			} else {
				$vast_thirdparty_impression = $unparameters["vast_thirdparty_impression"];
			}

			if (isset($input["vast_thirdparty_companion_clicktracking"])) {
				$vast_thirdparty_companion_clicktracking = $input["vast_thirdparty_companion_clicktracking"];
			} else {
				$vast_thirdparty_companion_clicktracking = $unparameters["vast_thirdparty_companion_clicktracking"];
			}

			if (isset($input["vast_wrapper_url"])) {
				$vast_wrapper_url = $input["vast_wrapper_url"];
			} else {
				$vast_wrapper_url = $unparameters["vast_wrapper_url"];
			}

			if (isset($input["vast_type"])) {
				$vast_version = $input["vast_type"];
			} else {
				$vast_version = $unparameters["vast_type"];
			}

			if (isset($input["vast_video_skip_duration"])) {
				$vast_video_skip_duration = $input["vast_video_skip_duration"];
			} else {
				$vast_video_skip_duration =
					$unparameters["vast_video_skip_duration"];
			}
			if (isset($input["vast_video_skip_progress_duration"])) {
				$vast_video_skip_progress_duration = $input["vast_video_skip_progress_duration"];
			} else {
				$vast_video_skip_progress_duration = $unparameters["vast_video_skip_progress_duration"];
			}
			if (isset($input["vast_overlay_expanded_width"])) {
				$vast_overlay_expanded_width = $input["vast_overlay_expanded_width"];
			} else {
				$vast_overlay_expanded_width = $unparameters["vast_overlay_expanded_width"];
			}
			if (isset($input["vast_overlay_expanded_height"])) {
				$vast_overlay_expanded_height = $input["vast_overlay_expanded_height"];
			} else {
				$vast_overlay_expanded_height = $unparameters["vast_overlay_expanded_height"];
			}
			if (isset($input["vast_overlay_expandedminduration"])) {
				$vast_overlay_expandedminduration = $input["vast_overlay_expandedminduration"];
			} else {
				$vast_overlay_expandedminduration = $unparameters["vast_overlay_expandedminduration"];
			}

			if (isset($input["vast_overlay_height"])) {
				$vast_overlay_height = $input["vast_overlay_height"];
			} else {
				$vast_overlay_height = $unparameters["vast_overlay_height"];
			}

			if (isset($input["vast_overlay_width"])) {
				$vast_overlay_width = $input["vast_overlay_width"];
			} else {
				$vast_overlay_width = $unparameters["vast_overlay_width"];
			}

			if (isset($input["vast_creative_type"])) {
				$vast_creative_type = $input["vast_creative_type"];
			} else {
				$vast_creative_type = $unparameters["vast_creative_type"];
			}

			if (isset($input["vast_overlay_wrapper"])) {
				$vast_overlay_wrapper = $input["vast_overlay_wrapper"];
			} else {
				$vast_overlay_wrapper = $unparameters["vast_overlay_wrapper"];
			}
			if (isset($input["vast_overlay_format"])) {
				$vast_overlay_format = $input["vast_overlay_format"];
			} else {
				$vast_overlay_format = $unparameters["vast_overlay_format"];
			}
			$campaignid = "select campaignid from " . $table_prefix . "banners where bannerid=:bannerid";
			$campaignid_det = $this->db->prepare($campaignid);
			$campaignid_det->bindParam(":bannerid", $bannerid);
			$campaignid_det->execute();
			$campaignid_det = $campaignid_det->fetch();

			$banner_list = "select * from " . $table_prefix . "banners where campaignid=:campaignid";
			$allbanners_det = $this->db->prepare($banner_list);
			$allbanners_det->bindParam(":campaignid", $campaignid_det['campaignid']);
			$allbanners_det->execute();
			$details = $allbanners_det->fetchAll();
			$num = count($details);
			$bannerdetails = array();
			if ($num > 0) {
				if (isset($vast_companion_banner_id)) {
					foreach ($details as $banner) {
						$bannerdetails[$banner['bannerid']] = array(
							'campaignid' => $banner['campaignid'],
							'bannerid' => $banner['bannerid']
						);

						if ($vast_companion_banner_id == ($bannerdetails[$banner['bannerid']]['bannerid'])) {
							$flag = 1;
							break;
						} else {
							$flag = 2;
						}
					}

					if ($flag == 2) {
						$response = array('response' => 'error', 'Message' => 'Please enter valid banner id','status' => '404');

						return $this->response->withJson($response);
					}
				}
			}

			$var = [];
			$var = [
				"banner_vast_element_id" => "banner_vast_element_id",
				"vast_element_type" => "singlerow",
				"vast_video_id" => "N",
				"vast_video_delivery" => $vast_video_delivery,
				"vast_thirdparty_clicktracking" => $vast_thirdparty_clicktracking,
				"vast_version" => $vast_version,
				"vast_thirdparty_companion_clicktracking" => $vast_thirdparty_companion_clicktracking,
				"vast_video_skip_duration" => $vast_video_skip_duration,
				"vast_thirdparty_clickcustom" => $vast_thirdparty_clickcustom,
				"vast_video_bitrate" => 400,
				"vast_overlay_height" => 480,
				"vast_overlay_width" => 640,
				"vast_wrapper_url" => $vast_wrapper_url,
				"vast_overlay_wrapper" => $vast_overlay_wrapper,
				"vast_overlay_expanded_width" => $vast_overlay_expanded_width,
				"vast_overlay_expanded_height" => $vast_overlay_expanded_height,
				"vast_overlay_expandedminduration" => $vast_overlay_expandedminduration,
				"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
				"vast_thirdparty_companion_expandedwidth" => $vast_thirdparty_companion_expandedwidth,
				"vast_thirdparty_companion_expandedheight" => $vast_thirdparty_companion_expandedheight,
				"vast_video_skip_progress_duration" => $vast_video_skip_progress_duration,
				"vast_overlay_height" => $vast_overlay_height,
				"vast_overlay_width" => $vast_overlay_width,
				"vast_overlay_text_title" => "N",
				"vast_overlay_text_description" => "N",
				"vast_overlay_text_call" => "N",
				"vast_overlay_format" => $vast_overlay_format,
				"vast_overlay_action" => "N",
				"vast_companion_banner_id" => $vast_companion_banner_id,
				"vast_creative_type" => $vast_creative_type,
				"vast_thirdparty_impression" => $vast_thirdparty_impression,
			];

			$parameters = serialize($var);

			$editbanner1 =
				"update " . $table_prefix . "banners set 
			description=:description,
			filename='" .
				$imageurl .
				"',
			width='" .
				$width .
				"',
			height='" .
				$height .
				"',
			url='" .
				$url .
				"',
			comments=:comments,
			updated=:updated,
			keyword=:keyword,
			append=:append,
			prepend=:prepend,
			url=:url,
			parameters=:parameters
			where bannerid=:bannerid";

			$djax_query_banners = $this->db->prepare($editbanner1);
			$djax_query_banners->bindParam(":bannerid", $bannerid);
			$djax_query_banners->bindParam(":description", $description);
			$djax_query_banners->bindParam(":comments", $comments);
			$djax_query_banners->bindParam(":updated", $datetime);
			$djax_query_banners->bindParam(":keyword", $keyword);
			$djax_query_banners->bindParam(":append", $append);
			$djax_query_banners->bindParam(":prepend", $prepend);
			$djax_query_banners->bindParam(":url", $url);
			$djax_query_banners->bindParam(":parameters", $parameters);
			$djax_query_banners->execute();


			$editvastparameters =
				"update " . $table_prefix . "djaxbanner_vast_element set
			vast_video_delivery=:vast_video_delivery,
			vast_wrapper_url='" .
				$vast_wrapper_url .
				"',
			vast_overlay_wrapper='" .
				$vast_overlay_wrapper .
				"',
			vast_video_skip_duration='" .
				$vast_video_skip_duration .
				"',
			vast_video_skip_progress_duration='" .
				$vast_video_skip_progress_duration .
				"',
			vast_version='" .
				$vast_version .
				"',
			vast_type='" .
				$vast_version .
				"',
			vast_type='" .
				$vast_version .
				"',
			vast_overlay_height='" .
				$vast_overlay_height .
				"',
			vast_overlay_width='" .
				$vast_overlay_width .
				"',
			vast_creative_type='" .
				$vast_creative_type .
				"',
			vast_thirdparty_clicktracking='" .
				$vast_thirdparty_clicktracking .
				"',
			vast_thirdparty_clickcustom='" .
				$vast_thirdparty_clickcustom .
				"',
			vast_thirdparty_companion_clicktracking='" .
				$vast_thirdparty_companion_clicktracking .
				"',
			vast_thirdparty_companion_expandedwidth='" .
				$vast_thirdparty_companion_expandedwidth .
				"',
			vast_thirdparty_companion_expandedheight='" .
				$vast_thirdparty_companion_expandedheight .
				"',
			vast_overlay_expanded_width='" .
				$vast_overlay_expanded_width .
				"',
			vast_overlay_expanded_height='" .
				$vast_overlay_expanded_height .
				"',
			vast_overlay_expandedminduration='" .
				$vast_overlay_expandedminduration .
				"',
			vast_overlay_format='" .
				$vast_overlay_format .
				"',
			vast_companion_banner_id=:vast_companion_banner_id,
			vast_video_clickthrough_url=:vast_video_clickthrough_url,
			vast_thirdparty_impression=:vast_thirdparty_impression where banner_id=:banner_id ";

			$djax_query_banners_parameters = $this->db->prepare(
				$editvastparameters
			);
			$djax_query_banners_parameters->bindParam(
				":vast_video_delivery",
				$vast_video_delivery
			);
			$djax_query_banners_parameters->bindParam(
				":vast_companion_banner_id",
				$vast_companion_banner_id
			);
			$djax_query_banners_parameters->bindParam(
				":vast_video_clickthrough_url",
				$vast_video_clickthrough_url
			);
			$djax_query_banners_parameters->bindParam(
				":vast_thirdparty_impression",
				$vast_thirdparty_impression
			);
			//new
			$djax_query_banners->bindParam(
				":vast_thirdparty_companion_expandedheight",
				$vast_thirdparty_companion_expandedheight
			);
			$djax_query_banners->bindParam(
				":vast_thirdparty_companion_expandedwidth",
				$vast_thirdparty_companion_expandedwidth
			);
			$djax_query_banners->bindParam(
				":vast_thirdparty_clickcustom",
				$vast_thirdparty_clickcustom
			);
			$djax_query_banners->bindParam(
				":vast_thirdparty_clicktracking",
				$vast_thirdparty_clicktracking
			);
			$djax_query_banners->bindParam(":vast_version", $vast_version);
			$djax_query_banners->bindParam(
				":vast_video_skip_progress_duration",
				$vast_video_skip_progress_duration
			);
			$djax_query_banners->bindParam(
				":vast_video_skip_duration",
				$vast_video_skip_duration
			);
			$djax_query_banners->bindParam(
				":vast_wrapper_url",
				$vast_wrapper_url
			);
			//end
			$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);
			$djax_query_banners_parameters->execute();

			if (
				isset($input["vast_wrapper_url"]) &&
				$input["vast_wrapper_url"] == ""
			) {
				$response1 = [
					"response" => "error",
					"Message" => "vast_wrapper_url must not be empty",
					'status' => '403'
				];
				return $this->response->withJson($response1);
			}

			if (isset($input["description"]) && $input["description"] == "") {
				$response2 = [
					"response" => "error",
					"Message" => "description must not be empty",
					'status' => '403'
				];
				return $this->response->withJson($response2);
			}

			if (isset($input["vast_version"]) && $input["vast_version"] == "") {
				$response3 = [
					"response" => "error",
					"Message" => "vast_version must not be empty",
					'status' => '403'
				];
				return $this->response->withJson($response3);
			} else {
				$response = [
					"response" => "ok",
					"Message" => "Banner Updated Successfully",
					'status' => '200'
				];
				return $this->response->withJson($response);
			}
		} else {
			$response = [
				"response" => "error",
				"Message" => "Please enter valid bannerid",
				'status' => '403'
			];
			return $this->response->withJson($response);
		}
	}
});


// Invocation Tag generation of VAST VIDEO FEATURES

/*
 * Vast Inline tag
 * 
 * Input Parameters:
 * --------------- 
 * vtype 
 * comments
 * midrolloffset
 * playerurl
 * tparty 
 */

$app->post('/advancedvast_vast_invoke_inlinevast/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		// return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$sql = "select zoneid,width,height from " . $table_prefix . "zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$vtype 			= (isset($input['vtype'])) ? $input['vtype'] : '';
		$cmnd 			= (isset($input['comments'])) ? $input['comments'] : '';
		$full_url = $this->get('settings')['path']['delivery'];
		// $full_url=substr($full_url, 0, -5).'delivery';

		if (!$zoneav) {
			$res = array(
				'response' => 'Error',
				'Message' => 'Zone is Not Avaliable',
				'status' => '404'
			);
			return $this->response->withJson($res);
		}

		//Video position
		if ($vtype == 1) {
			$version = 2;
		} else if ($vtype == 2) {
			$version = 3;
		} else if ($vtype == 3) {
			$version = 4;
		} else if ($vtype == 4) {
			$version = 4.1;
		}


		//source validation
		if ($cmnd == 1) {
			$cmnd = "<!--/*
		*
		* Revive Adserver Vast Inline 2.0 AD tag
		
		*
		*/-->

		<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
		* a generated random number (or timestamp).
		*
		*/-->";
		} else {
			$cmnd = "";
		}

		$full_url = $this->get('settings')['path']['vasttagdelivery'];

		if ($_SERVER["HTTPS"] == "on") {
			$https = 'https';
		} else {
			$https = 'http';
		}
		$vast_inline2 = "$https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&format=vast$version&totimp={total_imp}&series={series}&episode={episode}&title={title}&gender={gender}&age={age}&genre={genre}";

		if ($vtype == 1) {
			$res = array(
				'response' => 'tag',
				'Vast Inline 2.0 Invocation tag' => $vast_inline2,
				'status' => '200'

			);
		} else if ($vtype == 2) {
			$res = array(
				'response' => 'tag',
				'Vast Inline 3.0 Invocation tag' => $vast_inline2,
				'status' => '200'

			);
		} else if ($vtype == 3) {
			$res = array(
				'response' => 'tag',
				'Vast Inline 4.0 Invocation tag' => $vast_inline2,
				'status' => '200'

			);
		} else if ($vtype == 4) {
			$res = array(
				'response' => 'tag',
				'Vast Inline 4.1 Invocation tag' => $vast_inline2,
				'status' => '200'

			);
		} else {
			$res = array(
				'response' => 'Error',
				'Message' => 'vast version is Invalid',
				'status' => '403'
			);
		}
		return ($this->response->withJson($res));

		return $response;
	}
});


/*
 * Vast Inline Wrapper tag
 * 
 * Input Parameters:
 * --------------- 
 * vtype 
 * comments
 * midrolloffset
 * playerurl
 * tparty 
 */

$app->post('/advancedvast_vast_invoke_inlinevastwrapper/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$sql = "select zoneid,width,height from  " . $table_prefix . "zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$vtype 			= (isset($input['vtype'])) ? $input['vtype'] : '';
		$cmnd 			= (isset($input['comments'])) ? $input['comments'] : '';

		if (!$zoneav) {
			$res = array(
				'response' => 'Error',
				'Message' => 'Zone is Not Avaliable',
				'status' => '403'
			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		if ($vtype == 1) {
			$version = "vast2_wrapper";
		} else if ($vtype == 2) {
			$version = "vast3_wrapper";
		} else if ($vtype == 3) {
			$version = "vast4_wrapper";
		} else if ($vtype == 4) {
			$version = "vast4.1_wrapper";
		}


		//~ 
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
		*
		* Revive Adserver Vast Inline Wrapper 2.0 AD tag
		
		*
		*/-->

		<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
		* a generated random number (or timestamp).
		*
		*/-->";
		} else {
			$cmnd = "";
		}

		$full_url = $this->get('settings')['path']['vasttagdelivery'];

		if ($_SERVER["HTTPS"] == "on") {
			$https = 'https';
		} else {
			$https = 'http';
		}
		$vast_inlinewrapper = "$https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&format=$version&totimp={total_imp}&series={series}&episode={episode}&title={title}&gender={gender}&age={age}&genre={genre}";

		if ($vtype == 1) {
			$res = array(
				'response' => 'tag',
				'Vast Inline Wrapper 2.0 Invocation tag' => $vast_inlinewrapper,
				'status' => '200'

			);
		} else if ($vtype == 2) {
			$res = array(
				'response' => 'tag',
				'Vast Inline Wrapper 3.0 Invocation tag' => $vast_inlinewrapper,
				'status' => '200'

			);
		} else if ($vtype == 3) {
			$res = array(
				'response' => 'tag',
				'Vast Inline Wrapper 4.0 Invocation tag' => $vast_inlinewrapper,
				'status' => '200'

			);
		} else if ($vtype == 4) {
			$res = array(
				'response' => 'tag',
				'Vast Inline Wrapper 4.1 Invocation tag' => $vast_inlinewrapper,
				'status' => '200'

			);
		} else {
			$res = array(
				'response' => 'Error',
				'Message' => 'vast version is Invalid',
				'status' => '200'
			);
		}
		return ($this->response->withJson($res));

		return $response;
	}
});


/*
 * Vast INLINE AD POD tag
 * 
 * Input Parameters:
 * --------------- 
 * vtype 
 * comments
 * midrolloffset
 * playerurl
 * tparty 
 */

$app->post('/advancedvast_vast_invoke_vastadpod/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$sql = "select zoneid,width,height from " . $table_prefix . "zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$cto 			= (isset($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vtype 			= (isset($input['vtype'])) ? $input['vtype'] : '';
		$cmnd 			= (isset($input['comments'])) ? $input['comments'] : '';
		$limit 			= (isset($input['limit'])) ? $input['limit'] : '';

		if (!$zoneav) {
			$res = array(
				'response' => 'Error',
				'Message' => 'Zone is Not Avaliable',
				'status' => '404'
			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends
		//limit validation

		if ($limit) {
			$limit = $limit;
		} else {
			$limit = '';
		}


		if ($vtype == 2) {
			$version = "vast_pod";
		} else if ($vtype == 3) {
			$version = "vast4_pod";
		} else if ($vtype == 4) {
			$version = "vast4.1_pod";
		}

		//third party validation
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}

		//~ 
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
		*
		* Revive Adserver Vast Ad Pod tag
		
		*
		*/-->

		<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
		* a generated random number (or timestamp).
		*
		*/-->";
		} else {
			$cmnd = "";
		}
		$full_url = $this->get('settings')['path']['vasttagdelivery'];

		if ($_SERVER["HTTPS"] == "on") {
			$https = 'https';
		} else {
			$https = 'http';
		}
		$vastadpod = "$https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&limit=$limit&format=$version&totimp={total_imp}&series={series}&episode={episode}&title={title}&gender={gender}&age={age}&genre={genre}";


		if ($vtype == 2) {
			$res = array(
				'response' => 'tag',
				'Vast adpod 3.0 Invocation tag' => $vastadpod,
				'status' => '200'

			);
		} else if ($vtype == 3) {
			$res = array(
				'response' => 'tag',
				'Vast adpod 4.0 Invocation tag' => $vastadpod,
				'status' => '200'

			);
		} else if ($vtype == 4) {
			$res = array(
				'response' => 'tag',
				'Vast adpod 4.1 Invocation tag' => $vastadpod,
				'status' => '200'

			);
		} else {
			$res = array(
				'response' => 'Error',
				'Message' => 'vast version is Invalid',
				'status' => '403'
			);
		}

		return ($this->response->withJson($res));

		return $response;
	}
});

/*
 * Vast INLINE AD POD WRAPPER tag
 * 
 * Input Parameters:
 * --------------- 
 * vtype 
 * comments
 * midrolloffset
 * playerurl
 * tparty 
 */

$app->post('/advancedvast_vast_invoke_vastadpodwrapper/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$sql = "select zoneid,width,height from  " . $table_prefix . "zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$cto 			= (isset($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vast_validator = (isset($input['playerurl'])) ? $input['playerurl'] : '';
		$midrolloffset 			= (isset($input['midrolloffset'])) ? $input['midrolloffset'] : '';
		$vtype 			= (isset($input['vtype'])) ? $input['vtype'] : '';
		$cmnd 			= (isset($input['comments'])) ? $input['comments'] : '';
		$limit 			= (isset($input['limit'])) ? $input['limit'] : '';

		if (!$zoneav) {
			$res = array(
				'response' => 'Error',
				'Message' => 'Zone is Not Avaliable',
				'status' => '404'

			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends
		//limit validation

		if ($limit) {
			$limit = $limit;
		} else {
			$limit = '';
		}


		if ($vtype == 2) {
			$version = "vast_pod_wrapper";
		} else if ($vtype == 3) {
			$version = "vast4_pod_wrapper";
		} else if ($vtype == 4) {
			$version = "vast4.1_pod_wrapper";
		}

		//third party validation
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}

		//~ 
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
	  *
	  * Revive Adserver Vast Ad Pod Wrapper tag
	 
	  *
	  */-->
	
	<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
	  * a generated random number (or timestamp).
	  *
	  */-->";
		} else {
			$cmnd = "";
		}
		$full_url = $this->get('settings')['path']['vasttagdelivery'];

		if ($_SERVER["HTTPS"] == "on") {
			$https = 'https';
		} else {
			$https = 'http';
		}
		$vastadpodwrapper = "$https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&limit=$limit&format=$version&totimp={total_imp}&series={series}&episode={episode}&title={title}&gender={gender}&age={age}&genre={genre}";

		if ($vtype == 2) {
			$res = array(
				'response' => 'tag',
				'Vast adpod wrapper 3.0 Invocation tag' => $vastadpodwrapper,
				'status' => '200'

			);
		} else if ($vtype == 3) {
			$res = array(
				'response' => 'tag',
				'Vast adpod wrapper 4.0 Invocation tag' => $vastadpodwrapper,
				'status' => '200'

			);
		} else if ($vtype == 4) {
			$res = array(
				'response' => 'tag',
				'Vast adpod wrapper 4.1 Invocation tag' => $vastadpodwrapper,
				'status' => '200'

			);
		} else {
			$res = array(
				'response' => 'Error',
				'Message' => 'vast version is Invalid',
				'status' => '404'
			);
		}

		return ($this->response->withJson($res));

		return $response;
	}
});


/*
 * Vast OVERLAY tag
 * 
 * Input Parameters:
 * --------------- 
 * comments
 * playerurl
 * tparty 
 */

$app->post('/advancedvast_vast_invoke_vastoverlay/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$sql = "select zoneid,width,height from " . $table_prefix . "zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$cto 			= (isset($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vast_validator = (isset($input['playerurl'])) ? $input['playerurl'] : '';
		//~ $midrolloffset 			= (isset($input['midrolloffset']))?$input['midrolloffset']:'';
		$vtype 			= (isset($input['vtype'])) ? $input['vtype'] : '';
		$cmnd 			= (isset($input['comments'])) ? $input['comments'] : '';


		if (!$zoneav) {
			$res = array(
				'response' => 'Error',
				'Message' => 'Zone is Not Avaliable',
				'status' => '403'
			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends

		if ($vtype == 1) {
			$version = "vast2";
		} else if ($vtype == 2) {
			$version = "vast3";
		} else if ($vtype == 3) {
			$version = "vast4";
		} else if ($vtype == 4) {
			$version = "vast4.1";
		}

		//third party validation
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}

		//~ 
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
	  *
	  * Revive Adserver Vast Overlay 2.0 tag
	 
	  *
	  */-->
	
	  <!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
	  * a generated random number (or timestamp).
	  *
	  */-->";
		} else {
			$cmnd = "";
		}

		$full_url = $this->get('settings')['path']['vasttagdelivery'];

		if ($_SERVER["HTTPS"] == "on") {
			$https = 'https';
		} else {
			$https = 'http';
		}
		$vastoverlay = "$https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&format=$version&totimp={total_imp}&series={series}&episode={episode}&title={title}&gender={gender}&age={age}&genre={genre}";


		if ($vtype == 1) {
			$res = array(
				'response' => 'tag',
				'Vast Overlay 2.0 Invocation tag' => $vastoverlay,
				'status' => '200'

			);
		} else if ($vtype == 2) {
			$res = array(
				'response' => 'tag',
				'Vast Overlay 3.0 Invocation tag' => $vastoverlay,
				'status' => '200'

			);
		} else if ($vtype == 3) {
			$res = array(
				'response' => 'tag',
				'Vast Overlay 4.0 Invocation tag' => $vastoverlay,
				'status' => '200'

			);
		} else if ($vtype == 4) {
			$res = array(
				'response' => 'tag',
				'Vast Overlay 4.1 Invocation tag' => $vastoverlay,
				'status' => '200'

			);
		} else {
			$res = array(
				'response' => 'Error',
				'Message' => 'vast version is Invalid',
				'status' => '403'
			);
		}
		return ($this->response->withJson($res));

		return $response;
	}
});


/*
 * Vast OVERLAY Wrapper tag
 * 
 * Input Parameters:
 * --------------- 
 * comments
 * playerurl
 * tparty 
 */

$app->post('/advancedvast_vast_invoke_vastoverlaywrapper/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');

		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$sql = "select zoneid,width,height from " . $table_prefix . "zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$cto 			= (isset($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vtype 			= (isset($input['vtype'])) ? $input['vtype'] : '';
		//  $limit 			= (isset($input['limit']))?$input['limit']:'';
		$vast_validator = (isset($input['playerurl'])) ? $input['playerurl'] : '';
		$cmnd 			= (isset($input['comments'])) ? $input['comments'] : '';


		if ($vtype == 1) {
			$version = "vast2_wrapper";
		} else if ($vtype == 2) {
			$version = "vast3_wrapper";
		} else if ($vtype == 3) {
			$version = "vast4_wrapper";
		} else if ($vtype == 4) {
			$version = "vast4.1_wrapper";
		}

		if (!$zoneav) {
			$res = array(
				'response' => 'Error',
				'Message' => 'Zone is Not Avaliable',
				'status' => '404'

			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends


		//third party validation
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}


		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
	  *
	  * Revive Adserver Vast Overlay wrapper 2.0 tag
	 
	  *
	  */-->
	
	<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
	  * a generated random number (or timestamp).
	  *
	  */-->";
		} else {
			$cmnd = "";
		}
		$full_url = $this->get('settings')['path']['vasttagdelivery'];

		if ($_SERVER["HTTPS"] == "on") {
			$https = 'https';
		} else {
			$https = 'http';
		}
		$vastoverlaywrapper = "$https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&type=&format=$version&totimp={total_imp}&series={series}&episode={episode}&title={title}&gender={gender}&age={age}&genre={genre}";

		if ($vtype == 1) {
			$res = array(
				'response' => 'tag',
				'Vast Overlay wrapper 2.0 Invocation tag' => $vastoverlaywrapper,
				'status' => '200'

			);
		} else if ($vtype == 2) {
			$res = array(
				'response' => 'tag',
				'Vast Overlay wrapper 3.0 Invocation tag' => $vastoverlaywrapper,
				'status' => '200'

			);
		} else if ($vtype == 3) {
			$res = array(
				'response' => 'tag',
				'Vast Overlay wrapper 4.0 Invocation tag' => $vastoverlaywrapper,
				'status' => '200'

			);
		} else if ($vtype == 4) {
			$res = array(
				'response' => 'tag',
				'Vast Overlay wrapper 4.1 Invocation tag' => $vastoverlaywrapper,
				'status' => '200'

			);
		} else {
			$res = array(
				'response' => 'Error',
				'Message' => 'vast version is Invalid',
				'status' => '404'
			);
		}

		return ($this->response->withJson($res));

		return $response;
	}
});
