<?php

/*---------------- Start of Agency Statistics -------------*/

$app->get('/get_agency_advertiser_statistics/[{start_date},{end_date},{agency_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $agencyid = $args['agency_id'];
        $stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("agency_id", $args['agency_id']);
        $std->execute();
        $agency = $std->fetchAll();
        if ($agency)
        {
			$sql = "select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			b.bannerid as bannerid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			cl.agencyid as agencyid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm	 
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."agency as g
			where
			h.ad_id = b.bannerid
			AND b.campaignid = c.campaignid
			AND g.agencyid = :agencyid
			AND cl.agencyid = g.agencyid
			AND cl.clientid = c.clientid
			AND h.date_time between '".$startdate."'
			AND '".$enddate."' group by clientid";
				
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":agencyid", $agencyid);
            $sth->execute();
            $todos = $sth->fetchAll();
            
            if ($todos)
            {				                                   
				$data['data'] = $todos;			
				$data['response']="success";
				$data['message']="Agencywise Advertiser Statistics";
				$data['status']="200";                    
				
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available','response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }           
        }
        else
        {
            $response = array('message' => 'Please enter valid Agency Id','response' => 'error','status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));


$app->get('/get_agency_campaign_statistics/[{start_date},{end_date},{agency_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $agencyid = $args['agency_id'];
        $stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("agency_id", $args['agency_id']);
        $std->execute();
        $agency = $std->fetchAll();
        if ($agency)
        {
            $sql = "select 
		g.agencyid as agencyid,
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		COALESCE(sum(h.total_revenue),0) as revenue,
		b.campaignid as campaignid,
		c.campaignname as campaignname,
		cl.clientid as clientid,
		cl.agencyid as agencyid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,	
		ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm	 
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."agency as g
		where
		h.ad_id = b.bannerid
		AND b.campaignid = c.campaignid
		AND g.agencyid = :agencyid
		AND cl.agencyid = g.agencyid
		AND c.clientid = cl.clientid 
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by campaignid";
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":agencyid", $agencyid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Agencywise Campaign Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Agency Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));


$app->get('/get_agency_banner_statistics/[{start_date},{end_date},{agency_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $agencyid = $args['agency_id'];
        $stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("agency_id", $args['agency_id']);
        $std->execute();
        $agency = $std->fetchAll();
        if ($agency)
        {
            $sql = "select 
			g.agencyid as agencyid,
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			b.description as bannername,
			b.campaignid as campaignid,
			c.campaignid as camp,
			c.clientid as client,
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm		
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."agency as g
			where
			h.ad_id = b.bannerid
			AND g.agencyid = :agencyid
			AND cl.agencyid = g.agencyid
			AND b.campaignid = c.campaignid   
			AND c.clientid = cl.clientid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by ad_id";
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":agencyid", $agencyid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Agencywise Banner Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Agency Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));


$app->get('/get_agency_publisher_statistics/[{start_date},{end_date},{agency_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $agency_id = $args['agency_id'];
        $stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("agency_id", $args['agency_id']);
        $std->execute();
        $agency = $std->fetchAll();
        if ($agency)
        {
            $sql = "select 
			g.agencyid as agencyid,
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			a.name as affiliatename, 
			z.affiliateid as affiliateid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as a,
			".$table_prefix."zones as z,
			".$table_prefix."agency as g
			where
			h.zone_id = z.zoneid
			AND g.agencyid = :agencyid
			AND a.agencyid = g.agencyid
			AND a.affiliateid = z.affiliateid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by  affiliateid";
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":agencyid", $agency_id);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Agencywise Publisher Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Agency Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));


$app->get('/get_agency_zone_statistics/[{start_date},{end_date},{agency_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $agencyid = $args['agency_id'];
        $stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("agency_id", $args['agency_id']);
        $std->execute();
        $agency = $std->fetchAll();
        if ($agency)
        {
            $sql = "select 
		g.agencyid as agencyid,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		COALESCE(sum(h.total_revenue),0) as revenue,
		z.zoneid as zoneid,
		z.zonename as zonename,
		z.affiliateid as affiliateid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."affiliates as a,
		".$table_prefix."zones as z,
		".$table_prefix."agency as g
		where
		z.zoneid = h.zone_id
		AND g.agencyid = :agencyid
		AND a.agencyid = g.agencyid
		AND a.affiliateid = z.affiliateid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by zoneid";
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":agencyid", $agencyid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Agencywise Zone Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Agency Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));


$app->get('/get_agency_daily_statistics/[{start_date},{end_date},{agency_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $agency_id = $args['agency_id'];
        $stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("agency_id", $args['agency_id']);
        $std->execute();
        $agency = $std->fetchAll();
        if ($agency)
        {
            $sql = "select 
			g.agencyid as agencyid,
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			b.bannerid as bannerid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."agency as g
			where
			h.ad_id = b.bannerid
			AND b.campaignid = c.campaignid
			AND c.clientid = cl.clientid
			AND g.agencyid = :agencyid		
			AND cl.agencyid = g.agencyid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by DATE(date_time)";
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":agencyid", $agency_id);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Agencywise Daily Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Agency Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

/*---------------- End of Agency Statistics -------------*/


/*--------------- Start of Advertiser Statistics ------------*/

$app->get('/get_advertiser_daily_statistics/[{start_date},{end_date},{advertiser_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $advertiser_id = $args['advertiser_id'];
        $stc = "select * from ".$table_prefix."clients where clientid=:advertiser_id";
        $std = $this->db->prepare($stc);
        $std->bindParam(":advertiser_id", $advertiser_id);
        $std->execute();
        $client = $std->fetchAll();
        if ($client)
        {
            $sql = "select 
            DATE(h.date_time) as date_time,
            sum(h.impressions) as impressions,
            sum(h.clicks) as clicks,
            sum(h.conversions) as conversions,
            COALESCE(sum(h.total_revenue),0) as revenue,
            b.bannerid as bannerid,
            b.campaignid as campaignid,
            c.clientid as client,
            cl.clientid as clientid,
            (sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
            ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm 
            from
            ".$table_prefix."data_summary_ad_hourly as h,
            ".$table_prefix."banners as b,
            ".$table_prefix."campaigns as c,
            ".$table_prefix."clients as cl
            where
            h.ad_id = b.bannerid
            AND b.campaignid = c.campaignid
            AND c.clientid = cl.clientid
            AND cl.clientid = :advertiser
            AND DATE(h.date_time) between '".$startdate."' and 
            '".$enddate."' group by DATE(date_time)";
            
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":advertiser", $advertiser_id);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Advertiser Daily Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Advertiser Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));


$app->get('/get_advertiser_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $advertiser_id = $args['advertiser_id'];
        $stc = "select * from ".$table_prefix."clients where clientid=:client_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("client_id", $advertiser_id);
        $std->execute();
        $client = $std->fetchAll();
        if ($client)
        {
			$sql = "select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm 
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by campaignid";
			
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":advertiserid", $advertiser_id);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Advertiserwise Campaign Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Advertiser Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));


$app->get('/get_advertiser_banner_statistics/[{start_date},{end_date},{advertiser_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $advertiser_id = $args['advertiser_id'];
        $stc = "select * from ".$table_prefix."clients where clientid=:client_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("client_id", $advertiser_id);
        $std->execute();
        $client = $std->fetchAll();
        if ($client)
        {
			$sql = "select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			b.description as bannername,
			cl.clientid as clientid,        
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm     
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl
			where
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' GROUP BY ad_id";
			
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":advertiserid", $advertiser_id);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Advertiserwise banner Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Advertiser Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));


$app->get('/get_advertiser_publisher_statistics/[{start_date},{end_date},{advertiser_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $advertiser_id = $args['advertiser_id'];
        $stc = "select * from ".$table_prefix."clients where clientid=:client_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("client_id", $advertiser_id);
        $std->execute();
        $client = $std->fetchAll();
        if ($client)
        {
			$sql = "select 
			h.ad_id as ad_id,
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			p.name as affiliatename,
			cl.clientid as clientid,    
			p.affiliateid as affiliateid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm 
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND cl.clientid = c.clientid
			AND z.affiliateid =  p.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by affiliateid";
        }
        else
        {
            $response = array('message' => 'Please enter valid Advertiser Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
        $sth = $this->db->prepare($sql);
        $sth->bindParam(":advertiserid", $advertiser_id);
        $sth->execute();
        $todos = $sth->fetchAll();
        if ($todos)
        {
            $data['data'] = $todos;
            $data['response'] = "success";
            $data['message'] = "Advertiserwise Publisher Statistics";
            $data['status'] = "200";
            return $this->response->withJson($data);
        }
        else
        {
            $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));


$app->get('/get_advertiser_zone_statistics/[{start_date},{end_date},{advertiser_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $advertiser_id = $args['advertiser_id'];
        $stc = "select * from ".$table_prefix."clients where clientid=:client_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("client_id", $advertiser_id);
        $std->execute();
        $client = $std->fetchAll();
        if ($client)
        {
			$sql = "select 
			h.ad_id as ad_id,
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			h.impressions as impressions,
			h.clicks as clicks,
			h.conversions as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			z.affiliateid as affiliateid,
			z.zonename as zonename,
			p.agencyid as agencyid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm  
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND p.affiliateid = z.affiliateid
			AND h.zone_id = z.zoneid
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by zoneid";
			
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":advertiserid", $advertiser_id);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Advertiserwise Zone Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Advertiser Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

/*--------------- End of Advertiser Statistics ------------*/

/*--------------- Start of Campaign Statistics ------------*/

$app->get('/get_campaign_daily_statistics/[{start_date},{end_date},{campaign_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $campaignid = $args['campaign_id'];
        $stc = "select * from ".$table_prefix."campaigns where campaignid=:campaign_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("campaign_id", $campaignid);
        $std->execute();
        $campaign = $std->fetchAll();
        if ($campaign)
        {
			$sql = "select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			c.clientid as clientid,
			c.campaignname as campaignname,
			cl.agencyid as agencyid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm 
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."agency as a
			where
			h.ad_id = b.bannerid
			AND b.campaignid = c.campaignid
			AND c.campaignid = :campaignid
			AND a.agencyid=cl.agencyid
			AND cl.clientid=c.clientid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by DATE(date_time)";
        
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":campaignid", $campaignid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Campaignwise Daily Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Campaign Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

$app->get('/get_campaign_banner_statistics/[{start_date},{end_date},{campaign_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $campaignid = $args['campaign_id'];
        $stc = "select * from ".$table_prefix."campaigns where campaignid=:campaign_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("campaign_id", $campaignid);
        $std->execute();
        $campaign = $std->fetchAll();
        if ($campaign)
        {
			$sql = "select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			b.bannerid as bannerid,
			b.description as bannername,
			b.campaignid as campaignid,
			c.clientid as clientid,
			c.campaignname as campaignname,
			cl.agencyid as agencyid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."agency as a
			where
			h.ad_id = b.bannerid
			AND b.campaignid = c.campaignid
			AND c.campaignid = :campaign_id
			AND a.agencyid=cl.agencyid
			AND cl.clientid=c.clientid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by ad_id";
        
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":campaign_id", $campaignid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Campaignwise Banner Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Campaign Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

$app->get('/get_campaign_publisher_statistics/[{start_date},{end_date},{campaign_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $campaignid = $args['campaign_id'];
        $stc = "select * from ".$table_prefix."campaigns where campaignid=:campaign_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("campaign_id", $campaignid);
        $std->execute();
        $campaign = $std->fetchAll();
        if ($campaign)
        {
			$sql = "select 
			p.agencyid as agencyid,
			h.ad_id as ad_id,
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			b.bannerid as bannerid,
			b.description as bannername,
			b.campaignid as campaignid,
			p.affiliateid as affiliateid,       
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm 
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND z.zoneid = h.zone_id
			AND b.campaignid =:campaignid
			AND c.campaignid =b.campaignid
			AND z.affiliateid = p.affiliateid
			AND DATE(h.date_time) between '".$startdate."'
			and '".$enddate."' group by affiliateid";
        
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":campaignid", $campaignid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Campaignwise Publisher Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Campaign Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

$app->get('/get_campaign_zone_statistics/[{start_date},{end_date},{campaign_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $input = $request->getParsedBody();
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $campaignid = $args['campaign_id'];
        $stc = "select * from ".$table_prefix."campaigns where campaignid=:campaign_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("campaign_id", $campaignid);
        $std->execute();
        $campaign = $std->fetchAll();
        if ($campaign)
        {
			$sql = "select 
			h.ad_id as ad_id,
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			p.affiliateid as affiliateid,
			z.zonename as zonename,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm     
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND h.zone_id = z.zoneid
			AND b.campaignid = :campaignid
			AND c.campaignid = b.campaignid
			AND p.affiliateid = z.affiliateid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by zoneid";
			
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":campaignid", $campaignid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Campaignwise Zone Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Campaign Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

/*--------------- End of Campaign Statistics ------------*/

/*--------------- Start of Banner Statistics ------------*/

$app->get('/get_banner_daily_statistics/[{start_date},{end_date},{banner_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $bannerid = $args['banner_id'];
        $stc = "select * from ".$table_prefix."banners where bannerid=:banner_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("banner_id", $bannerid);
        $std->execute();
        $banners = $std->fetchAll();
        if ($banners)
        {
            $sql = "select      
            DATE(h.date_time) as date_time,
            sum(h.impressions) as impressions,
            sum(h.clicks) as clicks,                    
            (sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
            ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm,
            sum(h.conversions) as conversions,
            COALESCE(sum(h.total_revenue),0) as revenue,
            b.bannerid as bannerid
            from
            ".$table_prefix."data_summary_ad_hourly as h,
            ".$table_prefix."banners as b
            where
            h.ad_id = :bannerid
            AND b.bannerid = :bannerid
            AND DATE(h.date_time) between '".$startdate."'
            AND '".$enddate."' group by DATE(date_time)";
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":bannerid", $bannerid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Bannerwise Daily Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Banner Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

$app->get('/get_banner_publisher_statistics/[{start_date},{end_date},{banner_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $bannerid = $args['banner_id'];
        $stc = "select * from ".$table_prefix."banners where bannerid=:banner_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("banner_id", $bannerid);
        $std->execute();
        $banners = $std->fetchAll();
        if ($banners)
        {
			$sql = "select      
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm,            
			b.bannerid as bannerid,
			p.name as affiliatename,
			p.affiliateid as affiliateid
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."affiliates as p,   
			".$table_prefix."zones as z
			where
			h.ad_id = :bannerid
			AND b.bannerid = h.ad_id
			AND p.affiliateid = z.affiliateid
			AND z.zoneid = h.zone_id 
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."'  group by affiliateid";
        
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":bannerid", $bannerid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Bannerwise Publisher Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Banner Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

$app->get('/get_banner_zone_statistics/[{start_date},{end_date},{banner_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $bannerid = $args['banner_id'];
        $stc = "select * from ".$table_prefix."banners where bannerid=:banner_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("banner_id", $bannerid);
        $std->execute();
        $banners = $std->fetchAll();
        if ($banners)
        {
			$sql = "select 
			h.zone_id as zoneid,        
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			COALESCE(sum(h.total_revenue),0) as revenue,
			b.bannerid as bannerid,
			p.affiliateid as affiliateid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."affiliates as p,   
			".$table_prefix."zones as z
			where
			h.ad_id = :bannerid
			AND b.bannerid = h.ad_id
			AND p.affiliateid = z.affiliateid 
			AND h.zone_id = z.zoneid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by zoneid";
        
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":bannerid", $bannerid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Bannerwise Zone Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Banner Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

/*--------------- End of Banner Statistics ------------*/


/*--------------- Start of Publisher Statistics ------------*/

$app->get('/get_publisher_daily_statistics/[{start_date},{end_date},{publisher_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $publisherid = $args['publisher_id'];
        $stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
        $std = $this->db->prepare($stc);
        $std->bindParam("affiliateid", $publisherid);
        $std->execute();
        $publishers = $std->fetchAll();
        if ($publishers)
        {
            $sql = "select 
            h.zone_id as zoneid,
            DATE(h.date_time) as date_time,
            sum(h.impressions) as impressions,
            sum(h.clicks) as clicks,
            sum(h.conversions) as conversions,
            COALESCE(sum(h.total_revenue),0) as revenue,
            al.affiliateid as affiliateid,
            (sum(h.clicks)/sum(h.impressions)) * 100 as ctr,            
            ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm,
            al.name as name
            from
            ".$table_prefix."data_summary_ad_hourly as h,
            ".$table_prefix."zones as z,
            ".$table_prefix."affiliates as al
            where
            h.zone_id = z.zoneid
            AND al.affiliateid = z.affiliateid
            AND z.affiliateid = :publisherid
            AND DATE(h.date_time) between '".$startdate."'
            AND '".$enddate."' group by DATE(h.date_time)";
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":publisherid", $publisherid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Publisherwise Daily Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Publisher Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

$app->get('/get_publisher_zone_statistics/[{start_date},{end_date},{publisher_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $publisherid = $args['publisher_id'];
        $stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
        $std = $this->db->prepare($stc);
        $std->bindParam("affiliateid", $publisherid);
        $std->execute();
        $publishers = $std->fetchAll();
        if ($publishers)
        {
            $sql = "select 
            h.ad_id as ad_id,
            h.zone_id as zoneid,
            DATE(h.date_time) as date_time,
            sum(h.impressions) as impressions,
            sum(h.clicks) as clicks,
            sum(h.conversions) as conversions,
            COALESCE(sum(h.total_revenue),0) as revenue,
            b.bannerid as bannerid,
            b.campaignid as campaignid,
            cl.clientid as clientid,
            (sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
            ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm,
            p.affiliateid as affiliateid,
            p.name as affiliatename,
            z.zonename as zonename
            from
            ".$table_prefix."data_summary_ad_hourly as h,
            ".$table_prefix."banners as b,
            ".$table_prefix."campaigns as c,
            ".$table_prefix."clients as cl,
            ".$table_prefix."affiliates as p,
            ".$table_prefix."zones as z
            where
            h.ad_id = b.bannerid
            AND cl.clientid = c.clientid
            AND p.affiliateid = :publisherid
            and p.affiliateid=z.affiliateid
            AND z.zoneid = h.zone_id
            AND b.campaignid = c.campaignid
            AND DATE(h.date_time) between '".$startdate."'
            AND '".$enddate."' group by zoneid";
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":publisherid", $publisherid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Publisherwise Zone Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Publisher Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

$app->get('/get_publisher_advertiser_statistics/[{start_date},{end_date},{publisher_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $publisherid = $args['publisher_id'];
        $stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
        $std = $this->db->prepare($stc);
        $std->bindParam("affiliateid", $publisherid);
        $std->execute();
        $publishers = $std->fetchAll();
        if ($publishers)
        {
            $sql = "select 
            h.ad_id as ad_id,
            h.zone_id as zoneid,
            DATE(h.date_time) as date_time,
            sum(h.impressions) as impressions,
            sum(h.clicks) as clicks,
            sum(h.conversions) as conversions,
            COALESCE(sum(h.total_revenue),0) as revenue,
            b.bannerid as bannerid,
            b.campaignid as campaignid,
            cl.clientid as clientid,
            (sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
            ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm,
            p.affiliateid as affiliateid,
            p.name as affiliatename,
            cl.clientname as clientname
            from
            ".$table_prefix."data_summary_ad_hourly as h,
            ".$table_prefix."banners as b,
            ".$table_prefix."campaigns as c,
            ".$table_prefix."clients as cl,
            ".$table_prefix."affiliates as p,
            ".$table_prefix."zones as z
            where
            h.ad_id = b.bannerid
            AND cl.clientid = c.clientid
            AND p.affiliateid = :publisherid
            and p.affiliateid=z.affiliateid
            AND z.zoneid = h.zone_id
            AND b.campaignid = c.campaignid
            AND DATE(h.date_time) between '".$startdate."'
            AND '".$enddate."' group by clientid";
            
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":publisherid", $publisherid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Publisherwise Advertiser Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Publisher Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

$app->get('/get_publisher_campaign_statistics/[{start_date},{end_date},{publisher_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $publisherid = $args['publisher_id'];
        $stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
        $std = $this->db->prepare($stc);
        $std->bindParam("affiliateid", $publisherid);
        $std->execute();
        $publishers = $std->fetchAll();
        if ($publishers)
        {
            $sql = "select 
            h.ad_id as ad_id,
            h.zone_id as zoneid,
            DATE(h.date_time) as date_time,
            sum(h.impressions) as impressions,
            sum(h.clicks) as clicks,
            sum(h.conversions) as conversions,
            COALESCE(sum(h.total_revenue),0) as revenue,
            b.bannerid as bannerid,
            b.campaignid as campaignid,
            cl.clientid as clientid,
            (sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
            ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm,
            p.affiliateid as affiliateid,
            p.name as name,
            c.campaignname as campaignname
            from
            ".$table_prefix."data_summary_ad_hourly as h,
            ".$table_prefix."banners as b,
            ".$table_prefix."campaigns as c,
            ".$table_prefix."clients as cl,
            ".$table_prefix."affiliates as p,
            ".$table_prefix."zones as z
            where
            h.ad_id = b.bannerid
            AND cl.clientid = c.clientid
            AND p.affiliateid = :publisherid
            and p.affiliateid=z.affiliateid
            AND z.zoneid = h.zone_id
            AND b.campaignid = c.campaignid
            AND DATE(h.date_time) between '".$startdate."'
            AND '".$enddate."' group by campaignid";
            
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":publisherid", $publisherid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Publisher Campaign Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Publisher Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

$app->get('/get_publisher_banner_statistics/[{start_date},{end_date},{publisher_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $publisherid = $args['publisher_id'];
        $stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
        $std = $this->db->prepare($stc);
        $std->bindParam("affiliateid", $publisherid);
        $std->execute();
        $publishers = $std->fetchAll();
        if ($publishers)
        {
            $sql = "select 
            h.ad_id as ad_id,
            h.zone_id as zoneid,
            DATE(h.date_time) as date_time,
            sum(h.impressions) as impressions,
            sum(h.clicks) as clicks,
            sum(h.conversions) as conversions,
            COALESCE(sum(h.total_revenue),0) as revenue,
            b.bannerid as bannerid,
            b.campaignid as campaignid,
            cl.clientid as clientid,
            p.affiliateid as affiliateid,
            p.name as affiliatename,
            (sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
            ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm,
            b.description as bannername
            from
            ".$table_prefix."data_summary_ad_hourly as h,
            ".$table_prefix."banners as b,
            ".$table_prefix."campaigns as c,
            ".$table_prefix."clients as cl,
            ".$table_prefix."affiliates as p,
            ".$table_prefix."zones as z
            where
            h.ad_id = b.bannerid
            AND cl.clientid = c.clientid
            AND p.affiliateid = :publisherid
            and p.affiliateid=z.affiliateid
            AND z.zoneid = h.zone_id
            AND b.campaignid = c.campaignid
            AND DATE(h.date_time) between '".$startdate."'
            AND '".$enddate."' group by p.affiliateid";
            
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":publisherid", $publisherid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Publisherwise Banner Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Publisher Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

/*--------------- End of Publisher Statistics ------------*/

/*--------------- Start of zone Statistics ------------*/

$app->get('/get_zone_daily_statistics/[{start_date},{end_date},{zone_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $zoneid = $args['zone_id'];
        $stc = "select * from ".$table_prefix."zones where zoneid=:zone_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("zone_id", $zoneid);
        $std->execute();
        $publishers = $std->fetchAll();
        if ($publishers)
        {
            $sql = "select 
            h.zone_id as zoneid,
            DATE(h.date_time) as date_time,
            sum(h.impressions) as impressions,
            sum(h.clicks) as clicks,
            sum(h.conversions) as conversions,
            COALESCE(sum(h.total_revenue),0) as revenue,
            b.bannerid as bannerid,
            b.campaignid as campaignid,
            cl.clientid as clientid,
            p.affiliateid as affiliateid,
            p.name as name,
            (sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
            ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm,
            b.description as bannername
            from
            ".$table_prefix."data_summary_ad_hourly as h,
            ".$table_prefix."banners as b,
            ".$table_prefix."campaigns as c,
            ".$table_prefix."clients as cl,
            ".$table_prefix."affiliates as p,
            ".$table_prefix."zones as z
            where
            h.ad_id = b.bannerid
            AND cl.clientid = c.clientid
            AND z.zoneid = :zoneid
            and p.affiliateid=z.affiliateid
            AND z.zoneid = h.zone_id
            AND b.campaignid = c.campaignid
            AND DATE(h.date_time) between '".$startdate."'
            AND '".$enddate."' group by DATE(date_time)";
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":zoneid", $zoneid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Agencywise Campaign Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Zone Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

$app->get('/get_zone_advertiser_statistics/[{start_date},{end_date},{zone_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $zoneid = $args['zone_id'];
        $stc = "select * from ".$table_prefix."zones where zoneid=:zone_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("zone_id", $zoneid);
        $std->execute();
        $publishers = $std->fetchAll();
        if ($publishers)
        {
            $sql = "select 
            h.zone_id as zoneid,
            DATE(h.date_time) as date_time,
            sum(h.impressions) as impressions,
            sum(h.clicks) as clicks,
            sum(h.conversions) as conversions,
            COALESCE(sum(h.total_revenue),0) as revenue,
            b.bannerid as bannerid,
            b.campaignid as campaignid,
            cl.clientid as clientid,
            p.affiliateid as affiliateid,
            p.name as affiliatename,
            cl.clientname as clientname,
            (sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
            ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm,
            b.description as bannername
            from
            ".$table_prefix."data_summary_ad_hourly as h,
            ".$table_prefix."banners as b,
            ".$table_prefix."campaigns as c,
            ".$table_prefix."clients as cl,
            ".$table_prefix."affiliates as p,
            ".$table_prefix."zones as z
            where
            h.ad_id = b.bannerid
            AND cl.clientid = c.clientid
            AND z.zoneid = :zoneid
            and p.affiliateid=z.affiliateid
            AND z.zoneid = h.zone_id
            AND b.campaignid = c.campaignid
            AND DATE(h.date_time) between '".$startdate."'
            AND '".$enddate."' group by clientid";
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":zoneid", $zoneid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Zonewise Advertiser Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Zone Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

$app->get('/get_zone_campaign_statistics/[{start_date},{end_date},{zone_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $zoneid = $args['zone_id'];
        $stc = "select * from ".$table_prefix."zones where zoneid=:zone_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("zone_id", $zoneid);
        $std->execute();
        $publishers = $std->fetchAll();
        if ($publishers)
        {
            $sql = "select 
            h.zone_id as zoneid,
            DATE(h.date_time) as date_time,
            sum(h.impressions) as impressions,
            sum(h.clicks) as clicks,
            sum(h.conversions) as conversions,
            COALESCE(sum(h.total_revenue),0) as revenue,
            b.bannerid as bannerid,
            b.campaignid as campaignid,
            cl.clientid as clientid,
            p.affiliateid as affiliateid,
            p.name as affiliatename,
            c.campaignname as campaignname,
            cl.clientname as clientname,
            (sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
            ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm,
            b.description as bannername
            from
            ".$table_prefix."data_summary_ad_hourly as h,
            ".$table_prefix."banners as b,
            ".$table_prefix."campaigns as c,
            ".$table_prefix."clients as cl,
            ".$table_prefix."affiliates as p,
            ".$table_prefix."zones as z
            where
            h.ad_id = b.bannerid
            AND cl.clientid = c.clientid
            AND z.zoneid = :zoneid
            and p.affiliateid=z.affiliateid
            AND z.zoneid = h.zone_id
            AND b.campaignid = c.campaignid
            AND DATE(h.date_time) between '".$startdate."'
            AND '".$enddate."' group by campaignid";
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":zoneid", $zoneid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Zonewise Campaign Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Zone Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));

$app->get('/get_zone_banner_statistics/[{start_date},{end_date},{zone_id}]', function ($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');
        return $this->response->withJson($errors);
    }
    else
    {
        $input = $request->getParsedBody();
        $table_prefix = $this->get('settings') ['path']['table_prefix'];
        $datetime = date('Y-m-d H:i:s');
        $startdate = $args['start_date'];
        $enddate = $args['end_date'];
        $zoneid = $args['zone_id'];
        $stc = "select * from ".$table_prefix."zones where zoneid=:zone_id";
        $std = $this->db->prepare($stc);
        $std->bindParam("zone_id", $zoneid);
        $std->execute();
        $publishers = $std->fetchAll();
        if ($publishers)
        {
            $sql = "select 
            h.zone_id as zoneid,
            h.ad_id as ad_id,
            DATE(h.date_time) as date_time,
            sum(h.impressions) as impressions,
            sum(h.clicks) as clicks,
            sum(h.conversions) as conversions,
            COALESCE(sum(h.total_revenue),0) as revenue,
            b.bannerid as bannerid,
            b.campaignid as campaignid,
            cl.clientid as clientid,
            p.affiliateid as affiliateid,
            p.name as affiliatename,
            c.campaignname as campaignname,
            cl.clientname as clientname,
            (sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
            ROUND(COALESCE((Sum(h.total_revenue)/sum(h.impressions))*1000,0),4) as ecpm,
            b.description as bannername
            from
            ".$table_prefix."data_summary_ad_hourly as h,
            ".$table_prefix."banners as b,
            ".$table_prefix."campaigns as c,
            ".$table_prefix."clients as cl,
            ".$table_prefix."affiliates as p,
            ".$table_prefix."zones as z
            where
            h.ad_id = b.bannerid
            AND cl.clientid = c.clientid
            AND z.zoneid = :zoneid
            and p.affiliateid=z.affiliateid
            AND z.zoneid = h.zone_id
            AND b.campaignid = c.campaignid
            AND DATE(h.date_time) between '".$startdate."'
            AND  '".$enddate."' group by ad_id";
            $sth = $this->db->prepare($sql);
            $sth->bindParam(":zoneid", $zoneid);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Zonewise Banner Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = array('message' => 'No Stats Available', 'response' => 'error', 'status' => '204');
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response = array('message' => 'Please enter valid Zone Id', 'response' => 'error', 'status' => '404');
            return $this->response->withJson($response);
        }
    }
})->add($container->get('datevalidation'));


/*--------------- End of zone Statistics ------------*/


/*--------------- Start of vast video Statistics ------------*/

$app->get('/get_vastvideo_eventsbycampaign/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
    }
    else
    {
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date'];
		$campaign_id = $args['campaign_id']; 
		
        $stc= "Select campaignid from ".$table_prefix."campaigns where campaignid='".$campaign_id."'";
		
		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
        if ($publishers)
        {
			$sql="Select 
                c.campaignname as campaign_name,
                b.description as banner_name,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                ".$table_prefix."stats_vast as h,
                ".$table_prefix."banners as b,
                ".$table_prefix."campaigns as c,
                ".$table_prefix."clients as cl,
                ".$table_prefix."agency as a
                where
                h.creative_id = b.bannerid
                AND b.campaignid = c.campaignid
                AND c.campaignid = '".$campaign_id."'
                AND a.agencyid=cl.agencyid
                AND cl.clientid=c.clientid
                AND DATE(h.interval_start) between '".$startdate."' AND  '".$enddate."' group by b.bannerid, h.vast_event_id";
            
            $sth = $this->db->prepare($sql); 
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Campaignwise Video Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = ['message'=>'No Stats Available', 'response' => 'error', 'status' => '204'];
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response =['message'=>'Please enter valid campaign id', 'response' => 'error', 'status' => '404'];
            return $this->response->withJson($response);
        }
    }
 
})->add($container->get('datevalidation')); 


$app->get('/get_vastvideo_eventsbyadvertiser/[{start_date},{end_date},{client_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
    }
    else
    {
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$client_id = $args['client_id'];
		
		$stc = "Select clientid from ".$table_prefix."clients where clientid='".$client_id."'";

        $std = $this->db->prepare($stc);
        $std->execute();
        $publishers = $std->fetchAll();
        if ($publishers)
        {
           
			$sql="select 
                cl.clientname as clientname,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                ".$table_prefix."stats_vast as h,
                ".$table_prefix."banners as b,
                ".$table_prefix."campaigns as c,
                ".$table_prefix."clients as cl 
                where
                h.creative_id = b.bannerid
                AND c.campaignid = b.campaignid
                AND c.clientid = cl.clientid
                AND cl.clientid = '".$client_id."'
                AND DATE(h.interval_start) between '".$startdate."'
                AND '".$enddate."' group by cl.clientid,h.vast_event_id";
            
            $sth = $this->db->prepare($sql);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Advertiserwise Video Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = ['message'=>'No Stats Available', 'response' => 'error', 'status' => '204'];
                return $this->response->withJson($response);
            }
        }
        else
        {
			$response = ['message'=>'Please enter valid client id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
    }
 
})->add($container->get('datevalidation')); 


$app->get('/get_vastvideo_eventsbywebsite/[{start_date},{end_date},{affiliate_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
    }
    else
    {
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date'];
		$affiliate_id = $args['affiliate_id']; 
		
		$stc = "Select affiliateid from ".$table_prefix."affiliates where affiliateid='".$affiliate_id."'";

		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
		
        if ($publishers)
        {
            $sql="select 
                a.name as affiliatename,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                ".$table_prefix."stats_vast as h,
                ".$table_prefix."affiliates as a,
                ".$table_prefix."zones as z
                where
                h.zone_id = z.zoneid
                AND z.affiliateid = a.affiliateid
                AND a.affiliateid = '".$affiliate_id."'
                AND DATE(h.interval_start) between '".$startdate."'
                AND '".$enddate."' group by a.affiliateid,h.vast_event_id";
		
            $sth = $this->db->prepare($sql);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Websitewise Video Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = ['message'=>'No Stats Available', 'response' => 'error', 'status' => '204'];
                return $this->response->withJson($response);
            }
        }
        else
        {
			$response = ['message'=>'Please enter valid affiliate id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}

    }
 
})->add($container->get('datevalidation'));  


$app->get('/get_vastvideo_eventsbyzone/[{start_date},{end_date},{zone_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
    }
    else
    {
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$zone_id = $args['zone_id'];
		
        $stc = "Select zoneid from ".$table_prefix."zones where zoneid='".$zone_id."'";

        $std = $this->db->prepare($stc);
        $std->execute();
        $publishers = $std->fetchAll();

		if($publishers)
		{
		
            $sql="select 
                z.zonename as zonename,
                h.vast_event_id as event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                ".$table_prefix."stats_vast as h,
                ".$table_prefix."zones as z
                where
                h.zone_id = '".$zone_id."'
                AND z.zoneid = h.zone_id
                AND DATE(h.interval_start) between '".$startdate."'
                AND '".$enddate."' group by h.vast_event_id";
            
            $sth = $this->db->prepare($sql);
            $sth->execute();
            $todos = $sth->fetchAll();
            if($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Zonewise Video Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = ['message'=>'No Stats Available', 'response' => 'error', 'status' => '204'];
                return $this->response->withJson($response);
            }
		
		}
        else
        {
			$response = ['message'=>'Please enter valid zone id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
}
  
})->add($container->get('datevalidation')); 


$app->get('/get_vastvideo_eventsbyagency/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
    }
    else
    {
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$agency_id = $args['agency_id'];
		
		$stc = "Select agencyid from ".$table_prefix."agency where agencyid='".$agency_id."'";
		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
		
        if ($publishers)
        {
		    $sql="select 
                g.name as agencyname,
                a.name as affiliatename,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                ".$table_prefix."affiliates as a,
                ".$table_prefix."zones as z,
                ".$table_prefix."agency as g,
                ".$table_prefix."stats_vast as h
                where
                g.agencyid = '".$agency_id."'
                AND a.agencyid = g.agencyid
                AND a.affiliateid = z.affiliateid
                AND DATE(h.interval_start) between '".$startdate."'
                AND '".$enddate."' group by a.affiliateid, h.vast_event_id";
		//print_r($sql);exit;
            $sth = $this->db->prepare($sql);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Websitewise Video Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = ['message'=>'No Stats Available', 'response' => 'error', 'status' => '204'];
                return $this->response->withJson($response);
            }
        }
        else
        {
			$response = ['message'=>'Please enter valid agency id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}

    }
 
})->add($container->get('datevalidation'));  


$app->get('/get_vastvideo_eventsbybanner/[{start_date},{end_date},{banner_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
    }
    else
    {
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date'];
		$banner_id = $args['banner_id']; 
		
        $stc= "Select bannerid from ".$table_prefix."banners where bannerid='".$banner_id."'";
		
		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
        if ($publishers)
        {
			$sql="Select 
                b.description as banner_name,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                ".$table_prefix."stats_vast as h,
                ".$table_prefix."banners as b
                where
                h.creative_id = b.bannerid
                AND b.bannerid = '".$banner_id."'
                AND DATE(h.interval_start) between '".$startdate."' AND  '".$enddate."' group by b.bannerid, h.vast_event_id";
            
            $sth = $this->db->prepare($sql); 
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Campaignwise Video Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = ['message'=>'No Stats Available', 'response' => 'error', 'status' => '204'];
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response =['message'=>'Please enter valid banner id', 'response' => 'error', 'status' => '404'];
            return $this->response->withJson($response);
        }
    }
 
})->add($container->get('datevalidation')); 


$app->get('/get_agencycampaign_videoevents/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
    }
    else
    {
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date'];
		$agency_id = $args['agency_id']; 
		
        $stc= "Select agencyid from ".$table_prefix."agency where agencyid='".$agency_id."'";
        
		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
        if ($publishers)
        {
			$sql="Select 
                a.name as agencyname,
                c.campaignname as campaign_name,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                ".$table_prefix."stats_vast as h,
                ".$table_prefix."banners as b,
                ".$table_prefix."campaigns as c,
                ".$table_prefix."clients as cl,
                ".$table_prefix."agency as a
                where
                a.agencyid = ".$agency_id."
                AND cl.agencyid=a.agencyid
                AND cl.clientid = c.clientid
                AND b.campaignid = c.campaignid
                AND h.creative_id = b.bannerid
                AND DATE(h.interval_start) between '".$startdate."' AND  '".$enddate."' group by c.campaignid, h.vast_event_id";

            $sth = $this->db->prepare($sql); 
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Campaignwise Video Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = ['message'=>'No Stats Available', 'response' => 'error', 'status' => '204'];
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response =['message'=>'Please enter valid agency id', 'response' => 'error', 'status' => '404'];
            return $this->response->withJson($response);
        }
    }
 
})->add($container->get('datevalidation')); 


$app->get('/get_agencyadvertiser_videoevents/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
    }
    else
    {
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$agency_id = $args['agency_id'];
		
        $stc= "Select agencyid from ".$table_prefix."agency where agencyid='".$agency_id."'";
        
		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
        if ($publishers)
        {
			$sql="Select 
                a.name as agencyname,
                cl.clientname as advertiser_name,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                ".$table_prefix."stats_vast as h,
                ".$table_prefix."banners as b,
                ".$table_prefix."campaigns as c,
                ".$table_prefix."clients as cl,
                ".$table_prefix."agency as a
                where
                a.agencyid = ".$agency_id."
                AND cl.agencyid=a.agencyid
                AND cl.clientid = c.clientid
                AND b.campaignid = c.campaignid
                AND h.creative_id = b.bannerid
                AND DATE(h.interval_start) between '".$startdate."' AND  '".$enddate."' group by cl.clientid, h.vast_event_id";

            $sth = $this->db->prepare($sql);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Advertiserwise Video Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = ['message'=>'No Stats Available', 'response' => 'error', 'status' => '204'];
                return $this->response->withJson($response);
            }
        }
        else
        {
			$response = ['message'=>'Please enter valid agency id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
    
    }
 
})->add($container->get('datevalidation')); 


$app->get('/get_agencybanner_videoevents/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
    }
    else
    {
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date'];
		$agency_id = $args['agency_id']; 
		
        $stc= "Select agencyid from ".$table_prefix."agency where agencyid='".$agency_id."'";
        
		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
        if ($publishers)
        {
			$sql="Select 
                a.name as agencyname,
                b.description as banner_name,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                ".$table_prefix."stats_vast as h,
                ".$table_prefix."banners as b,
                ".$table_prefix."campaigns as c,
                ".$table_prefix."clients as cl,
                ".$table_prefix."agency as a
                where
                a.agencyid = ".$agency_id."
                AND cl.agencyid=a.agencyid
                AND cl.clientid = c.clientid
                AND b.campaignid = c.campaignid
                AND h.creative_id = b.bannerid
                AND DATE(h.interval_start) between '".$startdate."' AND  '".$enddate."' group by b.bannerid, h.vast_event_id";


			/* $sql="Select 
                b.description as banner_name,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                ".$table_prefix."stats_vast as h,
                ".$table_prefix."banners as b
                where
                h.creative_id = b.bannerid
                AND b.bannerid = '".$banner_id."'
                AND DATE(h.interval_start) between '".$startdate."' AND  '".$enddate."' group by b.bannerid, h.vast_event_id"; */
            
            $sth = $this->db->prepare($sql); 
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Campaignwise Video Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = ['message'=>'No Stats Available', 'response' => 'error', 'status' => '204'];
                return $this->response->withJson($response);
            }
        }
        else
        {
            $response =['message'=>'Please enter valid banner id', 'response' => 'error', 'status' => '404'];
            return $this->response->withJson($response);
        }
    }
 
})->add($container->get('datevalidation')); 


$app->get('/get_agencyaffiliate_videoevents/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
    }
    else
    {
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date'];
		$agency_id = $args['agency_id']; 
		
        $stc= "Select agencyid from ".$table_prefix."agency where agencyid='".$agency_id."'";
        
		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
        if ($publishers)
        {
			$sql="Select 
                a.name as name,
                w.name as affiliatename,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                ".$table_prefix."stats_vast as h,
                ".$table_prefix."agency as a,
                ".$table_prefix."affiliates as w,
                ".$table_prefix."zones as z
                
                where
                a.agencyid = '".$agency_id."'
                AND w.agencyid=a.agencyid
                AND z.affiliateid = w.affiliateid
                AND h.zone_id = z.zoneid
                AND DATE(h.interval_start) between '".$startdate."' AND  '".$enddate."' group by w.affiliateid, h.vast_event_id";
		
            $sth = $this->db->prepare($sql);
            $sth->execute();
            $todos = $sth->fetchAll();
            if ($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Websitewise Video Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = ['message'=>'No Stats Available', 'response' => 'error', 'status' => '204'];
                return $this->response->withJson($response);
            }
        }
        else
        {
			$response = ['message'=>'Please enter valid affiliate id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}

    }
 
})->add($container->get('datevalidation'));  


$app->get('/get_agencyzone_videoevents/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
    if ($request->getAttribute('has_errors'))
    {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
    }
    else
    {
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$agency_id = $args['agency_id'];
		
        $stc= "Select agencyid from ".$table_prefix."agency where agencyid='".$agency_id."'";
        
		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
        if ($publishers)
        {
			$sql="Select 
                a.name as name,
                z.zonename as zonename,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                ".$table_prefix."stats_vast as h,
                ".$table_prefix."agency as a,
                ".$table_prefix."affiliates as w,
                ".$table_prefix."zones as z
                
                where
                a.agencyid = '".$agency_id."'
                AND w.agencyid=a.agencyid
                AND z.affiliateid = w.affiliateid
                AND h.zone_id = z.zoneid
                AND DATE(h.interval_start) between '".$startdate."' AND  '".$enddate."' group by z.zonename, h.vast_event_id";
            
            $sth = $this->db->prepare($sql);
            $sth->execute();
            $todos = $sth->fetchAll();
            if($todos)
            {
                $data['data'] = $todos;
                $data['response'] = "success";
                $data['message'] = "Zonewise Video Statistics";
                $data['status'] = "200";
                return $this->response->withJson($data);
            }
            else
            {
                $response = ['message'=>'No Stats Available', 'response' => 'error', 'status' => '204'];
                return $this->response->withJson($response);
            }
		
		}
        else
        {
			$response = ['message'=>'Please enter valid zone id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
}
  
})->add($container->get('datevalidation')); 




/*---- Vast video ads Statistics end----*/  



/*--------------- Start of vast video Statistics ------------*/

$app->get('/get_advancedvastvideo_eventsbycampaign/[{start_date},{end_date},{campaign_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];

		$campaign_id = $args['campaign_id'];

		$stc = "	select campaignid 
			from
			" . $table_prefix . "campaigns 
			
			where
			campaignid='" . $campaign_id . "' ";



		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {

			$sql = "Select 
                c.campaignname as campaign_name,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                " . $table_prefix . "stats_djaxvast as h,
                " . $table_prefix . "banners as b,
                " . $table_prefix . "campaigns as c,
                " . $table_prefix . "clients as cl,
                " . $table_prefix . "agency as a
                where
                h.creative_id = b.bannerid
                AND b.campaignid = c.campaignid
                AND c.campaignid = '" . $campaign_id . "'
                AND a.agencyid=cl.agencyid
                AND cl.clientid=c.clientid
                AND DATE(h.interval_start) between '" . $startdate . "' AND  '" . $enddate . "' group by c.campaignid,    h.vast_event_id";

			$sth = $this->db->prepare($sql);
			$sth->execute();
			$todos = $sth->fetchAll();

			if ($todos) {
				$data['data'] = $todos;
				$data['response'] = "success";
				$data['message'] = "Campaignwise Video Statistics";
				$data['status'] = "200";
				return $this->response->withJson($data);
			} else {
				$response = ['message' => 'No Stats Available', 'response' => 'error', 'status' => '204'];
				return $this->response->withJson($response);
			}
		} else {
			$response = ['message' => 'Please enter valid campaign id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));


$app->get('/get_advancedvastvideo_eventsbyadvertiser/[{start_date},{end_date},{client_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$client_id = $args['client_id'];

		$stc = "selectclientid 
			from
			" . $table_prefix . "clients 
			where
			clientid='" . $client_id . "'";
		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {

			$sql = "select 
		cl.clientname as clientname,
		h.vast_event_id as vast_event_id,
		sum(h.count) as count,
		DATE(h.interval_start) as date_time
		from
		" . $table_prefix . "stats_djaxvast as h,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "clients as cl 
		where
		h.creative_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = '" . $client_id . "'
		AND DATE(h.interval_start) between '" . $startdate . "'
		AND '" . $enddate . "' group by cl.clientid,h.vast_event_id";
			$sth = $this->db->prepare($sql);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				$data['data'] = $todos;
				$data['response'] = "success";
				$data['message'] = "Advertiserwise Video Statistics";
				$data['status'] = "200";
				return $this->response->withJson($data);
			} else {

				$response = ['message' => 'No Stats Available', 'response' => 'error', 'status' => '204'];
				return $this->response->withJson($response);
			}
		} else {
			$response = ['message' => 'Please enter valid client id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));


$app->get('/get_advancedvastvideo_eventsbybanner/[{start_date},{end_date},{banner_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$banner_id = $args['banner_id'];

		$stc = "Select bannerid from " . $table_prefix . "banners where bannerid='" . $banner_id . "'";

		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
		if ($publishers) {
			$sql = "Select 
                b.description as banner_name,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                " . $table_prefix . "stats_djaxvast as h,
                " . $table_prefix . "banners as b
                where
                h.creative_id = b.bannerid
                AND b.bannerid = '" . $banner_id . "'
                AND DATE(h.interval_start) between '" . $startdate . "' AND  '" . $enddate . "' group by b.bannerid, h.vast_event_id";

			$sth = $this->db->prepare($sql);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				$data['data'] = $todos;
				$data['response'] = "success";
				$data['message'] = "Bannerwise Video Statistics";
				$data['status'] = "200";
				return $this->response->withJson($data);
			} else {
				$response = ['message' => 'No Stats Available', 'response' => 'error', 'status' => '204'];
				return $this->response->withJson($response);
			}
		} else {
			$response = ['message' => 'Please enter valid banner id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));


$app->get('/get_advancedvastvideo_eventsbywebsite/[{start_date},{end_date},{affiliate_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$affiliate_id = $args['affiliate_id'];

		$stc = "Select affiliateid from " . $table_prefix . "affiliates where affiliateid='" . $affiliate_id . "'";
		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {
			$sql = "select 
                a.affiliateid as affiliate_id,
                a.name as affiliatename,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                " . $table_prefix . "stats_djaxvast as h,
                " . $table_prefix . "affiliates as a,
                " . $table_prefix . "zones as z
                where
                h.zone_id = z.zoneid
                AND z.affiliateid = a.affiliateid
                AND a.affiliateid = '" . $affiliate_id . "'
                AND DATE(h.interval_start) between '" . $startdate . "'
                AND '" . $enddate . "' group by a.affiliateid,h.vast_event_id";
			$sth = $this->db->prepare($sql);

			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				$data['data'] = $todos;
				$data['response'] = "success";
				$data['message'] = "Websitewise Video Statistics";
				$data['status'] = "200";
				return $this->response->withJson($data);
			} else {
				$response = ['message' => 'No Stats Available', 'response' => 'error', 'status' => '204'];
				return $this->response->withJson($response);
			}
		} else {

			$response = ['message' => 'Please enter valid affiliate id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));

$app->get('/get_advancedvastvideo_eventsbyzone/[{start_date},{end_date},{zone_id}]', function ($request, $response, $args) {
	//rv_data_bkt_vast_e
	//rv_stats_djaxvast

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$zone_id = $args['zone_id'];

		$stc = "Select zoneid from " . $table_prefix . "zones where zoneid='" . $zone_id . "'";

		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {

			$sql = "select 
			h.zone_id as zoneid,
			z.zonename as zonename,
			h.vast_event_id as event_id,
			sum(h.count) as count,
			DATE(h.interval_start) as date_time
			from
			" . $table_prefix . "stats_djaxvast as h,
			" . $table_prefix . "zones as z
			where
			h.zone_id = '" . $zone_id . "'
			AND z.zoneid = h.zone_id
			AND DATE(h.interval_start) between '" . $startdate . "'
			AND '" . $enddate . "' group by h.vast_event_id";


			$sth = $this->db->prepare($sql);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				$data['data'] = $todos;
				$data['response'] = "success";
				$data['message'] = "Zonewise Video Statistics";
				$data['status'] = "200";
				return $this->response->withJson($data);
			} else {
				$response = ['message' => 'No Stats Available', 'response' => 'error', 'status' => '204'];
				return $this->response->withJson($response);
			}
		} else {
			$response = ['message' => 'Please enter valid zone id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));

$app->get('/get_advancedagencycampaign_videoevents/[{start_date},{end_date},{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$agency_id = $args['agency_id'];

		$stc = "Select agencyid from " . $table_prefix . "agency where agencyid='" . $agency_id . "'";

		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
		if ($publishers) {
			$sql = "Select 
                a.name as agencyname,
                c.campaignname as campaign_name,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                " . $table_prefix . "stats_djaxvast as h,
                " . $table_prefix . "banners as b,
                " . $table_prefix . "campaigns as c,
                " . $table_prefix . "clients as cl,
                " . $table_prefix . "agency as a
                where
                a.agencyid = " . $agency_id . "
                AND cl.agencyid=a.agencyid
                AND cl.clientid = c.clientid
                AND b.campaignid = c.campaignid
                AND h.creative_id = b.bannerid
                AND DATE(h.interval_start) between '" . $startdate . "' AND  '" . $enddate . "' group by c.campaignid, h.vast_event_id";

			$sth = $this->db->prepare($sql);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				$data['data'] = $todos;
				$data['response'] = "success";
				$data['message'] = "Campaignwise Video Statistics";
				$data['status'] = "200";
				return $this->response->withJson($data);
			} else {
				$response = ['message' => 'No Stats Available', 'response' => 'error', 'status' => '204'];
				return $this->response->withJson($response);
			}
		} else {
			$response = ['message' => 'Please enter valid agency id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));


$app->get('/get_advancedagencyadvertiser_videoevents/[{start_date},{end_date},{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$agency_id = $args['agency_id'];

		$stc = "Select agencyid from " . $table_prefix . "agency where agencyid='" . $agency_id . "'";

		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
		if ($publishers) {
			$sql = "Select 
                a.name as agencyname,
                cl.clientname as advertiser_name,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                " . $table_prefix . "stats_djaxvast as h,
                " . $table_prefix . "banners as b,
                " . $table_prefix . "campaigns as c,
                " . $table_prefix . "clients as cl,
                " . $table_prefix . "agency as a
                where
                a.agencyid = " . $agency_id . "
                AND cl.agencyid=a.agencyid
                AND cl.clientid = c.clientid
                AND b.campaignid = c.campaignid
                AND h.creative_id = b.bannerid
                AND DATE(h.interval_start) between '" . $startdate . "' AND  '" . $enddate . "' group by cl.clientid, h.vast_event_id";

			$sth = $this->db->prepare($sql);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				$data['data'] = $todos;
				$data['response'] = "success";
				$data['message'] = "Advertiserwise Video Statistics";
				$data['status'] = "200";
				return $this->response->withJson($data);
			} else {
				$response = ['message' => 'No Stats Available', 'response' => 'error', 'status' => '204'];
				return $this->response->withJson($response);
			}
		} else {
			$response = ['message' => 'Please enter valid agency id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));


$app->get('/get_advancedagencybanner_videoevents/[{start_date},{end_date},{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$agency_id = $args['agency_id'];

		$stc = "Select agencyid from " . $table_prefix . "agency where agencyid='" . $agency_id . "'";

		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
		if ($publishers) {
			$sql = "Select 
                a.name as agencyname,
                b.description as banner_name,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                " . $table_prefix . "stats_djaxvast as h,
                " . $table_prefix . "banners as b,
                " . $table_prefix . "campaigns as c,
                " . $table_prefix . "clients as cl,
                " . $table_prefix . "agency as a
                where
                a.agencyid = " . $agency_id . "
                AND cl.agencyid=a.agencyid
                AND cl.clientid = c.clientid
                AND b.campaignid = c.campaignid
                AND h.creative_id = b.bannerid
                AND DATE(h.interval_start) between '" . $startdate . "' AND  '" . $enddate . "' group by b.bannerid, h.vast_event_id";

			$sth = $this->db->prepare($sql);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				$data['data'] = $todos;
				$data['response'] = "success";
				$data['message'] = "Campaignwise Video Statistics";
				$data['status'] = "200";
				return $this->response->withJson($data);
			} else {
				$response = ['message' => 'No Stats Available', 'response' => 'error', 'status' => '204'];
				return $this->response->withJson($response);
			}
		} else {
			$response = ['message' => 'Please enter valid banner id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));


$app->get('/get_advancedagencyaffiliate_videoevents/[{start_date},{end_date},{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$agency_id = $args['agency_id'];

		$stc = "Select agencyid from " . $table_prefix . "agency where agencyid='" . $agency_id . "'";

		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
		if ($publishers) {
			$sql = "Select 
                a.name as name,
                w.name as affiliatename,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                " . $table_prefix . "stats_djaxvast as h,
                " . $table_prefix . "agency as a,
                " . $table_prefix . "affiliates as w,
                " . $table_prefix . "zones as z
                
                where
                a.agencyid = '" . $agency_id . "'
                AND w.agencyid=a.agencyid
                AND z.affiliateid = w.affiliateid
                AND h.zone_id = z.zoneid
                AND DATE(h.interval_start) between '" . $startdate . "' AND  '" . $enddate . "' group by w.affiliateid, h.vast_event_id";

			$sth = $this->db->prepare($sql);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				$data['data'] = $todos;
				$data['response'] = "success";
				$data['message'] = "Websitewise Video Statistics";
				$data['status'] = "200";
				return $this->response->withJson($data);
			} else {
				$response = ['message' => 'No Stats Available', 'response' => 'error', 'status' => '204'];
				return $this->response->withJson($response);
			}
		} else {
			$response = ['message' => 'Please enter valid agency id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));


$app->get('/get_advancedagencyzone_videoevents/[{start_date},{end_date},{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$agency_id = $args['agency_id'];

		$stc = "Select agencyid from " . $table_prefix . "agency where agencyid='" . $agency_id . "'";

		$std = $this->db->prepare($stc);
		$std->execute();
		$publishers = $std->fetchAll();
		if ($publishers) {
			$sql = "Select 
                a.name as name,
                z.zonename as zonename,
                h.vast_event_id as vast_event_id,
                sum(h.count) as count,
                DATE(h.interval_start) as date_time
                from
                " . $table_prefix . "stats_djaxvast as h,
                " . $table_prefix . "agency as a,
                " . $table_prefix . "affiliates as w,
                " . $table_prefix . "zones as z
                
                where
                a.agencyid = '" . $agency_id . "'
                AND w.agencyid=a.agencyid
                AND z.affiliateid = w.affiliateid
                AND h.zone_id = z.zoneid
                AND DATE(h.interval_start) between '" . $startdate . "' AND  '" . $enddate . "' group by z.zonename, h.vast_event_id";

			$sth = $this->db->prepare($sql);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				$data['data'] = $todos;
				$data['response'] = "success";
				$data['message'] = "Zonewise Video Statistics";
				$data['status'] = "200";
				return $this->response->withJson($data);
			} else {
				$response = ['message' => 'No Stats Available', 'response' => 'error', 'status' => '204'];
				return $this->response->withJson($response);
			}
		} else {
			$response = ['message' => 'Please enter valid agency id', 'response' => 'error', 'status' => '404'];
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation')); 

/*---- Vast video ads Statistics end----*/

