<?php
// Require the initialisation file
require_once '../../../../init.php';
// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/www/admin/config.php';
/*Database connections*/
if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
/*Database connections*/

OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);
// Create a new option object for displaying the setting's page's HTML form
$oOptions = new OA_Admin_Option('target-index');
$prefSection = "target-index";
$setPref = $oOptions->getSettingsPreferences($prefSection);
$title = 'Gender Management';
// Display the settings page's header and sections
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);
phpAds_PageHeader('filter-details', $oHeaderModel);
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
?>

<div class="tableWrapper">
    <div class="tableHeader">
     <ul class='tableActions'>
	   <li>
                <a href='target-filter-edit.php' class='inlineIcon iconAdvertiserAdd'>Add New Gender</a>
       </li>
 	   <li class='inactive activeIfSelected'>
		<script type='text/javascript'>
                <!--
                $('#approveSelection').click(function(event) {
                    event.preventDefault();
                    if (!$(this).parents('li').hasClass('inactive')) {
                        var ids = [];
                        $(this).parents('.tableWrapper').find('.toggleSelection input:checked').each(function() {
                            ids.push(this.value);
                        });
                        if (!tablePreferences.warningBeforeDelete || confirm("Do You Really Want To Delete Selected Gender?")) {
                            window.location = 'target-filter-delete.php?id=' + ids.join(',');
                        }
                    }
                });
                
                //-->
                </script>           
            </li>
            <li class='inactive activeIfSelected'>
                <a id='deleteSelection' href='#' class='inlineIcon iconDelete'>Delete</a>
                <script type='text/javascript'>
                <!--
                $('#deleteSelection').click(function(event) {
                    event.preventDefault();
                    
                    if (!$(this).parents('li').hasClass('inactive')) {
                        var ids = [];
                        $(this).parents('.tableWrapper').find('.toggleSelection input:checked').each(function() {
                            ids.push(this.value);
                        });
                        if (!tablePreferences.warningBeforeDelete || confirm("Do You Really Want To Delete Selected Gender?")) {

                            window.location = 'target-filter-delete.php?id=' + ids.join(',');
                        }
                    }
                });
                
                //-->
                </script>
                
            </li>
        </ul>
        <div class="clear"></div>
        <div class="corner left"></div>
        <div class="corner right"></div>
    </div>

    <table cellspacing="0" summary="">
        <thead>
            <tr>
               <th class='first toggleAll'>
                  <input type='checkbox' />
                </th>
                <th class="">
                    <a href="#">Gender</a>
                </th>
				<th class="">  
                </th>

            </tr>
        </thead>

   <tbody>

<?php 

$query =OA_Dal_Delivery_query("select * from  ".$table_prefix."target_gender");

if(OA_Dal_Delivery_numRows($query) > 0)
{
  $i =1;
	while($row = OA_Dal_Delivery_fetchAssoc($query))
   {
	if($i == 1) 
	{
    	$_class = "odd hilite";
	} 
	elseif($i%2 == 0)
	{
		$_class = "even";

	} 
	else 
	{
     	$_class = "odd";

	} 
	?>
	<tr class="<?php echo $_class; ?>">
	    <td class='toggleSelection'>
               <input type='checkbox' value="<?php echo $row['id']?>" />
        </td>
		<td> <a href="target-filter-edit.php?id=<?php echo $row['id']; ?>"><?php echo $row['name']; ?></a></td>
        <td class="alignRight verticalActions"><ul class="rowActions"> <li></li></ul></td>
        </tr>
<?php 

	$i++;
} 

} else { ?>

<tr class='odd'>
                <td colspan='6'>&nbsp;</td>
            </tr>
            <tr class='even'>

                <td colspan='6' class="hasPanel">
                    <div class='tableMessage'>
                        <div class='panel'>
                            There are currently No Gender configured Yet.                            
                            <div class='corner top-left'></div>
                            <div class='corner top-right'></div>
                            <div class='corner bottom-left'></div>
                            <div class='corner bottom-right'></div>
                        </div>
                    </div>
                    &nbsp;
                </td>
            </tr>
            <tr class='odd'>
                <td colspan='6'>&nbsp;</td>
            </tr>
<?php } ?>
</tbody>
</table></div>

<?php
phpAds_PageFooter();

?>
  


