<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * @package    OpenXPlugin
 * @subpackage DeliveryLimitations
 * @author     Chris Nutting <chris@m3.net>
 * @author     Andrzej Swedrzynski <andrzej.swedrzynski@m3.net>
 */

require_once MAX_PATH . '/lib/max/Delivery/limitations.delivery.php';

/**
 * Check to see if this impression contains the valid country.
 *
 * @param string $limitation The country (or comma list of countries) limitation
 * @param string $op The operator (either '==' or '!=')
 * @param array $aParams An array of additional parameters to be checked
 * @return boolean Whether this impression's country passes this limitation's test.
 */
function MAX_checkParameter_Title($limitation, $op, $aParams = array())
{ 
    $aParams=($_REQUEST['title']=='{title}')?'':$_REQUEST['title'];
	$targeteddata=explode(',',strtolower($limitation));
	$results=0;
	foreach($targeteddata as $key => $value)
	{
    	if(strtolower($value)==strtolower($aParams))
		{
			$results=1;
		}
	}
	if($op=='=~')
	{
		return $results;
	}
	else if($op=='!~')
	{
		return !$results;
	}
}

?>
