<?php
/*Forkmedia_sprint3_DAC218_dealid*/
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file

require_once '../../../../init.php';

if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}elseif ($GLOBALS['_MAX']['CONF']['database']['type'] == 'pgsql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}elseif ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysqli') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';

require_once RV_PATH . '/lib/RV/Admin/DateTimeFormat.php';

// Register input variables
phpAds_registerGlobalUnslashed('hideinactive', 'listorder', 'orderdirection',
                               'pubid', 'url', 'formId');
phpAds_PageHeader('AddNewDeal', $oHeaderModel);

$agencyId  = OA_Permission::getAgencyId();
// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER);
if (!empty($affiliateid) && !OA_Permission::hasAccessToObject('affiliates', $affiliateid)) { //check if can see given website
    $page = basename($_SERVER['SCRIPT_NAME']);
    OX_Admin_Redirect::redirect($page);
}

if (!isset($listorder))
{
    if (isset($session['prefs']['dealid-index.php']['listorder']))
        $listorder = $session['prefs']['dealid-index.php']['listorder'];
    else
        $listorder = '';
}

if (!isset($orderdirection))
{
    if (isset($session['prefs']['dealid-index.php']['orderdirection']))
        $orderdirection = $session['prefs']['dealid-index.php']['orderdirection'];
    else
        $orderdirection = '';
}


/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/

require_once MAX_PATH . '/lib/OA/Admin/Template.php';
require_once MAX_PATH . '/lib/OA/Admin/TemplatePlugin.php';

$oTpl = new OA_Plugin_Template('dealid-index.html', 'Rtb');

/*Get publisher user*/
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

$agencyId  = OA_Permission::getAgencyId();


$showDeal = ($_GET['showDeal']) ? $_GET['showDeal'] : 1;


if($showDeal != 1){

    if($showDeal == 2){
        $condition = "is_expire = 0";
    }else if($showDeal == 3){
        $condition = "is_expire IN (2,1) ";
    }

    $getpublisher = OA_Dal_Delivery_query("SELECT d.*,DATE_FORMAT(d.start,'%d-%m-%Y') AS start,DATE_FORMAT(d.end,'%d-%m-%Y') AS end,d.floor_price from {$table_prefix}dealid d WHERE d.agencyid=".$agencyId);
}else{

    $getpublisher = OA_Dal_Delivery_query("SELECT d.*,DATE_FORMAT(d.start,'%d-%m-%Y') AS start,DATE_FORMAT(d.end,'%d-%m-%Y') AS end,d.floor_price from {$table_prefix}dealid d WHERE d.agencyid=".$agencyId);
}

$getpubdata=array();
while($getpubdetails=OA_Dal_Delivery_fetchAssoc($getpublisher))
{
    $getpubdata[$getpubdetails['dealid']]=$getpubdetails;
}


$aWebsitesZones =$getpubdata;

$itemsPerPage = 250;
$oPager = OX_buildPager($aWebsitesZones, $itemsPerPage);
$oTopPager = OX_buildPager($aWebsitesZones, $itemsPerPage, false);
list($itemsFrom, $itemsTo) = $oPager->getOffsetByPageId();
$aWebsitesZones =  array_slice($aWebsitesZones, $itemsFrom - 1, $itemsPerPage, true);

//~ Deal Active/Pause Status
if(!empty($_POST['btntxt'])){
    $c_id = $_POST['deal_id'];
    $qry = OA_Dal_Delivery_query("SELECT dealid,DATE_FORMAT(end,'%d-%m-%Y') AS end,is_expire FROM {$table_prefix}dealid WHERE dealid = {$c_id}");
    $sel = OA_Dal_Delivery_fetchAssoc($qry);
    
    if($_POST['btntxt'] == "Activate"){
        if ($sel['end'] > date("d-m-Y")){
            $c_status = 0;
        }else{
            $c_status = 1;
        }
    }else if($_POST['btntxt'] == "Pause"){
        if ($sel['end'] > date("d-m-Y")){
            $c_status = 2;
        }else{
            $c_status = 1;
        }
    } 
 
    OA_Dal_Delivery_query("UPDATE {$table_prefix}dealid SET is_expire = {$c_status} WHERE dealid = {$c_id} AND agencyid =  ".$agencyId);
    
}

$oTpl->assign('pager', $oPager);
$oTpl->assign('topPager', $oTopPager);

$oTpl->assign('affiliates',     $aWebsitesZones);
$oTpl->assign('listorder',      $listorder);
$oTpl->assign('orderdirection', $orderdirection);
$oTpl->assign('phpAds_ZoneBanner',          phpAds_ZoneBanner);
$oTpl->assign('phpAds_ZoneInterstitial',    phpAds_ZoneInterstitial);
$oTpl->assign('phpAds_ZonePopup',           phpAds_ZonePopup);
$oTpl->assign('phpAds_ZoneText'.            phpAds_ZoneText);
$oTpl->assign('showAdDirect', (defined('OA_AD_DIRECT_ENABLED') && OA_AD_DIRECT_ENABLED === true) ? true : false);


/*-------------------------------------------------------*/
/* Store preferences                                     */
/*-------------------------------------------------------*/

$session['prefs']['dealid-index.php']['listorder'] = $listorder;
$session['prefs']['dealid-index.php']['orderdirection'] = $orderdirection;
phpAds_SessionDataStore();


/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

$oTpl->display();

phpAds_PageFooter();


function buildHeaderModel()
{
    $builder = new OA_Admin_UI_Model_InventoryPageHeaderModelBuilder();
    return $builder->buildEntityHeader(array(), 'Dealid', 'list');
}
/*Forkmedia_sprint3_DAC218_dealid*/

?>
<script type="text/javascript">

    var current = ('<?=$_GET['showDeal']?>')? '<?=$_GET['showDeal']?>': 1;

    $(document).ready(function()
    {
        // $("#thirdLevelHeader").append("<div  class='breadcrumb hasIcon iconZonesLarge'><h2>Deal Listing</h2></div>");
        // $(".tableHeader").append('<div style = " display: flex; margin-top: -24px; float: right; "><p style="margin-right:8px;">Show :   </p> <select class="showDeal" onchange="showHide(this.value)"><option value="1" >All Deals</option><option value="2">Active Deals</option><option value="3">In Active Deals</option></select></div>');
        $(".showDeal").val(current);
    });


    function showHide(value){

        window.location.replace("dealid-index.php?showDeal="+value);
    }


    $('.blockubc').click(function() {
        var data_id = $(this).attr('data-id');
        var is_block = $(this).attr('is_block');

        var targeting_page = "deal";
        var button =$(this);

        if (data_id) {
            $.ajax({
                type: "post",
                url: "ajaxcall.php",
                cache: false,               
                data: {'data_id' : data_id,'is_block':is_block, 'targetting':targeting_page},
                success: function(json){                        
                    try{  
                        var jsonparse =JSON.parse(json);
                        console.log(jsonparse);

                        if (jsonparse['STATUS']=="true") {
                            var btnTxt = 'Pause';
                            var btnValue = 0;

                            if (is_block==0) {
                                btnTxt = 'Resume';
                                btnValue = 1;
                            }

                            button.text(btnTxt);
                            button.attr('is_block', btnValue);
                        }
                    } catch(e) {     
                        console.log('Exception while request..');
                    }       
                },
                error: function() {                      
                    console.log('Error while request..');
                }
            });
        }
    });    

</script>
