<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v16/resources/local_services_lead_conversation.proto

namespace Google\Ads\GoogleAds\V16\Resources;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Data from Local Services Lead Conversation.
 * Contains details of Lead Conversation which is generated when user calls,
 * messages or books service from advertiser. These are appended to a Lead.
 * More info: https://ads.google.com/local-services-ads
 *
 * Generated from protobuf message <code>google.ads.googleads.v16.resources.LocalServicesLeadConversation</code>
 */
class LocalServicesLeadConversation extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the local services lead conversation
     * data. Local Services Lead Conversation resource name have the form
     * `customers/{customer_id}/localServicesLeadConversation/{local_services_lead_conversation_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $resource_name = '';
    /**
     * Output only. ID of this Lead Conversation.
     *
     * Generated from protobuf field <code>int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $id = 0;
    /**
     * Output only. Type of GLS lead conversation, EMAIL, MESSAGE, PHONE_CALL,
     * SMS, etc.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v16.enums.LocalServicesLeadConversationTypeEnum.ConversationType conversation_channel = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $conversation_channel = 0;
    /**
     * Output only. Type of participant in the lead conversation, ADVERTISER or
     * CONSUMER.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v16.enums.LocalServicesParticipantTypeEnum.ParticipantType participant_type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $participant_type = 0;
    /**
     * Output only. Resource name of Lead associated to the Lead Conversation.
     *
     * Generated from protobuf field <code>string lead = 5 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $lead = '';
    /**
     * Output only. The date time at which lead conversation was created by Local
     * Services Ads. The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads
     * account's timezone. Examples: "2018-03-05 09:15:00" or "2018-02-01
     * 14:34:30"
     *
     * Generated from protobuf field <code>string event_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $event_date_time = '';
    /**
     * Output only. Details of phone call conversation in case of PHONE_CALL.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v16.resources.PhoneCallDetails phone_call_details = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $phone_call_details = null;
    /**
     * Output only. Details of message conversation in case of EMAIL, MESSAGE or
     * SMS.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v16.resources.MessageDetails message_details = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $message_details = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $resource_name
     *           Output only. The resource name of the local services lead conversation
     *           data. Local Services Lead Conversation resource name have the form
     *           `customers/{customer_id}/localServicesLeadConversation/{local_services_lead_conversation_id}`
     *     @type int|string $id
     *           Output only. ID of this Lead Conversation.
     *     @type int $conversation_channel
     *           Output only. Type of GLS lead conversation, EMAIL, MESSAGE, PHONE_CALL,
     *           SMS, etc.
     *     @type int $participant_type
     *           Output only. Type of participant in the lead conversation, ADVERTISER or
     *           CONSUMER.
     *     @type string $lead
     *           Output only. Resource name of Lead associated to the Lead Conversation.
     *     @type string $event_date_time
     *           Output only. The date time at which lead conversation was created by Local
     *           Services Ads. The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads
     *           account's timezone. Examples: "2018-03-05 09:15:00" or "2018-02-01
     *           14:34:30"
     *     @type \Google\Ads\GoogleAds\V16\Resources\PhoneCallDetails $phone_call_details
     *           Output only. Details of phone call conversation in case of PHONE_CALL.
     *     @type \Google\Ads\GoogleAds\V16\Resources\MessageDetails $message_details
     *           Output only. Details of message conversation in case of EMAIL, MESSAGE or
     *           SMS.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V16\Resources\LocalServicesLeadConversation::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the local services lead conversation
     * data. Local Services Lead Conversation resource name have the form
     * `customers/{customer_id}/localServicesLeadConversation/{local_services_lead_conversation_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getResourceName()
    {
        return $this->resource_name;
    }

    /**
     * Output only. The resource name of the local services lead conversation
     * data. Local Services Lead Conversation resource name have the form
     * `customers/{customer_id}/localServicesLeadConversation/{local_services_lead_conversation_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_name = $var;

        return $this;
    }

    /**
     * Output only. ID of this Lead Conversation.
     *
     * Generated from protobuf field <code>int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Output only. ID of this Lead Conversation.
     *
     * Generated from protobuf field <code>int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkInt64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * Output only. Type of GLS lead conversation, EMAIL, MESSAGE, PHONE_CALL,
     * SMS, etc.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v16.enums.LocalServicesLeadConversationTypeEnum.ConversationType conversation_channel = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getConversationChannel()
    {
        return $this->conversation_channel;
    }

    /**
     * Output only. Type of GLS lead conversation, EMAIL, MESSAGE, PHONE_CALL,
     * SMS, etc.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v16.enums.LocalServicesLeadConversationTypeEnum.ConversationType conversation_channel = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setConversationChannel($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V16\Enums\LocalServicesLeadConversationTypeEnum\ConversationType::class);
        $this->conversation_channel = $var;

        return $this;
    }

    /**
     * Output only. Type of participant in the lead conversation, ADVERTISER or
     * CONSUMER.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v16.enums.LocalServicesParticipantTypeEnum.ParticipantType participant_type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getParticipantType()
    {
        return $this->participant_type;
    }

    /**
     * Output only. Type of participant in the lead conversation, ADVERTISER or
     * CONSUMER.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v16.enums.LocalServicesParticipantTypeEnum.ParticipantType participant_type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setParticipantType($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V16\Enums\LocalServicesParticipantTypeEnum\ParticipantType::class);
        $this->participant_type = $var;

        return $this;
    }

    /**
     * Output only. Resource name of Lead associated to the Lead Conversation.
     *
     * Generated from protobuf field <code>string lead = 5 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getLead()
    {
        return $this->lead;
    }

    /**
     * Output only. Resource name of Lead associated to the Lead Conversation.
     *
     * Generated from protobuf field <code>string lead = 5 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setLead($var)
    {
        GPBUtil::checkString($var, True);
        $this->lead = $var;

        return $this;
    }

    /**
     * Output only. The date time at which lead conversation was created by Local
     * Services Ads. The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads
     * account's timezone. Examples: "2018-03-05 09:15:00" or "2018-02-01
     * 14:34:30"
     *
     * Generated from protobuf field <code>string event_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEventDateTime()
    {
        return $this->event_date_time;
    }

    /**
     * Output only. The date time at which lead conversation was created by Local
     * Services Ads. The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads
     * account's timezone. Examples: "2018-03-05 09:15:00" or "2018-02-01
     * 14:34:30"
     *
     * Generated from protobuf field <code>string event_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEventDateTime($var)
    {
        GPBUtil::checkString($var, True);
        $this->event_date_time = $var;

        return $this;
    }

    /**
     * Output only. Details of phone call conversation in case of PHONE_CALL.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v16.resources.PhoneCallDetails phone_call_details = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Ads\GoogleAds\V16\Resources\PhoneCallDetails|null
     */
    public function getPhoneCallDetails()
    {
        return $this->phone_call_details;
    }

    public function hasPhoneCallDetails()
    {
        return isset($this->phone_call_details);
    }

    public function clearPhoneCallDetails()
    {
        unset($this->phone_call_details);
    }

    /**
     * Output only. Details of phone call conversation in case of PHONE_CALL.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v16.resources.PhoneCallDetails phone_call_details = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Ads\GoogleAds\V16\Resources\PhoneCallDetails $var
     * @return $this
     */
    public function setPhoneCallDetails($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V16\Resources\PhoneCallDetails::class);
        $this->phone_call_details = $var;

        return $this;
    }

    /**
     * Output only. Details of message conversation in case of EMAIL, MESSAGE or
     * SMS.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v16.resources.MessageDetails message_details = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Ads\GoogleAds\V16\Resources\MessageDetails|null
     */
    public function getMessageDetails()
    {
        return $this->message_details;
    }

    public function hasMessageDetails()
    {
        return isset($this->message_details);
    }

    public function clearMessageDetails()
    {
        unset($this->message_details);
    }

    /**
     * Output only. Details of message conversation in case of EMAIL, MESSAGE or
     * SMS.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v16.resources.MessageDetails message_details = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Ads\GoogleAds\V16\Resources\MessageDetails $var
     * @return $this
     */
    public function setMessageDetails($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V16\Resources\MessageDetails::class);
        $this->message_details = $var;

        return $this;
    }

}

