<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/ads/googleads/v15/services/audience_insights_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Ads\GoogleAds\V15\Services\Gapic;

use Google\Ads\GoogleAds\V15\Common\LocationInfo;
use Google\Ads\GoogleAds\V15\Services\BasicInsightsAudience;
use Google\Ads\GoogleAds\V15\Services\GenerateAudienceCompositionInsightsRequest;
use Google\Ads\GoogleAds\V15\Services\GenerateAudienceCompositionInsightsResponse;
use Google\Ads\GoogleAds\V15\Services\GenerateInsightsFinderReportRequest;
use Google\Ads\GoogleAds\V15\Services\GenerateInsightsFinderReportResponse;
use Google\Ads\GoogleAds\V15\Services\GenerateSuggestedTargetingInsightsRequest;
use Google\Ads\GoogleAds\V15\Services\GenerateSuggestedTargetingInsightsResponse;
use Google\Ads\GoogleAds\V15\Services\InsightsAudience;
use Google\Ads\GoogleAds\V15\Services\ListAudienceInsightsAttributesRequest;
use Google\Ads\GoogleAds\V15\Services\ListAudienceInsightsAttributesResponse;
use Google\Ads\GoogleAds\V15\Services\ListInsightsEligibleDatesRequest;
use Google\Ads\GoogleAds\V15\Services\ListInsightsEligibleDatesResponse;
use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;

/**
 * Service Description: Audience Insights Service helps users find information about groups of
 * people and how they can be reached with Google Ads. Accessible to
 * allowlisted customers only.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $audienceInsightsServiceClient = new AudienceInsightsServiceClient();
 * try {
 *     $customerId = 'customer_id';
 *     $audience = new InsightsAudience();
 *     $dimensions = [];
 *     $response = $audienceInsightsServiceClient->generateAudienceCompositionInsights($customerId, $audience, $dimensions);
 * } finally {
 *     $audienceInsightsServiceClient->close();
 * }
 * ```
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Ads\GoogleAds\V15\Services\Client\AudienceInsightsServiceClient} to use
 * the new surface.
 */
class AudienceInsightsServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.ads.googleads.v15.services.AudienceInsightsService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'googleads.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/adwords',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/audience_insights_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/audience_insights_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/audience_insights_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/audience_insights_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'googleads.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Returns a collection of attributes that are represented in an audience of
     * interest, with metrics that compare each attribute's share of the audience
     * with its share of a baseline audience.
     *
     * List of thrown errors:
     * [AudienceInsightsError]()
     * [AuthenticationError]()
     * [AuthorizationError]()
     * [FieldError]()
     * [HeaderError]()
     * [InternalError]()
     * [QuotaError]()
     * [RangeError]()
     * [RequestError]()
     *
     * Sample code:
     * ```
     * $audienceInsightsServiceClient = new AudienceInsightsServiceClient();
     * try {
     *     $customerId = 'customer_id';
     *     $audience = new InsightsAudience();
     *     $dimensions = [];
     *     $response = $audienceInsightsServiceClient->generateAudienceCompositionInsights($customerId, $audience, $dimensions);
     * } finally {
     *     $audienceInsightsServiceClient->close();
     * }
     * ```
     *
     * @param string           $customerId   Required. The ID of the customer.
     * @param InsightsAudience $audience     Required. The audience of interest for which insights are being requested.
     * @param int[]            $dimensions   Required. The audience dimensions for which composition insights should be
     *                                       returned.
     *                                       For allowed values, use constants defined on {@see \Google\Ads\GoogleAds\V15\Enums\AudienceInsightsDimensionEnum\AudienceInsightsDimension}
     * @param array            $optionalArgs {
     *     Optional.
     *
     *     @type InsightsAudience $baselineAudience
     *           The baseline audience to which the audience of interest is being
     *           compared.
     *     @type string $dataMonth
     *           The one-month range of historical data to use for insights, in the format
     *           "yyyy-mm". If unset, insights will be returned for the last thirty days of
     *           data.
     *     @type string $customerInsightsGroup
     *           The name of the customer being planned for.  This is a user-defined value.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Ads\GoogleAds\V15\Services\GenerateAudienceCompositionInsightsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function generateAudienceCompositionInsights($customerId, $audience, $dimensions, array $optionalArgs = [])
    {
        $request = new GenerateAudienceCompositionInsightsRequest();
        $requestParamHeaders = [];
        $request->setCustomerId($customerId);
        $request->setAudience($audience);
        $request->setDimensions($dimensions);
        $requestParamHeaders['customer_id'] = $customerId;
        if (isset($optionalArgs['baselineAudience'])) {
            $request->setBaselineAudience($optionalArgs['baselineAudience']);
        }

        if (isset($optionalArgs['dataMonth'])) {
            $request->setDataMonth($optionalArgs['dataMonth']);
        }

        if (isset($optionalArgs['customerInsightsGroup'])) {
            $request->setCustomerInsightsGroup($optionalArgs['customerInsightsGroup']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GenerateAudienceCompositionInsights', GenerateAudienceCompositionInsightsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a saved report that can be viewed in the Insights Finder tool.
     *
     * List of thrown errors:
     * [AuthenticationError]()
     * [AuthorizationError]()
     * [FieldError]()
     * [HeaderError]()
     * [InternalError]()
     * [QuotaError]()
     * [RangeError]()
     * [RequestError]()
     *
     * Sample code:
     * ```
     * $audienceInsightsServiceClient = new AudienceInsightsServiceClient();
     * try {
     *     $customerId = 'customer_id';
     *     $baselineAudience = new BasicInsightsAudience();
     *     $specificAudience = new BasicInsightsAudience();
     *     $response = $audienceInsightsServiceClient->generateInsightsFinderReport($customerId, $baselineAudience, $specificAudience);
     * } finally {
     *     $audienceInsightsServiceClient->close();
     * }
     * ```
     *
     * @param string                $customerId       Required. The ID of the customer.
     * @param BasicInsightsAudience $baselineAudience Required. A baseline audience for this report, typically all people in a
     *                                                region.
     * @param BasicInsightsAudience $specificAudience Required. The specific audience of interest for this report.  The insights
     *                                                in the report will be based on attributes more prevalent in this audience
     *                                                than in the report's baseline audience.
     * @param array                 $optionalArgs     {
     *     Optional.
     *
     *     @type string $customerInsightsGroup
     *           The name of the customer being planned for.  This is a user-defined value.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Ads\GoogleAds\V15\Services\GenerateInsightsFinderReportResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function generateInsightsFinderReport($customerId, $baselineAudience, $specificAudience, array $optionalArgs = [])
    {
        $request = new GenerateInsightsFinderReportRequest();
        $requestParamHeaders = [];
        $request->setCustomerId($customerId);
        $request->setBaselineAudience($baselineAudience);
        $request->setSpecificAudience($specificAudience);
        $requestParamHeaders['customer_id'] = $customerId;
        if (isset($optionalArgs['customerInsightsGroup'])) {
            $request->setCustomerInsightsGroup($optionalArgs['customerInsightsGroup']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GenerateInsightsFinderReport', GenerateInsightsFinderReportResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns a collection of targeting insights (e.g. targetable audiences) that
     * are relevant to the requested audience.
     *
     * List of thrown errors:
     * [AudienceInsightsError]()
     * [AuthenticationError]()
     * [AuthorizationError]()
     * [FieldError]()
     * [HeaderError]()
     * [InternalError]()
     * [QuotaError]()
     * [RangeError]()
     * [RequestError]()
     *
     * Sample code:
     * ```
     * $audienceInsightsServiceClient = new AudienceInsightsServiceClient();
     * try {
     *     $customerId = 'customer_id';
     *     $audience = new InsightsAudience();
     *     $response = $audienceInsightsServiceClient->generateSuggestedTargetingInsights($customerId, $audience);
     * } finally {
     *     $audienceInsightsServiceClient->close();
     * }
     * ```
     *
     * @param string           $customerId   Required. The ID of the customer.
     * @param InsightsAudience $audience     Required. The audience of interest for which insights are being requested.
     * @param array            $optionalArgs {
     *     Optional.
     *
     *     @type InsightsAudience $baselineAudience
     *           Optional. The baseline audience.  The default, if unspecified, is all
     *           people in the same country as the audience of interest.
     *     @type string $dataMonth
     *           Optional. The one-month range of historical data to use for insights, in
     *           the format "yyyy-mm". If unset, insights will be returned for the last
     *           thirty days of data.
     *     @type string $customerInsightsGroup
     *           Optional. The name of the customer being planned for.  This is a
     *           user-defined value.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Ads\GoogleAds\V15\Services\GenerateSuggestedTargetingInsightsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function generateSuggestedTargetingInsights($customerId, $audience, array $optionalArgs = [])
    {
        $request = new GenerateSuggestedTargetingInsightsRequest();
        $requestParamHeaders = [];
        $request->setCustomerId($customerId);
        $request->setAudience($audience);
        $requestParamHeaders['customer_id'] = $customerId;
        if (isset($optionalArgs['baselineAudience'])) {
            $request->setBaselineAudience($optionalArgs['baselineAudience']);
        }

        if (isset($optionalArgs['dataMonth'])) {
            $request->setDataMonth($optionalArgs['dataMonth']);
        }

        if (isset($optionalArgs['customerInsightsGroup'])) {
            $request->setCustomerInsightsGroup($optionalArgs['customerInsightsGroup']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GenerateSuggestedTargetingInsights', GenerateSuggestedTargetingInsightsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Searches for audience attributes that can be used to generate insights.
     *
     * List of thrown errors:
     * [AuthenticationError]()
     * [AuthorizationError]()
     * [FieldError]()
     * [HeaderError]()
     * [InternalError]()
     * [QuotaError]()
     * [RangeError]()
     * [RequestError]()
     *
     * Sample code:
     * ```
     * $audienceInsightsServiceClient = new AudienceInsightsServiceClient();
     * try {
     *     $customerId = 'customer_id';
     *     $dimensions = [];
     *     $queryText = 'query_text';
     *     $response = $audienceInsightsServiceClient->listAudienceInsightsAttributes($customerId, $dimensions, $queryText);
     * } finally {
     *     $audienceInsightsServiceClient->close();
     * }
     * ```
     *
     * @param string $customerId   Required. The ID of the customer.
     * @param int[]  $dimensions   Required. The types of attributes to be returned.
     *                             For allowed values, use constants defined on {@see \Google\Ads\GoogleAds\V15\Enums\AudienceInsightsDimensionEnum\AudienceInsightsDimension}
     * @param string $queryText    Required. A free text query.  If the requested dimensions include
     *                             Attributes CATEGORY or KNOWLEDGE_GRAPH, then the attributes returned for
     *                             those dimensions will match or be related to this string.  For other
     *                             dimensions, this field is ignored and all available attributes are
     *                             returned.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $customerInsightsGroup
     *           The name of the customer being planned for.  This is a user-defined value.
     *     @type LocationInfo[] $locationCountryFilters
     *           If SUB_COUNTRY_LOCATION attributes are one of the requested dimensions and
     *           this field is present, then the SUB_COUNTRY_LOCATION attributes returned
     *           will be located in these countries. If this field is absent, then location
     *           attributes are not filtered by country. Setting this field when
     *           SUB_COUNTRY_LOCATION attributes are not requested will return an error.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Ads\GoogleAds\V15\Services\ListAudienceInsightsAttributesResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAudienceInsightsAttributes($customerId, $dimensions, $queryText, array $optionalArgs = [])
    {
        $request = new ListAudienceInsightsAttributesRequest();
        $requestParamHeaders = [];
        $request->setCustomerId($customerId);
        $request->setDimensions($dimensions);
        $request->setQueryText($queryText);
        $requestParamHeaders['customer_id'] = $customerId;
        if (isset($optionalArgs['customerInsightsGroup'])) {
            $request->setCustomerInsightsGroup($optionalArgs['customerInsightsGroup']);
        }

        if (isset($optionalArgs['locationCountryFilters'])) {
            $request->setLocationCountryFilters($optionalArgs['locationCountryFilters']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ListAudienceInsightsAttributes', ListAudienceInsightsAttributesResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists date ranges for which audience insights data can be requested.
     *
     * List of thrown errors:
     * [AuthenticationError]()
     * [AuthorizationError]()
     * [FieldError]()
     * [HeaderError]()
     * [InternalError]()
     * [QuotaError]()
     * [RangeError]()
     * [RequestError]()
     *
     * Sample code:
     * ```
     * $audienceInsightsServiceClient = new AudienceInsightsServiceClient();
     * try {
     *     $response = $audienceInsightsServiceClient->listInsightsEligibleDates();
     * } finally {
     *     $audienceInsightsServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Ads\GoogleAds\V15\Services\ListInsightsEligibleDatesResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listInsightsEligibleDates(array $optionalArgs = [])
    {
        $request = new ListInsightsEligibleDatesRequest();
        return $this->startCall('ListInsightsEligibleDates', ListInsightsEligibleDatesResponse::class, $optionalArgs, $request)->wait();
    }
}
