/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.ResultSet;
import java.util.ArrayList;
import java.util.Map;

public class ResultSetConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, ResultSet obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "columnNames": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setColumnNames(list);
                    break;
                }
                case "next": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setNext(new ResultSet((JsonObject)member.getValue()));
                    break;
                }
                case "numColumns": {
                    break;
                }
                case "numRows": {
                    break;
                }
                case "output": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    obj.setOutput(((JsonArray)member.getValue()).copy());
                    break;
                }
                case "results": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonArray) {
                            list.add((String)((JsonArray)item).copy());
                        }
                    });
                    obj.setResults(list);
                    break;
                }
                case "rows": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                }
            }
        }
    }

    public static void toJson(ResultSet obj, JsonObject json) {
        ResultSetConverter.toJson(obj, json.getMap());
    }

    public static void toJson(ResultSet obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getColumnNames() != null) {
            array = new JsonArray();
            obj.getColumnNames().forEach(item -> array.add(item));
            json.put("columnNames", array);
        }
        if (obj.getNext() != null) {
            json.put("next", obj.getNext().toJson());
        }
        json.put("numColumns", obj.getNumColumns());
        json.put("numRows", obj.getNumRows());
        if (obj.getOutput() != null) {
            json.put("output", obj.getOutput());
        }
        if (obj.getResults() != null) {
            array = new JsonArray();
            obj.getResults().forEach(item -> array.add(item));
            json.put("results", array);
        }
        if (obj.getRows() != null) {
            array = new JsonArray();
            obj.getRows().forEach(item -> array.add(item));
            json.put("rows", array);
        }
    }
}

