/*
 * Decompiled with CFR 0.152.
 */
package com.izettle.metrics.influxdb;

import com.izettle.metrics.influxdb.InfluxDbBaseSender;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.TimeUnit;

public class InfluxDbTcpSender
extends InfluxDbBaseSender {
    private static final int NUM_OF_RETRIES = 2;
    private static final TimeUnit TCP_TIME_PRECISION = TimeUnit.NANOSECONDS;
    private final String hostname;
    private final int port;
    private final int socketTimeout;
    private Socket tcpSocket;

    public InfluxDbTcpSender(String hostname, int port, int socketTimeout, String database, String measurementPrefix) {
        super(database, TCP_TIME_PRECISION, measurementPrefix);
        this.hostname = hostname;
        this.port = port;
        this.socketTimeout = socketTimeout;
    }

    @Override
    protected int writeData(byte[] line) throws Exception {
        this.retryConnect(false);
        for (int i = 1; i <= 2; ++i) {
            try {
                OutputStream outputStream = this.tcpSocket.getOutputStream();
                outputStream.write(line);
                outputStream.flush();
                return 0;
            }
            catch (IOException e) {
                this.retryConnect(true);
                continue;
            }
        }
        return 0;
    }

    private void retryConnect(boolean force) throws IOException {
        if (force || this.tcpSocket == null) {
            if (this.tcpSocket != null) {
                this.tcpSocket.close();
                this.tcpSocket = null;
            }
            this.tcpSocket = new Socket(this.hostname, this.port);
            this.tcpSocket.setSoTimeout(this.socketTimeout);
        }
    }
}

