/*
 * Decompiled with CFR 0.152.
 */
package com.izettle.metrics.influxdb;

import com.izettle.metrics.influxdb.InfluxDbBaseSender;
import com.izettle.metrics.influxdb.utils.TimeUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;

public class InfluxDbHttpSender
extends InfluxDbBaseSender {
    private final URL url;
    private final String authStringEncoded;
    private final int connectTimeout;
    private final int readTimeout;

    public InfluxDbHttpSender(String protocol, String hostname, int port, String database, String authString, TimeUnit timePrecision, int connectTimeout, int readTimeout, String measurementPrefix) throws Exception {
        super(database, timePrecision, measurementPrefix);
        String endpoint = new URL(protocol, hostname, port, "/write").toString();
        String queryDb = String.format("db=%s", URLEncoder.encode(database, "UTF-8"));
        String queryPrecision = String.format("precision=%s", TimeUtils.toTimePrecision(timePrecision));
        this.url = new URL(endpoint + "?" + queryDb + "&" + queryPrecision);
        this.authStringEncoded = authString != null && !authString.isEmpty() ? Base64.encodeBase64String((byte[])authString.getBytes(UTF_8)) : "";
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Deprecated
    public InfluxDbHttpSender(String protocol, String hostname, int port, String database, String authString, TimeUnit timePrecision) throws Exception {
        this(protocol, hostname, port, database, authString, timePrecision, 1000, 1000, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int writeData(byte[] line) throws Exception {
        HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
        con.setRequestMethod("POST");
        if (this.authStringEncoded != null && !this.authStringEncoded.isEmpty()) {
            con.setRequestProperty("Authorization", "Basic " + this.authStringEncoded);
        }
        con.setDoOutput(true);
        con.setConnectTimeout(this.connectTimeout);
        con.setReadTimeout(this.readTimeout);
        try (OutputStream out = con.getOutputStream();){
            out.write(line);
            out.flush();
        }
        int responseCode = con.getResponseCode();
        if (responseCode / 100 != 2) {
            throw new IOException("Server returned HTTP response code: " + responseCode + " for URL: " + this.url + " with content :'" + con.getResponseMessage() + "'");
        }
        return responseCode;
    }
}

