/*
 * Decompiled with CFR 0.152.
 */
package com.izettle.metrics.influxdb;

import com.izettle.metrics.influxdb.InfluxDbSender;
import com.izettle.metrics.influxdb.data.InfluxDbPoint;
import com.izettle.metrics.influxdb.data.InfluxDbWriteObject;
import com.izettle.metrics.influxdb.utils.InfluxDbWriteObjectSerializer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;

abstract class InfluxDbBaseSender
implements InfluxDbSender {
    static final Charset UTF_8 = StandardCharsets.UTF_8;
    private final InfluxDbWriteObject influxDbWriteObject;
    private final InfluxDbWriteObjectSerializer influxDbWriteObjectSerializer;

    InfluxDbBaseSender(String database, TimeUnit timePrecision, String measurementPrefix) {
        this.influxDbWriteObject = new InfluxDbWriteObject(database, timePrecision);
        this.influxDbWriteObjectSerializer = new InfluxDbWriteObjectSerializer(measurementPrefix);
    }

    @Override
    public void flush() {
        this.influxDbWriteObject.setPoints(new HashSet<InfluxDbPoint>());
    }

    @Override
    public boolean hasSeriesData() {
        return this.influxDbWriteObject.getPoints() != null && !this.influxDbWriteObject.getPoints().isEmpty();
    }

    @Override
    public void appendPoints(InfluxDbPoint point) {
        if (point != null) {
            this.influxDbWriteObject.getPoints().add(point);
        }
    }

    @Override
    public int writeData() throws Exception {
        byte[] line = this.influxDbWriteObjectSerializer.getLineProtocolString(this.influxDbWriteObject).getBytes(UTF_8);
        return this.writeData(line);
    }

    protected abstract int writeData(byte[] var1) throws Exception;

    @Override
    public void setTags(Map<String, String> tags) {
        if (tags != null) {
            this.influxDbWriteObject.setTags(tags);
        }
    }

    @Override
    public Map<String, String> getTags() {
        return this.influxDbWriteObject.getTags();
    }
}

