/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gdpr.util;

import com.iab.gdpr.Bits;
import com.iab.gdpr.VendorConsent;
import com.iab.gdpr.exception.VendorConsentParseException;
import java.util.ArrayList;

@Deprecated
public class ConsentStringParser {
    private Bits bits;

    public ConsentStringParser(byte[] consent) {
        this.bits = new Bits(consent);
    }

    public VendorConsent parse() {
        VendorConsent.Builder builder = new VendorConsent.Builder();
        builder.withVersion(this.bits.getInt(0, 6));
        builder.withConsentRecordCreatedOn(this.bits.getInstantFromEpochDeciseconds(6, 36));
        builder.withConsentRecordLastUpdatedOn(this.bits.getInstantFromEpochDeciseconds(42, 36));
        builder.withCmpID(this.bits.getInt(78, 12));
        builder.withCmpVersion(this.bits.getInt(90, 12));
        builder.withConsentScreenID(this.bits.getInt(102, 6));
        builder.withConsentLanguage(this.bits.getSixBitString(108, 12));
        builder.withVendorListVersion(this.bits.getInt(120, 12));
        ArrayList<Integer> allowedPurposes = new ArrayList<Integer>();
        int ii = 156;
        for (int i = 132; i < ii; ++i) {
            if (!this.bits.getBit(i)) continue;
            allowedPurposes.add(i - 132 + 1);
        }
        builder.withAllowedPurposes(allowedPurposes);
        int maxVendorId = this.bits.getInt(156, 16);
        builder.withMaxVendorId(maxVendorId);
        int vendorEncodingType = this.bits.getInt(172, 1);
        builder.withVendorEncodingType(vendorEncodingType);
        if (vendorEncodingType == 1) {
            builder.withDefaultConsent(this.bits.getBit(173));
            int numEntries = this.bits.getInt(174, 12);
            ArrayList<VendorConsent.RangeEntry> rangeEntries = new ArrayList<VendorConsent.RangeEntry>(numEntries);
            int i = 0;
            int currentOffset = 187;
            while (i < numEntries) {
                boolean range = this.bits.getBit(currentOffset - 1);
                if (range) {
                    int startVendorId = this.bits.getInt(currentOffset, 16);
                    int endVendorId = this.bits.getInt(currentOffset += 16, 16);
                    currentOffset += 16;
                    if (startVendorId > endVendorId || endVendorId > maxVendorId) {
                        throw new VendorConsentParseException("Start VendorId must not be greater than End VendorId and End VendorId must not be greater than Max Vendor Id");
                    }
                    rangeEntries.add(new VendorConsent.RangeEntry(startVendorId, endVendorId));
                } else {
                    int vendorId = this.bits.getInt(currentOffset, 16);
                    currentOffset += 16;
                    if (vendorId > maxVendorId) {
                        throw new VendorConsentParseException("VendorId in the range entries must not be greater than Max VendorId");
                    }
                    rangeEntries.add(new VendorConsent.RangeEntry(vendorId));
                }
                ++i;
                ++currentOffset;
            }
            builder.withRangeEntries(rangeEntries);
        } else {
            ArrayList<Integer> bitField = new ArrayList<Integer>(maxVendorId);
            for (int i = 173; i < 173 + maxVendorId; ++i) {
                if (!this.bits.getBit(i)) continue;
                if (i - 173 + 1 > maxVendorId) {
                    throw new VendorConsentParseException("VendorId provided in the bit field must not be greater than Max VendorId");
                }
                bitField.add(i - 173 + 1);
            }
            builder.withBitField(bitField);
        }
        return builder.build();
    }
}

