/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gdpr.consent.implementation.v1;

import com.iab.gdpr.Bits;
import com.iab.gdpr.Purpose;
import com.iab.gdpr.consent.VendorConsent;
import com.iab.gdpr.consent.implementation.v1.ByteBufferBackedVendorConsent;
import com.iab.gdpr.consent.range.RangeEntry;
import com.iab.gdpr.exception.VendorConsentCreateException;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class VendorConsentBuilder {
    private static final int VERSION = 1;
    private Instant consentRecordCreated;
    private Instant consentRecordLastUpdated;
    private int cmpID;
    private int cmpVersion;
    private int consentScreenID;
    private String consentLanguage;
    private int vendorListVersion;
    private int maxVendorId;
    private int vendorEncodingType;
    private Set<Integer> allowedPurposes = new HashSet<Integer>(24);
    private Set<Integer> vendorsBitField;
    private List<RangeEntry> rangeEntries;
    private boolean defaultConsent;

    public VendorConsentBuilder withConsentRecordCreatedOn(Instant consentRecordCreated) {
        this.consentRecordCreated = consentRecordCreated;
        return this;
    }

    public VendorConsentBuilder withConsentRecordLastUpdatedOn(Instant consentRecordLastUpdated) {
        this.consentRecordLastUpdated = consentRecordLastUpdated;
        return this;
    }

    public VendorConsentBuilder withCmpID(int cmpID) {
        this.cmpID = cmpID;
        return this;
    }

    public VendorConsentBuilder withCmpVersion(int cmpVersion) {
        this.cmpVersion = cmpVersion;
        return this;
    }

    public VendorConsentBuilder withConsentScreenID(int consentScreenID) {
        this.consentScreenID = consentScreenID;
        return this;
    }

    public VendorConsentBuilder withConsentLanguage(String consentLanguage) {
        this.consentLanguage = consentLanguage;
        return this;
    }

    public VendorConsentBuilder withVendorListVersion(int vendorListVersion) {
        this.vendorListVersion = vendorListVersion;
        return this;
    }

    public VendorConsentBuilder withAllowedPurposeIds(Set<Integer> allowedPurposeIds) {
        Objects.requireNonNull(allowedPurposeIds, "Argument allowedPurposeIds is null");
        boolean invalidPurposeIdFound = allowedPurposeIds.stream().anyMatch(purposeId -> purposeId < 0 || purposeId > 24);
        if (invalidPurposeIdFound) {
            throw new IllegalArgumentException("Invalid purpose ID found");
        }
        this.allowedPurposes = allowedPurposeIds;
        return this;
    }

    public VendorConsentBuilder withAllowedPurposes(Set<Purpose> allowedPurposes) {
        Objects.requireNonNull(allowedPurposes, "Argument allowedPurposes is null");
        this.allowedPurposes = allowedPurposes.stream().map(Purpose::getId).collect(Collectors.toSet());
        return this;
    }

    public VendorConsentBuilder withMaxVendorId(int maxVendorId) {
        this.maxVendorId = maxVendorId;
        return this;
    }

    public VendorConsentBuilder withVendorEncodingType(int vendorEncodingType) {
        if (vendorEncodingType < 0 || vendorEncodingType > 1) {
            throw new IllegalArgumentException("Illegal value for argument vendorEncodingType:" + vendorEncodingType);
        }
        this.vendorEncodingType = vendorEncodingType;
        return this;
    }

    public VendorConsentBuilder withBitField(Set<Integer> bitFieldEntries) {
        this.vendorsBitField = bitFieldEntries;
        return this;
    }

    public VendorConsentBuilder withRangeEntries(List<RangeEntry> rangeEntries) {
        this.rangeEntries = rangeEntries;
        return this;
    }

    public VendorConsentBuilder withDefaultConsent(boolean defaultConsent) {
        this.defaultConsent = defaultConsent;
        return this;
    }

    public VendorConsent build() {
        int i;
        int bitBufferSizeInBits;
        Objects.requireNonNull(this.consentRecordCreated, "consentRecordCreated must be set");
        Objects.requireNonNull(this.consentRecordLastUpdated, "consentRecordLastUpdated must be set");
        Objects.requireNonNull(this.consentLanguage, "consentLanguage must be set");
        if (this.vendorListVersion <= 0) {
            throw new VendorConsentCreateException("Invalid value for vendorListVersion:" + this.vendorListVersion);
        }
        if (this.maxVendorId <= 0) {
            throw new VendorConsentCreateException("Invalid value for maxVendorId:" + this.maxVendorId);
        }
        if (this.vendorEncodingType == 1) {
            Objects.requireNonNull(this.rangeEntries, "Range entries must be set");
            boolean invalidRangeEntriesFound = this.rangeEntries.stream().anyMatch(rangeEntry -> !rangeEntry.valid(this.maxVendorId));
            if (invalidRangeEntriesFound) {
                throw new VendorConsentCreateException("Invalid range entries found");
            }
        }
        if (this.vendorEncodingType == 1) {
            int rangeEntrySectionSize = this.rangeEntries.stream().mapToInt(RangeEntry::size).sum();
            bitBufferSizeInBits = 186 + rangeEntrySectionSize;
        } else {
            bitBufferSizeInBits = 173 + this.maxVendorId;
        }
        boolean bitsFit = bitBufferSizeInBits % 8 == 0;
        Bits bits = new Bits(new byte[bitBufferSizeInBits / 8 + (bitsFit ? 0 : 1)]);
        bits.setInt(0, 6, 1);
        bits.setInstantToEpochDeciseconds(6, 36, this.consentRecordCreated);
        bits.setInstantToEpochDeciseconds(42, 36, this.consentRecordLastUpdated);
        bits.setInt(78, 12, this.cmpID);
        bits.setInt(90, 12, this.cmpVersion);
        bits.setInt(102, 6, this.consentScreenID);
        bits.setSixBitString(108, 12, this.consentLanguage);
        bits.setInt(120, 12, this.vendorListVersion);
        for (i = 0; i < 24; ++i) {
            if (this.allowedPurposes.contains(i + 1)) {
                bits.setBit(132 + i);
                continue;
            }
            bits.unsetBit(132 + i);
        }
        bits.setInt(156, 16, this.maxVendorId);
        bits.setInt(172, 1, this.vendorEncodingType);
        if (this.vendorEncodingType == 1) {
            if (this.defaultConsent) {
                bits.setBit(173);
            } else {
                bits.unsetBit(173);
            }
            bits.setInt(174, 12, this.rangeEntries.size());
            int currentOffset = 186;
            for (RangeEntry rangeEntry2 : this.rangeEntries) {
                currentOffset = rangeEntry2.appendTo(bits, currentOffset);
            }
        } else {
            for (i = 0; i < this.maxVendorId; ++i) {
                if (this.vendorsBitField.contains(i + 1)) {
                    bits.setBit(173 + i);
                    continue;
                }
                bits.unsetBit(173 + i);
            }
        }
        return new ByteBufferBackedVendorConsent(bits);
    }
}

