/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gdpr.consent.implementation.v1;

import com.iab.gdpr.Bits;
import com.iab.gdpr.Purpose;
import com.iab.gdpr.consent.VendorConsent;
import com.iab.gdpr.exception.VendorConsentParseException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ByteBufferBackedVendorConsent
implements VendorConsent {
    private final Bits bits;

    public ByteBufferBackedVendorConsent(Bits bits) {
        this.bits = bits;
    }

    @Override
    public int getVersion() {
        return this.bits.getInt(0, 6);
    }

    @Override
    public Instant getConsentRecordCreated() {
        return this.bits.getInstantFromEpochDeciseconds(6, 36);
    }

    @Override
    public Instant getConsentRecordLastUpdated() {
        return this.bits.getInstantFromEpochDeciseconds(42, 36);
    }

    @Override
    public int getCmpId() {
        return this.bits.getInt(78, 12);
    }

    @Override
    public int getCmpVersion() {
        return this.bits.getInt(90, 12);
    }

    @Override
    public int getConsentScreen() {
        return this.bits.getInt(102, 6);
    }

    @Override
    public String getConsentLanguage() {
        return this.bits.getSixBitString(108, 12);
    }

    @Override
    public int getVendorListVersion() {
        return this.bits.getInt(120, 12);
    }

    @Override
    public Set<Integer> getAllowedPurposeIds() {
        HashSet<Integer> allowedPurposes = new HashSet<Integer>();
        for (int i = 132; i < 156; ++i) {
            if (!this.bits.getBit(i)) continue;
            allowedPurposes.add(i - 132 + 1);
        }
        return allowedPurposes;
    }

    @Override
    public Set<Purpose> getAllowedPurposes() {
        return this.getAllowedPurposeIds().stream().map(Purpose::valueOf).collect(Collectors.toSet());
    }

    @Override
    public int getAllowedPurposesBits() {
        return this.bits.getInt(132, 24);
    }

    @Override
    public int getMaxVendorId() {
        return this.bits.getInt(156, 16);
    }

    @Override
    public boolean isPurposeAllowed(int purposeId) {
        if (purposeId < 1 || purposeId > 24) {
            return false;
        }
        return this.bits.getBit(132 + purposeId - 1);
    }

    @Override
    public boolean isPurposeAllowed(Purpose purpose) {
        return this.isPurposeAllowed(purpose.getId());
    }

    @Override
    public boolean isVendorAllowed(int vendorId) {
        int maxVendorId = this.getMaxVendorId();
        if (vendorId < 0 || vendorId > maxVendorId) {
            return false;
        }
        if (this.encodingType() == 1) {
            boolean defaultConsent = this.bits.getBit(173);
            boolean present = this.isVendorPresentInRange(vendorId);
            return present != defaultConsent;
        }
        return this.bits.getBit(173 + vendorId - 1);
    }

    @Override
    public byte[] toByteArray() {
        return this.bits.toByteArray();
    }

    private int encodingType() {
        return this.bits.getInt(172, 1);
    }

    private boolean isVendorPresentInRange(int vendorId) {
        int numEntries = this.bits.getInt(174, 12);
        int maxVendorId = this.getMaxVendorId();
        int currentOffset = 186;
        for (int i = 0; i < numEntries; ++i) {
            boolean range = this.bits.getBit(currentOffset);
            ++currentOffset;
            if (range) {
                int startVendorId = this.bits.getInt(currentOffset, 16);
                int endVendorId = this.bits.getInt(currentOffset += 16, 16);
                currentOffset += 16;
                if (startVendorId > endVendorId || endVendorId > maxVendorId) {
                    throw new VendorConsentParseException("Start VendorId must not be greater than End VendorId and End VendorId must not be greater than Max Vendor Id");
                }
                if (vendorId < startVendorId || vendorId > endVendorId) continue;
                return true;
            }
            int singleVendorId = this.bits.getInt(currentOffset, 16);
            currentOffset += 16;
            if (singleVendorId > maxVendorId) {
                throw new VendorConsentParseException("VendorId in the range entries must not be greater than Max VendorId");
            }
            if (singleVendorId != vendorId) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteBufferBackedVendorConsent that = (ByteBufferBackedVendorConsent)o;
        return Arrays.equals(this.bits.toByteArray(), that.bits.toByteArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.bits.toByteArray());
    }

    public String toString() {
        return "ByteBufferVendorConsent{Version=" + this.getVersion() + ",Created=" + this.getConsentRecordCreated() + ",LastUpdated=" + this.getConsentRecordLastUpdated() + ",CmpId=" + this.getCmpId() + ",CmpVersion=" + this.getCmpVersion() + ",ConsentScreen=" + this.getConsentScreen() + ",ConsentLanguage=" + this.getConsentLanguage() + ",VendorListVersion=" + this.getVendorListVersion() + ",PurposesAllowed=" + this.getAllowedPurposeIds() + ",MaxVendorId=" + this.getMaxVendorId() + ",EncodingType=" + this.encodingType() + "}";
    }
}

