/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gdpr.consent;

import com.iab.gdpr.Bits;
import com.iab.gdpr.consent.VendorConsent;
import com.iab.gdpr.consent.implementation.v1.ByteBufferBackedVendorConsent;
import java.util.Base64;

public class VendorConsentDecoder {
    private static final Base64.Decoder BASE64_DECODER = Base64.getUrlDecoder();

    public static VendorConsent fromBase64String(String consentString) {
        if (VendorConsentDecoder.isNullOrEmpty(consentString)) {
            throw new IllegalArgumentException("Null or empty consent string passed as an argument");
        }
        return VendorConsentDecoder.fromByteArray(BASE64_DECODER.decode(consentString));
    }

    public static VendorConsent fromByteArray(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("Null or empty consent bytes passed as an argument");
        }
        Bits bits = new Bits(bytes);
        int version = VendorConsentDecoder.getVersion(bits);
        switch (version) {
            case 1: {
                return new ByteBufferBackedVendorConsent(bits);
            }
        }
        throw new IllegalStateException("Unsupported version: " + version);
    }

    private static int getVersion(Bits bits) {
        return bits.getInt(0, 6);
    }

    private static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

