/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gdpr;

import com.iab.gdpr.Bits;
import com.iab.gdpr.exception.GdprException;
import com.iab.gdpr.exception.VendorConsentCreateException;
import com.iab.gdpr.exception.VendorConsentException;
import com.iab.gdpr.exception.VendorConsentParseException;
import com.iab.gdpr.util.ConsentStringParser;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

@Deprecated
public class VendorConsent {
    private static Base64.Decoder decoder = Base64.getUrlDecoder();
    private static Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
    private final Bits bits;
    private final int version;
    private final Instant consentRecordCreated;
    private final Instant consentRecordLastUpdated;
    private final int cmpID;
    private final int cmpVersion;
    private final int consentScreenID;
    private final String consentLanguage;
    private final int vendorListVersion;
    private final int maxVendorId;
    private final int vendorEncodingType;
    private final List<Boolean> allowedPurposes;
    private List<Boolean> bitfield;
    private boolean defaultConsent;
    private List<RangeEntry> rangeEntries;
    private String consentString;
    private List<Integer> integerPurposes;

    private VendorConsent(Builder builder) throws VendorConsentException {
        this.version = builder.version;
        this.consentRecordCreated = builder.consentRecordCreated;
        this.consentRecordLastUpdated = builder.consentRecordLastUpdated;
        this.cmpID = builder.cmpID;
        this.cmpVersion = builder.cmpVersion;
        this.consentScreenID = builder.consentScreenID;
        this.consentLanguage = builder.consentLanguage;
        this.vendorListVersion = builder.vendorListVersion;
        this.maxVendorId = builder.maxVendorId;
        this.vendorEncodingType = builder.vendorEncodingType;
        this.allowedPurposes = builder.allowedPurposes;
        if (this.vendorEncodingType == 1) {
            this.defaultConsent = builder.defaultConsent;
            if (builder.rangeEntries.stream().anyMatch(rangeEntry -> ((RangeEntry)rangeEntry).endVendorId > this.maxVendorId)) {
                throw new VendorConsentCreateException("VendorId in range entry is greater than Max VendorId");
            }
            this.rangeEntries = builder.rangeEntries;
        } else {
            this.bitfield = new ArrayList<Boolean>(this.maxVendorId);
            IntStream.range(0, this.maxVendorId).forEach(i -> this.bitfield.add(false));
            Iterator iterator = builder.vendorsBitField.iterator();
            while (iterator.hasNext()) {
                int vendorId = (Integer)iterator.next();
                if (vendorId > this.maxVendorId || vendorId < 1) {
                    throw new VendorConsentCreateException("VendorId in bit field is greater than Max VendorId or less than 1");
                }
                this.bitfield.set(vendorId - 1, true);
            }
        }
        this.integerPurposes = builder.integerPurposes;
        if (this.vendorEncodingType == 1) {
            int rangeEntrySize = this.rangeEntries.size();
            for (RangeEntry entry : this.rangeEntries) {
                if (entry.endVendorId == entry.startVendorId) {
                    rangeEntrySize += 16;
                    continue;
                }
                rangeEntrySize += 32;
            }
            int bitSize = 186 + rangeEntrySize;
            boolean bitsFit = bitSize % 8 == 0;
            this.bits = new Bits(new byte[bitSize / 8 + (bitsFit ? 0 : 1)]);
        } else {
            int bitSize = 173 + this.maxVendorId;
            boolean bitsFit = bitSize % 8 == 0;
            this.bits = new Bits(new byte[bitSize / 8 + (bitsFit ? 0 : 1)]);
        }
        this.bits.setInt(0, 6, this.version);
        this.bits.setInstantToEpochDeciseconds(6, 36, this.consentRecordCreated);
        this.bits.setInstantToEpochDeciseconds(42, 36, this.consentRecordLastUpdated);
        this.bits.setInt(78, 12, this.cmpID);
        this.bits.setInt(90, 12, this.cmpVersion);
        this.bits.setInt(102, 6, this.consentScreenID);
        this.bits.setSixBitString(108, 12, this.consentLanguage);
        this.bits.setInt(120, 12, this.vendorListVersion);
        int i2 = 0;
        for (boolean purpose : this.allowedPurposes) {
            if (purpose) {
                this.bits.setBit(132 + i2++);
                continue;
            }
            this.bits.unsetBit(132 + i2++);
        }
        this.bits.setInt(156, 16, this.maxVendorId);
        this.bits.setInt(172, 1, this.vendorEncodingType);
        if (this.vendorEncodingType == 1) {
            if (this.defaultConsent) {
                this.bits.setBit(173);
            } else {
                this.bits.unsetBit(173);
            }
            this.bits.setInt(174, 12, this.rangeEntries.size());
            int currentOffset = 186;
            for (RangeEntry entry : this.rangeEntries) {
                if (entry.endVendorId > entry.startVendorId) {
                    this.bits.setBit(currentOffset++);
                    this.bits.setInt(currentOffset, 16, entry.startVendorId);
                    this.bits.setInt(currentOffset += 16, 16, entry.endVendorId);
                    currentOffset += 16;
                    continue;
                }
                this.bits.unsetBit(currentOffset++);
                this.bits.setInt(currentOffset, 16, entry.startVendorId);
                currentOffset += 16;
            }
        } else {
            int bitfieldOffset = 173;
            for (boolean vendorBit : this.bitfield) {
                if (vendorBit) {
                    this.bits.setBit(bitfieldOffset);
                }
                ++bitfieldOffset;
            }
        }
        this.consentString = encoder.encodeToString(this.bits.toByteArray());
    }

    public static VendorConsent fromBase64String(String consentString) throws GdprException {
        try {
            if (VendorConsent.isNullOrEmpty(consentString)) {
                throw new VendorConsentParseException("Consent String is empty or null");
            }
            byte[] consentAsBytes = decoder.decode(consentString);
            ConsentStringParser parser = new ConsentStringParser(consentAsBytes);
            return parser.parse();
        }
        catch (VendorConsentException e) {
            throw new GdprException("Error parsing IAB Consent String", e.getCause());
        }
    }

    public String getConsentString() {
        return this.consentString;
    }

    public Instant getConsentRecordCreated() {
        return this.consentRecordCreated;
    }

    public Instant getConsentRecordLastUpdated() {
        return this.consentRecordLastUpdated;
    }

    public int getVersion() {
        return this.version;
    }

    public int getCmpId() {
        return this.cmpID;
    }

    public int getCmpVersion() {
        return this.cmpVersion;
    }

    public int getConsentScreen() {
        return this.consentScreenID;
    }

    public String getConsentLanguage() {
        return this.consentLanguage;
    }

    public int getMaxVendorId() {
        return this.maxVendorId;
    }

    public boolean isDefaultConsent() {
        return this.defaultConsent;
    }

    public int getVendorEncodingType() {
        return this.vendorEncodingType;
    }

    public List<RangeEntry> getRangeEntries() {
        return this.rangeEntries;
    }

    public List<Boolean> getBitfield() {
        return this.bitfield;
    }

    public String getBinaryString() {
        return this.bits.getBinaryString();
    }

    public List<Integer> getAllowedPurposes() {
        if (this.integerPurposes != null) {
            return this.integerPurposes;
        }
        ArrayList<Integer> purposes = new ArrayList<Integer>();
        int ii = this.allowedPurposes.size();
        for (int i = 1; i <= ii; ++i) {
            if (!this.isPurposeAllowed(i)) continue;
            purposes.add(i);
        }
        this.integerPurposes = purposes;
        return purposes;
    }

    public int getAllowedPurposesBits() {
        return this.bits.getInt(132, 24);
    }

    public int getVendorListVersion() {
        return this.vendorListVersion;
    }

    public boolean isPurposeAllowed(int purposeId) {
        if (purposeId < 1 || purposeId > this.allowedPurposes.size()) {
            return false;
        }
        return this.allowedPurposes.get(purposeId - 1);
    }

    public boolean arePurposesAllowed(List<Integer> purposeIds) {
        boolean allow = true;
        for (int purposeId : purposeIds) {
            allow = allow && this.isPurposeAllowed(purposeId);
        }
        return allow;
    }

    private boolean findVendorIdInRange(int vendorId) {
        for (RangeEntry entry : this.rangeEntries) {
            if (!entry.containsVendorId(vendorId)) continue;
            return true;
        }
        return false;
    }

    public boolean isVendorAllowed(int vendorId) {
        if (this.vendorEncodingType == 1) {
            boolean present = this.findVendorIdInRange(vendorId);
            return present != this.defaultConsent;
        }
        if (vendorId > 0 && vendorId <= this.maxVendorId) {
            return this.bitfield.get(vendorId - 1);
        }
        return false;
    }

    private static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VendorConsent consent = (VendorConsent)o;
        return this.version == consent.version && this.cmpID == consent.cmpID && this.cmpVersion == consent.cmpVersion && this.consentScreenID == consent.consentScreenID && this.vendorListVersion == consent.vendorListVersion && this.maxVendorId == consent.maxVendorId && this.vendorEncodingType == consent.vendorEncodingType && this.defaultConsent == consent.defaultConsent && Objects.equals(this.bits, consent.bits) && Objects.equals(this.consentRecordCreated, consent.consentRecordCreated) && Objects.equals(this.consentRecordLastUpdated, consent.consentRecordLastUpdated) && Objects.equals(this.consentLanguage, consent.consentLanguage) && Objects.equals(this.allowedPurposes, consent.allowedPurposes) && Objects.equals(this.consentString, consent.consentString) && Objects.equals(this.rangeEntries, consent.rangeEntries) && Objects.equals(this.integerPurposes, consent.integerPurposes);
    }

    public int hashCode() {
        return Objects.hash(this.bits, this.version, this.consentRecordCreated, this.consentRecordLastUpdated, this.cmpID, this.cmpVersion, this.consentScreenID, this.consentLanguage, this.vendorListVersion, this.maxVendorId, this.vendorEncodingType, this.allowedPurposes, this.consentString, this.rangeEntries, this.defaultConsent, this.integerPurposes);
    }

    public String toString() {
        return "VendorConsent{bits=" + this.bits + ", version=" + this.version + ", consentRecordCreated=" + this.consentRecordCreated + ", consentRecordLastUpdated=" + this.consentRecordLastUpdated + ", cmpID=" + this.cmpID + ", cmpVersion=" + this.cmpVersion + ", consentScreenID=" + this.consentScreenID + ", consentLanguage='" + this.consentLanguage + '\'' + ", vendorListVersion=" + this.vendorListVersion + ", maxVendorId=" + this.maxVendorId + ", vendorEncodingType=" + this.vendorEncodingType + ", allowedPurposes=" + this.allowedPurposes + ", consentString='" + this.consentString + '\'' + ", rangeEntries=" + this.rangeEntries + ", defaultConsent=" + this.defaultConsent + ", integerPurposes=" + this.integerPurposes + '}';
    }

    public static class Builder {
        private int version;
        private Instant consentRecordCreated;
        private Instant consentRecordLastUpdated;
        private int cmpID;
        private int cmpVersion;
        private int consentScreenID;
        private String consentLanguage;
        private int vendorListVersion;
        private int maxVendorId;
        private int vendorEncodingType;
        private List<Boolean> allowedPurposes = new ArrayList<Boolean>(24);
        private List<Integer> vendorsBitField;
        private List<RangeEntry> rangeEntries;
        private boolean defaultConsent;
        private List<Integer> integerPurposes = null;

        public Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder withConsentRecordCreatedOn(Instant consentRecordCreated) {
            this.consentRecordCreated = consentRecordCreated;
            return this;
        }

        public Builder withConsentRecordLastUpdatedOn(Instant consentRecordLastUpdated) {
            this.consentRecordLastUpdated = consentRecordLastUpdated;
            return this;
        }

        public Builder withCmpID(int cmpID) {
            this.cmpID = cmpID;
            return this;
        }

        public Builder withCmpVersion(int cmpVersion) {
            this.cmpVersion = cmpVersion;
            return this;
        }

        public Builder withConsentScreenID(int consentScreenID) {
            this.consentScreenID = consentScreenID;
            return this;
        }

        public Builder withConsentLanguage(String consentLanguage) {
            this.consentLanguage = consentLanguage;
            return this;
        }

        public Builder withVendorListVersion(int vendorListVersion) {
            this.vendorListVersion = vendorListVersion;
            return this;
        }

        public Builder withAllowedPurposes(List<Integer> allowedPurposes) {
            this.integerPurposes = allowedPurposes;
            for (int i = 0; i < 24; ++i) {
                this.allowedPurposes.add(false);
            }
            for (int purpose : allowedPurposes) {
                this.allowedPurposes.set(purpose - 1, true);
            }
            return this;
        }

        public Builder withMaxVendorId(int maxVendorId) {
            this.maxVendorId = maxVendorId;
            return this;
        }

        public Builder withVendorEncodingType(int vendorEncodingType) {
            this.vendorEncodingType = vendorEncodingType;
            return this;
        }

        public Builder withBitField(List<Integer> bitFieldEntries) {
            this.vendorsBitField = bitFieldEntries;
            return this;
        }

        public Builder withRangeEntries(List<RangeEntry> rangeEntries) {
            this.rangeEntries = rangeEntries;
            return this;
        }

        public Builder withDefaultConsent(boolean defaultConsent) {
            this.defaultConsent = defaultConsent;
            return this;
        }

        public VendorConsent build() {
            return new VendorConsent(this);
        }
    }

    public static class RangeEntry {
        private final int endVendorId;
        private final int startVendorId;

        public RangeEntry(int vendorId) {
            this.endVendorId = this.startVendorId = vendorId;
        }

        public RangeEntry(int startId, int endId) {
            this.endVendorId = endId;
            this.startVendorId = startId;
        }

        public boolean containsVendorId(int vendorId) {
            return vendorId >= this.startVendorId && vendorId <= this.endVendorId;
        }

        public boolean idIsGreaterThanMax(int vendorId) {
            return vendorId > this.endVendorId;
        }

        public boolean isIsLessThanMin(int vendorId) {
            return vendorId < this.startVendorId;
        }

        public String toString() {
            return "RangeEntry{endVendorId=" + this.endVendorId + ", startVendorId=" + this.startVendorId + '}';
        }
    }
}

