/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gdpr;

import com.iab.gdpr.exception.VendorConsentCreateException;
import com.iab.gdpr.exception.VendorConsentException;
import com.iab.gdpr.exception.VendorConsentParseException;
import java.time.Instant;

public class Bits {
    private static final byte[] bytePows = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private final byte[] bytes;

    public Bits(byte[] b) {
        this.bytes = b;
    }

    public boolean getBit(int index) {
        int byteIndex = index / 8;
        byte b = this.bytes[byteIndex];
        int bitExact = index % 8;
        return (b & bytePows[bitExact]) != 0;
    }

    public void setBit(int index) {
        int byteIndex = index / 8;
        int shift = (byteIndex + 1) * 8 - index - 1;
        int n = byteIndex;
        this.bytes[n] = (byte)(this.bytes[n] | 1 << shift);
    }

    public void unsetBit(int index) {
        int byteIndex = index / 8;
        int shift = (byteIndex + 1) * 8 - index - 1;
        int n = byteIndex;
        this.bytes[n] = (byte)(this.bytes[n] & ~(1 << shift));
    }

    public int getInt(int startInclusive, int size) throws VendorConsentException {
        if (size > 32) {
            throw new VendorConsentParseException("can't fit bit range in int " + size);
        }
        int val = 0;
        int sigMask = 1;
        int sigIndex = size - 1;
        for (int i = 0; i < size; ++i) {
            if (this.getBit(startInclusive + i)) {
                val += sigMask << sigIndex;
            }
            --sigIndex;
        }
        return val;
    }

    public void setInt(int startInclusive, int size, int to) throws VendorConsentException {
        if (size > 32 || (long)to > this.maxOfSize(size) || to < 0) {
            throw new VendorConsentCreateException("can't fit integer into bit range of size" + size);
        }
        this.setNumber(startInclusive, size, to);
    }

    public long getLong(int startInclusive, int size) throws VendorConsentException {
        if (size > 64) {
            throw new VendorConsentParseException("can't fit bit range in long: " + size);
        }
        long val = 0L;
        long sigMask = 1L;
        int sigIndex = size - 1;
        for (int i = 0; i < size; ++i) {
            if (this.getBit(startInclusive + i)) {
                val += sigMask << sigIndex;
            }
            --sigIndex;
        }
        return val;
    }

    public void setLong(int startInclusive, int size, long to) throws VendorConsentException {
        if (size > 64 || to > this.maxOfSize(size) || to < 0L) {
            throw new VendorConsentCreateException("can't fit long into bit range of size " + size);
        }
        this.setNumber(startInclusive, size, to);
    }

    public Instant getInstantFromEpochDeciseconds(int startInclusive, int size) throws VendorConsentException {
        long epochDemi = this.getLong(startInclusive, size);
        return Instant.ofEpochMilli(epochDemi * 100L);
    }

    public void setInstantToEpochDeciseconds(int startInclusive, int size, Instant instant) throws VendorConsentException {
        this.setLong(startInclusive, size, instant.toEpochMilli() / 100L);
    }

    public int length() {
        return this.bytes.length * 8;
    }

    public String getSixBitString(int startInclusive, int size) throws VendorConsentException {
        if (size % 6 != 0) {
            throw new VendorConsentParseException("string bit length must be multiple of six: " + size);
        }
        int charNum = size / 6;
        StringBuilder val = new StringBuilder();
        for (int i = 0; i < charNum; ++i) {
            int charCode = this.getInt(startInclusive + i * 6, 6) + 65;
            val.append((char)charCode);
        }
        return val.toString().toUpperCase();
    }

    public void setSixBitString(int startInclusive, int size, String to) throws VendorConsentException {
        if (size % 6 != 0 || size / 6 != to.length()) {
            throw new VendorConsentCreateException("bit array size must be multiple of six and equal to 6 times the size of string");
        }
        char[] values = to.toCharArray();
        for (int i = 0; i < values.length; ++i) {
            int charCode = values[i] - 65;
            this.setInt(startInclusive + i * 6, 6, charCode);
        }
    }

    public String getBinaryString() {
        StringBuilder s = new StringBuilder();
        int size = this.length();
        for (int i = 0; i < size; ++i) {
            if (this.getBit(i)) {
                s.append("1");
                continue;
            }
            s.append("0");
        }
        return s.toString();
    }

    public byte[] toByteArray() {
        return this.bytes;
    }

    private void setNumber(int startInclusive, int size, long to) {
        for (int i = size - 1; i >= 0; --i) {
            int index = startInclusive + i;
            int byteIndex = index / 8;
            int shift = (byteIndex + 1) * 8 - index - 1;
            int n = byteIndex;
            this.bytes[n] = (byte)((long)this.bytes[n] | to % 2L << shift);
            to /= 2L;
        }
    }

    private long maxOfSize(int size) {
        long max = 0L;
        for (int i = 0; i < size; ++i) {
            max = (long)((double)max + Math.pow(2.0, i));
        }
        return max;
    }
}

